#!/bin/bash

echo "Removing exclude from /etc/yum.conf"
sed -i.bak '/exclude=/d' /etc/yum.conf

echo "Removing xen 4.4"
yum remove xen xen-hypervisor xen-libs -y 

echo "Removing xen libvirt"
yum remove libvirt libvirt-client -y

echo "installing xen 4.2"
yum install xen-4.2.5-38.el6.centos.alt xen-hypervisor-4.2.5-38.el6.centos.alt xen-libs-4.2.5-38.el6.centos.alt xen-runtime-4.2.5-38.el6.centos.alt -y

echo "installing libvirt and libguest"
yum install --disablerepo=Xen4CentOS libvirt libguestfs libguestfs-winsupport libguestfs-tools-c  -y

service xend restart

echo "exclude=xen* libvirt libvirt-client" >> /etc/yum.conf

echo "You will need to reboot this machine to take effect of xen tool update"
echo -n "Do you want to reboot now ? [y/N]"
read rebBOOT


if ([ "$rebBOOT" == "Y" ] || [ "$rebBOOT" == "y" ]); then	
	echo "The system is now being RESTARTED"
	reboot -f ;
fi
exit 0
