<?php

//////////////////////////////////////////////////////////////
//===========================================================
// twofactauth_theme.php
//===========================================================
// SOFTACULOUS VIRTUALIZOR
// Version : 1.0
// Inspired by the DESIRE to be the BEST OF ALL
// ----------------------------------------------------------
// Started by: Alons
// Date:       4th September 2017
// Time:       23:00 hrs
// Site:       https://www.virtualizor.com/ (SOFTACULOUS VIRTUALIZOR)
// ----------------------------------------------------------
// Please Read the Terms of use at https://www.virtualizor.com
// ----------------------------------------------------------
//===========================================================
// (c)Softaculous Ltd.
//===========================================================
//////////////////////////////////////////////////////////////

if(!defined('VIRTUALIZOR')){

	die('Hacking Attempt');

}

function twofactauth_theme(){

global $theme, $globals, $kernel, $users, $l, $error, $done, $SESS, $twofactauth;

softheader($l['<title>']);
										
echo page_header(__('Two Factor Authentication'), 'fas fa-users', '', 0, 0, '');

$breadcrummbs = array('dashboard', 'lm_config', 'lms_twofactauth');

echo get_breadcrumb($breadcrummbs);

error_handle($error);

echo '<script language="javascript" type="text/javascript"><!-- // --><![CDATA[

$(document).ready(function(){ 	 	
	$("#twofactauth_passcode").val(""); 	 	
	//$("#otp_email_user").html(); 	 	
	var selected_type = "none"; 	 	
	if(!empty("'.$twofactauth['2fa_type'].'")){ 		
		selected_type = "'.$twofactauth['2fa_type'].'"; 	
	} 

	$("#2fa_type").val(selected_type); 	 	
	// Display the QR Code Always 	
	$("#qrcode").html("<img src=\"'.$twofactauth['qrcode'].'\" />"); 	 	
	// Display the Secret Code Always 	
	$("#secret_key").html("'.$twofactauth['secret_key'].'"); 	
	$("#secret_key_val").val("'.$twofactauth['secret_key'].'"); 	 	
	show_otp_divs(); 
});
	
function reset_otp_key(){
	
	showalert("'.__J('WARNING : If you reset the secret key you will have to update your apps with the new one. Are you sure you want to continue ?').'" ,"3" ,function(confirm){
		if(confirm == false){
			return false;
		}else{
			$.ajax({
				type: "GET",
				url: "'.$globals['index'].'act=twofactauth&api=json&reset_secret_key=1",
				dataType : "json",
				success: function(data){
					$("#secret_key").html(data.twofactauth.secret_key);
					$("#secret_key_val").val(data.twofactauth.secret_key);
					$("#qrcode").html("<img src=\""+data.twofactauth.qrcode+"\" />");
				},
				error: function(data) {
					//alert(data.description);
					return false;
				}
			});
		}
	});
	
	
	
	
	
	return false;
	
}


function show_otp_divs(){
	
	$(".otp_methods_div").css("display", "none");
	
	//alert($("#2fa_type").val())
	var show_div = $("#2fa_type").val()+"_otp_div";
	$("#"+show_div).show();
	if($("#2fa_type").val() != "none"){
		$("#otp_input_div").show();
	}
}

function send_passcode(){
	$("#progress_bar").show();
	
	$.ajax({
		type: "GET",
		url: "'.$globals['index'].'act=twofactauth&api=json&email_passcode=1",
		dataType : "json",
		success: function(data){
			$("#progress_bar").hide();
			
			//alert(data);
			if("done" in data){
				showalert(data.done.msg);
			}
			
			if("error" in data){
				error(data.error);
			}
		},
		error: function(data) {
			$("#progress_bar").hide();
			//alert(data.description);
			return false;
		}
	});
	
	return false;
}

function twoFactAuthForm(){
	
	$("#progress_bar").show();
	
	$.ajax({
		type: "POST",
		url: "'.$globals['index'].'act=twofactauth&api=json",
		data :  $("#twofactauthform").serialize(),
		dataType : "json",
		success: function(data){
			$("#progress_bar").hide();
			//alert(JSON.stringify(data));

			if("done" in data){
				showalert(data.done.msg);
				$("#twofactauthform").trigger("reset");
			}
			
			if("error" in data){
				error(data.error);
			}
		},
		error: function(data) {
			$("#progress_bar").hide();
			//alert(data.description);
			return false;
		}
	});
	
	return false;
}

// ]]></script>';


if($done){
	show_alert(__('The Storage was deleted successfully'));
}

echo '
<div id="form-container" class="card p-2 mx-3">
	<form accept-charset="'.$globals['charset'].'" name="twofactauth" class="form-horizontal" id="twofactauthform" onsubmit="return twoFactAuthForm();">
		<div class="row mx-auto w-100 my-3">
			<div class="col-sm-4">
				<label class="control-label">'.__('Select Preference : ').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Select the Two Factor Authentication type and then enter the code to enable it').'"><i class="fas text-primary fa-info-circle"></i></a></label>
			</div>
			<div class="col-sm-4">
				<select class="custom-select" name="2fa_type" id="2fa_type" onchange="show_otp_divs();">
					<option value="none">'.__('None (Not Recommended !)').'</option>
					<option value="email">'.__('Email OTP').'</option>
					<option value="app">'.__('Enable App (Google authenticator etc..)').'</option>';
				echo '</select>
			</div>	
		</div>

		<div class="row mx-auto w-100 my-3 otp_methods_div" id="email_otp_div" style="display:none;">
			<div class="col-sm-12 p-0">
				<div class="row mx-auto w-100 my-3">
					<div class="col-sm-4">
						<span>'.__('OTP will be sent to :').'&nbsp;&nbsp;&nbsp;<b id="otp_email_user">';if(empty($SESS["uid"])){ echo $globals["soft_email"];}else{ echo $SESS["og_name"];} echo '</b></span>
					</div>
					<div class="col-sm-4">
						<button type="button" class="btn" name="email_passcode_but" id="email_passcode_but" onclick="send_passcode();">'.__('Email Code').'</button>
					</div>
				</div>
			</div>
		</div>
		<div class="row mx-auto w-100 my-3 otp_methods_div" id="app_otp_div" style="display:none;">
			<div class="col-sm-12 p-0">
				<div class="row mx-auto w-100 my-3">
					<div class="col-sm-4">
						'.__('To get the confirmation code you should download two factor authentication app i.e Google Authenticator, Authy etc. <br /> Scan the QR Code or enter the Secret key given below into your two factor authentication app. After that the app will provide you a unique OTP which you have to enter into the text box to enable Two Factor Authentication.').'<br />
						<label class="control-label">'.__('Secret Key : ').'<span id="secret_key"></span></label><br>
						<a href="#" onclick="reset_otp_key();return false;">'.__('Reset Key').'</a>
					</div>
					<div class="col-sm-4">
						<div id="qrcode"></div><br />
					</div>
				</div>
			</div>
		</div>
		<div class="row mx-auto w-100 my-3 otp_methods_div" id="otp_input_div" style="display:none;">
			<div class="col-sm-4 ">
				<label class="control-label">'.__('Confirmation code').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Enter the OTP received in the email or from the App').'"><i class="fas text-primary fa-info-circle"></i></a></label>
			</div>
			<div class="col-sm-4 ">
				<input type="text" name="twofactauth_passcode" maxlength="6" class="form-control" id="twofactauth_passcode" autocomplete="off"/>
			</div>
		</div>

		<center class="my-4">
			<input type="hidden" name="twofactauth_save" value="1" />
			<input type="hidden" name="secret_key" id="secret_key_val" />
			<button class="go_btn" type="submit"  name="twofactauth_submit" id="twofactauth_submit">'.__('Submit').'</button>
		</center>

	</form>
	<div id="progress_bar" style="display:none;">
		<br />
		<center>
			<font id="progress_txt" size="4">'.__('Please wait, Action in Progress.').'</font>
		</center>
		<div class="my-2" align="center">
			<div class="progress w-50">
				<div class="progress-bar bg-primary progress-bar-striped progress-bar-animated w-100">
				</div>
			</div>
		</div>
		<center>
			'.__('You will be notified once the Action is Completed.').'
		</center>
	</div>
';

echo'</div>';

softfooter();

}
