<?php

//////////////////////////////////////////////////////////////
//===========================================================
// servers_theme.php
//===========================================================
// SOFTACULOUS VIRTUALIZOR
// Version : 1.0
// Inspired by the DESIRE to be the BEST OF ALL
// ----------------------------------------------------------
// Started by: Alons
// Date:       8th Mar 2010
// Time:       23:00 hrs
// Site:       https://www.virtualizor.com/ (SOFTACULOUS VIRTUALIZOR)
// ----------------------------------------------------------
// Please Read the Terms of use at https://www.virtualizor.com
// ----------------------------------------------------------
//===========================================================
// (c)Softaculous Ltd.
//===========================================================
//////////////////////////////////////////////////////////////

if(!defined('VIRTUALIZOR')){

	die('Hacking Attempt');

}

function getSortHeader($header_name, $column ,$size = 90){
	
	global $theme, $globals;

		$link = $globals['index'].'act=servers&sortcolumn='.$column;
		$str = '<div class="d-inline-flex align-items-center" style="width:'.$size.'px;">
			<div class="mr-2"> 
				<span class="" >'.$header_name.'</span>
			</div>
			<span class="sorter">
				<i class="fas fa-sort-up" onclick=sort_servers_entry("'.$link.'&orderby=asc"); style="cursor: pointer;" ></i><br>
				<i class="fas fa-sort-down" onclick=sort_servers_entry("'.$link.'&orderby=desc"); style="cursor: pointer;"></i>
			</span>
		</div>';
		
		return $str;
}

function servers_theme(){

global $theme, $globals, $kernel, $user, $l, $cluster, $servers, $servs, $error, $done, $force_delete, $servergroups, $distros, $remove_ha, $delete, $servers_data, $server_cached, $firewall_plans;

softheader($l['<title>']);
					
$buttons = array( 0 => array(
	'name' => __('Add Server'), 
	'act' => 'addserver')
);

echo page_header(__('Servers'), 'icon icon-servers','', 1, 1, $buttons);

$breadcrumbs = array('dashboard', 'lm_servers','lms_servers');

echo get_breadcrumb($breadcrumbs);

error_handle($error);
$serid = json_encode(array_keys($servers));

if(!empty($done)){
	show_alert(__('The slave server has been deleted successfully'));
}

if(!empty($force_delete) && empty($done)){
	echo '<div class="notice"><a href="'.$globals['ind'].'act=servers&force='.$force_delete.'&remove_ha='.(!empty($remove_ha) ? '1' : 0).'"><span class="text-center">'.__('Perform forced unslave ?').'</span></a><br> <span class="text-center">'.__('NOTE: If forced unslave is performed and if the server is in HA cluster, we will try to remove node from HA cluster and no further confirmation will be asked.').'</span></div>';
	return;
}

if(!empty($remove_ha) && empty($done)){
	$link = $globals['ind'].'act=servers&delete='.$delete.'&remove_ha=';
	echo '<div class="notice"><span class="text-center">'.__('HA is enabled for this server. Do you want to remove this server from HA cluster as well?').'</span><center><input type="button" value="'.__('Yes').'" class="link_btn" onclick="window.location =\''.$link.'1\';">&nbsp;&nbsp;<input type="button" value="'.__('No').'" class="link_btn" onclick="window.location =\''.$link.'0\';"></center></div>';
	return;
}

get_fw_plans_by_user([], 1, 1);
	
echo '

<script language="javascript" type="text/javascript"><!-- // --><![CDATA[

function mouse_over(el){
	el.className = "server_over";
	el.onmouseout = function(){el.className="";}
};

function sort_servers_entry(link){

	var server_ip_value = $("#serverip").val();
	var server_name_value = $("#servername").val();
	var p_type_id = $("#ptypeid").val();

	if(!empty(server_ip_value)){
		link += "&serverip="+server_ip_value;
	}
	
	if(!empty(server_name_value)){
		link += "&servername="+server_name_value;
	}

	if(!empty(p_type_id)){
		link += "&ptype="+p_type_id;
	}

	window.location.href = link;
	
}

function conf_del(id){
	showalert("'.__J('Are you sure you want to delete the Slave Server ?').'" ,"3" ,function(confirm){
		if(confirm == false){
			return false;
		}else{
			window.location.href="'.$globals['ind'].'act=servers&delete="+id;
		}
	});
};

function sync_server(id){
	var finalData = new Object();
	finalData["sync_serid"] = id;
	var htm = $("#sync_td_"+id).html();
	$("#sync_td_"+id).html(\'<div class="loader"></div>\');
	$.ajax({
		type: "POST",
		url: "'.$globals['index'].'act=servers&api=json",
		data : finalData,
		dataType : "json",
		success: function(data){
			$("#sync_td_"+id).html(htm);
			if("error" in data){
				errors = "";
				for(x in data["error"]){
					errors = errors + data["error"][x]+ "<br>";
				}
				showalert(errors, 1);
			}else{
				showalert("'.__J('Syncing completed successfully').'");
			}
		}
	});
};

function lockServer(serid ,ele){

	var action = $(ele).parent().prev().find("select").val();
	
	serid = serid || 0;
	
	// List of server ids to lock
	var server_list = new Array();
		
	if($(ele).parent().prev().find("select").val() == 0){
		showalert("'.__J('No action selected !').'","1");
		return false;
	}
	
	$(".ios:checked").each(function() {
		server_list.push($(this).val());
	});
	
	if(server_list.length < 1){
		showalert("'.__J('Nothing selected !').'","1");
		return false;
	}
	
	ServerAlert(action, server_list);

	return false;
};

function ServerAlert(action, server_list){

	var l = Array();
	l["lock_lang"] = "'.__J('Are you sure, you want to lock the selected server(s) ?').'<br />'.__J('Reason').' : <input type=\"text\" class=\"form-control\" id=\"lock_reason\" name=\"reason\">";
	l["unlock_lang"] = "'.__J('Are you sure, you want to unlock the selected server(s) ?').'";
	l["reset_key_lang"] = "'.__J('Are you sure you want to reset the API keys?').'";
	l["update_servers_lang"] = "'.__J('Are you sure you want to update selected servers?').'";
	
	showalert(l[action+"_lang"] ,"3" ,function(confirm){
		if(confirm == false){
			return false;
		}else{
			var finalData = new Object();
			var reason = $("#lock_reason").val();
			finalData[action] = server_list.join(",");
			finalData["reason"] = reason;
			//alert(JSON.stringify(finalData));
			//return false;
			
			$("#progress_bar").show();
			
			$.ajax({
				type: "POST",
				url: "'.$globals['index'].'act=servers&api=json",
				data : finalData,
				dataType : "json",
				success: function(data){
					$("#progress_bar").hide();
					if("done" in data){
						let msg = "'.__J('The action was completed sucessfully').'";
						if("done_msg" in data && !empty(data["done_msg"])){
							msg = data["done_msg"];
						}
						setTimeout(function(){showalert(msg);
						$("#alert-modal").on("hidden.bs.modal", function (e) {
							location.reload(true);
						})} ,200);
					}
					if("error" in data){
						errors = "";
						for(x in data["error"]){
							errors = errors + data["error"][x]+ "<br>";
						}
						showalert(errors, 1);
					}
				},
				error: function(data) {
					$("#progress_bar").hide();
					//alert(data.description);
					return false;
				}
			});
		}
	});

	return false;
};

function show_virt_name(virt){

	let full_name = "";
	let full_name_tt = "";
	switch (virt) {
		case \'kvm\':
			full_name_tt = "KVM";
			break;
		case \'kvm lxc\':
			full_name_tt = "KVM & LXC";
			break;
		case \'openvz\':
			full_name_tt = "Openvz";
			break;
		case \'proxk proxl\':
			full_name_tt = "<span style=\"color:#e57000\">Proxmox</span>";
			break;
		case \'vzk vzo\':
			full_name_tt = "<span style=\"color:#F96666\">Virtuozzo</span>";
			break;
		case \'xcp\':
			full_name_tt = "XCP";
			break;
		case \'xcphvm\':
			full_name_tt = "XCP HVM";
			break;
		case \'xenhvm\':
			full_name_tt = "XEN HVM";
			break;
		case \'xen\':
			full_name_tt = "XEN";
			break;
		case \'lxc\':
			full_name_tt = "LXC";
			break;
		case \'msonly\':
			full_name_tt = "<span style=\"color:#42b355\"> Master Only</span>";
		}
		let ret = \'<span class="font-weight-light text-admin text-nowrap" >\'+full_name_tt+\'</span>\';
		return ret;
}

function sso(serid){
	$.ajax({
		type: "POST",
		url: "'.$globals['index'].'act=servers&sso="+serid+"&api=json",
		dataType : "json",
		success: function(data){
			if(empty(data["fatal_error_text"])){
				window.open("https://"+data["servers"][serid]["ip"]+":4085/"+data["sso_link"]["token_key"]+"/?as="+data["sso_link"]["sid"],"_blank");
			}else{
				showalert(data["fatal_error_text"], 1);
			}
		}
	});
}

// ]]></script>
<div class="card p-2 mx-3">
	<div id="showsearch" class="mb-3" style="display:'.(optREQ('search') || (!empty($servs) && !empty($globals['showsearch'])) ? "" : "none").';">
		<form accept-charset="'.$globals['charset'].'" name="servers" method="GET" action="" class="form-horizontal">
			<input type="hidden" name="act" value="servers">
					
			<div class="form-group_head">
				<div class="row mx-auto w-100">
					<div class="col-sm-4"><label>'.__('Name').'</label><input type="text" class="form-control" name="servername" id="servername" size="30" value="'.REQval('servername', '').'" /></div>
					<div class="col-sm-4"><label>'.__('IP').'</label><input type="text" class="form-control" name="serverip" id="serverip" size="30" value="'.REQval('serverip','').'"/></div>
					<div class="col-sm-4"><label>'.__('Type').'</label>
						<select name="ptype" class="form-control virt-select" id="ptypeid">
							<option value="">All</option>
							<option value="openvz" '.REQselect('ptype', 'openvz').'>Openvz</option>
							<option value="xen" '.REQselect('ptype', 'xen').'>Xen</option>
							<option value="kvm" '.REQselect('ptype', 'kvm').'>KVM</option>
							<option value="xcp" '.REQselect('ptype', 'xcp').'>XCP</option>
							<option value="lxc" '.REQselect('ptype', 'lxc').'>LXC</option>
							<option value="vzo" '.REQselect('ptype', 'vzo').'>Virtuozzo Openvz</option>
							<option value="vzk" '.REQselect('ptype', 'vzk').'>Virtuozzo KVM</option>
							<option value="proxk" '.REQselect('ptype', 'proxk').'>Proxmox KVM</option>
							<option value="proxl" '.REQselect('ptype', 'proxl').'>Proxmox LXC</option>
							<option value="proxo" '.REQselect('ptype', 'proxo').'>Proxmox OpenVZ</option>
							<!--<option value="vmware" '.REQselect('ptype', 'vmware').'>VMWARE ESXi</option>-->
						</select>
					</div>
				</div>
				<div class="row mx-auto w-100 my-2">
					<div class="col-sm-12 text-center"><button type="submit" name="search" class="go_btn mt-2" value="Search"/>'.__('Search').'</button></div>
				</div>
			</div>
		</form>
	</div>

	<div id="show_sorting" class="mb-3" style="display:none;">
		<form accept-charset="'.$globals['charset'].'" name="servers" method="GET" action="" class="form-horizontal">
			<input type="hidden" name="act" value="servers">
			<div class="form-group_head">
				<div class="row mx-auto w-100">
					<div class="col-sm-6"><label>'.__('Sort Column').'</label>
						<select name="sortcolumn" class="form-control virt-select" id="sortingid">
							<option value="">None</option>
							<option value="alloc_ram" '.REQselect('sortcolumn', 'alloc_ram').'>RAM</option>
							<option value="space" '.REQselect('sortcolumn', 'space').'>Storage</option>
							<option value="locked" '.REQselect('sortcolumn', 'locked').'>Locked Server</option>
							<option value="numvps" '.REQselect('sortcolumn', 'numvps').'>Number of VM</option>
						</select>
					</div>
					<div class="col-sm-6"><label>'.__('Order By').'</label>
						<select name="orderby" class="form-control virt-select" id="ascending">
							<option value="asc" '.REQselect('orderby', 'asc').'>Ascending</option>
							<option value="dec" '.REQselect('orderby', 'dec').'>Descending</option>
						</select>
					</div>
				</div>
				<div class="row mx-auto w-100 my-2">
					<div class="col-sm-12 text-center"><button type="submit" class="go_btn mt-2"/>'.__('Sort').'</button></div>
				</div>
			</div>
		</form>
	</div>';

if(!empty($saved)){
	show_alert(__('The slave server has been deleted successfully'));
	echo '<div class="notice"><b>'.__('Note').' : </b> &nbsp; '.__('The slave server has been deleted successfully').'</div>';
}

if(empty($servs)){
	show_alert(__('No results were found for your search query'),"2");
	echo '<div class="notice"><b>'.__('Note').' : </b> &nbsp; '.__('No results were found for your search query').'</div>';
}else{
	echo'<div class="row mx-auto w-100 mb-3">
		<div class="col-sm-8 col-lg-8 col-md-6 d-flex align-items-center p-0">';
		page_links($globals['num_res'], $globals['cur_page'], $globals['reslen']);
		echo get_num_records($globals['num_res']).'
		</div>
		<div class="col-sm-4 col-lg-4 col-md-6 text-right d-flex align-items-center">
			<div class="bottom-menu float-right w-100">
				<div class="row my-auto">
					<div class="p-0">
						<label>'.__('With Selected').'</label>
					</div>
					<div class="col p-0">
						<select name="server_task_select" class="custom-select">
							<option value="0">---</option>
							<option value="lock">'.__('Lock').'</option>
							<option value="unlock">'.__('Unlock').'</option>';
							if(is_master()){
								echo'<option value="reset_key">'.__('Reset API Keys').'</option>';
								echo'<option value="update_servers">'.__('Update Servers').'</option>';
							}
							echo'
						</select>
					</div>
					<div class="pl-2">
						<input type="submit" id ="server_submit" class="go_btn" name="server_submit" value="'.__('GO').'" onclick="lockServer(0 ,this); return false;">
					</div>
				</div>
			</div>
		</div>
	</div>
<form accept-charset="'.$globals['charset'].'" name="multi_server" id="multi_server" method="post" action="" class="w-100 mx-auto sticky">
	<table class="table table-hover tablesorter common-table">
		<tr class="table_heading">
			<th class="z-index-1 min_width">
				'.get_checkbox('select_all', '', 'select_all', array('chk_it' => 0), '', 'select_all').'
			</th>
			<th width="min_width">'.getSortHeader(__('ID'), 'serid' ,25).'</th>
			<th width="min_width">'.__('Type').'</th>
			<th width="min_width">'.__('OS').'</th>
			<th width="min_width">'.getSortHeader(__('Name'), 'server_name' ,25).'</th>
			<th width="min_width">'.getSortHeader(__('IP'), 'ip' ,25).'</th>
			<th width="min_width">'.__('Resources (Free / Total)').'</th>
			<th width="min_width" class="z-index-1 text-center">'.__('Live Usage').'</th>
			<th width="min_width">'.__('Version').'</br> & '.__('Expiry date').'</th>
			<th>'.__('Server Group').'</th>
			<th colspan="6" class="min_width text-right">'.__('Manage').'</th>
		</tr>';
				
		$i = 1;

		foreach($servs as $k => $v){
			
			if(preg_match('/CentOS/is', $v['os'])){
				$servers_ditro = 'centos';
			}elseif(preg_match('/AlmaLinux/is', $v['os'])){
				$servers_ditro = 'almalinux';
			}elseif(preg_match('/Rocky/is', $v['os'])){
				$servers_ditro = 'rocky';
			}elseif(preg_match('/oracle/is', $v['os'])){
				$servers_ditro = 'oracle';
			}elseif(preg_match('/ubuntu/is', $v['os'])){
				$servers_ditro = 'ubuntu';
			}elseif(preg_match('/vmware/is', $v['os'])){
				$servers_ditro = 'vmware';
			}else{
				$servers_ditro = 'others';
			}

			// loading slave settings data for vpslimit
			$server_settings_data = unserialize($v['settings']);

			if(($v['serid'] == 0) && !empty($globals['is_master_only'])){
				$v['virt'] = 'msonly';
			}

			$server_vps_href = "act=vs&vpsid=&vpsname=&vpsip=&vpshostname=&vsstatus=0&vstype=0&speedcap=0&user=&vsgid=-1&vserid=".$v['serid']."&plid=-1&bpid=-1&search=Search";
			$server_storage_href = "act=storage&name=&path=&servers_search=".$v['serid']."&search=Search";
			
			echo '<tr>
			<td width="20" valign="middle" align="center">
				'.get_checkbox('servers_list[]', '', '', array('chk_it' => 0), $v['serid']).'
			</td>
			<td class="pl-2">'.$v['serid'].'</td>
			<td align="center"><script>document.write(show_virt_name("'.$v['virt'].(empty($v['hvm']) ? '' : 'hvm').'"));</script></td>
			<td ><img src="'.distro_logo($servers_ditro,'',1).'" title="'.$v['os'].'" width="35px"/></td>
			<td ><span class="text-admin" id ="server'.$v['serid'].'">'.$v['server_name'].'</span>';
			if(!empty($v['locked'])){

					$tmp_tooltip = $tooltip = '';
					if(is_array($v['locked'])){
						foreach($v['locked']['reason'] as $k1 => $v1){
							$tmp_tooltip .= $v1;
							$tmp_tooltip .= '<br>';
						}
						$tooltip .= 'tooltip="'.$tmp_tooltip.'"';
					}
					
					echo ' &nbsp;<i class="fas fa-lock" id="lock'.$v['serid'].'" '.$tooltip.'></i>';
					unset($tooltip);
				unset($tmp_tooltip);
				
		}

		$firewall_icon_class = 'text-danger';
		$firewall_info_text = __('No firewall plan found');
		if(!empty($v['fwid'])){
			$firewall_icon_class = 'text-success';
			$firewall_info_text = $firewall_plans[$v['fwid']]['fw_plan_name'].' '.__(' Firewall Plan applied');
		}

		echo ' &nbsp;<i class="fas fa-fire-alt font-16 '.$firewall_icon_class.'" tooltip="'.$firewall_info_text.'"></i>';
		echo '</br><span id="uptime_'.$v['serid'].'"></span></td>
		<td><span>'.$v['ip'].'</span></td>
		<td>
				<div class="d-flex">
					<div class="resource_1">
						<div class="d-flex gap-1 align-items-center">
							<div class="w-20px d-flex align-items-center">
								<img src="'.$theme['svg'].'ram.svg" title="'.__('RAM').'"/>
							</div>
							'.size_converter((!empty($v['alloc_ram']) ? $v['alloc_ram'] : '0')).' / '.size_converter($v['total_ram']).'
						</div>
						<div class="d-flex gap-1 align-items-center">
							<div class="w-20px d-flex align-items-center">
								<img src="'.$theme['svg'].'disk.svg" title="'.__('Disk').'"/>
							</div>
							<a href="'.$globals['ind'].$server_storage_href.'">
								'.size_converter((!empty($v['space']) ? $v['space'] : '0'), "GB").' / '.size_converter($v['total_space'], "GB").'
							</a>
						</div>
					</div>
					<div class="divide_line"></div>
					<div class="resource_1">
						<div class="d-flex gap-1 align-items-center">
							<div class="w-20px d-flex align-items-center">
								<img src="'.$theme['svg'].'cpu.svg" title="'.__('CPU').'"/>
							</div>
							'.(!empty($v['vcores']) ? $v['vcores'] : '0').' Cores
						</div>
						<div class="d-flex gap-1 align-items-center">
							<div class="w-20px d-flex align-items-center">
								<img src="'.$theme['svg'].'vms.svg" title="'.VM_SHORT.'"/>
							</div>
							<a href="'.$globals['ind'].$server_vps_href.'">
								'.(!empty($v['numvps']) ? $v['numvps'] : '0').' / '.(!empty($server_settings_data['vpslimit']) ? $server_settings_data['vpslimit'] : '<i class="fas fa-infinity"></i>').' '.VM_SHORT.'(s)
							</a>
						</div>
					</div>
				</div>

			</td>
			<td>
				<div class="d-flex align-items-center justify-content-center" align="center">
						<div class="p-1">
							<small class="pl-1">CPU</small>
							<div align="center" id="cpu_graph_'.$v['serid'].'" ></div>
							<small class="pl-1" id="cpu_per_'.$v['serid'].'">--%</small>
							</div>
						<div class="p-1">
							<small class="pl-1">RAM</small>
							<div align="center" id="ram_graph_'.$v['serid'].'"></div>
							<small class="pl-1" id="ram_per_'.$v['serid'].'">--%</small>
							</div>
						<div class="p-1">
							<small class="pl-1">DISK</small>
							<div align="center" id="disk_graph_'.$v['serid'].'"></div>
							<small class="pl-1" id="disk_per_'.$v['serid'].'">--%</small>
						</div>
						<div class="p-1">
							<small class="pl-1">IO</small>
							<div align="center" id="io_graph_'.$v['serid'].'"></div>
							<small class="pl-1" id="io_per_'.$v['serid'].'">--%</small>
						</div>
				</div>
			</td>
			<td>
				<big><span class="text-admin">'.$v['version'].' ('.$v['patch'].')</span></big></br>'.$v['lic_expires'].'
			</td>
			<td >
				'.$servergroups[$v['sgid']]['sg_name'].'
			</td>
			<td align="center">
				<div class="badge_container">
					<div class="btn-group dropleft ml-2">
						<button class="badge badge-white" id="server_options" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"><i class="fas fa-ellipsis-v"></i>
						</button>
						<div id="server_options_menu" class="dropdown-menu" aria-labelledby="server_options">
							<div class="dropdown-header d-flex justify-content-center">Server Options</div>';
							if(empty($globals['disable_terminal_access'])){
								echo '<a class="dropdown-item" href="'.$globals['ind'].'act=terminal&serid='.$k.'&auto_redirect=1" target="_blank"><i class="fas fa-terminal mr-2"></i>Terminal</a>';
							}
							echo '
								<a class="dropdown-item" href="'.$globals['ind'].'act=manageserver&changeserid='.$k.'" ><i class="fas fa-tools mr-2"></i>'.__('Manage Server').'</a>
								<a class="dropdown-item" href="'.$globals['ind'].'act=editserver&serid='.$k.'"><i class="fas fa-pencil-alt mr-2"></i>'.__('Edit Server').'</a>';
							if(!empty($k)){
								echo '<a id="sync_td_'.$k.'" class="dropdown-item" href="javascript:void(0)" title = "Sync" onclick="sync_server(\''.$k.'\');"><i class="fas h6 m-0 fa-sync-alt mr-2"></i>'.__('Sync Server').'</a>';
							}
							if(!empty($k)){
								echo '<a class="dropdown-item" href="javascript:void(0)" onclick="sso(\''.$k.'\');"><i class="fas fa-sign-in-alt mr-2"></i>'.__('Single Sign On').'</a>';
							}
							if(!empty($k)){
								echo '<a class="dropdown-item trash" href="javascript:void(0)" onclick="conf_del(\''.$k.'\');"><i class="fas fa-trash mr-2"></i>'.__('Delete Server').'</a>';
							}
							echo '
						</div>
					</div>
				</div>
			</td>
			</tr>';
			$i++;
		}
		
		echo 
	'</table>
';
	echo'<div class="row mx-auto w-100 mt-1">
	<div class="col-sm-8 col-lg-8 col-md-6 mb-3 p-0">';
		page_links($globals['num_res'], $globals['cur_page'], $globals['reslen']);
	echo'
	</div>
	<div class="col-sm-4 col-lg-4 col-md-6 text-right mb-3">
		<div class="bottom-menu float-right w-100">
            <div class="row my-auto">
                <div class="p-0">
                    <label>'.__('With Selected').'</label>
                </div>
                <div class="col p-0">
					<select name="server_task_select" class="custom-select">
						<option value="0">---</option>
						<option value="lock">'.__('Lock').'</option>
						<option value="unlock">'.__('Unlock').'</option>';
						if(is_master()){
							echo'<option value="reset_key">'.__('Reset API Keys').'</option>';
							echo'<option value="update_servers">'.__('Update Servers').'</option>';
						}
						echo'
					</select>
                </div>
                <div class="pl-2">
					<input type="submit" id ="server_submit" class="go_btn" name="server_submit" value="'.__('GO').'" onclick="lockServer(0 ,this); return false;">
                </div>
            </div>
		</div>
	</div>
</div>
</form>
<script>
//TODO Convert this into fixed array
$(document).ready(function() {

	function chart(data, io = 0){

		let temp_labels = ["Used", "Free"];
		let temp_colors = ["#008FFB", "#00E396"];

		// if there is io for render chart then we pass other labels also
		if(io == 1){
			temp_labels = ["User", "Nice", "System", "Iowait", "Steal", "Ideal" ];
			temp_colors = ["#00E396", "#F76775", "#6F58FF", "#008FFB", "#46C9B8"];
		}

		var options = {
			series: data,
			chart: {
				type: "donut",
				animations: {
					enabled: true,
					easing: "easeinout",
					speed: 1000
				},
				height:75,
				width:50
			},
			labels: temp_labels,
			legend: {
				show: false 
			},
			dataLabels: {
				enabled: false
			},
			plotOptions: {
				pie: {
					donut: {
						size: "55%"
					},
					expandOnClick: true,
				}
			},
			tooltip: {
				enabled: true,
				y: {
					formatter: function(val) {
						return val.toFixed(2) + "%";
					}
				}
			},
			
			colors: temp_colors,
		};
		
		return options;
	}

	function loadserverdetails(){
		
		var serid = JSON.parse(\''.$serid.'\');

		let cpu_graph_objects = {};
		let ram_graph_objects = {};
		let disk_graph_objects = {};
		let iowait_graph_objects = {};

		serid.forEach(function(item){
			let cpu_graph = "cpu_graph_" + item;
			let ram_graph = "ram_graph_" + item;
			let disk_graph = "disk_graph_" + item;
			let iowait_graph = "io_graph_" + item;

			cpu_graph_objects[item] = live_resource_graph2("", cpu_graph, chart([0,100])); 
			ram_graph_objects[item] = live_resource_graph2("", ram_graph, chart([0,100])); 
			disk_graph_objects[item] = live_resource_graph2("", disk_graph, chart([0,100])); 
			iowait_graph_objects[item] = live_resource_graph2("", iowait_graph, chart([100, 0, 0, 0, 0, 0], 1));
		});

		function get_live_data(){
			url = new URL(window.location);
			$.ajax({
				type: "POST",
				url: url.href+"&server_update=true&api=json",
				dataType : "json",
				success: function(data){
					$.each(data.servers_data, function(i, t){
						if(t != null){
							cpu_val = [t.cpu.percent,t.cpu.percent_free];
							ram_val = [t.ram.percent,t.ram.percent_free];						
							disk_val = [t.disk.percent,t.disk.percent_free];

							//CPU
							update_cpu_option_and_data = {
								series: cpu_val,
							};
							cpu_graph_objects[i] = live_resource_graph2(cpu_graph_objects[i], "",{},{},update_cpu_option_and_data);
							$("#cpu_per_"+i).html(t.cpu.percent.toFixed()+"%");

							//RAM
							update_ram_option_and_data = {
								series: ram_val,
							};
							ram_graph_objects[i] = live_resource_graph2(ram_graph_objects[i], "",{},{},update_ram_option_and_data);
							$("#ram_per_"+i).html(t.ram.percent.toFixed()+"%");
							
							//DISK
							update_disk_option_and_data = {
								series: disk_val,
							};
							disk_graph_objects[i] = live_resource_graph2(disk_graph_objects[i], "",{},{},update_disk_option_and_data);
							$("#disk_per_"+i).html(t.disk.percent.toFixed()+"%");

							if(!empty(t.io)){
								iowait_val = [t.io.avg_cpu.user,t.io.avg_cpu.nice,t.io.avg_cpu.steal,t.io.avg_cpu.iowait,t.io.avg_cpu.system,t.io.avg_cpu.idle];
								
								//IO
								update_iowait_option_and_data = {
									series: iowait_val,
								};
								iowait_graph_objects[i] = live_resource_graph2(iowait_graph_objects[i], "",{},{},update_iowait_option_and_data);
								$("#io_per_"+i).html((100 - t.io.avg_cpu.idle).toFixed()+"%");
							}

						}else{
							show_toast("'.__J('Unable to connect to the server').'", "'.__J('Failed to connect to Server ID: ').'"+i, 3);
						}

					});
				},
				error: function(data) {
					return false;
				}
			});

			setTimeout(function(){
				get_live_data();
			}, 30000);

		};
		
		get_live_data();
	}
	
	loadserverdetails();

});
</script>
<div id="progress_bar" style="display:none;">
	<br />
	<center>
		<font id="progress_txt" size="4">'.__('Please wait, Action in Progress.').'</font>
	</center>
	<div class="my-2" align="center">
		<div class="progress w-50">
			<div class="progress-bar bg-primary progress-bar-striped progress-bar-animated w-100">
			</div>
		</div>
	</div>
	<center>
		'.__('You will be notified once the Action is Completed.').'
	</center>
</div>';

}
echo '<br>
<div class="text-center my-4">
	<a href="index.php?act=addserver" class="go_btn">'.__('Add Server').'</a>
</div></div>';

softfooter();

}

?>