<?php

//////////////////////////////////////////////////////////////
//===========================================================
// server_stats_theme.php
//===========================================================
// SOFTACULOUS VIRTUALIZOR
// Version : 1.0
// Inspired by the DESIRE to be the BEST OF ALL
// ----------------------------------------------------------
// Started by: Alons
// Date:       8th Mar 2010
// Time:       23:00 hrs
// Site:       https://www.virtualizor.com/ (SOFTACULOUS VIRTUALIZOR)
// ----------------------------------------------------------
// Please Read the Terms of use at https://www.virtualizor.com
// ----------------------------------------------------------
//===========================================================
// (c)Softaculous Ltd.
//===========================================================
//////////////////////////////////////////////////////////////

if(!defined('VIRTUALIZOR')){

	die('Hacking Attempt');

}

function server_stats_theme(){

global $theme, $globals, $ckernel, $user, $l, $server_stats, $month, $servers;

softheader($l['<title>']);
					
$monthly_data = json_encode($server_stats);
$month = json_encode($month);

echo '<style>
.tickLabel{
width:30px !important;
}
</style>
<script language="javascript" type="text/javascript"><!-- // --><![CDATA[

function graph_display(id){

	var res= id.split("_");

	if($(\'#\'+res[1]+\'_body\').is(\':visible\')){

		$(\'#\'+res[1]+\'_sign\').html(\'+\');
		$(\'#\'+res[1]+\'_body\').slideUp("fast");

	}else{

		$(\'#\'+res[1]+\'_sign\').html(\'-\');
		$(\'#\'+res[1]+\'_body\').slideDown("fast");

	}
}

//Show monthly graph
function show_monthly_graph(monthly_data, month){

	$("#note_box").css("display", "none");

	if(!empty(monthly_data)){

		var cpu_data = new Array();
		var inode_data = new Array();
		var ram_data = new Array();
		var disk_data = new Array();
		var ntw_in_data = new Array();
		var ntw_out_data = new Array();
		var ntw_total_data = new Array();
		var avg_download = 0;
		var avg_upload = 0;
		var count = 0;

		$.each(monthly_data,function(key,val){

			//Array is in format [vpsid, time, status, disk, inode, ram, cpu, actual_cpu, net_in, net_out]
			cpu_data.push([val[1] * 1000, val[6]]);

			inode_data.push([val[1] * 1000, val[4]]);

			ram_data.push([val[1] * 1000, val[5]]);

			disk_data.push([val[1] * 1000, (val[3]/1024)]);

			ntw_in_data.push([val[1] * 1000, val[8]]);

			ntw_out_data.push([val[1] * 1000, val[9]]);

			ntw_total_data.push([val[1] * 1000, parseInt(val[8]) + parseInt(val[9])]);

			avg_download += parseInt(val.net_in);
			avg_upload += parseInt(val.net_out);
			count++;
		});

		//cpu_data.sort(function(a,b){return a-b});
		cpu_data.sort(function(a, b){
			return a[0]-b[0];
		});

		var ntw_graph = [
			{ name: "'.__J('Download Speed').'",  data: ntw_in_data, color: "#0077FF"},
			{ name: "'.__J('Upload Speed').'",  data: ntw_out_data, color: "#7D0096"},
			{ name: "'.__J('Total Speed').'",  data: ntw_total_data},
		];
			
		var cpuoptions = {
			chart: {
				type: "area",
				stacked: false
			},
			xaxis:{
				stepSize: 2,
				type: "datetime",
			},
			yaxis: {
				labels: {
					formatter: function (value) {
						return Math.round(value) + "%"; // Round the value and append a percentage sign
					}
				},
				stepSize: 1					
			},
			dataLabels: {
				enabled: false
			},
			colors: ["#515DBC"], 
			title: {
				text: "CPU UTILIZATION",
					style: {
						color: "#FF1654"
					}
			},
			series: [
				{
					name: "CPU Utilized",
					data: cpu_data,
					color: "#515DBC",
					fill: {
						type: "gradient",
						gradient: {
						shade: "light",
						type: "vertical",
						shadeIntensity: 1,
						gradientToColors: ["#515DBC"],
						opacityFrom: 0.4,
						opacityTo: 0.1,
						stops: [0, 100]
						}
					}
				}
			],
			stroke: {
				width: [2, 1], 
				curve: "straight" 
			}, 
			legend: {
				horizontalAlign: "left",
				offsetX: 40
			},
			tooltip:{
				x: {
					format: "dd MMM yyyy HH:mm:ss"  
				}
			} 
		};
				
		var ramoptions = {
			chart: {
				type: "area",
				stacked: false
			},
			stroke: {
				width: 2, 
				curve: "smooth" 
			}, 
			xaxis:{
				stepSize: 2,
				type: "datetime",
			},
			yaxis: {
				stepSize: 1,
				labels: {
					formatter: function (value) {
							return Math.round(value / 1024) + " GB"; // Convert MB to GB and round to nearest whole number
					}
				}
			},
			dataLabels: {
				enabled: false
			},
			colors: ["#515DBC"], 
			title: {
				text: "RAM UTILIZATION",
					style: {
						color: "#FF1654"
					}
			},
			series: [
				{
					name: "RAM UTITLIZED",
					data: ram_data,
					color: "#E52B50",
					fill: {
						type: "gradient",
						gradient: {
						shade: "light",
						type: "vertical",
						shadeIntensity: 1,
						gradientToColors: ["#E52B50"],
						opacityFrom: 0.4,
						opacityTo: 0.1,
						stops: [0, 100]
						}
					}
				}
			],
			stroke: {
				width: [2, 1], 
				curve: "straight" 
			}, 
			legend: {
				horizontalAlign: "left",
				offsetX: 40
			},
			tooltip:{
				x: {
					format: "dd MMM yyyy HH:mm:ss"  
				},
				y: {
					formatter: function (value) {
						return (value / 1024).toFixed(2) + " GB"; // Tooltip still shows with 2 decimal places
					}
				},
			} 
		};

		var diskoptions = {
			chart: {
				type: "area",
				stacked: false
			},
			stroke: {
				width: 2, 
				curve: "smooth" 
			}, 
			xaxis:{
				stepSize: 2,
				type: "datetime",
			},
			yaxis: {
				stepSize: 1,
				labels: {
					formatter: function (value) {
						return value.toFixed(2) + " GB"; // Format with 2 decimals and add GB
					}
				}
			},
			dataLabels: {
				enabled: false
			},
			colors: ["#515DBC"], 
			title: {
				text: "DISK UTILIZATION",
					style: {
						color: "#FF1654"
					}
			},
			series: [
				{
					name: "DISK UTITLIZED",
					data: disk_data,
					color: "#FFA500",
					fill: {
						type: "gradient",
						gradient: {
						shade: "light",
						type: "vertical",
						shadeIntensity: 1,
						gradientToColors: ["#FFA500"],
						opacityFrom: 0.4,
						opacityTo: 0.1,
						stops: [0, 100]
						}
					}
				}
			],
			stroke: {
				width: [2, 1], 
				curve: "straight" 
			}, 
			legend: {
				horizontalAlign: "left",
				offsetX: 40
			},
			tooltip:{
				x: {
					format: "dd MMM yyyy HH:mm:ss"  
				},
				y:{
					formatter: function (value) {
						return value.toFixed(2) + " GB"; // Also format tooltip values
					}
				}	
			} 
		};

		var inodeoptions = {
			chart: {
				type: "area",
				stacked: false
			},
			stroke: {
				width: 2, 
				curve: "smooth" 
			}, 
			xaxis:{
				stepSize: 2,
				type: "datetime",
			},
			yaxis: {
				stepSize: 1,
			},
			dataLabels: {
				enabled: false
			},
			colors: ["#515DBC"], 
			title: {
				text: "INODE",
					style: {
						color: "#FF1654"
					}
			},
			series: [
				{
					name: "Inode",
					data: inode_data,
					color: "#11E19D",
					fill: {
						type: "gradient",
						gradient: {
						shade: "light",
						type: "vertical",
						shadeIntensity: 1,
						gradientToColors: ["#11E19D"],
						opacityFrom: 0.4,
						opacityTo: 0.1,
						stops: [0, 100]
						}
					}
				}
			],
			legend: {
				horizontalAlign: "left",
				offsetX: 40
			},
			tooltip:{
				x: {
					format: "dd MMM yyyy HH:mm:ss"  
				}
			} 
		};

		var ntwoptions = {
			chart: {
				type: "area",
				stacked: false
			},
			stroke: {
				width: 1, 
				curve: "smooth" 
			}, 
			xaxis:{
				stepSize: 2,
				type: "datetime",
			},
			yaxis: {
				labels: {
					formatter: function(val){
						if(val >= 1024 && parseInt(val/1024) < 1024){
							return Math.round(val / 1024) + " MB/s";
						}else if(parseInt(val/1024) >= 1024){
							return Math.round(val / 1024 /1024) + " GB/s";
						}else{
							return Math.round(val) + " KB/s";
						}
					}
				}
			},		
			dataLabels: {
				enabled: false
			},
			colors : ["#FDC046", "#FE8F4D", "#E60C8D"],
			series: ntw_graph,
			legend: {
				horizontalAlign: "left",
				offsetX: 40,
				position: "top"
			},
			tooltip:{
				x: {
					format: "dd MMM yyyy HH:mm:ss"  
				},
			} 
		};

		document.getElementById("cpu").innerHTML = "";
		document.getElementById("ram").innerHTML = "";
		document.getElementById("disk").innerHTML = "";
		document.getElementById("inodes").innerHTML = "";
		document.getElementById("ntw").innerHTML = "";

		var cpuchart = new ApexCharts(document.querySelector("#cpu"), cpuoptions);
		var ramchart = new ApexCharts(document.querySelector("#ram"), ramoptions);
		var diskchart = new ApexCharts(document.querySelector("#disk"), diskoptions);
		var inodechart = new ApexCharts(document.querySelector("#inodes"), inodeoptions);
		var ntwchart = new ApexCharts(document.querySelector("#ntw"), ntwoptions);

		ramchart.render();
		cpuchart.render();
		diskchart.render();
		inodechart.render();
		ntwchart.render();

		$("#data_div").css("display", "block");

	}else{
		$("#note_box").css("display", "block");
		showalert("<b>'.__J('Note').' : </b>&nbsp; '.__J('No data Available').'","2");
	}

	var current_year = month.current_month.substring(0,4);
	var current_month = parseInt(month.current_month.substring(4));
	var monthNames = ["'.__J('Jan').'", "'.__J('Feb').'", "'.__J('Mar').'", "'.__J('Apr').'", "'.__J('May').'", "'.__J('Jun').'", "'.__J('Jul').'", "'.__J('Aug').'", "'.__J('Sep').'", "'.__J('Oct').'", "'.__J('Nov').'", "'.__J('Dec').'" ];
	
	var d = new Date();
	cur_month = d.getMonth(); //get current month

	var _month = parseInt(month.current_month.substring(5))-1; //get month from virtualizor
	if(cur_month == _month){
		$("#next_month").css("display","none");
	}
	
	$("#month_holder2").html(monthNames[current_month - 1] +" "+ current_year);
	$("#next_month").html(\'<a id="next_stats" class="btn btn-primary" href="'.$globals['index'].'act=server_stats&show=\'+ month.next_month +\'">'.__J('Next Month').'</a>\');
	$("#prev_month").html(\'<a id="prev_stats" class="btn btn-primary" href="'.$globals['index'].'act=server_stats&show=\'+ month.prev_month +\'">'.__J('Prev Month').'</a>\');

}

$(document).ready(function() {
	$(".legend_container").next("div").css("width", $( window ).width() - 250);
	show_monthly_graph('.$monthly_data.', '.$month.');
});

</script>';

echo page_header(__('Node Performance'), 'fas fa-chart-bar');
echo 
	'<div class="card p-4 m-3">';
	server_select();
	echo'
		<div class="row w-100 mx-auto my-3" id="note_box">
			<div class="col-sm-12">
				<div class="notice" style="display:none;"><b>NOTE : </b>&nbsp; '.__('No data Available').'</div>
			</div>
		</div>
		<div class="form-group row w-100 mx-auto my-3" id="per_month_display">
			<div id="prev_month" class="col-4 text-right"></div>
			<div id="month_holder2" class="col-4 text-center h4 p-0 m-0"></div>
			<div id="next_month" class="col-4 text-left"></div>
		</div> 
	</div>

	<div id="data_div" style="display:none;" class="card p-4 m-3">
		<div class="row w-100 mx-auto">
			<div class="col-sm-12 p-0">
				<div id="flip_cpu" class="roundheader cursor-pointer " onclick="graph_display(this.id)">
					<label id="cpu_sign">-</label>
					<label>'.__('CPU Utilization').'</label>
				</div>
				<center>
					<div id="cpu_body" class="box_shadow row w-100 p-2 bgaddv card">
						<div class="legend_container mb-3 row mx-auto w-100" id="legend_cpu"></div>
						<div id="cpu" class="w-75" style="margin:auto; height:300px; padding:6px;"></div>
					</div>
				</center><br />
				<div id="flip_ram" class="roundheader cursor-pointer"  onclick="graph_display(this.id)">
					<label id="ram_sign">-</label>
					<label>'.__('Ram').'</label>
				</div>
				<center>
					<div id="ram_body" class="box_shadow row w-100 p-2 bgaddv card">
						<div class="legend_container mb-3 row mx-auto w-100" id="legend_ram"></div>
						<div id="ram" class="w-75"  style="margin:auto; height:300px; padding:6px;"></div>
					</div>
				</center><br/>
				<div id="flip_disk" class="roundheader cursor-pointer"  onclick="graph_display(this.id)">
					<label id="disk_sign">-</label>
					<label>'.__('Disk / Inodes').'</label>
				</div>
				<center>					
					<div id="disk_body" class="box_shadow row w-100 p-2 bgaddv card">
						<div class="row mx-auto w-100">
							<div class="legend_container mb-3 row mx-auto w-100" id="legend_disk"></div>
							<div id="disk" class="w-75"  style="margin:auto; height:300px; padding:6px;"></div>
						</div>
						<div class="row mx-auto w-100">
							<div class="legend_container mb-3 row mx-auto w-100" id="legend_inodes"></div>
							<div id="inodes" class="w-75" style="margin:auto; height:300px; padding:6px;"></div>
						</div>
					</div>
				</center><br />
				<div id="flip_ntw" class="roundheader" cursor-pointer  onclick="graph_display(this.id)">
					<label id="ntw_sign">-</label>
					<label >'.__('Network Speed').'</label>
				</div>
				<center>
					<div id="ntw_body" class="box_shadow row w-100 p-2 bgaddv card">
						<div class="legend_container mb-3 row mx-auto w-100" id="legend_ntw"></div>
						<div id="ntw" class="w-75"  style="margin:auto; height:300px; padding:6px;"></div>
					</div>
				</center>
			</div>
		</div>
	</div><br>';

softfooter();

}

