<?php

//////////////////////////////////////////////////////////////
//===========================================================
// performance_theme.php
//===========================================================
// SOFTACULOUS VIRTUALIZOR
// Version : 1.0
// Inspired by the DESIRE to be the BEST OF ALL
// ----------------------------------------------------------
// Started by: Alons
// Date:       8th Mar 2010
// Time:       23:00 hrs
// Site:       https://www.virtualizor.com/ (SOFTACULOUS VIRTUALIZOR)
// ----------------------------------------------------------
// Please Read the Terms of use at https://www.virtualizor.com
// ----------------------------------------------------------
//===========================================================
// (c)Softaculous Ltd.
//===========================================================
//////////////////////////////////////////////////////////////

if(!defined('VIRTUALIZOR')){

	die('Hacking Attempt');

}

function performance_theme(){

global $theme, $globals, $cluster, $user, $l, $perfomance, $disk_health, $hypervisor, $servers, $disks, $supported, $binary_count, $binaries_not_found, $filter_ps_cpu, $filter_ps_ram, $crons, $disk_io, $interfaces_speeds, $ram_specs, $cpu_specs, $disks_df, $disks_inodes, $month;
$show_no_table = 0;
$no_data = 0;

softheader($l['<title>']);
										
echo page_header(__('Server Monitoring'), 'fas fa-heartbeat');

$breadcrumbs = ['dashboard', 'lm_resources', 'lms_performance'];

echo get_breadcrumb($breadcrumbs);

	// Tittle ends
	//smartmontool support start
	if(empty($supported)){
		$show_no_table = 1;
		echo '<div class="card p-2 mx-3">
	<form id="performanceform"  accept-charset="'.$globals['charset'].'" action="" method="post" name="performance" class="form-horizontal">
		<div class="col-sm-12 notice">
			Oops! Looks like your OS does not support smartmontool utility or smartmontools utility is missing.
		</div>
	</form>';
	}
	//smartmontool support ends

	// Is it offline ?
	$hypervisor_status = $cluster->statewise($globals['server']);
	if($hypervisor_status == 0 || $hypervisor_status == 2){
		show_alert($globals['hypervisor_status'][$hypervisor_status] ,"1");
		echo '
	<div class="e_notice"><b>NOTE: </b>&nbsp; '.$globals['hypervisor_status'][$hypervisor_status].'</div>';
	}else{
	//Procced with page
		echo'
	<script> 
		var hddtable 	= ``;
		var ssdtable 	= ``;
		var nvmetable 	= ``;
		var fdisktable 	= ``;
	</script>

	<!-- Big 3 Cards Start here -->

	<div class="card-deck row mx-auto w-100">
		<div class="card border-light col-sm-4 ">
			<div class="card-body px-0">
				<div class="row">
					<div class="col-sm-8">
						<h5 class="text-dark"><i class="fas fa-microchip"></i>&nbsp;'.__('CPU').'</h5>
					</div>
					<div class="col-sm-4 text-right">
						<h5 class="skeleton-loader text-right text-admin" id="cpu_percentage"></h5>
					</div>
				</div>
				<div class="row">
					<div class="col-sm-8">
						<div class="skeleton-loader mb-1 txt-overflow" id="cpu_id"></div>
					</div>
					<div class="col-sm-4 text-right cursor-pointer" onclick="$(\'#process_cpuspec_modal\').modal();"><span class="text-primary">'.__('Extra Info').'</span>
						 <i class="text-primary fas fa-info-circle"></i>
					</div>
				</div>
					<hr>
					<div id="cpuholder"></div>
			</div>
			<div class="card-footer">
			<p class="px-3 cursor-pointer" id="list_process_cpu"> <span class="text-admin" >'.__('List Process').' :</span>'.__('Top 10 Processes consuming').' '.__('CPU').'</p>		
			</div>
		</div>
		<div class="card border-light col-sm-4 ">
			<div class="card-body px-0">
				<h5 class="text-dark"><i class="fas fa-server"></i>&nbsp;'.__('Node Info').'</h5>
				<div class="mb-4" id="server_info" style="width: 300px; height: 343px;">
					<div>&nbsp;</div>
					<hr>
					<p class="px-3"><span class="text-admin">'.__('Node\'s OS').'</span>: '.$servers[$globals['server']]['os'].'</p>
					<p class="px-3 cursor-pointer" id ="list_binary"> <span class="text-admin" >'.__('Binaries').' </span>: <span id="binary_count">'.(!empty($binary_count) ?  $binary_count.' " " '.__('binaries are missing').' <span style="color:red"><i class="fas 	fa-exclamation-triangle"></i></span>' : ''.__('No missing binaries').' <span style="color:green"><i class="fas fa-check-circle"></i></span>').'</p>
					<p class="px-3 cursor-pointer" id="cron_list"> <span class="text-admin" >'.__('Scripts').': </span>'.__('Shows active cron processes time').'</p>
					<p class="px-3 cursor-pointer" id="diskio_list"> <span class="text-admin" >'.__('Disk IO') .': </span>'.__('Show current node\'s Disk IO').'</p>
					<p class="px-3 cursor-pointer" id="graph_list"><span class="text-admin">'.__('Network Graphs').': </span>'.__('Monitor up/down speed').'</p>
				</div>
			</div>
			<div class="card-footer">
			<p class="px-3 text-black"><span class="text-admin" >'.__('Hostname').' : </span>'.$servers[$globals['server']]['server_name'].'</p>
			</div>
		</div>

		<div class="card border-light col-sm-4 ">
			<div class="card-body px-0">
				
				<div class="row">
					<div class="col-sm-8">
						<h5 class="text-dark"><i class="fas fa-memory"></i>&nbsp;'.__('RAM').'</h5>
					</div>
					<div class="col-sm-4">
						<h5 class="skeleton-loader text-right text-admin" id="ram_percentage"></h5>
					</div>
				</div>
				<div class="row">
					<div class="col-sm-8">
						<p class="text-muted">
						'.__('Total Ram').' : '.round(($servers[$globals['server']]['total_ram']) / 1024).'GB
						</p>
					</div>
					<div class="col-sm-4 text-right cursor-pointer"><span class="text-primary" onclick="$(\'#process_ramspec_modal\').modal();">'.__('Extra Info').'</span>
						<i class="px-1 text-primary fas fa-info-circle"></i>
					</div>
				</div>
				<hr>
				<div id="ramholder"></div>
			</div>
			<div class="card-footer style="background-color: white;">
			<p class="px-3 cursor-pointer" id="list_process_ram"> <span class="text-admin" >'.__('List Process').' :</span>'.__('Top 10 Processes consuming').' '.__('RAM').'</p>
			</div>
		</div>
	</div>

	<!-- Big 3 Cards ends here -->

	<hr>';
 
	echo '
	<!-- Storage size cards start here -->

	<div class="card p-2 mx-3">
		<h5 class="text-dark"><i class="fas fa-hdd"></i>&nbsp;Storage Size</h5>
		<div class="row w-100">';
			foreach($disks_df as $k => $v){
				if(!empty($k)){
					echo '
					<div class="col-sm-3">
						<div class="card border-light">
							<div class="card-body">
								<h6 class="text-monospace card-title txt-overflow" tooltip="'.$k.'">'.$k.'</h6>
								<div class="row">
									<div class="col-6">
										<p class="card-text">Size : '.$v['limit_gb'].' GB</p>
										<p class="card-text">Utilized : '.$v['used_gb'].' GB</p>
									</div>
									<div class="col-6 text-right">
										<h3 class="text-primary">'.$v['percent'].'%</h3>
									</div>
								</div>
								<div class="progress mt-1"  style="height: 5px;">
									<div class="progress-bar bg-admin" role="progressbar" style="width: '.$v['percent'].'%;" aria-valuenow="'.$v['percent'].'" aria-valuemin="0" aria-valuemax="100">
									</div>
								</div>
							</div>
						</div>
					</div>
					';
				}
			}

		echo'
		</div>
	</div>
	<!-- Storage size cards ends here -->

	<hr>
	';
	// Disk Panel Ends

	// Disk Ionodes
	echo '
	<!-- Storage Ionodes cards start here -->

	<div class="card p-2 mx-3">
		<h5 class="text-dark"><i class="fas fa-hdd"></i>&nbsp;Storage Inodes</h5>
		<div class="row w-100">';
			foreach($disks_inodes as $k => $v){
				if(!empty($k)){
					echo '
					<div class="col-sm-3">
						<div class="card border-light">
							<div class="card-body">
								<h6 class="text-monospace card-title txt-overflow tooltip="'.$k.'" ">'.$k.'</h6>
								<div class="row">
									<div class="col-6">
										<p class="card-text">Limit : '.$v['limit'].'</p>
										<p class="card-text">Used : '.$v['used'].'</p>
									</div>
									<div class="col-6 text-right">
										<h3 class="text-primary">'.$v['percent'].'%</h3>
									</div>
								</div>
								<div class="progress mt-1"  style="height: 5px;">
									<div class="progress-bar bg-admin" role="progressbar" style="width: '.$v['percent'].'%;" aria-valuenow="'.$v['percent'].'" aria-valuemin="0" aria-valuemax="100">
									</div>
								</div>
							</div>
						</div>
					</div>	
					';
				}
			}

		echo'
		</div>
	</div>

	<!-- Storage Ionodes cards ends here -->

	<hr>
	';
	// Disk Inodes Ends

	////Disk health creator 
	if(empty($show_no_table)){
		echo '
		<!-- Smartmontool header starts here -->
		<div class="card p-2 mx-3">
			<div id="hddmain" style="display:none">
				<h5 class="px-3 text-dark"><i class="fas fa-hdd"></i>&nbsp;'.__('HDD Drives Health').'</h5>  
				<div class ="px-2 w-100 mx-auto sticky">
					<table class="table table-hover tablesorter common-table border-light" id="hddtable"> </table>
				</div>
			</div>
			<div id="ssdmain" style="display:none">
				<h5 class="px-3 text-dark"><i class="fas fa-hdd"></i>&nbsp;'.__('SSD Drives Health').'</h5>  
				<div class ="px-2 w-100 mx-auto sticky">
					<table class="table table-hover tablesorter common-table border-light" id="ssdtable"> </table>
				</div>
			</div>
			<div id="nvmemain" style="display:none">
				<h5 class="px-3 text-dark"><i class="fas fa-hdd"></i>&nbsp;'.__('NVMe Drives Health').'</h5>  
				<div class ="px-2 w-100 mx-auto sticky">
					<table class="table table-hover tablesorter common-table border-light" id="nvmetable"> </table>
				</div>
			</div>
			<div id="fdiskmain" style="display:none">
				<h5 class="px-3 text-dark"><i class="fas fa-hdd"></i>&nbsp;'.__('Virtual Drives Health').'</h5>  
				<div class ="px-2 w-100 mx-auto sticky">
					<table class="table table-hover tablesorter common-table border-light" id="fdisktable"> </table>
				</div>
			</div>
		</div>
		<!-- SSmartmontool header ends here -->
		';
		
		//Disk health creator 
		foreach($disk_health as $disk_numer => $smartctl_values){
			if(array_key_exists("ata_smart_attributes", $disk_health[$disk_numer]) & !empty($smartctl_values['rotation_rate'])){
				echo '
		<script>
			hddtable += `
					<tr>
						<td>Smartctl</td>
						<td>'.(!empty($hypervisor) ? $hypervisor : $smartctl_values['model_family']).'</td>
						<td>'.(empty($smartctl_values['serial_number']) ? "NA" : $smartctl_values['serial_number']).'</td>
						<td>'.$smartctl_values['logical_block_size'].'</td>
						<td>'.(empty($smartctl_values['rotation_rate']) ? "NA" : $smartctl_values['rotation_rate']).'</td>
						<td>'.(empty($smartctl_values['sata_version']['string']) ? "NA" : $smartctl_values['sata_version']['string']).'</td>
						<td>'.(empty($smartctl_values['interface_speed']['current']['string']) ? "NA" : $smartctl_values['interface_speed']['current']['string']).'</td>
						<td>'.(empty($smartctl_values['user_capacity']['bytes']) ? "NA" : round(($smartctl_values['user_capacity']['bytes']/1000000000000),2)).' TB</td><td>`;
					';
				foreach($smartctl_values['ata_smart_attributes']['table'] as $k => $v){
					if($v['name'] == 'Temperature_Celsius'){
						if(strlen($v['raw']['value']) > 3){
							echo ' 
			hddtable += ` '.$v['raw']['string'].'°C ` ';
								
						}else{
							echo ' 
			hddtable += ` '.$v['raw']['value'].'°C ` ';
						}
							break;
					}
				}
			echo '
			hddtable += `</td>
					<td>'.(empty($smartctl_values['smart_status']['passed']) ? "NA" : (($smartctl_values['smart_status']['passed'] == 1) ? '<span style="color:green"><i class="fas fa-check-circle"></i></span>' : '<span style="color:red"><i class="fas fa-exclamation-triangle"></i></span>' )).'</td>
					</tr>`;
		</script>
					';
			}
			else if(array_key_exists("nvme_smart_health_information_log", $disk_health[$disk_numer])){
				echo '
		<script>
		
			nvmetable += `
					<tr>
						<td>Smartctl</td>
						<td>'.(!empty($smartctl_values['model_name']) ? $smartctl_values['model_name'] : 'NA').'</td>
						<td>'.(empty($smartctl_values['serial_number']) ? "NA" : $smartctl_values['serial_number']).'</td>
						<td>'.(!empty($smartctl_values['logical_block_size']) ? $smartctl_values['logical_block_size'] : 'NA').'</td>
						<td>'.(!empty($smartctl_values['firmware_version']) ? $smartctl_values['firmware_version'] : 'NA').'</td>
						<td>'.(empty($smartctl_values['user_capacity']['bytes']) ? "NA" : round(($smartctl_values['user_capacity']['bytes']/1000000000000),2)).' TB</td>
						<td>'.(empty($smartctl_values['temperature']) ? "NA" : $smartctl_values['temperature']['current'].' °C').'</td>
						<td>'.(empty($smartctl_values['smart_status']['passed']) ? "NA" : (($smartctl_values['smart_status']['passed'] == 1) ? '<span style="color:green"><i class="fas fa-check-circle"></i></span>' : '<span style="color:red"><i class="fas fa-exclamation-triangle"></i></span>' )).'</td>
					</tr>`;
		</script>';	
			}
			else if(array_key_exists("ata_smart_attributes", $disk_health[$disk_numer]) && !empty($smartctl_values['firmware_version']) && !empty($smartctl_values['sata_version']['string'])){
				echo '
		<script>
			ssdtable += `
					<tr>
						<td>Smartctl</td>
						<td>'.(!empty($hypervisor) ? $hypervisor : $smartctl_values['model_name']).'</td>
						<td>'.(empty($smartctl_values['serial_number']) ? "NA" : $smartctl_values['serial_number']).'</td>
						<td>'.$smartctl_values['logical_block_size'].'</td>
						<td>'.(empty($smartctl_values['firmware_version']) ? "NA" : $smartctl_values['firmware_version']).'</td>
						<td>'.(empty($smartctl_values['sata_version']['string']) ? "NA" : $smartctl_values['sata_version']['string']).'</td>
						<td>'.(empty($smartctl_values['interface_speed']['current']['string']) ? "NA" : $smartctl_values['interface_speed']['current']['string']).'</td>
						<td>'.(empty($smartctl_values['user_capacity']['bytes']) ? "NA" : round(($smartctl_values['user_capacity']['bytes']/1000000000000),2)).' TB</td>
						<td>'.(empty($smartctl_values['temperature']['current']) ? "NA" : $smartctl_values['temperature']['current'].' °C').'</td>
						<td>'.(empty($smartctl_values['smart_status']['passed']) ? "NA" : (($smartctl_values['smart_status']['passed'] == 1) ? '<span style="color:green"><i class="fas fa-check-circle"></i></span>' : '<span style="color:red"><i class="fas fa-exclamation-triangle"></i></span>' )).'</td>
					</tr>`;
		</script>
				';
			}
			else{
				$no_data = 1;
				break;
			}
		}
	}
	//Disk health creator ends

	//Disk creator for non smartctl and non hypervisor
	if(!empty($no_data)){
		foreach($disks as $disk_num => $disk_info){
			echo '
			<script>
			fdisktable +=`
				<tr>
					<td>Fdisk</td>
					<td>'.(!empty($hypervisor) ? $hypervisor : "Virtual").'</td>
					<td>'.(!empty($disk_info['1']) ? substr($disk_info['1'],0,strlen($disk_info['1'])-1) : "NA").'</td>
					<td>NA</td>
					<td>NA</td>
					<td>NA</td>
					<td>NA</td>
					<td>'.round(($disk_info['4']/1000000000000),2).' TB</td>
					<td>NA</td>
					<td>NA</td>
				</tr> `;
			</script>
			';
		}
	}
	//Disk creator for non smartctl and non hypervisor ends

	echo '
	<!-- Binary modal initializor -->

	<div class="modal fade" id="binaries_modal">
		<div class="modal-dialog">
			<div class="modal-content">
				<div class="modal-header d-flex align-items-center">
					<span class="modal-title">'.__('Binaries').'</span>
					<span class="spinner-grow spinner-grow-sm"></span>
					<button type="button" class="close text-always-white" data-dismiss="modal">&times;</button>
				</div>
				<div class="modal-body">
					<div class="alert alert-info alert-dismissible fade show">
					<strong>'.__('Note').': </strong>'.__('Shows missing binaries which are needed by virtualizor for its core functionality').'
					</div>
					<div id="binary_display"></div>
				</div>
			</div>
		</div>
	</div>

	<!-- Binary modal ends -->

	<!-- Ram modal initializor -->
	<div class="modal fade" id="process_ram_modal">
		<div class="modal-dialog modal-xl">
			<div class="modal-content">
				<div class="modal-header d-flex align-items-center">
					<span class="modal-title"> '.__('Top 10 Processes consuming') ." ".__('RAM').' </span>
					<span class="spinner-grow spinner-grow-sm"></span>
					<button type="button" class="close text-always-white" data-dismiss="modal">&times;</button>
				</div>
				<div class="modal-body">
					<div class="alert alert-info alert-dismissible fade show">
						<strong>'.__('Note').': </strong>'.__('This list gets updated in every 5 seconds on the basis of ram usage') .'
					</div>
					<div id="process_ram_display"></div>
				</div>
			</div>
		</div>
	</div>

	<div class="modal fade" id="process_ramspec_modal">
		<div class="modal-dialog modal-xl">
			<div class="modal-content">
				<div class="modal-header d-flex align-items-center">
					<span class="modal-title">'.__('RAM details').'</span>
					<button type="button" class="close text-always-white" data-dismiss="modal">&times;</button>
				</div>
				<div class="modal-body">
					<div id="ramspec_display"></div>
				</div>
			</div>
		</div>
	</div>

	<!-- Ram modal ends -->

	<!-- Cpu modal initializor -->

	<div class="modal fade" id="process_cpu_modal">
		<div class="modal-dialog modal-xl">
			<div class="modal-content">
				<div class="modal-header d-flex align-items-center">
					<span class="modal-title">'.__('Top 10 Processes consuming') ." ". __('CPU').' </span>
					<span class="spinner-grow spinner-grow-sm"></span>
					<button type="button" class="close text-always-white" data-dismiss="modal">&times;</button>
				</div>
				<div class="modal-body">
					<div class="alert alert-info alert-dismissible fade show">
						<strong>'.__('Note').': </strong>'.__('This list gets updated in every 5 seconds on the basis of cpu usage').'
					</div>
					<div id="process_cpu_display"></div>
				</div>
			</div>
		</div>
	</div>
	<div class="modal fade" id="process_cpuspec_modal">
		<div class="modal-dialog modal-lg">
			<div class="modal-content">
				<div class="modal-header d-flex align-items-center">
					<span class="modal-title">'.__('Show CPU info').'</span>
					<button type="button" class="close text-always-white" data-dismiss="modal">&times;</button>
				</div>
				<div class="modal-body">
					<div id="cpuspec_display"></div>
				</div>
			</div>
		</div>
	</div>

	<!-- Cpu modal ends -->

	<!-- DiskIO modal initializor -->

	<div class="modal fade" id="diskio_modal">
		<div class="modal-dialog modal-xl">
			<div class="modal-content">
				<div class="modal-header d-flex align-items-center">
					<span class="modal-title">'.__('Disk IO').'</span>
					<span class="spinner-grow spinner-grow-sm"></span>
					<button type="button" class="close text-always-white" data-dismiss="modal">&times;</button>
				</div>
				<div class="modal-body">
					<div class="alert alert-info alert-dismissible fade show">
						<strong>'.__('Note').': </strong>'.__('This table shows each disk\'s partitions active I/O which is updated in every 5 seconds').'
					</div>
					<div id="diskio_display"></div>
					<div id="diskio_help"></div>
				</div>
			</div>
		</div>
	</div>
	
	<!-- DiskIO modal ends -->

	<!-- Script modal initializor -->

	<div class="modal fade" id="cron_modal">
		<div class="modal-dialog">
			<div class="modal-content">
				<div class="modal-header d-flex align-items-center">
					<span class="modal-title">'.__('Scripts').'</span>
					<span class="spinner-grow spinner-grow-sm"></span>
						<button type="button" class="close text-always-white" data-dismiss="modal">&times;</button>
				</div>
				<div class="modal-body">
					<div class="alert alert-info alert-dismissible fade show">
						<strong>'.__('Note').': </strong>'.__('Active times for scripts are updated in every 5 seconds').'
					</div>
					<div id="cron_display"></div>
				</div>
			</div>
		</div>
	</div>

	<!-- Script modal ends -->

	<!-- Graph modal initializor -->

	<div class="modal fade" id="graph_modal">
		<div class="modal-dialog">
			<div class="modal-content">
				<div class="modal-header d-flex align-items-center">
					<span class="modal-title">'.__('Network Graphs').'</span>
					<span class="spinner-grow spinner-grow-sm"></span>
					<button type="button" class="close text-always-white" data-dismiss="modal">&times;</button>
				</div>
				<div class="modal-body">
					<div class="alert alert-info alert-dismissible fade show">
						<strong>'.__('Note').': </strong>'.__('Graph values are updated in every 5 secs').'
					</div>
					<div id="graph_display">
						<div class="card border-light  text-center">
							<div class="card-body">
								<h5 class="card-title">'.(empty($globals['interface']) ? "eth0" : $globals['interface']).'</h5>
								<h6 class="card-subtitle mb-2 text-muted">Network Speed : <span id="nw_speed_live"></span></h6>
							</div>
							<div id="nw_speed_chartLegend"></div>
							<div id="network_speed_holder1"></div>
						</div>
						<hr>
						<div id="table_interface"></div>
					</div>
				</div>
			</div>
		</div>
	</div>

	<!-- Graph modal ends -->
	';

	// Javascript Functions Starts
echo '
	<script language="javascript" type="text/javascript">
	
	function makedata(data,time=""){
		
		var fdata = [];
		i = 0;
		
		if(!empty(time)){
			for(i = 1; i < 13; i++){
				fdata.push(i*5);
			}
			return fdata.reverse();
		}else{
			for (x in data){
				fdata.push([data[x]][0]);
			}	
			return fdata;
		}	

	}
	
	//DiskIO more info div

	var diskio_help = `<div class="card border-light ">
	<div class="card-header">
	  	'.__J('Need more info ?').'
	</div>
	<div class="card-body">
	  	<p>'.__J('Devices').'<br>
	  		<span>'.__J('This column gives the devices or partitions name as listed in the /dev directory.').'</span></br></p>
		<p>'.__J('TPS').'<br>
			<span>'.__J('Indicate the number of transfers per second that were issued to the device. A transfer is an I/O request to the device. Multiple logical requests can be combined into a single I/O request to the device. A transfer is of indeterminate size.').'</span><br></p>
		<p>'.__J('MB Read/s').'<br> 
			<span>'.__J('Indicate the amount of data read from the device expressed in a number of blocks i.e megabytes per second. Blocks are equivalent to sectors and therefore have a size of 512 bytes.').'</span></br></p>
		<p>'.__J('MB Written/s').'<br>
			<span>'.__J('Indicate the amount of data written to the device expressed in a number of blocks i.e megabytes per second.').'</span></br></p>
		<p>'.__J('MB Read').'<br>
			<span>'.__J('The total number of blocks i.e megabytes read.').'</span></br></p>
		<p>'.__J('MB Written').'<br>
			<span>'.__J('The total number of blocks i.e megabytes written.').'</span></br></p>
	</div>`;

	//DiskIO more info div ends

	// Apexchart starts here

	var timer_server_loads; 

	function loadperformancestats(){
		
		var cpu_graph_data = Array(12).fill("0");
		var ram_graph_data = Array(12).fill("0");
		var down_speed = Array(12).fill("0"); 
		var up_speed = Array(12).fill("0");
		var categories = [60, 55, 50, 45, 40, 35, 30, 25, 20, 15, 10, 5];
		
		var cpu_options = {
			chart: {
				type: "area",
				stacked: false,
				toolbar: false,
				height: "300",
			},
			dataLabels: {
				enabled: false
			},
			colors: ["#515DBC"], 
			plotOptions: {
				line: {
					dropShadow: {
						enabled: true,
						top: 2,
						left: 2,
						blur: 4,
						opacity: 0.5,
						color: "#FF4560" 
					}
				}
			},
			series: [{
					name: "CPU Usage ",
					data: cpu_graph_data,
					fill: {
						type: "gradient",
						gradient: {
							shade: "light",
							type: "vertical",
							shadeIntensity: 1,
							gradientToColors: "#515DBC",
							opacityFrom: 0.4,
							opacityTo: 0.1,
							stops: [0, 100]
						}
					}
			}],
			xaxis: {
				categories: categories,
				title: {
					text: "In Seconds"
				},
				stepSize: 1,
				labels:{
					show: true,
				},
				axisTicks: {
					show: false,
				},
				style: {
					colors: "#2563EB",
				},
				tickAmount: 6
			},
			yaxis: {
				min: 0,
				max: undefined,
				stepSize: 2,
				decimalsInFloat: 2,
				labels: {
					formatter: function(val){
						return val.toFixed(2) + " %";
					}	
				},
				style: {
					colors: "#2563EB",
				},
				tickAmount: 6
			},
			stroke: {
				width: 1, 
				curve: "smooth",
			}, 
			legend: {
				horizontalAlign: "left",
				offsetX: 40,
				position: "top",
			},
			tooltip: {
				shared: true,
				intersect: false,
			},
			grid: {
				// borderColor: "#e0e0e0", 
				borderColor: "#2A2D2F", 
				strokeDashArray: 0,	
				xaxis: {
					lines: {
						show: false 
					}
				},
				yaxis: {
					lines: {
						show: true 
					}
				}
			}	

		};

		var ram_options = {
			chart: {
				type: "area",
				stacked: false,
				toolbar: false,
				height: "300",
			},
			dataLabels: {
				enabled: false
			},
			colors: ["#FF5733"], 
			plotOptions: {
				line: {
					dropShadow: {
						enabled: true,
						top: 2,
						left: 2,
						blur: 4,
						opacity: 0.5,
						color: "#FF4560" 
					}
				}
			},
			series: [{
					name: "RAM Usage ",
					data: ram_graph_data,
					fill: {
						type: "gradient",
						gradient: {
							shade: "light",
							type: "vertical",
							shadeIntensity: 1,
							gradientToColors: "#515DBC",
							opacityFrom: 0.4,
							opacityTo: 0.1,
							stops: [0, 100]
						}
					}
			}],
			xaxis: {
				categories: categories,
				title: {
					text: "In Seconds"
				},
				stepSize: 1,
				labels:{
					show: true,
				},
				axisTicks: {
					show: false,
				},
				style: {
					colors: "#2563EB",
				},
				tickAmount: 6

			},
			yaxis: {
				min: 0,
				max: undefined,
				stepSize: 2,
				decimalsInFloat: 2,
				labels: {
					formatter: function(val){
						return val.toFixed(2) + " %";
					}
				},
				style: {
					colors: "#2563EB",
				},
				tickAmount: 6

			},
			stroke: {
				width: 1, 
				curve: "smooth",
			}, 
			legend: {
				horizontalAlign: "left",
				offsetX: 40,
				position: "top",
			},
			tooltip: {
				shared: true,
				intersect: false,
			},
			grid: {
				// borderColor: "#e0e0e0", 
				borderColor: "#2A2D2F", 
				strokeDashArray: 0,	
				xaxis: {
					lines: {
						show: false 
					}
				},
				yaxis: {
					lines: {
						show: true 
					}
				}
			}	

		};

		var ntwk_options= {
			chart: {
				type: "area",
				stacked: false,
				toolbar: false,
				height: "300",
			},
			dataLabels: {
				enabled: false
			},
			colors: ["#515DBC", "#DD7F52"],
			plotOptions: {
				line: {
					dropShadow: {
						enabled: true,
						top: 2,
						left: 2,
						blur: 4,
						opacity: 0.5,
						color: "#FF4560" 
					}
				}
			},
			series: [
				{
					name: "BANDWIDTH IN ",
					data: up_speed,
					fill: {
						type: "gradient",
						gradient: {
							shade: "light",
							type: "vertical",
							shadeIntensity: 1,
							gradientToColors: "#515DBC",
							opacityFrom: 0.4,
							opacityTo: 0.1,
							stops: [0, 100]
						}
					}
				},
				{
					name: "BANDWIDTH OUT ",
					data: down_speed,
					fill: {
						type: "gradient",
						gradient: {
							shade: "light",
							type: "vertical",
							shadeIntensity: 1,
							gradientToColors: "#515DBC",
							opacityFrom: 0.4,
							opacityTo: 0.1,
							stops: [0, 100]
						}
					}
				}
			],
			xaxis: {
				categories: categories,
				title: {
					text: "In Seconds"
				},
				stepSize: 1,
				labels:{
					show: true,
				},
				axisTicks: {
					show: false,
				},
				style: {
					colors: "#2563EB",
				},
				tickAmount: 6
			},
			yaxis: {
				min: 0,
				max: undefined,
				stepSize: 2,
				decimalsInFloat: 2,
				labels: {
					formatter: function(val){
						return val.toFixed(2) + " MB/s";
					}	
				},
				style: {
					colors: "#2563EB",
				},
				tickAmount: 6
			},
			stroke: {
				width: 1, 
				curve: "smooth",
			}, 
			legend: {
				horizontalAlign: "left",
				offsetX: 40,
				position: "top",
			},
			tooltip: {
				shared: true,
				intersect: false,
			},
			grid: {
				borderColor: "#2A2D2F", 
				strokeDashArray: 0,	
				xaxis: {
					lines: {
						show: false 
					}
				},
				yaxis: {
					lines: {
						show: true 
					}
				}
			}
		};

		let cpu_graph_object = {};
		let ram_graph_object = {};
		let ntwk_graph_object = {};

		cpu_graph_object = live_resource_graph2("", "cpuholder", cpu_options);
		ram_graph_object = live_resource_graph2("", "ramholder", ram_options);
		ntwk_graph_object = live_resource_graph2("", "network_speed_holder1", ntwk_options);

		function getprfmstats(){
			
			clearTimeout(timer_server_loads);
			
			$.getJSON("'.$globals['index'].'act=performance&ajax=true&api=json&network_stats=true", function(data) {

				//CPU
				cpu_graph_data.push(data["performance"]["cpu"].toString());
					cpu_graph_data.shift();
				var cpu_data = [{
					data: cpu_graph_data,
				}];
				var update_cpu_option_and_data = {
					series: cpu_data
				};
				cpu_graph_object = live_resource_graph2(cpu_graph_object, "",{},{},update_cpu_option_and_data);
				load_process_list(data["filter_ps_cpu"], "cpu")


				//RAM
				ram_graph_data.push(data["performance"]["ram"].toString());
					ram_graph_data.shift();

				var ram_data = [{
					data: ram_graph_data,
				}];
				var update_ram_option_and_data = {
					series: ram_data
				};

				ram_graph_object = live_resource_graph2(ram_graph_object, "",{},{},update_ram_option_and_data);
				load_process_list(data["filter_ps_ram"], "ram")

				load_binary_list(data["binaries_not_found"]);
				load_cron_list(data["crons"]);
				load_diskio_list(data["get_disk_io"]);
				show_the_name(data["performance"]["cpu_model"], data["performance"]["cpu"], data["performance"]["ram"]);

				var ginterface = "'.$globals['interface'].'";

				var plot_table = `
					<table class= "table table-hover tablesorter ">
						<tr>
							<th>'.__J('Interface Name').'</th>
							<th>'.__J('Upload Speed').'</th>
							<th>'.__J('Download Speed').'</th>
						</tr>`;		
									
				if(empty(ginterface)){
					ginterface = "eth0";
				}

				var speed_data = JSON.parse(data["interface_speed"]);

				$.each(speed_data, function(interface , speed){
									
					if(interface == ginterface){
						
						total_speed = (speed["download"] + speed["upload"]);

						down_speed.push((speed["download"] * 8).toString());
						down_speed.shift();
						up_speed.push((speed["upload"] * 8).toString());
						up_speed.shift();

						var ntwk_data = [
							{data: down_speed},
							{data: up_speed}
						];
						var update_ntwk_option_and_data  = {
							series: ntwk_data
						};

						ntwk_graph_object = live_resource_graph2(ntwk_graph_object, "",{},{},update_ntwk_option_and_data);

						$("#nw_speed_live").html(((speed["download"] * 8) + (speed["upload"] * 8)).toFixed(2)+" MB/s");
					}else{

						plot_table += `<tr> 
							<td> ${interface} </td>
							<td> ${speed["upload"]} MB/s </td>
							<td> ${speed["download"]} MB/s </td>
							</tr>`;

					}

				});
		
				plot_table += `</table>`;
				$("#table_interface").html(plot_table);
				
				timer_server_loads = setTimeout(getprfmstats(), 5000);
			});

		}

		getprfmstats();

	}

	loadperformancestats();

	//Ajax Calls
	getusagebandwidth();
	
	function getusagebandwidth(selected_data=""){
		
		var act = "'.$globals['index'].'act=bandwidth&show="+selected_data+"&api=json";
		if(AJAX(act, "_updatebw(re)")){
			return false;
		}else{
			return true;	
		}
	};

	var bwdays = [];
	var bw_usage = [];
	var bw_in = [];
	var bw_out = [];

	function _updatebw(re){
		var bw_ajax = JSON.parse(re);
		bwdays = bw_ajax["bandwidth"]["mdays"];
		bw_usage = makedata(bw_ajax["bandwidth"]["usage"]);
		bw_in = makedata(bw_ajax["bandwidth"]["in"]["usage"]);
		bw_out = makedata(bw_ajax["bandwidth"]["out"]["usage"]);
		bw_chart(bw_in,bw_out,bw_usage);		
	}

	function bw_chart(bw_in, bw_out, bw_usage){
		
		var month = getCurrentMonthDetails();
		//adding bandwidth which is in MB to GB of whole month
		bw_in_usage = (bw_in.reduce((acc, cur) => acc + cur, 0) / 1024).toFixed(2);
		bw_out_usage = (bw_out.reduce((acc, cur) => acc + cur, 0) / 1024).toFixed(2);
		tot_bw_usage = (parseFloat(bw_in_usage) + parseFloat(bw_out_usage)).toFixed(2);
		
		const bandwidth_total = ["'. __J('Bandwidth IN') .' - <b>"+bw_in_usage+ " GB</b>", "'.__J('Bandwidth OUT').' - <b>"+bw_out_usage+ " GB</b>", "'.__J('Total Bandwidth').' - <b>"+tot_bw_usage+ " GB</b>"]; 
		

		var options = {
			chart: {
				type: "area",
				stacked: false,
				height: 500
			},
			dataLabels: {
				enabled: false
			},
			title: {
				text: "BANDWIDTH",
				style: {
					color: "#FF1654"
				}
			},		
			series: [
				{
					name: "'.__J('Bandwidth IN').'",
					data: bw_in,
					color: "#515DBC",
				}, 
				{
					name: "'.__J('Bandwidth OUT').'",
					data: bw_out,
					color: "#FF6C23"
				},
				{
					name: "'.__J('Bandwidth Usage').'",
					data: bw_usage,
					color: "#FF00FF"
	   			}
			],
			xaxis: {
				categories: month["days"],
				tickamount: 7	
			},
			yaxis: {
				stepSize: 1,
				labels: {
					formatter: function (value) {
							return Math.round(value / 1024) + " GB"; // Convert MB to GB and round to nearest whole number
					}
				},
				tickamount: 7	
			},
			stroke: {
				width: [2, 1, 1], 
				curve: "straight" 
			}, 
			tooltip: {
		  		shared: true,
		  		intersect: false,
		  		y: {
					formatter: function (y) {
						if (typeof y !== "undefined") {
							return (y / 1024).toFixed(2) + " GB";
						}
	   				   return y;
					}
		  		},
				x: {
					formatter: function (value) {
						var curr_month  = month["monthName"].substr(0,3);
						return value + "  " + curr_month;  
					}
				}
			},
			grid: {
	 		   borderColor: "#e0e0e0", 
			   strokeDashArray: 0,	
				xaxis: {
					lines: {
						show: true 
					}
				},
				yaxis: {
					lines: {
						show: true 
					}
				}
			},
			legend: {
					position: "top",
					formatter: function(seriesName, opts) {
						return bandwidth_total[opts.seriesIndex];
					},
						
			}	

		};

		document.getElementById("bwholder").innerHTML = "";
		var chart = new ApexCharts(document.querySelector("#bwholder"), options);
		chart.render();
	}

	
	function ram_info_plotter(rams){
		var ram_plot = "";
		ram_plot += `<div class="row mx-auto w-100">`;
		if(!empty(rams)){
			$.each(rams, function(dimm, dimmval){
				ram_plot += `
					
					<div class="col-sm-3 mb-2">
						<div class="card border-light " style="width-100">
							<div class="card-body">
								<h5 class="card-title text-admin">${dimmval["Manufacturer"]}</h5>
								<p class="card-text text-muted font-weight-bold">${dimmval["Type"]}</p>
							</div>
							<ul class="list-group list-group-flush">
								<li class="list-group-item">
									<div class="row">
										<div class="col-12">
										Speed : 
										</div>
										<div class="col-12">
										${dimmval["Speed"]}
										</div>
									</div>
								</li>
								<li class="list-group-item">
									<div class="row">
										<div class="col-12">
										Size : 
										</div>
										<div class="col-12">
										${dimmval["Size"]}
										</div>
									</div>
								</li>
								<li class="list-group-item">
									<div class="row">
										<div class="col-12">
										Location : 
									</div>
									<div class="col-12">
									${dimmval["Bank Locator"]}
									</div>
									</div>
								</li>
							</ul>
							<div class="card-body">
								<div class=row>
									<div class="col-6">
										Voltage:
									</div>
									<div class="col-6">
										Serial Number:
									</div>
									<div class="col-6">
										${dimmval["Configured Voltage"]}
									</div>
									<div class="col-6">
										${dimmval["Serial Number"]}
									</div>
								</div>
							</div>
						</div>
					</div>
				`;
			})
			ram_plot += `</div>`;
		}else{
			ram_plot = `<div class="alert alert-danger alert-dismissible fade show">
			'.__J('Oops! This wasn\'t suppose to happen').'
			</div>`;
		}
		$("#ramspec_display").html(ram_plot);
	}

	function show_the_name(val,cpercent,rpercent){
		if(!empty(val)){
			$("#cpu_id").html(val);
			$("#cpu_id").removeClass("skeleton-loader");
			$("#cpu_id").addClass("text-muted");
			$("#cpu_percentage").html(cpercent+"%");
			$("#cpu_percentage").removeClass("skeleton-loader");
			$("#ram_percentage").html(rpercent+"%");
			$("#ram_percentage").removeClass("skeleton-loader");
			

		}else{
			$("#cpu_id").html("NA");
			$("#cpu_id").removeClass("skeleton-loader");
		}
	}


	show_cpu_spec('.json_encode($cpu_specs).');
	ram_info_plotter('.json_encode($ram_specs).');
	
	//Ajax Call ends


	//binary list

	function load_binary_list(binary_not_found, binary_count){
		if(!empty(binary_count)){
			var display_binary = `<table class= "table table-hover tablesorter ">`;
			var count_msg = (!empty(binary_count) ?  binary_count+\' '.__J('binaries are missing').'<span style="color:red"><i class="fas fa-exclamation-triangle"></i></span>\' : 
			\' '.__J('No missing binaries').' <span style="color:green"><i class="fas fa-check-circle"></i></span>\');
			$("#binary_count").html(count_msg);
			$.each(binary_not_found, function(k, val){
				display_binary += `<tr> 
					<td> ${val} </td>
					</tr>
					`;
			})
			display_binary += `</table>`;
		}else{
			var display_binary = `<p align="center"> No binaries are missing </p>`
		}
		
		$("#binary_display").html(display_binary);
	}

	// binary lsit ends

	//cpu modal

	function show_cpu_spec(cpuarr){
		if(!empty(cpuarr)){
			const cpucards = ["Architecture", "Model name", "L1i cache", "L2 cache","L3 cache","Thread(s) per core"];
			var cpu_image = "";
			if("Model name" in cpuarr){
				if(cpuarr["Model name"].match(/Intel/)){
					cpu_image = "'.$theme['images'].'/svgset/intel.svg";
				}else{
					cpu_image = "'.$theme['images'].'/svgset/amd.svg";
				}
			}else{
				cpuarr["Model name"] = "NA";
			}

			var cpucard = "";
			cpucard += `<div class="row">`; 
			cpucard += `
			<div class="col-sm-6 mb-2">
				<div class="card border-light ">
					<div class="card-body">
			`;


			$.each(cpuarr, function(cpuparam , cpuval){
				cpucard += `		
					<h6 class="card-title">${cpuparam}</h6>
					<p class="card-text">${cpuval}</p>
					`;
			})

			if(!("CPU MHz" in cpuarr)){
				cpuarr["CPU MHz"] = "NA";
			}
			
			cpucard += `</div>
					</div>
				</div>`;

			cpucard += `
						<div class="col-sm-6 mb-2">
							<div class="card border-light ">
								<div class="card-body col-sm-8">
									<img class="card-img-top" src="${cpu_image}">
								</div>
								<div class="card-body">
									<h5 class="card-title">${cpuarr["Model name"]}</h5>
									<p class="card-text">Architecture : ${cpuarr["Architecture"]}</p>
								</div>
								<ul class="list-group list-group-flush">
									<li class="list-group-item">CPU Frequency : ${cpuarr["CPU MHz"].substring(0, 4)} MHz</li>
									<li class="list-group-item">L1 Cache : ${cpuarr["L1i cache"]}</li>
									<li class="list-group-item">L2 Cache : ${cpuarr["L2 cache"]}</li>
									<li class="list-group-item">L3 Cache : ${cpuarr["L3 cache"]}</li>
								</ul>
								<div class="card-body">
									<span class="text-admin">Cores : ${cpuarr["Core(s) per socket"]}</a>
									<span class="px-3 text-admin">Thread : ${cpuarr["CPU(s)"]}</a>
								</div>
							</div>
						</div>
			`;
			$("#cpuspec_display").html(cpucard);
		}else{
			cpucard = `<div class="alert alert-danger alert-dismissible fade show">
			'.__J('Oops! This wasn\'t suppose to happen').'
			</div>`;
			$("#cpuspec_display").html(cpucard);
		}
	}

	//cpu modal ends

	//process list modal

	function load_process_list(filter_ps, hardware){

			var display_process = `<table class= "table table-hover tablesorter ">
			<tr>
			<th>'.__J('Process ID').'</th>
			<th>'.__J('Process Parent ID').'</th>
			<th>'.__J('Memory').'</th>
			<th>'.__J('CPU').'</th>
			<th>'.__J('Command').'</th>
			</tr>
			`;
		
			$.each(filter_ps, function(k, val){
				display_process += `<tr> 
					<td> ${val["1"]} </td>
					<td> ${val["2"]} </td>
					<td> ${val["3"]}% </td>
					<td> ${val["4"]}%</td>
					<td><span class="text-monospace">${val["5"]} </span></td>
					</tr>
					`;
			})
			if(hardware == "ram"){
				display_process += `</table>`;
				$("#process_ram_display").html(display_process);
			}else{
				display_process += `</table>`;
				$("#process_cpu_display").html(display_process);
			}
		
	}
	//process list modal ends

	//script load stats

	function load_cron_list(crons){
		var display_cron = `<table class= "table table-hover tablesorter ">
		<tr>
		<th>'.__J('Cron Name').'</th>
		<th>'.__J('Elapsed Time(seconds)').'</th>
		<th>'.__J('Process ID').'</th>
		</tr>
		`;
		
		$.each(crons, function(k, val){
			display_cron += `<tr> 
				<td> ${k} </td>
				<td> ${val["active"]} </td>
				<td> ${val["pid"]} </td>
				</tr>
				`;
		})
		display_cron += `</table>`;
		$("#cron_display").html(display_cron);
	}

	function load_diskio_list(diskio){
		var display_diskio = `<table class= "table table-hover tablesorter ">
		<tr>
		<th>'.__J('Devices').'</th>
		<th>'.__J('TPS').'</th>
		<th>'.__J('MB Read/s').'</th>
		<th>'.__J('MB Written/s').'</th>
		<th>'.__J('MB Read').'</th>
		<th>'.__J('MB Written').'</th>
		</tr>
		`;
		$.each(diskio, function(k, val){
			display_diskio += `<tr> 
				<td> ${(empty(val["0"]) ? 0 : val["0"])} </td>
				<td> ${(empty(val["1"]) ? 0 : val["1"])} </td>
				<td> ${(empty(val["2"]) ? 0 : val["2"])}mbps </td>
				<td> ${(empty(val["3"]) ? 0 : val["3"])}mbps </td>
				<td> ${(empty(val["4"]) ? 0 : val["4"])} MB </td>
				<td> ${(empty(val["5"]) ? 0 : val["5"])} MB </td>
				</tr>
				`;
		})
		display_diskio += `</table>`;
		$("#diskio_display").html(display_diskio);
	}

	$(document).ready(function(){
		$("#list_process_ram").click(function(){
			$("#process_ram_modal").modal();
		})
		$("#list_process_cpu").click(function(){
			$("#process_cpu_modal").modal();
		})
		$("#list_binary").click(function(){
			$("#binaries_modal").modal();
		})
		$("#cron_list").click(function(){
			$("#cron_modal").modal();
		})
		$("#graph_list").click(function(){
			$("#graph_modal").modal();
		})
		$("#diskio_list").click(function(){
			$("#diskio_modal").modal();
		})

		$("#diskio_help").html(diskio_help);
		$("#hddmain").hide();
		$("#ssdmain").hide();
		$("#nvmemain").hide();
		$("#fdiskmain").hide();

		if(!empty(fdisktable) && empty(hddtable) &&  empty(nvmetable) &&  empty(ssdtable)){
			fdisktable = `
				<thead>
				<tr class="table_heading">
					<th>'.__J('Utility').'</th>
					<th>'.__J('Model family').'</th>
					<th>'.__J('Serial number').'</th>
					<th>'.__J('Logical block size').'</th>
					<th>'.__J('Rotation rate').'</th>
					<th>'.__J('Sata Version').'</th>
					<th>'.__J('Interface Speed').'</th>
					<th>'.__J('Size').'</th>
					<th>'.__J('Temperature').'</th>
					<th>'.__J('Passed').'</th>
				</tr>
			</thead>
		<tbody>`+fdisktable;

			fdisktable += `</tbody>` ;

			$("#fdisktable").html(fdisktable);
			$("#fdiskmain").show();
		}

		if(!empty(hddtable)){
			hddtable = `
					<thead>
					<tr class="table_heading">
						<th>'.__J('Utility').'</th>
						<th>'.__J('Model family').'</th>
						<th>'.__J('Serial number').'</th>
						<th>'.__J('Logical block size').'</th>
						<th>'.__J('Rotation rate').'</th>
						<th>'.__J('Sata Version').'</th>
						<th>'.__J('Interface Speed').'</th>
						<th>'.__J('Size').'</th>
						<th>'.__J('Temperature').'</th>
						<th>'.__J('Passed').'</th>
					</tr>
				</thead>
				<tbody>
			`+hddtable;
			hddtable += `</tbody>` ;
			$("#hddtable").html(hddtable);
			$("#hddmain").show();
		}

		if(!empty(nvmetable)){
			nvmetable = `
			<thead>
			<tr class="table_heading">
				<th>'.__J('Utility').'</th>
				<th>'.__J('Model family').'</th>
				<th>'.__J('Serial number').'</th>
				<th>'.__J('Logical block size').'</th>
				<th>'.__J('Firmware Version').'</th>
				<th>'.__J('Size').'</th>
				<th>'.__J('Temperature').'</th>
				<th>'.__J('Passed').'</th>
			</tr>
		</thead>
		<tbody>
			`+nvmetable;
			nvmetable += `</tbody>`;
			$("#nvmetable").html(nvmetable);
			$("#nvmemain").show();
		}
		if(!empty(ssdtable)){
			ssdtable = `
						<thead>
							<tr class="table_heading">
								<th>'.__J('Utility').'</th>
								<th>'.__J('Model family').'</th>
								<th>'.__J('Serial number').'</th>
								<th>'.__J('Logical block size').'</th>
								<th>'.__J('Firmware Version').'</th>
								<th>'.__J('Sata Version').'</th>
								<th>'.__J('Interface Speed').'</th>
								<th>'.__J('Size').'</th>
								<th>'.__J('Temperature').'</th>
								<th>'.__J('Passed').'</th>
							</tr>
						</thead>
						<tbody>`+ssdtable;
						ssdtable += `</tbody>`;
						$("#ssdtable").html(ssdtable);
						$("#ssdmain").show();
		}

	})
</script>';

// Script ends here

//On click Ajax Call on basis of time 

$years = array("January" => '01',
			   "Febuary" => '02',
			   "March" => '03',
			   "April" => '04',
			   "May" => '05',
			   "June" => '06',
			   "July" => '07',
			   "August" => '08',
			   "September" => '09',
			   "October" => '10',
			   "November" => '11',
			   "December" => '12'
			);
$current_year = date("Y");
$tmp = $current_month = date("m");
echo '<hr>
<script language="javascript" type="text/javascript">
	function fetch_details(){
		var select_month = document.getElementById("cmonth");
		var selected_month = select_month.options[select_month.selectedIndex].value;
		var select_year = document.getElementById("cyear");
		var selected_year = select_year.options[select_year.selectedIndex].value;
		var selected_combine = selected_year+selected_month;
		getusagebandwidth(selected_combine);
	}
</script>
<div class ="card mx-3 p-2 row">
	<h5 class="px-3 text-dark"><i class="fas fa-tachometer-alt"></i>&nbsp;'.__('Bandwidth Usage').'</h5>
	<div class="row mx-auto w-100 my-3">
		<div class="col-sm-2">
			<label class="control-label">Select Year</label>
			<select class="custom-select chosen" name="cmonth" id="cmonth">';
			foreach($years as $month => $mvalues){
				echo '<option value="'.$mvalues.'" '.(($current_month == $mvalues) ? 'selected = "selected"' : '').'>'.$month.'</option>';
			}
			echo '
			</select>
		</div>';
		echo '
		<div class="col-sm-2">
			<label class="control-label">Select Year</label>
			<select class="custom-select chosen" name="cyear" id="cyear">
			';
			for($i = 5; $i > 0; $i--){
				echo '<option value="'.$current_year.'" '.(($tmp == $current_year) ? 'selected = "selected"' : '').'>'.$current_year.'</option>';
				$current_year --;
			}
echo '
			</select>
		</div>
			<div class="col-sm-2 text-left">
				</br>
				<input type="button" onclick="fetch_details();" class="btn px-4 link_btn" value="Fetch">
			</div>
		</div>
		<div class ="px-1 row w-100 mx-auto">
			<div id="bwholder" style="width:1400px;height:50px;"></div>
		</div>
		
	</div>
';
}
//on click ajax ends
echo '</div>';
softfooter();

}

?>
