<?php

//////////////////////////////////////////////////////////////
//===========================================================
// addserver_theme.php
//===========================================================
// SOFTACULOUS VIRTUALIZOR
// Version : 1.0
// Inspired by the DESIRE to be the BEST OF ALL
// ----------------------------------------------------------
// Started by: Alons
// Date:       8th Mar 2010
// Time:       23:00 hrs
// Site:       https://www.virtualizor.com/ (SOFTACULOUS VIRTUALIZOR)
// ----------------------------------------------------------
// Please Read the Terms of use at https://www.virtualizor.com
// ----------------------------------------------------------
//===========================================================
// (c)Softaculous Ltd.
//===========================================================
//////////////////////////////////////////////////////////////

if(!defined('VIRTUALIZOR')){

	die('Hacking Attempt');

}

function migrate_theme(){

global $theme, $globals, $servers, $user, $l, $list, $cluster, $error, $done, $servergroups, $migrate_status, $cpu, $progress, $migrate_done, $migrate_run, $mprog, $vpsid, $alliplist, $vpsips, $actid, $multi_mig_started, $selected_act, $disk_storages, $ip_resources, $live_mig, $is_not_shared_pool, $locked, $is_not_shared_storage, $migrate_lang;
	
//Is Ajax Mode on?
if(optREQ('do')){

	$do = optREQ('do');
	
	// Is there any error
	if(!empty($error)){
		$json['error'] = $error;
	}
	
	if($do == 'getvpslist'){	
		$json['list'] = $list;	
		echo array2json($json);
	}

	if($do == 'get_resources'){
		$json['disk_storages'] = $disk_storages;
		$json['vps_ip_resources'] = $ip_resources['vps'];
		$json['server_ip_resources'] = $ip_resources['server'];
		$json['vpsinfo'] = getvps($vpsid);
		echo array2json($json);
	}
	
	if($do == 'chk_ippool'){
		$json['is_not_shared_pool'] = $is_not_shared_pool;
		echo array2json($json);
	}

	if($do == 'chk_storage'){
		$json['is_not_shared_storage'] = $is_not_shared_storage;
		echo array2json($json);
	}
	
	return true;
}


softheader($l['<title>']);
					
$breadcrumbs = array('dashboard', 'lm_vs', ($selected_act == 'migrate' ? 'lms_migrate' : 'lms_clone'));

echo page_header($migrate_lang['<'.$selected_act[0].'title>'], 'fas fa-server', $globals['docs'].($selected_act == 'migrate' ? 'vps-migration/' : 'clone-vps/'), 0, 0, '');

echo get_breadcrumb($breadcrumbs);

// commented because no $saved found anywhere
// if(!empty($saved)){
// 	echo '<div class="notice"><b>'.__('Note').' : </b> &nbsp; '.__('API pair generated successfully! Return to <a href="index.php?act=list_api">List API Overview</a>').'</div><br />';
// }

if(!empty($locked['msg'])){

	$type = 1;
	if($locked['type'] == 'warn'){
		$type = 2;
	}
	show_alert(str_replace("\n", '<br>', $locked['msg']), $type);

}

if(!empty($error['vdf_errors'])){
	$error[] = __('Found Domain Forwarding records conflict. Make necessary update to VPS Domain Forwarding records or select "Ignore Domain Forwarding" option to ignore Domain Forwarding records copying for this VPS and try again');
}
error_handle($error);

if(!empty($multi_mig_started)){
	echo '<div class="notice mx-3" id="running"><b>NOTE : </b> '.__('The requested process has been started for selected VPS(s) and running in background, you can check the status on the <b><a href="index.php?act=tasks">Tasks page</a></b>.').'</div>';
}

echo '<script language="javascript" type="text/javascript"><!-- // --><![CDATA[
var actid = '.(isset($actid) ? $actid : "-1").';
var progress = 0;
var progress_update = "";
var update_status_txt = "";
var timer = null;
var server_ip_resources = "";

function getvpslist(){
	
	var from_server = $("#from_server").val();
	
	// If there are no VPS we check for that and return from here only. As there is nothing to check !
	if(from_server == "select_server"){
		return;
	}
	
	if(from_server == -1){
		$("#ip_tr").show();
		$("#pass_tr").show();
		
		var from_ip = $("#from_ip").val();
		var from_pass = $("#from_pass").val();
		
		if(from_ip.length < 1 || from_pass.length < 1){
			return false;
		}
		
	}else{
		$("#ip_tr").hide();
		$("#pass_tr").hide();
	}
	
	// Show the image
	$("#prog_img").show();
	
	$.ajax({
		type: "POST",
		dataType: "json",
		url: "index.php?act='.$selected_act.'&do=getvpslist",
		data: $("#migrate_form").serialize(),
		success: function(data, textStatus, jqXHR){	
	
			// Hide the image
			$("#prog_img").hide();			
			
			// Are there any errors ?
			if(typeof(data["error"]) != "undefined"){
				var errors = "";
				for(x in data["error"]){
					errors = errors + data["error"][x];
				}
				showalert(errors,"1");
			}
			
			// Build the VPS list
			var vpsopts = "";
			for(x in data["list"]){
				vpsopts = vpsopts + \'<option value="\'+x+\'" \'+(!empty(data["list"][x]["locked"]) ? "disabled" : "")+\'>\'+x+\' - \'+data["list"][x]["hostname"]+(!empty(data["list"][x]["locked"]) ? " ('.__J('Locked').')" : "")+\'</option>\';
			}
			
			//To check if vps virt is kvm for live migration
			var live_migration_virt = new Array("kvm", "vzo");
			for(x in data["list"]){
				if (live_migration_virt.includes(data["list"][x]["virt"])) {
					$("#live_mig_div").show();
				}else{
					$("#live_mig_div").hide();
				}
			}
			
			$("#vpsid").html(vpsopts);
			//$("#vpsid").select2();
		}
	});

}

function toggle_resources(){
	
	var selected_vps = [];
	
	$_("storage_row").style.display = "none";
	$("#ip_resource").hide();
	
	if($("#to_server").val().localeCompare("select_server") == 0){
		return;
	}
	
	$("#vpsid :selected").each(function(i, selected){
		selected_vps[i] = $(selected).text(); 
	});
	
	// If the count is more than 1, then do not display storage selection fields
	if(selected_vps.length != 1){
		$_("storage_row").style.display = "none";
		$("#ip_resource").hide();
		return;
	}
	
	$_("storage_row").style.display = "flex";
	
	if(!$("#preserve_ip").is(":checked")){
		$("#ip_resource").show();
	}
}


function get_resources(){
	
	var selected_vps = [];
	var vps_id = $("#vpsid").val();
	
	// If there are no VPS we check for that and return from here only. As there is nothing to do !
	if(vps_id == 0){
		return;
	}
	
	$("#vpsid :selected").each(function(i, selected){
		selected_vps[i] = $(selected).text(); 
	});
	
	if(selected_vps.length != 1){
		return;
	}
	
	$("#storage").html("");
	
	toggle_resources();
	
	';
	if($selected_act != 'migrate'){
		echo '
		if($("#to_server").val() == 0){
			$("#ignore_if_vdfconflict").prop("checked", true);
			$("#ignore_if_vdfconflict").prop("disabled", true);
		}else{
			$("#ignore_if_vdfconflict").prop("checked", false);
			$("#ignore_if_vdfconflict").prop("disabled", false);
		}';
	}
	
	echo '
	
	if($("#to_server").val().localeCompare("select_server") == 0){
		return;
	}
	
	$("#storage").html("<img src=\"'.$theme['images'].'loading_35.gif\"/>");
	
	$.ajax({
		type: "POST",
		dataType: "json",
		url: "index.php?act='.$selected_act.'&do=get_resources",
		data: $("#migrate_form").serialize(),
		success: function(data, textStatus, jqXHR){
	
			// Are there any errors ?
			if(typeof(data["error"]) != "undefined"){
				var errors = "";
				for(x in data["error"]){
					errors = errors + data["error"][x];
				}
				//alert(errors);
			}
			
			if(!$("#live_mig").is(":checked")){
				var ip_resources_table = "<table border=\'0\' class=\"table shadow-none\"><tr><th></th><th>VPS IPs</th><th>'.__J('Free IPs on : ').'"+$("#to_server option:selected").text()+"</th></tr>";
				
				var num_ips = {ips:"'.__J('IPv4 IP(s)').'", ipv6:"'.__J('IPv6 IP(s)').'", ipv6_subnet:"'.__J('IPv6 Subnets').'", ips_int : "'.__J('Internal IPs').'"}; 
				server_ip_resources =  data["server_ip_resources"];
				for(x in data["vps_ip_resources"]){
					
					var bgcolor = "class=\"text-success\"";
					if(data["vps_ip_resources"][x] > data["server_ip_resources"][x]){
						var bgcolor = "class=\"text-danger\"";
					}
					
					ip_resources_table += "<tr id=\'"+x+"_tr\' "+bgcolor+"><td>"+num_ips[x]+"</td><td>"+data["vps_ip_resources"][x]+"</td><td >"+data["server_ip_resources"][x]+"</td></tr>";
					var num = data["vps_ip_resources"][x];
					$("#num_"+x).val(num);
					$("#num_"+x+"_row").show();
				}
				
				ip_resources_table += "</table>";
				$("#ip_resource").show();
				$("#ip_resources_table").html(ip_resources_table);
			}
			
			var storageopts = "";
			
			if(data["disk_storages"] == undefined ){
				var msg = "'.__J('Selected VPS virtualization does not support storage selection, hence the destination servers primary storage will be used').'";
				$("#storage").html(msg);
				return;
			}
			
			if(data["disk_storages"]["no_storage_select"]){
				$("#storage").html(data["disk_storages"]["no_storage_select"]);
				return;
			}
			
			// Build the Storage List
			for(x in data["disk_storages"]){
				var num = parseInt(x);
				var size = data["vpsinfo"]["disks"][x]["size"];
				
				size = parseFloat(size).toFixed(2);
				num++;
				
				var format = data["vpsinfo"]["disks"][x]["format"];
				
				if(format == ""){
					if(data["vpsinfo"]["disks"][x]["type"] == "block"){
						format = "raw";
					}else if(data["vpsinfo"]["disks"][x]["type"] == "file"){
						format = "qcow2";
					}
				}
				
				storageopts += \'<div class="row mx-auto w-100 my-0"><div class="col-3 pl-0"> <label class="form-label" > DISK&nbsp;\' + num + \'</label> (&nbsp;\'+size+\'&nbsp;GB&nbsp;)<br />\' + format.toUpperCase() +\'</div>\';
				
				if(typeof data["disk_storages"][x] == "object"){
					storageopts +=  \'<div class="col-9 pr-0"><select class="custom-select" name="storage[\'+x+\']">\';
					
						for(y in data["disk_storages"][x]){
							
							storageopts += \'<option value="\'+y+\'" \'+(data["disk_storages"][x][y]["primary_storage"] == 1 ? "selected=selected" : "")+\'>\'+y+\' - \'+data["disk_storages"][x][y]["name"]+\' (\'+data["disk_storages"][x][y]["free"]+\'GB Free)</option>\';
						}
					storageopts += \'</select></div></div>\'; 
				}else if(typeof data["disk_storages"][x] == "string"){
					storageopts += \'<div class="col-sm-9"><span class="text-danger">\'+data["disk_storages"][x]+\'</span></div></div>\';
				}
			}
			
			if(storageopts == ""){
				storageopts = errors;
			}
			
			$("#storage").html(storageopts);
		}
	});

}

function chk_shared_ippool(){
	var vpsids = new Array();vpsids = $("#vpsid").val();
	var live_mig = $("#live_mig").prop("checked");
	vpsids = $("#vpsid").val();
	count = vpsids.length;
	var errors = "";
	$("#preserve_ip").prop("disabled", false);
	$("#del_orig").prop("disabled", false);
	if(live_mig){
		$("#preserve_ip").prop("checked", 1);
		$("#del_orig").prop("checked", 1);
		$("#preserve_ip").prop("disabled", true);
		$("#del_orig").prop("disabled", true);
		$("#sharedstorage_mig_div").show();
		
		$.each(vpsids, function(k, v){
			count = count-1;
			$.ajax({
				type: "POST",
				dataType: "json",
				url: "index.php?act='.$selected_act.'&do=chk_ippool",
				data: $("#migrate_form").serialize(),
				success: function(data){
					//if it is true
					if(data["is_not_shared_pool"] == true){
						errors += "'.__J('Live migration requires VPS IPs to be from a shared IP pool. Live miration cannot proceed for VPS ID: ').'"+v+"<br>";
						if(count == 0){
							showalert(errors,"1");
						}
					}
				}
			});
		});
	}else{
		$("#preserve_ip").prop("checked", 0);
		$("#del_orig").prop("checked", 0);
		$("#sharedstorage_mig_div").hide();
	}
	
	$("#preserve_ip").trigger("onchange");
	
	get_resources();
	
}

function chk_shared_storage(){

	var vpsids = new Array();
	vpsids = $("#vpsid").val();
	count = vpsids.length;
	var shared_mig = $("#shared_storage").prop("checked");
	var live_mig = $("#live_mig").prop("checked");
	var errors = "";

	if(shared_mig && live_mig){
		$.each(vpsids, function(k, v){
			count = count-1;
			$.ajax({
				type: "POST",
				dataType: "json",
				url: "index.php?act='.$selected_act.'&do=chk_storage",
				data: $("#migrate_form").serialize(),
				success: function(data){
					//if it is true
					if(data["is_not_shared_storage"][v] == true){
						errors += "'.__J('The VPS storage is not shared hence migration is not supported').' "+v+"<br>";
						if(count == 0){
							showalert(errors, "1");
						}
					}
				}
			});
		});
	}
	get_resources();
}
';

echo '
// Clean IDs
function ids_clean(str){
	str = str.replace(/\./gi, "_"); 
	str = str.replace(/\:/gi, "_"); 
	return str;
}

function donefunc(data){

	if(data == 1){
		showalert(\''.$migrate_lang[$selected_act[0].'_complete'].'\');
		$("#form-container").show();
		$("#running").hide();
		$("#progress-cont").hide();
	}else{
		animate_task("'.$migrate_lang[$selected_act.'_task'].'");
		$("#form-container").hide();
		progress_onload();
		$("#complete").hide();
		$("#running").show();
		$("#progress-cont").show();
	}
};

function startusage(){
	toggle_resources();
	timer = setTimeout("get_progress(\'migrate\')", 1000);
}

function make_mig_table(id, data){
		
	try{
		data = JSON.parse(data);
	}catch(e){
		return;
	}
	var j = 1;
	var html = "<center><table o><tr>";
	$.each(data, function(i, item){
		
		html += "<td>&nbsp;&nbsp;<b>"+i+"&nbsp;&nbsp;&nbsp;</b></td><td>"+item+"</td>";
		if(j % 2 == 0){
			html += "</tr><tr>";
		}
		j++;
	});
	
	html += "</tr></table></center>";
	$(id).html(html);
};

function changeipres(name){
	
	var value = parseInt($("#"+name).val());
	
	var name = name.substr(4);
	
	if(server_ip_resources[name] < value){
		$("#"+name+"_tr").css("color", "red");
	}else{
		$("#"+name+"_tr").css("color", "green");
	}
}

addonload("getvpslist(); '.(!empty($migrate_status) || !empty($migrate_done) ? "startusage();donefunc(2);$('#progressbar').progressbar();" : "").' '.(isset($_POST['migrate_but']) ? "get_resources();" : "").'");

// ]]></script>

	<div id="form-container" class="card p-2 mx-3">
		<form accept-charset="'.$globals['charset'].'" name="migrate_form" method="post" action="" id="migrate_form" class="form-horizontal">

			<div class="row mx-auto w-100 my-3">
				<div class="col-sm-4">
					<label class="form-label">'.__('From Server').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('The source server <b>FROM</b> which VPS(s) is/are to be selected').'"><i class="fas text-primary fa-info-circle"></i></a></label>
				</div>
				<div class="col-sm-4 server-select-lg">
					<select class="form-select virt-select" name="from_server" id="from_server" onchange="getvpslist();">
					<option value="select_server" selected="selected">'.__('Select Server').'</option>';
					
					foreach($servers as $k => $v){		 
						echo '<option value="'.$k.'" '.(POSTval('from_server') == $k && isset($_POST['from_server']) ? 'selected="selected"' : '').'>'.$v['server_name'].'</option>';
					}
					
					// Uncomment it if we plan to release migrate from non-slaved server
					//<option value="-1" '.(POSTval('from_server') == -1 ? 'selected="selected"' : '').'>'.__('Enter Server Details').'</option>
					
				echo '</select>
				</div>
			</div>

			<div class="row mx-auto w-100 my-3" id="ip_tr" style="display:none;">
				<div class="col-sm-4">
					<label class="form-label">'.__('IP Address').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('The primary address of the server').'"><i class="fas text-primary fa-info-circle"></i></a></label>
				</div>
				<div class="col-sm-4">
					<input type="text" class="form-control" name="from_ip" id="from_ip" size="30" value="'.POSTval('from_ip', '').'" />
				</div>	
			</div>

			<div class="row mx-auto w-100 my-3" id="pass_tr" style="display:none;">
				<div class="col-sm-4">
					<label class="form-label">'.__('Server Password').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('The password for controlling the server').'"><i class="fas text-primary fa-info-circle"></i></a></label>
				</div>
				<div class="col-sm-4">
					<input type="text" class="form-control" name="from_pass" id="from_pass" size="30" value="'.POSTval('from_pass', '').'" /> &nbsp; <input type="button" class="submit" onmouseover="sub_but(this)" onclick="getvpslist();" value="'.__('Get VPS List').'" />
				</div>
			</div>

			<div class="row mx-auto w-100 my-3">
				<div class="col-sm-4">
					<label class="form-label">'.__('Select VPS').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Select the VPS you wish to perform action on').'"><i class="fas text-primary fa-info-circle"></i></a></label>
				</div>
				<div class="col-sm-4">
					<div class="">
						<select name="vpsid[]" id="vpsid" class="form-control w-100" multiple="multiple" size="10" onchange="toggle_resources();get_resources();">
							<option value="0">'.__('Select VPS').'</option>
						</select>
						<div class="help-block"></div>
					</div>
					<div class="loader" id="prog_img" style="display:none;"></div>
				</div>	
			</div>

			<div class="row mx-auto w-100 my-3">
				<div class="col-sm-4">
					<label class="form-label">'.__('To Server').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('The <b>Desitnation</b> OR <b>Target</b> server for the VPS(s)').'" id="to-server" ><i class="fas text-primary fa-info-circle"></i></a></label>
				</div>
				<div class="col-sm-4 server-select-lg">
					<select class="form-select virt-select" name="to_server" id="to_server" onchange="get_resources();">
					<option value="select_server" selected="selected">'.__('Select Server').'</option>';
					
					foreach($servers as $k => $v){		 
						echo '<option value="'.$k.'" '.(POSTval('to_server') == $k && isset($_POST['to_server']) ? 'selected="selected"' : '').'>'.$v['server_name'].'</option>';
					}
					
				echo '</select>
				</div>
			</div>
			<div class="row mx-auto w-100 my-3" id="storage_row" style="display:none;">
				<div class="col-sm-4">
					<label class="form-label">'.__('Select Storage').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Select the Storage for the respective disk on the destination server.').'"><i class="fas text-primary fa-info-circle"></i></a></label>
				</div>
				<div class="col-sm-4" id="storage">
				</div>
			</div>';

			if($selected_act == 'migrate'){
				
				echo'
				<div class="row mx-auto w-100 my-3" id="live_mig_div" style="display:none";>
					<div class="col-4 ">
						<label class="form-label">'.__('Live Migration').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If checked, the KVM VPS will be live migrated to other node').'"><i class="fas text-primary fa-info-circle"></i></a></label>
					</div>
					<div class="col-4">
						'.get_checkbox('live_mig' ,'', 'live_mig', array('chk_it' => 1), 1, '', array('onclick="chk_shared_ippool();"')).'
					</div>
				</div>';
				echo '
				<div class="row mx-auto w-100 my-3">
					<div class="col-4" id="preserve_ip_row">
						<label class="form-label">'.__('Preserve the same IP Address(s)').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Set this option to use same IP Address(s) on the migrated VPS. The IP must belong to a common IP Pool between the source and destination servers. If not checked, IP(s) will be selected automatically.').'"><i class="fas text-primary fa-info-circle"></i></a></label>
					</div>
					<div class="col-4">
						'.get_checkbox('preserve_ip', '', 'preserve_ip', array('chk_it' => 1), 1, '' , array('onchange="toggle_resources();"')).'
					</div>
				</div>
				<div class="row mx-auto w-100 hide_for_multiple" id="ip_resource" style="display:none">
					<div class="col-sm-12">
					<fieldset class="user_details_f">
						<legend class="user_details_f">'.__('VPS IP Resources').'</legend>
						<div class="row mx-auto w-100">
						<div class="col-sm-6">
							<div class="row mx-auto w-100 hide_for_multiple my-2" id="num_ips_row" style="display:none">
								<div class="col-sm-6 pl-0">
									<label class="form-label">'.__('Number of IPv4').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Number of IPv4 to assign to the Migrated VPS').'"><i class="fas text-primary fa-info-circle"></i></a></label>
								</div>
								<div class="col-sm-6">
									<input type="text" class="form-control ip_res" name="num_ips" id="num_ips" value="'.POSTval('num_ips').'" onkeyup="changeipres(this.name);" />
								</div>
							</div>
							<div class="row mx-auto w-100 hide_for_multiple my-2" id="num_ipv6_row" style="display:none">
								<div class="col-sm-6 pl-0">
									<label class="form-label">'.__('Number of IPv6').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Number of IPv6 to assign to the Migrated VPS').'"><i class="fas text-primary fa-info-circle"></i></a></label>
								</div>
								<div class="col-sm-6">
									<input type="text" class="form-control ip_res" name="num_ipv6" id="num_ipv6" value="'.POSTval('num_ipv6').'" onkeyup="changeipres(this.name);" />
								</div>
							</div>
							<div class="row mx-auto w-100 hide_for_multiple my-2" id="num_ipv6_subnet_row" style="display:none">
								<div class="col-sm-6 pl-0">
									<label class="form-label">'.__('Number of IPv6 Subnets').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Number of IPv6 subnet to assign to the Migrated VPS').'"><i class="fas text-primary fa-info-circle"></i></a></label>
								</div>
								<div class="col-sm-6">
									<input type="text" class="form-control ip_res" name="num_ipv6_subnet" id="num_ipv6_subnet" value="'.POSTval('num_ipv6_subnet').'" onkeyup="changeipres(this.name);" />
								</div>
							</div>
							<div class="row mx-auto w-100 hide_for_multiple my-2" id="num_ips_int_row" style="display:none">
								<div class="col-sm-6 pl-0">
									<label class="form-label">'.__('Number of Internal IP(s)').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Number of Internal IP(s) to assign to the Migrated VPS').'"><i class="fas text-primary fa-info-circle"></i></a></label>
								</div>
								<div class="col-sm-6">
									<input type="text" class="form-control ip_res" name="num_ips_int" id="num_ips_int" value="'.POSTval('num_ips_int').'" onkeyup="changeipres(this.name);" />
								</div>
							</div>
						</div>
						<div class="col-sm-6" id="ip_resources_table">
						</div>
						</div>
					</fieldset>
					</div>
				</div>';
			}

			if($selected_act == 'migrate'){
				
				echo '<div class="row mx-auto w-100 my-3">
					<div class="col-4">
						<label class="form-label">'.__('Delete the Source VPS').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Set this option to delete the source VPS after successful Migration').'"><i class="fas text-primary fa-info-circle"></i></a></label>
					</div>
					<div class="col-4">
						'.get_checkbox('del_orig', '', 'del_orig').'
					</div>
				</div>

				<div class="row mx-auto w-100 my-3" id="sharedstorage_mig_div" style="display:none">
					<div class="col-4 ">
						<label class="form-label">'.__('Shared storage migrations').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If checked, then only domain file will be migrated').'"><i class="fas text-primary fa-info-circle"></i></a></label>
					</div>
					<div class="col-4">
						'.get_checkbox('shared_storage' ,'', 'shared_storage', array('chk_it' => 1), 1, '', array('onclick="chk_shared_storage();"')).'
					</div>
				</div>';
				
			}

			echo'
			<div class="row mx-auto w-100 my-3">
				<div class="col-4">
					<label class="form-label">'.__('Ignore Domain Forwarding Conflict(s)').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Ignore HAProxy VPS Domain Forwarding records if a conflict is found with records on the destination server').'"><i class="fas text-primary fa-info-circle"></i></a></label>
				</div>
				<div class="col-4">
					'.get_checkbox('ignore_if_vdfconflict' ,'', 'ignore_if_vdfconflict').'
				</div>
			</div>
			<div class="row mx-auto w-100 my-3">
				<div class="col-4 ">
					<label class="form-label">'.__('Speed Limit for transfering VPS(s) data (in MBps)').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If defined the transfer of the VPS(s) data to another server will be performed at the defined speed. default will be 1000MBps if not defined').'"><i class="fas text-primary fa-info-circle"></i></a></label>
				</div>
				<div class="col-4">
					<input type="number" class="form-control" name="speed_limit" id="speed_limit" value="'.POSTval('speed_limit').'"/>
				</div>
			</div>

			<div class="row mx-auto w-100 my-3">
				<div class="col-4 ">
					<label class="form-label">'.__('Disable Compression').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If checked, compression (i.e. gzip) will not be used during migration').'"><i class="fas text-primary fa-info-circle"></i></a></label>
				</div>
				<div class="col-4">
					'.get_checkbox('disable_gzip' ,'', '', array('chk_it' => 1, 'val' => 1)).'
				</div>
			</div>
			<br/>';
			echo'
			<input type="hidden" name="migrate" value="1"/>
			<center>
				<input type="submit" class="go_btn mt-5" name="migrate_but" id="migrate_but" value="'.$migrate_lang[$selected_act[0].'sub_but'].'" />
			</center>
			<br/><br/>
		</form>';

		echo '
		<div class="notebox">
			<font class="bboxtxt"><b>NOTE</b> : <br />
			<ul>
			<li><b>'.__('Now VPSID will remain same after successful migration. (i.e. New migrated VPS will get the OLD VPSID)').'</b></li>
			<li>'.__('It is recommended that you save the VPS data before starting this process as Virtualizor will <b>power off</b> the VPS to do the transfer.').'</li>
			<li>'.__('This process may take some time depending on the VPS size and transfer rate.').'</li>
			<li>'.__('You can navigate away from this page and check the status on the <b><a href="index.php?act=tasks">Tasks page</a></b>.').'</li>
			</ul>
			</font>
		</div>
		</div>';

		if(!empty($mprog)){
			echo '
			<div id="progress_onload">
			</div><br/>
			<div class="notice" id="complete" style="display:none;"><b>'.__('Note').' : </b> &nbsp; '.$migrate_lang[$selected_act[0].'_complete'].'
			</div><br/>
			<div class="notice mx-3" id="running"><b>'.__('Note').' : </b> &nbsp; '.__('You can navigate away from this page and check the status on the <b><a href="index.php?act=tasks">Tasks page</a></b>.').'
			</div><br/>';
		}

softfooter();

}

?>