<?php

//////////////////////////////////////////////////////////////
//===========================================================
// load_balancer_theme.php
//===========================================================
// SOFTACULOUS VIRTUALIZOR
// Version : 1.0
// Inspired by the DESIRE to be the BEST OF ALL
// ----------------------------------------------------------
// Started by: Alons
// Date:       8th Mar 2010
// Time:       23:00 hrs
// Site:       https://www.virtualizor.com/ (SOFTACULOUS VIRTUALIZOR)
// ----------------------------------------------------------
// Please Read the Terms of use at https://www.virtualizor.com
// ----------------------------------------------------------
//===========================================================
// (c)Softaculous Ltd.
//===========================================================
//////////////////////////////////////////////////////////////

if(!defined('VIRTUALIZOR')){

	die('Hacking Attempt');

}

function getSortHeader($header_name, $sort_column, $sort_column_by, $column ,$size = 90){

    global $theme, $globals;

    $str = '<div class="d-inline-flex align-items-center" style="width:'.$size.'px;">
        <div class="mr-2">
            <span class="" >'.$header_name.'</span>
        </div>
        <span class="sorter">
            <a class="text-always-white" href="'.$globals['index'].'act=user_plans&sortcolumn='.$column.'&sortby=asc"><i class="fas fa-sort-up"></i></a><br>
            <a class="text-always-white" href="'.$globals['index'].'act=user_plans&sortcolumn='.$column.'&sortby=desc"><i class="fas fa-sort-down"></i></a>
        </span>
    </div>';
    return $str;
}

function load_balancer_theme(){

global $theme, $globals, $cluster, $user, $l, $host, $current, $error, $done, $onboot, $load_balancer, $sort_column, $sort_column_by, $servers, $servergroups, $users;

softheader($l['<title>']);
										
$buttons = array(
	0 => array(
		'name' => __('Add Load Balancer'),
		'act'  => 'addvs&load_balancer=1'
	)
);

echo  page_header(__('Load Balancer'), 'fas fa-balance-scale-right', '', 1, 0, $buttons);

$breadcrumbs = array('dashboard', 'lm_load_balancer', 'lms_load_balancer');

echo get_breadcrumb($breadcrumbs);

error_handle($error);
echo'
<div class="card p-2 mx-3">
    <div id="showsearch" style="display:'.(optREQ('search') || (!empty($load_balancer) && !empty($globals['showsearch'])) ? "" : "none").';">
        <form accept-charset="'.$globals['charset'].'" name="load_balancer" id="load_balancer" method="GET" action="" class="form-horizontal">
            <input type="hidden" name="act" value="load_balancer"> 
            <div class="form-group_head">
                <div class="row mx-auto w-100">
                    <div class="col-sm-4">
                        <label>'.__('Load Balancer').'</label>
                        <input type="text" class="form-control" name="hostname" id="hostname" size="30" value="'.REQval('hostname','').'"/>
                    </div>
                    <div class="col-sm-4">
                        <label>'.__('User').'</label>
                        <select name="uid" class="form-control virt-select">
                            <option value="0" '.REQselect('uid', 0, true).'>---</option>';
                            foreach($users as $uid => $u){
                                echo '<option value='.$uid.' '.REQselect('uid', $uid).'>'.$u['email'].'</option>';
                            }
                            echo'
                        </select>
                    </div>
                    <div class="col-sm-4">
                        <label>'.__('Server Group').'</label>
                        <select name="sgid" class="form-control virt-select">
                            <option value="-1" '.REQselect('sgid', -1, true).'>---</option>';
                            foreach($servergroups as $sgid => $u){
                                echo '<option value='.$sgid.' '.REQselect('sgid', $sgid).'>'.$u['sg_name'].'</option>';
                            }
                            echo'
                        </select>
                    </div>
                </div>
                <div class="row mx-auto w-100 my-2">
                    <div class="col-sm-12 text-center">
                        <button type="submit" name="search" class="go_btn mt-2" value="Search">'.__('Search').'</button>
                    </div> 
                </div>
            </div>
        </form>
    </div>
';


if(empty($load_balancer) && empty($error)){
	optREQ('search') ? show_alert(__('No results were found for your search query'), "2") : show_alert(__('No Load Balancers'), "2");
	echo '<div class="notice"><b>'.__('Note').' : </b>&nbsp; '.(optREQ('search') ? __('No results were found for your search query') : __('No Load Balancers')).'</div>';
	
}elseif(!empty($load_balancer)){
    echo'
    <script>
    function lb_delete(lbuuid){
        msg = `'.__J('Are you sure you that you want to <b class=\'text-danger\'>delete</b> the load balancer').'<br>
        '.get_checkbox('delete_added_vm', __J('Delete added VPS from panel as well?'), 'delete_added_vm').'`;
        showalert(msg, 4, function(confirm){
            if(confirm == false){
                return false;
            }else{
                processing_symb(1);
                var is_checked = $("#delete_added_vm").prop("checked");
                $.ajax({
                    type: "POST",
                    url: "'.$globals['index'].'act=load_balancer&delete_lb="+lbuuid+(!empty(is_checked) ? "&delete_added_vm=1" : "")+"&api=json",
                    dataType : "json",
                    success:function(res){
                        processing_symb(0);
                        if("delete_lb_done" in res){
                            setTimeout(function(){ showalert("'.__J('The load balancer was removed successfully').'");
                                $("#alert-modal").on("hidden.bs.modal", function (e) {
                                    location.reload(true);
                                });
                            return; } ,200);
                        }
            
                        // Are there any errors ?
                        if(typeof(res["error"]) != "undefined"){
                            setTimeout(function(){ var errors = "";
                            for(x in res["error"]){
                                errors = errors + res["error"][x]+ "<br>";
                            }
                            showalert(errors ,"1"); } ,200);
                        }
                    }
                });
            }
        });
    }
    </script>
    <div class="row mx-auto w-100 mt-3">
	    <div class="col-sm-8 col-lg-8 col-md-6 mb-3 p-0">';
            page_links($globals['num_res'], $globals['cur_page'], $globals['reslen']);
        echo get_num_records($globals['num_res']).'
        </div>
    </div>
    <div class="w-100 mx-auto sticky">
        <table class="table table-hover tablesorter common-table">
            <tr class="table_heading">
                <th class="min_width">'.__('ID').'</th>
                <th>'.__('Load Balancer').'</th>
                <th>'.__('Load Balancer IP').'</th>
                <th>'.__('Number of VPS').'</th>
                <th>'.__('User').'</th>
                <th>'.__('Server Group').'</th>
                <th colspan="2">'.__('Manage').'</th>
            </tr>';
            foreach($load_balancer as $k => $v){
                echo '<tr>
                    <td class="pl-2">
                        '.$v['lbid'].'
                    </td>
                    <td>
                        '.$v['hostname'].' ('.$v['vpsid'].')
                    </td>
                    <td>
                        '.$v['ip'].'
                    </td>
                    <td>
                        '.$v['num_vps'].'
                    </td>
                    <td>
                        '.$v['email'].'
                    </td>
                    <td>
                        '.$v['sg_name'].'
                    </td>
                    <td align="center" width="24">
                        <div class="badge container">
                            <a class="badge badge-settings" href="'.$globals['index'].'act=manage_load_balancer&lb_uuid='.$v['vps_uuid'].'" title="'.__('Manage').'"><i class="fas fa-cog"></i></a>
                            <a class="badge badge-trash" href="javascript:void(0);" onclick="return lb_delete(\''.$v['vps_uuid'].'\');" title="Delete"><i class="fas fa-trash"></i></a>
                        </div>
                    </td>
                </tr>';
            }
            echo'
        </table>
    </div>
    <div id="progress_bar" style="display:none;">
        <br />
        <center>
            <font id="progress_txt" size="4">'.__('Please wait, Action in Progress.').'</font>
        </center>
        <div class="my-2" align="center">
            <div class="progress w-50">
                <div class="progress-bar bg-primary progress-bar-striped progress-bar-animated w-100">
                </div>
            </div>
        </div>
        <center>
            '.__('You will be notified once the Action is Completed.').'
        </center>
    </div>
';
}
echo '</div><br>';
softfooter();

}



