<?php

//////////////////////////////////////////////////////////////
//===========================================================
// editplan_theme.php
//===========================================================
// SOFTACULOUS VIRTUALIZOR
// Version : 1.0
// Inspired by the DESIRE to be the BEST OF ALL
// ----------------------------------------------------------
// Started by: Alons
// Date:       8th Mar 2010
// Time:       23:00 hrs
// Site:       https://www.virtualizor.com/ (SOFTACULOUS VIRTUALIZOR)
// ----------------------------------------------------------
// Please Read the Terms of use at https://www.virtualizor.com
// ----------------------------------------------------------
//===========================================================
// (c)Softaculous Ltd.
//===========================================================
//////////////////////////////////////////////////////////////

if(!defined('VIRTUALIZOR')){

	die('Hacking Attempt');

}

function editplan_theme(){

global $theme, $l, $globals, $kernel, $user, $error, $plan, $done, $_ubc, $mgs, $isos, $oslist, $vnc_keymap_array, $recipes, $backup_plans, $supported_nics, $servergroups, $ippools, $bus_driver_list, $ostemplates, $bios, $cpu_info, $firewall_plans, $firewall_users, $custom_cp;

softheader($l['<title>']);
					
echo page_header(__('Edit Plan'), 'fas fa-clipboard', '', 0, 0, '');

$breadcrumbs = array('dashboard', 'lm_plans', 'lms_editplan');

echo get_breadcrumb($breadcrumbs);

error_handle($error);

if(!empty($done)){
	show_alert(__('The Plan has been saved. Return to <a href="index.php?act=plans">Plans Overview</a>'), "0", "plans");
}

//decode VPS Data
$data_decode = json_decode($plan['data'],1);
echo '<script language="javascript" type="text/javascript">

var servergroups = '.json_encode($servergroups).';

var edit_done = "'.$done.'";

function toggle_advoptions(ele){
	
	var div_ele = $("#"+ele+"_advoptions");

	if (div_ele.is(":hidden")){
		$("#"+ele+"_advoptions_ind").text(" - ");
		div_ele.slideDown("slow");
	}
	else{
		$("#"+ele+"_advoptions_ind").text(" + ");
		div_ele.slideUp("slow");
	}
}

function prox_cpu_flags(){

	let virt = \''.$plan['virt'].'\';
	if(virt != "proxk"){
		return false;
	}
	
	let cpu = $("#cpu_mode").val();
	$(".hide_all_cpu_flags").hide();
	$("."+cpu).show();
};

$(document).ready(function(){

	toggle_driver_num($("#bus_driver").val());
	if(!empty(edit_done)){
		checkdemo();
	}

});

function adddnsrow(id, val){

var t = $_(id);
	var ele = document.createElement("div");
	ele.setAttribute("class","row mx-auto w-100 my-1");
	ele.innerHTML=\'<div class="col-sm-11 p-0"><input type="text" class="form-control w-100" name="dns[]"  value="\'+(val || "")+\'"  size="20" /></div><div class="col-sm-1 p-0">&nbsp;&nbsp;<a class="deldns" ><i class="fas fa-times text-danger cursor-pointer py-2"></i></a></div>\';
	t.appendChild(ele);
	var sp = document.createElement("span");
	sp.setAttribute("class","help-block");
	t.appendChild(sp);	
	del_dns_div("deldns");
};

function ispvonhvm(plan){

	if($("#tr_pvonhvm").css("display") == "none"){
		return true;
	}
	
	var pv_on_hvm = false;
	if(!$_("pv_on_hvm")){
		pv_on_hvm = false;
	}else{
		pv_on_hvm = $_("pv_on_hvm").checked;
	}
	
	if($_("tr_viftype")){
		if(pv_on_hvm == true){
			$_("tr_viftype").style.display = "none";
		}else{
			$_("tr_viftype").style.display = "";
		}
	}
	
	return true;
};

let toggle_bios = () => {
	
	let ele = $("#bios").val();

	if(ele === "uefi"){
		$("#tpm_row").show();
		showalert("'.__J('To create VPS using UEFI bios, please use ISO as our default template won’t work with UEFI bios option. After creating VPS from ISO, resize will not be possible. Template creation will not work for VPS with UEFI bios.').'","2");
	}else{
		$("#tpm_row").hide();
	}		
	
}

function changeplan(plan){
	$(".openvz, .kvm, .xen, .xenhvm, .xcp, .xcphvm, .lxc, .vzk, .vzo, .proxk, .proxl, .proxo").hide();
	$("." + plan).show();
	
	$("#disk_space_col").attr("class", "");
	if(plan == "proxk"){
		$("#disk_space_col").attr("class", "col-sm-3 pr-0 ml-1");
		$("#disk_space").css("width", "50%");
	}else{
		$("#disk_space_col").attr("class", "col-sm-6 p-0");
		$("#disk_space").css("width", "");
	}
	
	$("#mgs option").each(function(){
		if($(this).attr("type") != plan){
			$(this).attr("disabled","disabled");
			$(this).css("display","none");
		}else{
			$(this).attr("disabled", false);
			$(this).css("display","block");
		}
	});	
	prox_cpu_flags();
};

function changepriority(priority){
	if(!$("#prior")){
		return;
	}
	if (priority != ""){
		$_("prior").value = priority;
	}
};

function ishvm(){
	var hvm = false;
	var tmp_hvm = "'.$plan['virt'].'";
	var n = tmp_hvm.search(/hvm/i); 
	if(n > 0){
		hvm = true;
	}
	
	if($_("isorow")){
		if(hvm == true || tmp_hvm == "kvm" || tmp_hvm == "proxk"){
			$_("isorow").style.display = "";
		}else{
			$_("isorow").style.display = "none";
		}
	}
	
	$("#osid").select2("destroy");
	$("#osid").select2({
		width:"100%",
		templateResult: function(option) {
			var myOption = $("#osid").find("option[value=\"" + option.id + "\"]");
			
			if ((myOption.attr("virt") != "undefined") && (hvm == true || hvm == false) && (myOption.attr("virt") == tmp_hvm)) {
				return option.text;
			}else if ((myOption.attr("value") == 0)) {
				return option.text;
			}
		}
	});

	//alert(vpsid + " -- " + hvm)
	
	return false;
};

function ubcEdit(){
	if($("#ubcsettings").prop("checked")){
		$("#ubc_advoptions input:text").prop("disabled", false);
	}else{
		$("#ubc_advoptions input:text").prop("disabled", true);
	}
}

function change_cpu_topology(){
	
	if($("#enable_cpu_topology").prop("checked")){
		$("#cpu_topology").css("display", "");
	}else{
		$("#cpu_topology").css("display", "none");
		$("#topology_sockets").val(0);
		$("#topology_cores").val(0);
		$("#topology_threads").val(0);
	}
}

function toggle_driver_num(driver_type){
	
	if(empty(driver_type)){
		return false;
	}
	$(".ide, .sata, .virtio, .scsi").hide();
	$(".driver_type").show();

	$("#bus_driver_num").val(0);
	if(driver_type == "ide"){
		$("#bus_driver_num").val(2);
	}

	if(driver_type == "virtio"){
		$("#ssd_emulation").prop("checked", false);
		$(".ssd_emulation").hide();
	}else{
		$(".ssd_emulation").show();
	}

	if(driver_type == "scsi"){
 		$(".scsi_controller").show();
	}else{
		$("#scsi_controller").val("");
		$(".scsi_controller").hide();
	}
};

$(document).ready(function(){
	toggle_driver_num("'.$plan['bus_driver'].'");
});

function checkcputhreshold(){

	if($("#enable_cpu_threshold").prop("checked")){
		$("#cputhresholdpercentage").css("display", "");
		$("#enable_cpu_threshold").val(1);
	}else{
		$("#cputhresholdpercentage").css("display", "none");
		$("#cpu_threshold").val(0);
		$("#cpu_threshold_time").val(0);
	}

};

var lang_no_limit = "'.__J('No Restriction').'";
addonload("changepriority(\''.POSTval('priority', $plan['io']).'\');change_cpu_topology();checkcputhreshold();");
addonload("handle_capping(); fillspeedkBps(); changeplan(\''.$plan['virt'].'\');enable_accel();ishvm();ispvonhvm();ubcEdit();");
$(document).ready(function(){
	enable_vertical_scaling();
});

function checkdemo(){
	if(!$("#demo")){
		return false;
	}
	if(is_checked("demo")){
		$("#demo_duration").show();
		$("#demo_days").show();
		$("#demo_action_options").show();
	}else{
		$("#demo_duration").hide();
		$("#demo_days").hide();
		$("#demo_action_options").hide();
	}	
};

function change_checkbox(id){
	if(is_checked(id)){
		$("#hidden_"+id).val(1);
	}else{
		$("#hidden_"+id).val(0);
	}
};
</script>

<form accept-charset="'.$globals['charset'].'" name="editplan" id="editplan" method="post" action="" class="form-horizontal">

<div class="row mx-auto w-100 mb-3">
	<div class="col-sm-12 col-md-12 col-lg-6">
		<div class="roundheader cursor-pointer" onclick="toggle_advoptions(\'general\');"><label id="general_advoptions_ind" class="min_width">-</label> &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'.__('General Settings').'</div>
		<div id="general_advoptions" class="w-100 bgaddv">	
			<div class="row mx-auto w-100 my-3">
				<div class="col-6 p-0">
					<label class="control-label">'.__('Enable Plan').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If enabled, then this plan will be available to the Cloud User for creating vps').'"><i class="fas text-primary fa-info-circle"></i></a></label>
				</div>
				<div class="col-6 p-0">
					'.get_checkbox('is_enabled', '', 'is_enabled', array('chk_it' => 1, 'val' => $plan['is_enabled'])).'
				</div>
			</div>
			<div class="row mx-auto w-100 my-3">
				<div class="col-sm-6 p-0">
					<label class="control-label">'.__('Plan Name').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('The name of this plan').'"><i class="fas text-primary fa-info-circle"></i></a></label>
				</div>
				<div class="col-sm-6 p-0">
					<input type="text" class="w-100 form-control side_text" name="plan_name" id="plan_name" size="30" value="'.POSTval('plan_name', $plan['plan_name']).'" />
				</div>
			</div>
			<div class="row mx-auto w-100 my-3">
				<div class="col-sm-6 p-0">
					<label class="control-label">'.__('Plan Type').'</label>
				</div>
				<div class="col-sm-6 p-0">
					<script>document.write(show_virtname("'.$plan['virt'].'", "18px"))</script>
				</div>
			</div>';

		if(!empty($backup_plans)){
			
			echo '
			<div class="row mx-auto w-100 my-3">
				<div class="col-sm-6 p-0">
					<label class="control-label">'.__('Backup Plan').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Select Backup Plan for the VPS').'"><i class="fas text-primary fa-info-circle"></i></a></label>
				</div>
				<div class="col-sm-6 p-0">
					<select class="custom-select virt-select w-100 side_text" name="bpid" id="bpid">
					<option value=0 '.(POSTval('bpid') == 0 ? 'selected="selected"' : '').'>'.__('Select Backup Plan').'</option>';
						foreach($backup_plans as $k => $v){
							echo '<option value="'.$k.'" '.(POSTval('bpid') == $k ? 'selected="selected"' : (empty($_POST) && $plan['bpid'] == $k ? 'selected="selected"' : '')).'>'.$v['plan_name'].'</option>';
						}
					echo '</select>
				</div>
			</div>';
		}

		if(!empty($firewall_plans)){
								
			echo '
			<div class="row mx-auto w-100 my-3"> 
				<div class="col-sm-6 p-0">
					<label class="control-label">'.__('Firewall Plan').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Select Firewall Plan for the VPS').'"><i class="fas text-primary fa-info-circle"></i></a></label>
				</div>
				<div class="col-sm-6 p-0 server-select-lg">
					<select class="custom-select w-100 side_text virt-select" id="fwid" name="fwid">
					<option value="0" '.(POSTval('fwid') == 0 ? 'selected="selected"' : '').'>'.__('None').'</option>';
					$current_user = -1;

					foreach($firewall_plans as $k => $v){

						$firewall_plan_creator = empty($v["uid"]) ? "root" : $firewall_users[$v["uid"]];

						if($current_user != $v['uid']){

							if($current_user != -1){
								echo '</optgroup>';
							}	
							
							echo '<optgroup label="'.$firewall_plan_creator.'">';

							$current_user = $v['uid'];
							
						}

						echo '<option value="'.$k.'" '.(POSTval('fwid') == $k ? 'selected="selected"' : (empty($_POST) && $plan['fwid'] == $k ? 'selected="selected"' : '')).'>'.$v['fw_plan_name'].'</option>';
					}

					echo '</optgroup>';
				
				echo '</select>
				</div>
			</div>';
		
		}

		echo '
		<div class="row mx-auto w-100 my-3">
			<div class="col-sm-6 p-0">
				<label class="control-label">'.__('Operating System').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Select the Operating System for the VPS').'"><i class="fas text-primary fa-info-circle"></i></a></label>
			</div>
			<div class="col-sm-6 p-0">
				<select class="custom-select w-100 virt-select side_text" id="osid" name="osid">
					<option value="0" '.(POSTval('osid')== 0 ?  'selected="selected"' :($plan['osid']== 0 ? 'selected="selected"' : '')).'>'.__('Select OS').'</option>';
					if(!empty($ostemplates)){
						foreach($ostemplates as $k => $v){
							echo '<option value="'.$k.'" '.(POSTval('osid') == $k ? 'selected="selected"' : ($plan['osid'] == $k ? 'selected="selected"' : '')).' '.(!empty($v['hvm']) ? 'hvm="1"' : '').' virt="'.$v['type'].(!empty($v['hvm']) ? 'hvm' : '').'">'.(!empty($v['hvm']) ? 'HVM - ' : '').''.$v['name'].is_custom_os($k).'</option>';
						}
					}
			echo'</select>
			</div>
		</div>';

		if(!empty($isos)){
			echo '<div class="row mx-auto w-100 my-3 kvm xenhvm xcphvm vzk proxk" id="isorow">
				<div class="col-sm-6 p-0">
					<label class="control-label">'.__('ISO').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If an ISO is selected the machine will be booted from that ISO').'"><i class="fas text-primary fa-info-circle"></i></a></label>
				</div>
				<div class="col-sm-6 p-0">
					<select class="custom-select w-100 side_text" name="iso">
					<option value="0" '.(POSTval('iso') == 0 ? 'selected="selected"' : '').'>'.__('None').'</option>';
					
					foreach($isos as $k => $v){	
						echo '<option value="'.$k.'" '.(POSTval('iso') == $k ? 'selected="selected"' : ($plan['iso'] == $k ? 'selected="selected"' : '')).'>'.$v['name'].'</option>';
					}
					
				echo'</select>
				</div>
			</div>';

		}

		echo '
		<div class="row mx-auto w-100 my-3">
			<div class="col-sm-6 p-0">
				<label class="control-label">'.__('Disk Space').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('The allowed disk space for the VPS').'"><i class="fas text-primary fa-info-circle"></i></a></label>
			</div>
			<div class="proxk row col-sm-3 p-0 ml-1">
					<div class="col-sm-6 pl-0 pr-1">
					<select class="custom-select bus_driver" id="bus_driver" name="bus_driver" onchange="toggle_driver_num(this.value)" >';					
						foreach($bus_driver_list as $bdk => $bdv){
							echo '<option value="'.$bdk.'" '.(POSTval('bus_driver') == $bdk ? 'selected="selected"' : ($plan['bus_driver'] == $bdk ? 'selected="selected"' : '')).' >'.$bdv.'</option>';
						}
			echo   '</select>
				</div>	
					<div class="col-sm-6 pr-0 pl-1">	
							<select class="custom-select bus_driver_num" id="bus_driver_num" name="bus_driver_num" >';
								echo '<option class="sata virtio scsi" value="0" '.(POSTval('bus_driver_num') == 0 ? 'selected="selected"' : ($plan['bus_driver_num'] == 0 ? 'selected="selected"' : '')).'>0</option>';
								echo '<option class="sata virtio scsi" value="1" '.(POSTval('bus_driver_num') == 1 ? 'selected="selected"' : ($plan['bus_driver_num'] == 1 ? 'selected="selected"' : '')).'>1</option>';
								echo '<option class="ide sata virtio scsi" value="2" '.(POSTval('bus_driver_num') == 2 ? 'selected="selected"' : ($plan['bus_driver_num'] == 2 ? 'selected="selected"' : '')).'>2</option>';
								echo '<option class="ide sata virtio scsi" value="3" '.(POSTval('bus_driver_num') == 3 ? 'selected="selected"' : ($plan['bus_driver_num'] == 3 ? 'selected="selected"' : '')).'>3</option>';
								echo '<option class="virtio scsi" value="4" '.(POSTval('bus_driver_num') == 4 ? 'selected="selected"' : ($plan['bus_driver_num'] == 4 ? 'selected="selected"' : '')).'>4</option>';
								echo '<option class="sata virtio scsi" value="5" '.(POSTval('bus_driver_num') == 5 ? 'selected="selected"' : ($plan['bus_driver_num'] == 5 ? 'selected="selected"' : '')).'>5</option>';
								echo '<option class="virtio scsi" value="6" '.(POSTval('bus_driver_num') == 6 ? 'selected="selected"' : ($plan['bus_driver_num'] == 6 ? 'selected="selected"' : '')).'>6</option>';
								echo '<option class="virtio scsi" value="7" '.(POSTval('bus_driver_num') == 7 ? 'selected="selected"' : ($plan['bus_driver_num'] == 7 ? 'selected="selected"' : '')).'>7</option>';
								echo '<option class="virtio scsi" value="8" '.(POSTval('bus_driver_num') == 8 ? 'selected="selected"' : ($plan['bus_driver_num'] == 8 ? 'selected="selected"' : '')).'>8</option>';
								echo '<option class="virtio scsi" value="9" '.(POSTval('bus_driver_num') == 9 ? 'selected="selected"' : ($plan['bus_driver_num'] == 9 ? 'selected="selected"' : '')).'>9</option>';
								echo '<option class="virtio scsi" value="10" '.(POSTval('bus_driver_num') == 10 ? 'selected="selected"' : ($plan['bus_driver_num'] == 10 ? 'selected="selected"' : '')).'>10</option>';
								echo '<option class="virtio scsi" value="11" '.(POSTval('bus_driver_num') == 11 ? 'selected="selected"' : ($plan['bus_driver_num'] == 11 ? 'selected="selected"' : '')).'>11</option>';
								echo '<option class="virtio scsi" value="12" '.(POSTval('bus_driver_num') == 12 ? 'selected="selected"' : ($plan['bus_driver_num'] == 12 ? 'selected="selected"' : '')).'>12</option>';
								echo '<option class="virtio scsi" value="13" '.(POSTval('bus_driver_num') == 13 ? 'selected="selected"' : ($plan['bus_driver_num'] == 13 ? 'selected="selected"' : '')).'>13</option>';
								echo '<option class="virtio" value="14" '.(POSTval('bus_driver_num') == 14 ? 'selected="selected"' : ($plan['bus_driver_num'] == 14 ? 'selected="selected"' : '')).'>14</option>';
								echo '<option class="virtio" value="15" '.(POSTval('bus_driver_num') == 15 ? 'selected="selected"' : ($plan['bus_driver_num'] == 15 ? 'selected="selected"' : '')).'>15</option>';
					echo	'
							</select>
			</div>
			</div>
			<div id="disk_space_col" class="col-sm-3 pr-0 ml-2">
				<div class="input-group ">
					<input type="number" step="0.001" class="form-control rounded" name="disk_space" id="disk_space" size="10" value="'.POSTval('disk_space', $plan['space']).'" />
					<div class="input-group-append">
							<span class="input-group-text">GB</span>
					</div>
				</div>
			</div>
		</div>

		<div class="row mx-auto w-100 my-3 scsi_controller proxk" >
			<div class="col-sm-6 p-0">
				<label class="control-label">'.__('SCSI Controller').'</label>
			</div>
			<div class="col-sm-6 p-0">
				<select id="scsi_controller" name="scsi_controller" class="custom-select">
					<option value="">'.__('None').'</option>
					<option value="virtio-scsi-pci" '	.(($data_decode['scsi_controller'] == 'virtio-scsi-pci')? 	 'selected = "selected"' : '').'> VirtIO SCSI </option>
					<option value="lsi" '			 	.(($data_decode['scsi_controller'] == 'lsi')? 				 'selected = "selected"' : '').'> LSI 53C895A </option>
					<option value="lsi53c810" '		 	.(($data_decode['scsi_controller'] == 'lsi53c810')? 		 'selected = "selected"' : '').'> LSI 53C810 </option>
					<option value="megasas" '		 	.(($data_decode['scsi_controller'] == 'megasas')? 			 'selected = "selected"' : '').'> MegaRAID SAS 8708EM2 </option>
					<option value="virtio-scsi-single" '.(($data_decode['scsi_controller'] == 'virtio-scsi-single')?'selected = "selected"' : '').'> VirtIO SCSI single </option>
					<option value="pvscsi" '			.(($data_decode['scsi_controller'] == 'pvscsi')? 			 'selected = "selected"' : '').'> VMware PVSCSI </option>
				</select>							
			</div>
		</div>
		<div class="row mx-auto w-100 my-3">
			<div class="col-sm-6 p-0">
				<label class="control-label">'.__('Guaranteed RAM').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('The amount of RAM which the VPS will always have').'"><i class="fas text-primary fa-info-circle"></i></a></label>
			</div>
			<div class="col-sm-6 p-0">
				<div class="input-group ">
					<input type="number" class="form-control side_text" name="guaranteed_ram" id="guaranteed_ram" size="10" value="'.POSTval('guaranteed_ram', $plan['ram']).'" />
					<div class="input-group-append">
							<span class="input-group-text">MB</span>
					</div>
				</div>
			</div>	
		</div>

		<div class="row mx-auto w-100 my-3 proxk" id="minram">
			<div class="col-sm-6 p-0">
				<label class="control-label">'.__('Minimum RAM').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Supported only on Proxmox 7 and above').'"><i class="fas text-primary fa-info-circle"></i></a></label>
			</div>
			<div class="col-sm-6 p-0">
				<div class="input-group ">
					<input type="number" class="form-control side_text" name="min_ram" id="min_ram" size="10" value="'.POSTval('min_ram', $data_decode['min_ram']).'" />
					<div class="input-group-append">
							<span class="input-group-text">MB</span>
					</div>
				</div>
			</div>
		</div>

		<div class="row mx-auto w-100 my-3 kvm xen xenhvm xcp xcphvm lxc vzk vzo proxk proxo proxl" id="swap">
			<div class="col-sm-6 p-0">
				<label class="control-label">'.__('SWAP Ram').'</label>
			</div>
			<div class="col-sm-6 p-0">
				<div class="input-group ">
					<input type="number" class="form-control rounded" name="swapram" id="swapram" size="10" value="'.POSTval('swapram', $plan['swap']).'" />
					<div class="input-group-append">
							<span class="input-group-text">MB</span>
					</div>
				</div>
			</div>	
		</div>

		<div class="row mx-auto w-100 my-3 openvz" id="burst">
			<div class="col-sm-6 p-0">
				<label class="control-label">'.__('Burstable RAM').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('The maximum amount of RAM which the VPS can use').'"><i class="fas text-primary fa-info-circle"></i></a></label>
			</div>
			<div class="col-sm-6 p-0">
				<div class="input-group ">
					<input type="number" class="form-control side_text" name="burst_ram" id="burst_ram" size="10" value="'.POSTval('burst_ram', $plan['burst']).'" />
					<div class="input-group-append">
							<span class="input-group-text">MB</span>
					</div>
				</div>
			</div>
		</div>		

		<div class="row mx-auto w-100 my-3">
			<div class="col-sm-6 p-0">
				<label class="control-label">'.__('Bandwidth').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Monthly Bandwidth limit of the VPS').'"><i class="fas text-primary fa-info-circle"></i></a></label>
			</div>
			<div class="col-sm-6 p-0">
				<div class="input-group ">
					<input type="number" class="form-control side_text" name="bandwidth" id="bandwidth" size="10" value="'.POSTval('bandwidth', $plan['bandwidth']).'" onchange="handle_capping();" />
					<div class="input-group-append">
							<span class="input-group-text">GB</span>
					</div>
				</div>
			</div>	
		</div>

		<script type="text/javascript">
		function netspeed(r){
			$_("network_speed").value = r;
			handle_capping();
		}
		function upspeed(r){
			$_("upload_speed").value = (r);
			handle_capping();
		}

		function enable_accel(){
			
			if($_("kvm_vga").checked == true){
				$_("enable_acceleration").style.display = "";
				$_("set_vga_vram").style.display = "";
			}else{
				$_("enable_acceleration").style.display = "none";
				$_("set_vga_vram").style.display = "none";
			}

		}

		$("#hvm").change(function(data){
			if(data.target.checked){
				$("#tr_viftype").show();
				$("#tr_pvonhvm").show();
			}else if(!data.target.checked){
				$("#tr_viftype").hide();
				$("#tr_pvonhvm").hide();
			}
			
		});
		
		</script>

		<div class="row mx-auto w-100 my-3">
			<div class="col-sm-6 p-0">
				<label class="control-label">'.__('Network Speed').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Enter 0 or leave empty for no restriction. <br />Use the select box for easy options').'"><i class="fas text-primary fa-info-circle"></i></a></label>
			</div>
			<div class="col-sm-6 p-0">
				<div class="input-group w-100">
					<input type="number" class="form-control rounded rounded-right" name="network_speed" id="network_speed" size="8" value="'.POSTval('network_speed', $plan['network_speed']).'" onchange="handle_capping();" />
					<div class="input-group-append w-50">
						<span class="square mr-1">'.__('KB/s').'</span>
						<select class="custom-select w-75 speedkBps" name="network_speed2" id="network_speed2" onchange="netspeed(this.value)"></select>
					</div>
				</div>
			</div>
		</div>

		<div class="row mx-auto w-100 my-3" id="cpunits">
			<div class="col-sm-6 p-0">
				<label class="control-label">'.__('CPU Units').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('CPU units to be allocated').'"><i class="fas text-primary fa-info-circle"></i></a></label><br>
						<span class="help-block">
						<a href="'.$globals['docs'].'creating-a-vps#cpu-parameters" target="_blank">'.__('Need more info ?').'</a>
			</div>
			<div class="col-sm-6 p-0">
				<div class="input-group ">
					<input type="number" class="form-control rounded rounded-right" name="cpu_units" id="cpu_units" size="10" value="'.POSTval('cpu_units', $plan['cpu']).'" />
					<div class="input-group-append">
					<span class="square">Units</span>
					</div>
				</div>
			</div>	
		</div>

		<div class="row mx-auto w-100 my-3">
			<div class="col-sm-6 p-0">
				<label class="control-label">'.__('CPU Cores').'</label><br>
						<span class="help-block"><a href="'.$globals['docs'].'creating-a-vps#cpu-parameters" target="_blank">'.__('Need more info ?').'</a></span>
			</div>
			<div class="col-sm-6 p-0">
				<input type="number" class="form-control w-100 side_text" name="cpu_cores" id="cpu_cores" size="10" value="'.POSTval('cpu_cores', $plan['cores']).'" />
			</div>	
		</div>

		<div class="row mx-auto w-100 my-3 kvm openvz proxk proxl vzk vzo xcp xen" id="cpupercent">
			<div class="col-sm-6 p-0">
				<label class="control-label">'.__('CPU %').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('The CPU time in percent the corresponding VPS is not allowed to exceed. <br />Set <b>0</b> for no restriction.').'"><i class="fas text-primary fa-info-circle"></i></a></label><br>
						<span class="help-block">
						<a href="'.$globals['docs'].'creating-a-vps#cpu-parameters" target="_blank">'.__('Need more info ?').'</a>
						</span>
			</div>
			<div class="col-sm-6 p-0">
				<div class="input-group ">
					<input type="number" class="form-control rounded" name="percent_cpu" id="percent_cpu" size="10" value="'.POSTval('percent_cpu', $plan['cpu_percent']).'" />
					<div class="input-group-append">
						<span class="square">%</span>
					</div>
				</div>
			</div>
		</div>

		<div class="row mx-auto w-100 my-3 openvz vzo vzk proxo" id="priority">
			<div class="col-sm-6 p-0">
				<label class="control-label">'.__('I/O priority').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Choose priority from 0-7').'"><i class="fas text-primary fa-info-circle"></i></a></label>
			</div>
			<div class="col-sm-6 p-0">
				<select id="prior" name="priority" class="custom-select w-100 side_text">
					<option value="0">0</option>
					<option value="1">1</option>
					<option value="2">2</option>
					<option value="3">3</option>
					<option value="4">4</option>
					<option value="5">5</option>
					<option value="6">6</option>
					<option value="7">7</option>
				</select>
			</div>
		</div>

		<div class="row mx-auto w-100 my-3">
			<div class="col-sm-6 p-0">
				<label class="control-label">'.__('Number of IPs').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Specify any positive integer. If nothing is specified (or 0), you will have to select the IPs when creating a VPS.').'"><i class="fas text-primary fa-info-circle"></i></a></label>
			</div>
			<div class="col-sm-6 p-0">
				<input type="number" class="form-control w-100 side_text" name="ips" size="10" value="'.POSTval('ips', $plan['ips']).'" />
			</div>
		</div>

		<div class="row mx-auto w-100 my-3">
			<div class="col-sm-6 p-0">
				<label class="control-label">'.__('Number of IPv6 Subnets').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Specify any positive integer. If nothing is specified (or 0), you will have to select the IPs when creating a VPS.').'"><i class="fas text-primary fa-info-circle"></i></a></label>
			</div>
			<div class="col-sm-6 p-0">
				<input type="number" class="form-control w-100 side_text" name="ips6_subnet" size="10" value="'.POSTval('ips6_subnet', $plan['ips6_subnet']).'" />
			</div>
		</div>

		<div class="row mx-auto w-100 my-3">
			<div class="col-sm-6 p-0">
				<label class="control-label">'.__('Number of IPv6 Addresses').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Specify any positive integer. If nothing is specified (or 0), you will have to select the IPs when creating a VPS.').'"><i class="fas text-primary fa-info-circle"></i></a></label>
			</div>
			<div class="col-sm-6 p-0">
				<input type="number" class="form-control w-100 side_text" name="ips6" size="10" value="'.POSTval('ips6', $plan['ips6']).'" />
			</div>
		</div>

		<div class="row mx-auto w-100 my-3">
			<div class="col-sm-6 p-0">
				<label class="control-label">'.__('Number of Internal IPs').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Specify any positive integer. If nothing is specified (or 0), you will have to select the Internal IPs when creating a VPS.').'"><i class="fas text-primary fa-info-circle"></i></a></label>
			</div>
			<div class="col-sm-6 p-0">
				<input type="number" class="form-control w-100 side_text" name="ips_int" size="10" value="'.POSTval('ips_int', $plan['ips_int']).'" />
			</div>
		</div>
		<div class="row mx-auto w-100 my-3 kvm vzk" id="virtio_settings">
			<div class="col-6 p-0">
				<label class="control-label">'.__('Select Disk driver').'&nbsp;
					<a class="info" data-placement="right" tooltip="'.__('Use <b>virtio</b> for virtio drivers<br>Use <b>scsi</b> for disk drivers. Fstrim will work <b>ONLY</b> if scsi is selected and storage is thin.<br>If None is checked IDE will be selected').'"><i class="fas text-primary fa-info-circle"></i>
					</a>
				</label><br>
			</div>
			<div class="col-2 p-0">
				<label class="custom-control custom-radio">
					<input type="radio" class="custom-control-input" id="disk_driver_none" name="virtio" value="0"   '.(POSTval('virtio', $plan['virtio']) == '0' ? 'checked="checked"' : '').'>
					<span class="custom-control-label" for="disk_driver_none">'.__('None').'</span>
				</label> 
			</div>
			<div class="col-2 p-0">
				<label class="custom-control custom-radio">
					<input type="radio" class="custom-control-input" id="virtio" name="virtio" value="1"   '.(POSTval('virtio', $plan['virtio']) == '1' ? 'checked="checked"' : '').'>
					<span class="custom-control-label" for="virtio">'.__('virtio').'</span>
				</label>
			</div>
			<div class="col-2 p-0">
				<label class="custom-control custom-radio">
					<input type="radio" class="custom-control-input" id="scsi" name="virtio" value="2"   '.(POSTval('virtio', $plan['virtio']) == '2' ? 'checked="checked"' : '').'>
					<span class="custom-control-label" for="scsi">'.__('scsi').'</span>
				</label>
			</div>
		</div>
		<div class="row mx-auto w-100 my-3 vnc_div kvm xen xenhvm xcp xcphvm proxk vzk vzo">
			<div class="col-6 p-0">
				<label class="control-label">VNC</label>
				<span class="help-block">&nbsp;</span>
			</div>
			<div class="col-6 p-0">
				'.get_checkbox('vnc', '', 'vnc', array('chk_it' => 1, 'val' => $plan['vnc'])).'
			</div>
		</div>
		<div class="row mx-auto w-100 my-3 xenhvm" id="shadow_div">
			<div class="col-sm-6 p-0">
				<label class="control-label">'.__('Shadow Memory').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Recommended value : 8 MB').'"><i class="fas text-primary fa-info-circle"></i></a></label>
			</div>
			<div class="col-sm-6 p-0">
				<input type="number" class="form-control side_text" name="shadow" size="10" value="'.POSTval('shadow', $plan['shadow']).'" /><label class="side_lbl">MB</label>
			</div>
		</div>';
		$ploop_flag = ($globals['ploop'] ? 'checked="checked" disabled="disabled"' : '');
		echo'
		<div class="row mx-auto w-100 my-3 openvz">
			<div class="col-6 p-0">
				<label class="control-label">'.__('Ploop').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If enabled, VPS will be created with the Ploop format').'"><i class="fas text-primary fa-info-circle"></i></a></label>
			</div>
			<div class="col-6 p-0">
				'.get_checkbox('ploop', '', '', array('chk_it' => 1, 'val' => $plan['ploop']), 1, '', array($ploop_flag)).'
			</div>
		</div>
		';
		if(($globals['is_master_only'] == 1) || check_licensepro()){
			echo '
			<div class="row mx-auto w-100 my-3 kvm proxk vzk">
				<div class="col-6 p-0">
					<label class="control-label">'.__('Create as load balancer').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If checked then VPS will be created with load balancer service enabled').'"><i class="fas text-primary fa-info-circle"></i></a></label>
				</div>
				<div class="col-6 p-0">
					'.get_checkbox('load_balancer', '', 'load_balancer', array('chk_it' => 1, 'val' => $plan['load_balancer'])).'
				</div>
			</div>';
		}	
		echo'
		<div class="row mx-auto w-100 my-3 kvm_hvm_div kvm xenhvm xcphvm">
			<div class="col-6 p-0">
				<label class="control-label">'.__('ACPI').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('ACPI is used to send shutdown signal to the Virtual Machines. ACPI is required for Virtual Machines so that they can react to such signals').'"><i class="fas text-primary fa-info-circle"></i></a></label>
			</div>
			<div class="col-6 p-0">
				'.get_checkbox('acpi', '', '', array('chk_it' => 1, 'val' => $plan['acpi'])).'
			</div>
		</div>
		<div class="row mx-auto w-100 my-3 kvm_hvm_div kvm xenhvm xcphvm">
			<div class="col-6 p-0">
				<label class="control-label">'.__('APIC').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Advanced Programmable Interrupt Controller improves virtualized AMD64 and Intel 64 guest performance by allowing the guest to directly access the APIC, dramatically cutting down interrupt latencies and the number of virtual machine exits caused by the APIC').'"><i class="fas text-primary fa-info-circle"></i></a></label>
			</div>
			<div class="col-6 p-0">
				'.get_checkbox('apic', '', '', array('chk_it' => 1, 'val' => $plan['apic'])).'
			</div>
		</div>
		<div class="row mx-auto w-100 my-3 kvm_hvm_div kvm xenhvm xcphvm">
			<div class="col-6 p-0">
				<label class="control-label">'.__('PAE').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Physical address extension mode allows 32-bit guest virtual machines to address more than 4 GB of memory').'"><i class="fas text-primary fa-info-circle"></i></a></label>
			</div>
			<div class="col-6 p-0">
				'.get_checkbox('pae', '', '', array('chk_it' => 1, 'val' => $plan['pae'])).'
			</div>
		</div>
		<div class="row mx-auto w-100 my-3">
			<div class="col-sm-6 p-0">
				<label class="control-label">'.__('Media Groups').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If no Media Group is assigned then all Media will be available to this VPS.').'"><i class="fas text-primary fa-info-circle"></i></a></label>
			</div>
			<div class="col-sm-6 p-0">
				<select class="virt-select w-100" name="mgs[]" id="mgs" multiple="multiple">';
					$tmp_mgs = empty($_POST['mgs']) ? $plan['mgs'] : $_POST['mgs'];
					foreach($mgs as $mk => $mv){
						echo '<option value="'.$mk.'" type="'.$mv['mg_type'].'" '.(in_array($mk, @$tmp_mgs) ? 'selected="selected"' : '').'>'.$mv['mg_name'].'</option>';
					}
					
				echo '</select>
			</div>
		</div>
		</div><br>
		
		
		<div class="openvz_ubc openvz" style="display:none;" id="ubc">
			<div class="roundheader cursor-pointer" onclick="toggle_advoptions(\'ubc\');"><label id="ubc_advoptions_ind" class="min_width">-</label> &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'.__('UBC Settings').'</div>
			<div id="ubc_advoptions" class="w-100 bgaddv">
				<div class="row mx-auto w-100 my-3" id="ubc">
					<div class="col-6 p-0">
						<label class="control-label">'.__('UBC Settings').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Check this if you want to save the UBC Settings').'"><i class="fas text-primary fa-info-circle"></i></a></label>
					</div>
					<div class="col-6 p-0">
						'.get_checkbox('ubcsettings', '', 'ubcsettings', array('chk_it' => 1, 'val' => (!empty($plan['ubc']) ? 1 : 0)), 1, '', array('onchange="ubcEdit();"')).'
					</div>
				</div>
				<div class="row mx-auto w-100 my-3">
					<div class="col-4 p-0"></div>
					<div class="col-4">
						<label class="control-label">'.__('Barrier').'</label>
					</div>
					<div class="col-4">
						<label class="control-label">'.__('Limit').'</label>
					</div>
				</div>';
			
				foreach($_ubc as $k){
					
					echo '<div class="row mx-auto w-100 my-3">
					<div class="col-4 p-0">
							<label class="control-label">'.$k.'</label></div>
						<div class="col-4 pl-0">
							<input type="text" class="form-control w-100" name="b'.$k.'" id="b'.$k.'" size="30" value="'.POSTval('b'.$k, @$plan['ubc'][$k][0]).'" />
							<span class="help-block"></span>
						</div>
						<div class="col-4 pr-0">
							<input type="text" class="form-control w-100" name="l'.$k.'" id="l'.$k.'" size="30" value="'.POSTval('l'.$k, @$plan['ubc'][$k][1]).'" />
						</div>
					</div>';	
				}
		echo '</div>
		</div><br>		
	</div>
	<div class="col-sm-12 col-md-12 col-lg-6">
		';
		$allcores_flag = (!empty($_POST) ? (is_array($_POST['cpupin']) ? '' : 'checked="checked"') : 'checked="checked"');
		echo'
		<div class="roundheader cursor-pointer" onclick="toggle_advoptions(\'adv\');"><label id="adv_advoptions_ind" class="min_width">-</label> &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'.__('Advanced Options').'</div>
		<div id="adv_advoptions" class="w-100 bgaddv">
			<!--<div class="row mx-auto w-100 my-3">
				<div class="col-6">
					<label class="control-label">'.__('CPU Affinity').'</label>
					<span class="help-block">'.__('Pin the particular CPU Cores to this VPS. You can choose multiple CPU Cores.').'</span>
				</div>
				<div class="col-6">
					'.get_checkbox('allcores', '', 'allcores', array('chk_it' => 0), -1, '', array($allcores_flag, 'onchange="pincheck();')).'
				</div>
			</div>
			<div id="pincores" class="row mx-auto w-100 my-3">
				<div class="col-6">
					<label class="control-label">'.__('Select the vCPU').'</label>
				</div>
				
				<div class="col-6">';
				for($i=0; $i < $resources['cpucores']; $i++){
					$cpucores_flag = (in_array($i, @$_POST['cpupin']) || in_array((string)$i, @$_POST['cpupin']) ? 'checked="checked"' : '');

					echo ''.get_checkbox('cpupin['.$i.']', '', 'pin'.$i, array('chk_it' => 0), $i, '', array($cpucores_flag));
				}
				
				echo '</div>
			</div>-->
			<div class="row mx-auto w-100 my-3">
				<div class="col-sm-6 p-0">
					<label class="control-label">'.__('IP Pool').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Select Multiple IP Pools you want to assign to this plan. (Optional)').'"><i class="fas text-primary fa-info-circle"></i></a></label>
				</div>
				<div class="col-sm-6 p-0">
					<select multiple="multiple" class="virt-select" name="ippoolid[]" id="ippoolid">';
						foreach($ippools as $k => $v){
							echo '<option value="'.$k.'" '.(in_array($k, $plan['ippoolid']) ? 'selected="selected"' : '').'">'.$v['ippool_name'].(!empty($v['ipv6']) ? " (IPv6)" : (!empty($v['internal']) ? " (".__('Internal').")" : " (IPv4)")).'</option>';
						}
					echo '</select>
				</div>
			</div>
			
			<div class="row mx-auto w-100 my-3 openvz vzo lxc">
				<div class=" col-6 p-0">
					<label class="control-label">'.__('Tun/Tap').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Enable Tun/Tap for a VPS').'"><i class="fas text-primary fa-info-circle"></i></a></label>
				</div>
				<div class=" col-6 p-0">
					'.get_checkbox('tuntap', '', 'tuntap', array('chk_it' => 1, 'val' => $plan['tuntap'])).'
				</div>
			</div>
			<div class="row mx-auto w-100 my-3 openvz vzo">
				<div class=" col-6 p-0">
					<label class="control-label">'.__('PPP').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Enable PPP (Point to Point Protocol) for a VPS').'"><i class="fas text-primary fa-info-circle"></i></a></label>
				</div>
				<div class=" col-6 p-0">
					'.get_checkbox('ppp', '', 'ppp', array('chk_it' => 1, 'val' => $plan['ppp'])).'
				</div>
			</div>
			<div class="row mx-auto w-100 my-3 openvz vzo">
				<div class=" col-6 p-0">
					<label class="control-label">'.__('Enable Fuse in Container(s)').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If checked, Fuse will be enabled while making the new container(s).').'"><i class="fas text-primary fa-info-circle"></i></a></label>
				</div>
				<div class=" col-6 p-0">
					'.get_checkbox('fuse', '', '', array('chk_it' => 1, 'val' => $plan['fuse'])).'
				</div>
			</div>
			<div class="row mx-auto w-100 my-3 kvm">
				<div class=" col-6 p-0">
					<label class="control-label">'.__('Disable Autostart').' &nbsp;<a class="info" data-placement="right" tooltip="'.__('If enabled then VPS will not autostart in case of node reboot').'"><i class="fas text-primary fa-info-circle"></i></a></label>
				</div>
				<div class=" col-6 p-0">
					'.get_checkbox('disable_autostart', '', 'disable_autostart', array('chk_it' => 1, 'val' => $data_decode['disable_autostart'])).'
				</div>
			</div>
			<div class="row mx-auto w-100 my-3 openvz vzo">
				<div class=" col-6 p-0">
					<label class="control-label">'.__('Enable IPIP in Container(s)').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If checked, IPIP will be enabled while making the new container(s).').'"><i class="fas text-primary fa-info-circle"></i></a></label>
				</div>
				<div class=" col-6 p-0">
					'.get_checkbox('ipip', '', '', array('chk_it' => 1, 'val' => $plan['ipip'])).'
				</div>
			</div>
			<div class="row mx-auto w-100 my-3 openvz vzo">
				<div class=" col-6 p-0">
					<label class="control-label">'.__('Enable IPGRE in Container(s)').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If checked, IPGRE will be enabled while making the new container(s).').'"><i class="fas text-primary fa-info-circle"></i></a></label>
				</div>
				<div class=" col-6 p-0">
					'.get_checkbox('ipgre', '', '', array('chk_it' => 1, 'val' => $plan['ipgre'])).'
				</div>
			</div>
			<div class="row mx-auto w-100 my-3 openvz vzo">
				<div class=" col-6 p-0">
					<label class="control-label">'.__('Enable NFS in Container(s)').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If checked, NFS will be enabled while making the new container(s).').'"><i class="fas text-primary fa-info-circle"></i></a></label>
				</div>
				<div class=" col-6 p-0">
					'.get_checkbox('nfs', '', '', array('chk_it' => 1, 'val' => $plan['nfs'])).'
				</div>
			</div>
			<div class="row mx-auto w-100 my-3 openvz vzo">
				<div class="col-sm-6 p-0">
					<label class="control-label">'.__('Enable QUOTAUGIDLIMIT in Container(s)').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Enables or disables in-container per-user and per-group disk quotas. If the value is set to 0 or not set, disk quotas inside the container is disabled and not accounted. <br><b>NOTE:</b> This will restart the container.').'"><i class="fas text-primary fa-info-circle"></i></a></label>
				</div>
				<div class="col-sm-6 p-0">
					<input type="number" class="form-control" name="quotaugidlimit" id="quotaugidlimit" size="30" value="'.POSTval('quotaugidlimit', $plan['quotaugidlimit']).'" />
				</div>
			</div>
			<div class="row mx-auto w-100 my-3 openvz vzo">
				<div class="col-sm-6 p-0">
					<label class="control-label">'.__('Set IO Bandwidth Limit for Container(s)').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If set, IO operation will not exceed the specified limit while performing IO operations.').'"><i class="fas text-primary fa-info-circle"></i></a></label>
				</div>
				<div class="col-sm-6 p-0">
					<input type="number" class="form-control" name="iolimit" id="iolimit" size="30" value="'.POSTval('iolimit', $plan['iolimit']).'" />
				</div>
			</div>
			<div class="row mx-auto w-100 my-3 openvz vzo">
				<div class="col-sm-6 p-0">
					<label class="control-label">'.__('Set IOPS Limit for Container(s)').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If set, IO operations per second will not exceed the specified limit.').'"><i class="fas text-primary fa-info-circle"></i></a></label>
				</div>
				<div class="col-sm-6 p-0">
					<input type="number" class="form-control" name="iopslimit" id="iopslimit" size="30" value="'.POSTval('iopslimit', $plan['iopslimit']).'" />
				</div>
			</div>
			<div class="row mx-auto w-100 my-3">
				<div class="col-sm-6 p-0">
					<label class="control-label">'.__('Web Control Panel').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('This option will install selected web control panel in the VPS').'"><i class="fas text-primary fa-info-circle"></i></a></label>
				</div>
				<div class="col-sm-6 p-0">
					<select class="custom-select" name="control_panel" id="control_panel" >
						<option value="0" '.ex_POSTselect('control_panel', 'none', $plan['control_panel']).'>None</option>
						<option value="cpanel" '.ex_POSTselect('control_panel', 'cpanel', $plan['control_panel']).'>cPanel</option>
						<option value="webuzo" '.ex_POSTselect('control_panel', 'webuzo', $plan['control_panel']).'>Webuzo</option>
						<option value="plesk" '.ex_POSTselect('control_panel', 'plesk', $plan['control_panel']).'>Plesk</option>
						<option value="webmin" '.ex_POSTselect('control_panel', 'webmin', $plan['control_panel']).'>Webmin</option>
						<option value="interworx" '.ex_POSTselect('control_panel', 'interworx', $plan['control_panel']).'>Interworx</option>
						<option value="ispconfig" '.ex_POSTselect('control_panel', 'ispconfig', $plan['control_panel']).'>ISPConfig</option>
						<option value="cwp" '.ex_POSTselect('control_panel', 'cwp', $plan['control_panel']).'>CentOS Web Panel</option>
						<option value="vesta" '.ex_POSTselect('control_panel', 'vesta', $plan['control_panel']).'>VestaCP</option>';
						if(!empty($custom_cp)){
							foreach($custom_cp as $k => $v){
								echo '<option value="virt_'.$v.'" '.ex_POSTselect('control_panel', 'virt_'.$v, $plan['control_panel']).'>'.$v.'</option>';
							}
						}
						echo ';
					</select>
				</div>
			</div>

			<div class="row mx-auto w-100 my-3 proxl">
				<div class="col-sm-6 p-0">
					<label class="control-label">'.__('Unprivileged').' &nbsp;<a class="info" data-placement="right" tooltip="'.__('Create unprivileged Container. NOTE: You cannot change the unprivileged state once VPS is created').'"><i class="fas text-primary fa-info-circle"></i></a></label>
				</div>
				<div class="col-sm-6 p-0">
					<select class="custom-select" name="unprivileged" id="unprivileged" >
							<option value="0" '.ex_POSTselect('unprivileged', '0', $data_decode['unprivileged']).'>Disable</option>
							<option value="1" '.ex_POSTselect('unprivileged', '1', $data_decode['unprivileged']).'>Enable</option>
					</select>
				</div>
			</div>';
			
			if(!empty($globals['premium_apps'])){
				echo '
					<div id="premium_apps_cb" class="row mx-auto w-100 my-3">
						<div class="col-6 p-0">
							<label class="control-label">'.__('Enable Premium Applications').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If checked then premium application will be enabled for the VPS(s) under this plan').'"><i class="fas text-primary fa-info-circle"></i></a></label>
						</div>
						<div class="col-6 p-0 ">
							'.get_checkbox('premium_apps_plan', '', 'premium_apps_plan', array('chk_it' => 1, 'val' => $plan['webuzo_data'])).'
						</div>
					</div>';
			}
			
			echo '
	<!--Multi Recipe-->
	<div class="row mx-auto w-100 my-3">
		<div class="col-6 p-0">
			<label class="control-label">'.__('Recipe').'&nbsp;<a class="info data-placement="right" tooltip="'.__('Select the recipe to be executed inside the VPS after creation').'"><i class="fas text-primary fa-info-circle"></i></a></label>
			
		</div>
		<div class="col-6 p-0 server-select-lg">
			<select class="form-control virt-select" name="recipe[]" id="recipe" multiple="multiple" style="width:100%">';
			$tmp_rids = empty($_POST['recipe']) ? $plan['recipe'] : $_POST['recipe'];
			
			if(!empty($tmp_rids)){
				$tmp_rids = (is_array($tmp_rids) ? $tmp_rids : array($tmp_rids));
			}
			
			foreach($recipes as $k => $v){
				echo '<option value="'.$k.'" >'.$v['name'].'</option>';
			}				
			echo '</select>
		</div>
		<script type = "text/javascript">
			var recSeq = '.json_encode(@$tmp_rids).';
			if(recSeq){
				recSeq.forEach(item => { // iterate through array of items that need to be pre-selected
					let value = $("#recipe option[value="+item+"]").text(); // get items inner text
					$("#recipe option[value="+item+"]").remove(); // remove current item from DOM
					$("#recipe").append(new Option(value, item, true, true)).trigger("change"); // append it, making it selected by default
				 });
			}
		</script>
			</div>
			<div class="kvm proxk xcp xcphvm vzk">
				<div class="row mx-auto w-100 my-3 xcp xcphvm">
					<div class="col-6 p-0">
						<label class="control-label">'.__('Install Xentools').'</label>
					</div>
					<div class="col-6 p-0">
						'.get_checkbox('install_xentools', '', 'install_xentools', array('chk_it' => 1, 'val' => $plan['install_xentools'])).'
					</div>
				</div>
				<div class="row mx-auto w-100 my-3 kvm proxk" id="kvm_cpu_mode">
					<div class="col-sm-6 p-0">
						<label class="control-label">'.__('CPU Mode').'</label>
					</div>
					<div class="col-sm-6 p-0">
						<select class="custom-select" name="cpu_mode" id="cpu_mode" onchange="prox_cpu_flags()">
							<option value="default" '.ex_POSTselect('cpu_mode', 'default', $plan['cpu_mode']).'>Default</option>
							<option class="kvm" value="host-model" '.ex_POSTselect('cpu_mode', 'host-model', $plan['cpu_mode']).'>Host Model</option>
							<option class="kvm" value="host-passthrough" '.ex_POSTselect('cpu_mode', 'host-passthrough', $plan['cpu_mode']).'>Host Passthrough</option>							
							<option class="proxk" value="athlon" '.ex_POSTselect('cpu_mode', 'athlon', $plan['cpu_mode']).'>athlon</option>
							<option class="proxk" value="EPYC" '.ex_POSTselect('cpu_mode', 'EPYC', $plan['cpu_mode']).'>EPYC</option>
							<option class="proxk" value="EPYC-IBPB" '.ex_POSTselect('cpu_mode', 'EPYC-IBPB', $plan['cpu_mode']).'>EPYC-IBPB</option>
							<option class="proxk" value="EPYC-Rome" '.ex_POSTselect('cpu_mode', 'EPYC-Rome', $plan['cpu_mode']).'>EPYC-Rome</option>
							<option class="proxk" value="Opteron_G1" '.ex_POSTselect('cpu_mode', 'Opteron_G1', $plan['cpu_mode']).'>Opteron_G1</option>
							<option class="proxk" value="Opteron_G2" '.ex_POSTselect('cpu_mode', 'Opteron_G2', $plan['cpu_mode']).'>Opteron_G2</option>
							<option class="proxk" value="Opteron_G3" '.ex_POSTselect('cpu_mode', 'Opteron_G3', $plan['cpu_mode']).'>Opteron_G3</option>
							<option class="proxk" value="Opteron_G4" '.ex_POSTselect('cpu_mode', 'Opteron_G4', $plan['cpu_mode']).'>Opteron_G4</option>
							<option class="proxk" value="Opteron_G5" '.ex_POSTselect('cpu_mode', 'Opteron_G5', $plan['cpu_mode']).'>Opteron_G5</option>
							<option class="proxk" value="phenom" '.ex_POSTselect('cpu_mode', 'phenom', $plan['cpu_mode']).'>phenom</option>
							<option class="proxk" value="486" '.ex_POSTselect('cpu_mode', '486', $plan['cpu_mode']).'>486</option>
							<option class="proxk" value="Broadwell" '.ex_POSTselect('cpu_mode', 'Broadwell', $plan['cpu_mode']).'>Broadwell</option>
							<option class="proxk" value="Broadwell-IBRS" '.ex_POSTselect('cpu_mode', 'Broadwell-IBRS', $plan['cpu_mode']).'>Broadwell-IBRS</option>
							<option class="proxk" value="Broadwell-noTSX" '.ex_POSTselect('cpu_mode', 'Broadwell-noTSX', $plan['cpu_mode']).'>Broadwell-noTSX</option>
							<option class="proxk" value="Broadwell-noTSX-IBRS" '.ex_POSTselect('cpu_mode', 'Broadwell-noTSX-IBRS', $plan['cpu_mode']).'>Broadwell-noTSX-IBRS</option>
							<option class="proxk" value="Cascadelake-Server" '.ex_POSTselect('cpu_mode', 'Cascadelake-Server', $plan['cpu_mode']).'>Cascadelake-Server</option>
							<option class="proxk" value="Cascadelake-Server-noTSX" '.ex_POSTselect('cpu_mode', 'Cascadelake-Server-noTSX', $plan['cpu_mode']).'>Cascadelake-Server-noTSX</option>
							<option class="proxk" value="Conroe" '.ex_POSTselect('cpu_mode', 'Conroe', $plan['cpu_mode']).'>Conroe</option>
							<option class="proxk" value="core2duo" '.ex_POSTselect('cpu_mode', 'core2duo', $plan['cpu_mode']).'>core2duo</option>
							<option class="proxk" value="coreduo" '.ex_POSTselect('cpu_mode', 'coreduo', $plan['cpu_mode']).'>coreduo</option>
							<option class="proxk" value="Haswell" '.ex_POSTselect('cpu_mode', 'Haswell', $plan['cpu_mode']).'>Haswell</option>
							<option class="proxk" value="Haswell-IBRS" '.ex_POSTselect('cpu_mode', 'Haswell-IBRS', $plan['cpu_mode']).'>Haswell-IBRS</option>
							<option class="proxk" value="Haswell-noTSX" '.ex_POSTselect('cpu_mode', 'Haswell-noTSX', $plan['cpu_mode']).'>Haswell-noTSX</option>
							<option class="proxk" value="Haswell-noTSX-IBRS" '.ex_POSTselect('cpu_mode', 'Haswell-noTSX-IBRS', $plan['cpu_mode']).'>Haswell-noTSX-IBRS</option>
							<option class="proxk" value="Icelake-Client" '.ex_POSTselect('cpu_mode', 'Icelake-Client', $plan['cpu_mode']).'>Icelake-Client</option>
							<option class="proxk" value="Icelake-Client-noTSX" '.ex_POSTselect('cpu_mode', 'Icelake-Client-noTSX', $plan['cpu_mode']).'>Icelake-Client-noTSX</option>
							<option class="proxk" value="Icelake-Server" '.ex_POSTselect('cpu_mode', 'Icelake-Server', $plan['cpu_mode']).'>Icelake-Server</option>
							<option class="proxk" value="Icelake-Server-noTSX" '.ex_POSTselect('cpu_mode', 'Icelake-Server-noTSX', $plan['cpu_mode']).'>Icelake-Server-noTSX</option>
							<option class="proxk" value="IvyBridge" '.ex_POSTselect('cpu_mode', 'IvyBridge', $plan['cpu_mode']).'>IvyBridge</option>
							<option class="proxk" value="IvyBridge-IBRS" '.ex_POSTselect('cpu_mode', 'IvyBridge-IBRS', $plan['cpu_mode']).'>IvyBridge-IBRS</option>
							<option class="proxk" value="KnightsMill" '.ex_POSTselect('cpu_mode', 'KnightsMill', $plan['cpu_mode']).'>KnightsMill</option>
							<option class="proxk" value="Nehalem" '.ex_POSTselect('cpu_mode', 'Nehalem', $plan['cpu_mode']).'>Nehalem</option>
							<option class="proxk" value="Nehalem-IBRS" '.ex_POSTselect('cpu_mode', 'Nehalem-IBRS', $plan['cpu_mode']).'>Nehalem-IBRS</option>
							<option class="proxk" value="Penryn" '.ex_POSTselect('cpu_mode', 'Penryn', $plan['cpu_mode']).'>Penryn</option>
							<option class="proxk" value="pentium" '.ex_POSTselect('cpu_mode', 'pentium', $plan['cpu_mode']).'>pentium</option>
							<option class="proxk" value="pentium2" '.ex_POSTselect('cpu_mode', 'pentium2', $plan['cpu_mode']).'>pentium2</option>
							<option class="proxk" value="pentium3" '.ex_POSTselect('cpu_mode', 'pentium3', $plan['cpu_mode']).'>pentium3</option>
							<option class="proxk" value="SandyBridge" '.ex_POSTselect('cpu_mode', 'SandyBridge', $plan['cpu_mode']).'>SandyBridge</option>
							<option class="proxk" value="SandyBridge-IBRS" '.ex_POSTselect('cpu_mode', 'SandyBridge-IBRS', $plan['cpu_mode']).'>SandyBridge-IBRS</option>
							<option class="proxk" value="Skylake-Client" '.ex_POSTselect('cpu_mode', 'Skylake-Client', $plan['cpu_mode']).'>Skylake-Client</option>
							<option class="proxk" value="Skylake-Client-IBRS" '.ex_POSTselect('cpu_mode', 'Skylake-Client-IBRS', $plan['cpu_mode']).'>Skylake-Client-IBRS</option>
							<option class="proxk" value="Skylake-Client-noTSX-IBRS" '.ex_POSTselect('cpu_mode', 'Skylake-Client-noTSX-IBRS', $plan['cpu_mode']).'>Skylake-Client-noTSX-IBRS</option>
							<option class="proxk" value="Westmere" '.ex_POSTselect('cpu_mode', 'Westmere', $plan['cpu_mode']).'>Westmere</option>
							<option class="proxk" value="Westmere-IBRS" '.ex_POSTselect('cpu_mode', 'Westmere-IBRS', $plan['cpu_mode']).'>Westmere-IBRS</option>
							<option class="proxk" value="kvm32" '.ex_POSTselect('cpu_mode', 'kvm32', $plan['cpu_mode']).'>kvm32</option>
							<option class="proxk" value="kvm64" '.ex_POSTselect('cpu_mode', 'kvm64', $plan['cpu_mode']).'>kvm64</option>
							<option class="proxk" value="max" '.ex_POSTselect('cpu_mode', 'max', $plan['cpu_mode']).'>max</option>
							<option class="proxk" value="qemu32" '.ex_POSTselect('cpu_mode', 'qemu32', $plan['cpu_mode']).'>qemu32</option>
							<option class="proxk" value="qemu64" '.ex_POSTselect('cpu_mode', 'qemu64', $plan['cpu_mode']).'>qemu64</option>
							<option class="proxk" value="host" '.ex_POSTselect('cpu_mode', 'host', $plan['cpu_mode']).'>host</option>
						</select>
					</div>
				</div>';

				$cpu_flags = [
					'md-clear' => __('Required to let the guest OS know if MDS is mitigated correctly.'),
					'pcid' => __('Meltdown fix cost reduction on Westmere, Sandy-, and IvyBride Intel CPUs.'),
					'spec-ctrl' => __('Allowed improved Spectre mitigation with Intel CPUs.'),
					'ssbd' => __('Protection for Speculative Store Bypass for Intel models.'),
					'ibpb' => __('Allows improved Spectre mitigation with AMD CPUs.'),
					'virt-ssbd' => __('Basis for Speculative Store Bypass protection for AMD models.'),
					'amd-ssbd' => __('Improved Spectre mitigation performance with AMD CPUs, best used with virt-ssbd.'), 
					'amd-no-ssb' => __('Notifies guest OS that host is not vulnerable for Spectre on AMD CPUs.'),
					'pdpe1gb' => __('Allow guest OS to use 1GB size pages, if host HW supports it.'),
					'hv-tlbflush' => __('Improved performance in overcomitted Windows guests. May lead to guest bluescreens on old CPUs.'),
					'hv-evmcs' => __('Improve performance for nested virtualization. Only supported in Intel CPUs.'),
					'aes' => __('Activated AES instruction set for HW accelaration.')
				];

				echo '
					<div class="mx-3 proxk">
						<div class="row mx-auto w-100 my-3 proxk extra_cpu_flags" style="display:none;">
							<div class="col-12 p-0">
								<label class="control-label"><small>'.__('Extra Cpu Flags').'</small>&nbsp;<a class="info" data-placement="right" tooltip="'.__('Supported only on Proxmox 7 and above').'"><i class="fas text-primary fa-info-circle"></i></a></label>
							</div>
						</div>';

						foreach($cpu_flags as $flag => $flag_info){
							$class = '';
							if( !empty($cpu_info['amd_cpu']['exception'][$flag])){
								$class .= ' '.implode(' ', $cpu_info['amd_cpu']['exception'][$flag]);
							}elseif(in_array($flag, $cpu_info['amd_cpu']['cpu_flags'])){
								$class .= ' '.implode(' ', $cpu_info['amd_cpu']['cpu_mode']);
							}

							if( !empty($cpu_info['intel_cpu']['exception'][$flag])){
								$class .= ' '.implode(' ', $cpu_info['intel_cpu']['exception'][$flag]);
							}elseif(in_array($flag, $cpu_info['intel_cpu']['cpu_flags'])){
								$class .= ' '.implode(' ', $cpu_info['intel_cpu']['cpu_mode']);
							}

							if( !empty($cpu_info['other_cpu']['exception'][$flag])){
								$class .= ' '.implode(' ', $cpu_info['other_cpu']['exception'][$flag]);
							}elseif(in_array($flag, $cpu_info['other_cpu']['cpu_flags'])){
								$class .= ' '.implode(' ', $cpu_info['other_cpu']['cpu_mode']);
							}

							echo '
									<div class="row mx-auto w-100 my-3 proxk '.$flag.' '.$class.' hide_all_cpu_flags" style="display:none">
										<div class="col-5">
											<label class="control-label">'.$flag.'&nbsp;<a class="info" data-placement="right" tooltip="'.$flag_info.'"><i class="fas text-primary fa-info-circle"></i></a></label>
										</div>
										<div class="col-2">
											<label class="custom-control custom-radio">
												<input type="radio" class="custom-control-input" id="'.$flag.'-on" name="'.$flag.'" value="1" '.POSTradio($flag, 1, $data_decode['cpu_flags'][$flag]).'>
												<span class="custom-control-label" for="'.$flag.'">'.__('On').'</span>
											</label>
										</div>
										<div class="col-3">
											<label class="custom-control custom-radio">
												<input type="radio" class="custom-control-input" id="'.$flag.'-default" name="'.$flag.'" value="0" '.POSTradio($flag, 0, $data_decode['cpu_flags'][$flag]).'>
												<span class="custom-control-label" for="'.$flag.'">'.__('Default').'</span>
											</label>
										</div>
										<div class="col-2">
											<label class="custom-control custom-radio">
												<input type="radio" class="custom-control-input" id="'.$flag.'-off" name="'.$flag.'" value="2" '.POSTradio($flag, 2, $data_decode['cpu_flags'][$flag]).'>
												<span class="custom-control-label" for="'.$flag.'">'.__('Off').'</span>
											</label>
										</div>
									</div>';
						
						}		
				echo '</div>

				
				<div class="row mx-auto w-100 my-3 kvm">
					<div class="col-sm-6 p-0">
						<label class="control-label">'.__('Custom CPU Mode').'</label>&nbsp;<a class="info" data-placement="right" tooltip="'.__('Custom Model should be the exact name which is available in the cpu mode dropdown list on addvs wizard. If not matched then it will not set the custom model.').'"><i class="fas text-primary fa-info-circle"></i></a>
					</div>
					<div class="col-sm-6 p-0">
						<input type="text" class="form-control" name="custom_cpu_model" id="custom_cpu_model" size="6" value="'.POSTval('custom_cpu_model', $data_decode['custom_cpu_model']).'" />
					</div>
				</div>
				<div class="row mx-auto w-100 my-3 proxk">
					<div class="col-sm-6 p-0">
						<label class="control-label">'.__('Machine Type').'</label>&nbsp;<a class="info" data-placement="right" tooltip="'.__('Enter the machine type(E.g : pc-i440fx-5.1 or pc-q35-5.1). If not entered properly, default machine type will be selected').'"><i class="fas text-primary fa-info-circle"></i></a>
					</div>
					<div class="col-sm-6 p-0">
						<input type="text" class="form-control" name="machine_type" id="machine_type" value="'.POSTval('machine_type', $data_decode['machine_type']).'" />
					</div>
				</div>
				<div class="row mx-auto w-100 my-3 kvm proxk xcp" id="enable_cpu_topology_row">
					<div class="col-6 p-0">
						<label class="control-label">'.__('CPU Topology').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Specify the number of CPU cores, Threads and Sockets to be assigned to the VPS').'"><i class="fas text-primary fa-info-circle"></i></a></label>
					</div>
					<div class="col-6 p-0">
						'.get_checkbox('enable_cpu_topology', '', 'enable_cpu_topology', array('chk_it' => 1, 'val' => $plan['topology_sockets']), 1, '', array('onchange="change_cpu_topology();"')).'
					</div>
				</div>
				<div id="cpu_topology">
					<div class="row mx-auto w-100 my-3">
						<div class="col-sm-6 p-0">
							<label class="control-label">Sockets</label>
						</div>
						<div class="col-sm-6 p-0">
							<input type="text" name="topology_sockets" id="topology_sockets" class="form-control numbersonly" size="6" value="'.POSTval('topology_sockets', $plan['topology_sockets']).'" />
						</div>
					</div>
					<div class="row mx-auto w-100 my-3">
						<div class="col-sm-6 p-0">
							<label class="control-label">Cores</label>
						</div>
						<div class="col-sm-6 p-0">
							<input type="number" class="form-control numbersonly" name="topology_cores" id="topology_cores" size="6" value="'.POSTval('topology_cores', $plan['topology_cores']).'" />
						</div>
					</div>
					<div class="row mx-auto w-100 my-3 kvm">
						<div class="col-sm-6 p-0">
							<label class="control-label">Threads</label>
						</div>
						<div class="col-sm-6 p-0">
							<input type="number" class="form-control numbersonly" name="topology_threads" id="topology_threads" size="6" value="'.POSTval('topology_threads', $plan['topology_threads']).'" />
						</div>
					</div>
				</div>';

				if(!empty($isos)){
					echo '<div class="row mx-auto w-100 my-3 kvm vzk proxk" id="sec_iso_div">
						<div class="col-sm-6 p-0">
							<label class="control-label">'.__('ISO for secondary CDROM ').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Select an ISO for secondary CDROM').'"><i class="fas text-primary fa-info-circle"></i></a></label>
						</div>
						<div class="col-sm-6 p-0">
						<select class="custom-select virt-select" name="sec_iso">
						<option value="0" '.ex_POSTselect('sec_iso', 0, $plan['sec_iso']).'>'.__('None').'</option>';
					
						foreach($isos as $k => $v){	
							echo '<option value="'.$k.'" '.ex_POSTselect('sec_iso', $k, $plan['sec_iso']).' >'.$v['name'].'</option>';
						}
						
						 echo'</select>
						</div>
					</div>';
				}
			echo '</div>
			<div class="row mx-auto w-100 my-3 kvm xen xenhvm xcp xcphvm" id="vnc_keymap_div">
				<div class="col-sm-6 p-0">
					<label class="control-label">'.__('VNC Console Keymap').'</label>
				</div>
				<div class="col-sm-6 p-0">
					<select class="virt-select" name="vnc_keymap" id="vnc_keymap" >';
						foreach($vnc_keymap_array as $kk => $vv){
							echo '<option value="'.$vv.'" '.ex_POSTselect('vnc_keymap', $vv, $plan['vnc_keymap']).'>'.$vv.'</option>';
						}
						echo '
					</select>
				</div>
			</div>
			<div class="kvm proxk">
				<div class="row mx-auto w-100 my-3" id="kvm_cache_div">
					<div class="col-sm-6 p-0">
						<label class="control-label">'.__('Disk Caching').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Controls the cache mechanism').'"><i class="fas text-primary fa-info-circle"></i></a></label>
					</div>
					<div class="col-sm-6 p-0">
						<select class="custom-select" name="kvm_cache" id="kvm_cache" >
							<option value="0" '.ex_POSTselect('kvm_cache', 'none', $plan['kvm_cache']).'>None</option>
							<option value="writeback" '.ex_POSTselect('kvm_cache', 'writeback', $plan['kvm_cache']).'>Writeback</option>
							<option value="writethrough" '.ex_POSTselect('kvm_cache', 'writethrough', $plan['kvm_cache']).'>Writethrough</option>
							<option value="default" '.ex_POSTselect('kvm_cache', 'default', $plan['kvm_cache']).'>Default</option>
							<option value="directsync" '.ex_POSTselect('kvm_cache', 'directsync', $plan['kvm_cache']).'>Direct Sync</option>
						</select>
					</div>
				</div>

			
				<div class="row mx-auto w-100 my-3 kvm" id="io_mode_div">
					<div class="col-sm-6 p-0">
						<label class="control-label">'.__('I/O Policy').'</label>
					</div>
					<div class="col-sm-6 p-0">
						<select class="custom-select" name="io_mode" id="io_mode" >
							<option value="0" '.ex_POSTselect('io_mode', 'default', $plan['io_mode']).'>Default</option>
							<option value="native" '.ex_POSTselect('io_mode', 'native', $plan['io_mode']).'>Native</option>
							<option value="threads" '.ex_POSTselect('io_mode', 'threads', $plan['io_mode']).'>Threads</option>
							<option value="io_uring" '.ex_POSTselect('io_mode', 'io_uring', $plan['io_mode']).'>Io_Uring</option>
						</select>
					</div>
				</div>
				<div class="row mx-auto w-100 my-3 kvm" id="kvm_vga_div">
					<div class=" col-6 p-0">
						<label class="control-label">'.__('Enable VGA').'</label>
					</div>
					<div class=" col-6 p-0">
						'.get_checkbox('kvm_vga', '', 'kvm_vga', array('chk_it' => 1, 'val' => $plan['kvm_vga']), 1, '', array('onchange="enable_accel();"')).'
					</div>
				</div>
				
				<div class="row mx-auto w-100 my-3 proxk" id="proxmox_numa">
					<div class="col-6 p-0">
						<label class="control-label">'.__('Enable NUMA').'</label>
					</div>
					<div class="col-6 p-0">
						'.get_checkbox('numa', '', 'numa', array('chk_it' => 1, 'val' => $plan['numa'])).'
					</div>
				</div>
				
				<div class="row mx-auto w-100 my-3" id="set_vga_vram" style="display:none;">
					<div class=" col-6 p-0">
						<label class="control-label">'.__('Set vram').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Set vram for VGA in MB. If not defined or set as 0, vram value will be set as 8MB').'"><i class="fas text-primary fa-info-circle"></i></a></label>
					</div>

					<div class=" col-6 p-0">
						<div class="input-group ">
							<input type="number" class="form-control rounded" name="vga_vram" id="vga_vram" size="10" value="'.POSTval('vga_vram', $data_decode['vga_vram']).'" />
							<div class="input-group-append">
								<span class="input-group-text">MB</span>
							</div>
						</div>
					</div>
				</div>

				<div class="row mx-auto w-100 my-3 kvm" id="enable_acceleration" style="display:none;">
					<div class=" col-6 p-0">
						<label class="control-label">'.__('Enable Acceleration').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If checked then 2D and 3D acceleration will be enabled for the VPS').'"><i class="fas text-primary fa-info-circle"></i></a></label>
					</div>
					<div class=" col-6 p-0">
						'.get_checkbox('acceleration', '', 'acceleration', array('chk_it' => 1, 'val' => $plan['acceleration'])).'
					</div>
				</div>
				<div class="row mx-auto w-100 my-3 kvm proxk" id="total_iops_sec_div">
					<div class="col-sm-6 p-0">
						<label class="control-label">'.__('Total I/O\'s per sec').'</label>
					</div>
					<div class="col-sm-6 p-0">
						<input type="number" class="form-control" name="total_iops_sec" value="'.POSTval('total_iops_sec', $plan['total_iops_sec']).'" />
					</div>
				</div>
				<div class="row mx-auto w-100 my-3 kvm proxk" id="read_bytes_sec_div">
					<div class="col-sm-6 p-0">
						<label class="control-label">'.__('Read Mega Byte\'s/s').'</label>
					</div>
					<div class="col-sm-6 p-0">
						<div class="input-group ">
							<input type="number" class="form-control rounded" name="read_bytes_sec" value="'.POSTval('read_bytes_sec', $plan['read_bytes_sec']).'" />
						<div class="input-group-append">
							<span class="input-group-text">MB/s</span>
						</div>
						</div>
					</div>
				</div>
				<div class="row mx-auto w-100 my-3 kvm proxk" id="write_bytes_sec_div">
					<div class="col-sm-6 p-0">
						<label class="control-label">'.__('Write Mega Byte\'s/s').'</label>
					</div>
					<div class="col-sm-6 p-0">
						<div class="input-group ">
							<input type="number" class="form-control rounded" name="write_bytes_sec" value="'.POSTval('write_bytes_sec', $plan['write_bytes_sec']).'" />
						<div class="input-group-append">
							<span class="input-group-text">MB/s</span>
						</div>
						</div>
					</div>
				</div>';
				
			echo '</div> ';
			
			
			$os_type = array('other' => 'unspecified OS / Default',
								'wxp' => 'Microsoft Windows XP',
								'w2k' => 'Microsoft Windows 2000',
								'w2k3' => 'Microsoft Windows 2003',
								'w2k8' => 'Microsoft Windows 2008',
								'wvista' => 'Microsoft Windows Vista',
								'win7' => 'Microsoft Windows 7',
								'win8' => 'Microsoft Windows 8/2012/2012r2',
								'win10' => 'Microsoft Windows 10/2016',
								'l24' => 'Linux 2.4 Kernel',
								'l26' => 'Linux 2.6 - 5.X Kernel',
								'solaris' => 'Solaris/OpenSolaris/OpenIndiania kernel'
							);	
			echo '
			<div class="row mx-auto w-100 my-3 proxk">
				<div class="col-sm-6 p-0">
					<label class="control-label">'.__('Select OS Type').' &nbsp;<a class="info" data-placement="right" tooltip="'.__('Setting the proper Operating System(OS) allows Proxmox VE to optimize some low level parameters').'"><i class="fas text-primary fa-info-circle"></i></a></label><br>
				</div>
				<div class="col-sm-6 p-0">
					<select class="custom-select virt-select" name="os_type" id="os_type">';
					foreach($os_type as $os_value => $os_full_form){
						echo '<option value="'.$os_value.'" '.(($data_decode['os_type'] == $os_value) ? 'selected = "selected"' : '').'>'.$os_full_form.'</option>';
					}
				echo'	</select>
				</div>
			</div>';
			
			$rtc = array('0' => __('Disable'),
					 '1' => __('Enable')
					);
			echo '
			<div class="row mx-auto w-100 my-3 proxk">
				<div class="col-sm-6 p-0">
					<label class="control-label">'.__('RTC').' &nbsp;<a class="info" data-placement="right" tooltip="'.__('Set RTC local time. By default for Windows it is enabled').'"><i class="fas text-primary fa-info-circle"></i></a></label><br>
					</div>
				<div class="col-sm-6 p-0">
					<select class="custom-select virt-select" name="rtc" id="rtc">';
					foreach($rtc as $bol => $options){
						echo '<option value="'.$bol.'" '.(($data_decode['rtc'] == $bol) ? 'selected = "selected"' : '').'>'.$options.'</option>';
					}
				echo'	</select>
				</div>
			</div>';


			echo'
			<div class="row mx-auto w-100 my-3 kvm_hvm_div kvm xenhvm xcphvm vzk proxk">
				<div class=" col-6 p-0">
					<label class="control-label">'.__('Enable RDP').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Enable Remote Desktop Connection (For Windows VPS)').'"><i class="fas text-primary fa-info-circle"></i></a></label>
				</div>
				<div class=" col-6 p-0">
					'.get_checkbox('rdp', '', 'rdp', array('chk_it' => 1, 'val' => $plan['rdp'])).'
				</div>
			</div>	
			<div id="tr_pvonhvm" class="row mx-auto w-100 my-3 pv_on_hvm_div xenhvm">
				<div class=" col-6 p-0">
					<label class="control-label">'.__('PV-on-HVM driver Support').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('The primary goal of PV on HVM is to boost performance of fully virtualized HVM guests through use of specially optimized paravirtual device drivers').'"><i class="fas text-primary fa-info-circle"></i></a></label>
				</div>
				<div class=" col-6 p-0">
					'.get_checkbox('pv_on_hvm', '', 'pv_on_hvm', array('chk_it' => 1, 'val' => $plan['pv_on_hvm']), 1, '', array('onchange="ispvonhvm();"')).'
				</div>
			</div>
			<div id="tr_viftype" class="row mx-auto w-100 my-3 xenhvm">
				<div class="col-6 p-0">
					<label class="control-label">'.__('Virtual Network Interface Emulation type').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If you want to change the network interface emulation type. Options are <b>netfront</b> or <b>ioemu</b>.').'"><i class="fas text-primary fa-info-circle"></i></a></label>
				</div>
				<div class="col-6 p-0">
					<label class="custom-control custom-radio">
							<input type="radio" name="vif_type"  value="netfront" id="netfront" '.POSTradio('vif_type', 'netfront', $plan['vif_type']).' class="custom-control-input" >
							<span class="custom-control-label" for="netfront">'.__('netfront (default)').'</span>
						</label>
						<label class="custom-control custom-radio">
							<input type="radio" name="vif_type"  value="ioemu" id="ioemu" '.POSTradio('vif_type', 'ioemu', $plan['vif_type']).' class="custom-control-input" >
							<span class="custom-control-label" for="ioemu">'.__('ioemu').'</span>
						</label>
				</div>
			</div>';
					
			if(!empty($globals['add_ptr_record'])){
				$dont_add_ptr = (!empty($data_decode['dont_add_ptr']) ? 'checked="checked"' : '');
				echo '<div class="row mx-auto w-100 my-3">
						<div class="col-6 p-0">
							<label class="control-label">'.__('Do not Add PTR Record').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If Auto Add PTR record setting is enabled in Master settings, PTR record for the VPS will not be added').'"><i class="fas text-primary fa-info-circle"></i></a></label>
						</div>
						<div class="col-6 p-0">
							'.get_checkbox('dont_add_ptr', '', 'dont_add_ptr', array('chk_it' => 1, 'val' => $plan['dont_add_ptr']),1,'',array($dont_add_ptr)).'
						</div>
				</div>'; 
			}

			echo'
			<div class="row mx-auto w-100 my-3">
				<div class="col-sm-6 p-0">
					<label class="control-label">'.__('OS Reinstall Limit').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If you want to limit the number of OS re-installs per month. <br />Eg. 0 - is unlimited').'"><i class="fas text-primary fa-info-circle"></i></a></label>
				</div>
				<div class="col-sm-6 p-0">
					<input type="number" class="form-control" name="osreinstall_limit" id="osreinstall_limit"  value="'.POSTval('osreinstall_limit', $plan['osreinstall_limit']).'"/>
				</div>
			</div>
			<div class="row mx-auto w-100 my-3">
				<div class="col-6 p-0">
					<label class="control-label">'.__('Managed by Admin').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If checked, VPS can not be managed from Enduser Panel.').'"><i class="fas text-primary fa-info-circle"></i></a></label>
				</div>
				<div class="col-6 p-0">
					'.get_checkbox('admin_managed', '', 'admin_managed', array('chk_it' => 1, 'val' => $plan['admin_managed'])).'
				</div>
			</div>';
					
			if(!empty($globals['add_ptr_record'])){
				$dont_add_ptr = (!empty($data_decode['dont_add_ptr']) ? 'checked="checked"' : '');
				echo '<div class="row mx-auto w-100 my-3">
						<div class="col-6 p-0">
							<label class="control-label">'.__('Do not Add PTR Record').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If Auto Add PTR record setting is enabled in Master settings, PTR record for the VPS will not be added').'"><i class="fas text-primary fa-info-circle"></i></a></label>
						</div>
						<div class="col-6 p-0">
							'.get_checkbox('dont_add_ptr', '', 'dont_add_ptr', array('chk_it' => 1, 'val' => $plan['dont_add_ptr']),1,'',array($dont_add_ptr)).'
						</div>
				</div>'; 
			}

			echo'
			<div class="row mx-auto w-100 my-3">
				<div class="col-6 p-0">
					<label class="control-label">'.__('Disable password authentication').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If enabled then password authentication will be restricted for SSH.').'"><i class="fas text-primary fa-info-circle"></i></a></label>
				</div>
				<div class="col-6 p-0">
					'.get_checkbox('disable_password', '', 'disable_password', array('chk_it' => 1, 'val' => $data_decode['disable_password'])).'
				</div>
			</div>
			<div class="row mx-auto w-100 my-3 kvm">
				<div class="col-6 p-0">
					<label class="control-label">'.__('Enable HA').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('HA will be enabled for VPS only if the VPS is created in HA enabled server group').'"><i class="fas text-primary fa-info-circle"></i></a></label>
				</div>
				<div class="col-6 p-0">
					'.get_checkbox('ha', '', 'ha', array('chk_it' => 1, 'val' => $data_decode['ha'])).'
				</div>
			</div>
			<div class="row mx-auto w-100 my-3 kvm proxk">
				<div class="col-6 p-0">
					<label class="control-label">'.__('Bios').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Choose bios to boot VPS from. Note: It will work if the VPS is booted from ISO.').'"><i class="fas text-primary fa-info-circle"></i></a></label>
				</div>
				<div class="col-6 p-0">
					<select class="custom-select virt-select" name="bios" id="bios" onchange="toggle_bios();">';
						foreach($bios as $boi => $options){
							echo '<option value="'.$boi.'" '.(($data_decode['bios'] === $boi) ? 'selected = "selected"' : '').'>'.$options.'</option>';
						}
						
			echo'	</select>
				</div>
			</div>
			<div class="row mx-auto w-100 my-3" id="tpm_row" '.(!empty($data_decode['bios']) && $data_decode['bios'] === 'uefi' ? '' : 'style="display:none"').'>
				<div class="col-6 p-0">
					<label class="control-label">'.__('Enable TPM').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If checked TPM will be enabled').'"><i class="fas text-primary fa-info-circle"></i></a></label>
				</div>
				<div class="col-6 p-0">
					'.get_checkbox('enable_tpm', '', 'enable_tpm', array('chk_it' => 1, 'name' => 'enable_tpm', 'val' => $data_decode['enable_tpm'])).'
				</div>
			</div>
			<div class="row mx-auto w-100 my-3 kvm xen xenhvm xcp xcphvm lxc vzk proxk proxl" id="disable_nw_config_row">
				<div class="col-6 p-0">
					<label class="control-label">'.__('Disable Network configuration').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If checked, Virtualizor will not configure/re-write network when a VPS is rebooted. However, during creation of the VPS, the network file will be written.').'"><i class="fas text-primary fa-info-circle"></i></a></label>
				</div>
				<div class="col-6 p-0">
					'.get_checkbox('disable_nw_config', '', 'disable_nw_config', array('chk_it' => 1, 'val' => $plan['disable_nw_config'])).'
				</div>
			</div>
			<div class="row mx-auto w-100 my-3 proxk">
				<div class="col-6 p-0">
					<label class="control-label">'.__('Enable Discard').'</label>
				</div>
				<div class="col-6 p-0">
					'.get_checkbox('discard', '', 'discard', array('chk_it' => 1, 'val' => $data_decode['discard'])).'
				</div>
			</div>
			<!--<div class="row mx-auto w-100 my-3 proxk proxl">
				<div class="col-6 p-0">
					<label class="control-label">'.__('VLAN Tag').'</label>
				</div>
				<div class="col-6 p-0">
					<input type="number" max="4094" class="form-control" name="vlan_tag" id="vlan_tag"  value="'.POSTval('vlan_tag', $data_decode['vlan_tag']).'"/>
				</div>
			</div>-->
			<div class="row mx-auto w-100 my-3 proxk">
				<div class="col-6 p-0 iothread">
					<label class="control-label">'.__('IO Thread').'</label>
				</div>
				<div class="col-6 p-0 iothread">
					'.get_checkbox('iothread', '', 'iothread', array('chk_it' => 1, 'val' => $data_decode['iothread'])).'
				</div>	
			</div>
			<div class="row mx-auto w-100 my-3 proxl">
				<div class="col-6 p-0 nesting">
					<label class="control-label">'.__('Nesting').'</label>
				</div>
				<div class="col-6 p-0 nesting">
					'.get_checkbox('nesting', '', 'nesting', array('chk_it' => 1, 'val' => $data_decode['nesting'])).'
				</div>	
			</div>
			<div class="row mx-auto w-100 my-3 proxk kvm">
				<div class="col-6 p-0 ssd_emulation">
					<label class="control-label">'.__('SSD Emulation').'</label>
				</div>
				<div class="col-6 p-0 ssd_emulation">
					'.get_checkbox('ssd_emulation', '', 'ssd_emulation', array('chk_it' => 1, 'val' => $data_decode['ssd_emulation'])).'
				</div>	
			</div>';

			$cpu_threshold_perc = (!empty($data_decode['enable_cpu_threshold']) ? 'checked="checked"' : '');
			echo'
			<div class="row mx-auto w-100 my-3">
				<div class="col-6 p-0">
					<label class="control-label">'.__('CPU Threshold ').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('The CPU Threshold notifies admin when a predefined threshold of CPU usage is exceeded ').'"><i class="fas text-primary fa-info-circle"></i></a></label>
				</div>
				<div class="col-6 p-0">
					'.get_checkbox('enable_cpu_threshold', '', 'enable_cpu_threshold', array('chk_it' => 1), 1, '', array('onchange="checkcputhreshold();"', $cpu_threshold_perc)).'
				</div>
			</div>
			<div id="cputhresholdpercentage" class="input-group" style="display:none;">
				<div class="row mx-auto w-100 my-3">
					<div class="col-sm-6 p-0">
						<label class="control-label">'.__('CPU Threshold Percentage').'</label>
					</div>
					<div class="col-sm-6 p-0 input-group">
						<input type="number" min="0" max="100" class="form-control" name="cpu_threshold" id="cpu_threshold" size="6" value="'.POSTval('cpu_threshold', $data_decode['cpu_threshold']).'"/> 
						<span class="input-group-text">%</span>
					</div>
				</div>
				<div class="row mx-auto w-100">
					<div class="col-sm-6 p-0">
						<label class="control-label">'.__('CPU Threshold Time').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('The threshold time is divided by 5, and we will check the CPU usage on each interval. If CPU usage is above the threshold value for each interval then at the last interval we will suspend the VPS').'"><i class="fas text-primary fa-info-circle"></i></a></label>
					</div>
					<div class="col-sm-6 p-0 input-group">
						<input type="number" min="0" class="form-control" name="cpu_threshold_time" id="cpu_threshold_time" size="30" value="'.POSTval('cpu_threshold_time', $data_decode['cpu_threshold_time']).'"/>
						<span class="input-group-text">
							<i class="fas fa-stopwatch" style="color: #000000;"></i>
						</span>
					</div>
				</div>
			</div>
			<div class="row mx-auto w-100 my-3 ">
				<div class="row mx-auto w-100">
					<div class="col-6 p-0 hide_for_plan d-flex align-items-center">
						<label class="control-label">'.__('Enable Demo').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('When enabled VPS will Suspended/Deleted once demo period is expired').'"><i class="fas text-primary fa-info-circle"></i></a></label>
					</div>	
					<div class="col-4 p-0">
						'.get_checkbox('show_demo', '', 'demo', array('chk_it' => 1, 'name' => 'demo_edit','val' => (!empty($data_decode['demo']['duration_days']) || !empty($_POST['enable_demo']) ? '1' : '')), 1, '', array('onchange="checkdemo();change_checkbox(\'demo\');"')).'
						<input type="hidden" name="enable_demo" id="hidden_demo"'.(!empty($data_decode['demo']['duration_days']) ? ' value="1" ' : '').'>
					</div>
				</div>
				<div class="row mx-auto w-100">
					<div class="col-6 p-0"></div>
					<div id="demo_days" class="col-sm-6 p-0" '.(empty($data_decode['demo']['duration_days']) ? '  style="display:none; ' : '').'">
						<div class="input-group mt-2">
							<input type="number" class="form-control rounded" name="demo_duration" id="demo_duration" size="10" value="'.POSTval('demo_duration', $data_decode['demo']['duration_days']).'" placeholder="'.__('Demo duration in Day(s)').'"/>
							<div class="input-group-append">
								<span class="input-group-text">'.__('Day(s)').'</span>
							</div>
						</div>
					</div>
				</div>
				<div class="row mx-auto w-100 my-3" id="demo_action_options" '.(empty($data_decode['demo']['duration_days']) ? '  style="display:none; ' : '').'">
						<div class="col-sm-6 p-0">
							<label class="control-label">'.__('Demo Action').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Action to be taken once the Demo period is expired').'"><i class="fas text-primary fa-info-circle"></i></a></label>
						</div>
						<div class="col-sm-6 p-0">
							<label class="custom-control custom-radio">
								<input type="radio" class="custom-control-input" name="demo_action" value="0" id="demo_delete_action" '.($data_decode['demo']['action'] == 0 ? 'checked="checked"' : '').'>
								<span class="custom-control-label" for="demo_delete_action">'.__('VPS will be deleted').'</span>
							</label>
							<label class="custom-control custom-radio">
								<input type="radio" class="custom-control-input" name="demo_action" value="1" id="demo_suspend_action" '.($data_decode['demo']['action'] == 1 ? 'checked="checked"' : '').'>
								<span class="custom-control-label" for="demo_suspend_action">'.__('VPS will be suspended').'</span>
							</label>
						</div>
					</div>

					<div class="row mx-auto w-100 my-3 proxk">
						<div class="col-sm-6 p-0">
							<label class="control-label">'.__('Graphic Card').'</label>
						</div>
						<div class="col-sm-6 p-0">
							<select class="custom-select" name="vga" id="vga">
								<option value="" '.(($data_decode['vga'] == '') ? 'selected = "selected"' : '').'>Default</option>
								<option value="std" '.(($data_decode['vga'] == 'std')? 'selected = "selected"' : '').'>Standard VGA</option>
								<option value="vmware"  '.(($data_decode['vga'] == 'vmware')? 'selected = "selected"' : '').'>VMware Compatible</option>
								<option value="qxl" '.(($data_decode['vga'] == 'qxl')? 'selected = "selected"' : '').'>SPICE</option>
								<option value="qxl2" '.(($data_decode['vga'] == 'qxl2')? 'selected = "selected"' : '').'>SPICE dual monitor</option>
								<option value="qxl3" '.(($data_decode['vga'] == 'qxl3')? 'selected = "selected"' : '').'>SPICE three monitor</option>
								<option value="qxl4" '.(($data_decode['vga'] == 'qxl4')? 'selected = "selected"' : '').'>SPICE four monitor</option>
								<option value="serial0" '.(($data_decode['vga'] == 'serial0')? 'selected = "selected"' : '').'>Serial Terminal 0</option>
								<option value="serial1" '.(($data_decode['vga'] == 'serial1')? 'selected = "selected"' : '').'>Serial Terminal 1</option>
								<option value="serial2" '.(($data_decode['vga'] == 'serial2')? 'selected = "selected"' : '').'>Serial Terminal 2</option>
								<option value="virtio" '.(($data_decode['vga'] == 'virtio')? 'selected = "selected"' : '').'>VirtIO-GPU</option>
								<option value="virtio-gl" '.(($data_decode['vga'] == 'virtio-gl')? 'selected = "selected"' : '').'>VirtGL GPU</option>
								<option value="none" '.(($data_decode['vga'] == 'none')? 'selected = "selected"' : '').'>None</option>
							</select>
						</div>
					</div>
					<div class="row mx-auto w-100 my-3 proxk">
						<div class="col-sm-6 p-0">
							<label class="control-label">'.__('Graphic Card Memory (MB)').'<a class="info" data-placement="right" tooltip="'.__('Graphir Card Memory should be less then or equal to 512').'"><i class="fas text-primary fa-info-circle"></i></a></label>
						</div>
						<div class="col-sm-6 p-0">
							<input type="number" min="0" max="512" class="form-control"  name="vga_memory" id="vga_memory" value="'.POSTval('vga_memory', $data_decode['vga_memory']).'"/>
						</div>
					</div>

				</div>';
			
			if(check_licensepro()){
				echo'
				<div class="row mx-auto w-100 kvm">
					<div class="col-6 p-0">
						<label class="control-label">'.__('Enable vertical scaling').'</label>
					</div>
					<div class="col-6 p-0">
						'.get_checkbox('enable_ver_scaling', '', 'enable_ver_scaling', array('chk_it' => 1, 'val' => $data_decode['enable_ver_scaling'])).'
					</div>
				</div>
				<div class="row mx-auto w-100 ver_scale_settings">
					<div class="col-sm-12 p-2">
						<fieldset class="user_details_f">
							<legend class="user_details_f mb-0">'.__('Vertical Scaling Settings').'</legend>
							<div class="row mx-auto w-100">
								<div class="col-sm-12 notice">
									'.__('<ol class="pl-2 mb-1">
<li>Vertical scaling is supported on KVM based virtualization only.</li>
<li>QEMU version should be greater than or equal to 1.5, To check QEMU Version run "/usr/bin/virsh version"</li>
<li>Vertical scaling is currently not supported on Windows VPS</li>
</ol>').'
								</div>
							</div>
							<h5>'.__('RAM Settings').'</h5>
							<div class="row mx-auto w-100 my-3">
								<div class="col-sm-6 p-0">
									<label class="control-label">'.__('Max RAM (in MB)').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Provide the maximum amount of RAM that will be allocated to VPS ').'"><i class="fas text-primary fa-info-circle"></i></a></label>
								</div>
								<div class="col-sm-6 p-0">
									<input type="text" class="form-control" name="ver_max_ram" value="'.POSTval('ver_max_ram', $data_decode['ver_max_ram']).'" />
								</div>
							</div>
							<div class="row mx-auto w-100 my-3">
								<div class="col-sm-6 p-0">
									<label class="control-label">'.__('RAM Threshold (in %)').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If the VPS RAM usage is greater/less than threshold provided scaling will be performed accordingly').'"><i class="fas text-primary fa-info-circle"></i></a></label>
								</div>
								<div class="col-sm-6 p-0">
									<input type="text" class="form-control" name="ver_ram_threshold" value="'.POSTval('ver_ram_threshold', $data_decode['ver_ram_threshold']).'" />
								</div>
							</div>
							<div class="row mx-auto w-100 my-3">
								<div class="col-sm-6 p-0">
									<label class="control-label">'.__('Increase/Decrease RAM By (in GB)').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If the threshold exceeds/subceeds, the provided RAM (in GB) will be increased or decreased accordingly').'"><i class="fas text-primary fa-info-circle"></i></a></label>
								</div>
								<div class="col-sm-6 p-0">
									<input type="text" class="form-control" name="ver_ram_inc_by" value="'.POSTval('ver_ram_inc_by', $data_decode['ver_ram_inc_by']).'" />
								</div>
							</div>
							<hr>
							<h5>'.__('CPU Settings').'</h5>
							<div class="row mx-auto w-100 my-3">
								<div class="col-sm-6 p-0">
									<label class="control-label">'.__('Max CPU Cores').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Provide the maximum amount of cpu cores that will be allocated to VPS ').'"><i class="fas text-primary fa-info-circle"></i></a></label>
								</div>
								<div class="col-sm-6 p-0">
									<input type="text" class="form-control" name="ver_max_cpu" value="'.POSTval('ver_max_cpu', $data_decode['ver_max_cpu']).'" />
								</div>
							</div>
							<div class="row mx-auto w-100 my-3">
								<div class="col-sm-6 p-0">
									<label class="control-label">'.__('CPU Threshold (in %)').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If the VPS cpu usage is greater/less than threshold provided scaling will be performed accordingly').'"><i class="fas text-primary fa-info-circle"></i></a></label>
								</div>
								<div class="col-sm-6 p-0">
									<input type="text" class="form-control" name="ver_cpu_threshold" value="'.POSTval('ver_cpu_threshold', $data_decode['ver_cpu_threshold']).'" />
								</div>
							</div>
							<div class="row mx-auto w-100 my-3">
								<div class="col-sm-6 p-0">
									<label class="control-label">'.__('Increase/Decrease CPU Cores By').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If the threshold exceeds/subceeds, the provided cores will be increased or decreased accordingly').'"><i class="fas text-primary fa-info-circle"></i></a></label>
								</div>
								<div class="col-sm-6 p-0">
									<input type="text" class="form-control" name="ver_cpu_inc_by" value="'.POSTval('ver_cpu_inc_by', $data_decode['ver_cpu_inc_by']).'" />
								</div>
							</div>
						</fieldset>
					</div>
				</div>';
			}
			echo'
		</div><br>
		
		<div class="roundheader cursor-pointer" onclick="toggle_advoptions(\'network\');"><label id="network_advoptions_ind" class="min_width">-</label> &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'.__('Network Settings').'</div>
		<div id="network_advoptions" class="w-100 bgaddv">
			<div class="row mx-auto w-100 my-3">
				<div class="col-sm-6 p-0">
					<label class="control-label">'.__('Upload Speed').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Enter 0 or leave empty for no restriction. <br /> Enter -1 for upload speed to be same as <b>Network Speed.</b> <br />Use the select box for easy options').'"><i class="fas text-primary fa-info-circle"></i></a></label>
				</div>
				<div class="col-sm-6 p-0">
					<div class="row mx-auto w-100">
						<div class="col-3 p-0">
							<input type="number" class="form-control" name="upload_speed" id="upload_speed" size="8" value="'.POSTval('upload_speed', $plan['upload_speed']).'" onchange="handle_capping();" />
						</div>
						<div class="col-2 p-0 p-1 pt-2 square mr-1">'.__('KB/s').'</div>
						<div class="col-7 p-0">
							<select class="custom-select speedkBps" name="upload_speed2" id="upload_speed2" onchange="upspeed(this.value)"></select>
						</div>
					</div>
				</div>
				
			</div>';

			$nics_lang = [
				'default' => __('Realtek 8139(default)'),
				'e1000' => __('Intel E1000'),
				'ne2k_pci' => __('Novell NE2000'),
				'virtio' => __('Virtio'),
				'i82559er' => __('Intel i82559er'),
				'pcnet' => __('AMD PCNET'),
				'ne2k_isa' => __('Novell E2000 ISA'),
				'vmxnet3' => __('VMware vmxnet3')
			];

			if(!empty($supported_nics)){
				echo '
				<div class="row mx-auto w-100 my-3 kvm xen xenhvm vzk proxk" id="nic_settings">
					<div class="col-sm-6 p-0">
						<label class="control-label">'.__('Virtual Network Interface Type').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Virtual Network Interface Type').'"><i class="fas text-primary fa-info-circle"></i></a></label>
					</div>
					<div class="col-sm-6 p-0">
						<select class="nic_type custom-select form-control w-100 side_text" name="nic_type" id="nic_type" >';
							
							foreach($supported_nics as $k => $v){
								echo '<option value="'.$v.'" '.ex_POSTselect('nic_type', $v, $plan['nic_type']).'>'.(!empty($nics_lang[$v]) ? $nics_lang[$v] : $v).'</option>';
							}
							
						echo'
						</select>
					</div>
				</div>
				';
			}
			echo '
			<div class="row mx-auto w-100 my-3">
				<div class="col-6 p-0">
					<label class="control-label">'.__('Bandwidth suspend ').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Suspend the VPS if it is uses more than specified bandwidth').'"><i class="fas text-primary fa-info-circle"></i></a></label>
				</div>
				<div class="col-6 p-0">
					'.get_checkbox('band_suspend', '', 'band_suspend', array('chk_it' => 1, 'val' => $plan['band_suspend']), 1, '', array('onchange="handle_capping();"')).'
				</div>
			</div>
			<div id="speed_cap_limit">
				<div class="row mx-auto w-100 my-3">
					<div class="col-sm-6 p-0">
						<label class="control-label">'.__('Capped Download Speed ').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Download speed after the bandwidth is overused for a VPS, 0 or emtpy value indicates no capping').'"><i class="fas text-primary fa-info-circle"></i></a></label>
					</div>
					<div class="col-sm-6 p-0">
						<div class="row mx-auto w-100">
							<div class="col-3 p-0">
								<input type="number" class="form-control" name="speed_cap_down" id="speed_cap_down" value="'.POSTval('speed_cap_down', $plan['speed_cap']['down']).'" onmouseout="blur();"/>
							</div>
							<div class="col-2 square mr-1">
								'.__('KB/s').'
							</div>
							<div class="col-7 p-0">
								<select class="custom-select speedkBps" name="speed_cap_down2" id="speed_cap_down2" onchange="$(\'#speed_cap_down\').val(this.value)"></select>
							</div>
						</div>
					</div>
				</div>
				<div class="row mx-auto w-100 my-3">
					<div class=" col-sm-6 p-0">
						<label class="control-label">'.__('Capped Upload Speed ').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Upload speed after the bandwidth is overused for a VPS.<br /> If VPS upload speed -1 then  Capped upload speed will be same as <b>Capped Download Speed</b><br />0 or emtpy value indicates no capping').'"><i class="fas text-primary fa-info-circle"></i></a></label>
					</div>
					<div class="col-sm-6 p-0">
						<div class="row mx-auto w-100">
							<div class="col-3 p-0">
								<input type="number" class="form-control" name="speed_cap_up" id="speed_cap_up" value="'.POSTval('speed_cap_up', $plan['speed_cap']['up']).'" onmouseout="blur();" />
							</div>
							<div class="col-2 square mr-1">
								'.__('KB/s').'
							</div>
							<div class="col-7 p-0">
								<select class="custom-select speedkBps" name="speed_cap_up2" id="speed_cap_up2" onchange="$(\'#speed_cap_up\').val(this.value)"></select>
							</div>
						</div>
					</div>
				</div>
			</div>
			<div class="row mx-auto w-100 my-3">
				<div class="col-sm-6 p-0">
					<label class="control-label">'.__('DNS Nameservers').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If not aware then use 4.2.2.1 and 4.2.2.2').'"><i class="fas text-primary fa-info-circle"></i></a></label>
				</div>
				<div class="col-sm-6 p-0">
					<div class="row mx-auto w-100 my-1">
							<div class="col-sm-12 p-0" id="dnstable">';
						 
								$_dns = @(empty($_POST['dns']) ? $plan['dns_nameserver'] : $_POST['dns']);
								
								if(is_array($_dns) && !empty($_dns)){
									foreach($_dns as $d => $ds){
										if(empty($ds)){
											unset($_dns[$d]);
										}
									}
								}
								
								if(empty($_dns)){
									$_dns = array(NULL);
								}
							 
								foreach($_dns as $dn){
									echo '<div class="row mx-auto w-100 my-1">
										<div class="col-sm-11 p-0">
											<input type="text" class="form-control w-100" name="dns[]" value="'.$dn.'"/>
										</div>
									</div>';
								}
								
							echo '
							</div>
						</div>
					<input type="button" class="btn mt-1 blue_btn py-1 px-2" onclick="adddnsrow(\'dnstable\')" value="'.__('+').'"/>
					<span class="help-block"></span>
				</div>
			</div>
		</div><br />';
		
		if(!empty($globals['inhouse_billing'])){
	
		echo '
		<div class="roundheader cursor-pointer" onclick="toggle_advoptions(\'pricing\');"><label id="pricing_advoptions_ind" class="min_width" >-</label> &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'.__('Pricing').'</div>
		<div id="pricing_advoptions" class="w-100 bgaddv" >
			<div class="row mx-auto w-100 my-3 ">
				<div class="col-2 p-0"><label>'.__('Regions').'</label></div>

					<div class="col-3">
						<label>'.__('Hourly Rate').'</label>
					</div>
					<div class="col-3 text-center">
						<label>'.__('Monthly Rate').'</label>
					</div>
					<div class="col-3 text-center">
						<label>'.__('Yearly Rate').'</label>
					</div>
			</div><hr />
			<div class="row mx-auto w-100 my-3" id="pricerowscontainer" >
			</div>
			<div class="row mx-auto w-100 my-3">
				<div class="col-sm-12 text-right p-0">
					<button type="button" class="btn blue_btn py-2 px-2" data-toggle1="modal" data-target1="#selectregionforpricing" onclick="selectregmod();" ><i class="fas fa-plus"></i></button>
				</div>
			</div>
			<div class="modal fade" id="selectregionforpricing" role="dialog">
				<div class="modal-dialog">
					<div class="modal-content">
						<div class="modal-header">
							<div class="modal-title float-left"><b>'.__('Select Region').'</b></div>
							<div class="close" data-dismiss="modal" >X</div>
						</div>
						<div class="modal-body"></div>
					</div>
				</div>
			</div>
		</div>
		<script>
			var ratetypes = ["h_rate", "m_rate", "y_rate"];
			
			// tmpsgs will act as a bucket, and store servergroups currently for which pricing is not added.
			var tmpsgs = JSON.parse(JSON.stringify(servergroups));
			
			// Fill and display modal with available servergroups
			function selectregmod(){
				
				if(JSON.stringify(tmpsgs) == "{}"){
					showalert("'.__J('No more regions left to add').'" ,"1");
					return;
				}
				
				var dv = "";
				dv += "<div class=\"row mh-25 p-1 overflow-auto\" id=\"sglist\">";
				
				for(var x in tmpsgs){
					if(tmpsgs.hasOwnProperty(x) && tmpsgs[x] != null){
						dv += "<div class=\"col-sm-6 p-0 selregrowclass\">";
							dv += "<div class=\"row\" id=\""+tmpsgs[x].sgid+"\" onclick=\"moreregionpricing(this); $(this).removeAttr(\'onclick\'); $(this).css(\'background-color\', \'var(--primary_color)\'); $(this).css(\'color\', \'var(--always_white)\');\">";
								dv += "<div class=\"col-sm-1\">"+(tmpsgs[x].sgid == -1 ? "*" : tmpsgs[x].sgid)+"</div>";
								dv += "<div class=\"col-sm-10\">"+tmpsgs[x].sg_name+"</div>";
							dv += "</div>";
						dv += "</div>";
					}
				}
				dv += "</div>";
				$("#selectregionforpricing .modal-body").html(dv);
				$("#selectregionforpricing").modal({keyboard: true});
				$("#selectregionforpricing").modal({show:true});
			}
			
			// Add selected region (servergroup) pricing row
			function moreregionpricing(selreg, reload){
				// Return back if we do not have a valid servergroup to add or if we are not reloading old values back.
				if(reload != 1 && (selreg == "" || $(selreg).attr("id") == null)){
					return false;
				}
				
				// Extract sgid
				var rsgid = (reload == 1 ? selreg : $(selreg).attr("id"));
				// Construct div for this sgid:
				var prow = "";
				prow += "<div class=\"row mx-auto w-100 my-1\" id=\"pricerow"+rsgid+"\">";
				prow += "<div class=\"col-2 p-0 text-break\">";
				prow += "<label>"+servergroups[rsgid].sg_name+"</label>";
				prow += "</div>";
				for(var i in ratetypes){
					prow += "<div class=\"col-3\">";
					prow += "<input type=\"number\" step=\"0.001\" class=\"form-control\" name=\""+ratetypes[i]+"["+rsgid+"]\" id=\""+ratetypes[i]+"["+rsgid+"]\" value=\"\" />";
					prow += "</div>";
				}
					
				prow += "<div class=\"col-1 text-right\">";
				prow += "<button type=\"button\" class=\"btn red_btn py-2 px-2\" onclick=\"removepricing(this)\"><i class=\"fas fa-minus\"></i></button>";
				prow += "</div>";
				prow += "</div>";
				
				
				// Append this new div to pricerowcontainer div
				$("#pricerowscontainer").append(prow);
				
				// Remove this servergroup from the tmpsgs bucket
				delete tmpsgs[rsgid];
			}
			
			// Remove selected region pricing row
			function removepricing(id){
				// Remove selected pricing region
				$("#"+$(id).parents().eq(1).attr("id")).remove();
				
				// Get Pricing Region ID (ie id of servergroup in servergroups)
				var tmpsgid = parseInt(/\-?\d+/.exec($(id).parents().eq(1).attr("id")));
				// If we did not got expected ID
				if(isNaN(tmpsgid)){
					showalert("'.__J('Delete ID not found').'" ,"1");
					return false;
				}
				// Add removed servergroup back to tmpsgs bucket
				tmpsgs[tmpsgid] = servergroups[tmpsgid];
			}
			
		';
			
			if(empty($_POST)){
				$_POST['h_rate'] = $plan['h_rate'];
				$_POST['m_rate'] = $plan['m_rate'];
				$_POST['y_rate'] = $plan['y_rate'];
			}
			
			// Are the rates posted ? Then we must add them
			if(!empty($_POST['h_rate'])){
				
				echo '
		$("#pricing_advoptions_ind").text(" - ");
		$("#pricing_advoptions").slideDown("slow");
		';
				
				foreach($_POST['h_rate'] as $kk => $vv){
					echo '
					moreregionpricing('.$kk.', 1);
					$("#h_rate\\\["+'.$kk.'+"\\\]").val("'.$_POST['h_rate'][$kk].'");
					$("#m_rate\\\["+'.$kk.'+"\\\]").val("'.$_POST['m_rate'][$kk].'");
					$("#y_rate\\\["+'.$kk.'+"\\\]").val("'.$_POST['y_rate'][$kk].'");
					';
					
				}
				
			}
			
		echo '</script>';

		}
		
		echo'		
	</div>
</div>';

echo '
<br /><br />
<center><input type="submit" value="'.__('Save Plan').'" class="go_btn mt-5" name="editplan"></center><br><br><br>
</form>
</div>';

softfooter();

}

