<?php

//////////////////////////////////////////////////////////////
//===========================================================
// editfirewall_plan_theme.php
//===========================================================
// SOFTACULOUS VIRTUALIZOR
// Version : 1.0
// Inspired by the DESIRE to be the BEST OF ALL
// ----------------------------------------------------------
// Started by: Alons
// Date:       8th Mar 2010
// Time:       23:00 hrs
// Site:       https://www.virtualizor.com/ (SOFTACULOUS VIRTUALIZOR)
// ----------------------------------------------------------
// Please Read the Terms of use at https://www.virtualizor.com
// ----------------------------------------------------------
//===========================================================
// (c)Softaculous Ltd.
//===========================================================
//////////////////////////////////////////////////////////////

if(!defined('VIRTUALIZOR')){

	die('Hacking Attempt');

}

function editfirewall_plan_theme(){

global $l, $theme, $globals, $kernel, $user, $l, $info, $error, $done, $protocol_array, $firewall_plan, $for_servers;

softheader($l['<title>']);
					
error_handle($error);

if(!empty($done)){
	show_alert(__('The firewall plan has been sucessfully saved') ,"0" , (!empty($for_servers) ? "server_firewall_plans" : "firewall_plans"));
}

echo '
<script type="text/javascript" charset="utf8" src="'.$theme['url'].'/js2/jquery.dataTables.min.js"></script>';

echo page_header(__('Edit Firewall Plan'), 'fas fa-fire-alt', '', 1, 0, '');

$breadcrumbs = ['dashboard', !empty($for_servers) ? 'lm_server_firewall_plans' :'lm_vpsfirewall_plans', 'lms_editfirewall_plan'];

echo get_breadcrumb($breadcrumbs);

echo'
<script type="text/javascript">

$(document).ready(function(){

	$("nav").removeClass("ml-2");
	$(".breadcrumb").addClass("p-0");
	
	if (!$.fn.DataTable.isDataTable( "#managerules")) {

		$("#managerules").DataTable({
			sorting :false,
			paging: false,
			info: false,
			ordering : false,
			searching : false,
			"language": {
				"emptyTable": "'.__J('No rules added in the Plan').'"
			},
			"columnDefs": [
					{ className: "width-1 text-left", "targets": [ 0 ] },
					{ className: "width-10 text-left", "targets": [ 1 ] },
					{ className: "width-10 text-left", "targets": [ 2 ] },
					{ className: "width-10 text-left", "targets": [ 3 ] },
					{ className: "width-20 text-left", "targets": [ 4 ] },
					{ className: "width-25 text-left", "targets": [ 5 ] },
					{ className: "width-35 text-left", "targets": [ 6 ] },
					{ className: "width-12 text-right", "targets": [ 7 ] }
			],
			"fnDrawCallback" : function(){
				// $("#managerules thead").remove();
				rows = $("#managerules").DataTable().rows().nodes();
				rows_length = rows.length;
				if(!empty(rows_length)){
	
					$.each(rows, function(index){
						$("td:first", this).html(index + 1);
					});
	
				}
	
			}
		});
	
	}else{
	
		$("#managerules").DataTable().clear().draw();
	
	}

	$("#search_rule").on("keyup", function(){
		
		var value = $(this).val().toLowerCase();

		$("#managerules_body tr").filter(function() {
			$(this).toggle($(this).text().toLowerCase().indexOf(value) > -1)
		});

	});
	
	';

	if(!empty($firewall_plan)){

		$rules = $firewall_plan['rules'];

		echo '
		let rules = "";
		let html = "";
		rules = '.$rules.';
		fwp = '.json_encode($firewall_plan).';

		$("#fwp_name").val(fwp["fw_plan_name"]);
		$("#default_policy").val(fwp["default_policy"]);
		(!empty(fwp["admin_default"]) ? $("#admin_default").prop("checked", "checked") : "");
		$("#firewall_plan_id").val(fwp["fwid"]);
		
		if(!empty(rules)){

			let firewallplan_table = $("#managerules").DataTable();
			let ip_version = "";
			
			$("#managerules tbody").attr("id", "managerules_body");

			rules.forEach((item, index) => {
				rule = item.split(" ");
				if(rule[0] == 4){
					class_name = "class=\"ipv4_rule\"";
					ip_version = "'.__J('IPv4').'";
				}

				let row_count = index + 1;
				let ip_type = rule[0];
				let direction_val = rule[1];
				let decision_val = rule[2];
				let protocol_val = rule[3];
				let port_num = rule[4];
				let src_addr = rule[5];

				let old_rows = firewallplan_table.row.add(
					["",
					"<input type=\"hidden\" name=\"direction[]\" value=\""+direction_val+"\" />"+direction_val,
					"<input type=\"hidden\" name=\"ip[]\" value=\""+ip_type+"\" />"+ip_version,
					"<input type=\"hidden\" name=\"decision[]\" value=\""+decision_val+"\" />"+decision_val, 
					"<input type=\"hidden\" id=\"fwr_protocol_"+row_count+"\" name=\"protocol[]\" value=\""+protocol_val+"\" />"+protocol_val, 
					"<input type=\"hidden\" id=\"fwr_port_"+row_count+"\" name=\"port[]\" value=\""+port_num+"\" />"+port_num,
					"<input type=\"hidden\" name=\"source_addr[]\" value=\""+src_addr+"\" />"+src_addr, 
					"<div class=\"badge_container\"><span class=\"\"><a class=\"badge badge-yellow\"><i class=\"fas fa-pencil-alt\" onclick=\"edit_row(this)\" title=\"'. __J('Edit this record').'\"></i></a></span>" +
					"<span class=\"\"><a class=\"badge badge-trash\" class=\"mx-2\"><i class=\"fas fa-trash\" onclick=\"delete_rule(this);\"></i></a></span></div>"
					]
				).draw(false).node();

				$(old_rows).attr("id", "fwr_"+row_count);

			});
		}
		';

	}
echo '});

function port_sanitizing(ports){
	// remove all empty spaces first
	sanitize_port = ports.replaceAll(" ", "");

	// remove last comma if remaining
	sanitize_port = sanitize_port.replace(/,\s*$/, "");

	// remove all @#$ all all special characters instead of " , " and " : "
	let unnecessory_port = sanitize_port.match(/[^a-zA-Z0-9:,]+/g);

	if(!empty(unnecessory_port)){
		showalert(`'.__J('Please Enter Valid port').' (<b>\"${unnecessory_port}\"</b> - '.__J('Please remove this from port section').') </br></br> Port values can be comma separated ports or range like (4081:4085) or ALL to allow all ports. (eg. 22,25,4081:4085)`, 1);
		return false;
	}
	
	// return sanitize port
	return sanitize_port;

};

function addfirewallrule(){

	let protocol = $("#fwr_protocol_0").val();
	let ports = $("#fwr_port_0").val();
	let sanitize_port = "";

	// sanitizing port if exist before check the final error
	if(!empty(ports)){
		sanitize_port = port_sanitizing(ports)
	}

	if(sanitize_port === false){
		return false;
	}

	if(protocol == 0){
		showalert("'.__J('No protocol provided').'", 1);
		return false;
	}

	let direction = $("#direction").val();
		if(direction == 0){
		showalert("'.__J('Please specify direction for firewall rule').'", 1);
		return false;
	}
	
	if( sanitize_port == "" && !(protocol == "icmp" || protocol == "gre" || protocol == "esp") ){

		showalert("'.__J('No port specified').'", 1);
		return false;

	}else if( !empty(sanitize_port) && !(protocol == "icmp" || protocol == "gre" || protocol == "esp") ){
		
		let port_list = sanitize_port;
		let ports = port_list.split(",");
		let invalid_ports = [];

		ports.forEach( ( item, index ) => {

			if( item < 0 || item > 65535 ){
				
				invalid_ports.push(item);

			}

		});

		if(!empty(invalid_ports)){

			invalid_port_list = invalid_ports.join(" ,");

			showalert( "<b>" + invalid_port_list + "</b> '.__J('Invalid Ports').'", 1 );
			return false;
			
		}
	}

	if($("#source_addr").val() == ""){
		showalert("'.__J('Empty Source Address').'", 1);
		return false;
	}

	if($("#iptype").val() == 4){
		iptype = "IPv4";
	}else{
		iptype = "IPv6";
	}

	let protocol_val = $("#fwr_protocol_0").val();
	let protocol_display = $("#fwr_protocol_0 option:selected").html();
	
	let direction_val = $("#direction").val();
	let direction_display = $("#direction option:selected").html();

	let decision_val = $("#decision").val();
	let decision_display = $("#decision option:selected").html();

	let tcp_array = ["http", "tcp", "https", "mysql", "postgresql", "rdp"];
	let udp_array = ["udp", "dnsudp"];

	if(tcp_array.indexOf(protocol_val) != -1){
		protocol_display = "TCP";
		protocol_val = "tcp";
	}

	if(udp_array.indexOf(protocol_val) != -1){
		protocol_display = "UDP";
		protocol_val = "udp";
	}

	if( protocol == 0 && "#source_addr".val() == "" && sanitize_port == "" && !(protocol == "icmp" || protocol == "gre" || protocol == "esp" && direction == 0) ){
		$("#firewall_submit").hide();
	}else{
		$("#firewall_submit").show();
	}

	let firewallplan_table = $("#managerules").DataTable();
	let last_row_id = $("#managerules_body tr:last").attr(\'id\');
	let new_id = 1;
		
	if(last_row_id){
		new_id = last_row_id.replace(/\D+/g, "");
		new_id = Number(new_id) + 1;
	}
	
	var new_row = firewallplan_table.row.add(

		["",
		"<input type=\"hidden\" name=\"direction[]\" value=\""+direction_val+"\" />"+direction_display,
		"<input type=\"hidden\" name=\"ip[]\" value=\""+$("#iptype").val()+"\" />"+iptype,
		"<input type=\"hidden\" name=\"decision[]\" value=\""+decision_val+"\" />"+decision_display, 
		"<input type=\"hidden\" id=\"fwr_protocol_"+new_id+"\" name=\"protocol[]\" value=\""+protocol_val+"\" />"+protocol_display,
		"<input type=\"hidden\" id=\"fwr_port_"+new_id+"\" name=\"port[]\" value=\""+sanitize_port+"\" />"+sanitize_port,  
		"<input type=\"hidden\" name=\"source_addr[]\" value=\""+$("#source_addr").val()+"\" />"+$("#source_addr").val(), 
		"<div class=\"badge_container\"><span class=\"\"><a class=\"badge badge-yellow\"><i class=\"fas fa-pencil-alt\" onclick=\"edit_row(this)\" title=\"'. __J('Edit this record').'\"></i></a></span>" +
		"<span class=\"\"><a class=\"badge badge-trash\" class=\"mx-2\"><i class=\"fas fa-trash\" onclick=\"delete_rule(this);\"></i></a></span></div>"
		]

	).draw(false).node();

	// adding class and the id for each row
	$(new_row).addClass("highlighted_row")
	$(new_row).attr("id", "fwr_"+new_id);

	setTimeout(function() {
		$(new_row).removeClass("highlighted_row");
	}, 2000);

	// after row draw we need to clean the all inputs from the port and sorce IP address
	$("#fwr_port_0").val("");
	$("#source_addr").val("");

}

function delete_rule(element){
	let table = $("#managerules").DataTable();
	table.row($(element).parents("tr")).remove().draw();
}

function edit_row(el) {

    var row = $(el).closest("tr");
    var td_cells = row.find("td");
    if (row.data("editing")) return;
    row.data("editing", true);
	let port_disabled = "";

    // Loop through editable td_cells
    for (let i = 1; i <= 6; i++) {
        let td_cell = td_cells.eq(i);
        let input = td_cell.find("input[type=\"hidden\"]");
        let val = input.val();
		let td_id = input.attr("id");

		// convert the php array to js Object
		let temp_protocol = \''.json_encode($protocol_array).'\';
		let protocol = JSON.parse(temp_protocol);

		if(i == 4){
			let check_protocol = document.getElementById(td_id).value;
			console.log("check protocol = "+check_protocol);

			if(check_protocol == "ESP" || check_protocol == "GRE" || check_protocol == "ICMP"){
				port_disabled = "disabled";
			}else{
				port_disabled = "";
			}
		}

        let html = "";

        switch (i) {

			// code to convert the input to select
            case 1: // direction[]
                html = `<select class="form-control form-control-sm" name="direction[]">
                            <option value="IN"" ${val === "IN" ? " selected" : ""} ">IN</option>
                            <option value="OUT""  ${val === "OUT" ? " selected" : ""} ">OUT</option>
                       </select>`;
                break;
			
			// code to convert the input to select
            case 2: // ip[]
                html = `<select class="form-control form-control-sm" name="ip[]">
                            <option value="4" ${val === "4" ? " selected" : ""} ">IPv4</option>
                       </select>`;
                break;

			// code to convert the input to select
            case 3: // decision[]
                html = `<select class="form-control form-control-sm" name="decision[]">
                        <option value="ACCEPT" ${val === "ACCEPT" ? " selected" : ""} + ">ACCEPT</option>
                        <option value="DROP" ${val === "DROP" ? " selected" : ""} + ">DROP</option>
                       </select>`;
                break;

			// code to convert the input to select
            case 4: // protocol[]
                html = `<select class="form-control form-control-sm" id=\"${td_id}\" name="protocol[]" onchange="protocol_check(this);">`;
                for (let protocol_option of protocol) {
                    html += `<option value="${protocol_option}" ${val === protocol_option ? " selected" : ""}> ${protocol_option} </option>`;
                }
                html += `</select>`;
                break;

            case 5: // port[]
                html = `<input type="text" id=\"${td_id}\" class="form-control form-control-sm" name="port[]" value="${ val}" ${port_disabled}>`;
                break;

            case 6: // source_addr[]
                html = `<input type="text" class="form-control form-control-sm" name="source_addr[]" value="${val}">`;
                break;
        }

        td_cell.html(html);
    }

    // Update action buttons to "save" state
    var action_td_cell = td_cells.last();
    action_td_cell.html(
        "<div class=\"badge_container\">" +
			"<span>" +
				"<a class=\"badge badge-manage cursor-pointer\" title=\"Save this record\" onclick=\"save_row(this)\" aria-label=\"Save\">" +
					"<i class=\"fas fa-save\"></i>" +
				"</a>" +
			"</span>" +
			"<span>" +
				"<a class=\"badge badge-trash cursor-pointer\" title=\"Delete this record\" aria-label=\"Delete\">" +
					"<i class=\"fas fa-trash\" onclick=\"delete_rule(this);\"></i>" +
				"</a>" +
			"</span>" +
		"</div>"
    );
}

function save_row(el) {
    var row = $(el).closest("tr");
    var td_cells = row.find("td");

    var fields = ["direction[]", "ip[]", "decision[]", "protocol[]", "port[]", "source_addr[]"];

    for (var i = 1; i <= fields.length; i++) {
        var cell = td_cells.eq(i);
        var input = cell.find("select, input");
        var val = input.val();
        let td_id = input.attr("id");
		
		// sanitizing the port if editing is choose by user
		if (fields[i - 1] === "port[]") {
			val = port_sanitizing(val);
		}

        var selected_value = input.find("option:selected").text() || val;

        // Revert cell to display mode with hidden input
        cell.html(`<input type="hidden" id="${td_id}" name="${fields[i - 1]}" value="${val}"/>${selected_value}`);
    }

    // Restore Edit/Delete buttons
    var action_td_cell = td_cells.last();

    action_td_cell.html(
        `<div class="badge_container">
            <span>
                <a class="badge badge-yellow cursor-pointer" title="Edit this record" aria-label="Edit">
                    <i class="fas fa-pencil-alt" onclick="edit_row(this)"></i>
                </a>
            </span>
            <span>
                <a class="badge badge-trash cursor-pointer" title="Delete this record" aria-label="Delete">
                    <i class="fas fa-trash" onclick="delete_rule(this);"></i>
                </a>
            </span>
        </div>`
    );

    row.removeData("editing");
}

function edit_row_afterips(self, vdfid, vpsips){
	var coleditelms = {};
	coleditelms["protocol"] = "<span class=\"coledit\">";
	coleditelms["protocol"] += "<select id=\""+vdfid+"_protocol_edit\" class=\"virt-select\" onchange=\"handleprotochange(this, "+vdfid+");\">";
	$.each($supported_protocols, function(i,t){
		coleditelms["protocol"] += "<option value=\""+t+"\" "+($("#"+vdfid+"_protocol .coldat").html() == t ? "selected=\"selected\"" : "")+">"+t+"</option>";
	});
	coleditelms["protocol"] += "</select></span>";
	
	coleditelms["src_hostname"] = "<span class=\"coledit\">";
	coleditelms["src_hostname"] += "<input id=\""+vdfid+"_src_hostname_edit\" type=\"text\" class=\"form-control\" value=\""+$("#"+vdfid+"_src_hostname .coldat").html()+"\" />";
	coleditelms["src_hostname"] += "</span>";
	
	coleditelms["src_port"] = "<span class=\"coledit\">";
	coleditelms["src_port"] += "<input id=\""+vdfid+"_src_port_edit\" type=\"text\" class=\"form-control\" value=\""+$("#"+vdfid+"_src_port .coldat").html()+"\" />";
	coleditelms["src_port"] += "</span>";
	
	coleditelms["dest_ip"] = "<span class=\"coledit\">";
	coleditelms["dest_ip"] += "<select id=\""+vdfid+"_dest_ip_edit\" class=\"virt-select\">";
	
	$.each(vpsips, function(i,t){
		coleditelms["dest_ip"] += "<option value=\""+i+"\" "+($("#"+vdfid+"_dest_ip .coldat").html() == i ? "selected=\"selected\"" : "")+">"+i+"</option>";
	});
	coleditelms["dest_ip"] += "</select></span>";
	
	coleditelms["dest_port"] = "<span class=\"coledit\">";
	coleditelms["dest_port"] += "<input id=\""+vdfid+"_dest_port_edit\" type=\"text\" class=\"form-control\" value=\""+$("#"+vdfid+"_dest_port .coldat").html()+"\" />";
	coleditelms["dest_port"] += "</span>";
	
	
	$.each(coleditelms, function(i, t){
		$("#"+vdfid+"_"+i+" .coledit").remove();
		$("#"+vdfid+"_"+i).append(coleditelms[i]);
		$("#"+vdfid+"_"+i+" .coldat").css("display", "none");
		$("#"+vdfid+"_"+i+" .coledit").css("display", "block");
	});
	
	var revertimg = "<a class=\"badge badge-yellow mr-1\"><i class=\""+vdf_revert_ico+"\" onclick=\"revert_vdf(this, "+vdfid+");\" data-toggle=\"tooltip\" data-placement=\"auto\" title=\"{{Revert changes made to this record}}\" ></i></a><a class=\"badge badge-manage\"><i class=\""+vdf_save_ico+"\" onclick=\"save_vdf(this);\" data-toggle=\"tooltip\" data-placement=\"auto\" title=\"{{Save changes made to this record}}\" ></i></a>";
	$("#"+vdfid+"_edit").append(revertimg);
	$(self).remove();
	
	$("#"+vdfid+"_protocol select").trigger("change");
	$(".virt-select").select2({width:"100%"});
	// Add search feature to select and adjust select height
	$(document).ready(function(){
		show_tooltip();
	});
};

function hide_down(){
	$("#fwr_port_0").val("");
	$("#managerules").DataTable().clear().draw();
}


</script>
<div class="card p-2 mx-3">
	<form accept-charset="UTF-8" id="editfirewallform" action="" method="post" name="editfirewall" class="form-horizontal">
		<div class="p-2">
			<div class="row">
				<div class="col col-lg-4 col-md-4 col-sm-12">
					<div class="d-flex align-items-center">
						<label for="fwp_name" class="control-label d-inline-block mr-1 font-500">'.__('Enter Plan Name').'</label>
						<span class="info-text" tooltip="'.__('Specify firewall plan name.').'"><i class="fas text-primary fa-info-circle" aria-hidden="true"></i></span>
					</div>
					<div class="my-auto py-2">
						<input type="text" class="form-control" id="fwp_name" name="fwp_name" value="'.POSTval('fwp_name', '').'" required/>
					</div>
				</div>
				<div class="col-lg-4 col-md-4 col-sm-12">
					<div class="d-flex align-items-center">
						<label for="default_policy" class="control-label d-inline-block mr-1 font-500">'.__('Default Policy').'</label>
						<span class="info-text" tooltip="'.__('Set the default policy for traffic. You can set the default as ACCEPT / DROP and as per this policy default traffic will be Allowed / Denied respectively.').'"><i class="fas text-primary fa-info-circle" aria-hidden="true"></i></span>
					</div>
					<div class="my-auto py-2">
						<span style="text-align: top;">
							<select name="default_policy" class="select2 custom-select" id="default_policy">
								<option value="0">'.__('DROP').'</option>
								<option value="1">'.__('ACCEPT').'</option>
							</select>
						</span>
					</div>	
				</div>
				<div class="col-lg-4 col-md-4 col-sm-12 d-flex align-items-end py-2">
					<div class="w-100 d-flex justify-content-end">
						<input id="search_rule" placeholder="'.__('Quick Search (IP, Port, Protocol, action)').'" class="w-100 form-control h-100 d-inline-block search-box p-2">
					</div>
				</div>
			</div>
			
			<div class="row">
				<div class="col-sm-12 px-3 py-3">
					<table class="table tablesorter table-hover common-table w-100 mb-0" id="editfirewall_rules" >
						<thead>
							<tr>
								<th class="width-1"> '.__('#').'</th>
								<th class="width-10"> '.__('Direction').'</th>
								<th class="width-10"> '.__('IP Type').'</th>
								<th class="width-10"> '.__('Decision').'</th>
								<th class="width-20"> '.__('Protocol').'</th>
								<th class="width-25"> '.__('Port').'</th>
								<th class="width-35"> '.__('IP').'</th>
								<th class="text-right width-10"> '.__('Action').'</th>
							</tr>
						</thead>
						<tbody>
							<tr id="fwr_0">
								<td  class="width-1" style="padding-top: 22px !important;">
									#
								</td>
								<td  class="width-10">
									<select class="form-control mx-auto select-medium" onchange="" id="direction">
										<option value= "IN">'.__('IN').'</option>
										<option value = "OUT">'.__('OUT').'</option></select>
								</td>
								<td  class="width-10">
									<select class="form-control mx-auto select-medium" id="iptype">
									<option value="4">'.__('IPv4').'</option></select>	
								</td>
								<td  class="width-10">
									<select class="form-control mx-auto select-medium" id="decision">
										<option value="ACCEPT">'.__('ACCEPT').'</option>
										<option value="DROP">'.__('DROP').'</option>
									</select>	
								</td>
								<td  class="width-10">
									<select class="virt-select mx-auto custom-select" onchange="protocol_check(this);" id="fwr_protocol_0" name="fwr_protocol_0">';
									foreach($protocol_array as $k){
										echo '<option value="'.$k.'" >'.$k.'</option>';
									}
									echo '</select>
								</td>
								<td class="width-20">
									<input type="text" class="form-control mx-auto" id="fwr_port_0" placeholder="'.__('ALL or PORT').'"/>
								</td>
								<td class="width-25">
									<input type="hidden" name="iptype" id="iptype" value="4">
									<input type="text" class="text-left form-control mx-auto" id="source_addr" placeholder="0.0.0.0/0"/>
								</td>
								<td class="text-right" class="width-9">
									<div class="badge_container">
										<a class="badge badge-settings">
											<i class="fas fa-plus" onclick="addfirewallrule()" tooltip="'.__('Add This Rule').'"></i>
										</a>
									</div>
								</td>
							</tr>
						</tbody>
					</table>
					<table id="managerules" class="mt-4 table table-striped common-table table-hover tablesorter">
						<thead>
							<tr class="table_heading">
								<th> '.__('#').'</th>
								<th> '.__('Direction').' </th>
								<th> '.__('IP Type').' </th>
								<th> '.__('Decision').' </th>
								<th> '.__('Protocol').' </th>
								<th> '.__('Port').' </th>
								<th> '.__('IP').' </th>
								<th> '.__('Action').' </th>
							</tr>
						</thead>
					</table>
				</div>
			</div>
			<div class="mx-auto px-2 d-flex align-items-center justify-content-center">
				<div>
					<input type="hidden" name="fwid" id="firewall_plan_id" value="">
					<input type="hidden" name="save_firewall" id="save_firewall" value="1">
					<button type="submit" id="firewall_submit" class="go_btn button-fix  border-0 mx-1"><i class="fas pr-2 fa-edit"></i>'.__('Edit').'</button>
					<button type="reset" id="firewall_reset" class="go_btn button-fix bg-danger border-0 mx-1" onclick="hide_down();"><i class="fas pr-2 fa-redo"></i>'.__('Reset').'</button>
				</div>
			</div>
			<div class="col-sm-12 mx-auto px-3">
				<div class="col-sm-12 px-3 py-3">
					<div class="row px-3">
								<div class="col-12 rounded px-4 py-3 description-shadow info_card">
								<div class="row">
									<div class="col-12 py-2 border-bottom"><h6>'.__('Note').'</h6>
									</div>
								</div>
								<div class="row">
									<div class="col-6 py-2">
										<div class="font-600">'.__('Direction').'
										</div>
										<div>'.__('The direction of the packets to and fro the VM. Possible values IN/OUT').'
										</div>
									</div>
									<div class="col-6 py-2">
										<div class="font-600">'.__('IP Type').'
										</div>
										<div>'.__('Version of the IP protcol. Currently IPv4 only.').'
										</div>
									</div>
								</div>
								<div class="row">
									<div class="col-6 py-2">
										<div class="font-600">'.__('Decision').'
										</div>
										<div>'.__('By default we DROP all the packets. We allow only ACCEPT rules.').'
										</div>
									</div>
									<div class="col-6 py-2">
										<div class="font-600">'.__('Protocol').'
										</div>
										<div>'.__('TCP, UDP, GRE, ICMP Protocols that are supported.').'
										</div>
									</div>
								</div>
								<div class="row">
									<div class="col-6 py-2">
										<div class="font-600">'.__('Port').'
										</div>
										<div>'.__('Port values can be comma separated ports or range like (4081:4085) or ALL to allow all ports. (eg. 22,25,4081:4085)').'
										</div>
									</div>
									<div class="col-6 py-2">
									</div>
								</div>
								<div class="row">
									<div class="col-6 py-2">
										<div class="font-600">'.__('IP').'
										</div>
										<div>'.__('IP or Subnet for which rule is to be applied.<br>(Valid Entries : Individual IP address, Subnet or 0.0.0.0/0 for all IPs)').'
										</div>
									</div>
									<div class="col-6 py-2">
									</div>
								</div>
							</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</form>
</div>
';

softfooter();

}

?>