<?php

//////////////////////////////////////////////////////////////
//===========================================================
// dashboard_theme.php
//===========================================================
// SOFTACULOUS VIRTUALIZOR
// Version : 1.0
// Inspired by the DESIRE to be the BEST OF ALL
// ----------------------------------------------------------
// Started by: Alons
// Date:       8th Mar 2010
// Time:       23:00 hrs
// Site:       https://www.virtualizor.com/ (SOFTACULOUS VIRTUALIZOR)
// ----------------------------------------------------------
// Please Read the Terms of use at https://www.virtualizor.com
// ----------------------------------------------------------
//===========================================================
// (c)Softaculous Ltd.
//===========================================================
//////////////////////////////////////////////////////////////

if(!defined('VIRTUALIZOR')){

	die('Hacking Attempt');

}

function adminindex_theme(){

global $theme, $globals, $cluster, $user, $l, $stats, $servers, $users, $bandwidth,$task_action;

$acl_cluster_statistics = is_allowed("cluster_statistics");
$acl_server_statistics = is_allowed("server_statistics");

softheader($l['<title>']);
$num_virts = array('openvz', 'kvm', 'xen', 'xenhvm', 'xcp', 'xcphvm', 'lxc', 'vzo', 'vzk', 'proxl', 'proxk');

$virt_lang['num_openvz'] = __('OpenVZ');
$virt_lang['num_kvm'] = __('KVM');
$virt_lang['num_xen'] = __('Xen');
$virt_lang['num_xenhvm'] = __('Xen HVM');
$virt_lang['num_xcp'] = __('Xen Server');
$virt_lang['num_xcphvm'] = __('Xen Server HVM');
$virt_lang['num_lxc'] = __('LXC');
$virt_lang['num_vzo'] = __('Virtuozzo OpenVZ');
$virt_lang['num_vzk'] = __('Virtuozzo KVM');
$virt_lang['num_proxl'] = __('Proxmox LXC');
$virt_lang['num_proxk'] = __('Proxmox KVM');

if(!empty($stats['num_vps'])) {
	$table_vps = '';
	foreach($num_virts as $v){
		if(!empty($stats['num_'.$v])){
			$table_vps .= '<div class="row text-left mx-auto w_100_tp_vps"><div class="col-9 p-0" ><small>'.$virt_lang['num_'.$v].'</small></div><div class="col-3 p-0"><small>'.$stats['num_'.$v].'</small></div></div>';
		}
	}
} else {
	$table_vps = '';
}
if(!empty($stats['num_total_users'])) {
	$table_users = ''.
	(!empty($stats['num_admins']) ? '<div class="row text-left mx-auto w_100_tp"><div class="col-8 p-0"><small>'.__('Admin').'</small></div><div class=" p-0 text-left"><small>'.$stats['num_admins'].'</small></div></div>' : '').
	(!empty($stats['num_clouds']) ? '<div class="row text-left mx-auto w_100_tp"><div class="col-8 p-0"><small>'.__('Cloud').'</small></div><div class=" p-0 text-left"><small>'.$stats['num_clouds'].'</small></div></div>' : '').
	(!empty($stats['num_users']) ? '<div class="row text-left mx-auto w_100_tp"><div class="col-8 p-0"><small>'.__('End Users').'</small></div><div class=" p-0 text-left"><small>'.$stats['num_users'].'</small></div></div>' : '').
	'</table>';
} else {
	$table_users = '';
}

echo '<style type="text/css">

	.select2-selection{
		border: none !important;
		font-size: 15px;
		box-shadow: rgba(0, 0, 0, 0.1) 0px 3px 5px;
	}
	.resource_gr {
		border-radius: 4px;
		color: #FFFFFF;
		height:95%;
	}
	.resource_header {
		font-weight: 300;
		padding: 8px;
		font-size: 16px;
		text-align: center;
	}
	.resource_content {
		font-size: 16px;
		padding: 14px 16px 8px 16px;
		text-align: center;
	}
	.resource_container {
		display: inline-block;
		text-align: center;
		height: 80px;
		width: 80px;
		position: relative;
	}
	.resource_container .text {
		line-height: 80px;
		height: 100%;
	}
	.resource_container .chart-2 {
		position: absolute;
		top: 0;
		left: 0;
	}
	.resource_value {
		font-size: 12px;
		margin-top: 8px;
	}
	
	#search-input {
		transition: all 0.5s;
		float: right;
		width: 100%;
	}
	#search-input.collapsed {
		width: 0;
		padding: 0;
		border: 0;
	}
	
	#cluster_stats [class*=col] {
		margin-bottom: 8px;
	}
	
	.dash {
		border-radius: 0px;
		height: 80px;
		position: relative;
	}
	.dash-text {
		position: absolute;
		left: 12px;
		top: 12px;
	}
	.dash-title {
		position: absolute;
		left: 12px;
		bottom: 12px;
	}
	.dash .badge {
		background-color:rgba(0,0,0,0.5);
		font-size: 14px !important;
		color:#fff;
	}
	.dash i {
		position: absolute;
		right: 12px;
		top: 12px;
		font-size: 48px;
		opacity: 0.4;
	}
	.dash.compact .badge {
		font-size: 18px;
	}
	.dash.compact i {
		font-size: 36px;
	}
	.dash.compact .dash-title {
		font-size: 11px;
	}
	
	.server_gr {
		text-align: center;
	}
	.server_gr .title {
		font-size: 16px;
		font-weight: bold;
		margin: 20px 0 16px 0;
		text-transform: uppercase;
	}
	.server_gr .content {
		display: inline-block;
		position: relative;
		height: 140px;
		width: 140px;
	}
	.server_gr .content .text {
		display: table-cell;
		vertical-align: middle;
		width: 140px;
		height: 140px;
	}
	.server_gr .content .text div {
		margin-left: auto;
		margin-right: auto;
	}
	.server_gr .content .value {
		font-size: 16px;
	}
	.server_gr .chart {
		position: absolute;
		top: 0;
		left: 0;
		display: inline-block;
	}
	.server_gr .bottom-text {
		margin: 12px 0;
	}
	
	table.tool {
		width: 150px;
		margin: 4px;
	}
	table.tool td {
		padding: 4px;
	}
	
	.panel {
		min-height: 120px;
	}
	.panel-content {
		max-height: 200px;
		overflow: hidden;
	}
	.panel.panel-red {
		border-color: #EF5350;
	}
	.panel.panel-red .panel-heading {
		background-color: #EF5350;
		border-color: #EF5350;
		color: #fff;
	}
	.panel.panel-red1 .table-dash thead tr {
		background-color: #EF5350CC;
		color: #fff;
	}
	.panel.panel-blue {
		border-color: #3083FF;
	}
	.panel.panel-blue .panel-heading {
		background-color: #3083FF;
		border-color: #3083FF;
		color: #fff;
	}
	.panel.panel-blue1 .table-dash thead tr {
		background-color: #3083FFCC;
		color: #fff;
	}
	.panel.panel-blue-grey {
		border-color: #607D8B;
	}
	.panel.panel-blue-grey .panel-heading {
		background-color: #607D8B;
		border-color: #607D8B;
		color: #fff;
	}
	.panel.panel-blue-grey1 .table-dash thead tr {
		background-color: #607D8BCC;
		color: #fff;
	}
	
	.table-dash {
		margin-bottom: 4px;
	}
	.table-dash tbody tr td {
		vertical-align: middle;
	}
	.table-dash tr td:first-child, .table-dash tr th:first-child {
		padding-left: 16px;
	}
	.table-dash tr td:last-child, .table-dash tr th:last-child {
		padding-right: 16px;
	}
	
	.btn-logs {
		
		margin : 0;
		padding : 1px 12px;
		font-size : 10px;
		height : 28px;

	}

	.table td {
		padding : 0.5rem;
	}


</style>
<script>

$(function () {
	get_live_resource($("#band_ser").val());
});

var timer_server_loads; 
function get_live_resource(serid){

	var load_once_flag = $("#load_once_flag").val();
	if(empty(load_once_flag)){
		$(".show-loading").show();
	}

	var month = getCurrentMonthDetails();

	var d1 = Array(30).fill("0");
	var d2 = Array(30).fill("0");

	var bw_options = {
		chart: {
			type: "area",
			stacked: false,
			height:270
		},
		dataLabels: {
			enabled: false
		},
		colors: ["#3B82F6", "#3ECE74"], 
		plotOptions: {
			line: {
				dropShadow: {
					enabled: true,
					top: 2,
					left: 2,
					blur: 4,
					opacity: 0.5,
					color: "#FF4560" 
				}
			}
		},
		series: [
			{
				name: "'.__J('Bandwidth IN').'",
				data: d1,
				color: "#3B82F6",
				fill: {
					type: "gradient",
					gradient: {
						shade: "light",
						type: "vertical",
						shadeIntensity: 1,
						gradientToColors: ["#3B82F6"],
						opacityFrom: 0.4,
						opacityTo: 0.1,
						stops: [0, 100]
					}
				}
			}, 
			{
				name: "'.__J('Bandwidth OUT').'",
				data: d2,
				color: "#3ECE74",
				fill: {
					type: "gradient",
					gradient: {
						shade: "light",
						type: "vertical",
						shadeIntensity: 1,
						gradientToColors: ["#3ECE74"],
						opacityFrom: 0.4,
						opacityTo: 0.1,
						stops: [0, 100]
					}
				}
			}
		],
		xaxis: {
			categories: month["days"],
			labels: {
				formatter: function(value, timestamp, index) {
					// Show only odd numbers
					if (value % 2 === 0) {
						// Check if there is data for this even day
						if (d1[index] || d2[index]){
							return value;
						}
						return "";
					}
					return value; 
				},
			}

		},
		yaxis: {
			min: 0,
			max: undefined,
			labels: {
						formatter: function (value) {
								return size_converter(value, "GB"); 
						}
					}
		},
		stroke: {
			width: [2, 1], 
			curve: "smooth" 
		}, 
		legend: {
			horizontalAlign: "left",
			offsetX: 50,
		},
		tooltip: {
			shared: true,
			intersect: false,
			y: {
				formatter: function (y) {
					if (typeof y !== "undefined") {
						return y.toFixed(2) + " GB";
					}
					return y;
				}
			},
			x: {
				formatter: function (value) {
					var curr_month  = month["monthName"].substr(0,3);
					return value + "  " + curr_month;  
				}
			}

		},
		markers: {
			size: 3,
			strokeColors: "#fff",
			strokeWidth: 2,
			hover: {
				size: 8
			}
		},
		grid: {
			xaxis: {
				lines: {
					show: false // Show vertical lines
				}
			},
			yaxis: {
				lines: {
					show: true // Show horizontal lines
				}
			}
		},
	};

	let bw_graph_object = {};
	bw_graph_object = live_resource_graph2("", "bandwidth_graph", bw_options);

	function live_resources(){

		clearTimeout(timer_server_loads);

		$.getJSON("'.$globals['index'].'act=adminindex&serid="+serid+"&api=json", function(data) {
			$("#load_once_flag").val("1");
			$(".show-loading").hide();
			
			var ser_status = data["servers"][serid]["status"];
			
			if(empty(ser_status)){
				var server_name = $("#band_ser").find(":selected").text();
				show_toast("'.__J('Unable to fetch server statistics').'", "'.__J('Server :').' "+server_name+" '.__J('is Offline').'", 3);
				return;
			}

			d1 = [];
			total_bandwidth_in = 0;
			$.each(data["stats"]["bandwidth_in"],function(k,v){
				var b_in = (v / 1024).toFixed(2);
				d1.push(b_in);
				total_bandwidth_in += parseFloat(b_in);
			});

			d2 = [];
			total_bandwidth_out = 0;
			$.each(data["stats"]["bandwidth_out"],function(k,v){
				var bw_out = (v / 1024).toFixed(2);
				d2.push(bw_out);
				total_bandwidth_out += parseFloat(bw_out);
			});	
		
			//BandWidth
			bw_graph_data = [
				{data:d1},
				{data:d2}
			];

			const bandwidth_total = ["'.__J('Bandwidth IN'). ' : <b>"+total_bandwidth_in.toFixed(2)+" GB</b>" , "'.__J('Bandwidth OUT').' : <b>"+ total_bandwidth_out.toFixed(2)+" GB</b>"]; 

			var update_bw_option_and_data = {
				series: bw_graph_data,
				legend: {
					formatter: function(seriesName, opts) {
						return bandwidth_total[opts.seriesIndex];
					}
				}
			};
			bw_graph_object = live_resource_graph2(bw_graph_object, "", {}, {}, update_bw_option_and_data);

		if(!empty(data) && ("node_ram" in data["stats"])){

			show_tooltip();
			$("#virt_type").html(data["stats"]["virt"]);
		}
	});
	
	setTimeout(function(){
					live_resources();
				}, 5000);
	};
	
	live_resources();
	
};

var modal_html = "";

function get_server_details(serid , skip_html){

	if(skip_html){
		document.getElementById("resources_modal").innerHTML = "";

		//filling modal html
		modal_html = `<div class="modal fade" id="server_graph_modal_${serid}" data-backdrop="static" data-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">
						<div class="modal-dialog modal-lg">
							<div class="modal-content white_modal">
								<div class="modal-header">
									<h5 class="modal-title" id="staticBackdropLabel"></h5>
									<button type="button" class="close" data-dismiss="modal" onclick="clean_reource_chart();" aria-label="Close">
									<span aria-hidden="true">&times;</span>
									</button>
								</div>
								<div class="modal-body white_modal mx-2">
									<h5 class="card_title p-0 d-flex align-items-center justify-content-center">
										<div class="pt-2 mb-2 d-flex justify-content-center" id="image_cpu_${serid}"></div> 
										<span id="cpu_name_${serid}" class="ml-2"></span>
									</h5>
									<table class="table common-table">
										<tbody class="">
											<tr class="table_${serid}heading">
												<th class="admin_panel_table text-left">uptime</th>
												<th class="admin_panel_table min_width text-left">'.__J('OS :').'</th>
												<th class="admin_panel_table min_width text-left">'.__J('Kernel :').'</th>
											</tr>
											<tr class="">
												<td class="border-0 text-left"><span id="server_uptime_${serid}"></span></td>
												<td class="border-0 text-left"><span class="font-weight-light text-admin" id="osname_${serid}"></span></td>
												<td class="border-0 text-left"><span class="font-weight-light text-admin" id="kernelname_${serid}"></span></td>
											</tr>
										</tbody>
									</table>
									<div class="all_border">
										<div class="d-flex align-items-end">
											<div class="pulse-circle ml-auto"></div>
										</div>
										<div class="text-center mb-4">
											<div id="resource_chart_loader" class="big_loader mx-auto"></div>
										</div>
										<div class="d-flex align-items-center justify-content-between" id="chart_container" style="display:none;">
											<div class="text-center">
												<div class="" id="cpu_usage_${serid}"></div>
												<div class="subtitle" id="live_cpu_usage"></div>
											</div>
											<div class="text-center">
												<div class="" id="ram_usage_${serid}"></div>
												<div class="subtitle" id="live_ram_usage"></div>
											</div>
											<div class="text-center">
												<div class="" id="storage_usage_${serid}"></div>
												<div class="subtitle" id="live_storage_usage"></div>
											</div>
											<div class="text-center">
												<div class="" id="bandwidth_usage_${serid}"></div>
												<div class="subtitle" id="live_bandwidth_usage"></div>
											</div>
										</div>
									</div>
									<div id="free_used_chart_mark" class="d-flex align-items-center justify-content-end mr-2 mb-2">
										<span style="background-color: #3ECE74;"></span>'.__J('FREE').'
										<span style="background-color: #008FFB;"></span>'.__J('Used').'
									</div>
								</div>
								<div class="modal-footer white_modal">
									<button type="button" class="go_btn" data-dismiss="modal" onclick="clean_reource_chart();">'.__J('Close').'</button>
								</div>
							</div>
						</div>
					</div>`;
		
		
		
		document.getElementById("resources_modal").innerHTML = modal_html;
	}

	//makinbg ajax call for live data of server
	$.getJSON("'.$globals['index'].'act=adminindex&serid="+serid+"&api=json", function(data){
		
		if(!empty(data)){

			if(data["stats"]["band_per"] == 0){
				is_unlimited = true;
			}else{
				is_unlimited = false;
			}

			// declared one variable to inject true inside the array if promise received.
			let resource_chart_rendered  = {};

			// CPU promise
			let cpu_chart_rendered = resources_chart(data["stats"]["cpu_percent"], "#cpu_usage_"+serid, "'.__J('CPU').'", 150).then(() => {
				resource_chart_rendered["cpu"] = true;
				$("#live_cpu_usage").html(data["stats"]["cpu_percent"] +" / "+ "100 %");
			});

			// RAM promise
			let ram_chart_rendered = resources_chart(data["stats"]["node_ram"]["percent"], "#ram_usage_"+serid, "'.__J('RAM').'", 150).then(() => {
				resource_chart_rendered["ram"] = true;
				$("#live_ram_usage").html(size_converter(data["stats"]["node_ram"]["used"])+" / "+size_converter(data["stats"]["node_ram"]["limit"]));
				
			});

			// Storage promise
			let st_chart_rendered = resources_chart(parseFloat(data["stats"]["vps_per"].toFixed(2)), "#storage_usage_"+serid, "'.__J('STORAGE').'", 150).then(() => {
				resource_chart_rendered["storage"] = true;
				$("#live_storage_usage").html(data["stats"]["vps_bottom"]);
			});
			
			// bandwidth promise
			let bw_chart_rendered = resources_chart(is_unlimited ? 0 : data["stats"]["band_per"], "#bandwidth_usage_"+serid, "'.__J('BANDWIDTH').'", 150).then(() => {
				resource_chart_rendered["bandwidth"] = true;
				$("#live_bandwidth_usage").html(data["stats"]["band_bottom"]);
			});

			// Detecting all promise and check further
			Promise.all([cpu_chart_rendered, ram_chart_rendered, st_chart_rendered, bw_chart_rendered]).then(() => {
				
				// Check if any chart has been rendered if yes then we will hide that loader and show only graph
				if (Object.values(resource_chart_rendered).some(val => val === true)) {
					document.getElementById("resource_chart_loader").style.display = "none";    //hiding loader
					document.getElementById("chart_container").style.display = "block";     //showing only graph
				}
				
			});
			
			$("#cpu_name_"+serid).html("| "+data["stats"]["cpu_model"]);
			$("#cpu_name_"+serid).attr("tooltip",data["stats"]["cpu_model"]);
			$("#server_uptime_"+serid).html(data["stats"]["uptime"]);
			$("#kernelname_"+serid).html(data["stats"]["kernel_name"]);
			$("#virt_type_"+serid).html(data["stats"]["virt"]);
			$("#osname_"+serid).html(data["stats"]["osname"]);
			$("#image_cpu_"+serid).html(\'<img src="'.$theme['svg'].'\'+data["stats"]["cpu_manu"]+\'.svg" style="height:20px"/>\');

		}
	
	});

	//setting interval for current function for ajax call at every 5 seconds
	$("#server_graph_modal_"+serid).on("shown.bs.modal", function () {
		server_graph_interval_id = setInterval(function() {
			// Call your function here with parameters
			get_server_details(serid, "");
		}, 5000);
	});
};

function clean_reource_chart(){
	server_resource_chart = {};
	clearInterval(server_graph_interval_id);
};

var server_resource_chart = {};

function resources_chart(resource_data, resource_id, resource_label, chart_width){

	let free_space = (100 - resource_data);

	if (!server_resource_chart[resource_id]) {

		document.getElementById("resource_chart_loader").style.display = "block";
    	document.getElementById("chart_container").style.display = "none";

		var options = {

			series: [resource_data, free_space],
			
			chart: {
					type: "donut",
					width: chart_width,
					height: chart_width,
					events: {
					rendered: function() {
						
					}
				}
			},

			events: {
				rendered: function() {
					// Hide the loader and show the chart once rendering is done
					document.getElementById("big_loader").style.display = "none";
					document.getElementById("chart-container").style.display = "block";
				}
			},

			stroke: {
				show: true,
				width: 2,
				color: ["#000000"],
			},

			legend: {
				show: false,
				position: "right",
			},

			dataLabels: {
				enabled: false,
			},

			title: {
				text: resource_label,
				align: "center",
				margin: 0,
				offsetX: 0,
				offsetY: 0,
				floating: false,
				style: {
					fontSize:  "14px",
					fontWeight:  "semi-bold",
					fontFamily:  "Poppins",
					color:  "#012970"
				},
			},

			annotations: {
				yaxis: [
					{
					y: 50,
					borderColor: "#00E396",
					label: {
						borderColor: "#00E396",
						style: {
						color: "#fff",
						background: "#00E396"
						},
						text: "Y-axis annotation on 8800"
					}
					}
				]
			},

			labels: ["Used", "Free"],

			grid:{
				padding: {
					top: 0,
					right: 0,
					bottom: 0,
					left: 0
				},
			},
			
			tooltip: {
				enabled: true,
				y: {
					formatter: function(val) {
						return val.toFixed(2)+" %";
					}
				}
			}

		};

		server_resource_chart[resource_id] = new ApexCharts(document.querySelector(resource_id), options);
		
		// return data to detect the promise
		return server_resource_chart[resource_id].render()

	} else {

		// If the chart already exists, update the series with new data
		return server_resource_chart[resource_id].updateSeries([resource_data, free_space]);
	}

}

function dashboard_donut_chart(data, donut_chart_id){

	var options = {
			series: [data["data"][0], data["data"][1], data["data"][2]],
			chart: {
			type: "donut",
			width: 100,
			height: 100,
        },

		stroke: {
			show: true,
			width: 1,
  		},

		legend: {
			show: false,
			position: "right",
		},

		dataLabels: {
			enabled: false,
		},

		labels: [data["label"][0], data["label"][1], data["label"][2]],

		grid:{
			padding: {
				top: 0,
				right: 0,
				bottom: 0,
				left: 0
			},
		},

		colors: ["#6F58FF", "#F76775", "#46C9B8"],

		noData: {
			text: "ND",
			style: {
				color: "#000",
				fontSize: "6px",
				fontFamily: undefined
			}
		},

    };

	var chart = new ApexCharts(document.querySelector(donut_chart_id), options);
	chart.render();
}

// sso function
function sso(serid){
	$.ajax({
		type: "POST",
		url: "'.$globals['index'].'act=servers&sso="+serid+"&api=json",
		dataType : "json",
		success: function(data){
			if(empty(data["fatal_error_text"])){
				window.open("https://"+data["servers"][serid]["ip"]+":4085/"+data["sso_link"]["token_key"]+"/?as="+data["sso_link"]["sid"],"_blank");
			}else{
				showalert(data["fatal_error_text"], 1);
			}
		}
	});
}

var servers_chart = {};

function server_list_chart(ser_ls_used_space, ser_ls_free_space , ser_ls_id){

	var options = {
          series: [ser_ls_used_space, ser_ls_free_space],
          chart: {
				type: "pie",
				width: 35,
				height: 35,
        	},

		legend: {
			show: false,
			position: "right",
		},

		dataLabels: {
			enabled: false,
		},

		labels: ["'.__J('FREE').'", "'.__J('Used').'"],

		grid:{
			padding: {
				top: 0,
				right: 0,
				bottom: 0,
				left: 0
			},
		},

		tooltip: {
			enabled: true,
			y: {
				formatter: function(val) {
					return val.toFixed(2) + " %";
				}
			}
		},

		colors: ["#00E396", "#008FFB"],

		noData: {
			text: "ND",
			style: {
				color: "#000",
				fontSize: "6px",
				fontFamily: undefined
			}
		},
    };

	var servers_chart= new ApexCharts(document.querySelector(ser_ls_id), options);
	servers_chart.render();
}

</script>';

echo
'<div class="bg p-0">';

//ACL Validation
if(!$acl_cluster_statistics && !$acl_server_statistics){
	$error[] = __('You do not have enough access privileges for this page.');
	error_handle($error);
	softfooter();
	return false;
}

	// checkning online and offline server state
	$online_server = 0;
	$offline_server = 0;
	$expired_server = 0;

	foreach($servers as $s) {
		if($s['status'] == 0) {
			$offline_server++;
		} else if($s['status'] == 1) {
			$online_server++;
		} else {
			$expired_server++;
		}
	}

	echo '
	<!-- first row for whole cluster server data -->
	<div class="row dashboard_row mt-3 mx-auto w-100">
		<!-- card for hypervisor count -->
		<div class="col-lg-3 col-sm-6 col-md-6 mb-3 res_card h-50">
			<div class="card3 cluster-card1 res_card h-25">
				<div class="card_icon_title">
					<h5 class="text-nowrap m-0 d-flex flex-fill align-items-center justify-content-between mx-1">
						<div>
							<img  src="'.$theme['svg'].'server.svg" title="'.__('Hypervisor').'"/>
							<a href="'.$globals['ind'].'act=servers">
								'._strtoupper(__('Hypervisor')).' 
							</a>
						</div>
						<span>'.count($servers).'</span>
					</h5>
				</div>
				<div class="d-flex justify-content-center mt-1">
					<div id="server_chart" class="p-0"></div>
					<div class="w-100 my-auto ml-2">
						<div class="d-flex align-items-center justify-content-between card_content">
							<div class="">
							<span class="purple_dot"></span> 
							<label class="">'.__('Online').'</label>
							</div>
							<div class="">'.$online_server.'</div>
						</div>
						<div class="d-flex align-items-center justify-content-between card_content">
							<div class="">
							<span class="red_dot"></span>
							<label class="">'.__('Offline').'</label>
							</div>
							<div class="">'.$offline_server.'</div>
						</div>
						<div class="d-flex align-items-center justify-content-between card_content">
							<div class="">
								<span class="green_dot"></span>
								<label class="">'.__('License Expired').'</label>
							</div>
							<div class="">'.$expired_server.'</div>
						</div>
					</div>
				</div>
			</div>
		</div>
		<!-- card for VPS -->
		<div class="col-lg-3 col-sm-6 col-md-6 mb-3 res_card h-50">
			<div class="card3 cluster-card1 res_card h-25">
				<div class="card_icon_title">
					<h5 class="text-nowrap m-0 d-flex flex-fill align-items-center justify-content-between mx-1">
						<div>
							<img src="'.$theme['svg'].'vms.svg" title="'.__('RAM').'"/>
							<a href="'.$globals['ind'].'act=vs">
								'._strtoupper(__('VPS')).'
							</a>
						</div>
						<span>
							'.$stats['num_vps'].'
						</span>
					</h5>
				</div>
				<div class="d-flex justify-content-center mt-1">
					<div id="vps_chart" class="p-0"></div>
					<div class="w-100 my-auto ml-2">
						<div class="d-flex align-items-center justify-content-between card_content">
							<div class="">
							<span class="purple_dot"></span> 
							<label class="">'.__('VPS').'</label>
							</div>
							<div class="">'.$stats['num_vps'].'</div>
						</div>
						<div class="d-flex align-items-center justify-content-between card_content">
							<div class="">
							<span class="red_dot"></span>
							<label class="">'.__('Suspended').'</label>
							</div>
							<div class="">'.$stats['num_vps_suspended'].'</div>
						</div>
						<div class="d-flex align-items-center justify-content-between card_content">
							<div class="">
								<span class="green_dot"></span>
								<label class="">'.__('Awaiting Setup').'</label>
							</div>
							<div class="">'.$stats['num_setup_pending'].'</div>
						</div>
					</div>
				</div>
			</div>
		</div>
		<!-- card for users -->
		<div class="col-lg-3 col-sm-6 col-md-6 mb-3 res_card h-50">
			<div class="card3 cluster-card1 res_card h-25">
				<div class="card_icon_title">
					<h5 class="text-nowrap m-0 d-flex flex-fill align-items-center justify-content-between mx-1">
						<div>
							<i class="fas fa-md fa-users"></i>
							<a href="'.$globals['ind'].'act=users">
								'._strtoupper(__('Users')).'
							</a>
						</div>
						<span>
							'.$stats['num_total_users'].'
						</span>
					</h5>
				</div>
				<div class="d-flex justify-content-center mt-1">
					<div id="usr_chart" class="p-0"></div>
					<div class="w-100 my-auto ml-2">
						<div>
							<div class="d-flex align-items-center justify-content-between card_content">
								<div class="">
									<span class="purple_dot"></span>
									<label class="greay_label">'.__('Admin').'</label> : 
								</div>
								<div class="">'.$stats['num_admins'].'</div>
							</div>
							<div class="d-flex align-items-center justify-content-between card_content">
								<div class="">
									<span class="red_dot"></span>
									<label class="greay_label">'.__('Cloud').'</label> : 
								</div>
								<div class="">'.$stats['num_clouds'].'</div>
							</div>
							<div class="d-flex align-items-center justify-content-between card_content">
								<div class="">
									<span class="green_dot"></span>
									<label class="greay_label">'.__('End Users').'</label> : 
								</div>
								<div class="">'.$stats['num_users'].'</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
		<!-- card for ipv4/ipv6 -->
		<div class="col-lg-3 col-sm-6 col-md-6 mb-3 res_card h-50">
			<div class="card3 cluster-card1 res_card h-25">
				<div class="card_icon_title">
					<h5 class="text-nowrap m-0 d-flex flex-fill align-items-center justify-content-between mx-1">
						<div>
							<i class="icon icon-ippool"></i>
							<a href="'.$globals['ind'].'act=ippool">
								'._strtoupper(__('IPv4')).' / '._strtoupper(__('IPv6')).'
							</a>
						</div>
						<span>
							'.((int)$stats['total_ipv4'] + (int)$stats['total_ipv6']).'
						</span>
					</h5>
				</div>
				<div class="d-flex justify-content-between mt-2">
					<div class="w-50 mr-3">
						<div class="d-flex align-items-center justify-content-between card_content">
							<div class="">
								<label class="">'.__('IPV4').'</label>
							</div>
							<div class="">'.$stats['total_ipv4'].'</div>
						</div>
						<div class="d-flex align-items-center justify-content-between card_content">
							<div class="">
							<label class="">'.__('FREE').'</label> : 
							</div>
							<div class="">'.$stats['free_ipv4'].'</div>
						</div>
						<div class="d-flex align-items-center justify-content-between card_content">
							<div class="">
							<label class="">'.__('Used').'</label> : 
							</div>
							<div class="">'.$stats['ipv4'].'</div>
						</div>
						<div class="d-flex align-items-center justify-content-between card_content">
							<div class="">
							<label class="">'.__('End Users').'</label> : 
							</div>
							<div class="">'.$stats['ipv4'].'</div>
						</div>
					</div>
					<div class="divider"></div>
					<div class="w-50 ml-3">
						<div class="d-flex align-items-center justify-content-between card_content">
							<div class="">
								<label class="">'.__('IPV6').'</label>
							</div>
							<div class="">'.$stats['total_ipv6'].'</div>
						</div>
						<div class="d-flex align-items-center justify-content-between card_content">
							<div class="">
							<label class="">'.__('FREE').'</label> : 
							</div>
							<div class="">'.$stats['free_ipv6'].'</div>
						</div>
						<div class="d-flex align-items-center justify-content-between card_content">
							<div class="">
							<label class="">'.__('Used').'</label> : 
							</div>
							<div class="">'.$stats['ipv6'].'</div>
						</div>
						<div class="d-flex align-items-center justify-content-between card_content">
							<div class="">
							<label class="">'.__('End Users').'</label> : 
							</div>
							<div class="">'.$stats['ipv6'].'</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
	<!-- second row-->
	<div class="row mx-auto w-100 mb-3">
		<!-- row for hypervisor list and bandwidth card -->
		<div class="col-lg-7 col-sm-12 col-md-12 mb-0 text-center">
			<div class="col-lg-12 col-sm-12 col-md-12 px-0 mb-3" id ="dashboard_server_card">
				<div class="card fixed_card_height">
					<h5 class="card_title">
						'.__('Hypervisor').' <span>| '.__('Overview of Connected Hypervisor').' </span>
					</h5>
					<div class="d-flex justify-content-between align-items-center">
						<div class="of_status">
							<a id="success_search" class="success"><img  src="'.$theme['svg'].'online.svg" title="'.__('online').'"/></a> : '.$online_server.'
							<a id="failure_search" class="failure"><img  src="'.$theme['svg'].'offline.svg" title="'.__('offline').'"/></a> : '.$offline_server.'
						</div>
						<div class="search-bar">
							<form class="search-form d-flex align-items-center" method="POST" action="#">
								<input type="text" name="query" placeholder="Search" id="server_table_search" title="Enter search keyword" >
								<button type="submit" title="Search"><i class="fas fa-search"></i></button>
							</form>
						</div>
					</div>
					<div class="mx-2 mt-2 overflow_y hypervisor_card">
						<table class="table table-hover tablesorter common-table">
							<thead>
								<tr class="table_heading">
									<th align="center" class="admin_panel_table width-10">#</th>
									<th class="admin_panel_table width-35">'.__('Server').'</th>
									<th class="admin_panel_table width-5">'.__('VPS').'</th>
									<th class="admin_panel_table width-5">'.__('CPU').'</th>
									<th class="admin_panel_table width-25 text-center">'.__('RAM').'</th>
									<th class="admin_panel_table width-25 text-center">'.__('STORAGE').'</th>
									<th class="admin_panel_table width-5">'.__('Status').'</th>
									<th class="admin_panel_table width-5">'.__('Live').'</th>
								</tr>
							</thead>
							<tbody id="server_table">';

							foreach($servers as $s ) {

								if($s['status'] == 0) {
									$status_txt = __('Offline'); 
								} else if($s['status'] == 1) {
									$status_txt = __('Online'); 
								}

								if(($s['serid'] == 0) && !empty($globals['is_master_only'])){
									$s['virt'] = 'msonly';
								}

								if($s['lic_expires']){
									$lic_expired = true;
								}

								$server_vps_href = "act=vs&vpsid=&vpsname=&vpsip=&vpshostname=&vsstatus=0&vstype=0&speedcap=0&user=&vsgid=-1&vserid=".$s['serid']."&plid=-1&bpid=-1&search=Search";
								
								echo 
								'<tr>
									<td class="border-0 text-left">'.show_virt_type($s['virt']).'</td>
									<td class="border-0 text-left">
										'.(empty($s['serid']) ? ''.$s['server_name'].'' : '<a href="javascript:void(0)" onclick="sso(\''.$s['serid'].'\');">'.$s['server_name'].'</a>').' </br>('.$s['ip'].')
									</td>
									<td class="border-0 text-left "><a href="'.$globals['ind'].$server_vps_href.'">'.(empty($s['numvps']) ? '0' : $s['numvps']).'</a></td>
									<td class="border-0 text-left">'.$s['vcores'].'</td>
									<td class="border-0 text-center">
										<div class="d-flex justify-content-center"
											<div id="server_ram_'.$s['serid'].'" class="mx-auto"></div>
										<div>
										<div class="font-10">'.size_converter($s['ram'], "MB").'/'.size_converter($s['total_ram'], "MB").'</div>
									</td>
									<td class="border-0 text-center">
										<div class="d-flex justify-content-center"
											<div id="server_storage_'.$s['serid'].'"></div>
										</div>
										<div class="font-10">'.size_converter($s['space'], "GB").'/'.size_converter($s['total_space'], "GB").'</div>
									</td>
									<td class="border-0 text-left" align="center">
										<h5 class="p-0 m-0"><a class="badge server-status '.(empty($s['lic_expires']) ? "badge-warning" : ($s['status'] == 1 ? 'badge-success' : 'badge-danger')).'" '.(empty($s['lic_expires']) ? 'href="https://www.softaculous.com/clients?ca=virtbuy" target="_blank"' : "").'>'.(empty($s['lic_expires']) ? '<i class="fas fa-exclamation-triangle mr-1"></i> '.__('License Expired') : $status_txt).'</a></h5>
									</td>
									<td class="border-0 text-left">
										<button type="button" class="" data-toggle="modal" data-target="#server_graph_modal_'.$s['serid'].'" onclick="get_server_details('.$s['serid'].', 1);">
											<i class="fas fa-2x fa-chart-bar text-primary"></i>
										</button>
										<div id="resources_modal"></div>
									</td>
								</tr>';
							}
							
							echo '</tbody>
						</table>
					</div>
				</div>
			</div>
			<div class="col-lg-12 col-sm-12 col-md-12 text-center px-0 mb-3" id="dashboard_bandwidth_card">
				<div class="card cluster-card1 pt-0">
					<div class="d-flex justify-content-center mt-3">
						<div class="border rounded-lg w-50">
							<select class="<select class="custom-select virt-select"" id="band_ser" onchange="$(\'#load_once_flag\').val(\'0\');get_live_resource(this.value);">';		
									foreach($servers as $k => $v){

										if(($v['serid'] == 0) && !empty($globals['is_master_only'])){
											$v['virt'] = 'msonly';
										}

										echo '<option value="'.$k.'" '.($globals['server'] == $k ? 'selected="selected"' : '').' data-virt="'.$v['virt'].'">'.$v['server_name'].'</option>';
									}
									echo 
							'</select>
							';
							echo'
						</div>
					</div>
					<input type="hidden" id="load_once_flag" value="0">
					<div style="display:none;" class="loader band-loading position-absolute show-loading"></div>
					<h5 class="card_title">'.__('BANDWIDTH').'<span> | '.__('Monthly Inbound and Outbound Overview').'</h5>
					<div class="overflow-hidden p-0 position-relative mt-2" id="bandwidth_graph1">
						<div id="bandwidth_graph"></div>
					</div>
				</div>
			</div>
		</div>
		<!-- row for recent task and login list -->
		<div class="col-lg-5 col-sm-12 col-md-12 text-center">
			<!-- card for recent task list -->
			<div id="dashboard_task_card" class="card col-lg-12 col-sm-12 col-md-12 px-0 mb-3 task_table">
				<h5 class="card_title">
					'.__('RECENT TASKS').' <span>| '.__('Last 10 Tasks').'</span>
				</h5>
				<div>
					<ul class="nav nav-tabs d-flex" id="task_table_card" role="tablist">
						<li class="nav-item flex-fill" role="presentation">
							<a class="nav-link w-100 active" id="home-tab" data-toggle="tab" href="#home-justified" role="tab" aria-controls="home" aria-selected="true">
							'.__('COMPLETED').'</a>
						</li>
						<li class="nav-item flex-fill" role="presentation">
							<a class="nav-link w-100" id="profile-tab" data-toggle="tab" href="#profile-justified" role="tab" aria-controls="profile" aria-selected="false">
							'.__('FAILED').'</a>
						</li>
						<li class="nav-item flex-fill" role="presentation">
							<a class="nav-link w-100" id="contact-tab" data-toggle="tab" href="#contact-justified" role="tab" aria-controls="contact" aria-selected="false">
							'.__('RUNNING').'</a>
						</li>
					</ul>
					<div class="tab-content pt-2" id="task_table_cardContent">
						<div class="tab-pane fade show active" id="home-justified" role="tabpanel" aria-labelledby="home-tab">
							<div class="mx-2 mt-2 tasks activity">';
								if(empty($stats['completed_tasks'])){
									echo'<div class="notice mx-3 mb-3">'.__('There is no task to display').'</div>';
								}else{
							
									echo'<table class="table table-hover tablesorter common-table">
										<thead>
											<tr class="table_heading">
												<th class="admin_panel_table text-left width-10">'.__('Status').'</th>
												<th class="admin_panel_table text-left width-30">'.__('Action').'</th>
												<th class="admin_panel_table text-left width-50">'.__('USER').'</th>
												<th class="admin_panel_table min_width text-left width-10">'.__('Logs').'</th>
											</tr>
										</thead>
										<tbody class="my-3">';

										foreach($stats['completed_tasks'] as $task) {
											echo
											'<tr class="activity-item">
												<td class="activite-label">
													<div class="divider"></div>
													<img class="activity-badge" src="'.$theme['svg'].(($task['status'] == "1" && $task['progress'] == "100" ) ? 'check_circle.svg' : ($task['status'] == "-1" ? 'cross_circle.svg' : 'running_circle.svg')).'" alt="badge">
												</td>
												<td class="border-0 text-left">'.$task_action[$task['action']].'</td>
												<td class="border-0 text-left">'.(empty($task['uid']) ? 'root' : $task['email']).'</td>
												<td class="border-0 text-left"><button class="go_btn btn-logs" onclick="loadlogs('.$task['actid'].');">'.__('Show').'</button></td>
											</tr>';
										}
										
										echo '</tbody>
									</table>';
								}
						echo '</div>
						</div>
						<div class="tab-pane fade" id="profile-justified" role="tabpanel" aria-labelledby="profile-tab">
							<div class="mx-2 mt-2 tasks activity">';
								if(empty($stats['failed_tasks'])){
									echo'<div class="notice mx-3 mb-3">'.__('There is no task to display').'</div>';
								}else{
							
								echo '<table class="table table-hover tablesorter tasks common-table">
										<thead>
											<tr>
												<th class="admin_panel_table text-left width-10">'.__('Status').'</th>
												<th class="admin_panel_table text-left width-30">'.__('Action').'</th>
												<th class="admin_panel_table text-left width-50">'.__('USER').'</th>
												<th class="admin_panel_table min_width text-left width-10">'.__('Logs').'</th>
											</tr>
										</thead>
										<tbody class="my-3">';

										foreach($stats['failed_tasks'] as $task) {
											echo
											'<tr class="activity-item">
												<td class="activite-label">
													<div class="divider"></div>
													<img class="activity-badge" src="'.$theme['svg'].(($task['status'] == "1" && $task['progress'] == "100" ) ? 'check_circle.svg' : ($task['status'] == "-1" ? 'cross_circle.svg' : 'running_circle.svg')).'" alt="badge">
												</td>
												<td class="border-0 text-left">'.$task_action[$task['action']].'</td>
												<td class="border-0 text-left">'.(empty($task['uid']) ? 'root' : $task['email']).'</td>
												<td class="border-0 text-left"><button class="go_btn btn-logs" onclick="loadlogs('.$task['actid'].');">'.__('Show').'</button></td>
											</tr>';
										}
										
										echo '</tbody>
									</table>';
								}
								echo'
							</div>
						</div>
						<div class="tab-pane fade" id="contact-justified" role="tabpanel" aria-labelledby="contact-tab">
							<div class="mx-2 mt-2 tasks activity">';
								if(empty($stats['running_tasks'])){
										echo'<div class="notice mx-3 mb-3">'.__('There is no task to display').'</div>';
									}else{
								
									echo '<table class="table table-hover tablesorter tasks common-table">
										<thead>
											<tr>
												<th class="admin_panel_table text-left width-10">'.__('Status').'</th>
												<th class="admin_panel_table text-left width-30">'.__('Action').'</th>
												<th class="admin_panel_table text-left width-50">'.__('USER').'</th>
												<th class="admin_panel_table min_width text-left width-10">'.__('Logs').'</th>
											</tr>
										</thead>
										<tbody class="my-3">';
											foreach($stats['running_tasks'] as $task) {
												echo
												'<tr class="activity-item">
													<td class="activite-label">
														<div class="divider"></div>
														<img class="activity-badge" src="'.$theme['svg'].(($task['status'] == "1" && $task['progress'] == "100" ) ? 'check_circle.svg' : ($task['status'] == "-1" ? 'cross_circle.svg' : 'running_circle.svg')).'" alt="badge">
													</td>
													<td class="border-0 text-left">'.$task_action[$task['action']].'</td>
													<td class="border-0 text-left">'.(empty($task['uid']) ? 'root' : $task['email']).'</td>
													<td class="border-0 text-left"><button class="go_btn btn-logs" onclick="loadlogs('.$task['actid'].');">'.__('Show').'</button></td>
												</tr>';
											}
										
										
										echo '</tbody>
									</table>';
								}
								echo'
							</div>
						</div>
					</div>
				</div>
			</div>
			<!-- card for recent login list -->
			<div id="dashboard_login_card" class="col-lg-12 col-sm-12 col-md-12 px-0 col-md-12 mb-0 text-center">
				<div id="panel-logins" class="card recent">
					<h5 class="card_title">'.__('Recent Logins').'<span> | '.__('Last 10 Login Details').'</span></h5>
					<div class="mx-2 mt-2 overflow_y">
						<table class="table table-hover tablesorter common-table">
							<thead>
								<tr class="table_heading">
									<th class="text-left admin_panel_table width-40">'.__('USER').'</th>
									<th class="text-left admin_panel_table width-50">'.__('DETAILS').'</th>
									<th class="text-left admin_panel_table width-50">'.__('From IP').'</th>
								</tr>
							</thead>
							<tbody>';
							
							foreach($stats['logins'] as $login) {
								// If it's not today's date then include date in string
								$time_text = datify($login['time'], 1, 1);
								
								echo '<tr>
									<td class="text-left border-0">
										'.(empty($login['name']) ? '' : '<div>'.$login['name'].'</div>').'
										<div>'.(empty($login['name']) ? $login['username'] : '<span style="color: rgba(0,0,0,0.54)">'.$login['username'].'</span>').'</div>
									</td>
									<td class="text-left border-0" align="right">'.$time_text.'</td>
									<td class="text-left border-0" align="right">'.$login['ip'].'</td>
								</tr>';
							}
							echo '</tbody>
						</table>
					</div>
				</div>
			</div>
		</div>
		<!-- card for recent task -->
	</div>
	';

echo '
<script language="javascript" type="text/javascript" src="https://a.softaculous.com/virtualizor/latestinfo.php"></script>
<script type="text/javascript">

	var servers = new Array('.implode(', ', array_keys($servers)).');	
	function callserverstats(serid){
		if(serid < 0){
			if(empty(servers)){
				getserverstats(0);
			}else{
				$("#cserver").prop("disabled", true);
				servers.sort(function(a, b){return b-a});
				for(x in servers){	
					//alert(servers[x]);
					getserverstats(servers[x]);				
				}
			}
		}else{
			$("#cserver").prop("disabled", true);
			getserverstats(serid);			
		}
		
	}
	
	function hideserverstats(){
		if(!empty(servers) && $("#cserver").find("option:selected").val() >= 0){
			for(x in servers){
				$("#row_server_graphs"+servers[x]).hide();
				$("#row_server_table"+servers[x]).hide();
				$("#server_error"+servers[x]).hide();
			}
		}
	}
	
	function getserverstats(serid){
		//$_("refresh_status").src = "'.$theme['images'].'admin/vpsloading.gif";
		
		serid = serid || 0;		
		
		$("#server_error").hide();
		$("#row_server_loading"+serid).show();
		hideserverstats();
		
		// This function is local function for getserverstats. As its defined only for server stats radial charts on dashboard
		function chart(used, id){

			var options = {
				chart: {
					height: 180,
					width: "125%",
					type: "radialBar",
					offsetX: -12,
					offsetY: 0	
				},
				series: [used],
				colors: ["#20E647"],
				plotOptions: {
					radialBar: {
						hollow: {
							margin: 0,
							size: "70%",
							background: "#293450"
						},
						track: {
							strokeWidth: "150%",
							dropShadow: {
								enabled: true,
								top: 2,
								left: 0,
								blur: 4,
								opacity: 0.15
							}
						},
						dataLabels: {
							name: {
								offsetY: -10,
								color: "#fff",
								fontSize: "13px",
								offsetY: -10
							},
							value: {
								color: "#fff",
								fontSize: "15px",
								show: true,
								offsetY: -1
							}
						}
					}
				},
				fill: {
					type: "gradient",
					gradient: {
						shade: "dark",
						type: "vertical",
						gradientToColors: ["#87D4F9"],
						stops: [0, 100]
					}
				},
				stroke: {
					lineCap: "round"
				},
				labels: ["Used"]
			};
		
			var chart = new ApexCharts(document.querySelector(id), options);
			chart.render();
		};
		
		$.getJSON("'.$globals['index'].'act=manageserver&changeserid="+serid+"&api=json", function(data) {
			
			$("#cserver").prop("disabled", false);
			$("#row_server_loading"+serid).hide();
			
			// Is it offline ?
			if(data["offline"]){
				//showalert(data["offline"] ,"1");
				$("#server_error"+serid).html("<b>'.__J('Note').' : </b> &nbsp;" + data["offline"]);
				$("#server_error"+serid).show();
				return false;
			}
			
			$("#row_server_graphs"+serid).show();
			$("#row_server_table"+serid).show();
			
			if((data["info"]["check_kernel"]).length > 10){
				//showalert(data["info"]["check_kernel"] ,"1");
				$_("server_error"+serid).innerHTML = \'<b>NOTE : </b>&nbsp; \'+data["info"]["check_kernel"];
				$("#server_error"+serid).show();
			}else{
				$("#server_error"+serid).hide();
			}
		});
	}
';

if($acl_server_statistics){
	echo '
	$(document).ready(function(){
		getserverstats('.$globals['server'].');
	});';
}

echo '

$(document).ready(function(){

	var server_graph_interval_id;

	$_("softnews").style.width = $_("softnewsholder").offsetWidth;
	//The news
	if(typeof(soft_news) == "undefined"){
		$_("softnews").innerHTML = "'.__J('Unable to connect to Virtualizor.').'";
	}else{
		var newsstr = "";
		for(x in soft_news){
			newsstr = newsstr+\'<div class="news_div mb-3"><div class="softnewshead">\'+soft_news[x][0]+\'</div>\'+\'<div class="softnewsblock">\'+soft_news[x][1]+\'</div></div>\';
		}
		$_("softnews").innerHTML = newsstr;
	}

	var user_chart_data = {
							data : ['.$stats['num_admins'].', '.$stats['num_clouds'].', '.$stats['num_users'].'],
						  	label : ["'.__J('Admin').'", "'.__J('Cloud').'", "'.__J('End Users').'"]
						};
	
	var vps_chart_data = {
							data : ['.$stats['num_vps'].', '.$stats['num_vps_suspended'].', '.$stats['num_setup_pending'].'],
						  	label : ["'.__J('VPS').'", "'.__J('Suspended').'", "'.__J('Awaiting Setup').'"]
						};

	var server_chart_data = {
							data : ['.$online_server.', '.$offline_server.', '.$expired_server.'],
						  	label : ["'.__J('Online').'", "'.__J('Offline').'", "'.__J('License Expired').'"]
						};
	
	// calling each card chart
	dashboard_donut_chart(vps_chart_data, "#vps_chart");
	dashboard_donut_chart(server_chart_data, "#server_chart");
	dashboard_donut_chart(user_chart_data, "#usr_chart");



	$("#server_table_search").on("keyup", function() {
		
		var value = $(this).val().toLowerCase();

		$("#server_table tr").filter(function() {
			$(this).toggle($(this).text().toLowerCase().indexOf(value) > -1)
		});
	});

	let is_success_filltered = false;

	$("#success_search").on("click", function(){
		
		if(!is_success_filltered){
			
			let online ="'.__J('online').'";
			
			$("#server_table tr").filter(function() {
				$(this).toggle($(this).text().toLowerCase().indexOf(online) > -1)
			});

			is_success_filltered = true;

		}else{
			
			// if someone again click on link then it will reset
			$("#server_table tr").show();
			is_success_filltered = false;
		}
		
	});

	let is_failure_filltered = false;

	$("#failure_search").on("click", function(){

		if(!is_failure_filltered){
			let offline ="'.__J('offline').'";
			$("#server_table tr").filter(function() {
				$(this).toggle($(this).text().toLowerCase().indexOf(offline) > -1)
			});		
			is_failure_filltered = true;
		} else {
			
			// if someone again click on link then it will reset
			$("#server_table tr").show();
			is_failure_filltered = false;
		}

	});

	';

	foreach($servers as $k => $v){
		
		// calculation for ram and storage for apex chart
		if ($v['total_ram'] != 0 ) {
			$pec_used_ram = round((($v['ram'] / $v['total_ram']) * 100 ), 2);
			$pec_free_ram = 100 - $pec_used_ram;
			echo'server_list_chart('.$pec_used_ram.', '.$pec_free_ram.', "#server_ram_'.$v['serid'].'");';
		}else{
			echo'$("#server_ram_'.$v['serid'].'").html("<div class=\'dp_no_chart\' tooltip=\''.__J('No data Available').'\'>NA</div>");';
		}

		if ($v['total_space'] != 0 ){
			$pec_used_storage = round((($v['space'] / $v['total_space']) * 100 ), 2);
			$pec_free_storage = 100 - $pec_used_storage;
			echo'server_list_chart('.$pec_used_storage.', '.$pec_free_storage.', "#server_storage_'.$v['serid'].'");';
		}else{
			echo'$("#server_storage_'.$v['serid'].'").html("<div class=\'dp_no_chart\' tooltip=\''.__J('No data Available').'\'>NA</div>");';
		}
	}

	echo'

	$(".softnewsblock").each(function() {
        $(this).find("br").first().remove();
    });

});

</script>
	<div class="row mx-3">
		<div class="col-sm-12 card cluster-card1 pt-0">
			<div class="text-center m-0 p-0">
				<h5 class="card_title">'.__('Virtualizor News').' <span>| '.__('Latest Updates').' </span></h5>
			</div>
			<div class="">		
				<div id="softnewsholder">
					<div class="softnews scrollbar-virt" id="softnews"></div>
				</div>
			</div>
		</div>
	</div>
</div>
';

//footer start
echo softfooter();
//footer end


echo '
<script type="text/javascript">

	function bar_color(v) {
		if(v <= 50) {
			return "#6BCB77";
		} else if(v <= 80) {
			return "#ffd600";
		} else {
			return "#FF6B6B";
		}
	}	
</script>';

}

