/*
	Javascript for razorpay payment gateway
*/

function razorpay_requirement(){
	
	var html = '';
	
	html += '<script src="https://checkout.razorpay.com/v1/checkout.js"></script>';
	
	$('.payment_gateway_fields').html(html);
};

function razorpay_process(){

	var data = $('#make_payment_form').serializeArray();
	var uri = $('#make_payment_form').attr('action') + '&api=json';
	$("#payment-error").html(" ");
	$.ajax({
		url: uri,
		data: data,
		method: 'POST',
		success: function(res){
			var finalData = JSON.parse(res);

			if(empty(finalData["error"])){
				var options = {
					"key": finalData["key"], // Enter the Key ID generated from the Dashboard
					"amount": finalData["result"]["amount"] * 100, // Amount is in currency subunits. Default currency is INR. Hence, 50000 refers to 50000 paise
					"currency": finalData["result"]["currency"],
					"name": finalData["sn"],
					"order_id": finalData["result"]["id"], //This is a sample Order ID. Pass the `id` obtained in the response of Step 1
					"callback_url":finalData["callback_url"],
				};
				var r = new Razorpay(options);
				r.open();
				return false;
			}else{

				error = '<div id="payment-error-div" class="row p-2 bg-danger rounded"><script>function closeerror(){$("#payment-error").html(" ");}</script><div class="col-md-11 p-0"><div class="d-flex align-items-center justify-content-center flex text-center justify-center"><p class="text-white m-0">';
				Object.keys(finalData["error"]).forEach(element => {
					error += finalData["error"][element]+"<br>";
				});
				errorScript = '</p></div></div><div class="col-md-1 p-0"><button type="button" onclick="closeerror();" class="close"><span aria-hidden="true">×</span></button></div></div>';
				$('#payment-error').html(error+errorScript);
			}

			
		}
	});
	
};