/*
 * Decompiled with CFR 0.152.
 */
package com.tightvnc.rfbplayer;

import com.tightvnc.rfbplayer.RfbPlayer;
import com.tightvnc.rfbplayer.RfbProto;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.MemoryImageSource;
import java.io.IOException;
import java.util.Observable;
import java.util.Observer;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;

class VncCanvas
extends Component
implements Observer {
    RfbPlayer appClass;
    RfbProto rfb;
    ColorModel cm8;
    ColorModel cm24;
    int bytesPixel;
    Image memImage;
    Graphics memGraphics;
    Image offImage;
    Graphics offGraphics;
    Image rawPixelsImage;
    MemoryImageSource pixelsSource;
    byte[] pixels8;
    int[] pixels24;
    byte[] zlibBuf;
    int zlibBufLen = 0;
    Inflater zlibInflater;
    static final int tightZlibBufferSize = 512;
    Inflater[] tightInflaters;
    Rectangle jpegRect;
    boolean seekMode;
    static final int SCROLL_MARGIN = 50;
    static final Color DARK_GRAY = new Color(132, 138, 156);
    private Color hextile_bg;
    private Color hextile_fg;
    boolean showSoftCursor = false;
    MemoryImageSource softCursorSource;
    Image softCursor;
    int cursorX = 0;
    int cursorY = 0;
    int cursorWidth;
    int cursorHeight;
    int origCursorWidth;
    int origCursorHeight;
    int hotX;
    int hotY;
    int origHotX;
    int origHotY;

    VncCanvas(RfbPlayer rfbPlayer) throws IOException {
        this.appClass = rfbPlayer;
        this.rfb = this.appClass.rfb;
        this.seekMode = false;
        this.cm24 = new DirectColorModel(24, 0xFF0000, 65280, 255);
        this.setPixelFormat();
        this.setBackground(Color.white);
    }

    public boolean getFocusTraversalKeysEnabled() {
        return false;
    }

    public Dimension getPreferredSize() {
        Dimension dimension = this.appClass.desktopScrollPane.getViewportSize();
        Dimension dimension2 = new Dimension(this.rfb.framebufferWidth, this.rfb.framebufferHeight);
        if (dimension.width > dimension2.width) {
            dimension2.width = dimension.width;
        }
        if (dimension.height > dimension2.height) {
            dimension2.height = dimension.height;
        }
        return dimension2;
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    Point getImageOrigin() {
        int n = 0;
        int n2 = 0;
        Dimension dimension = this.appClass.desktopScrollPane.getViewportSize();
        if (this.rfb.framebufferWidth < dimension.width) {
            n = dimension.width / 2 - this.rfb.framebufferWidth / 2;
        }
        if (this.rfb.framebufferHeight < dimension.height) {
            n2 = dimension.height / 2 - this.rfb.framebufferHeight / 2;
        }
        return new Point(n, n2);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics graphics) {
        Point point = this.getImageOrigin();
        Dimension dimension = this.getPreferredSize();
        if (this.offImage == null) {
            this.offImage = this.createImage(dimension.width, dimension.height);
            this.offGraphics = this.offImage.getGraphics();
        } else if (this.offImage.getWidth(null) != dimension.width || this.offImage.getHeight(null) != dimension.height) {
            this.offGraphics.dispose();
            this.offGraphics = null;
            this.offImage.flush();
            this.offImage = null;
            this.offImage = this.createImage(dimension.width, dimension.height);
            this.offGraphics = this.offImage.getGraphics();
        }
        Object object = this.memImage;
        synchronized (object) {
            this.offGraphics.drawImage(this.memImage, point.x, point.y, null);
        }
        if (point.x > 0 || point.y > 0) {
            object = graphics.getColor();
            this.offGraphics.setColor(Color.white);
            this.offGraphics.fillRect(0, 0, point.x, dimension.height);
            this.offGraphics.fillRect(point.x + this.rfb.framebufferWidth, 0, dimension.width - (point.x + this.rfb.framebufferWidth), dimension.height);
            this.offGraphics.fillRect(point.x, 0, this.rfb.framebufferWidth, point.y);
            this.offGraphics.fillRect(point.x, point.y + this.rfb.framebufferHeight, this.rfb.framebufferWidth, dimension.height - (point.y + this.rfb.framebufferHeight));
            this.offGraphics.setColor((Color)object);
        }
        object = graphics.getColor();
        this.offGraphics.setColor(DARK_GRAY);
        this.offGraphics.drawRect(point.x - 1, point.y - 1, this.rfb.framebufferWidth + 1, this.rfb.framebufferHeight + 1);
        this.offGraphics.setColor((Color)object);
        if (this.showSoftCursor) {
            int n = this.cursorX - this.hotX;
            int n2 = this.cursorY - this.hotY;
            Rectangle rectangle = new Rectangle(n += point.x, n2 += point.y, this.cursorWidth, this.cursorHeight);
            if (rectangle.intersects(graphics.getClipBounds())) {
                this.offGraphics.setClip(point.x, point.y, this.rfb.framebufferWidth, this.rfb.framebufferHeight);
                this.offGraphics.drawImage(this.softCursor, n, n2, null);
                this.offGraphics.setClip(null);
            }
        }
        graphics.drawImage(this.offImage, 0, 0, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        if ((n & 0xA0) == 0) {
            return true;
        }
        if ((n & 0x20) != 0 && this.jpegRect != null) {
            Rectangle rectangle = this.jpegRect;
            synchronized (rectangle) {
                this.memGraphics.drawImage(image, this.jpegRect.x, this.jpegRect.y, null);
                this.scheduleRepaint(this.jpegRect.x, this.jpegRect.y, this.jpegRect.width, this.jpegRect.height);
                this.jpegRect.notify();
            }
        }
        return false;
    }

    private void setPixelFormat() throws IOException {
        this.bytesPixel = 4;
        this.updateFramebufferSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateFramebufferSize() {
        int n = this.rfb.framebufferWidth;
        int n2 = this.rfb.framebufferHeight;
        if (this.memImage == null) {
            this.memImage = this.appClass.createImage(n, n2);
            this.memGraphics = this.memImage.getGraphics();
        } else if (this.memImage.getWidth(null) != n || this.memImage.getHeight(null) != n2) {
            Image image = this.memImage;
            synchronized (image) {
                this.memImage = this.appClass.createImage(n, n2);
                this.memGraphics = this.memImage.getGraphics();
            }
        }
        if (this.bytesPixel == 1) {
            this.pixels24 = null;
            this.pixels8 = new byte[n * n2];
            this.pixelsSource = new MemoryImageSource(n, n2, this.cm8, this.pixels8, 0, n);
        } else {
            this.pixels8 = null;
            this.pixels24 = new int[n * n2];
            this.pixelsSource = new MemoryImageSource(n, n2, this.cm24, this.pixels24, 0, n);
        }
        this.pixelsSource.setAnimated(true);
        this.rawPixelsImage = this.createImage(this.pixelsSource);
        if (!this.seekMode && this.appClass.desktopScrollPane != null) {
            if (this.appClass.inSeparateFrame) {
                this.resizeDesktopFrame();
            } else {
                this.resizeEmbeddedApplet();
                this.appClass.desktopScrollPane.clearAndRepaint();
            }
        }
    }

    void resizeDesktopFrame() {
        Dimension dimension = this.appClass.vncFrame.getToolkit().getScreenSize();
        Dimension dimension2 = this.appClass.desktopScrollPane.getSize();
        dimension.height -= 30;
        dimension.width -= 30;
        Insets insets = this.appClass.desktopScrollPane.getInsets();
        dimension.height -= insets.top + insets.bottom;
        dimension.width -= insets.left + insets.right;
        boolean bl = false;
        if (dimension2.width != this.rfb.framebufferWidth || dimension2.height != this.rfb.framebufferHeight) {
            bl = true;
        }
        int n = this.rfb.framebufferWidth;
        int n2 = this.rfb.framebufferHeight;
        if (n > dimension.width) {
            n = dimension.width;
            bl = true;
        }
        if (n2 > dimension.height) {
            n2 = dimension.height;
            bl = true;
        }
        if (bl) {
            this.appClass.desktopScrollPane.setSize(n, n2);
            this.appClass.desktopScrollPane.validate();
        }
        this.setSize(this.getPreferredSize());
        this.appClass.vncFrame.pack();
    }

    void resizeEmbeddedApplet() {
        Dimension dimension = this.appClass.desktopScrollPane.getSize();
        if (dimension.width != this.appClass.dispW || dimension.height != this.appClass.dispH) {
            this.appClass.desktopScrollPane.setSize(this.appClass.dispW, this.appClass.dispH);
        }
        this.appClass.desktopScrollPane.validate();
        this.setSize(this.getPreferredSize());
    }

    /*
     * Unable to fully structure code
     */
    public void processNormalProtocol() throws Exception {
        this.zlibInflater = new Inflater();
        this.tightInflaters = new Inflater[4];
        this.appClass.updatePos();
        this.appClass.fbs.addObserver(this);
        while (true) {
            var1_1 = this.rfb.readServerMessageType();
            block0 : switch (var1_1) {
                case 0: {
                    this.rfb.readFramebufferUpdate();
                    block16: for (var2_2 = 0; var2_2 < this.rfb.updateNRects; ++var2_2) {
                        this.rfb.readFramebufferUpdateRectHdr();
                        var3_3 = this.rfb.updateRectX;
                        var4_4 = this.rfb.updateRectY;
                        var5_5 = this.rfb.updateRectW;
                        var6_6 = this.rfb.updateRectH;
                        if (this.rfb.updateRectEncoding == -224) break block0;
                        if (this.rfb.updateRectEncoding == -223) {
                            if (var5_5 == 0 || var6_6 == 0) break block0;
                            this.rfb.setFramebufferSize(var5_5, var6_6);
                            this.updateFramebufferSize();
                            break block0;
                        }
                        if (this.rfb.updateRectEncoding == -240) ** GOTO lbl27
                        if (this.rfb.updateRectEncoding != -239) ** GOTO lbl29
lbl27:
                        // 2 sources

                        this.handleCursorShapeUpdate(this.rfb.updateRectEncoding, var3_3, var4_4, var5_5, var6_6);
                        continue;
lbl29:
                        // 1 sources

                        if (this.rfb.updateRectEncoding == -232) {
                            this.softCursorMove(var3_3, var4_4);
                            continue;
                        }
                        switch (this.rfb.updateRectEncoding) {
                            case 0: {
                                this.handleRawRect(var3_3, var4_4, var5_5, var6_6);
                                continue block16;
                            }
                            case 1: {
                                this.handleCopyRect(var3_3, var4_4, var5_5, var6_6);
                                continue block16;
                            }
                            case 2: {
                                this.handleRRERect(var3_3, var4_4, var5_5, var6_6);
                                continue block16;
                            }
                            case 4: {
                                this.handleCoRRERect(var3_3, var4_4, var5_5, var6_6);
                                continue block16;
                            }
                            case 5: {
                                this.handleHextileRect(var3_3, var4_4, var5_5, var6_6);
                                continue block16;
                            }
                            case 6: {
                                this.handleZlibRect(var3_3, var4_4, var5_5, var6_6);
                                continue block16;
                            }
                            case 7: {
                                this.handleTightRect(var3_3, var4_4, var5_5, var6_6);
                                continue block16;
                            }
                            default: {
                                throw new Exception("Unknown RFB rectangle encoding " + Integer.toString(this.rfb.updateRectEncoding, 16));
                            }
                        }
                    }
                    break;
                }
                case 1: {
                    throw new Exception("Can't handle SetColourMapEntries message");
                }
                case 2: {
                    Toolkit.getDefaultToolkit().beep();
                    break;
                }
                case 3: {
                    this.rfb.readServerCutText();
                    break;
                }
                default: {
                    throw new Exception("Unknown RFB message type " + var1_1);
                }
            }
            this.appClass.updatePos();
        }
    }

    void handleRawRect(int n, int n2, int n3, int n4) throws IOException {
        this.handleRawRect(n, n2, n3, n4, true);
    }

    void handleRawRect(int n, int n2, int n3, int n4, boolean bl) throws IOException {
        if (this.bytesPixel == 1) {
            for (int i = n2; i < n2 + n4; ++i) {
                this.rfb.is.readFully(this.pixels8, i * this.rfb.framebufferWidth + n, n3);
            }
        } else {
            byte[] byArray = new byte[n3 * 4];
            for (int i = n2; i < n2 + n4; ++i) {
                this.rfb.is.readFully(byArray);
                int n5 = i * this.rfb.framebufferWidth + n;
                for (int j = 0; j < n3; ++j) {
                    this.pixels24[n5 + j] = (byArray[j * 4 + 2] & 0xFF) << 16 | (byArray[j * 4 + 1] & 0xFF) << 8 | byArray[j * 4] & 0xFF;
                }
            }
        }
        this.handleUpdatedPixels(n, n2, n3, n4);
        if (bl) {
            this.scheduleRepaint(n, n2, n3, n4);
        }
    }

    void handleCopyRect(int n, int n2, int n3, int n4) throws IOException {
        this.rfb.readCopyRect();
        this.memGraphics.copyArea(this.rfb.copyRectSrcX, this.rfb.copyRectSrcY, n3, n4, n - this.rfb.copyRectSrcX, n2 - this.rfb.copyRectSrcY);
        this.scheduleRepaint(n, n2, n3, n4);
    }

    void handleRRERect(int n, int n2, int n3, int n4) throws IOException {
        int n5 = this.rfb.is.readInt();
        byte[] byArray = new byte[4];
        this.rfb.is.readFully(byArray);
        Color color = new Color(byArray[2] & 0xFF, byArray[1] & 0xFF, byArray[0] & 0xFF);
        this.memGraphics.setColor(color);
        this.memGraphics.fillRect(n, n2, n3, n4);
        for (int i = 0; i < n5; ++i) {
            this.rfb.is.readFully(byArray);
            color = new Color(byArray[2] & 0xFF, byArray[1] & 0xFF, byArray[0] & 0xFF);
            int n6 = n + this.rfb.is.readUnsignedShort();
            int n7 = n2 + this.rfb.is.readUnsignedShort();
            int n8 = this.rfb.is.readUnsignedShort();
            int n9 = this.rfb.is.readUnsignedShort();
            this.memGraphics.setColor(color);
            this.memGraphics.fillRect(n6, n7, n8, n9);
        }
        this.scheduleRepaint(n, n2, n3, n4);
    }

    void handleCoRRERect(int n, int n2, int n3, int n4) throws IOException {
        int n5 = this.rfb.is.readInt();
        byte[] byArray = new byte[4];
        this.rfb.is.readFully(byArray);
        Color color = new Color(byArray[2] & 0xFF, byArray[1] & 0xFF, byArray[0] & 0xFF);
        this.memGraphics.setColor(color);
        this.memGraphics.fillRect(n, n2, n3, n4);
        for (int i = 0; i < n5; ++i) {
            this.rfb.is.readFully(byArray);
            color = new Color(byArray[2] & 0xFF, byArray[1] & 0xFF, byArray[0] & 0xFF);
            int n6 = n + this.rfb.is.readUnsignedByte();
            int n7 = n2 + this.rfb.is.readUnsignedByte();
            int n8 = this.rfb.is.readUnsignedByte();
            int n9 = this.rfb.is.readUnsignedByte();
            this.memGraphics.setColor(color);
            this.memGraphics.fillRect(n6, n7, n8, n9);
        }
        this.scheduleRepaint(n, n2, n3, n4);
    }

    void handleHextileRect(int n, int n2, int n3, int n4) throws IOException {
        this.hextile_bg = new Color(0);
        this.hextile_fg = new Color(0);
        for (int i = n2; i < n2 + n4; i += 16) {
            int n5 = 16;
            if (n2 + n4 - i < 16) {
                n5 = n2 + n4 - i;
            }
            for (int j = n; j < n + n3; j += 16) {
                int n6 = 16;
                if (n + n3 - j < 16) {
                    n6 = n + n3 - j;
                }
                this.handleHextileSubrect(j, i, n6, n5);
            }
            this.scheduleRepaint(n, n2, n3, n4);
        }
    }

    void handleHextileSubrect(int n, int n2, int n3, int n4) throws IOException {
        byte[] byArray = new byte[1024];
        int n5 = this.rfb.is.readUnsignedByte();
        if ((n5 & 1) != 0) {
            for (int i = n2; i < n2 + n4; ++i) {
                this.rfb.is.readFully(byArray, 0, n3 * 4);
                int n6 = i * this.rfb.framebufferWidth + n;
                for (int j = 0; j < n3; ++j) {
                    this.pixels24[n6 + j] = (byArray[j * 4 + 2] & 0xFF) << 16 | (byArray[j * 4 + 1] & 0xFF) << 8 | byArray[j * 4] & 0xFF;
                }
            }
            this.handleUpdatedPixels(n, n2, n3, n4);
            return;
        }
        if ((n5 & 2) != 0) {
            this.rfb.is.readFully(byArray, 0, 4);
            this.hextile_bg = new Color(byArray[2] & 0xFF, byArray[1] & 0xFF, byArray[0] & 0xFF);
        }
        this.memGraphics.setColor(this.hextile_bg);
        this.memGraphics.fillRect(n, n2, n3, n4);
        if ((n5 & 4) != 0) {
            this.rfb.is.readFully(byArray, 0, 4);
            this.hextile_fg = new Color(byArray[2] & 0xFF, byArray[1] & 0xFF, byArray[0] & 0xFF);
        }
        if ((n5 & 8) == 0) {
            return;
        }
        int n7 = this.rfb.is.readUnsignedByte();
        if ((n5 & 0x10) != 0) {
            for (int i = 0; i < n7; ++i) {
                this.rfb.is.readFully(byArray, 0, 4);
                this.hextile_fg = new Color(byArray[2] & 0xFF, byArray[1] & 0xFF, byArray[0] & 0xFF);
                int n8 = this.rfb.is.readUnsignedByte();
                int n9 = this.rfb.is.readUnsignedByte();
                int n10 = n + (n8 >> 4);
                int n11 = n2 + (n8 & 0xF);
                int n12 = (n9 >> 4) + 1;
                int n13 = (n9 & 0xF) + 1;
                this.memGraphics.setColor(this.hextile_fg);
                this.memGraphics.fillRect(n10, n11, n12, n13);
            }
        } else {
            this.memGraphics.setColor(this.hextile_fg);
            for (int i = 0; i < n7; ++i) {
                int n14 = this.rfb.is.readUnsignedByte();
                int n15 = this.rfb.is.readUnsignedByte();
                int n16 = n + (n14 >> 4);
                int n17 = n2 + (n14 & 0xF);
                int n18 = (n15 >> 4) + 1;
                int n19 = (n15 & 0xF) + 1;
                this.memGraphics.fillRect(n16, n17, n18, n19);
            }
        }
    }

    void handleZlibRect(int n, int n2, int n3, int n4) throws Exception {
        int n5 = this.rfb.is.readInt();
        if (this.zlibBuf == null || this.zlibBufLen < n5) {
            this.zlibBufLen = n5 * 2;
            this.zlibBuf = new byte[this.zlibBufLen];
        }
        this.rfb.is.readFully(this.zlibBuf, 0, n5);
        this.zlibInflater.setInput(this.zlibBuf, 0, n5);
        try {
            byte[] byArray = new byte[n3 * 4];
            for (int i = n2; i < n2 + n4; ++i) {
                this.zlibInflater.inflate(byArray);
                int n6 = i * this.rfb.framebufferWidth + n;
                for (int j = 0; j < n3; ++j) {
                    this.pixels24[n6 + j] = (byArray[j * 4 + 2] & 0xFF) << 16 | (byArray[j * 4 + 1] & 0xFF) << 8 | byArray[j * 4] & 0xFF;
                }
            }
        }
        catch (DataFormatException dataFormatException) {
            throw new Exception(dataFormatException.toString());
        }
        this.handleUpdatedPixels(n, n2, n3, n4);
        this.scheduleRepaint(n, n2, n3, n4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleTightRect(int n, int n2, int n3, int n4) throws Exception {
        int n5;
        byte[] byArray;
        int n6;
        int n7;
        int n8 = this.rfb.is.readUnsignedByte();
        for (n7 = 0; n7 < 4; ++n7) {
            if ((n8 & 1) != 0 && this.tightInflaters[n7] != null) {
                this.tightInflaters[n7] = null;
            }
            n8 >>= 1;
        }
        if (n8 > 9) {
            throw new Exception("Incorrect tight subencoding: " + n8);
        }
        if (n8 == 8) {
            byte[] byArray2 = new byte[3];
            this.rfb.is.readFully(byArray2);
            Color color = new Color(byArray2[0] & 0xFF, byArray2[1] & 0xFF, byArray2[2] & 0xFF);
            this.memGraphics.setColor(color);
            this.memGraphics.fillRect(n, n2, n3, n4);
            this.scheduleRepaint(n, n2, n3, n4);
            return;
        }
        if (n8 == 9) {
            byte[] byArray3 = new byte[this.rfb.readCompactLen()];
            this.rfb.is.readFully(byArray3);
            Image image = Toolkit.getDefaultToolkit().createImage(byArray3);
            Rectangle rectangle = this.jpegRect = new Rectangle(n, n2, n3, n4);
            synchronized (rectangle) {
                Toolkit.getDefaultToolkit().prepareImage(image, -1, -1, this);
                try {
                    this.jpegRect.wait(3000L);
                }
                catch (InterruptedException interruptedException) {
                    throw new Exception("Interrupted while decoding JPEG image");
                }
            }
            this.jpegRect = null;
            return;
        }
        n7 = 0;
        int n9 = n3;
        int[] nArray = new int[256];
        boolean bl = false;
        if ((n8 & 4) != 0) {
            n6 = this.rfb.is.readUnsignedByte();
            if (n6 == 1) {
                n7 = this.rfb.is.readUnsignedByte() + 1;
                byArray = new byte[n7 * 3];
                this.rfb.is.readFully(byArray);
                for (n5 = 0; n5 < n7; ++n5) {
                    nArray[n5] = (byArray[n5 * 3] & 0xFF) << 16 | (byArray[n5 * 3 + 1] & 0xFF) << 8 | byArray[n5 * 3 + 2] & 0xFF;
                }
                if (n7 == 2) {
                    n9 = (n3 + 7) / 8;
                }
            } else if (n6 == 2) {
                bl = true;
            } else if (n6 != 0) {
                throw new Exception("Incorrect tight filter id: " + n6);
            }
        }
        if (n7 == 0 && this.bytesPixel == 4) {
            n9 *= 3;
        }
        n6 = n4 * n9;
        if (n6 < 12) {
            if (n7 != 0) {
                byArray = new byte[n6];
                this.rfb.is.readFully(byArray);
                if (n7 == 2) {
                    this.decodeMonoData(n, n2, n3, n4, byArray, nArray);
                } else {
                    n5 = 0;
                    for (int i = n2; i < n2 + n4; ++i) {
                        for (int j = n; j < n + n3; ++j) {
                            this.pixels24[i * this.rfb.framebufferWidth + j] = nArray[byArray[n5++] & 0xFF];
                        }
                    }
                }
            } else if (bl) {
                byArray = new byte[n3 * n4 * 3];
                this.rfb.is.readFully(byArray);
                this.decodeGradientData(n, n2, n3, n4, byArray);
            } else if (this.bytesPixel == 1) {
                for (int i = n2; i < n2 + n4; ++i) {
                    this.rfb.is.readFully(this.pixels8, i * this.rfb.framebufferWidth + n, n3);
                }
            } else {
                byArray = new byte[n3 * 3];
                for (int i = n2; i < n2 + n4; ++i) {
                    this.rfb.is.readFully(byArray);
                    int n10 = i * this.rfb.framebufferWidth + n;
                    for (n5 = 0; n5 < n3; ++n5) {
                        this.pixels24[n10 + n5] = (byArray[n5 * 3] & 0xFF) << 16 | (byArray[n5 * 3 + 1] & 0xFF) << 8 | byArray[n5 * 3 + 2] & 0xFF;
                    }
                }
            }
        } else {
            int n11 = this.rfb.readCompactLen();
            byte[] byArray4 = new byte[n11];
            this.rfb.is.readFully(byArray4);
            int n12 = n8 & 3;
            if (this.tightInflaters[n12] == null) {
                this.tightInflaters[n12] = new Inflater();
            }
            Inflater inflater = this.tightInflaters[n12];
            inflater.setInput(byArray4);
            try {
                if (n7 != 0) {
                    byte[] byArray5 = new byte[n6];
                    inflater.inflate(byArray5);
                    if (n7 == 2) {
                        this.decodeMonoData(n, n2, n3, n4, byArray5, nArray);
                    }
                    int n13 = 0;
                    for (int i = n2; i < n2 + n4; ++i) {
                        for (int j = n; j < n + n3; ++j) {
                            this.pixels24[i * this.rfb.framebufferWidth + j] = nArray[byArray5[n13++] & 0xFF];
                        }
                    }
                }
                if (bl) {
                    byte[] byArray6 = new byte[n3 * n4 * 3];
                    inflater.inflate(byArray6);
                    this.decodeGradientData(n, n2, n3, n4, byArray6);
                }
                byte[] byArray7 = new byte[n3 * 3];
                for (int i = n2; i < n2 + n4; ++i) {
                    inflater.inflate(byArray7);
                    int n14 = i * this.rfb.framebufferWidth + n;
                    for (int j = 0; j < n3; ++j) {
                        this.pixels24[n14 + j] = (byArray7[j * 3] & 0xFF) << 16 | (byArray7[j * 3 + 1] & 0xFF) << 8 | byArray7[j * 3 + 2] & 0xFF;
                    }
                }
            }
            catch (DataFormatException dataFormatException) {
                throw new Exception(dataFormatException.toString());
            }
        }
        this.handleUpdatedPixels(n, n2, n3, n4);
        this.scheduleRepaint(n, n2, n3, n4);
    }

    void decodeMonoData(int n, int n2, int n3, int n4, byte[] byArray, byte[] byArray2) {
        int n5 = n2 * this.rfb.framebufferWidth + n;
        int n6 = (n3 + 7) / 8;
        for (int i = 0; i < n4; ++i) {
            int n7;
            int n8;
            for (n8 = 0; n8 < n3 / 8; ++n8) {
                byte by = byArray[i * n6 + n8];
                for (n7 = 7; n7 >= 0; --n7) {
                    this.pixels8[n5++] = byArray2[by >> n7 & 1];
                }
            }
            for (n7 = 7; n7 >= 8 - n3 % 8; --n7) {
                this.pixels8[n5++] = byArray2[byArray[i * n6 + n8] >> n7 & 1];
            }
            n5 += this.rfb.framebufferWidth - n3;
        }
    }

    void decodeMonoData(int n, int n2, int n3, int n4, byte[] byArray, int[] nArray) {
        int n5 = n2 * this.rfb.framebufferWidth + n;
        int n6 = (n3 + 7) / 8;
        for (int i = 0; i < n4; ++i) {
            int n7;
            int n8;
            for (n8 = 0; n8 < n3 / 8; ++n8) {
                byte by = byArray[i * n6 + n8];
                for (n7 = 7; n7 >= 0; --n7) {
                    this.pixels24[n5++] = nArray[by >> n7 & 1];
                }
            }
            for (n7 = 7; n7 >= 8 - n3 % 8; --n7) {
                this.pixels24[n5++] = nArray[byArray[i * n6 + n8] >> n7 & 1];
            }
            n5 += this.rfb.framebufferWidth - n3;
        }
    }

    void decodeGradientData(int n, int n2, int n3, int n4, byte[] byArray) {
        byte[] byArray2 = new byte[n3 * 3];
        byte[] byArray3 = new byte[n3 * 3];
        byte[] byArray4 = new byte[3];
        int[] nArray = new int[3];
        int n5 = n2 * this.rfb.framebufferWidth + n;
        for (int i = 0; i < n4; ++i) {
            int n6;
            for (n6 = 0; n6 < 3; ++n6) {
                byArray4[n6] = (byte)(byArray2[n6] + byArray[i * n3 * 3 + n6]);
                byArray3[n6] = byArray4[n6];
            }
            this.pixels24[n5++] = (byArray4[0] & 0xFF) << 16 | (byArray4[1] & 0xFF) << 8 | byArray4[2] & 0xFF;
            for (int j = 1; j < n3; ++j) {
                for (n6 = 0; n6 < 3; ++n6) {
                    nArray[n6] = (byArray2[j * 3 + n6] & 0xFF) + (byArray4[n6] & 0xFF) - (byArray2[(j - 1) * 3 + n6] & 0xFF);
                    if (nArray[n6] > 255) {
                        nArray[n6] = 255;
                    } else if (nArray[n6] < 0) {
                        nArray[n6] = 0;
                    }
                    byArray4[n6] = (byte)(nArray[n6] + byArray[(i * n3 + j) * 3 + n6]);
                    byArray3[j * 3 + n6] = byArray4[n6];
                }
                this.pixels24[n5++] = (byArray4[0] & 0xFF) << 16 | (byArray4[1] & 0xFF) << 8 | byArray4[2] & 0xFF;
            }
            System.arraycopy(byArray3, 0, byArray2, 0, n3 * 3);
            n5 += this.rfb.framebufferWidth - n3;
        }
    }

    void handleUpdatedPixels(int n, int n2, int n3, int n4) {
        this.pixelsSource.newPixels(n, n2, n3, n4);
        this.memGraphics.setClip(n, n2, n3, n4);
        this.memGraphics.drawImage(this.rawPixelsImage, 0, 0, null);
        this.memGraphics.setClip(0, 0, this.rfb.framebufferWidth, this.rfb.framebufferHeight);
    }

    void scheduleRepaint(int n, int n2, int n3, int n4) {
        if (this.appClass.fbs.isSeeking()) {
            this.seekMode = true;
        } else if (this.seekMode) {
            this.seekMode = false;
            if (this.showSoftCursor) {
                this.scrollToPoint(this.cursorX, this.cursorY);
            }
            this.updateFramebufferSize();
            this.repaint();
        } else {
            Point point = this.getImageOrigin();
            this.repaint(this.appClass.deferScreenUpdates, point.x + n, point.y + n2, n3, n4);
        }
    }

    synchronized void handleCursorShapeUpdate(int n, int n2, int n3, int n4, int n5) throws IOException {
        this.softCursorFree();
        if (n4 * n5 == 0) {
            return;
        }
        this.softCursorSource = this.decodeCursorShape(n, n4, n5);
        this.origCursorWidth = n4;
        this.origCursorHeight = n5;
        this.origHotX = n2;
        this.origHotY = n3;
        this.createSoftCursor();
        this.showSoftCursor = true;
        Point point = this.getImageOrigin();
        this.scheduleCursorRepaint(this.cursorX - this.hotX + point.x, this.cursorY - this.hotY + point.y, this.cursorWidth, this.cursorHeight, 5);
    }

    synchronized MemoryImageSource decodeCursorShape(int n, int n2, int n3) throws IOException {
        int n4 = (n2 + 7) / 8;
        int n5 = n4 * n3;
        int[] nArray = new int[n2 * n3];
        if (n == -240) {
            byte[] byArray = new byte[6];
            this.rfb.is.readFully(byArray);
            int[] nArray2 = new int[]{0xFF000000 | (byArray[3] & 0xFF) << 16 | (byArray[4] & 0xFF) << 8 | byArray[5] & 0xFF, 0xFF000000 | (byArray[0] & 0xFF) << 16 | (byArray[1] & 0xFF) << 8 | byArray[2] & 0xFF};
            byte[] byArray2 = new byte[n5];
            this.rfb.is.readFully(byArray2);
            byte[] byArray3 = new byte[n5];
            this.rfb.is.readFully(byArray3);
            int n6 = 0;
            for (int i = 0; i < n3; ++i) {
                int n7;
                int n8;
                int n9;
                for (n9 = 0; n9 < n2 / 8; ++n9) {
                    byte by = byArray2[i * n4 + n9];
                    byte by2 = byArray3[i * n4 + n9];
                    for (n8 = 7; n8 >= 0; --n8) {
                        n7 = (by2 >> n8 & 1) != 0 ? nArray2[by >> n8 & 1] : 0;
                        nArray[n6++] = n7;
                    }
                }
                for (n8 = 7; n8 >= 8 - n2 % 8; --n8) {
                    n7 = (byArray3[i * n4 + n9] >> n8 & 1) != 0 ? nArray2[byArray2[i * n4 + n9] >> n8 & 1] : 0;
                    nArray[n6++] = n7;
                }
            }
        } else {
            byte[] byArray = new byte[n2 * n3 * this.bytesPixel];
            this.rfb.is.readFully(byArray);
            byte[] byArray4 = new byte[n5];
            this.rfb.is.readFully(byArray4);
            int n10 = 0;
            for (int i = 0; i < n3; ++i) {
                int n11;
                int n12;
                int n13;
                for (n13 = 0; n13 < n2 / 8; ++n13) {
                    byte by = byArray4[i * n4 + n13];
                    for (n12 = 7; n12 >= 0; --n12) {
                        n11 = (by >> n12 & 1) != 0 ? (this.bytesPixel == 1 ? this.cm8.getRGB(byArray[n10]) : (byArray[n10 * 4] & 0xFF) << 24 | (byArray[n10 * 4 + 1] & 0xFF) << 16 | (byArray[n10 * 4 + 2] & 0xFF) << 8 | byArray[n10 * 4 + 3] & 0xFF) : 0;
                        nArray[n10++] = n11;
                    }
                }
                for (n12 = 7; n12 >= 8 - n2 % 8; --n12) {
                    n11 = (byArray4[i * n4 + n13] >> n12 & 1) != 0 ? (this.bytesPixel == 1 ? this.cm8.getRGB(byArray[n10]) : 0xFF000000 | (byArray[n10 * 4 + 1] & 0xFF) << 16 | (byArray[n10 * 4 + 2] & 0xFF) << 8 | byArray[n10 * 4 + 3] & 0xFF) : 0;
                    nArray[n10++] = n11;
                }
            }
        }
        return new MemoryImageSource(n2, n3, nArray, 0, n2);
    }

    synchronized void createSoftCursor() {
        if (this.softCursorSource == null) {
            return;
        }
        int n = 100;
        this.cursorWidth = (this.origCursorWidth * n + 50) / 100;
        this.cursorHeight = (this.origCursorHeight * n + 50) / 100;
        this.hotX = (this.origHotX * n + 50) / 100;
        this.hotY = (this.origHotY * n + 50) / 100;
        this.softCursor = Toolkit.getDefaultToolkit().createImage(this.softCursorSource);
        if (n != 100) {
            this.softCursor = this.softCursor.getScaledInstance(this.cursorWidth, this.cursorHeight, 4);
        }
    }

    private void scrollToPoint(int n, int n2) {
        if (this.appClass.desktopScrollPane != null) {
            boolean bl = false;
            Dimension dimension = this.appClass.desktopScrollPane.getViewportSize();
            Point point = this.appClass.desktopScrollPane.getScrollPosition();
            Point point2 = new Point(point.x + dimension.width, point.y + dimension.height);
            if (n < point.x + 50) {
                point.x = n - 50;
                bl = true;
            } else if (n > point2.x - 50) {
                point.x = n - dimension.width + 50;
                bl = true;
            }
            if (n2 < point.y + 50) {
                point.y = n2 - 50;
                bl = true;
            } else if (n2 > point2.y - 50) {
                point.y = n2 - dimension.height + 50;
                bl = true;
            }
            if (bl) {
                this.appClass.desktopScrollPane.setScrollPosition(point.x, point.y);
            }
        }
    }

    synchronized void softCursorMove(int n, int n2) {
        Point point = this.getImageOrigin();
        int n3 = this.cursorX + point.x;
        int n4 = this.cursorY + point.y;
        this.cursorX = n;
        this.cursorY = n2;
        if (this.showSoftCursor) {
            this.scheduleCursorRepaint(n3 - this.hotX, n4 - this.hotY, this.cursorWidth, this.cursorHeight, 0);
            this.scheduleCursorRepaint(this.cursorX - this.hotX + point.x, this.cursorY - this.hotY + point.y, this.cursorWidth, this.cursorHeight, 1);
            if (!this.seekMode) {
                this.scrollToPoint(n, n2);
            }
        }
    }

    synchronized void softCursorFree() {
        if (this.showSoftCursor) {
            this.showSoftCursor = false;
            this.softCursor = null;
            this.softCursorSource = null;
            Point point = this.getImageOrigin();
            this.scheduleCursorRepaint(this.cursorX - this.hotX + point.x, this.cursorY - this.hotY + point.y, this.cursorWidth, this.cursorHeight, 3);
        }
    }

    Point getFrameCenter() {
        Dimension dimension = this.appClass.desktopScrollPane.getViewportSize();
        Point point = this.appClass.desktopScrollPane.getScrollPosition();
        point.x = dimension.width > this.rfb.framebufferWidth ? dimension.width / 2 : (point.x += dimension.width / 2);
        point.y = dimension.height > this.rfb.framebufferHeight ? dimension.height / 2 : (point.y += dimension.height / 2);
        return point;
    }

    public void update(Observable observable, Object object) {
        this.repaint();
        this.seekMode = false;
    }

    void scheduleCursorRepaint(int n, int n2, int n3, int n4, int n5) {
        if (this.appClass.fbs.isSeeking()) {
            this.seekMode = true;
        } else if (this.seekMode) {
            this.seekMode = false;
            if (this.showSoftCursor) {
                this.scrollToPoint(this.cursorX, this.cursorY);
            }
            this.updateFramebufferSize();
            this.repaint();
        } else {
            this.repaint(this.appClass.deferScreenUpdates, n, n2, n3, n4);
        }
    }
}

