/*
 * Decompiled with CFR 0.152.
 */
package com.tightvnc.rfbplayer;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

class RfbProto {
    static final String versionMsg = "RFB 003.003\n";
    static final int ConnFailed = 0;
    static final int NoAuth = 1;
    static final int VncAuth = 2;
    static final int VncAuthOK = 0;
    static final int VncAuthFailed = 1;
    static final int VncAuthTooMany = 2;
    static final int FramebufferUpdate = 0;
    static final int SetColourMapEntries = 1;
    static final int Bell = 2;
    static final int ServerCutText = 3;
    static final int SetPixelFormat = 0;
    static final int FixColourMapEntries = 1;
    static final int SetEncodings = 2;
    static final int FramebufferUpdateRequest = 3;
    static final int KeyboardEvent = 4;
    static final int PointerEvent = 5;
    static final int ClientCutText = 6;
    static final int EncodingRaw = 0;
    static final int EncodingCopyRect = 1;
    static final int EncodingRRE = 2;
    static final int EncodingCoRRE = 4;
    static final int EncodingHextile = 5;
    static final int EncodingZlib = 6;
    static final int EncodingTight = 7;
    static final int EncodingCompressLevel0 = -256;
    static final int EncodingQualityLevel0 = -32;
    static final int EncodingXCursor = -240;
    static final int EncodingRichCursor = -239;
    static final int EncodingPointerPos = -232;
    static final int EncodingLastRect = -224;
    static final int EncodingNewFBSize = -223;
    static final int MaxNormalEncoding = 7;
    static final int HextileRaw = 1;
    static final int HextileBackgroundSpecified = 2;
    static final int HextileForegroundSpecified = 4;
    static final int HextileAnySubrects = 8;
    static final int HextileSubrectsColoured = 16;
    static final int TightExplicitFilter = 4;
    static final int TightFill = 8;
    static final int TightJpeg = 9;
    static final int TightMaxSubencoding = 9;
    static final int TightFilterCopy = 0;
    static final int TightFilterPalette = 1;
    static final int TightFilterGradient = 2;
    static final int TightMinToCompress = 12;
    DataInputStream is;
    int serverMajor;
    int serverMinor;
    String desktopName;
    int framebufferWidth;
    int framebufferHeight;
    int bitsPerPixel;
    int depth;
    boolean bigEndian;
    boolean trueColour;
    int redMax;
    int greenMax;
    int blueMax;
    int redShift;
    int greenShift;
    int blueShift;
    int updateNRects;
    int updateRectX;
    int updateRectY;
    int updateRectW;
    int updateRectH;
    int updateRectEncoding;
    int copyRectSrcX;
    int copyRectSrcY;

    RfbProto(InputStream inputStream) throws Exception {
        this.newSession(inputStream);
    }

    public void newSession(InputStream inputStream) throws Exception {
        this.is = new DataInputStream(inputStream);
        this.readVersionMsg();
        if (this.readAuthScheme() != 1) {
            throw new Exception("Wrong authentication type in the session file");
        }
        this.readServerInit();
    }

    void readVersionMsg() throws IOException {
        byte[] byArray = new byte[12];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = 48;
        }
        this.is.readFully(byArray);
        if (byArray[0] != 82 || byArray[1] != 70 || byArray[2] != 66 || byArray[3] != 32 || byArray[4] < 48 || byArray[4] > 57 || byArray[5] < 48 || byArray[5] > 57 || byArray[6] < 48 || byArray[6] > 57 || byArray[7] != 46 || byArray[8] < 48 || byArray[8] > 57 || byArray[9] < 48 || byArray[9] > 57 || byArray[10] < 48 || byArray[10] > 57 || byArray[11] != 10) {
            throw new IOException("Incorrect protocol version");
        }
        this.serverMajor = (byArray[4] - 48) * 100 + (byArray[5] - 48) * 10 + (byArray[6] - 48);
        this.serverMinor = (byArray[8] - 48) * 100 + (byArray[9] - 48) * 10 + (byArray[10] - 48);
    }

    int readAuthScheme() throws IOException {
        int n = this.is.readInt();
        switch (n) {
            case 0: {
                int n2 = this.is.readInt();
                byte[] byArray = new byte[n2];
                this.is.readFully(byArray);
                throw new IOException(new String(byArray));
            }
            case 1: 
            case 2: {
                return n;
            }
        }
        throw new IOException("Unknown authentication scheme " + n);
    }

    void readServerInit() throws Exception {
        this.framebufferWidth = this.is.readUnsignedShort();
        this.framebufferHeight = this.is.readUnsignedShort();
        this.bitsPerPixel = this.is.readUnsignedByte();
        this.depth = this.is.readUnsignedByte();
        this.bigEndian = this.is.readUnsignedByte() != 0;
        this.trueColour = this.is.readUnsignedByte() != 0;
        this.redMax = this.is.readUnsignedShort();
        this.greenMax = this.is.readUnsignedShort();
        this.blueMax = this.is.readUnsignedShort();
        this.redShift = this.is.readUnsignedByte();
        this.greenShift = this.is.readUnsignedByte();
        this.blueShift = this.is.readUnsignedByte();
        byte[] byArray = new byte[3];
        this.is.readFully(byArray);
        int n = this.is.readInt();
        byte[] byArray2 = new byte[n];
        this.is.readFully(byArray2);
        this.desktopName = new String(byArray2);
    }

    void setFramebufferSize(int n, int n2) {
        this.framebufferWidth = n;
        this.framebufferHeight = n2;
    }

    int readServerMessageType() throws IOException {
        return this.is.readUnsignedByte();
    }

    void readFramebufferUpdate() throws IOException {
        this.is.readByte();
        this.updateNRects = this.is.readUnsignedShort();
    }

    void readFramebufferUpdateRectHdr() throws IOException {
        this.updateRectX = this.is.readUnsignedShort();
        this.updateRectY = this.is.readUnsignedShort();
        this.updateRectW = this.is.readUnsignedShort();
        this.updateRectH = this.is.readUnsignedShort();
        this.updateRectEncoding = this.is.readInt();
        if (this.updateRectEncoding < 0 || this.updateRectEncoding > 7) {
            return;
        }
        if (this.updateRectX + this.updateRectW > this.framebufferWidth || this.updateRectY + this.updateRectH > this.framebufferHeight) {
            throw new IOException("Framebuffer update rectangle too large: " + this.updateRectW + "x" + this.updateRectH + " at (" + this.updateRectX + "," + this.updateRectY + ")");
        }
    }

    void readCopyRect() throws IOException {
        this.copyRectSrcX = this.is.readUnsignedShort();
        this.copyRectSrcY = this.is.readUnsignedShort();
    }

    String readServerCutText() throws IOException {
        byte[] byArray = new byte[3];
        this.is.readFully(byArray);
        int n = this.is.readInt();
        byte[] byArray2 = new byte[n];
        this.is.readFully(byArray2);
        return new String(byArray2);
    }

    int readCompactLen() throws IOException {
        int n = this.is.readUnsignedByte();
        int n2 = n & 0x7F;
        if ((n & 0x80) != 0) {
            n = this.is.readUnsignedByte();
            n2 |= (n & 0x7F) << 7;
            if ((n & 0x80) != 0) {
                n = this.is.readUnsignedByte();
                n2 |= (n & 0xFF) << 14;
            }
        }
        return n2;
    }
}

