/*
 * Decompiled with CFR 0.152.
 */
package com.tightvnc.rfbplayer;

import com.tightvnc.rfbplayer.FbsEntryPoint;
import com.tightvnc.rfbplayer.FbsInputStream;
import java.applet.Applet;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;

public class FbsConnection {
    URL fbsURL;
    URL fbiURL;
    URL fbkURL;
    FbsEntryPoint[] indexData;
    int numIndexRecords;
    byte[] rfbInitData;

    FbsConnection(String string, String string2, Applet applet) throws MalformedURLException {
        URL uRL = null;
        if (applet != null) {
            uRL = applet.getCodeBase();
        }
        this.fbsURL = new URL(uRL, string);
        this.fbkURL = null;
        this.fbiURL = null;
        if (string2 != null) {
            try {
                this.fbiURL = new URL(uRL, string2 + ".fbi");
                this.fbkURL = new URL(uRL, string2 + ".fbk");
            }
            catch (MalformedURLException malformedURLException) {
                this.fbkURL = null;
                this.fbiURL = null;
            }
        }
        this.indexData = null;
        this.numIndexRecords = 0;
        this.rfbInitData = null;
        this.loadIndex();
    }

    FbsInputStream connect(long l) throws IOException {
        FbsInputStream fbsInputStream = null;
        int n = this.indexForTimeOffset(l);
        if (n >= 0) {
            FbsEntryPoint fbsEntryPoint = this.indexData[n];
            if (fbsEntryPoint.key_size < fbsEntryPoint.fbs_fpos) {
                try {
                    fbsInputStream = this.openFbsFile(fbsEntryPoint);
                }
                catch (IOException iOException) {
                    System.err.println(iOException);
                }
                if (fbsInputStream == null) {
                    System.err.println("Could not open FBS file at entry point " + fbsEntryPoint.timestamp + " ms");
                }
            }
        }
        if (fbsInputStream == null) {
            fbsInputStream = this.openFbsFile();
        }
        fbsInputStream.setTimeOffset(l, false);
        return fbsInputStream;
    }

    private void loadIndex() {
        if (this.fbiURL != null && this.fbkURL != null) {
            byte[] byArray;
            FbsEntryPoint[] fbsEntryPointArray;
            int n = 0;
            try {
                URLConnection uRLConnection = this.fbiURL.openConnection();
                uRLConnection.connect();
                DataInputStream dataInputStream = new DataInputStream(uRLConnection.getInputStream());
                byte[] byArray2 = new byte[12];
                dataInputStream.readFully(byArray2);
                if (byArray2[0] != 70 || byArray2[1] != 66 || byArray2[2] != 73 || byArray2[3] != 32 || byArray2[4] != 48 || byArray2[5] != 48 || byArray2[6] != 49 || byArray2[7] != 46 || byArray2[8] < 48 || byArray2[8] > 57 || byArray2[9] < 48 || byArray2[9] > 57 || byArray2[10] < 48 || byArray2[10] > 57 || byArray2[11] != 10) {
                    System.err.println("Could not load index: bad .fbi file signature");
                    return;
                }
                int n2 = dataInputStream.readInt();
                if (n2 <= 0) {
                    System.err.println("Could not load index: bad .fbi record counter");
                    return;
                }
                fbsEntryPointArray = new FbsEntryPoint[n2];
                int n3 = dataInputStream.readInt();
                if (n3 <= 0) {
                    System.err.println("Could not load index: bad RFB init data size");
                    return;
                }
                byArray = new byte[n3];
                try {
                    for (int i = 0; i < n2; ++i) {
                        FbsEntryPoint fbsEntryPoint = new FbsEntryPoint();
                        fbsEntryPoint.timestamp = (long)dataInputStream.readInt() & 0xFFFFFFFFL;
                        fbsEntryPoint.key_fpos = (long)dataInputStream.readInt() & 0xFFFFFFFFL;
                        fbsEntryPoint.key_size = (long)dataInputStream.readInt() & 0xFFFFFFFFL;
                        fbsEntryPoint.fbs_fpos = (long)dataInputStream.readInt() & 0xFFFFFFFFL;
                        fbsEntryPoint.fbs_skip = (long)dataInputStream.readInt() & 0xFFFFFFFFL;
                        fbsEntryPointArray[i] = fbsEntryPoint;
                        ++n;
                    }
                }
                catch (EOFException eOFException) {
                    System.err.println("Preliminary end of .fbi file");
                }
                catch (IOException iOException) {
                    System.err.println("Ignored exception: " + iOException);
                }
                if (n == 0) {
                    System.err.println("Could not load index: failed to read .fbi data");
                    return;
                }
                if (n != n2) {
                    System.err.println("Warning: read not as much .fbi data as expected");
                }
                dataInputStream.readFully(byArray);
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.err.println("Could not load index: .fbi file not found: " + fileNotFoundException.getMessage());
                return;
            }
            catch (IOException iOException) {
                System.err.println(iOException);
                System.err.println("Could not load index: failed to load .fbi file");
                return;
            }
            for (int i = 1; i < n; ++i) {
                if (fbsEntryPointArray[i].timestamp > fbsEntryPointArray[i - 1].timestamp) continue;
                System.err.println("Could not load index: wrong .fbi file contents");
                return;
            }
            this.indexData = fbsEntryPointArray;
            this.numIndexRecords = n;
            this.rfbInitData = byArray;
            System.err.println("Loaded index data, " + n + " records");
        }
    }

    private int indexForTimeOffset(long l) {
        if (l > 0L && this.indexData != null && this.numIndexRecords > 0) {
            int n;
            for (n = 0; n < this.numIndexRecords && this.indexData[n].timestamp <= l; ++n) {
            }
            return n - 1;
        }
        return -1;
    }

    private FbsInputStream openFbsFile() throws IOException {
        return new FbsInputStream(this.fbsURL.openStream());
    }

    private FbsInputStream openFbsFile(FbsEntryPoint fbsEntryPoint) throws IOException {
        System.err.println("Entering FBS at " + fbsEntryPoint.timestamp + " ms");
        if (!this.fbkURL.getProtocol().equalsIgnoreCase("http") || !this.fbsURL.getProtocol().equalsIgnoreCase("http")) {
            System.err.println("Indexed access requires HTTP protocol in URLs");
            return null;
        }
        InputStream inputStream = FbsConnection.openHttpByteRange(this.fbkURL, fbsEntryPoint.key_fpos, fbsEntryPoint.key_size);
        if (inputStream == null) {
            return null;
        }
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        byte[] byArray = new byte[this.rfbInitData.length + (int)fbsEntryPoint.key_size];
        System.arraycopy(this.rfbInitData, 0, byArray, 0, this.rfbInitData.length);
        dataInputStream.readFully(byArray, this.rfbInitData.length, (int)fbsEntryPoint.key_size);
        dataInputStream.close();
        inputStream = FbsConnection.openHttpByteRange(this.fbsURL, fbsEntryPoint.fbs_fpos, -1L);
        if (inputStream == null) {
            return null;
        }
        return new FbsInputStream(inputStream, fbsEntryPoint.timestamp, byArray, fbsEntryPoint.fbs_skip);
    }

    private static InputStream openHttpByteRange(URL uRL, long l, long l2) throws IOException {
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
        String string = "bytes=" + l + "-";
        if (l2 != -1L) {
            long l3 = l + l2 - 1L;
            string = string + l3;
        }
        httpURLConnection.setRequestProperty("Range", string);
        httpURLConnection.connect();
        InputStream inputStream = httpURLConnection.getInputStream();
        if (httpURLConnection.getResponseCode() != 206) {
            System.err.println("HTTP server does not support Range request headers");
            inputStream.close();
            return null;
        }
        return inputStream;
    }
}

