
SET SQL_MODE="NO_AUTO_VALUE_ON_ZERO";

--
-- Database: `virtualizor`
--

-- --------------------------------------------------------

--
-- Table structure for table `admin_acl`
--

CREATE TABLE `admin_acl` (
  `aclid` int(11) NOT NULL AUTO_INCREMENT,
  `acl_name` varchar(25) NOT NULL,
  `act_cluster_statistics` tinyint(4) NOT NULL,
  `act_cluster_resources` tinyint(4) NOT NULL,
  `act_statistics` tinyint(4) NOT NULL,
  `act_server_statistics` tinyint(4) NOT NULL,
  `act_vs` tinyint(4) NOT NULL,
  `act_vsresources` tinyint(4) NOT NULL,
  `act_editvs` tinyint(4) NOT NULL,
  `act_suspendvs` tinyint(4) NOT NULL,
  `act_unsuspendvs` tinyint(4) NOT NULL,
  `act_deletevs` tinyint(4) NOT NULL,
  `act_startvs` tinyint(4) NOT NULL,
  `act_stopvs` tinyint(4) NOT NULL,
  `act_restartvs` tinyint(4) NOT NULL,
  `act_poweroffvs` tinyint(4) NOT NULL,
  `act_addvs` tinyint(4) NOT NULL,
  `act_rebuildvs` tinyint(4) NOT NULL,
  `act_vnc` tinyint(4) NOT NULL,
  `act_migrate` tinyint(4) NOT NULL,
  `act_ippool` tinyint(4) NOT NULL,
  `act_editippool` tinyint(4) NOT NULL,
  `act_deleteippool` tinyint(4) NOT NULL,
  `act_addippool` tinyint(4) NOT NULL,
  `act_ips` tinyint(4) NOT NULL,
  `act_editips` tinyint(4) NOT NULL,
  `act_deleteips` tinyint(4) NOT NULL,
  `act_addips` tinyint(4) NOT NULL,
  `act_servers` tinyint(4) NOT NULL,
  `act_addserver` tinyint(4) NOT NULL,
  `act_editserver` tinyint(4) NOT NULL,
  `act_deleteserver` tinyint(4) NOT NULL,
  `act_rebootserver` tinyint(4) NOT NULL,
  `act_sg` tinyint(4) NOT NULL,
  `act_addsg` tinyint(4) NOT NULL,
  `act_editsg` tinyint(4) NOT NULL,
  `act_deletesg` tinyint(4) NOT NULL,
  `act_vpsbackupsettings` tinyint(4) NOT NULL,
  `act_restorevpsbackup` tinyint(4) NOT NULL,
  `act_deletevpsbackup` tinyint(4) NOT NULL,
  `act_vpsbackups` tinyint(4) NOT NULL,
  `act_backupservers` tinyint(4) NOT NULL,
  `act_editbackupservsers` tinyint(4) NOT NULL,
  `act_addbackupserver` tinyint(4) NOT NULL,
  `act_deletebackupserver` tinyint(4) NOT NULL,
  `act_plans` tinyint(4) NOT NULL,
  `act_addplan` tinyint(4) NOT NULL,
  `act_editplan` tinyint(4) NOT NULL,
  `act_deleteplan` tinyint(4) NOT NULL,
  `act_dnsplans` tinyint(4) NOT NULL,
  `act_adddnsplan` tinyint(4) NOT NULL,
  `act_editdnsplan` tinyint(4) NOT NULL,
  `act_deletednsplan` tinyint(4) NOT NULL,
  `act_users` tinyint(4) NOT NULL,
  `act_adduser` tinyint(4) NOT NULL,
  `act_edituser` tinyint(4) NOT NULL,
  `act_deleteuser` tinyint(4) NOT NULL,
  `act_ostemplates` tinyint(4) NOT NULL,
  `act_edittemplate` tinyint(4) NOT NULL,
  `act_deletetemplate` tinyint(4) NOT NULL,
  `act_os` tinyint(4) NOT NULL,
  `act_addtemplate` tinyint(4) NOT NULL,
  `act_createtemplate` tinyint(4) NOT NULL,
  `act_iso` tinyint(4) NOT NULL,
  `act_addiso` tinyint(4) NOT NULL,
  `act_editiso` tinyint(4) NOT NULL,
  `act_deleteiso` tinyint(4) NOT NULL,
  `act_mg` tinyint(4) NOT NULL,
  `act_addmg` tinyint(4) NOT NULL,
  `act_editmg` tinyint(4) NOT NULL,
  `act_deletemg` tinyint(4) NOT NULL,
  `act_config` tinyint(4) NOT NULL,
  `act_emailsettings` tinyint(4) NOT NULL,
  `act_databackup` tinyint(4) NOT NULL,
  `act_performdatabackup` tinyint(4) NOT NULL,
  `act_dldatabackup` tinyint(4) NOT NULL,
  `act_deletedatabackup` tinyint(4) NOT NULL,
  `act_adminacl` tinyint(4) NOT NULL,
  `act_add_admin_acl` tinyint(4) NOT NULL,
  `act_edit_admin_acl` tinyint(4) NOT NULL,
  `act_delete_admin_acl` tinyint(4) NOT NULL,
  `act_serverinfo` tinyint(4) NOT NULL,
  `act_licenseinfo` tinyint(4) NOT NULL,
  `act_hostname` tinyint(4) NOT NULL,
  `act_changehostname` tinyint(4) NOT NULL,
  `act_maintenance` tinyint(4) NOT NULL,
  `act_kernconfig` tinyint(4) NOT NULL,
  `act_defaultvsconf` tinyint(4) NOT NULL,
  `act_updates` tinyint(4) NOT NULL,
  `act_emailtemps` tinyint(4) NOT NULL,
  `act_editemailtemps` tinyint(4) NOT NULL,
  `act_phpmyadmin` tinyint(4) NOT NULL,
  `act_pdns` tinyint(4) NOT NULL,
  `act_addpdns` tinyint(4) NOT NULL,
  `act_editpdns` tinyint(4) NOT NULL,
  `act_deletepdns` tinyint(4) NOT NULL,
  `act_rdns` tinyint(4) NOT NULL,
  `act_managepdns` tinyint(4) NOT NULL,
  `act_importvs` tinyint(4) NOT NULL,
  `act_ssl` tinyint(4) NOT NULL,
  `act_editssl` tinyint(4) NOT NULL,
  `act_createssl` tinyint(4) NOT NULL,
  `act_firewall` tinyint(4) NOT NULL,
  `act_procs` tinyint(4) NOT NULL,
  `act_services` tinyint(4) NOT NULL,
  `act_webserver` tinyint(4) NOT NULL,
  `act_network` tinyint(4) NOT NULL,
  `act_sendmail` tinyint(4) NOT NULL,
  `act_mysqld` tinyint(4) NOT NULL,
  `act_iptables` tinyint(4) NOT NULL,
  `act_filemanager` tinyint(4) NOT NULL,
  `act_ssh` tinyint(4) NOT NULL,
  `act_logs` tinyint(4) NOT NULL,
  `act_userlogs` tinyint(4) NOT NULL,
  `act_loginlogs` tinyint(4) NOT NULL,
  `act_deletelogs` tinyint(4) NOT NULL,
  `act_deleteloginlogs` tinyint(4) NOT NULL,
  `act_deleteuserlogs` tinyint(4) NOT NULL,  
  `act_recipes` tinyint(4) NOT NULL, 
  `act_addrecipe` tinyint(4) NOT NULL,
  `act_editrecipe` tinyint(4) NOT NULL,
  `act_iplogs` tinyint(4) NOT NULL,
  `act_deliplogs` tinyint(4) NOT NULL,
  `act_list_distros` tinyint(4) NOT NULL DEFAULT '0',
  `act_add_distro` tinyint(4) NOT NULL DEFAULT '0',
  `act_suspend_user` tinyint(4) NOT NULL,
  `act_unsuspend_user` tinyint(4) NOT NULL,
  `act_backup_plans` TINYINT(4) NOT NULL DEFAULT '0',
  `act_addbackup_plan` TINYINT(4) NOT NULL DEFAULT '0',
  `act_editbackup_plan` TINYINT(4) NOT NULL DEFAULT '0',
  `act_deletebackup_plan` TINYINT(4) NOT NULL DEFAULT '0',
  `act_haproxy` TINYINT(4) NOT NULL DEFAULT '0',
  `act_twofactauth` TINYINT(4) NOT NULL DEFAULT '0',
  `act_euiso` TINYINT(4) NOT NULL DEFAULT '0',
  `act_orphaneddisk` TINYINT(4) NOT NULL DEFAULT '0',
  `act_deleteorphaneddisk` TINYINT(4) NOT NULL DEFAULT '0',
  `act_synciso` TINYINT(4) NOT NULL DEFAULT '0',
  `act_syncostemplate` TINYINT(4) NOT NULL DEFAULT '0',
  `act_storage` TINYINT(4) NOT NULL DEFAULT '0',
  `act_addstorage` TINYINT(4) NOT NULL DEFAULT '0',
  `act_editstorage` TINYINT(4) NOT NULL DEFAULT '0',
  `act_deletestorage` TINYINT(4) NOT NULL DEFAULT '0',
  `act_manageserver` TINYINT(4) NOT NULL DEFAULT '0',  
  `act_ha` TINYINT(4) NOT NULL DEFAULT '0',
  `act_multivirt` TINYINT(4) NOT NULL DEFAULT '0',
  `act_webuzo` TINYINT(4) NOT NULL DEFAULT '0',
  `act_billing` TINYINT(4) NOT NULL DEFAULT '0',
  `act_resource_pricing` TINYINT(4) NOT NULL DEFAULT '0',
  `act_invoices` TINYINT(4) NOT NULL DEFAULT '0',
  `act_transactions` TINYINT(4) NOT NULL DEFAULT '0',
  `act_addinvoice` TINYINT(4) NOT NULL DEFAULT '0',
  `act_addtransaction` TINYINT(4) NOT NULL DEFAULT '0',
  `act_add_dnsrecord` TINYINT(4) NOT NULL DEFAULT '0', 
  `act_terminal` TINYINT(4) NOT NULL DEFAULT '0',
  `act_volumes` TINYINT(4) NOT NULL DEFAULT '0',
  `act_list_api` TINYINT(4) NOT NULL DEFAULT '0',
  `act_create_api` TINYINT(4) NOT NULL DEFAULT '0',
  `act_api_credential_edit` TINYINT(4) NOT NULL DEFAULT '0',
  `act_show_api_log` TINYINT(4) NOT NULL DEFAULT '0',
  `act_load_balancer` TINYINT(4) NOT NULL DEFAULT '0',
  `act_manage_load_balancer` TINYINT(4) NOT NULL DEFAULT '0',
  `act_sso` TINYINT(4) NOT NULL DEFAULT '0',
  `act_export_as_csv` TINYINT(4) NOT NULL DEFAULT '0',
  `act_firewall_plans` TINYINT(4) NOT NULL DEFAULT '0',
  `act_addfirewall_plan` TINYINT(4) NOT NULL DEFAULT '0',
  `act_editfirewall_plan` TINYINT(4) NOT NULL DEFAULT '0',
  `act_deletefirewall_plan` TINYINT(4) NOT NULL DEFAULT '0',
  `act_passthrough` TINYINT(4) NOT NULL DEFAULT '0',
  `act_addpassthrough` TINYINT(4) NOT NULL DEFAULT '0',
  `act_editpassthrough` TINYINT(4) NOT NULL DEFAULT '0',
  `act_deletepassthrough` TINYINT(4) NOT NULL DEFAULT '0',
  `act_kyc_setting` TINYINT(4) NOT NULL DEFAULT '0',
  `act_edit_kyc` TINYINT(4) NOT NULL DEFAULT '0',
  `act_list_kyc` TINYINT(4) NOT NULL DEFAULT '0',
  `act_log_rotation` TINYINT(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`aclid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 ;

-- --------------------------------------------------------

--
-- Table structure for table `admin_notes`
--

CREATE TABLE `admin_notes` ( 
  `noteid` int(10) NOT NULL AUTO_INCREMENT PRIMARY KEY, 
  `uid` int(10) NOT NULL, 
  `title` varchar(128) NOT NULL, 
  `content` text NOT NULL, 
  `time` int(10) NOT NULL, 
  `type` tinyint(1) NOT NULL, 
  `done` int(10) NOT NULL DEFAULT '-1' 
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------
--
-- Table structure for table `api`
--

CREATE TABLE `api` (
  `idapi` int(10) NOT NULL AUTO_INCREMENT,
  `uid` int(10) NOT NULL DEFAULT '0',
  `apikey` varchar(50) NOT NULL DEFAULT '',
  `apipass` varchar(50) NOT NULL DEFAULT '',
  `ip` TEXT NULL DEFAULT NULL,
  `logging` INT NULL DEFAULT 0,
  `data` text NOT NULL,
  PRIMARY KEY (`idapi`),
  UNIQUE KEY `apikey` (`apikey`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 ;

-- --------------------------------------------------------

--
-- Table structure for table `api_logs`
--
CREATE TABLE `api_log` ( 
  `id` INT(20) NOT NULL AUTO_INCREMENT ,
  `vpsid` INT(20) NOT NULL,
  `user_type` INT(4) NOT NULL,
  `api_id` INT(25) NOT NULL,
  `uid` INT(20) NOT NULL,
  `from_ip` VARCHAR(50) NOT NULL,
  `action` VARCHAR(20) NOT NULL,
  `time` INT(10) NOT NULL,
  `status` INT(11) NOT NULL,
  `data` TEXT NOT NULL,
  PRIMARY KEY (`id`)
  ) ENGINE = MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------
--
-- Table structure for table `backups`
--
CREATE TABLE `backups` (
  `bkid` int(10) NOT NULL AUTO_INCREMENT,
  `bkup_uuid` varchar(16) NOT NULL,
  `vpsid` int(10) NOT NULL,
  `serid` int(10) NOT NULL,
  `bid` int(10) NOT NULL,
  `bkply_id` int(10) NOT NULL,
  `parent_bkply_id` int(10) DEFAULT NULL,
  `type` varchar(10) NOT NULL,
  `is_legacy_bkp` int(5) DEFAULT 0,
  `vps_uuid` varchar(100) NOT NULL,
  `hostname` varchar(255) NOT NULL,
  `dir` text NOT NULL,
  `filepath` TEXT NOT NULL,
  `filename` TEXT NOT NULL,
  `bkply_filepath` varchar(255) NOT NULL,
  `htime` varchar(255) NOT NULL,
  `time` int(10) NOT NULL,
	`date` int(10) DEFAULT 0,
  `bitmap` varchar(255) DEFAULT NULL,
  `size` bigint(15) NOT NULL,
  `folder_format` varchar(255) NOT NULL,
  `file_count` int(10) DEFAULT NULL,
  `note` text NOT NULL,
  `data` text NOT NULL,
  `is_admin` int(10) NOT NULL,
  `inf_name` VARCHAR(255) NOT NULL,
  PRIMARY KEY (`bkid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

-- --------------------------------------------------------
--
-- Table structure for table `backup_plans`
--

CREATE TABLE `backup_plans` (
  `bpid` int(10) NOT NULL AUTO_INCREMENT,
  `disabled` tinyint(4) NOT NULL default '0',
  `plan_name` varchar(255) NOT NULL,
  `bid` int(10) NOT NULL,
  `frequency` varchar(10) NOT NULL,
  `run_time` varchar(10) NOT NULL,
  `hourly_freq` text,
  `run_day` varchar(10) NOT NULL,
  `run_date` varchar(10) NOT NULL,
  `rotation` int(10) NOT NULL,
  `backup_limit` int(10) NOT NULL DEFAULT '0',
  `restore_limit` int(10) NOT NULL DEFAULT '0',
  `enable_enduser_backup_servers` tinyint(4) NULL DEFAULT '0',
  `nice` tinyint(10) NOT NULL DEFAULT '19',
  `ionice_prio` tinyint(10) NOT NULL DEFAULT '3',
  `ionice_class` tinyint(10) NOT NULL DEFAULT '1',
  `disable_compression` tinyint(4) NOT NULL DEFAULT '0',
  `dir` text NOT NULL,
  `bs_servergroups` text,
  `io_limit` int(10) NOT NULL,
  `data` TEXT NULL DEFAULT NULL,
  PRIMARY KEY (`bpid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `backup_servers`
--

CREATE TABLE `backup_servers` (
  `bid` int(10) NOT NULL auto_increment,
  `type` varchar(10) NOT NULL,
  `name` varchar(255) NOT NULL,
  `hostname` varchar(255) NOT NULL,
  `username` varchar(255) NOT NULL,
  `password` varchar(255) NOT NULL,
  `ssh_key` INT(1) NULL,
  `sshpub_key` TEXT NULL DEFAULT NULL,
  `sshpri_key` TEXT NULL DEFAULT NULL,
  `salt` varchar(20) NOT NULL DEFAULT '',
  `port` int(11) NOT NULL,
  `dir` text NOT NULL,
  `ftps` INT(1) NULL DEFAULT '0',
  `internal_hostname` varchar(255) NOT NULL,
  PRIMARY KEY  (`bid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `bandwidth`
--

CREATE TABLE `bandwidth` (
  `vpsid` int(10) NOT NULL DEFAULT '0',
  `device` varchar(255) NOT NULL DEFAULT '',
  `date` int(10) NOT NULL DEFAULT '0',
  `time` int(10) NOT NULL DEFAULT '0',
  `in` bigint(12) NOT NULL DEFAULT '0',
  `out` bigint(12) NOT NULL DEFAULT '0',
  `c_in` bigint(12) NOT NULL DEFAULT '0',
  `c_out` bigint(12) NOT NULL DEFAULT '0',
  UNIQUE KEY `vpsid` (`vpsid`,`device`,`date`,`time`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `cloud_bandwidth`
--

 CREATE TABLE `cloud_bandwidth` (
  `vpsid` int(10) NOT NULL DEFAULT '0',
  `cloud_uid` int(10) NOT NULL DEFAULT '0',
  `cloud_email` varchar(100) NOT NULL DEFAULT '',
  `uid` int(10) NOT NULL DEFAULT '0',
  `user_email` varchar(100) NOT NULL DEFAULT '',
  `bandwidth_used` decimal(12,2) NOT NULL DEFAULT '0.00',
  `date` int(10) NOT NULL DEFAULT '0'
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `console_sessions`
--

CREATE TABLE `console_sessions` (
 `vpsid` int(10) NOT NULL DEFAULT '0',
 `serid` int(10) NOT NULL DEFAULT '0',
 `start` int(10) NOT NULL DEFAULT '0',
 `duration` int(10) NOT NULL DEFAULT '0',
 `username` varchar(50) NOT NULL DEFAULT '',
 `password` varchar(100) NOT NULL DEFAULT '',
 `port` int(10) NOT NULL DEFAULT '0',
 UNIQUE KEY `vpsid` (`vpsid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='Console Sessions';

-- --------------------------------------------------------

--
-- Table structure for table `disks`
--

CREATE TABLE `disks` (
 `did` int(10) NOT NULL AUTO_INCREMENT,
 `disk_uuid` varchar(100) NOT NULL DEFAULT '',
 `st_uuid` varchar(100) NOT NULL DEFAULT '',
 `vps_uuid` varchar(100) NOT NULL DEFAULT '',
 `path` varchar(1000) NOT NULL DEFAULT '',
 `primary` tinyint(4) NOT NULL DEFAULT '0',
 `size` decimal(10,3) NOT NULL DEFAULT '0.000',
 `size_unit` varchar(10) NOT NULL DEFAULT '',
 `type` varchar(20) NOT NULL DEFAULT '',
 `format` varchar(100) NOT NULL DEFAULT '',
 `num` int(5) NOT NULL DEFAULT '0',
 `rescue` tinyint(4) NOT NULL DEFAULT '0',
 `extra` text,
 `bus_driver` VARCHAR(100) NOT NULL DEFAULT 'sata',
 `bus_driver_num` INT(2) NOT NULL DEFAULT '0',
 `user_uid` int(10) NOT NULL DEFAULT '0',
 `disk_name` text,
 `mnt_point` text,
 PRIMARY KEY (`did`),
 UNIQUE KEY `disk_uuid` (`disk_uuid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `dnsplans`
--
CREATE TABLE `dnsplans` (
  `dnsplid` int(10) NOT NULL auto_increment,
  `pdnsid` int(10) NOT NULL,
  `plan_name` text,
  `max_domains` int(10) NOT NULL,
  `max_domain_records` int(10) NOT NULL,
  `def_ttl` int(10) NOT NULL,
  PRIMARY KEY  (`dnsplid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `email_templates`
--

CREATE TABLE `email_templates` (
			`eid` int(11) NOT NULL AUTO_INCREMENT,
			`name` varchar(255) NOT NULL,
			`mail_type` varchar(6) NOT NULL,
			`is_disable` int(11) NOT NULL,
			`data` text NOT NULL,
			PRIMARY KEY (`eid`),
			UNIQUE KEY `name` (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `enduser_backup_servers`
--

CREATE TABLE `enduser_backup_servers` (
  `bserid` int(10) NOT NULL AUTO_INCREMENT,
  `uid` int(10) NOT NULL,
  `type` varchar(10) NOT NULL,
  `name` varchar(255) NOT NULL,
  `hostname` varchar(255) NOT NULL,
  `username` varchar(255) NOT NULL,
  `password` varchar(150) NOT NULL,
  `salt` varchar(20) NOT NULL DEFAULT '',
  `port` int(11) NOT NULL,
  `dir` text NOT NULL,
  PRIMARY KEY (`bserid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `enduser_iso`
--

CREATE TABLE `enduser_iso` (
 `isoid` int(5) NOT NULL AUTO_INCREMENT,
 `uuid` varchar(50) CHARACTER SET utf8 NOT NULL,
 `uid` int(10) NOT NULL,
 `pid` int(10) NOT NULL,
 `iso` text CHARACTER SET utf8 NOT NULL,
 `size` bigint(10) NOT NULL,
 `downloaded` bigint(10) NOT NULL,
 `download_time` int(10) NOT NULL DEFAULT '0',
 `deleted` int(10) NOT NULL DEFAULT '0',
 PRIMARY KEY (`isoid`),
 UNIQUE KEY `uuid` (`uuid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `firewall_plans`
--
CREATE TABLE `firewall_plans` (
 `fwid` int(10) NOT NULL AUTO_INCREMENT,
 `uid` int(100) NOT NULL DEFAULT '0',
 `fw_plan_name` varchar(255) DEFAULT NULL,
 `rules` TEXT NULL DEFAULT NULL,
 `is_admin` int(100) NOT NULL DEFAULT '0',
 `admin_default` int(10) NOT NULL DEFAULT '0',
 `default_policy` int(10) NOT NULL DEFAULT '0',
 `for_servers` TINYINT(4) NOT NULL DEFAULT '0',
 `data` TEXT NULL DEFAULT NULL,
 PRIMARY KEY (fwid)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


-- --------------------------------------------------------

--
-- Table structure for table `fpass`
--

CREATE TABLE `fpass` (
  `uid` int(10) NOT NULL DEFAULT '0',
  `key` varchar(50) NOT NULL DEFAULT '',
  `time` int(10) NOT NULL DEFAULT '0'
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `haproxy`
--

CREATE TABLE `haproxy` (
  `id` INT(10) NOT NULL AUTO_INCREMENT,
  `vpsuuid` varchar(16) NOT NULL DEFAULT '',
  `serid` INT(10) NOT NULL DEFAULT '0',
  `protocol` VARCHAR(10) NOT NULL DEFAULT '',
  `src_hostname` VARCHAR(255) NOT NULL DEFAULT '',  
  `src_port` INT(10) NOT NULL DEFAULT '0',
  `dest_ip` VARCHAR(35) NOT NULL DEFAULT '',
  `dest_port` INT(10) NOT NULL DEFAULT '0',
  `timeadded` INT(10) NOT NULL DEFAULT '0',
  `timeupdated` INT(10) NOT NULL DEFAULT '0',
  `skipped` TEXT NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE (`serid`, `src_hostname`, `src_port`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `invoices`
--

CREATE TABLE `invoices` (
  `invoid` int(10) NOT NULL AUTO_INCREMENT,
  `invonum` int(5) NOT NULL DEFAULT '0',
  `invodate` int(10) NOT NULL DEFAULT '0',
  `invotime` int(10) NOT NULL DEFAULT '0',
  `duedate` int(10) NOT NULL DEFAULT '0',
  `uid` int(10) NOT NULL DEFAULT '0',
  `paydate` int(10) NOT NULL DEFAULT '0',
  `paytime` int(10) NOT NULL DEFAULT '0',
  `item` text NOT NULL,
  `additional_desc` text,
  `item_desc` text NOT NULL,
  `amt` decimal(10,2) NOT NULL DEFAULT '0.00',
  `disc` decimal(10,2) NOT NULL DEFAULT '0.00',
  `additional_disc` decimal(10,2) NOT NULL DEFAULT '0.00',
  `net` decimal(10,2) NOT NULL DEFAULT '0.00',
  `tax` text,
  `token` varchar(255) NOT NULL DEFAULT '',
  `cancelled` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`invoid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

--
-- Table structure for table `ippool`
--

CREATE TABLE `ippool` (
  `ippid` int(10) NOT NULL auto_increment,
  `ipp_serid` int(10) NOT NULL default '0',
  `ippool_name` text,
  `gateway` varchar(50) NOT NULL default '',
  `netmask` varchar(50) NOT NULL default '',
  `ns1` varchar(50) NOT NULL default '',
  `ns2` varchar(50) NOT NULL default '',
  `ipv6` tinyint(2) NOT NULL default '0',
  `nat` varchar(100) NOT NULL default '',
  `nat_name` varchar(100) NOT NULL default '',
  `routing` int(11) NOT NULL default '0',
  `internal` tinyint(2) NOT NULL default '0',
  `bridge` varchar(255) NOT NULL default '',
  `mtu` INT(10) NOT NULL DEFAULT '0',
  `uid` INT(10) NOT NULL DEFAULT '0',
  `vlan` int(11) NOT NULL default '0',
  `vlan_tag` INT(11) NOT NULL DEFAULT 0,
  `ovs` VARCHAR(100) NOT NULL,
  `ovs_bridge` VARCHAR(100) NOT NULL,
  `pdns_id` INT(11) NOT NULL DEFAULT 0,
  PRIMARY KEY  (`ippid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `ippool_servers`
--

CREATE TABLE `ippool_servers` (
  `ippid` int(10) NOT NULL DEFAULT '0',
  `serid` int(10) NOT NULL DEFAULT '0',
  `sgid` int(10) NOT NULL DEFAULT '0'
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `ips`
--

CREATE TABLE `ips` (
  `ipid` int(10) NOT NULL AUTO_INCREMENT,
  `ippid` int(10) NOT NULL DEFAULT '0',
  `ip_serid` int(10) NOT NULL DEFAULT '0',
  `vpsid` int(10) NOT NULL DEFAULT '0',
  `ip` varchar(50) NOT NULL DEFAULT '',
  `ipv6` tinyint(2) NOT NULL DEFAULT '0',
  `ipr_netmask` VARCHAR(20) NOT NULL DEFAULT '',
  `primary` int(5) NOT NULL DEFAULT '0',
  `ipr_ips` TEXT NULL DEFAULT NULL,
  `mac_addr` varchar(20) DEFAULT NULL,
  `locked` INT(5) NOT NULL DEFAULT '0',
  `note` TEXT NULL DEFAULT NULL,
  PRIMARY KEY (`ipid`), 
  KEY `vpsid` (`vpsid`),
  KEY `ippid_index` (`ippid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `ips_locked`
--

CREATE TABLE `ips_locked`(
  `ips` TEXT NULL,
  `serid` INT(10) DEFAULT '0',
  `time` INT(10) NULL DEFAULT '0'
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------
--
-- Table structure for table `ip_logs`
--

CREATE TABLE `ip_logs` (
 `iplid` int(10) NOT NULL AUTO_INCREMENT,
 `ipid` int(10) NOT NULL DEFAULT '0',
 `ip` varchar(100) NOT NULL DEFAULT '',
 `vpsid` varchar(10) NOT NULL DEFAULT '0',
 `uid` int(10) NOT NULL DEFAULT '0',
 `email` varchar(255) NOT NULL DEFAULT '',
 `cloud_uid` int(10) NOT NULL DEFAULT '0',
 `cloud_email` varchar(255) NOT NULL DEFAULT '',
 `time` int(10) NOT NULL DEFAULT '0',
 `date` int(10) NOT NULL DEFAULT '0',
 PRIMARY KEY (`iplid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `iso`
--

CREATE TABLE `iso` (
  `uuid` varchar(50) NOT NULL DEFAULT '',
  `iso` text,
  `mg` text
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `lb_ssl_certs`
--
CREATE TABLE `lb_ssl_certs` ( 
  `ssl_id` INT NOT NULL AUTO_INCREMENT , 
  `ssl_name` VARCHAR(255) NULL , 
  `ssl_cert` TEXT NULL , 
  `ssl_key` TEXT NULL , 
  `ssl_chain` TEXT NULL , 
  PRIMARY KEY (`ssl_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 ;

-- --------------------------------------------------------

--
-- Table structure for table `load_balancer`
--
CREATE TABLE `load_balancer` ( 
  `lbid` INT NOT NULL AUTO_INCREMENT , 
  `vps_uuid` VARCHAR(50) NULL , 
  `uid` INT NULL , 
  `sgid` INT NULL , 
  `settings` TEXT NULL , 
  PRIMARY KEY (`lbid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 ;

-- --------------------------------------------------------

--
-- Table structure for table `logs_admin`
--

CREATE TABLE `logs_admin` (
  `actid` int(10) NOT NULL AUTO_INCREMENT,
  `uid` int(10) NOT NULL DEFAULT '0',
  `id` int(10) NOT NULL DEFAULT '0',
  `action` text,
  `data` text,
  `time` int(10) NOT NULL DEFAULT '0',
  `status` int(5) NOT NULL DEFAULT '0',
  `ip` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`actid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `logs_login`
--

CREATE TABLE `logs_login` (
  `username` varchar(255) NOT NULL DEFAULT '',
  `vpsid` int(10) NOT NULL DEFAULT '0',
  `time` int(10) NOT NULL DEFAULT '0',
  `status` int(5) NOT NULL DEFAULT '0',
  `ip` varchar(255) NOT NULL DEFAULT ''
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `logs_vps`
--

CREATE TABLE `logs_vps` (
  `actid` int(10) NOT NULL AUTO_INCREMENT,
  `uid` int(10) NOT NULL DEFAULT '0',
  `vpsid` int(10) NOT NULL DEFAULT '0',
  `action` text,
  `data` text,
  `time` int(10) NOT NULL DEFAULT '0',
  `status` int(5) NOT NULL DEFAULT '0',
  `ip` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`actid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `media_groups`
--

CREATE TABLE `media_groups` (
  `mgid` int(10) NOT NULL AUTO_INCREMENT,
  `mg_name` varchar(255) NOT NULL DEFAULT '',
  `mg_desc` text,
  `mg_type` varchar(50) NOT NULL DEFAULT '',
  PRIMARY KEY (`mgid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `notifications`
--
CREATE TABLE `notifications` (
  `nid` int(11) NOT NULL AUTO_INCREMENT,
  `serid` int(11) NOT NULL DEFAULT '0',
  `action` text NOT NULL,
  `data` text NOT NULL,
  `seen_time` int(11) DEFAULT '0',
  `ins_time` int(11) NOT NULL,
  PRIMARY KEY (`nid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `os`
--

CREATE TABLE `os` (
  `osid` int(10) NOT NULL default '0',
  `osdata` text,
  `mg` text,
  UNIQUE KEY `osid` (`osid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `os_distros`
--

CREATE TABLE `os_distros` (
 `distro` varchar(50) NOT NULL DEFAULT '' COMMENT 'Small Name',
 `name` varchar(50) NOT NULL DEFAULT '' COMMENT 'Actual Name',
 `desc` text,
 `logo` text,
 `screenshot` text,
 UNIQUE KEY `distro` (`distro`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `osreinstall`
--

CREATE TABLE `osreinstall` (
  `osrid` int(10) NOT NULL AUTO_INCREMENT,
  `vpsid` int(10) NOT NULL DEFAULT '0',
  `osid` int(10) NOT NULL DEFAULT '0',
  `uid` int(10) NOT NULL DEFAULT '0',
  `time` int(10) NOT NULL DEFAULT '0', 
  PRIMARY KEY (`osrid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `pdns`
--

CREATE TABLE `pdns` (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(250) NOT NULL,
  `description` text NOT NULL,
  `sql_ipaddress` varchar(200) NOT NULL,
  `sql_port` int(11) NOT NULL default '3306',
  `sql_username` varchar(200) NOT NULL,
  `sql_password` varchar(250) NOT NULL,
  `sql_database` varchar(200) NOT NULL,
  `use_ssl` INT(5) NOT NULL DEFAULT '0',
  `encrypt_sql_pass` int(10) NOT NULL DEFAULT '0',
  `salt` varchar(20) NOT NULL DEFAULT '',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `plans`
--

CREATE TABLE `plans` (
  `plid` int(10) NOT NULL AUTO_INCREMENT,
  `plan_name` text,
  `virt` varchar(50) NOT NULL DEFAULT '',
  `ips` int(10) NOT NULL DEFAULT '0',
  `ips6` int(10) NOT NULL DEFAULT '0',
  `ips6_subnet` int(10) NOT NULL DEFAULT '0',
  `ips_int` int(10) NOT NULL DEFAULT '0',
  `space` int(10) NOT NULL DEFAULT '0',
  `inodes` int(10) NOT NULL DEFAULT '0',
  `ram` int(10) NOT NULL DEFAULT '0',
  `burst` int(10) NOT NULL DEFAULT '0',
  `swap` int(10) NOT NULL DEFAULT '0',
  `cpu` int(10) NOT NULL DEFAULT '0',
  `cores` int(10) NOT NULL DEFAULT '0',
  `cpu_percent` decimal(10,2) NOT NULL DEFAULT '0.00',
  `bandwidth` int(10) NOT NULL DEFAULT '0',
  `network_speed` int(10) NOT NULL DEFAULT '0',
  `upload_speed` INT(10) NOT NULL DEFAULT '0',
  `nic_type` varchar(20) NOT NULL DEFAULT '',
  `io` int(10) NOT NULL DEFAULT '0',
  `virtio` INT(10) NOT NULL DEFAULT '0',
  `ubc` text,
  `ploop` INT(2) NOT NULL DEFAULT '0',
  `band_suspend` INT(5) NOT NULL DEFAULT '0',
  `dns_nameserver` TEXT NULL DEFAULT NULL,
  `ppp` INT(10) NOT NULL DEFAULT '0',
  `tuntap` INT(10) NOT NULL DEFAULT '0',
  `control_panel` TEXT NOT NULL,
  `mgs` TEXT NULL DEFAULT NULL,
  `cpu_mode` VARCHAR(255) NULL,
  `sec_iso` TEXT NULL DEFAULT NULL,
  `hvm` INT(5) NOT NULL DEFAULT '0',
  `kvm_cache` VARCHAR(20) NOT NULL,
  `io_mode` VARCHAR(20) NOT NULL,
  `osreinstall_limit` INT(10) NOT NULL DEFAULT '0',
  `total_iops_sec` BIGINT(20) NOT NULL DEFAULT '0',
  `read_bytes_sec` BIGINT(20) NOT NULL DEFAULT '0',
  `write_bytes_sec` BIGINT(20) NOT NULL DEFAULT '0',
  `vnc_keymap` VARCHAR(20) NOT NULL,
  `osid` INT(10) NOT NULL DEFAULT '0',
  `kvm_vga` INT(4) NOT NULL DEFAULT '0',
  `acceleration` INT(4) NOT NULL DEFAULT '0',
  `vif_type` VARCHAR(100) NOT NULL,
  `pv_on_hvm` INT(4) NOT NULL DEFAULT '0',
  `iso` TEXT NULL DEFAULT NULL,
  `vnc` INT(4) NOT NULL DEFAULT '0',
  `admin_managed` int(5) NOT NULL DEFAULT '0',
  `shadow` INT(10) NOT NULL DEFAULT '0',
  `acpi` int(10) NOT NULL DEFAULT '0',
  `apic` int(10) NOT NULL DEFAULT '0',
  `pae` int(10) NOT NULL DEFAULT '0',
  `recipe` TEXT NULL DEFAULT NULL,
  `topology_sockets` INT(5) NOT NULL DEFAULT '0',
  `topology_cores` INT(5) NOT NULL DEFAULT '0',
  `topology_threads` INT(5) NOT NULL DEFAULT '0',
  `disable_nw_config` INT(5) NOT NULL DEFAULT '0',
  `rdp` INT(5) NOT NULL DEFAULT '0',
  `openvz_features` TEXT NULL DEFAULT NULL,
  `speed_cap` TEXT NULL DEFAULT NULL,
  `numa` INT(5) NOT NULL DEFAULT '0',
  `bpid` INT(10) NOT NULL DEFAULT '0',
  `install_xentools` INT(5) NOT NULL default '0',
  `ippoolid` TEXT NULL DEFAULT NULL,
  `is_enabled` TINYINT NOT NULL DEFAULT '1',
  `bus_driver` VARCHAR(100) NOT NULL,
  `bus_driver_num` INT(2) NOT NULL,
  `webuzo_data` TEXT NULL DEFAULT NULL,
  `load_balancer` VARCHAR(50) NOT NULL default '0',
  `fwid` INT(10) NOT NULL DEFAULT '0',
  `data` TEXT NULL DEFAULT NULL,
  PRIMARY KEY (`plid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `pricing`
--

CREATE TABLE `pricing` (
  `prid` int(10) NOT NULL AUTO_INCREMENT,
  `plid` int(10) NOT NULL,
  `sgid` int(10) NOT NULL,
  `h_rate` decimal(10,3) NOT NULL,
  `m_rate` decimal(10,3) NOT NULL,
  `y_rate` decimal(10,3) NOT NULL,
  PRIMARY KEY (`prid`),
  UNIQUE KEY `pp_unique_plid_sgid` (`plid`,`sgid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `passthrough`
--

CREATE TABLE `passthrough` (
  `pid` int(10) NOT NULL AUTO_INCREMENT,
  `dev_name` varchar(255) DEFAULT NULL COMMENT 'PCI device specific',
  `dev_fullname` TEXT NOT NULL COMMENT 'Full info about device',
  `name` varchar(255) NOT NULL,
  `vpsid` int(10) DEFAULT 0,
  `serid` int(10) DEFAULT 0,
  `iommu_grp_num` int(10) DEFAULT 0 COMMENT 'IOMMU group number. Only for PCI devices',
  `iommu_peers_num` int(10) DEFAULT 0 COMMENT 'No. of Iommu group peers',
  `description` TEXT,
  `type` varchar(255) NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`pid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `recipes`
--

CREATE TABLE `recipes` (
  `rid` int(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  `code` TEXT NULL DEFAULT NULL,
  `desc` TEXT NULL DEFAULT NULL,
  `logo` TEXT NULL DEFAULT NULL,
  `shell` varchar(255) NOT NULL DEFAULT '#!/bin/sh',
  `status` int(11) NOT NULL DEFAULT '0',
  `admin_only` INT(2) NOT NULL DEFAULT '0',
  `uid` INT(10) NOT NULL DEFAULT '0',
  `type` varchar(10) NOT NULL,
  `data` TEXT NULL DEFAULT NULL,
  PRIMARY KEY (`rid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `registry`
--

CREATE TABLE `registry` (
  `name` varchar(255) NOT NULL,
  `value` text,
  UNIQUE KEY `name` (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `self_shutdown`
--

CREATE TABLE `self_shutdown` (
`id` int(11) NOT NULL AUTO_INCREMENT,
  `vpsid` int(10) NOT NULL DEFAULT '0',
  `time` int(10) NOT NULL DEFAULT '0',
  `action` int(1) DEFAULT NULL COMMENT 'Action start = 0, stop = 1, restart = 2, poweroff = 3;',
  `status` int(1) DEFAULT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `servers`
--

CREATE TABLE `servers` (
  `serid` int(10) NOT NULL auto_increment,
  `sgid` int(10) NOT NULL default '0',
  `server_name` text,
  `virt` varchar(50) NOT NULL default '',
  `ip` varchar(50) NOT NULL default '',
  `internal_ip` varchar(50) NOT NULL default '',
  `vnc_ip` varchar(50) NOT NULL default '',
  `key` varchar(64) NOT NULL default '',
  `pass` varchar(64) NOT NULL default '',
  `settings` TEXT NULL DEFAULT NULL,
  `unique_txt` varchar(255) NOT NULL default '',
  `lv` varchar(255) NOT NULL default '',
  `hvm` int(5) NOT NULL default '0',
  `licnumvs` int(10) NOT NULL default '-1',
  `total_ram` int(10) NOT NULL default '0',
  `overcommit` int(10) NOT NULL DEFAULT '0',
  `ram` int(10) NOT NULL default '0',
  `total_space` int(10) NOT NULL default '0',
  `space` int(10) NOT NULL default '0',
  `os` VARCHAR(255) NULL DEFAULT '',
  `os_arch` VARCHAR(100) NULL DEFAULT '',
  `uname` VARCHAR(255) NULL DEFAULT '',
  `version` VARCHAR(10) NULL DEFAULT '',  
  `patch` INT(5) NOT NULL DEFAULT '0',
  `lic_expires` TEXT NULL DEFAULT NULL,
  `checked` int(10) NOT NULL default '0',
  `locked` TEXT NULL DEFAULT NULL,
  `vcores` INT(10) NOT NULL DEFAULT '0',
  `ips` INT(10) NOT NULL DEFAULT '0',
  `ipv6` INT(10) NOT NULL DEFAULT '0',
  `ipv6_subnet` INT(10) NOT NULL DEFAULT '0',
  `ips_int` INT(10) NOT NULL DEFAULT '0',
  `bandwidth` BIGINT(12) NOT NULL DEFAULT '0',
  `update_resource` TINYINT(2) NOT NULL DEFAULT '0',
  `location` VARCHAR(255) NULL DEFAULT '',
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `last_reverse_sync` int(10) NOT NULL DEFAULT '0',
  `ha_master` INT(10) NOT NULL DEFAULT '0',
  `sys_load` FLOAT(6, 2) NOT NULL DEFAULT '0',
  `fwid` INT(10) NOT NULL DEFAULT '0',
  `data` TEXT NULL DEFAULT NULL,
  PRIMARY KEY  (`serid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `server_groups`
--

CREATE TABLE `server_groups` (
  `sgid` int(10) NOT NULL AUTO_INCREMENT,
  `sg_name` varchar(255) NOT NULL DEFAULT '',
  `sg_reseller_name` varchar(255) NOT NULL DEFAULT '',
  `sg_desc` text,
  `sg_select` int(10) NOT NULL DEFAULT '0',
  `sg_ha` INT(10) NOT NULL DEFAULT '0',
  `sg_key_type` VARCHAR(50) NULL DEFAULT NULL,
  `sg_public_key` TEXT NULL DEFAULT NULL,
  `sg_private_key` TEXT NULL DEFAULT NULL,
  `sg_password` VARCHAR(50) NOT NULL,
  `sg_salt` VARCHAR(20) NOT NULL DEFAULT '',
  PRIMARY KEY (`sgid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `server_sshkeys`
--

CREATE TABLE `server_sshkeys` (
  `serid` int(10) NOT NULL DEFAULT '0',
  `type` varchar(50) NOT NULL DEFAULT '',
  `time` int(10) NOT NULL DEFAULT '0',
  `public_key` text,
  `private_key` text,
  UNIQUE KEY `serid` (`serid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='Server SSH Keys';

-- --------------------------------------------------------

--
-- Table structure for table `sessions`
--

CREATE TABLE `sessions` (
  `sid` varchar(32) NOT NULL DEFAULT '',
  `last_updated` int(10) NOT NULL DEFAULT '0',
  `data` text,
  PRIMARY KEY (`sid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `smartctl_devices`
--
CREATE TABLE `smartctl_devices` ( 
  `id` INT NOT NULL AUTO_INCREMENT , 
  `serid` SMALLINT(10) NULL DEFAULT NULL ,
  `time` INT(15) NULL,
  `devices` VARCHAR(30) NULL DEFAULT NULL ,
  `model_name` TEXT NULL DEFAULT NULL ,
  `serial_number` TEXT NULL DEFAULT NULL ,
  `firmware_version` TEXT NULL DEFAULT NULL ,
  `logical_block_size` TINYINT(5) NULL DEFAULT NULL ,
  `rotation` INT(5) NULL DEFAULT NULL,
  `temperature` VARCHAR(10) NULL DEFAULT NULL ,
  `sata_version` VARCHAR(15) NULL DEFAULT NULL, 
  `size` VARCHAR(10) NULL DEFAULT NULL,
  `health` INT(1) NULL DEFAULT NULL ,
  `disk_type` VARCHAR(5) NOT NULL ,
  `data` TEXT NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE = MyISAM;

-- --------------------------------------------------------

--
-- Table structure for table `ssh_keys`
--

CREATE TABLE IF NOT EXISTS `ssh_keys` (
  `keyid` int(10) NOT NULL AUTO_INCREMENT,
  `uuid` varchar(50) NOT NULL,
  `uid` int(10) NOT NULL,
  `name` varchar(255) NOT NULL,
  `value` text NOT NULL,
  PRIMARY KEY (`keyid`),
  UNIQUE KEY `uuid` (`uuid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `status`
--

CREATE TABLE `status` (
  `vpsid` int(10) NOT NULL DEFAULT '0',
  `time` int(10) NOT NULL DEFAULT '0',
  `status` int(10) NOT NULL DEFAULT '0',
  `disk` BIGINT(12) NOT NULL DEFAULT '0',
  `inode` BIGINT(12) NOT NULL DEFAULT '0',
  `ram` BIGINT(12) NOT NULL DEFAULT '0',
  `cpu` FLOAT(5, 2) NOT NULL DEFAULT '0',
  `actual_cpu` FLOAT(5, 2) NOT NULL DEFAULT '0',
  `net_in` BIGINT(12) NOT NULL DEFAULT '0',
  `net_out` BIGINT(12) NOT NULL DEFAULT '0',
  `io_read` int(10) NOT NULL DEFAULT '0',
  `io_write` int(10) NOT NULL DEFAULT '0'
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `storage`
--

CREATE TABLE `storage` (
  `stid` int(10) NOT NULL AUTO_INCREMENT,
  `st_uuid` varchar(50) NOT NULL DEFAULT '',
  `name` varchar(255) NOT NULL DEFAULT '',
  `path` varchar(255) NOT NULL DEFAULT '',
  `type` varchar(50) NOT NULL DEFAULT '',
  `format` varchar(50) NOT NULL DEFAULT '',
  `size` decimal(10,2) NOT NULL DEFAULT '0.00',
  `free` decimal(10,2) NOT NULL DEFAULT '0.00',
  `oversell` int(10) NOT NULL DEFAULT '0',
  `alert_threshold` decimal(10,2) NOT NULL DEFAULT '0.00',
  `primary_storage` int(5) NOT NULL DEFAULT '0',
  `project_name` text NULL DEFAULT '',
  `last_alert` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`stid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `storage_servers`
--

CREATE TABLE `storage_servers` (
  `stid` int(10) NOT NULL DEFAULT '0',
  `serid` int(10) NOT NULL DEFAULT '0',
  `sgid` int(10) NOT NULL DEFAULT '0',
  UNIQUE KEY `stid` (`stid`,`serid`,`sgid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `system_alerts`
--

CREATE TABLE `system_alerts` (
  `vpsid` int(10) NOT NULL DEFAULT '0',
  `time` int(10) NOT NULL DEFAULT '0',
  `cpu` decimal(8,2) NOT NULL DEFAULT '0.00',
  `ram` decimal(8,2) NOT NULL DEFAULT '0.00',
  `disk` decimal(8,2) NOT NULL DEFAULT '0.00'
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `tasks`
--

CREATE TABLE `tasks` (
  `actid` int(10) NOT NULL AUTO_INCREMENT,
  `slaveactid` INT(10) NULL DEFAULT ' 0',
  `uid` int(10) NOT NULL DEFAULT '0',
  `vpsid` int(10) NOT NULL DEFAULT '0',
  `serid` INT(10) NOT NULL DEFAULT '0',
  `action` text,
  `data` text,
  `time` int(10) NOT NULL DEFAULT '0',
  `status_txt` TEXT NULL DEFAULT NULL,
  `status` int(5) NOT NULL DEFAULT '0',
  `progress` VARCHAR(255) NULL DEFAULT NULL,
  `started` INT( 10 ) NOT NULL DEFAULT '0',
  `updated` INT( 10 ) NOT NULL DEFAULT '0',
  `ended` INT( 10 ) NOT NULL DEFAULT '0',
  `proc_id` INT( 10 ) NOT NULL DEFAULT '0',
  `ip` varchar(255) NOT NULL DEFAULT '',
  `internal` INT(5) NOT NULL DEFAULT '0',
  `logs` MEDIUMBLOB NULL DEFAULT NULL,
  PRIMARY KEY (`actid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `tax_rules`
--

CREATE TABLE `tax_rules` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `level` int(1) NOT NULL DEFAULT '0',
  `name` text,
  `state` text,
  `country` text,
  `taxrate` decimal(10,2) NOT NULL DEFAULT '0.00',
  `default_rule` INT NOT NULL DEFAULT 0,
  `data` TEXT NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `state_country` (`state`(32),`country`(2))
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `tmp_transactions`
--

CREATE TABLE `tmp_transactions` (
 `id` bigint(20) NOT NULL AUTO_INCREMENT,
 `token` varchar(50) NOT NULL,
 `gateway` varchar(50) NOT NULL,
 `amount` decimal(10,2) NOT NULL,
 `fees` decimal(10,2) NOT NULL DEFAULT '0.00',
 `currency` varchar(10) NOT NULL,
 `is_paid` tinyint(4) NOT NULL,
 `uid` int(10) NOT NULL,
 `date_created` int(10) NOT NULL,
 `date_completed` int(10) NOT NULL,
 `data` text,
 PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `to_master`
--

CREATE TABLE `to_master` (
  `tables` varchar(100) NOT NULL DEFAULT '',
  `columns` varchar(100) NOT NULL DEFAULT '',
  `id` varchar(32) NOT NULL DEFAULT '0',
  `unique_column` varchar(100) NOT NULL DEFAULT '',
  `value` MEDIUMTEXT,
  UNIQUE KEY `tables` (`tables`,`columns`,`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `transactions`
--

CREATE TABLE `transactions` (
  `trid` int(12) NOT NULL AUTO_INCREMENT,
  `uid` int(10) NOT NULL DEFAULT '0',
  `date` int(10) NOT NULL DEFAULT '0',
  `unixtime` int(10) NOT NULL DEFAULT '0',
  `invoid` int(10) NOT NULL DEFAULT '0',
  `gateway` varchar(200) NOT NULL DEFAULT '' COMMENT 'The Gateway name in text',
  `token` varchar(100) NOT NULL DEFAULT '',
  `amt` decimal(10,2) NOT NULL DEFAULT '0.00',
  `fees` decimal(10,2) NOT NULL DEFAULT '0.00',
  `net` decimal(10,2) NOT NULL DEFAULT '0.00',
  `bal` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT 'Remaining balance after this transaction',
  `used` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'If set to 1 then we can skip in calculating balance',
  PRIMARY KEY (`trid`),
  KEY `uid` (`uid`,`amt`,`net`),
  KEY `used` (`used`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `usage`
--
CREATE TABLE `usage` (
  `usid` int(10) NOT NULL AUTO_INCREMENT,
  `vps_uuid` varchar(100) NOT NULL DEFAULT '0',
  `uid` int(10) NOT NULL DEFAULT '0' COMMENT 'User ID',
  `serid` int(10) NOT NULL DEFAULT '0' COMMENT 'The Server ID so that we can update the SGID',
  `sgid` int(10) NOT NULL DEFAULT '0' COMMENT 'Server Group of this VPS',
  `plid` int(10) NOT NULL DEFAULT '0' COMMENT 'The VPS Plan ID',
  `invoid` int(10) NOT NULL DEFAULT '0' COMMENT 'The invoice to which this usage is linked',
  `resource` varchar(100) DEFAULT '' COMMENT 'Blank is for the VPS itself',
  `resource_val` decimal(10,3) NOT NULL DEFAULT '0.000' COMMENT 'If its a resouce the value to calculate usage',
  `starttime` int(10) NOT NULL DEFAULT '0',
  `endtime` int(10) NOT NULL DEFAULT '0',
  `updatetime` int(10) NOT NULL DEFAULT '0',
  `h_used` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT 'The estimated amount that will be charged for the VPS',
  `data` text,
  PRIMARY KEY (`usid`),
  KEY `vps_uuid` (`vps_uuid`),
  KEY `endtime` (`endtime`),
  KEY `invoid` (`invoid`),
  KEY `resource` (`resource`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `user_meta`
--

CREATE TABLE `user_meta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `uid` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext,
  PRIMARY KEY (`umeta_id`),
  UNIQUE KEY `uid_2` (`uid`,`meta_key`),  
  KEY `uid` (`uid`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `user_plans`
--

CREATE TABLE `user_plans` (
  `uplid` int(10) NOT NULL AUTO_INCREMENT,
  `plan_name` varchar(255) NOT NULL DEFAULT '',
  `type` int(10) NOT NULL DEFAULT '0' COMMENT 'User Account type',
  `aclid` int(10) NOT NULL DEFAULT '0',
  `inhouse_billing` tinyint(2) NOT NULL DEFAULT '0' COMMENT 'Are we billing or not',
  `max_cost` int(10) NOT NULL DEFAULT '0' COMMENT 'Max Cost per VM',
  `num_vs` int(10) NOT NULL DEFAULT '0',
  `num_users` int(10) NOT NULL DEFAULT '0',
  `space` int(10) NOT NULL DEFAULT '0',
  `ram` int(10) NOT NULL DEFAULT '0',
  `burst` int(10) NOT NULL DEFAULT '0',
  `bandwidth` int(10) NOT NULL DEFAULT '0',
  `cpu` int(10) NOT NULL DEFAULT '0',
  `cores` int(10) NOT NULL DEFAULT '0',
  `cpu_percent` int(10) NOT NULL DEFAULT '0',
  `num_cores` int(10) NOT NULL DEFAULT '0',
  `num_ipv4` int(10) NOT NULL DEFAULT '0',
  `num_ip_int` int(10) NOT NULL DEFAULT '0',
  `num_ipv6` int(10) NOT NULL DEFAULT '0',
  `num_ipv6_subnet` int(10) NOT NULL DEFAULT '0',
  `allowed_virts` varchar(255) NOT NULL DEFAULT '',
  `network_speed` int(10) NOT NULL DEFAULT '0',
  `upload_speed` int(10) NOT NULL DEFAULT '0',
  `sg` text,
  `mg` text,
  `dnsplid` int(10) NOT NULL,
  `service_period` int(5) NOT NULL DEFAULT '0',
  `band_suspend` int(5) NOT NULL DEFAULT '0',
  `date_created` int(10) NOT NULL DEFAULT '0',
  `space_per_vm` int(10) NOT NULL DEFAULT '0',
  `total_iops_sec` BIGINT(20) NOT NULL DEFAULT '0',
  `read_bytes_sec` BIGINT(20) NOT NULL DEFAULT '0',
  `write_bytes_sec` BIGINT(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`uplid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `users`
--

CREATE TABLE `users` (
  `uid` int(10) NOT NULL auto_increment,
  `password` varchar(50) NOT NULL default '',
  `email` varchar(255) NOT NULL default '',
  `type` int(10) NOT NULL default '0',
  `aclid` int(10) NOT NULL default '0',
  `pid` int(10) NOT NULL default '0',
  `uplid` INT(10) NOT NULL default '0' COMMENT 'User Plan ID',
  `inhouse_billing` TINYINT(2) NOT NULL DEFAULT '0',
  `cur_bal` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT 'The current balance deposited by the user',
  `cur_usage` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT 'The current usage of all VPS and resources',
  `cur_invoices` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT 'The outstanding invoices total',
  `max_cost` INT(10) NOT NULL DEFAULT '0',
  `num_vs` int(10) NOT NULL default '0',
  `num_users` int(10) NOT NULL default '0',
  `space` int(10) NOT NULL default '0',
  `ram` int(10) NOT NULL default '0',
  `burst` int(10) NOT NULL default '0',
  `bandwidth` int(10) NOT NULL default '0',
  `cpu` int(10) NOT NULL default '0',
  `cores` int(10) NOT NULL default '0',
  `cpu_percent` int(10) NOT NULL default '0',
  `num_cores` INT(10) NOT NULL DEFAULT '0',
  `num_ipv4` int(10) NOT NULL default '0',
  `num_ip_int` int(10) NOT NULL default '0',
  `num_ipv6` int(10) NOT NULL default '0',
  `num_ipv6_subnet` INT(10) NOT NULL DEFAULT '0',
  `allowed_virts` varchar(255) NOT NULL default '',
  `network_speed` int(10) NOT NULL default '0',
  `upload_speed` int(10) NOT NULL default '0',
  `openvz` tinyint(2) NOT NULL default '0',
  `xen` tinyint(2) NOT NULL default '0',
  `xenhvm` tinyint(2) NOT NULL default '0',
  `kvm` tinyint(2) NOT NULL default '0',
  `sg` text,
  `mg` text,
  `preferences` text,
  `dnsplid` int(10) NOT NULL,
  `act_status` tinyint(2) NOT NULL DEFAULT '1',
  `activation_code` varchar(100) NOT NULL DEFAULT '',
  `date_created` INT(10) NOT NULL DEFAULT '0',
  `service_period` INT(5) NOT NULL DEFAULT '0',
  `band_suspend` INT(5) NOT NULL DEFAULT '0',
  `billing_warn` text COMMENT 'Serialized Array of data related to billing issues',
  `suspended` TEXT NULL DEFAULT NULL,
  `foreign_uid` INT(10) NULL DEFAULT '0' COMMENT 'It will be the uid of the users billing system',
  `webuzo_prem_apps` TINYINT(4) NOT NULL DEFAULT '0',
  `space_per_vm` int(10) NOT NULL DEFAULT '0',
  `total_iops_sec` BIGINT(20) NOT NULL DEFAULT '0',
  `read_bytes_sec` BIGINT(20) NOT NULL DEFAULT '0',
  `write_bytes_sec` BIGINT(20) NOT NULL DEFAULT '0',
  `kyc_status` INT(10) NOT NULL DEFAULT '0' COMMENT '-1=pending, 0=not done, 1=approved, 2=rejected',
  `kyc_details` TEXT NULL DEFAULT NULL,
  `kyc_last_done` INT(10) NOT NULL DEFAULT '0',
  `kyc_settings` TEXT NULL DEFAULT NULL,
  PRIMARY KEY  (`uid`),
  KEY `email` (`email`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `vps`
--

CREATE TABLE `vps` (
  `vpsid` int(10) NOT NULL auto_increment,
  `vps_name` text,
  `uuid` VARCHAR( 50 ) NOT NULL DEFAULT '',
  `serid` int(10) NOT NULL default '0',
  `time` int(10) NOT NULL default '0',
  `edittime` int(10) NOT NULL default '0',
  `virt` varchar(32) NOT NULL,
  `uid` int(10) NOT NULL default '0',
  `plid` int(10) NOT NULL default '0',
  `hostname` text,
  `osid` int(10) NOT NULL default '0',
  `os_name` VARCHAR( 255 ) NOT NULL DEFAULT '',
  `iso` text,
  `sec_iso` text,
  `boot` text,
  `space` int(10) NOT NULL default '0',
  `inodes` int(10) NOT NULL default '0',
  `ram` int(10) NOT NULL default '0',
  `burst` int(10) NOT NULL default '0',
  `swap` int(10) NOT NULL default '0',
  `cpu` int(10) NOT NULL default '0',
  `cores` int(10) NOT NULL default '0',
  `cpupin` varchar(150) NOT NULL DEFAULT '-1',
  `cpu_percent` decimal(10,2) NOT NULL default '0.00',
  `bandwidth` int(10) NOT NULL default '0',
  `network_speed` int(10) NOT NULL default '0',
  `upload_speed` int(10) NOT NULL default '0',
  `io` int(10) NOT NULL default '0',
  `ubc` text,
  `acpi` int(5) NOT NULL default '0',
  `apic` int(5) NOT NULL default '0',
  `pae` int(5) NOT NULL default '0',
  `shadow` int(5) NOT NULL default '0',
  `vnc` int(5) NOT NULL default '0',
  `vncport` INT(10) NOT NULL DEFAULT '0',
  `vnc_passwd` VARCHAR(50) NOT NULL DEFAULT '',
  `hvm` int(5) NOT NULL default '0',
  `suspended` int(5) NOT NULL default '0',
  `suspend_reason` TEXT NULL DEFAULT NULL,
  `nw_suspended` TEXT NULL DEFAULT NULL,
  `rescue` int(10) NOT NULL default '0',
  `band_suspend` int(5) NOT NULL default '0',
  `tuntap` int(10) NOT NULL default '0',
  `ppp` int(10) NOT NULL default '0',
  `ploop` int(10) NOT NULL default '0',
  `dns_nameserver` text,
  `osreinstall_limit` int(10) NOT NULL DEFAULT '0',
  `preferences` text,
  `nic_type` varchar(20) NOT NULL,
  `vif_type` varchar(10) default NULL,
  `virtio` tinyint(1) default NULL,
  `pv_on_hvm` tinyint(4) NOT NULL default '0',
  `disks` text,
  `kvm_cache` varchar(20) NOT NULL DEFAULT '',
  `io_mode` varchar(20) NOT NULL DEFAULT '',
  `cpu_mode` VARCHAR(255) NOT NULL DEFAULT '',  
  `total_iops_sec` BIGINT(20) NOT NULL DEFAULT '0',
  `read_bytes_sec` BIGINT(20) NOT NULL DEFAULT '0',
  `write_bytes_sec` BIGINT(20) NOT NULL DEFAULT '0',
  `kvm_vga` INT(5) NOT NULL DEFAULT '0',
  `acceleration` INT(5) NOT NULL DEFAULT '0',
  `vnc_keymap` varchar(20) NOT NULL DEFAULT '',
  `routing` tinyint(1) NOT NULL,
  `mg` text,
  `used_bandwidth` DECIMAL(12, 2) NOT NULL DEFAULT '0',
  `cached_disk` TEXT NULL DEFAULT NULL,
  `webuzo` int(10) NOT NULL default '0',
  `disable_ebtables` int(5) NOT NULL default '0',
  `install_xentools` INT(5) NOT NULL default '0',
  `admin_managed` int(5) NOT NULL DEFAULT '0',
  `rdp` int(10) NOT NULL DEFAULT '0',
  `topology_sockets` INT(5) NOT NULL DEFAULT '0',
  `topology_cores` INT(5) NOT NULL DEFAULT '0',
  `topology_threads` INT(5) NOT NULL DEFAULT '0',
  `mac` VARCHAR(20) NOT NULL DEFAULT '',
  `notes` TEXT NULL DEFAULT NULL,
  `disable_nw_config` INT(5) NOT NULL DEFAULT '0',
  `locked` TEXT NULL DEFAULT NULL,
  `openvz_features` TEXT NULL DEFAULT NULL,
  `speed_cap` TEXT NULL DEFAULT NULL,
  `numa` INT(5) NOT NULL DEFAULT '0',
  `bpid` INT(10) NOT NULL DEFAULT '0',
  `bserid` INT(10) NOT NULL DEFAULT '0',
  `timezone` VARCHAR(50) NULL default NULL,
  `ha` INT(2) NOT NULL DEFAULT '0',
  `load_balancer` VARCHAR(50) NOT NULL default '0',
  `data` TEXT NULL DEFAULT NULL,
  `fwid` INT(10) NOT NULL DEFAULT '0',
  `admin_fwid` INT(10) NOT NULL DEFAULT '0',
  `current_resource` TEXT NULL DEFAULT NULL,
  `plan_expiry` INT(11) NOT NULL DEFAULT '0',
  PRIMARY KEY  (`vpsid`),
  KEY `uid` (`uid`) USING BTREE
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `vpsbackup_settings`
--

CREATE TABLE `vpsbackup_settings` (
  `vbid` int(10) NOT NULL auto_increment,
  `serid` int(10) NOT NULL default '0',
  `bid` int(10) NOT NULL,
  `enabled` tinyint(4) NOT NULL default '0',
  `newvps` tinyint(4) NOT NULL DEFAULT '0',
  `frequency` varchar(10) NOT NULL,
  `run_time` varchar(10) NOT NULL,
  `hourly_freq` text,
  `run_day` varchar(10) NOT NULL,
  `run_date` varchar(10) NOT NULL,
  `rotation` int(10) NOT NULL,
  `vpsids` text NOT NULL,
  `nice` tinyint(10) NOT NULL default '19',
  `ionice_prio` tinyint(10) NOT NULL default '3',
  `ionice_class` tinyint(10) NOT NULL default '1',
  `disable_compression` tinyint(4) NOT NULL DEFAULT '0',
  `dir` text,
  PRIMARY KEY  (`vbid`),
  UNIQUE KEY `serid` (`serid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `vps_meta`
--

CREATE TABLE `vps_meta` (
  `vmeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `serid` int(10) DEFAULT 0,
  `vps_uuid` varchar(50) NOT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext,
  PRIMARY KEY (`vmeta_id`),
  UNIQUE KEY `vps_uuid_2` (`vps_uuid`,`meta_key`),
  KEY `vps_uuid` (`vps_uuid`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `vps_name`
--

CREATE TABLE `vps_name` (
  `vpsname` text NOT NULL,
  `virt` varchar(32) NOT NULL,
  `serid` int(10) DEFAULT '0',
  `time` int(10) NOT NULL DEFAULT '0'
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
