Option Explicit
'On Error Resume Next

' Function to Echo messages
Function echo (str)
	Dim time_now
	time_now = Now()
	Wscript.Echo "[" & time_now & "] " & str
	' objFH2.Write str & vbCrLf
End Function

' Function to Execute Shell commands
' This function executes shell commands,displays the output to screen and returns the output
Function ExecCmd (objShell, Args)

	Dim cmd, run, i
	run = 0
	cmd = ""
	
	For i=LBound(Args) to UBound(Args) Step 1
		If(i = 0) Then
			cmd = Args(i)
		ElseIf (i = 1) Then
			run = Args(i)
		End If
	Next
	
	' echo cmd
	' echo run
	
	Dim ret, reto, tmpr, errn
	reto = ""
	
	If (run <> 0) Then
		' echo "Running: " & cmd
		reto = objShell.Run(cmd)
		' echo reto
	Else
		' echo "Executing: " & cmd
		Set ret = objShell.Exec(cmd)
		While Not ret.StdOut.AtEndOfStream
			tmpr = ret.StdOut.ReadLine
			' Wscript.Echo tmpr
			If tmpr <> "" Then
				reto = reto & vbNewLine & tmpr
				' echo tmpr
			End If		
		Wend
	End If
	' echo "Done"
	ExecCmd = reto
End Function


Function GetNICName(mac)
	
	Dim nic_name, nic_list, nic_index, nic_row, nic_row_parts
	Dim op, mac_tmp
	
	' Get Interface Names for corresponding MAC Addresses
	op = ExecCmd(objShell, Array("getmac /NH /FO CSV /V", 0))
	nic_list = Split(op, vbNewLine)
	
	For nic_index = LBound(nic_list) to UBound(nic_list) Step 1
		nic_row = Trim(nic_list(nic_index))
		
		If ( nic_row <> "" ) Then
			nic_row_parts = Split(nic_row, ",")
			mac_tmp = Replace(nic_row_parts(2), """", "")
			If mac_tmp = mac Then
				nic_name = Replace(nic_row_parts(0), """", "")
			End If
		End If
		
	Next
	
	GetNICName=nic_name
	
End Function

Function RemoveAllIP(nic_name, net_type)
	
	Dim op, cmd
	
	Dim ip_gw, ip_act
	Dim nic_ip_list, ip_index

	ip_gw = ""
	ip_act = "addresses"
	If net_type = "ipv4" Then
		ip_gw = " gateway=all"
		ip_act = "ipaddress"
	End If
	
	cmd = "netsh interface " & net_type & " show " & ip_act & " """ & nic_name & """ level=normal"
	echo cmd
	echo ""
	op = ExecCmd(objShell, Array(cmd, 0))
	echo op
	echo ""
	nic_ip_list = Split(Trim(op), vbNewLine)
	
	For ip_index = LBound(nic_ip_list) to UBound(nic_ip_list) Step 1
		If nic_ip_list(ip_index) <> "" AND ip_index > 3 Then
		
			' echo ip_index & " " & nic_ip_list(ip_index)
			
			Dim iprow, ip
			iprow = Split(Trim(nic_ip_list(ip_index)), " ")
			ip = iprow(UBound(iprow))
			
			If net_type = "ipv6" Then
				Dim tmp_ip
				tmp_ip = Split(ip, "%")
				ip = tmp_ip(0)
			End If
			
			cmd = "netsh interface " & net_type & " delete address """ & nic_name & """ addr=" & chr(34) & ip & chr(34) & ip_gw
			echo cmd
			op = ExecCmd(objShell, Array(cmd, 0))
			echo op
			
		End If
	Next
	
	cmd = "netsh interface " & net_type & " delete dnsservers """ & nic_name & """ all"
	echo cmd
	op = ExecCmd(objShell, Array(cmd, 0))
	echo op
	
	RemoveAllIP = 1
	
End Function

Function ProcessNetIPs(net_type, data)
	
	Dim mac, ip_list, ip_list_elems, ip_elem, ip_elem_fields, ip, netmask, prefix, gateway, default_gateway, default_mtu, deafult_routed, routed, nic_name
	Dim dns_list, dns_list_elems, dns_ip
	Dim i, cmd, op
	
	mac = data(1)
	nic_name = GetNICName(mac)
	
	' Remove old IPs and Nameservers for this NIC
	op = RemoveAllIP(nic_name, net_type)
				
	If UBound(data) > 1 Then	
		If data(2) = "dhcp" Then
			cmd = "netsh interface ipv4 set address """ & nic_name & """ source=dhcp"
			echo cmd
			op = ExecCmd(objShell, Array(cmd, 0))
			echo op
			
			cmd = "netsh interface ipv6 set address """ & nic_name & """ source=dhcp"
			echo cmd
			op = ExecCmd(objShell, Array(cmd, 0))
			echo op
			
		ElseIf data(2) <> "" Then
			ip_list = data(2)
			default_gateway = data(3)
			deafult_routed = data(4)
			default_mtu = data(5)

			dns_list = data(6)
			dns_list_elems = Split(dns_list, ",")
			
			If nic_name <> "" Then
			
				echo vbTab & mac
				echo vbTab & default_gateway
				echo vbTab & nic_name
				echo vbTab & dns_list
				
				' Add / Set IPs
				ip_list_elems = Split(ip_list, ",")
				
				For i = 0 To UBound(ip_list_elems) Step 1
					ip_elem = ip_list_elems(i)
					' echo ip_elem
					ip_elem_fields = Split(ip_elem, "/")
					ip = ip_elem_fields(0)
					netmask = ip_elem_fields(1)
					gateway = ip_elem_fields(2)
					
					If gateway = "" Then
						gateway = "none"
					End If
					
					routed = ip_elem_fields(3)
					
					Dim add_set
					Dim static_set
					
					add_set = ""
					static_set = ""
					
					If i = 0 Then
						add_set = "set"
						
						If net_type = "ipv4" Then
							static_set = " static"
						End If
						
					Else
						add_set = "add"
						static_set = ""
					End If
					
					Dim cmd_ip_nm
					If InStr(netmask, ".") Then
						cmd_ip_nm = " mask=""" & netmask & """"
					Else
						cmd_ip_nm = "/" & netmask
					End If
					
					 echo vbtab & "IP: " & ip & " Netmask: " & netmask & " Gateway: " & gateway & " Routed: " & routed
					
					cmd = "netsh interface " & net_type & " " & add_set & " address """ & nic_name & """" & static_set & " " & ip & cmd_ip_nm 
					
					If net_type = "ipv4" Then
						cmd = cmd & " " & gateway
					End If
					
					echo cmd
					op = ExecCmd(objShell, Array(cmd, 0))
					echo op
					
				Next
				
				If net_type = "ipv6" Then
					' Set default gateway
					If deafult_routed <> 0 Then
						cmd = "netsh interface " & net_type & " add route " & default_gateway & "/128 """ & nic_name & """"
						echo cmd
						op = ExecCmd(objShell, Array(cmd, 0))
						echo op
					End If
					
					cmd = "netsh interface " & net_type & " add route ::/0 """ & nic_name & """ nexthop=" & default_gateway
					echo cmd
					op = ExecCmd(objShell, Array(cmd, 0))
					echo op
				End If
				
				If net_type = "ipv4" Then
					' Set default gateway
					If deafult_routed <> 0 Then
						cmd = "netsh interface " & net_type & " add route " & default_gateway & "/32 """ & nic_name & """"
						echo cmd
						op = ExecCmd(objShell, Array(cmd, 0))
						echo op
					End If
					
					cmd = "netsh interface " & net_type & " add route ::/0 """ & nic_name & """ " & default_gateway
					echo cmd
					op = ExecCmd(objShell, Array(cmd, 0))
					echo op
				End If
				
				' Set MTU
				If default_mtu <> "" OR default_mtu <> 0 Then
					cmd = "netsh interface " & net_type & " set interface mtu=""" & default_mtu
					echo cmd
					op = ExecCmd(objShell, Array(cmd, 0))
				End If
				
				' Add/Set DNS name servers
				dns_list_elems = Split(dns_list, ",")
				
				For i = 0 To UBound(dns_list_elems) Step 1
				
					dim ns_ip, ns_index
					
					ns_index = ""
					If i <> 0 Then
						ns_index = " index=" & i
					End If
					
					ns_ip = dns_list_elems(i)
					cmd = "netsh interface " & net_type & " add dnsservers """ & nic_name & """ " & ns_ip & " index=" & i
					echo cmd
					op = ExecCmd(objShell, Array(cmd, 0))
					echo op
			
				Next
				
			End If
		End If
	End If
	
	ProcessNetIPs = 1
	
End Function

'Function to read and parse virt_script.dat
Function Configure_Options(path)
	
	' File open modes
	Const ForReading = 1 
	Const ForWriting= 2
	Const ForAppending = 8
	
	' Declration of variables used in this function
	' Dim objOptionsDict
	
	Dim line
	Dim op
	Dim cmd
	
	' Set objOptionsDict = CreateObject("Scripting.Dictionary")
	' objOptionsDict.CompareMode = vbTextCompare
	
	' Open File for reading
	Set objFH = objFSO.OpenTextFile(path, ForReading)
	
	' Parse opened file for required parameters line by line
	Do While objFH.AtEndOfStream = False
		line = objFH.ReadLine
		' echo line
		
		Dim line_elems, act_type
		line_elems = Split(Trim(line), vbTab)
		act_type = line_elems(0)
		
		Select Case act_type
		
			case "password"
				Dim user, pass
				
				user = line_elems(1)
				pass = line_elems(2)
				
				' echo vbTab & "User: " & user & ", Pass: " & pass
				' echo vbNewLine
				
				cmd = "net user " & user & " " & pass
				'echo cmd
				
				echo "Setting password for " & user
				op = ExecCmd(objShell, Array(cmd, 1))
				echo op
				
			case "rdp"
				Dim enable_rdp
				
				enable_rdp = line_elems(1)
				
				' Delete Key Value name before adding it
				cmd = "reg delete " & chr(34) & "HKLM\System\CurrentControlSet\Control\Terminal Server" & chr(34) & " /v fDenyTSConnections /f"
				op = ExecCmd(objShell, Array(cmd, 0))
				echo op
				
				cmd = "reg delete " & chr(34) & "HKLM\System\CurrentControlSet\Control\Terminal Server\WinStations\RDP-Tcp" & chr(34) & " /v UserAuthentication /f"
				op = ExecCmd(objShell, Array(cmd, 0))
				echo op
					
				If enable_rdp = 1 Then
				
					echo "Enabling RDP"
					
					' Add Key to disable deny RDP
					cmd = "reg add " & chr(34) & "HKLM\System\CurrentControlSet\Control\Terminal Server" & chr(34) & " /v fDenyTSConnections /t REG_DWORD /d 0 /f"
					' echo cmd
					op = ExecCmd(objShell, Array(cmd, 0))
					echo op
					
					' Add Key to disable userAuthentication over secure network option
					cmd = "reg add " & chr(34) & "HKLM\System\CurrentControlSet\Control\Terminal Server\WinStations\RDP-Tcp" & chr(34) & " /v UserAuthentication /t REG_DWORD /d 0 /f"
					' echo cmd
					op = ExecCmd(objShell, Array(cmd, 0))
					
					cmd = "netsh firewall set service type=REMOTEDESKTOP mode=ENABLE"
					' echo cmd
					op = ExecCmd(objShell, Array(cmd, 0))
					echo op
					
					cmd = "netsh advfirewall firewall set rule group=" & chr(34) & "remote desktop" & chr(34) & " new enable=yes"
					' echo cmd
					op = ExecCmd(objShell, Array(cmd, 0))
					echo op
					
				ElseIf enable_rdp = 0 Then
				
					echo "Disabling RDP"
					
					cmd = "reg add " & chr(34) & "HKLM\System\CurrentControlSet\Control\Terminal Server" & chr(34) & " /v fDenyTSConnections /t REG_DWORD /d 1 /f"
					' echo cmd
					op = ExecCmd(objShell, Array(cmd, 0))
					echo op
					
					cmd = "netsh firewall set service type=REMOTEDESKTOP mode=DISABLE"
					' echo cmd
					op = ExecCmd(objShell, Array(cmd, 0))
					echo op
					
					cmd = "netsh advfirewall firewall set rule group=" & chr(34) & "remote desktop" & chr(34) & " new enable=no"
					' echo cmd
					op = ExecCmd(objShell, Array(cmd, 0))
					echo op
					
				End If
				
			case "net"
				' echo ""
				' echo line
				echo "Configuring static IPv4 IPs"
				op = ProcessNetIPs("ipv4", line_elems)
				' echo vbNewLine
			
			case "net6"
				' echo ""
				' echo line
				echo "Configuring static IPv6 IPs"
				op = ProcessNetIPs("ipv6", line_elems)
				' echo vbNewLine

			case "timezone"
				Dim timezone
				
				timezone = line_elems(1)
				' echo ""
				' echo line
				echo "Configuring Time Zone"
				
				cmd = "tzutil /s " & chr(34) & timezone & chr(34) & " "
				'echo cmd
				
				echo "Configuring Time Zone " & cmd
				op = ExecCmd(objShell, Array(cmd, 0))
				echo op

				' echo vbNewLine

			
		End Select
	
	Loop
	
	objFH.close
	objFSO.DeleteFile path
	
End Function

' Declration of variables used in this function
Dim objFSO, objFH
' Dim objFH2
Dim objShell

' Get FileSystem Object
Set objFSO = CreateObject("Scripting.FileSystemObject")
' Set objFH2 = objFSO.CreateTextFile("c:\\virt_scripts\\virt_script2.log")
Set objShell = CreateObject("Wscript.Shell")

Call Configure_Options("c:\virt_scripts\virt_script.dat")
