<?php

//////////////////////////////////////////////////////////////
//===========================================================
// vpsfirewallconfig_theme.php
//===========================================================
// SOFTACULOUS VIRTUALIZOR
// Version : 1.0
// Inspired by the DESIRE to be the BEST OF ALL
// ----------------------------------------------------------
// Started by: Paramhans
// Date:       27 March 2024
// Time:       18:45 hrs
// Site:       https://www.virtualizor.com/ (SOFTACULOUS VIRTUALIZOR)
// ----------------------------------------------------------
// Please Read the Terms of use at https://www.virtualizor.com
// ----------------------------------------------------------
//===========================================================
// (c)Softaculous Ltd.
//===========================================================
//////////////////////////////////////////////////////////////

if(!defined('VIRTUALIZOR')){

	die('Hacking Attempt');

}

function vpsfirewallconfig_theme(){

global $theme, $globals, $kernel, $user, $l, $info, $error, $done;

softheader($l['<title>']);
					
error_handle($error);

echo '

<script>

function select_to_apply(){

	let selection_method = $("#method_selector").val();
	$("#select_firewall_plan_div").addClass("d-none");
	$("#choose_option_div").addClass("d-none");
	$("#submit_div").removeClass("d-flex align-items-end");
	$("#submit_div").addClass("d-none");

	$.ajax({
		type : "POST",
		url : "'.$globals['index'].'act=vpsfirewallconfig&api=json",
		data : { method_selector : selection_method},
		success:function(response){

			data = JSON.parse(response);

			if(data["done"] != undefined){

				let done = data["done"];

				let valid_response = ["plans", "users", "data"];

				let response_keys =  Object.keys(done);

				let response_diff = response_keys.filter( value => !valid_response.includes(value) );

				if(!empty(response_diff)){

					showalert("'.__J('Invalid response').'", 1);
					return false;
				}

				$("#choose_option").empty();
				$("#choose_option").attr("onchange", "");
				
				if(done["data"] == undefined){

					$("#choose_option").select2({
						"width" : "100%",
						"multiple" : false,
						"placeholder" : ""
					});

					let newOption = new Option("'.__J('None').'", 0, true, false);
					$("#choose_option").append(newOption).trigger("change");
				}

				if(done["plans"] != undefined){

					let plans = done["plans"];

					for(plid in plans){
						
						if(!empty(plid)){

							newOption = new Option(plans[plid]["plan_name"], plid, true, false);
							$("#choose_option").append(newOption).trigger("change");
						}
					}
					
				}else if(done["users"] != undefined){

					let users = done["users"];

					for(user in users){
						
						if(!empty(user)){
							
							newOption = new Option(users[user], user, true, false);
							$("#choose_option").append(newOption).trigger("change");
						}
						
					}

				}else if(done["data"]["vpses"] != undefined){

					$("#choose_option").attr("name", "vpses[]");
					show_firewall_plan_list();
					
					$("#choose_option").select2({
						"width" : "100%",
						"multiple" : true,
						ajax: {

							type : "POST",
							url: "'.$globals['index'].'act=vpsfirewallconfig&api=json",
							dataType: "json",
							delay: 100,
							data: function (params) {
							
								return {
									"method_selector" : "to_vps",
									"term" : params.term,
									"next_page" : params.page,
									"query_type" : params._type
								};
							},
							processResults: function (data, params) {

								vpsdata = [];

								params.page = params.page || 1;
								vpses = data["done"]["data"]["vpses"];
								total_vps_count = data["done"]["data"]["total_vps_count"];
								reslen = Number(data["done"]["data"]["reslen"]);
								
								// if(params.page < 2 && empty(params.term)){
								//	vpsdata.push({
								//		"id" : -1,
								//		"text" : "ALL"
								//	});
								// }

								for(vpsid in vpses){
									temp = {
										"id" : vpsid,
										"text" : vpses[vpsid]["hostname"]
									};
									vpsdata.push(temp);
								}
								
								return {

									results: vpsdata,
									pagination: {
										more: (params.page * reslen) < total_vps_count
									}
								};
							},
							cache : true

						}
						
					});

				}else if(done["data"]["servers"] != undefined){

					$("#choose_option").attr("name", "servers[]");
					show_firewall_plan_list();
					
					$("#choose_option").select2({
						"width" : "100%",
						"multiple" : true,
						ajax: {

							type : "POST",
							url: "'.$globals['index'].'act=vpsfirewallconfig&api=json",
							dataType: "json",
							delay: 100,
							data: function (params) {
							
								return {
									"method_selector" : "to_server",
									"term" : params.term,
									"next_page" : params.page,
									"query_type" : params._type
								};
							},
							processResults: function (data, params) {
								
								server_data = [];

								params.page = params.page || 1;
								servers_list = data["done"]["data"]["servers"];
								total_server_count = data["done"]["data"]["total_server_count"];
								reslen = Number(data["done"]["data"]["reslen"]);
								
								for(serid in servers_list){
									temp = {
										"id" : serid,
										"text" : servers_list[serid]["server_name"]
									};
									server_data.push(temp);
								}
								
								return {

									results: server_data,
									pagination: {
										more: (params.page * reslen) < total_server_count
									}
								};
							},
							cache : true

						}
						
					});
				}
				
				// $("#choose_option").on("select2:select", function(e){
				// 	var selected = e.params.data;
				// 	if(selected["id"] == -1){
				// 		$.each(this.options, function(i, item){
				// 			console.log(item);
				// 			$(item).prop("disabled", true);
				// 		});
				// 	}
				// });

				$("#choose_option_div").removeClass("d-none");
				$("#choose_option").select2("open");

				if(done["data"] == undefined){
					$("#choose_option").attr("onchange", "show_firewall_plan_list();");
				}
			}
		}
	});
}

function show_firewall_plan_list(){

	let selection_method = $("#method_selector").val();
	let choosen_option = $("#choose_option").val();
	$("#select_firewall_plan_div").addClass("d-none");
	$("#submit_div").removeClass("d-flex align-items-end");
	$("#submit_div").addClass("d-none");

	$.ajax({

		type : "POST",
		url : "'.$globals['index'].'act=vpsfirewallconfig&api=json",
		data : { 
			choosen_method : selection_method ,
			choosen_option : choosen_option
		},
		success : function(response){
			
			data = JSON.parse(response);

			if("error" in data){
				showalert(response["error"],"1");
				return false;
			}

			if(data["done"] != undefined){

				let done = data["done"];

				if(done["firewall_plans"] != undefined){

					let firewall_plans = done["firewall_plans"];

					$("#select_firewall_plan").empty();

					let newOption = new Option("'.__J('None').'", 0, true, false);
					$("#select_firewall_plan").append(newOption).trigger("change");

					for(firewall_plan in firewall_plans){
						
						if(!empty(firewall_plan)){
							newOption = new Option(firewall_plans[firewall_plan]["fw_plan_name"], firewall_plan, true, false);
							$("#select_firewall_plan").append(newOption).trigger("change");
						}
					}

					$("#select_firewall_plan_div").removeClass("d-none");
					$("#select_firewall_plan").select2("open");
					$("#submit_div").removeClass("d-none");
					$("#submit_div").addClass("d-flex align-items-end");
				}

			}

		}
	});

}

function apply_admin_firewall_plan(){

	let selection_method = $("#method_selector").val();
	let choosen_option = $("#choose_option").val();
	let admin_firewall = $("#select_firewall_plan").val();

	if(empty(selection_method) ){

		showalert("'.__J('Please provide a method').'", 1);
		return false;
	}else if(empty(choosen_option)){

		showalert("'.__J('Please provide an option').'", 1);
		return false;
	}

	$.ajax({
		type : "POST",
		url : "'.$globals['index'].'act=vpsfirewallconfig&api=json",
		data : {
			apply_admin_firewall_plan : admin_firewall,
			method : selection_method,
			option : choosen_option
		},
		success : function(response){
			data = JSON.parse(response);
			if("error" in data){
				showalert(response["error"],"1");
				return false;
			}
			showalert("'.__J('Firewall rules updation task has been successfully added to background').'");
		}

	});


}

</script>';

echo page_header(__('Virtual Server Firewall Configuration'), 'fas fa-1x fa-fire-alt', $globals['docs'].'vps-firewall', 0, 0, '');

$breadcrumbs = ['dashboard', 'lms_vpsfirewall_plans', 'lms_vpsfirewallconfig'];

echo get_breadcrumb($breadcrumbs);

echo '
	<div class="card mx">
		<div class="w-100 px-2 pt-3 pb-4 my-2 mx-2 rounded">
			<div class="px-4 col-sm-12 pt-2 pb-3">
				<h6 class="text-dark"> '.__('Apply Firewall to').'</h6>
			</div>
			<div class="row mx-auto px-3">
				<div class="col-sm-3">
					<label class="w-100" for="method_selector">
						'.__('Select a method').'
						<select id="method_selector" class="custom-select virt-select" name="method_selector" onchange="select_to_apply();">
							<option value="0">'.__('None').'</option>
							<option value="by_plan">'.__('Apply by Plan').'</option>
							<option value="by_users">'.__('Apply by Users').'</option>
							<option value="to_vps">'.__('Apply to VPS').'</option>
							<option value="to_server">'.__('Apply to Server').'</option>
						</select>
					</label>
				</div>
				<div class="col-sm-3 d-none" id="choose_option_div">
					<label class="w-100" for="choose_option">
						'.__('Please provide an option').'
						<select id="choose_option" class="custom-select virt-select" name="choose_option">
						</select>
					</label>
				</div>
				<div class="col-sm-4 d-none" id="select_firewall_plan_div">
					<label class="w-100" for="select_firewall_plan">
						'.__('Please select an admin firewall plan').'
						<select id="select_firewall_plan" class="custom-select virt-select" name="firewall_plans">
						</select>
					</label>
				</div>
				<div class="col-sm-2 d-none" id="submit_div">
					<button id="admin_firewall_plan" class="go_btn button-fix  border-0 mb-1" onclick="apply_admin_firewall_plan();"><i class="fas fa-check-circle mr-2" ></i>'.__('Apply Plan').'</button>
				</div>
			</div>
		</div>
	
';

softfooter();

}

