<?php

if(!defined('VIRTUALIZOR')){

	die('Hacking Attempt');

}

function getSortHeader($header_name, $sort_column, $sort_column_by, $column, $size='90'){

	global $theme, $globals;
	$str = '<div class="d-inline-flex align-items-center" style="width:'.$size.'px;">
		<div class="mr-2">
			<span class="" >'.$header_name.'</span>
		</div>
		<span class="sorter">
			<a class="text-always-white" href="'.$globals['index'].'act=vps_stats&sortcolumn='.$column.'&sortby=asc"><i class="fas fa-sort-up"></i></a><br>
			<a class="text-always-white" href="'.$globals['index'].'act=vps_stats&sortcolumn='.$column.'&sortby=desc"><i class="fas fa-sort-down"></i></a>
		</span>
	</div>';
	return $str;
}

// Each Vps Stats
function vps_stats_theme(){

	global $theme, $globals, $ckernel, $user, $l, $vps_stats, $pie_data, $vps_data, $sort_column, $sort_column_by, $notice, $servers, $kernel;
	
	//Wrap up each vps data in td
	$table_data = '';
	
softheader($l['<title>']);
						
	if(!empty($notice['no_vps'])){
		
		
		echo page_header(__('Statistics'), 'fas fa-chart-area');
		
		$breadcrumbs = ['dashboard', 'lms_vps_stats'];

		echo get_breadcrumb($breadcrumbs);

		echo '<div class="card p-4 mx-3 mb-3">';
		
		echo '<div class="row mx-auto w-100"><div class="col-sm-4"></div><div class="col-sm-4">';
			server_select();
		echo '</div></div>';
		show_alert(__('There are no Virtual Server') ,"2");
		echo '<div class="notice" id="note_box">
			<b>NOTE : </b>&nbsp; '.__('There are no Virtual Server').'</div></div>';
		
			
	}else{
		
		//Initialize the pie chart values of vps bandwidth, cpu and ram
		$values_cpu = $values_ram = $values_bandwidth = $labels = array();
		
		// Total CPU and Bandwidth of all VPSs
		$total_cpu = 0;
		$total_band = 0;
		//log_message('/tmp/'.substr(basename(__FILE__), 0, -4).'-'.__FUNCTION__.'.log','Line Number : '.__LINE__.'$vps_data:'.print_r($vps_data,1));
		foreach($vps_data as $key => $values_chart){
			$pie_cpu[$values_chart['vps_name']] = (int) $values_chart['used_cpu'];
			$pie_ram[$values_chart['vps_name']] = (int) $values_chart['used_ram'];
			$pie_bandwidth[$values_chart['vps_name']] = round((int) $values_chart['used_bandwidth'],2);
			$pie_hex_color[] = '#' . str_pad(dechex(rand(0x000000, 0xFFFFFF)), 6, 0, STR_PAD_LEFT);
		}
		
		foreach($vps_data as $k => $v){
			
			// Values to plot the PIE
			$k = str_replace("K_", "", $k);
			$values_ram[$v['vpsid']] = '{"label" : "VPS ID : '.$v['vpsid'].' VPS Name : '.$v['vps_name'].'", data: '.$v['used_ram'].'}';
			
			$total_cpu += $v['used_cpu'];
			$values_cpu[$v['vpsid']] = '{"label" : "VPS ID : '.$v['vpsid'].' VPS Name : '.$v['vps_name'].'", data: '.$v['used_cpu'].'}';
			
			$total_band += $v['used_bandwidth'];
			$values_bandwidth[$v['vpsid']] = '{"label" : "VPS ID : '.$v['vpsid'].' VPS Name : '.$v['vps_name'].'", data: '.$v['used_bandwidth'].'}';
			
			//Check the status of the vps
			if($v['status'] == 1){
				$tmp = '<td align="center" id="spcpu_'.$k.'" ><div class="small_txt">'.(float)$v['used_cpu'].'%</div></td>
					'.($kernel->features('vps_ram_info', $v['virt']) ? '<td align="center" id="spram_'.$k.'" ><div class="small_txt">'.(int)$v['used_ram'].' / '.(int)$v['ram'].' MB</div></td>' : '<td align="center" id="spram_'.$k.'" >N/A</td>').'
					<td align="center" id="spdisk_'.$k.'"><div class="small_txt">'.round($v['used_disk'], 2).' / '.$v['disk'].' GB</div></td>
					'.(empty($v['inode']) ? '<td align="center" id="spinode_'.$k.'"> N/A </td>' : '<td align="center" id="spinode_'.$k.'"><div class="small_txt">'.$v['used_inode'].' / '.$v['inode'].'</div></td>');
				$status_td = '<td align="center" id="status_'.$k.'"><h5 class="p-0 m-0"><a class="badge badge-success">'.__('Online').'</a></h5></td>';				
			}elseif($v['status'] == 2){
				$status_td = '<td align="center" id="status_'.$k.'"><h5 class="p-0 m-0"><a class="badge badge-secondary">'.__('Suspended VPS').'</a></h5></td>';
				$tmp = '<td colspan="4" class="text-center" id="nodata_'.$k.'">'.__('No data Available').'</td>';
			}else{
				$status_td = '<td align="center" id="status_'.$k.'"><h5 class="p-0 m-0"><a class="badge badge-danger">'.__('Offline').'</a></h5></td>';
				$tmp = '<td colspan="4" class="text-center" id="nodata_'.$k.'">'.__('No data Available').'</td>';
			}
			
			//Check if speed cap is enabled
			if($v['speed_cap'] == '0' || $v['speed_cap'] == NULL){
				$speedCap = '<td align="center"><h5 class="p-0 m-0"><a class="badge badge-danger">'.__('Disabled').'</a></h5></td>';
			}else{
				$speed_cap = explode(',',$v['speed_cap']);
				$speedCap = '<td align="center">'.$speed_cap[1].' KB <img src="'.$theme['images'].'admin/arrow_up.png" title="'.__('Upload Speed').'"><br>'.$speed_cap[0].' KB <img src="'.$theme['images'].'admin/arrow_down.png" title="'.__('Download Speed').'"></td>';
			}
				
			$table_data .= '<tr>
								'.$status_td.'
								<td id="vpsid_'.$k.'">'.$v['vpsid'].'</td>
								<td id="hostname_'.$k.'" '.(strlen($v['hostname']) >= 20 ? 'tooltip="'.$v['hostname'].'"' : '').'><script>document.write(wordwrapper(20,"'.$v['hostname'].'"))</script>('.$v['vps_name'].')</td>
								'.$tmp.'
								<td>
									<div class="spband" align="center" id="band_'.$k.'">
										'.$v['used_bandwidth'].'/'.(!empty($v['bandwidth']) ? $v['bandwidth'] - $v['used_bandwidth'] : '<i class="fas fa-infinity"></i>').'
									</div>
								</td>
								<td align="center" id="netin_'.$k.'">'.byte_convert($v['net_in'], 2).'</td>
								<td align="center" id="netout_'.$k.'">'.byte_convert($v['net_out'], 2).'</td>
								<td align="center" id="io_read_'.$k.'">'.byte_convert($v['io_read'], 2).'</td>
								<td align="center" id="io_write_'.$k.'">'.byte_convert($v['io_write'], 2).'</td>
								'.$speedCap.'
								<td align="center"><span onclick="show_graph('.$v['vpsid'].')"><i class="fas fa-chart-bar fa-2x p-1 cursor-pointer"></i></span></td>
							</tr>';  
			
		}
		
		// Handle Server Ram 
		foreach($pie_data['server_ram'] as $k => $v){
			
			if($k == 0 && !empty($v['used_ram'])){
				$pie_hex_color[] = '#' . str_pad(dechex(rand(0x000000, 0xFFFFFF)), 6, 0, STR_PAD_LEFT);
				$values_ram[$k] = '{"label" : "Server '.__('Free').'&nbsp;'.__('RAM').'", data: '.($v['ram'] - $v['used_ram']).'}';
				$pie_ram[$k] = $v['ram'] - $v['used_ram'];
			// DOM-0 RAM for XEN and XCP	
			}elseif($k == -1 && !empty($v['used_ram'])){
				$values_ram[$k] = '{"label" : "Dom0 '.__('Used').'&nbsp;'.__('RAM').'", data: '.$v['used_ram'].'}';
				$values_ram[-2] = '{"label" : "Dom0 '.__('Free').'&nbsp;'.__('RAM').'", data: '.($v['ram'] - $v['used_ram']).'}';
				$pie_ram[$k] = $v['used_ram'];
				$pie_ram[-2] = $v['ram'] - $v['used_ram'];
			}
			if($v["ram"] > 0){
				$pie_ram[$k] = $v['ram'];
			}
		}
		
		// Handle Server CPU
		if(!empty($pie_data['server_cpu'])){
			
			// The actual CPU % free on main node retuned from server stats
			$values_cpu['Server'] = '{"label" : "Server '.__('Free').'", data: '.$pie_data['server_cpu']['percent_free'].'}';
			$pie_hex_color[] = '#' . str_pad(dechex(rand(0x000000, 0xFFFFFF)), 6, 0, STR_PAD_LEFT);
			$pie_cpu['Server'] = $pie_data['server_cpu']['percent_free'];
			// There is a possibility of total CPU % of all VPSs being greater than the actual CPU used % of the server
			if($total_cpu < $pie_data['server_cpu']['percent']){
				// CPU % utlized by the server itself apart from the VPSs
				$values_cpu['Server'] = '{"label" : "Server '.__('Used').'", data: '.($pie_data['server_cpu']['percent'] - $total_cpu).'}';
				$pie_cpu['Server'] = $pie_data['server_cpu']['percent'] - $total_cpu;
			}
			
		}
		
		// Handle Server Bandwidth
		if(!empty($pie_data['server_bandwidth'])){
			
			$pie_hex_color[] = '#' . str_pad(dechex(rand(0x000000, 0xFFFFFF)), 6, 0, STR_PAD_LEFT);
			$values_bandwidth[0] = '{"label" : "Server '.__('Used').'", data: '.$pie_data['server_bandwidth']['used_gb'].'}';
			$pie_bandwidth['Server'] = $pie_data['server_bandwidth']['used_gb'];
			$free = 0; // Server Free GB
			// Show Free bandwidth if there is any
			if($pie_data['server_bandwidth']['limit_gb'] > ($total_band + $pie_data['server_bandwidth']['used_gb'])){
				$free = $pie_data['server_bandwidth']['limit_gb'] - ($total_band + $pie_data['server_bandwidth']['used_gb']);
				$values_bandwidth[-1] = '{"label" : "Server '.__('Free').'", data: '.$free.'}';
				$pie_bandwidth[-1] = $free;
			}
		}
		$j_pie_data = json_encode(array_keys($pie_cpu));
		$j_pie_cpu = json_encode(array_values($pie_cpu));
		$j_pie_ram = json_encode(array_values($pie_ram));
		$j_pie_bandwidth = json_encode(array_values($pie_bandwidth));
		$j_pie_hex_color = json_encode(array_values($pie_hex_color));
		echo '<style type="text/css">
		
		.spcpu, .spram, .spdisk, .spinode, .spband {
			margin-bottom: 4px;
		}
		
		.small_txt {
			font-size: 11px;
		}
		
		</style>
		<script language="javascript" type="text/javascript">
		
		//Assign a global variable to remember the vpsid when page loads
		vpsid = 0;
		
		var monthFullNames = ["'.__J('January').'", "'.__J('February').'", "'.__J('March').'", "'.__J('April').'", "'.__J('May').'", "'.__J('June').'", "'.__J('July').'", "'.__J('August').'", "'.__J('September').'", "'.__J('October').'", "'.__J('November').'", "'.__J('December').'" ];
		
		// Show the data for bandwidth, CPU, RAM
		function plot_pie(id, data){
			
			var plot = $.plot(id, data,{
				series: {
					pie: { 
						show: true,
						radius: 3/4,
						label: {
							show: false
						},
						stroke: { 
							width: 0.1,
							color: "#408080"
						}
					}
				},
				grid: {
					hoverable: true,
					clickable: true
				},
				legend: {
					show: false
				}
			});
			
			id.bind("plothover", pieHover);
		}

		var previousPoint = null;
		function pieHover(event, pos, obj){
			
			if (!obj){
				$("#tooltip").remove();
				previousPoint = null;
				return;
			}
			
			if (previousPoint != obj.seriesIndex) {
				previousPoint = obj.seriesIndex;
				$("#tooltip").remove();
			
				var tmp = ""+obj.series.data;
				var ram = tmp.split(",");
				
				var idOfPie = event.target.getAttribute(\'id\');
				idOfPie = idOfPie.split("_");
				var pieChartName = "";
				var pieChartSign = "";
				
				if(idOfPie[1] == "cpu"){
					pieChartName = "CPU";
					pieChartSign = "%";

				}else if(idOfPie[1] == "ram"){
					pieChartName = "RAM";
					pieChartSign = "MB";
					
				}else if(idOfPie[1] == "bandwidth"){
					pieChartName = "Bandwidth";
					pieChartSign = "GB";
				}
				
				showTooltip(pos.pageX, pos.pageY, obj.series.label+"<br /> "+pieChartName+" : "+ram[1]+" "+pieChartSign);		
			}		
		}
			
		function show_graph(id){
			
			vpsid = id;
			//CPU as default window
			change_monitor_tabs("cpuinfo");
			var dialogTitle = \'<i class="fas fa-chart-bar"></i>&nbsp;&nbsp; <h5 class="m-0"> VPSID \'+id+\' </h5> &nbsp;&nbsp;<span id="img_loading"></span>\';
			
			$("#dialog-header").html(dialogTitle+"<button type=\"button\" class=\"close text-always-white\" data-dismiss=\"modal\">×</button>");
			$("#dialog").modal();
			
			
			
			//Display loading image
			$("#img_loading").html("<div class=\"loader\"></div>");
			
			$.post("'.$globals['index'].'act=vps_stats&jsnohf=1&api=json&svs="+id+"", function(data){
					data = JSON.parse(data);
					
					if(data.vps_stats){
						show_monthly_graph(data.vps_stats, data.month);
					}else{
						var req_month = parseInt(data.month.current_month.toString().substring(4));
						$("#note_box").css("display","block");
						$("#for_month").html(monthFullNames[req_month - 1]);
					}
					$("#img_loading").html("");
			});
		};	
			
		// Show monthly graph
		function show_monthly_graph(monthly_data, month){
			
			if(monthly_data){
				
				$("#note_box").css("display","none");
			
				var cpu_data = new Array();
				var inode_data = new Array();
				var ram_data = new Array();
				var disk_data = new Array();
				var ntw_in_data = new Array();
				var ntw_out_data = new Array();
				var ntw_total_data = new Array();
				var io_read_data = new Array();
				var io_write_data = new Array();

				if(monthly_data){
				
					$.each(monthly_data,function(key,val){
						
						//Array is in format [0:vpsid, 1:time, 2:status, 3:disk, 4:inode, 5:ram,  6:cpu, 7:actual_cpu, 8:net_in, 9:net_out]
					
						cpu_data.push([parseInt(val[1]) * 1000, parseFloat(val[7])]);

						inode_data.push([val[1] * 1000, val[4]]);
							
						ram_data.push([val[1] * 1000, val[5]]);	
						
						disk_data.push([val[1] * 1000, (val[3]/1024)]);
						
						ntw_in_data.push([val[1] * 1000, val[8]]);
						
						ntw_out_data.push([val[1] * 1000, val[9]]);
						
						ntw_total_data.push([val[1] * 1000, parseInt(val[8]) + parseInt(val[9])]);

						io_read_data.push([val[1] * 1000, val[10]]);

						io_write_data.push([val[1] * 1000, val[11]]);
					});
				
				}

				var ntw_graph = [
						{ name: "'.__J('Download Speed').'",  data: ntw_in_data, color: "#0077FF"},
						{ name: "'.__J('Upload Speed').'",  data: ntw_out_data , color: "#0000A0"},
						{ name: "'.__J('Total Speed').'",  data: ntw_total_data}
					];

				var cpuoptions = {
					chart: {
						type: "area",
						stacked: false,
						width: "100%",
						height: 380
					},
					xaxis:{
						stepSize: 2,
						type: "datetime",
					},
					yaxis: {
						stepSize: 1,
					},
					dataLabels: {
						enabled: false
					},
					colors: ["#515DBC"], 
					title: {
						text: "CPU UTILIZATION",
							style: {
								color: "#FF1654"
							}
					},
					series: [
						{
							name: "CPU Utilized",
							data: cpu_data,
							color: "#515DBC",
							fill: {
								type: "gradient",
								gradient: {
									shade: "light",
									type: "vertical",
									shadeIntensity: 1,
									gradientToColors: ["#515DBC"],
									opacityFrom: 0.4,
									opacityTo: 0.1,
									stops: [0, 100]
								}
							}
						}
					],
					stroke: {
						width: [2, 1], 
						curve: "straight" 
					}, 
					legend: {
						horizontalAlign: "left",
						offsetX: 40
					},
					tooltip:{
						x: {
							format: "dd MMM yyyy HH:mm:ss"  
						}
					} 
				};
				
				var ramoptions = {
					chart: {
						type: "area",
						stacked: false,
						width: "100%",
						height: 380

					},
					stroke: {
						width: 2, 
						curve: "smooth" 
					}, 
					xaxis:{
						stepSize: 2,
						type: "datetime",
					},
					yaxis: {
						stepSize: 1,
					},
					dataLabels: {
						enabled: false
					},
					colors: ["#515DBC"], 
					title: {
						text: "RAM UTILIZATION",
							style: {
								color: "#FF1654"
							}
					},
					series: [
						{
							name: "RAM UTITLIZED",
							data: ram_data,
							color: "#FF00FF",
							fill: {
								type: "gradient",
								gradient: {
									shade: "light",
									type: "vertical",
									shadeIntensity: 1,
									gradientToColors: ["#FF00FF"],
									opacityFrom: 0.4,
									opacityTo: 0.1,
									stops: [0, 100]
								}
							}
						}
					],
					stroke: {
						width: [2, 1], 
						curve: "straight" 
					}, 
					legend: {
						horizontalAlign: "left",
						offsetX: 40
					},
					tooltip:{
						x: {
							format: "dd MMM yyyy HH:mm:ss"  
						}
					} 
				};

				var diskoptions = {
					chart: {
						type: "area",
						stacked: false,
						width: "100%",
						height: 380
					},
					stroke: {
						width: 2, 
						curve: "smooth" 
					}, 
					xaxis:{
						stepSize: 2,
						type: "datetime",
					},
					yaxis: {
						stepSize: 1,
						labels: {
							formatter: function (value) {
									return (value).toFixed(2) + " GB"; 
							}
						}
					},
					dataLabels: {
						enabled: false
					},
					colors: ["#515DBC"], 
					title: {
						text: "DISK UTILIZATION",
							style: {
								color: "#FF1654"
							}
					},
					series: [
						{
							name: "DISK UTITLIZED",
							data: disk_data,
							color: "#FFA500",
							fill: {
								type: "gradient",
								gradient: {
									shade: "light",
									type: "vertical",
									shadeIntensity: 1,
									gradientToColors: ["#FFA500"],
									opacityFrom: 0.4,
									opacityTo: 0.1,
									stops: [0, 100]
								}
							}
						}
					],
					stroke: {
						width: [2, 1], 
						curve: "straight" 
					}, 
					legend: {
						horizontalAlign: "left",
						offsetX: 40
					},
					tooltip:{
						x: {
							format: "dd MMM yyyy HH:mm:ss"  
						}
					} 
				};

				var inodeoptions = {
					chart: {
						type: "area",
						stacked: false,
						width: "100%",
						height: 380
					},
					stroke: {
						width: 2, 
						curve: "smooth" 
					}, 
					xaxis:{
						stepSize: 2,
						type: "datetime",
					},
					yaxis: {
						stepSize: 1,
					},
					dataLabels: {
						enabled: false
					},
					colors: ["#515DBC"], 
					title: {
						text: "INODE",
							style: {
								color: "#FF1654"
							}
					},
					series: [
						{
							name: "Inode",
							data: inode_data,
							color: "#11E19D",
							fill: {
								type: "gradient",
								gradient: {
									shade: "light",
									type: "vertical",
									shadeIntensity: 1,
									gradientToColors: ["#11E19D"],
									opacityFrom: 0.4,
									opacityTo: 0.1,
									stops: [0, 100]
								}
							}
						}
					],
					legend: {
						horizontalAlign: "left",
						offsetX: 40
					},
					tooltip:{
						x: {
							format: "dd MMM yyyy HH:mm:ss"  
						}
					} 
				};

				var ioreadoptions = {
					chart: {
						type: "area",
						stacked: false,
						width: "100%",
						height: 380
					},
					stroke: {
						width: 2, 
						curve: "smooth" 
					}, 
					xaxis:{
						stepSize: 2,
						type: "datetime",
					},
					yaxis: {
						labels: {
							formatter: function(val){
								if(val >= 1024 && parseInt(val/1024) < 1024){
									return parseFloat(val / 1024).toFixed(1) + " KB/s";
								}else if(parseInt(val/1024) >= 1024){
									return (val / 1024 /1024).toFixed(1) + " MB/s";
								}else{
									return val + " B/s";
								}
							}
						}
					},		
					dataLabels: {
						enabled: false
					},
					colors: ["#515DBC"], 
					title: {
						text: "INODE",
							style: {
								color: "#FF1654"
							}
					},
					series: [
						{
							name: "I/O Read Speed",
							data: io_read_data,
							color: "#515DBC",
							fill: {
								type: "gradient",
								gradient: {
									shade: "light",
									type: "vertical",
									shadeIntensity: 1,
									gradientToColors: ["#515DBC"],
									opacityFrom: 0.4,
									opacityTo: 0.1,
									stops: [0, 100]
								}
							}
						}
					],
					legend: {
						horizontalAlign: "left",
						offsetX: 40
					},
					tooltip:{
						x: {
							format: "dd MMM yyyy HH:mm:ss"  
						}
					} 
				};

				var iowriteoptions = {
					chart: {
						type: "area",
						stacked: false,
						width: "100%",
						height: 380
					},
					stroke: {
						width: 2, 
						curve: "smooth" 
					}, 
					xaxis:{
						stepSize: 2,
						type: "datetime",
					},
					yaxis: {
						labels: {
							formatter: function(val){
								if(val >= 1024 && parseInt(val/1024) < 1024){
									return parseFloat(val / 1024).toFixed(1) + " KB/s";
								}else if(parseInt(val/1024) >= 1024){
									return (val / 1024 /1024).toFixed(1) + " MB/s";
								}else{
									return val + " B/s";
								}
							}
						}
					},		
					dataLabels: {
						enabled: false
					},
					colors: ["#515DBC"], 
					title: {
						text: "I/O Write Speed",
							style: {
								color: "#FF1654"
							}
					},
					series: [
						{
							name: "I/O Write Speed",
							data: io_write_data,
							color: "#39FF14",
							fill: {
								type: "gradient",
								gradient: {
								shade: "light",
								type: "vertical",
								shadeIntensity: 1,
								gradientToColors: ["#39FF14"],
								opacityFrom: 0.4,
								opacityTo: 0.1,
								stops: [0, 100]
								}
							}
						}
					],
					legend: {
						horizontalAlign: "left",
						offsetX: 40
					},
					tooltip:{
						x: {
							format: "dd MMM yyyy HH:mm:ss"  
						}
					} 
				};
				
				var ntwoptions = {
					chart: {
						type: "area",
						stacked: false,
						width: "100%",
						height: 380
					},
					stroke: {
						width: 1, 
						curve: "smooth" 
					}, 
					xaxis:{
						stepSize: 2,
						type: "datetime",
					},
					yaxis: {
						labels: {
							formatter: function(val){
								if(val >= 1024 && parseInt(val/1024) < 1024){
									return parseFloat(val / 1024).toFixed(1) + " MB/s";
								}else if(parseInt(val/1024) >= 1024){
									return (val / 1024 /1024).toFixed(1) + " GB/s";
								}else{
									return val + " KB/s";
								}
							}
						}
					},		
					dataLabels: {
						enabled: false
					},
					colors : ["#FDC046", "#FE8F4D", "#E60C8D"],
					series: ntw_graph,
					legend: {
						horizontalAlign: "left",
						offsetX: 40,
						position: "top"
					},
					tooltip:{
						x: {
							format: "dd MMM yyyy HH:mm:ss"  
						}
					} 
				};
				
				document.getElementById("cpu_plot").innerHTML = "";
				document.getElementById("ram_plot").innerHTML = "";
				document.getElementById("disk_plot").innerHTML = "";
				document.getElementById("inode_plot").innerHTML = "";
				document.getElementById("io_read_plot").innerHTML = "";
				document.getElementById("io_write_plot").innerHTML = "";
				document.getElementById("ntw").innerHTML = "";

				var cpuchart = new ApexCharts(document.querySelector("#cpu_plot"), cpuoptions);
				var ramchart = new ApexCharts(document.querySelector("#ram_plot"), ramoptions);
				var diskchart = new ApexCharts(document.querySelector("#disk_plot"), diskoptions);
				var inodechart = new ApexCharts(document.querySelector("#inode_plot"), inodeoptions);
				var ioreadchart = new ApexCharts(document.querySelector("#io_read_plot"), ioreadoptions);
				var iowritechart = new ApexCharts(document.querySelector("#io_write_plot"), iowriteoptions);
				var ntwchart = new ApexCharts(document.querySelector("#ntw"), ntwoptions);

				ramchart.render();
				cpuchart.render();
				diskchart.render();
				inodechart.render();
				ioreadchart.render();
				iowritechart.render();
				ntwchart.render();
				
				var monthNames = ["'.__J('Jan').'", "'.__J('Feb').'", "'.__J('Mar').'", "'.__J('Apr').'", "'.__J('May').'", "'.__J('Jun').'", "'.__J('Jul').'", "'.__J('Aug').'", "'.__J('Sep').'", "'.__J('Oct').'", "'.__J('Nov').'", "'.__J('Dec').'" ];
				
				var current_year = month.current_month.substring(0,4);
				var current_month = parseInt(month.current_month.substring(4));
				$("#month_holder2").html(monthNames[current_month - 1] +" "+ current_year);
				$("#next_month").html(\'<input type="button" class="btn w-50" onclick="search_result(\'+ month.next_month +\')" value="'.__J('Next Month').'" />\');
				$("#prev_month").html(\'<input type="button" class="btn w-50" onclick="search_result(\'+ month.prev_month +\')" value="'.__J('Prev Month').'" />\');
						
			}else{
				$("#note_box").css("display","block");
			}
		}
		
		function search_result(mon){
			
			//Display loading image
			$("#img_loading").html("<div class=\"loader\"></div>");
			$.post("'.$globals['index'].'act=vps_stats&jsnohf=1&api=json&svs="+ vpsid +"&show=" + mon +"", function(data){
				data = JSON.parse(data);
				if(data.vps_stats){
					show_monthly_graph(data.vps_stats, data.month);
				}else{
					var req_month = parseInt(mon.toString().substring(4));
					$("#note_box").css("display","block");
					$("#for_month").html(monthFullNames[req_month - 1]);
				}
				$("#img_loading").html("");
			}); 
			
		};
			
		function change_monitor_tabs(id){
			$("#cpuinfo_win, #raminfo_win, #diskinfo_win, #ntwinfo_win, #ioinfo_win").hide();
			$("#"+id+"_win").show();
		};
		
	$(document).ready(function(){

		function loadvpsstats(){

			var cpu_xvalues = JSON.parse(\''.$j_pie_cpu.'\');
			var cpu_yvalues = JSON.parse(\''.$j_pie_data.'\');
			var cpu_hex = JSON.parse(\''.$j_pie_hex_color.'\');
			var ram_xvalues = JSON.parse(\''.$j_pie_ram.'\');
			var bw_xvalues = JSON.parse(\''.$j_pie_bandwidth.'\');
			var tot_ram =  ram_xvalues.at(-1);		
			ram_xvalues.pop();

			var ram_used = ram_xvalues.map(value => value).reduce((total, value) => total + value, 0);
			var ram_free = parseFloat((tot_ram - ram_used).toFixed(2)) ;
			ram_xvalues.push(ram_free);

			var cpu_xvalues = convertToPercentages(cpu_xvalues);

			var cpu_options = {
				chart: {
					"type": "pie"
				},
				series: cpu_xvalues,
				labels: cpu_yvalues,
				colors: cpu_hex,
			};
			
			var ram_options = {
				chart: {
					"type": "pie"
				},
				series: ram_xvalues,
				labels: cpu_yvalues,
				colors: cpu_hex,
				tooltip: {
					enabled: true,
					y: {
						formatter: function(val) {
							return (val/1024).toFixed(2) + " GB";
						}
					}
				}
			};
			
			var bw_options = {
				chart: {
					"type": "pie"
				},
				series: bw_xvalues,
				labels: cpu_yvalues,
				colors: cpu_hex,
				tooltip: {
					enabled: true,
					y: {
						formatter: function(val) {
							return val.toFixed(2) + " GB";
						}
					}
				}
			};

			var cpu_graph_object = live_resource_graph2("", "holder_cpu", cpu_options);
			var ram_graph_object = live_resource_graph2("", "holder_ram", ram_options);
			var bw_graph_object = live_resource_graph2("", "holder_bandwidth", bw_options);

			function refresh_stats(){

				$.ajax({
			
					url: window.location.href +"&api=json",
					success: function(resp){

						resp = JSON.parse(resp);
						var total_cpu = 0;
						var total_band = 0;
						var v_ram = [];
						var v_cpu = [];
						var v_bandwidth = [];
						var table_data = "";
						var tmp = "";
						var status_td = "";
						var total_used_ram = 0;

						$.each(resp.vps_data, function(i, t){

							//setting the total cpu here
							total_cpu += parseFloat(t.used_cpu);
							v_cpu.push(parseFloat(t.used_cpu));

							
							var ram = 0;
							ram = parseFloat(t.used_ram);
							total_used_ram +=  ram;
							v_ram.push(ram);

							//
							total_band += parseFloat(t.used_bandwidth);
							v_bandwidth.push(parseFloat(t.used_bandwidth));

			
							if(t.status == 1){
								tmp += "<td align=\"center\" id=\"spcpu_"+i+"\" ><div class=\"spcpu\">"+parseFloat(t.used_cpu)+","+(100 - t.used_cpu)+"</div><div class=\"small_txt\">"+parseFloat(t.used_cpu)+" %</div></td>";
								tmp += ((t.vps_ram_info) ? "<td align=\"center\" id=\"spram_"+i+"\" ><div class=\"spram\">"+parseInt(t.used_ram)+","+(parseInt(t.ram) - parseInt(t.used_ram))+"</div><div class=\"small_txt\">"+parseInt(t.used_ram)+" / "+parseInt(t.ram)+" MB</div></td>" : "<td align=\"center\" id=\"spram_"+i+"\" >N/A</td>");
								tmp += "<td align=\"center\" id=\"spdisk_"+i+"\"><div class=\"spdisk\">"+(t.used_disk)+","+(t.disk - t.used_disk)+"</div><div class=\"small_txt\">"+(t.used_disk.toFixed(2))+" / "+(t.disk)+" GB</div></td>";
								tmp += ((t.inode == "") ? "<td align=\"center\" id=\"spinode_"+i+"\"> N/A </td>" : "<td align=\"center\" id=\"spinode_"+i+"\"><div class=\"spinode\">"+t.used_inode+","+(t.inode - t.used_inode)+"</div><div class=\"small_txt\">"+t.used_inode+" / "+(t.inode)+"</div></td>");
									
								status_td = "<td align=\"center\" id=\"status_"+i+"\"><i class=\"fas fa-circle fa-circle-green\" title=\"'.__J('Online').'\" ></i></td>";
									
							}else if(t.status == 2){
								status_td = "<td align=\"center\" id=\"status_"+i+"\"><i class=\"fas fa-circle fa-circle-gray\" title=\"'.__J('Suspended VPS').'\" ></i></td>";
								tmp += "<td colspan=\"4\" class=\"text-center\" id=\"nodata_"+i+"\">'.__J('No data Available').'</td>";
							}else{
								status_td = "<td align=\"center\" id=\"status_"+i+"\"><i class=\"fas fa-circle fa-circle-red\" title=\"'.__J('Offline').'\" ></i></td>";
								tmp += "<td colspan=\"4\" class=\"text-center\" id=\"nodata_"+i+"\">'.__J('No data Available').'</td>";
							}

						if(t.speed_cap == "0" || t.speed_cap == 0 || t.speed_cap == null){
							speedCap = "<td align=\"center\"><h5 class=\"p-0 m-0\"><a class=\"badge badge-danger\">'.__J('Disabled').'</a></h5></td>";
						}else{
								tmp_data = t.speed_cap.split(",");
								speedCap = "<td align=\"center\">"+tmp_data[1]+" KB <img src=\"'.$theme['images'].'admin/arrow_up.png\" title=\"'.__J('Upload Speed').'\"><br>"+tmp_data[0]+" KB <img src=\"'.$theme['images'].'admin/arrow_down.png\" title=\"'.__J('Download Speed').'\"></td>";
							}
								
							table_data += "<tr>";
							table_data += status_td;
							table_data += "<td id=\"vpsid_"+i+"\">"+t.vpsid+"</td>";
							table_data += "<td id=\"hostname_"+i+"\" tooltip=\""+t.hostname+"\" >"+wordwrapper(20,t.hostname)+" ("+t.vps_name+")</td>";
							table_data += tmp;
							table_data += "<td>";
							table_data += "<div class=\"spband\" align=\"center\" id=\"band_"+i+"\">";
							table_data += t.used_bandwidth+","+((t.bandwidth != "") ? (t.bandwidth - t.used_bandwidth).toFixed(2) : "asas<i class=\'fas fa-infinity\'></i>");
							table_data += "</div>";
							table_data += "<div class=\"small_txt\" align=\"center\" id=\"band2_"+i+"\">";
							table_data += t.used_bandwidth+"/"+((t.bandwidth != "") ? (t.bandwidth - t.used_bandwidth).toFixed(2) : "'.__J('Unlimited').'")+" GB";
							table_data += "</div>";
							table_data += "</td>";
							table_data += "<td align=\"center\" id=\"netin_"+i+"\">"+byte_convert(t.net_in, 2)+"</td>";
							table_data += "<td align=\"center\" id=\"netout_"+i+"\">"+byte_convert(t.net_out, 2)+"</td>";
							table_data += "<td align=\"center\" id=\"io_read_"+i+"\">"+byte_convert(t.io_read, 2)+"</td>";
							table_data += "<td align=\"center\" id=\"io_write_"+i+"\">"+byte_convert(t.io_write, 2)+"</td>";
							table_data += speedCap;
							table_data += "<td align=\"center\"><span onclick=\"show_graph("+t.vpsid+")\"><i class=\"fas fa-chart-bar fa-2x p-1 cursor-pointer\"></i></span></td>";
							table_data += "</tr>";
										
							tmp = "";
						});

						var pie_data = resp.pie_data;

						//Handle CPU
						if(pie_data.server_cpu != ""){
							v_cpu.push(parseFloat((pie_data.server_cpu.percent_free).toFixed(2)));
							
							if(total_cpu < pie_data.server_cpu.percent){
								v_cpu.pop();
								v_cpu.push(parseFloat(((pie_data.server_cpu.percent) - parseFloat(total_cpu)).toFixed(2)));
							}
						}

						v_cpu = convertToPercentages(v_cpu);
						
						update_cpu_option_and_data = {
							series: v_cpu,
						};
						cpu_graph_object = live_resource_graph2(cpu_graph_object, "",{},{},update_cpu_option_and_data);


						var ram2 = pie_data.server_ram;
						// Handle Server Ram
						$.each(pie_data.server_ram, function(i, t){
							if(i == 0 && (total_used_ram != "")){
								v_ram.push(parseFloat((t.ram - total_used_ram).toFixed(2)));
									
							//DOM-0 RAM for XEN and XCP
							}else if(i == -1 && (t.used_ram != "")){
								v_ram.push(parseFloat(t.used_ram));
								v_ram.push((parseFloat(t.ram) - parseFloat(t.used_ram)));
							}
						});

						update_ram_option_and_data = {
							series: v_ram,
						};
						ram_graph_object = live_resource_graph2(ram_graph_object, "",{},{},update_ram_option_and_data);
						

						// Handle Server Bandwidth
						if(pie_data.server_bandwidth != ""){
								
							v_bandwidth.push(parseFloat(pie_data.server_bandwidth.used_gb));
								
							var free = 0; // Server Free GB
							// Show Free bandwidth if there is any
							if(pie_data.server_bandwidth.limit_gb > (total_band + pie_data.server_bandwidth.used_gb)){
								free = parseFloat(pie_data.server_bandwidth.limit_gb) - (total_band + parseFloat(pie_data.server_bandwidth.used_gb));
								v_bandwidth.push(free);
								bw_yvalues.push("Server '.__J('Free').'");
							}
						}

						update_bw_option_and_data = {
							series: v_bandwidth,
						};
						bw_graph_object = live_resource_graph2(bw_graph_object, "",{},{},update_bw_option_and_data);
						v_bandwidth.pop();
			
					}//end of success

				});//end of ajax

				setTimeout(function(){
					refresh_stats();
				}, 30000);

			}; //end of refresh_stats

			refresh_stats();

		}//end of loadserverstats

		loadvpsstats();
	
	}); //end of document.ready
		
		function byte_convert(bytes, round_upto = 0){
				
			// Is it in TBs
			if(bytes > (1024*1024*1024*1024)){
				return Math.round(bytes / (1024*1024*1024*1024), round_upto)+" TB";
			}
				
			// Is it in GBs
			if(bytes > (1024*1024*1024)){
				return Math.round(bytes / (1024*1024*1024), round_upto)+" GB";
			}
				
			// Is it in MBs
			if(bytes > (1024*1024)){
				return Math.round(bytes / (1024*1024), round_upto)+" MB";
			}
				
			// Is it in KBs
			if(bytes > 1024 && bytes < (1024*1024)){
				return Math.round(bytes /1024, round_upto)+" KB";
			}
				
			// Is it in GBs
			if(bytes <= 1024){
				return Math.round(bytes, round_upto)+" B";
			}
		}
		</script>
		<style>
		th{
			width:auto !important; padding:5px 5px !important;
			background:#eeeef0;
			vertical-align:middle !important;
		}
		</style>';
		echo page_header(__('Statistics'), 'fas fa-chart-area' );

		$breadcrumbs = ['dashboard', 'lms_vps_stats'];

		echo get_breadcrumb($breadcrumbs);

		echo '
			<div class="card p-4 mx-3 mb-3">
		<div class="row mx-auto w-100"><div class="col-sm-4"></div><div class="col-sm-4">';
		server_select();
		echo '</div></div>
		<div class="row mx-auto w-100 my-3">
				<div class="col-sm-4">
					<div class="mx-auto d-flex justify-content-center">
						<div id="holder_cpu" align="center" style="width:430px; height: 200px"></div>
					</div>
					<div class="mx-auto d-flex justify-content-center">
						<span class="p-2 h5">'.__('CPU Utilization').'</span>
					</div>	
				</div>	
				<div class="col-sm-4">
					<div class="mx-auto d-flex justify-content-center">
						<div id="holder_ram" align="center" style="width:430px; height: 200px"></div>
					</div>	
					<div class="mx-auto d-flex justify-content-center">
						<span class="p-2 h5">'.__('RAM Utilization').'</span>
					</div>	
				</div>	
				<div class="col-sm-4">
					<div class="mx-auto d-flex justify-content-center">
						<div id="holder_bandwidth" align="center" style="width:450px; height: 200px"></div>
					</div>	
					<div class="mx-auto d-flex justify-content-center">
						<span class="p-2 h5">'.__('Bandwidth Utilization').'</span>
					</div>	
				</div>
		</div><br/>
		<div class="notice" align="left"><b>'.__('Note').' : </b> &nbsp; '.__('CPU % shown for OpenVZ VPS(s) is the CPU % utilized inside the VPS, for KVM it is as reported by virt-top, for XEN and XCP it is as reported by xentop').'</div>
		<br /> 
		<div class="row mx-auto w-100">
			<div class="col-sm-12 col-lg-12 col-md-6 mb-3 p-0">';
				page_links($globals['num_res'], $globals['cur_page'], $globals['reslen']);
			echo'
			</div>
		</div>
			<div class="scrollbar-virt task_table">
				<table class="table table-hover tablesorter tasks_table" id="servers_list_table">
				<thead>
						<tr>
							<th >'.__('Status').'</th>
							<th >'.getSortHeader(__('VPS ID'), $sort_column, $sort_column_by, 'vpsid','55').'</th>
							<th >'.__('Hostname').' (VID)</th>
							<th >'.getSortHeader(__('CPU'), $sort_column, $sort_column_by, 'cpu','40').'</th>
							<th >'.getSortHeader(__('RAM'), $sort_column, $sort_column_by, 'ram','40').'</th>
							<th >'.getSortHeader(__('Disk'), $sort_column, $sort_column_by, 'disk','40').'</th>
							<th >'.getSortHeader(__('Inode'), $sort_column, $sort_column_by, 'inode','55').'</th>
							<th >'.getSortHeader(__('Bandwidth'), $sort_column, $sort_column_by, 'bandwidth','80').'</th>
							<th >'.getSortHeader(__('Download'), $sort_column, $sort_column_by, 'net_in','80').'</th>
							<th >'.getSortHeader(__('Upload'), $sort_column, $sort_column_by, 'net_out','65').'</th>
							<th >'.getSortHeader(__('I/O Read'), $sort_column, $sort_column_by, 'io_read','70').'</th>
							<th >'.getSortHeader(__('I/O Write'), $sort_column, $sort_column_by, 'io_write','70').'</th>
							<th >'.getSortHeader(__('Speed Cap'), $sort_column, $sort_column_by, 'speed_cap').'</th>
							<th ></th>
						</tr>
					</thead>
					'.$table_data.'
				</table>
			</div>
			<div class="row mx-auto w-100 mt-5">
				<div class="col-sm-12 col-lg-12 col-md-6 mb-3 p-0">';
					page_links($globals['num_res'], $globals['cur_page'], $globals['reslen']);
				echo'
			</div>
		</div>
	</div>'; // bg div End
		
	// Modal html for Individual VPS
	echo '<div id="dialog" style="display:none" class="modal fade">
	<div class="modal-dialog modal-lg">
		<div class="modal-content">
			<div class="modal-header align-items-center" id="dialog-header"></div>
			<div class="modal-body">
				<div class="card m-3 p-3">
					<div class="row mx-auto w-100 my-3">
						<div class="col-sm-1"></div>
						<div class="col-sm-2 text-center">
							<a href="javascript:void(0);" class="tab pan-button" id="cpuinfo" onclick="change_monitor_tabs(this.id);">
								<svg xmlns="http://www.w3.org/2000/svg" viewBox="-1,-3,22,28" width="60" height="60" fill="currentColor">
									<path d="M6 3h8a3 3 0 0 1 3 3v8a3 3 0 0 1-3 3H6a3 3 0 0 1-3-3V6a3 3 0 0 1 3-3zm0 2a1 1 0 0 0-1 1v8a1 1 0 0 0 1 1h8a1 1 0 0 0 1-1V6a1 1 0 0 0-1-1H6zm2 2h4a1 1 0 0 1 1 1v4a1 1 0 0 1-1 1H8a1 1 0 0 1-1-1V8a1 1 0 0 1 1-1zm1 2v2h2V9H9zM6 0a1 1 0 0 1 1 1v2a1 1 0 1 1-2 0V1a1 1 0 0 1 1-1zM1 5h2a1 1 0 1 1 0 2H1a1 1 0 1 1 0-2zm16 0h2a1 1 0 0 1 0 2h-2a1 1 0 0 1 0-2zM1 9h2a1 1 0 1 1 0 2H1a1 1 0 0 1 0-2zm16 0h2a1 1 0 0 1 0 2h-2a1 1 0 0 1 0-2zM1 13h2a1 1 0 0 1 0 2H1a1 1 0 0 1 0-2zm16 0h2a1 1 0 0 1 0 2h-2a1 1 0 0 1 0-2zM6 16a1 1 0 0 1 1 1v2a1 1 0 0 1-2 0v-2a1 1 0 0 1 1-1zm8-16a1 1 0 0 1 1 1v2a1 1 0 0 1-2 0V1a1 1 0 0 1 1-1zm0 16a1 1 0 0 1 1 1v2a1 1 0 0 1-2 0v-2a1 1 0 0 1 1-1zM10 0a1 1 0 0 1 1 1v2a1 1 0 0 1-2 0V1a1 1 0 0 1 1-1zm0 16a1 1 0 0 1 1 1v2a1 1 0 0 1-2 0v-2a1 1 0 0 1 1-1z"></path>
								</svg>
							</a>
							<label for="input text" class="help-block">'.__('CPU').'</label>
						</div>
						<div class="col-sm-2 text-center">
							<a href="javascript:void(0);" class="tab pan-button" id="raminfo" onclick="change_monitor_tabs(this.id);">
								<svg xmlns="http://www.w3.org/2000/svg" viewBox="-1,-3,22,28" width="60" height="60" fill="currentColor">
									<path d="m14.95 7.879-.707-.707a1 1 0 0 1 1.414-1.415l.707.707 1.414-1.414-2.828-2.828L2.222 14.95l2.828 2.828 1.414-1.414L5.05 14.95a1 1 0 0 1 1.414-1.414L7.88 14.95l1.414-1.414-.707-.708A1 1 0 0 1 10 11.414l.707.707 1.414-1.414-1.414-1.414a1 1 0 0 1 1.414-1.414l1.415 1.414 1.414-1.414zM.808 13.536 13.536.808a2 2 0 0 1 2.828 0l2.828 2.828a2 2 0 0 1 0 2.828L6.464 19.192a2 2 0 0 1-2.828 0L.808 16.364a2 2 0 0 1 0-2.828z"></path>
								</svg>
							</a>
							<label for="input text" class="help-block">'.__('RAM').'</label>
						</div>
						<div class="col-sm-2 text-center">
							<a href="javascript:void(0);" class="tab pan-button" id="diskinfo" onclick="change_monitor_tabs(this.id);">
							<svg xmlns="http://www.w3.org/2000/svg" viewBox="-1,-3,22,28" width="60" height="60" fill="currentColor">
								<path d="M10 20C4.477 20 0 15.523 0 10S4.477 0 10 0s10 4.477 10 10-4.477 10-10 10zm0-2a8 8 0 1 0 0-16 8 8 0 0 0 0 16zm7-8a6.99 6.99 0 0 1-2.89 5.666l-.53-.796L13 14a4.992 4.992 0 0 0 2-4 4.992 4.992 0 0 0-2-4l1.2-1.6A6.99 6.99 0 0 1 17 10zm-7 3a3 3 0 1 1 0-6 3 3 0 0 1 0 6zm0-2a1 1 0 1 0 0-2 1 1 0 0 0 0 2z"/>
							</svg>
							</a>
							<label for="input text" class="help-block">'.__('Disk').'/'.__('Inode').'</label>
						</div>
						<div class="col-sm-2 text-center">
							<a href="javascript:void(0);" class="tab pan-button" id="ioinfo" onclick="change_monitor_tabs(this.id);">
							
							<svg xmlns="http://www.w3.org/2000/svg" viewBox="-1,-3,22,28" width="60" height="60" fill="currentColor">
							<path d="M.832 14A9.966 9.966 0 0 1 0 10C0 4.477 4.477 0 10 0s10 4.477 10 10a9.966 9.966 0 0 1-.832 4H.832zm16.916-2a8 8 0 1 0-15.497 0h15.497zM10 5a1 1 0 1 1 0-2 1 1 0 0 1 0 2zM5 9a1 1 0 1 1 0-2 1 1 0 0 1 0 2zm10 0a1 1 0 1 1 0-2 1 1 0 0 1 0 2zm-5-3a1 1 0 0 1 1 1v3a1 1 0 0 1-2 0V7a1 1 0 0 1 1-1z"/>
							</svg>
							</a>
							<label for="input text" class="help-block">'.__('Disk I/O').'</label>
						</div>
						<div class="col-sm-2 text-center">
							<a href="javascript:void(0);" class="tab pan-button" id="ntwinfo" onclick="change_monitor_tabs(this.id);">
							<svg xmlns="http://www.w3.org/2000/svg" viewBox="-1,-3,22,28" width="60" height="60" fill="currentColor">
							<path d="M10 13.992a1 1 0 1 1 0-2 1 1 0 0 1 0 2zM7.894 11.44a1 1 0 0 1-1.788-.894 4.355 4.355 0 0 1 7.788 0 1 1 0 1 1-1.788.894 2.353 2.353 0 0 0-4.212 0zM4.8 8.595a1 1 0 0 1-1.6-1.2 8.503 8.503 0 0 1 13.6 0 .999.999 0 1 1-1.6 1.2 6.503 6.503 0 0 0-10.4 0zm-3.057-2.93A1 1 0 0 1 .257 4.329c4.843-5.377 13.13-5.813 18.512-.973.342.307.667.632.974.973a.999.999 0 1 1-1.486 1.338 10.91 10.91 0 0 0-.826-.826C12.871.74 5.847 1.108 1.743 5.666z"/>
							</svg>
							</a>
							<label for="input text" class="help-block">'.__('Network Speed').'</label>
						</div>
					</div>

					<div class="row mx-auto w-100 my-3" id="by_month">
						<div id="prev_month" class="col-sm-4 "></div>
						<div id="month_holder2" class="col-sm-4 h5 m-0 text-center"></div>
						<div id="next_month" class="col-sm-4 d-flex justify-content-end"></div>	
					</div><br/>
					
					<div class="row mx-auto w-100 my-3">
						<div class="col-sm-12">
							<div class="notice" id="note_box" style="display: none;">
								<b>NOTE : </b>&nbsp; '.__('No data Available').'&nbsp;'.__('For').'&nbsp;<span id="for_month"></span>
							</div>
						</div>
					</div>
					<div class="row mx-auto w-100 my-3" id="cpuinfo_win">
						<div class="col-sm-12">
							<div id="legend_cpu" class="legend_container"></div>
							<div id="cpu_plot">
							</div>
						</div>
					</div>
					
					<div id="raminfo_win" style="display:none" class="row mx-auto w-100 my-3">
						<div class="col-sm-12">
							<div id="legend_ram" class="legend_container"></div>
							<div id="ram_plot">
							</div>
						</div>
					</div>
					
					<div class="row mx-auto w-100 my-3" id="diskinfo_win" style="display:none">
						<div class="row mx-auto w-100 my-3">
							<div class="col-sm-12">
								<div id="legend_disk" class="legend_container"></div>
								<div id="disk_plot">
								</div>
							</div>
						</div>	
						<div class="row mx-auto w-100 my-3">
							<div class="col-sm-12" >
								<div id="legend_inode" class="legend_container"></div>
								<div id="inode_plot">
								</div>
							</div>
						</div>	
					</div>
					
					<div id="ioinfo_win" style="display:none;" class="form-group">
						<div class="col-sm-12">
							<div id="legend_io_read" class="legend_container"></div>
							<div id="io_read_plot">
							</div>
						</div>
						<div class="col-sm-12">
							<div id="legend_io_write" class="legend_container"></div>
							<div id="io_write_plot">
							</div>
						</div>
					</div>
					
					<div id="ntwinfo_win" style="display:none;" class="row mx-auto w-100 my-3">
						<div class="col-sm-12">
							<div id="legend_ntw" class="legend_container"></div>
							<div id="ntw">
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>	
</div>';
	}
	
	softfooter();
}

//Function to convert given Bytes to KB, MB, GB or TB
function byte_convert($bytes, $round_upto = 0){
	
	// Is it in TBs
	if($bytes > (1024*1024*1024*1024)){
		return round($bytes / (1024*1024*1024*1024), $round_upto)." TB";
	}
	
	// Is it in GBs
	if($bytes > (1024*1024*1024)){
		return round($bytes / (1024*1024*1024), $round_upto)." GB";
	}
	
	// Is it in MBs
	if($bytes > (1024*1024)){
		return round($bytes / (1024*1024), $round_upto)." MB";
	}
	
	// Is it in KBs
	if($bytes > 1024 && $bytes < (1024*1024)){
		return round($bytes /1024, $round_upto)." KB";
	}
	
	// Is it in GBs
	if($bytes <= 1024){
		return round($bytes, $round_upto)." B";
	}
}
	
?>