<?php 

//////////////////////////////////////////////////////////////
//===========================================================
// smart_devices_theme.php
//===========================================================
// SOFTACULOUS VIRTUALIZOR
// Version : 1.0
// Inspired by the DESIRE to be the BEST OF ALL
// ----------------------------------------------------------
// Started by: Alons
// Date:	   8th Mar 2010
// Time:	   23:00 hrs
// Site:	   https://www.virtualizor.com/ (SOFTACULOUS VIRTUALIZOR)
// ----------------------------------------------------------
// Please Read the Terms of use at https://www.virtualizor.com
// ----------------------------------------------------------
//===========================================================
// (c)Softaculous Ltd.
//===========================================================
//////////////////////////////////////////////////////////////

if(!defined('VIRTUALIZOR')){
	die('Hacking Attempt');
}

function smart_devices_theme(){

global $cluster, $globals, $l,$fetched_row,$smart_data,$error,$servers;
softheader($l['<title>']);
					error_handle($error);
	
	echo '
	<script>
		let smart_data = new Object();
		smart_data = '.$smart_data.';
		function show_smart_modal(disk_id, disk_type){
			if(disk_type == "NVMe"){
				var smarttable = `<table class= "table get_task tablesorter tablehover shadow">
					<tr>
						<th>'.__J('Attributes').'</th>
						<th>'.__J('Values').'</th>
					</tr>`;
				$.each(smart_data[disk_id], function(k, val){
					if(k == "data_units_read" || k == "data_units_written"){
						val = (val/1970).toFixed()+" GB";
					}
					smarttable += `<tr> 
							<td> ${k} </td>
							<td> ${val}</td>
						</tr>
					`;
				})
			}else{
				if(smart_data[disk_id] == \'NA\'){
					var smarttable = `<p class="text-center mt-3">'.__J('No data Available').'</p>`;
				}
				else{
					var smarttable = `<table class= "table get_task tablesorter tablehover shadow">
					<tr>
						<th>'.__J('ID').'</th>
						<th>'.__J('Attributes').'</th>
						<th>'.__J('Values').'</th>
						<th>'.__J('Worst').'</th>
						<th>'.__J('Thresh').'</th>
						<th>'.__J('Flags').'</th>
						<th>'.__J('Raw Values').'</th>
						<th>'.__J('Fail').'</th>
					</tr>`;
	
					$.each(smart_data[disk_id], function(k, val){
						smarttable += `<tr> 
						<td> ${val["id"]} </td>
						<td> ${val["name"]}</td>
						<td> ${val["value"]}</td>
						<td> ${val["worst"]}</td>
						<td> ${val["thresh"]}</td>
						<td> ${val["flags"]["string"]}</td>
						<td> ${val["raw"]["value"]}</td>
						<td> ${(empty(val["when_failed"]) ? "- -" : val["when_failed"])}</td>
						</tr>
						`;
					})
				}
			}

			smarttable += `</table>`;
			$("#smart_values").html(smarttable);
			$("#span_smartvalue").html("Disk Info");
			$("#disk_smart_values").modal();
		';
	echo '
		}

	</script>';
	echo page_header(__('Disk Health'), 'fas fa-hdd', '', 1, 0, '');

	$breadcrumbs = ['dashboard', 'lm_vps_stats', 'lms_smart_devices'];

	echo get_breadcrumb($breadcrumbs);

	echo '<div class="card p-2 mx-3">
		<div id="showsearch" class="mt-3 w-100" style="display:'.(optREQ('search') || (!empty(1) && !empty($globals['showsearch'])) ? "" : "none").';">
			<form accept-charset="'.$globals['charset'].'" name="smart_devices" method="GET" action="" class="form-horizontal">
				<input type="hidden" name="act" value="smart_devices">
				<div class="form-group_head">
					<div class="row mx-auto w-100">
						<div class="col-sm-3">
							<label for="input text">'.__('Server ID').'</label>
							<input type="text" class="form-control" name="serid" id="serid" size="15" value="'.REQval('serid','').'" />
						</div>
						<div class="col-sm-3">
							<label for="input text" class="control-label">'.__('Serial Number').'</label>&nbsp;
							<input type="text" class="form-control" name="serial_number" id="serial_number" size="15" value="'.REQval('serial_number','').'" />
						</div>
						<div class="col-sm-3">
							<label for="input text" class="control-label">'.__('Model Name').'</label>&nbsp;
							<input type="text" class="form-control" name="model_name" id="model_name" size="15" value="'.REQval('model_name','').'" />
						</div>
						<div class="col-sm-3">
							<label for="input text" class="control-label">'.__('Device').'</label>&nbsp;
							<input type="text" class="form-control" name="device" id="device" size="15" value="'.REQval('device','').'" />
						</div>
						<div class="col-sm-3">
							<label for="input text" class="control-label">'.__('Rotation').'</label>&nbsp;
							<input type="text" class="form-control" name="rotation" id="rotation" size="15" value="'.REQval('rotation','').'" />
						</div>
						<div class="col-sm-3">
							<label for="input text" class="control-label">'.__('Logical Block Size').'</label>&nbsp;
							<input type="text" class="form-control" name="logical_block_size" id="logical_block_size" size="15" value="'.REQval('logical_block_size','').'" />
						</div>
						<div class="col-sm-3">
							<label for="input text" class="control-label">'.__('Disk Type').'</label>&nbsp;
							<input type="text" class="form-control" name="disk_type" id="disk_type" size="15" value="'.REQval('disk_type','').'" />
						</div>
						<div class="col-sm-3 server-select-lg">
							<label>'.__('Status').'</label>
							<select class="custom-select virt-select" name="status" id="status">
								<option value="0">---</option>
								<option value="healthy" '.REQselect('status', 'healthy').'>'.__('Healthy').'</option>
								<option value="fail" '.REQselect('status', 'fail').'>'.__('Failed').'</option>
							</select>
						</div>
						<div class="row mx-auto w-100 my-2">
							<div class="col-sm-12 text-center">
								<button type="submit" name="search" class="go_btn sm_space mt-2" value="Search">'.__('Submit').'</button>
							</div>
						</div>
					</div>
				</div>
			</form>
		</div>
	
	<div class="modal fade" id="disk_smart_values">
		<div class="modal-dialog modal-xl">
			<div class="modal-content">
				<div class="modal-header d-flex align-items-center">
					<span class="modal-title" id="span_smartvalue"></span>
					<button type="button" class="close text-always-white" data-dismiss="modal">&times;</button>
				</div>
				<div class="modal-body p-0">
					<div id="smart_values"></div>
				</div>
			</div>
		</div>
	</div>';

	if(!empty($fetched_row)){
	echo '
	<div class="row w-100 mx-auto">
		<table class="table table-hover tablesorter tasks_table common-table">
			<thead>
				<tr class="table_heading">
					<th class="min_width" align="center">'.__('ID').'</th>
					<th class="min_width" align="center">'.__('Server ID').'</th>
					<th align="center">'.__('Last Updated').'</th>
					<th>'.__('Disk Type').'</th>
					<th>'.__('Interface').'</th>
					<th>'.__('Model Name').' &</br> '.__('Device').'</th>
					<th>'.__('Serial Number').' &</br>'.__('Firmware Version').'</th>
					<th>'.__('Logical Block Size').'</th>
					<th>'.__('Rotation').'</th>
					<th>'.__('Temperature').'</th>
					<th>'.__('Size').'</th>
					<th class="min_width" align="center">'.__('S.M.A.R.T').'</th>
					<th class="min_width" align="center">'.__('Health').'</th>
				</tr>
			</thead>
	
	';

	foreach($fetched_row as $disk => $disk_data){
		if(!empty($disk_data['health'])){
			$disk_check = '<span style="color:green"><i class="fas fa-check-circle"></i></span>';
		}else{
			$disk_check = '<span style="color:red"><i class="fas fa-exclamation-triangle"></i></span>';
		}

		if(empty($disk_data['rotation'])){
			$disk_data['rotation'] = 'NA';
		}
		if($disk_data['sata_version'] == 'NA'){
			//NOW lets determine if its NVMe or something else
			if(preg_match('/QEMU/is', $disk_data['model_name'])){
				$disk_data['sata_version'] = 'Virtual / NA';
			}else{
				$disk_data['sata_version'] = 'PCI';
			}
		}
		echo '
			<tr>
				<td class="min_width" align="center">'.$disk_data['id'].'</td>
				<td class="min_width" align="center">'.$servers[$disk_data['serid']]['server_name'].'('.$disk_data['serid'].')'.'</td>
				<td>'.date('D-d/m h:i a', $disk_data['time']).'</td>
				<td><span class="text-admin font-weight-bold">'.$disk_data['disk_type'].'</span></td>
				<td>'.$disk_data['sata_version'].'</td>
				<td><span class="font-weight-bold">'.$disk_data['model_name'].'</span></br><span class="text-muted text-monospace">'.$disk_data['devices'].'</span></td>
				<td><span class="font-weight-bold">'.$disk_data['serial_number'].'</span></br><span class="text-muted">'.$disk_data['firmware_version'].'</span></td>
				<td>'.$disk_data['logical_block_size'].'</td>
				<td>'.$disk_data['rotation'].'</td>
				<td>'.$disk_data['temperature'].'</td>
				<td>'.$disk_data['size'].' TB</td>
				<td onclick="show_smart_modal(\''.$disk_data['id'].'\',\''.$disk_data['disk_type'].'\')" class="cursor-pointer min_width" align="center"><span class="text-primary"><i class="fas fa-eye"></i></span></td>
				<td class="min_width" align="center">'.$disk_check.'</td>
			</tr>
		';
	}

	echo '	</table>
		</div>
		<div class="row mx-auto w-100 mt-5">
			<div class="col-sm-8 col-lg-8 col-md-6 mb-3 p-0">';
			page_links($globals['num_res'], $globals['cur_page'], $globals['reslen']);
	echo'
			</div>
		</div>';
}else{
	echo '
	<div class="col-12">
		<div class="notice"><b>'.__('Note').': </b> &nbsp; '.__('No Disk data found!').'</div>
	</div>';
}
echo '</div>';
softfooter();
}
?>