<?php

//////////////////////////////////////////////////////////////
//===========================================================
// dashboard_theme.php
//===========================================================
// SOFTACULOUS VIRTUALIZOR
// Version : 1.0
// Inspired by the DESIRE to be the BEST OF ALL
// ----------------------------------------------------------
// Started by: Alons
// Date:       8th Mar 2010
// Time:       23:00 hrs
// Site:       https://www.virtualizor.com/ (SOFTACULOUS VIRTUALIZOR)
// ----------------------------------------------------------
// Please Read the Terms of use at https://www.virtualizor.com
// ----------------------------------------------------------
//===========================================================
// (c)Softaculous Ltd.
//===========================================================
//////////////////////////////////////////////////////////////

if(!defined('VIRTUALIZOR')){

	die('Hacking Attempt');

}

function manageserver_theme(){

global $theme, $error, $globals, $cluster, $user, $l, $usage, $info;

softheader($l['<title>']);
					
echo page_header(__('Manage Server'), 'icon icon-servers', '', 0, 0,'');

$breadcrumbs = array('dashboard', 'lm_servers', 'lms_manageserver');

echo get_breadcrumb($breadcrumbs);

error_handle($error); 

// Is it offline ?
$hypervisor_status = $cluster->statewise($globals['server']);
if($hypervisor_status == 0 || $hypervisor_status == 2){
	echo '<div class="e_notice mb-3"><b>'.__('Note').' : </b> &nbsp; '.$globals['hypervisor_status'][$hypervisor_status].'</div>';
}else{

	// Is it loaded into the correct kernel
	if(strlen($info['check_kernel']) > 1){
		show_alert($info['check_kernel'] ,"1");
		echo '<div class="e_notice mb-3"><b>'.__('Note').' : </b> &nbsp; '.$info['check_kernel'].'</div>';
	}

	if(!empty($GLOBALS['rebooted'])){
		show_alert($info['check_kernel'] ,"2");
		echo '<div class="mx-3 notice"><b>'.__('Note').' : </b> &nbsp; '.__('The server is now rebooting').'</div>';
	}
	echo '<style type="text/css">
	.card {
		border: none;
		box-shadow: 0px 1px 15px 1px rgba(69, 65, 78, 0.08);
	}
	.card-footer{
		border: none;
	}
	.card-header{
		border: none;
		height: 45px !important;
	}

	</style>';
	echo '<script language="javascript" type="text/javascript">';

	if(is_allowed('server_statistics')){

		echo '
		function conf_reboot(){
			showalert("'.__J('Are you sure you want to reboot the Server ?').'" ,"3" ,function(confirm){
				if(confirm == false){
					return false;
				}else{
					$("#progress_bar").show();
			
					$.ajax({
						type: "POST",
						url: "'.$globals['index'].'act=manageserver&reboot=1",
						success: function(data){
								setTimeout(function(){showalert(\''.__J('The server is now rebooting').'\');
								$("#alert-modal").on("hidden.bs.modal", function (e) {
								location.reload(true);
								});} ,200);
						},
						error: function(data) {
							$("#progress_bar").hide();
							return false;
						}
					});
				}
			});
		};

		// ]]></script>';

		if(is_allowed('server_statistics')){
			echo '
			<div class= "row w-100 mx-auto d-flex justify-content-center">
				<div col-sm-12>
					<div class="card p-2 mx-3 mb-3 w-100 text-center">
						<div class="card-header text-muted">
							<h6>'.$info['hostname'].' | <img src="'.$theme['images'].'/svgset/'.$info['os']['distro'].'.svg" width="30" />&nbsp;&nbsp;'.$info['os']['name'].'</span></h6>
						</div>
						<div class="card-body">
							<h5 class="text-admin"><img src="'.$theme['images'].'/svgset/'.$usage['cpu']['manu'].'.svg"  height="100px"/></h5>
							<h5 class="card-title">'.__('IP Address :').'&nbsp;'.$info['ips'][0].'</h5>
							<div class="row px-4">
								<div class="col-sm-6">
									<ul class="list-group list-group-flush">
										<li class="list-group-item text-left">'.__('VPS :').'&nbsp;'.$info['details']['numvps'].'</li>
										<li class="list-group-item text-left">'.__('Allocated CPU :').'&nbsp;'.$info['details']['alloc_cpu'].'</li>
										<li class="list-group-item text-left">'.__('Allocated Space :').'&nbsp;'.$info['details']['alloc_space'].' GB</li>
										<li class="list-group-item text-left">'.__('Allocated RAM :').'&nbsp;'.$info['details']['alloc_ram'].' MB</li>
									</ul>
								</div>
								<div class="col-sm-6">
									<ul class="list-group list-group-flush">
										<li class="list-group-item text-left">'.__('CPU Model:').'&nbsp;'.$usage['cpu']['cpumodel'].'</li>
										<li class="list-group-item text-left">'.__('Status :').'&nbsp;'.($info['status'] == 1 ? '<i class="fas fa-running fa-2x text-success"></i>&nbsp;&nbsp;'.__('Online').'' : '<i class="fas fa-times-circle fa-2x text-danger"></i>&nbsp;&nbsp;'.__('Offline').'').'</li>
										<li class="list-group-item text-left" id="uptime_data">'.__('Uptime :').'&nbsp;'.$info['uptime'].'</li>
										<li class="list-group-item text-left">'.__('Kernel :').'&nbsp;'.$info['kernel_name'].'</li>
									</ul>
								</div>
							</div>
							</br>
							<hr>
							<h5>'.__('Server Resources').'</h5>
							</br>
							<div class="row w-100 mx-auto">
								<div class="col-sm-6 col-md-4 col-lg-2">
									<div class="card text-center">
										<div class="card-header text-muted">
										<h6>'._strtoupper(__('CPU')).'</h6>
										</div>
										<div class="card-body">
										<h5 class="card-title" id="cpu_percent"></h5>
										<div class="row mx-auto w-100">
											<div class="col-sm-12 d-flex justify-content-center">
												<div id="cpuholder" style="width: 125px; height: 100px;"></div>
											</div>
										</div>
											</div>
										<div class="card-footer text-muted" id="cpu_model">
										</div>
									</div>
								</div>
								<div class="col-sm-6 col-md-4 col-lg-2">
									<div class="card text-center">
										<div class="card-header text-muted">
										<h6>'._strtoupper(__('RAM')).'</h6>
										</div>
										<div class="card-body">
										<h5 class="card-title" id="ram_percent"></h5>
										<div class="row w-100 mx-auto">
											<div class="col-sm-12 d-flex justify-content-center">
												<div id="ramholder" style="width: 125px; height: 100px;"></div>
											</div>
										</div>
											</div>
										<div class="card-footer text-muted" id="ram_model">
										</div>
									</div>
								</div>
								<div class="col-sm-6 col-md-4 col-lg-2">
									<div class="card text-center">
										<div class="card-header text-muted">
										<h6>'._strtoupper(__('Disk')).'</h6>
										</div>
										<div class="card-body">
										<h5 class="card-title" id="disk_percent"></h5>
										<div class="row mx-auto">
											<div class="col-sm-12 d-flex justify-content-center">
												<div id="diskholder" style="width: 125px; height: 100px;"></div>
											</div>
										</div>
											</div>
										<div class="card-footer text-muted" id="disk_model">
										</div>
									</div>
								</div>
								<div class="col-sm-6 col-md-4 col-lg-2">
									<div class="card text-center">
										<div class="card-header text-muted">
										<h6>'._strtoupper(__('Storage')).'</h6>
										</div>
										<div class="card-body">
										<h5 class="card-title" id="storage_percent"></h5>
										<div class="row mx-auto">
											<div class="col-sm-12 d-flex justify-content-center">
												<div id="storageholder" style="width: 125px; height: 100px;"></div>
											</div>
										</div>
											</div>
										<div class="card-footer text-muted" id="storage_model">
										</div>
									</div>
								</div>
								<div class="col-sm-6 col-md-4 col-lg-2">
									<div class="card text-center">
										<div class="card-header text-muted">
										<h6>'._strtoupper(__('Bandwidth')).'</h6>
										</div>
										<div class="card-body">
										<h5 class="card-title" id="bandwidth_percent"></h5>
										<div class="row mx-auto">
											<div class="col-sm-12 d-flex justify-content-center">
												<div id="bandwidthholder" style="width: 125px; height: 100px;"></div>
											</div>
										</div>
											</div>
										<div class="card-footer text-muted" id="bandwidth_model">
										</div>
									</div>
								</div>
								<div class="col-sm-6 col-md-4 col-lg-2">
									<div class="card text-center">
										<div class="card-header text-muted">
										<h6>'._strtoupper(__('IO WAIT')).'</h6>
										</div>
										<div class="card-body">
										<h5 class="card-title" id="iowait_percent"></h5>
										<div class="row mx-auto">
											<div class="col-sm-12 d-flex justify-content-center">
												<div id="iowaitholder" style="width: 125px; height: 100px;"></div>
											</div>
										</div>
											</div>
										<div class="card-footer text-muted" id="iowait_model">
										</div>
									</div>
								</div>
							</div>
							</br>
							<hr>
							<h5>'.__('Server Options').'</h5>
							</br>
							<div class="row mx-auto w-100 text-center">
								<div class="col-sm-12  d-flex justify-content-center">
									<div class="serv_op p-4 pan-button">
										<a href="'.$globals['index'].'act=config" class="micons">
										<svg xmlns="http://www.w3.org/2000/svg" viewBox="-1,-3,22,28" width="60" height="60" fill="currentColor">
											<path d="m2 8.654 2.813 2.822 6.332-6.35-2.814-2.823-6.332 6.35zm4.441 8.128 2.11-2.117a.993.993 0 0 1 1.408 0 1 1 0 0 1 0 1.411l-2.11 2.117a1 1 0 0 1 0 1.411L6.44 21.015a.993.993 0 0 1-1.407 0l-1.407-1.41a1 1 0 0 1 0-1.412l1.407-1.411a.993.993 0 0 1 1.407 0zm9.146-6.35 6.331-6.35-1.407-1.412-6.331 6.35c-.777-.78-.912-1.907-.302-2.52L19.406.956c.61-.612 1.735-.477 2.512.303l1.407 1.41c.778.78.913 1.909.302 2.52l-5.528 5.545c-.61.612-1.735.477-2.512-.303zm-.924 3.866L9.738 9.36l-.704.706 4.925 4.939.704-.706zm1.407 1.412-.704.705 1.759 1.764c.194.195.51.195.703 0a.5.5 0 0 0 0-.705L16.07 15.71zM2.06 5.77a1.5 1.5 0 0 1 .291-1.704l1.407-1.41a1.49 1.49 0 0 1 1.699-.293L6.924.892a1.986 1.986 0 0 1 2.814 0l2.814 2.823a2 2 0 0 1 0 2.822l-1.407 1.411 8.09 8.114a2.5 2.5 0 0 1 0 3.528 2.482 2.482 0 0 1-3.517 0l-8.09-8.114-1.408 1.411c-.777.78-2.037.78-2.814 0L.592 10.065a2 2 0 0 1 0-2.823l1.467-1.47z"/>
										</svg>
										<br />
										<div class="pt-2">'.__('Settings').'</div>
										</a>
									</div>
									<div class="serv_op p-4 pan-button">
										<a href="'.$globals['index'].'act=vscpu" class="micons">
										<svg xmlns="http://www.w3.org/2000/svg" viewBox="-1,-3,22,28" width="60" height="60" fill="currentColor">
										<path d="M6 3h8a3 3 0 0 1 3 3v8a3 3 0 0 1-3 3H6a3 3 0 0 1-3-3V6a3 3 0 0 1 3-3zm0 2a1 1 0 0 0-1 1v8a1 1 0 0 0 1 1h8a1 1 0 0 0 1-1V6a1 1 0 0 0-1-1H6zm2 2h4a1 1 0 0 1 1 1v4a1 1 0 0 1-1 1H8a1 1 0 0 1-1-1V8a1 1 0 0 1 1-1zm1 2v2h2V9H9zM6 0a1 1 0 0 1 1 1v2a1 1 0 1 1-2 0V1a1 1 0 0 1 1-1zM1 5h2a1 1 0 1 1 0 2H1a1 1 0 1 1 0-2zm16 0h2a1 1 0 0 1 0 2h-2a1 1 0 0 1 0-2zM1 9h2a1 1 0 1 1 0 2H1a1 1 0 0 1 0-2zm16 0h2a1 1 0 0 1 0 2h-2a1 1 0 0 1 0-2zM1 13h2a1 1 0 0 1 0 2H1a1 1 0 0 1 0-2zm16 0h2a1 1 0 0 1 0 2h-2a1 1 0 0 1 0-2zM6 16a1 1 0 0 1 1 1v2a1 1 0 0 1-2 0v-2a1 1 0 0 1 1-1zm8-16a1 1 0 0 1 1 1v2a1 1 0 0 1-2 0V1a1 1 0 0 1 1-1zm0 16a1 1 0 0 1 1 1v2a1 1 0 0 1-2 0v-2a1 1 0 0 1 1-1zM10 0a1 1 0 0 1 1 1v2a1 1 0 0 1-2 0V1a1 1 0 0 1 1-1zm0 16a1 1 0 0 1 1 1v2a1 1 0 0 1-2 0v-2a1 1 0 0 1 1-1z"/>
										</svg><br />
										<div class="pt-2">'.__('VPS CPU Usage').'</div>
										</a>
									</div>
									<div class="serv_op p-4 pan-button">
										<a href="'.$globals['index'].'act=vsram" class="micons">
										<svg xmlns="http://www.w3.org/2000/svg" viewBox="-1,-3,22,28" width="60" height="60" fill="currentColor">
										<path d="m14.95 7.879-.707-.707a1 1 0 0 1 1.414-1.415l.707.707 1.414-1.414-2.828-2.828L2.222 14.95l2.828 2.828 1.414-1.414L5.05 14.95a1 1 0 0 1 1.414-1.414L7.88 14.95l1.414-1.414-.707-.708A1 1 0 0 1 10 11.414l.707.707 1.414-1.414-1.414-1.414a1 1 0 0 1 1.414-1.414l1.415 1.414 1.414-1.414zM.808 13.536 13.536.808a2 2 0 0 1 2.828 0l2.828 2.828a2 2 0 0 1 0 2.828L6.464 19.192a2 2 0 0 1-2.828 0L.808 16.364a2 2 0 0 1 0-2.828z"/>
										</svg><br />
										<div class="pt-2">'.__('VPS RAM Usage').'</div>
										</a>
									</div>
									<div class="serv_op p-4 pan-button">
										<a href="'.$globals['index'].'act=vsbandwidth" class="micons">
										<svg xmlns="http://www.w3.org/2000/svg" viewBox="-1,-3,22,28" width="60" height="60" fill="currentColor">
											<path d="M10 18a8 8 0 1 0 0-16 8 8 0 0 0 0 16zm0 2C4.477 20 0 15.523 0 10S4.477 0 10 0s10 4.477 10 10-4.477 10-10 10zM9 1h2v10H9V1zm0 8h10v2H9V9z"/>
										</svg><br />
										<div class="pt-2">'.__('Bandwidth').'</div>
										</a>
									</div>
									<div class="serv_op p-4 pan-button">
										<a href="javascript:void(0);" class="micons" onclick="conf_reboot();">
										<svg xmlns="http://www.w3.org/2000/svg" viewBox="-1,-3,22,28" width="60" height="60" fill="currentColor">
											<path d="m5.308 7.612 1.352-.923a.981.981 0 0 1 1.372.27 1.008 1.008 0 0 1-.266 1.388l-3.277 2.237a.981.981 0 0 1-1.372-.27L.907 6.998a1.007 1.007 0 0 1 .266-1.389.981.981 0 0 1 1.372.27l.839 1.259C4.6 3.01 8.38 0 12.855 0c5.458 0 9.882 4.477 9.882 10s-4.424 10-9.882 10a.994.994 0 0 1-.988-1c0-.552.443-1 .988-1 4.366 0 7.906-3.582 7.906-8s-3.54-8-7.906-8C9.311 2 6.312 4.36 5.308 7.612z"/>
										</svg><br />
										<div class="pt-2">'.__('Reboot').'</div>
										</a>
									</div>
									<div class="serv_op p-4 pan-button">
										<a href="'.$globals['index'].'act=backup_plans" class="micons">
										<svg xmlns="http://www.w3.org/2000/svg" viewBox="-1,-3,22,28" width="60" height="60" fill="currentColor">
										<defs>
											<image width="24" height="25" id="img1" href="data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9Ii01IC00LjUgMjQgMjQiIHdpZHRoPSIyNCIgaGVpZ2h0PSIyNCIgZmlsbD0iY3VycmVudENvbG9yIj48cGF0aCBkPSJtNiA0LjA3MS0zLjk1IDMuOTVBMSAxIDAgMCAxIC42MzYgNi42MDdMNi4yOTMuOTVhLjk5Ny45OTcgMCAwIDEgMS40MTQgMGw1LjY1NyA1LjY1N0ExIDEgMCAwIDEgMTEuOTUgOC4wMkw4IDQuMDd2OS41ODZhMSAxIDAgMSAxLTIgMFY0LjA3eiIvPjwvc3ZnPg=="/>
										</defs>
										<style>
											.s0 { fill: currentColor } 
											#arrow-up {
												filter: invert(50%);
											}
										</style>
										<path id="Layer" fill-rule="evenodd" class="s0" d="m7 19c-1.5 0-2.9-0.6-3.8-1.8-1-1.1-1.4-2.5-1.1-4 0.2-1.4 1.1-2.7 2.3-3.5 1.2-0.7 2.8-0.9 4.2-0.5 0.6-1.4 1.7-2.7 3.2-3.4 1.4-0.7 3-1 4.6-0.7 1.6 0.4 3 1.2 4 2.5 1 1.2 1.6 2.8 1.6 4.4q0 1.4-0.5 2.7-0.6 1.3-1.6 2.2-0.9 1-2.2 1.6-1.3 0.5-2.7 0.5zm0-2h8c1.8 0 3.5-1 4.4-2.6 0.9-1.7 0.8-3.6-0.2-5.2-1-1.5-2.8-2.3-4.7-2.2-1.8 0.2-3.4 1.3-4.1 3l-0.7 1.7-1.8-0.6c-0.8-0.2-1.7-0.1-2.5 0.3-0.7 0.5-1.2 1.3-1.4 2.1-0.1 0.9 0.2 1.8 0.7 2.4 0.6 0.7 1.4 1.1 2.3 1.1z"/>
										<use id="arrow-up" href="#img1" transform="matrix(.458,0,0,.459,8,7)"/>
										</svg><br />
										<div class="pt-2">'.__('VPS Backup Settings').'</div>
										</a>
									</div>
									<div class="serv_op p-4 pan-button">
										<a href="'.$globals['index'].'act=vpsrestore" class="micons">
										<svg xmlns="http://www.w3.org/2000/svg" viewBox="-1,-3,22,28" width="60" height="60" fill="currentColor">
											<path d="M13.106 9h3.953c.546 0 .988.448.988 1s-.442 1-.988 1h-4.941a.994.994 0 0 1-.988-1V4c0-.552.442-1 .988-1s.988.448.988 1v5zm6-6.071A10.029 10.029 0 0 1 22 10c0 5.523-4.424 10-9.882 10v-2c4.366 0 7.906-3.582 7.906-8a8.02 8.02 0 0 0-2.316-5.657A7.834 7.834 0 0 0 12.118 2C8.574 2 5.574 4.36 4.571 7.612l1.352-.923a.981.981 0 0 1 1.372.27 1.007 1.007 0 0 1-.267 1.388l-3.277 2.237a.981.981 0 0 1-1.372-.27L.17 6.998a1.007 1.007 0 0 1 .267-1.389.981.981 0 0 1 1.372.27l.839 1.259C3.863 3.01 7.643 0 12.118 0c2.729 0 5.2 1.12 6.988 2.929z"/>
										</svg><br />
										<div class="pt-2">'.__('VPS Backups').'</div>
										</a>
									</div>
								</div>					
							
							</div>
						</div>
					</div>
				</div>
			</div>';
		}


	}

	echo '
	</br>
	<p class="mx-3 notice">'.__('All logos used are trademarks or registered trademarks of their respective companies.').'</p>
	</div>
	<script>
		var charts_rendered = {};
		var timer_server_loads; 

		function card_graph(percent_name,model_name,progress_name,percent,bottom_text){
			percent = percent.toFixed(2);
			$("#"+percent_name).html(percent+"%");
			$("#"+model_name).html(bottom_text);
		}

		function loadserverstats(){

			var percent = 0;
			var percent_free = 0;

			var cpu_graph_data = [percent,percent_free];
			var cpu_options = {
				
				series: cpu_graph_data,
				chart: {
					type: "donut",
					animations: {
						enabled: true,
						easing: "easeinout",
						speed: 1000
					},
						height:140,
						width:120
				},
				labels: ["Used", "Free"],
				legend: {
					show: false 
				},
				dataLabels: {
					enabled: false
				},
				plotOptions: {
					pie: {
						donut: {
						
						},
						expandOnClick: true,
					}
				},
				tooltip: {
					enabled: true,
					y: {
						formatter: function(val) {
							return val.toFixed(2) + "%";
						}
					}
				}
			};

			var ram_graph_data = [percent, percent_free];
			var ram_options = {
				
				series: ram_graph_data,
				chart: {
					type: "donut",
					animations: {
						enabled: true,
						easing: "easeinout",
						speed: 1000
					},
						height:140,
						width:120
				},
				labels: ["Used", "Free"],
				legend: {
					show: false 
				},
				dataLabels: {
					enabled: false
				},
				plotOptions: {
					pie: {
						donut: {
						
						},
						expandOnClick: true,
					}
				},
				tooltip: {
					enabled: true
				}
			};

			var disk_graph_data = [percent, percent_free];
			var disk_options = {
				
				series: disk_graph_data,
				chart: {
					type: "donut",
					animations: {
						enabled: true,
						easing: "easeinout",
						speed: 1000
					},
						height:140,
						width:120
				},
				labels: ["Used", "Free"],
				legend: {
					show: false 
				},
				dataLabels: {
					enabled: false
				},
				plotOptions: {
					pie: {
						donut: {
						
						},
						expandOnClick: true,
					}
				},
				tooltip: {
					enabled: true,
					y: {
						formatter: function(val) {
							return val.toFixed(2) + "%";
						}
					}
				}
			};

			var storage_graph_data = [percent, percent_free];
			var storage_options = {
				
				series: storage_graph_data,
				chart: {
					type: "donut",
					animations: {
						enabled: true,
						easing: "easeinout",
						speed: 1000
					},
						height:140,
						width:120
				},
				labels: ["Used", "Free"],
				legend: {
					show: false 
				},
				dataLabels: {
					enabled: false
				},
				plotOptions: {
					pie: {
						donut: {},
						expandOnClick: true,
					}
				},
				tooltip: {
					enabled: true,
					y: {
						formatter: function(val) {
							return val.toFixed(2) + "%";
						}
					}
				}
			};

			var bw_graph_data = [percent, percent_free];
			var bw_options = {
				
				series: bw_graph_data,
				chart: {
					type: "donut",
					animations: {
						enabled: true,
						easing: "easeinout",
						speed: 1000
					},
						height:140,
						width:120
				},
				labels: ["Used", "Free"],
				legend: {
					show: false 
				},
				dataLabels: {
					enabled: false
				},
				plotOptions: {
					pie: {
						donut: {
						
						},
						expandOnClick: true,
					}
				},
				tooltip: {
					enabled: true,
					y: {
						formatter: function(val) {
							return val.toFixed(2) + "%";
						}
					}
				}
			};

			var iowait_graph_data = [percent, percent_free];
			var iowait_options = {
				
				series: iowait_graph_data,
				chart: {
					type: "donut",
					animations: {
						enabled: true,
						easing: "easeinout",
						speed: 1000
					},
						height:140,
						width:120
				},
				labels: ["Used", "Free"],
				legend: {
					show: false 
				},
				dataLabels: {
					enabled: false
				},
				plotOptions: {
					pie: {
						donut: {
						
						},
						expandOnClick: true,
					}
				},
				tooltip: {
					enabled: true,
					y: {
						formatter: function(val) {
							return val.toFixed(2) + "%";
						}
					}
				}
			};

			let cpu_graph_object = {};
			let ram_graph_object = {};
			let disk_graph_object = {};
			let storage_graph_object = {};
			let bw_graph_object = {};
			let iowait_graph_object = {};

			cpu_graph_object = live_resource_graph2("", "cpuholder", cpu_options);
			ram_graph_object = live_resource_graph2("", "ramholder", ram_options);
			disk_graph_object = live_resource_graph2("", "diskholder", disk_options);
			storage_graph_object = live_resource_graph2("", "storageholder", storage_options);
			bw_graph_object = live_resource_graph2("", "bandwidthholder", bw_options);
			iowait_graph_object = live_resource_graph2("", "iowaitholder", iowait_options);

			function getserverstats(serid){
			
				clearTimeout(timer_server_loads);
				
				serid = serid || 0;
				
				$.getJSON("'.$globals['index'].'act=manageserver&changeserid="+serid+"&api=json", function(data) {
					
					//CPU
					cpu_graph_data = [data["usage"]["cpu"]["percent"],data["usage"]["cpu"]["percent_free"]];
					update_cpu_option_and_data = {
						series: cpu_graph_data,
					};
					cpu_graph_object = live_resource_graph2(cpu_graph_object, "",{},{},update_cpu_option_and_data);
					card_graph("cpu_percent","cpu_model","cpu_progress",data["usage"]["cpu"]["percent"],"'.__J('Free').': "+data["usage"]["cpu"]["percent_free"]+"%");

					//RAM
					ram_graph_data = [data["usage"]["ram"]["percent"],data["usage"]["ram"]["percent_free"]];
					update_ram_option_and_data = {
						series: ram_graph_data,
					};
					ram_graph_object = live_resource_graph2(ram_graph_object, "",{},{},update_ram_option_and_data);
					card_graph("ram_percent","ram_model","ram_progress",data["usage"]["ram"]["percent"],"'.__J('Free').': "+data["usage"]["ram"]["percent_free"]+"%");

					//DISK
					disk_graph_data = [data["usage"]["disk"]["/"]["percent"],data["usage"]["disk"]["/"]["percent_free"]];
					update_disk_option_and_data = {
						series: disk_graph_data,
					};
					disk_graph_object = live_resource_graph2(disk_graph_object, "",{},{},update_disk_option_and_data);
					card_graph("disk_percent","disk_model","disk_progress",data["usage"]["disk"]["/"]["percent"],"'.__J('Free').': "+data["usage"]["disk"]["/"]["percent_free"]+"%");

					//STORAGE
					var sto_total = data["info"]["resources"]["total_space"];
					var sto_used = (sto_total - data["info"]["resources"]["space"]).toFixed(2);
					var sto_per = (sto_used / sto_total)*100;

					storage_graph_data = [sto_per, 100 - sto_per.toFixed(2)];
					update_storage_option_and_data = {
						series: storage_graph_data,
					};
					storage_graph_object = live_resource_graph2(storage_graph_object, "",{},{},update_storage_option_and_data);
					card_graph("storage_percent","storage_model","storage_progress",sto_per,"'.__J('Free').': "+ (100 - sto_per).toFixed(2)+"%");

					//BANDWDITH
					bw_graph_data = [(data["usage"]["bandwidth"]["percent"] == 0)? 0.1 : data["usage"]["bandwidth"]["percent"] ,data["usage"]["bandwidth"]["percent_free"]];
					update_bw_option_and_data = {
						series: bw_graph_data,
					};
					bw_graph_object = live_resource_graph2(bw_graph_object, "",{},{},update_bw_option_and_data);
					card_graph("bandwidth_percent","bandwidth_model","bandwidth_progress",(data["usage"]["bandwidth"]["percent"] == 0)? 0.1 : data["usage"]["bandwidth"]["percent"],"'.__J('Free').': "+data["usage"]["bandwidth"]["percent_free"]+"%");
					
					
					//IOWAIT
					if(!empty(data["usage"]["io"])){
						var iowait = data["usage"]["io"]["avg_cpu"]["iowait"];
						var iowait_f = 100 - iowait;
					}else{
						var iowait = "NA";
						var iowait_f = "NA";
					}
					iowait_graph_data = [iowait ,iowait_f];
					update_iowait_option_and_data = {
						series: iowait_graph_data,
					};
					iowait_graph_object = live_resource_graph2(iowait_graph_object, "", {}, {}, update_iowait_option_and_data);
					card_graph("iowait_percent", "iowait_model", "iowait_progress", iowait, "'.__J('Free').': "+iowait_f+"%");


					// Update Server Load Average
					$("#uptime_data").html(data["info"]["uptime"]);

					timer_server_loads = setTimeout(getserverstats('.$globals['server'].'), 5000);
					
				});
			}

			getserverstats('.$globals['server'].');

		}
		loadserverstats();
	</script>';
}

softfooter();

}

