<?php

//////////////////////////////////////////////////////////////
//===========================================================
// import_theme.php
//===========================================================
// SOFTACULOUS VIRTUALIZOR
// Version : 1.0
// Inspired by the DESIRE to be the BEST OF ALL
// ----------------------------------------------------------
// Started by: Alons
// Date:       8th Mar 2010
// Time:       23:00 hrs
// Site:       https://www.virtualizor.com/ (SOFTACULOUS VIRTUALIZOR)
// ----------------------------------------------------------
// Please Read the Terms of use at https://www.virtualizor.com
// ----------------------------------------------------------
//===========================================================
// (c)Softaculous Ltd.
//===========================================================
//////////////////////////////////////////////////////////////

if(!defined('VIRTUALIZOR')){

	die('Hacking Attempt');

}

function import_default_theme(){

global $theme, $globals, $kernel, $user, $ippools, $l, $error, $oslist, $done, $vpsid;

softheader($l['<title>']);
					
echo page_header(__('Import VPS'), 'fas fa-upload', '', 1, 0, '');

$breadcrumbs = ['dashboard', 'lm_import', 'lms_import'];

echo get_breadcrumb($breadcrumbs);

echo '<div class="card p-2 mx-3">';
error_handle($error); 

if(!empty($done)){
	show_alert(lang_vars(__('VPS Successfully Imported. For Editing the VPS <a href="index.php?act=editvs&vpsid=&soft-1;">click here</a>'), array($vpsid)));
}

echo '<form accept-charset="'.$globals['charset'].'" name="importvps" method="post" action="" class="form-horizontal">

<table border="0" width="95%" align="center" class="class="table table-hover tablesorter"">
<tr>
	<td width="40%">
		<span class="fhead">'.__('VPS Container ID').'</span><br />
		<span class="exp">'.__('Please specify the VPS Container ID to be imported').'</span></td>
	<td>
		<input type="text" name="vpsname" id="vpsname" value="'.POSTval('vpsname', '').'" class="form-control" />
	</td>
</tr>
<tr>
	<td>
		<span class="fhead">'.__('Bandwidth').'</span><br />
		<span class="exp">'.__('Please specify the Bandwidth for the VPS').'</span></td>
	<td>
		<input type="text" name="vpsbandwidth" id="vpsbandwidth" value="'.POSTval('vpsbandwidth', '').'" class="form-control"/>
	</td>
</tr>
</table>

<br />
<center><input type="submit" name="importvps" value="'.__('Import').'" class="btn"></center>
</form>
</div>';

softfooter();

}

// Import Virtuozzo / OpenVZ
function openvz_import_theme(){

global $theme, $globals, $kernel, $user, $l, $error, $oslist, $done, $vpsid, $orphan, $users, $is_openvz7;

softheader($l['<title>']);

$sa = optREQ('sa');

$tmp_virt = 'OpenVZ';
if($sa == 'vzo'){
	$tmp_virt = 'Virtuozzo OpenVZ';
}

echo page_header(__('Import VPS'), 'fas fa-upload', $globals['docs'].'importing-openvz-vps/');

$breadcrumbs = ['dashboard', 'lm_import', 'lms_openvz7'];

echo get_breadcrumb($breadcrumbs);

error_handle($error);

if(!empty($done)){
	show_alert(__('The VPS(s) was imported successfully'));
}else{

// Are there any orphans
if(empty($orphan)){
show_alert(__('There is no VPS to import'), "2");
echo '<div class="e_notice mb-3"><b>NOTE : </b>&nbsp; '.__('There is no VPS to import').'</div>';

}else{
	if(!empty($is_openvz7)){
		show_alert(__('It seems that you have OpenVZ7 installation on the server and you are trying to import it in OpenVZ 6 wizard, Please <a href="index.php?act=import&sa=openvz7">click here</a> to import it as OpenVZ 7 containers'), "2");
		echo '<div class="e_notice mb-3"><b>NOTE : </b>&nbsp; '.__('It seems that you have OpenVZ7 installation on the server and you are trying to import it in OpenVZ 6 wizard, Please <a href="index.php?act=import&sa=openvz7">click here</a> to import it as OpenVZ 7 containers').'</div>';
	}
echo '
<div class="card p-2 mx-3">
<form accept-charset="'.$globals['charset'].'" name="importvps" method="post" action="" class="form-horizontal">
<div class="w-100 mx-auto sticky">
'.get_num_records(count($orphan)).'
<table border="0" width="95%" align="center" class="table table-hover tablesorter mt-3">
<tr>
	<th class="fhead">'.__('VPS Container ID').'</th>
	<th class="fhead">'.__('Bandwidth').'</th>
	<th class="fhead">&nbsp;</th>
	<th class="fhead">'.__('Users').'</th>
	<th class="z-index-1 min_width fhead">
		'.get_checkbox('select_all', '', 'select_all', array('chk_it' => 0), '', 'select_all').'
	</th>
</tr>';

foreach($orphan as $k => $v){
	echo '<tr>
	<td width="20%">'.$v.'</td>
	<td><input type="text" name="vsbw_'.$v.'" size="8" value="'.POSTval('vsbw_'.$v, '0').'" class="form-control"/></td><td> GB</td>
	<td>
		<select name="vsuser_'.$v.'" class="virt-select">
		<option value="">'.__('None').'</option>';
	
		foreach($users as $uk => $uv){
			echo '<option value="'.$uk.'">'.$uv['email'].'</option>';
		}
	
echo '</select>
	<td width="20" valign="top" align="center">
		'.get_checkbox('vps_list[]', '', '', array('chk_it' => 0), $k).'
	</td>
	</td>
</tr>';
}

echo '</table></div>

<br />
<center><input type="submit" name="importvps" value="'.__('Import').'" class="btn"></center>
</form>';

}// End of IF !EMPTY Orphan

}
echo '</div>';
softfooter();

}

// Import KVM
function kvm_import_theme(){

	global $theme, $globals, $kernel, $user, $l, $error, $oslist, $done, $vpsid, $orphan, $users;

	softheader($l['<title>']);

	echo page_header('KVM '.__('Import VPS'), 'fas fa-upload', '', 1);

	$breadcrumbs = ['dashboard', 'lm_import', 'lms_kvm'];

	echo get_breadcrumb($breadcrumbs);

	echo '<div class="card p-2 mx-3">';
	error_handle($error);

	if(!empty($done)){
		show_alert(__('The VPS(s) was imported successfully'));
	}else{

	// Are there any orphans
		if(empty($orphan)){
			show_alert(__('There is no VPS to import') ,"2");
			echo '<div class="e_notice m-0"><b>NOTE : </b>&nbsp; '.__('There is no VPS to import').'</div>';

		}else{
			echo '<form accept-charset="'.$globals['charset'].'" name="importvps" method="post" action="" class="form-horizontal">
			<div class="w-100 mx-auto sticky">
			'.get_num_records(count($orphan)).'
			<table border="0" width="95%" align="center" class="table table-hover tablesorter">
			<tr>
				<th class="fhead">'.__('VPS Container ID').'</th>
				<th class="fhead">'.__('Bandwidth').'</th>
				<th class="fhead">&nbsp;</th>
				<th class="fhead">'.__('Users').'</th>
				<th class="z-index-1 min_width fhead">
					'.get_checkbox('select_all', '', 'select_all', array('chk_it' => 0), '', 'select_all').'
				</th>
			</tr>';

			foreach($orphan as $k => $v){
				echo '<tr>
				<td>'.$v.'</td>
				<td><input type="text" name="vsbw_'.$v.'" size="8" value="'.POSTval('vsbw_'.$v, '0').'" class="form-control"/></td><td> GB</td>
				<td>
					<select name="vsuser_'.$v.'" class="virt-select">
					<option value="">'.__('None').'</option>';
				
					foreach($users as $uk => $uv){
						echo '<option value="'.$uk.'">'.$uv['email'].'</option>';
					}
				
			echo '</select>
				</td>
				<td width="20" valign="top" align="center">
					'.get_checkbox('vps_list[]', '', '', array('chk_it' => 0), $k).'
				</td>
			</tr>';
			}

			echo '</table></div>

			<br />
			<center><input type="submit" name="importvps" value="'.__('Import').'" class="btn"></center>
			</form>';

		}// End of IF !EMPTY Orphan

	}
	
	echo '<br /></div>';
	softfooter();

}

// Import xen
function xen_import_theme(){

	global $theme, $globals, $kernel, $user, $l, $error, $oslist, $done, $vpsid, $orphan, $users;

	softheader($l['<title>']);

	echo page_header('XEN '.__('Import VPS'), 'fas fa-upload');

	$breadcrumbs = ['dashboard', 'lm_import', 'lms_xen'];

	echo get_breadcrumb($breadcrumbs);

	echo '<div class="card p-2 mx-3">';
	error_handle($error);

	global $vps_success_imp;
	show_vps_imp_succ($vps_success_imp);

	if(!empty($done)){
		show_alert(__('The VPS(s) was imported successfully'));
	}else{
		// Are there any orphans
		if(empty($orphan)){
		show_alert(__('There is no VPS to import') ,"2");
		echo '<div class="e_notice m-0"><b>NOTE : </b>&nbsp; '.__('There is no VPS to import').'</div>';

		}else{
			echo 
			'<form accept-charset="'.$globals['charset'].'" name="importvps" method="post" action="" class="form-horizontal">
				<div class="w-100 mx-auto sticky">
					'.get_num_records(count($orphan)).'
					<table border="0" width="95%" align="center" class="table table-hover tablesorter">
						<tr>
							<th class="fhead">'.__('VPS Container ID').'</th>
							<th class="fhead">'.__('Bandwidth').'</th>
							<th class="fhead">&nbsp;</th>
							<th class="fhead">'.__('Users').'</th>
							<th class="z-index-1 min_width fhead">
								'.get_checkbox('select_all', '', 'select_all', array('chk_it' => 0), '', 'select_all').'
							</th>
						</tr>';

						foreach($orphan as $k => $v){
							echo 
							'<tr>
								<td>'.$v.'</td>
								<td>
									<input type="text" name="vsbw_'.$v.'" size="8" value="'.POSTval('vsbw_'.$v, '0').'" class="form-control"/></td><td> GB</td>
								<td>
									<select name="vsuser_'.$v.'" class="virt-select">
									<option value="">'.__('None').'</option>';
								
									foreach($users as $uk => $uv){
										echo '<option value="'.$uk.'">'.$uv['email'].'</option>';
									}
								
								echo'</select>
								</td>
								<td width="20" valign="top" align="center">
									'.get_checkbox('vps_list[]', '', '', array('chk_it' => 0), $k).'
								</td>
							</tr>';
						}
					echo 
					'</table>
				</div>
				<br/>
				<div class="text-center">
					<input type="submit" name="importvps" value="'.__('Import').'" class="btn" >
				</div>
			</form>';
		}// End of IF !EMPTY Orphan
	}
	
	echo '<br/></div>';
	softfooter();

}

// Import xen
function xcp_import_theme(){

	global $theme, $globals, $kernel, $user, $l, $error, $oslist, $done, $vpsid, $orphan, $users;

	softheader($l['<title>']);

	echo page_header(__('Import VPS'), 'fas fa-upload', '', 0, 0, '');

	$breadcrumbs = ['dashboard', 'lm_pdns', 'lms_xenserver'];

	echo get_breadcrumb($breadcrumbs);

	echo 
	'<div class="card p-2 mx-3">';

	error_handle($error);

	if(!empty($done)){
		show_alert(__('The VPS(s) was imported successfully'));
	}else{

	// Are there any orphans
		if(empty($orphan)){
			show_alert(__('There is no VPS to import') ,"2");
			echo '<div class="e_notice m-0"><b>NOTE : </b>&nbsp; '.__('There is no VPS to import').'</div>';
		}else{

			echo '<form accept-charset="'.$globals['charset'].'" name="importvps" method="post" action="" class="form-horizontal">
					<div class="w-100 mx-auto sticky">
					'.get_num_records(count($orphan)).'
					<table border="0" width="95%" align="center" class="table table-hover tablesorter">
					<tr>
						<th class="fhead">'.__('VPS Container ID').'</th>
						<th class="fhead">'.__('Bandwidth').'</th>
						<th class="fhead">&nbsp;</th>
						<th class="fhead">'.__('Users').'</th>
						<th class="z-index-1 min_width fhead">
							'.get_checkbox('select_all', '', 'select_all', array('chk_it' => 0), '', 'select_all').'
						</th>
					</tr>';

					foreach($orphan as $k => $v){
						echo '<tr>
						<td>'.$v.'</td>
						<td><input type="text" name="vsbw_'.$v.'" size="8" value="'.POSTval('vsbw_'.$v, '0').'" class="form-control"/></td><td> GB</td>
						<td>
							<select name="vsuser_'.$v.'" class="virt-select">
							<option value="">'.__('None').'</option>';
						
							foreach($users as $uk => $uv){
								echo '<option value="'.$uk.'">'.$uv['email'].'</option>';
							}
					
						echo '</select>
							</td>
							<td width="20" valign="top" align="center">
								'.get_checkbox('vps_list[]', '', '', array('chk_it' => 0), $k).'
							</td>
						</tr>';
					}

					echo '</table></div>

					<br />
					<div class="text-center my-3">
						<input type="submit" name="importvps" value="'.__('Import').'" class="go_btn">
					</div>
				</form>';
		}// End of IF !EMPTY Orphan
	}
	echo 
	'<br/>
	</div>';
	softfooter();
}

// The default theme to show the options
function solusvm_import_theme(){

	global $theme, $globals, $user, $l, $error, $done;
		
		softheader($l['<title>']);

		echo page_header(__('SolusVM Import Wizard'), 'fas fa-upload', '', 0, 0, '');

		$breadcrumbs = ['dashboard', 'lm_pdns', 'lms_solusvm'];

		echo get_breadcrumb($breadcrumbs);

		echo '<div class="card p-2 mx-3">';
		error_handle($error);
	echo '
	<div class="">
		<div class=" row w-100 mx-auto">
		<div class="col-sm-4"></div>
		<div class="col-sm-4 my-1">
			<a href="'.$globals['ind'].'act=import&sa=solusvm&ta=nodes" class="solus_opt"><i class="fas fa-server"></i> &nbsp;'.__('View Nodes').'</a>
		</div>
		<div class="col-sm-4"></div>
		<div class="col-sm-4"></div>
		<div class="col-sm-4 my-1">
			<a href="'.$globals['ind'].'act=import&sa=solusvm&ta=nodegroups" class="solus_opt"><i class="fas fa-server"></i> &nbsp;'.__('Import Node Groups').'</a>
		</div>
		<div class="col-sm-4"></div>
		<div class="col-sm-4"></div>
		<div class="col-sm-4 my-1">
			<a href="'.$globals['ind'].'act=import&sa=solusvm&ta=plans" class="solus_opt"><i class="fas fa-clipboard"></i> &nbsp;'.__('Import Plans').'</a>
		</div>
		<div class="col-sm-4"></div>
		<div class="col-sm-4"></div>
		<div class="col-sm-4 my-1">
			<a href="'.$globals['ind'].'act=import&sa=solusvm&ta=users" class="solus_opt"><i class="fas fa-users"></i> &nbsp;'.__('Import Users').'</a>
		</div>
		<div class="col-sm-4"></div>
		<div class="col-sm-4"></div>
		<div class="col-sm-4 my-1">
			<a href="'.$globals['ind'].'act=import&sa=solusvm&ta=ips" class="solus_opt"><i class="fas fa-upload"></i> &nbsp;'.__('Import IP Pools').'</a>
		</div>
		<div class="col-sm-4"></div>
		<div class="col-sm-4"></div>
		<div class="col-sm-4 my-1">
			<a href="'.$globals['ind'].'act=import&sa=solusvm&ta=os" class="solus_opt"><i class="fas fa-compact-disc"></i> &nbsp;'.__('Import OS Templates').'</a>
		</div>
		<div class="col-sm-4"></div>
		<div class="col-sm-4"></div>
		<div class="col-sm-4 my-1">
			<a href="'.$globals['ind'].'act=import&sa=solusvm&ta=vps" class="solus_opt"><i class="fas fa-cloud-upload-alt"></i> &nbsp;'.__('Import Virtual Server').'</a>
		</div>
	</div>
	<br>
	<div class="notice">'.__('Please go through the <a href="https://www.virtualizor.com/docs/admin/SolusVM_Import_Guide" target="_blank">SolusVM Import Guide</a> before starting to import data').'</div>
	<br><br>';
	softfooter();

}

// Import SolusVM Nodes
function solusvm_nodes_import_theme(){

	global $theme, $globals, $kernel, $user, $l, $error, $servers, $oslist, $done, $vpsid, $orphan, $users, $solusvm_nodes, $virt_solus_servers;
	
	softheader($l['<title>']);

	echo page_header(__('SolusVM and Virtualizor Nodes'), 'fas fa-upload', '', 1);
	echo 
	'<div class="card p-2 mx-3">';
	error_handle($error);
	
	if(!empty($done)){
		show_alert(__('Nodes Successfully Imported into Virtualizor'));
	}else{
			
		echo 
		'<div class="w-100 mx-auto sticky">
			'.get_num_records(count($solusvm_nodes)).'
			<table border="0" width="95%" align="center" class="table table-hover tablesorter">
				<tr>
					<th class="fhead">'.__('Node ID').'</th>
					<th class="fhead">'.__('Node Name').' </th>
					<th class="fhead">'.__('Node IP').' </th>
					<th class="fhead">'.__('Virtualizor Equivalent').'</th>
				</tr>';	
								
				foreach($solusvm_nodes as $k => $v){
					echo '<tr '.(isset($virt_solus_servers[$k]) ? 'class="import-tr-success"' : '').'>
					<td>'.$v['nodeid'].'</td>
					<td>'.$v['name'].'</td>
					<td>'.$v['ip'].'</td>
					<td>'.(!isset($virt_solus_servers[$k]) ? '--' : $servers[$virt_solus_servers[$k]]['server_name'].' (ID : '.$virt_solus_servers[$k].')').'</td>
					</tr>';
				}
		
		echo'</table>
		</div>
			
		<br/><br/>
		<div class="text-center">
			<a href="'.$globals['index'].'act=import&sa=solusvm" class="link_btn">'.__('Back to Wizard').'</a>
		</div>
		<br/><br/>
		<div class="text-center">
			<span class="import-tr-success p-2">'.__('Green rows indicate matching nodes i.e. Virtualizor has been installed on top of SolusVM on those nodes.').'</span>
		</div>
		<br/>';
	}
	echo 
	'</div>';

softfooter();

}

// Import SolusVM Node Groups
function solusvm_nodegroups_import_theme(){

	global $theme, $globals, $kernel, $user, $l, $error, $servers, $done, $v_server_groups, $v_sg_matches, $solusvm_nodes, $solusvm_nodegroups;
	
	softheader($l['<title>']);

	echo page_header(__('SolusVM Node Groups Importer'), 'fas fa-upload');
	echo 
	'<div class="card p-2 mx-3">';
	error_handle($error);
	
	if(!empty($done)){
		show_alert(__('The Node Groups were imported successfully. <a href="index.php?act=import&sa=solusvm">Click here to go back to the wizard.</a>'));
	}else{
		
		// Show the list to be imported
		if(!empty($solusvm_nodegroups)){
			
			echo 
			'<form accept-charset="'.$globals['charset'].'" name="importnodegroups" method="post" action="" class="form-horizontal">
				<div class="w-100 mx-auto sticky">
				'.get_num_records(count($solusvm_nodegroups)).'
					<table border="0" width="95%" align="center" class="table table-hover tablesorter">
						<tr>
							<th class="fhead" width="10%">'.__('IP Block').'</th>
							<th class="fhead">'.__('ID').' </th>
							<th class="fhead">'.__('Group Name').' </th>
							<th class="fhead">'.__('Nodes').' </th>
							<th class="fhead">'.__('Virtualizor Equivalent').' </th>
						</tr>';
						
						foreach($solusvm_nodegroups as $k => $v){
							
							$sgid = -1;
							
							// Is there a matching Group ?
							if(isset($v_sg_matches[$v['name']])){
								$sgid = $v_sg_matches[$v['name']];
							}
							
							echo '<tr>
								<td '.($sgid == -1 ? 'class="import-tr-success"' : '').'>'.$v['name'].'</td>
								<td>'.$v['id'].'</td>
								<td>'.$v['name'].'</td>
								<td>';
								$nodes = array();
								foreach($solusvm_nodes as $nk => $nv){
									if($k == $nv['groupid']){
										$nodes[$nk] = $nv['name'];
									}
								}
								
								echo implode(', ', $nodes).'</td>
								<td>'.($sgid == -1 ? '--' : $v_server_groups[$sgid]['sg_name'].' (ID : '.$sgid.')').'</td>
							</tr>';
							
						}
						echo '
					</table>
				</div>
				<br /><br />
				<div class="text-center my-2">
					<input type="submit" name="solusvm_ng" value="'.__('Import').'" class="go_btn">
				</div>
			</form>
			<br/><br/>
			<div class="text-center">
				<a href="'.$globals['index'].'act=import&sa=solusvm" class="go_btn">'.__('Back to Wizard').'</a>
			</div>
			<br/><br/>
			<div class="text-center">
				<span class="import-tr-success p-2">'.__('Green background indicates Node Groups to be imported').'</span>
			</div>';
			// There are no users
		}else{
			show_alert(__('Nothing to import') ,"2");
			echo '<div class="notice"><b>NOTE : </b>&nbsp; '.__('Nothing to import').'</div>';
		}
	}
	echo '<br /></div>';
	softfooter();
}

// Import SolusVM Plans
function solusvm_plans_import_theme(){

	global $theme, $globals, $kernel, $user, $l, $error, $servers, $done, $v_plans, $v_plans_matches, $solusvm_plans;
		
		softheader($l['<title>']);

		echo page_header(__('Import Plans'), 'fas fa-upload');
		echo '<div class="card p-2 mx-3">';
		error_handle($error);
		
		if(!empty($done)){
			show_alert(__('The plan(s) were imported successfully. <a href="index.php?act=import&sa=solusvm">Click here to go back to the wizard.</a>'));
			//echo '<div class="notice"><b>NOTE : </b>&nbsp; '..'</div>';
		}else{
			
			// Show the list to be imported
			if(!empty($solusvm_plans)){
				
				echo '<form accept-charset="'.$globals['charset'].'" name="importplans" method="post" action="" class="form-horizontal">
				<div class="w-100 mx-auto sticky">
				'.get_num_records(count($solusvm_plans)).'
				<table border="0" width="95%" align="center" class="table table-hover tablesorter">
				<tr>
					<th class="fhead" width="10%">'.__('ID').'</th>
					<th class="fhead">'.__('Plan Name').' </th>
					<th class="fhead">'.__('Type').' </th>
					<th class="fhead">'.__('Ram').' </th>
					<th class="fhead">'.__('Disk').' </th>
					<th class="fhead">'.__('Bandwidth').' </th>
					<th class="fhead">'.__('Virtualizor Equivalent').' </th>
				</tr>';
				
				foreach($solusvm_plans as $k => $v){
					
					$plid = -1;
					
					// Is there a matching Plan ?
					if(isset($v_plans_matches[$v['type'].'-'.$v['name']])){
						$plid = $v_plans_matches[$v['type'].'-'.$v['name']];
					}
					
					echo '<tr '.($plid == -1 ? 'class="import-tr-success"' : '').'>
						<td>'.$v['planid'].'</td>
						<td>'.$v['name'].'</td>
						<td>'.ucfirst($v['type']).'</td>
						<td>'.$v['ram'].' MB</td>
						<td>'.$v['disk'].' GB</td>
						<td>'.$v['bandwidth'].' GB</td>
						<td>'.($plid == -1 ? '--' : $v_plans[$plid]['name'].' (ID : '.$plid.')').'</td>
					</tr>';
					
				}

				echo '
				</table>
				</div>
				<br /><br />
				<center><input type="submit" name="solusvm_plans" value="'.__('Import').'" class="btn" ></center>
				</form>
				<br /><br />
				<center><a href="'.$globals['index'].'act=import&sa=solusvm" class="link_btn">'.__('Back to Wizard').'</a></center>
				<br /><br />
				<center><span class="import-tr-success p-2">'.__('The Green Background means that Virtualizor will import these plans.').'</span></center>';
		
			// There are no users
			}else{
				show_alert(__('Nothing to import') ,"2");
				echo '<div class="notice"><b>NOTE : </b>&nbsp; '.__('Nothing to import').'</div>';
			}

		}
	echo '<br /></div>';
	softfooter();

}

// Import SolusVM users
function solusvm_users_import_theme(){

	global $theme, $globals, $kernel, $user, $l, $error, $oslist, $done, $vpsid, $orphan, $users, $solusvm_users, $u_sol_users, $v_users, $inserted, $info, $no_users;
		
		softheader($l['<title>']);

		echo page_header('SolusVM '.__('Import Users'), 'fas fa-upload');
		echo '<div class="card p-2 mx-3">';
		error_handle($error);
		
		if(!empty($done)){
			show_alert(__('The users were imported successfully. <a href="index.php?act=import&sa=solusvm">Click here to go back to the wizard.</a>'));
			//echo '<div class="notice"><b>NOTE : </b>&nbsp; '..'</div>';
		}else{
			
			// Show the list to be imported
			if(!empty($solusvm_users)){
				
				echo '<form accept-charset="'.$globals['charset'].'" name="importvps" method="post" action="" class="form-horizontal">
				<div class="w-100 mx-auto sticky">
				'.get_num_records(count($solusvm_users)).'
				<table border="0" width="95%" align="center" class="table table-hover tablesorter">
				<tr>
					<th class="fhead">'.__('Users').'</th>
					<th class="fhead">'.__('Email').' </th>
					<th class="fhead">'.__('Type of User').' </th>
					<th class="fhead">'. __('To be Imported ?') .'</th>
				</tr>';
				
				foreach($solusvm_users as $k => $v){
					
					echo '<tr>
						<td width="40%">'.$v['username'].'</td>
						<td>'.(empty($v['emailaddress']) ? '---' : $v['emailaddress']).' </td>
						<td>'.(!empty($v['resellerid']) ? ($v['resellerid'] == $v['clientid'] ? __('Reseller') : __('Sub User')) : __('User')).' </td>
						<td>'. (empty($v['emailaddress']) ? '<font color="red">'.__('No').'</font>'. '<br />' .__('Reason') .': ' .__('No Email') : (in_array($v['emailaddress'], $v_users) ? '<font color="red">'.__('No') .'</font>'.'<br />' .__('Reason') . ': ' .__('User exists in Virtualizor DB')  : $e = '<font color="green">'.__('Yes') .'</font>' )) . '
						
						</td>
					</tr>';
					
				}
				
				/*if(isset($e)){
		
					echo '<tr>
							<td>
								'.__('Send Email to all the users to be imported ?').'
							</td>
							<td>
								<input type="checkbox" name="send_email">
							</td>
						</tr>';
				}*/

				echo '
				</table>
				</div>
				<br /><br />
				<center><input type="submit" name="solusvm_users" value="'.__('Import').'" class="btn" '.(!isset($e) ? ' disabled="1"' : '' ). '></center>
				</form>
				<br /><br />
				<center><a href="'.$globals['index'].'act=import&sa=solusvm" class="link_btn">'.__('Back to Wizard').'</a></center>';
		
			// There are no users
			}else{
				show_alert(__('No users to import') ,"2");
				echo '<div class="notice"><b>NOTE : </b>&nbsp; '.__('No users to import').'</div>';
			}

		}
	echo '<br /></div>';
	softfooter();

}

// Import SolusVM Ip Blocks
function solusvm_ips_import_theme(){

	global $theme, $globals, $kernel, $user, $l, $error, $servers, $oslist, $done, $vpsid, $orphan, $solusvm_nodes, $virt_solus_servers, $v_ippools, $v_ipmatches, $solusvm_ipblocks, $solusvm_ipblocknodes, $show_solusvm_int_ips;
		
		softheader($l['<title>']);

		echo page_header('SolusVM '.__('Import IP Addresses'), 'fas fa-upload');
		echo '<div class="card p-2 mx-3">';
		error_handle($error);
		
		if(!empty($done)){
			show_alert(__('The IP Addresses were imported successfully. <a href="index.php?act=import&sa=solusvm">Click here to go back to the wizard.</a>'));
		}else{
			
			// Show the list to be imported
			if(!empty($solusvm_ipblocks)){
				
				echo '<form accept-charset="'.$globals['charset'].'" name="importips" method="post" action="" class="form-horizontal">
				<div class="w-100 mx-auto sticky">
				'.get_num_records(count($solusvm_ipblocks)).'
				<table border="0" width="95%" align="center" class="table table-hover tablesorter">
				<tr>
					<th class="fhead" width="10">ID</th>
					<th class="fhead" width="10%">'.__('IP Block').'</th>
					<th class="fhead">'.__('Type').' </th>
					<th class="fhead">'.__('Gateway').' </th>
					<th class="fhead">'.__('Netmask').' </th>
					<th class="fhead">'.__('Nameserver(s)').' </th>
					<th class="fhead">'.__('Server Relationship').' </th>
				</tr>';
				
				foreach($solusvm_ipblocks as $k => $v){
							
					// Is there a matching IP pool ?
					$ippid = @$v_ipmatches[$v['name'].'_'.$v['gateway'].'/'.$v['mask']];
					
					echo '<tr>
						<td>'.$k.'</td>
						<td '.(empty($ippid) ? 'class="import-tr-success"' : '').'>'.$v['name'].'</td>
						<td>'.($v['iptype'] == 4 ? 'IPv4' : 'IPv6').'</td>
						<td>'.$v['gateway'].'</td>
						<td>'.$v['mask'].'</td>
						<td>'.$v['nameserver1'].'<br />'.$v['nameserver2'].'</td>
						<td>';
						
						// List the Block Nodes
						if(!empty($solusvm_ipblocknodes[$k])){
							
							echo '<table border="0" width="95%" align="center" class="table table-hover tablesorter">
							<tr>
							<th>SolusVM Node</th>
							<th>Virtualizor Server</th>
							</tr>';
							
							foreach($solusvm_ipblocknodes[$k] as $nk => $nv){
								echo '<tr '.(empty($v_ippools[$ippid]['servers'][$virt_solus_servers[$nk]]) ? ' class="import-tr-success"' : '').'>
								<td>'.$solusvm_nodes[$nk]['name'].'</td>
								<td>'.(empty($servers[$virt_solus_servers[$nk]]['server_name']) ? '--' : $servers[$virt_solus_servers[$nk]]['server_name']).'</td>
								</tr>';
							}
							
							echo '</table>';
						}
						
						echo '</td>
					</tr>';
					
				}
				
				// For internal IPs. This will not be there
				if(!empty($show_solusvm_int_ips)){
					
					echo '<tr>
						<td>'.$k++.'</td>
						<td class="import-tr-success">SolusVM_internal_'.$globals['server'].'</td>
						<td>Internal</td>
						<td>'.$show_solusvm_int_ips['gateway'].'</td>
						<td>'.$show_solusvm_int_ips['netmask'].'</td>
						<td>'.$show_solusvm_int_ips['nameserver1'].'<br />'.$show_solusvm_int_ips['nameserver2'].'</td>
						<td>';
				}
				
				echo '
				</table>
				</div>
				<br /><br />
				<center><input type="submit" name="solusvm_ips" value="'.__('Import').'" class="btn" ></center>
				</form>
				<br /><br />
				<center><a href="'.$globals['index'].'act=import&sa=solusvm" class="link_btn">'.__('Back to Wizard').'</a></center>
				<br /><br />
				<center><span class="import-tr-success p-2">'.__('The Green Background means that Virtualizor will import these objects.').'</span></center>';
		
			// There are no IPs
			}else{
				show_alert(__('Nothing to import'));
				echo '<div class="notice"><b>NOTE : </b>&nbsp; '.__('Nothing to import').'</div>';
			}

		}
	echo '<br /></div>';
	softfooter();

}

// Import SolusVM Templates
function solusvm_os_import_theme(){

	global $theme, $globals, $kernel, $user, $l, $error, $servers, $done, $ostemplates, $oslist, $os_map, $solusvm_templates;
	
	softheader($l['<title>']);

	echo page_header(__('SolusVM Template Importer'), 'fas fa-upload');
	echo '<div class="card p-2 mx-3">';
	error_handle($error);
	
	if(!empty($done)){
		show_alert(__('The OS were imported successfully. <a href="index.php?act=import&sa=solusvm">Click here to go back to the wizard.</a>'));
	}else{
		
		// Show the list to be imported
		if(!empty($solusvm_templates)){
			
			echo '<form accept-charset="'.$globals['charset'].'" name="importos" method="post" action="" class="form-horizontal">
			<div class="w-100 mx-auto sticky">
			<table border="0" width="95%" align="center" class="table table-hover tablesorter">
			<tr>
				<th class="fhead" width="10%">'.__('ID').'</th>
				<th class="fhead">'.__('Template Name').' </th>
				<th class="fhead">'.__('Type').' </th>
				<th class="fhead">'.__('Virtualizor Equivalent').' </th>
			</tr>';
			
			foreach($solusvm_templates as $type => $type_v){
				
				foreach($type_v as $k => $v){
				
					echo '<tr '.(empty($os_map[$v['type']][$v['_filename']]) ? 'class="import-tr-success"' : '').'>
					<td>'.$v['templateid'].'</td>
					<td>'.$v['filename'].'</td>
					<td>'.ucfirst($v['type']).'</td>
					<td>';
					
					if($v['type'] == 'openvz' || $v['type'] == 'xen'){
						echo (empty($os_map[$v['type']][$v['_filename']]) ? '--' : $ostemplates[ $os_map[$v['type']][$v['_filename']] ]['name'].' (ID : '.$os_map[$v['type']][$v['_filename']].')');
					}else{
						
						echo '<select name="'.$v['type'].'_'.$v['templateid'].'" class="virt-select">
						<option value="0">Select</option>';
						
						foreach($ostemplates as $ok => $ov){
							
							$ov['type'] = ($ov['type'] == 'xen' && !empty($ov['hvm'])) ? 'xenhvm' : $ov['type'];
							
							if($ov['type'] != $v['type']){
								continue;
							}
							
							echo '<option value="'.$ok.'" '.($os_map[$v['type']][$v['_filename']] == $ok ? 'selected="selected"' : '').'>'.$ov['name'].'</option>';
							
						}
						
						echo '</select>';
						
					}
					
					echo '</td>
				</tr>';
				
				}
				
			}

			echo '
			</table>
			</div>
			<br /><br />
			<center><input type="submit" name="solusvm_os" value="'.__('Import').'" class="btn" ></center>
			</form>
			<br /><br />
			<center><a href="'.$globals['index'].'act=import&sa=solusvm" class="link_btn">'.__('Back to Wizard').'</a></center>
			<br /><br />
			<center><span class="import-tr-success p-2">'.__('The Green Background means that Virtualizor will import these OS Templates. Those not marked in green are already there in Virtualizor.').'</span></center>
			<br /><br />
			<div class="notice">'.__('Only the templates used for creation of a VPS will be listed here. Unused templates will not be listed here.').'</div>';
	
		// There are no users
		}else{
			show_alert(__('No OS Templates were found in SolusVM') ,"2");
			echo '<div class="notice"><b>NOTE : </b>&nbsp; '.__('No OS Templates were found in SolusVM').'</div>';
		}

	}
	echo '<br /></div>';
	softfooter();

}

// Import SolusVM VPS
function solusvm_vps_import_theme(){

	global $theme, $globals, $kernel, $user, $l, $error, $servers, $done, $v_vps, $v_vps_matches, $solusvm_vps, $solusvm_users;
	
	softheader($l['<title>']);

	echo page_header(__('SolusVM VPS Importer'), 'fas fa-upload');
	echo '<div class="card p-2 mx-3">';
	error_handle($error);
	
	global $vps_success_imp;
	show_vps_imp_succ($vps_success_imp);
	
	if(!empty($done)){
		show_alert(__('The VPS(s) were imported successfully. <a href="index.php?act=import&sa=solusvm">Click here to go back to the wizard.</a>'));
	}else{
		
		// Show the list to be imported
		if(!empty($solusvm_vps)){
			
			echo '<form accept-charset="'.$globals['charset'].'" name="importos" method="post" action="" class="form-horizontal">
			<div class="w-100 mx-auto sticky">
			'.get_num_records(count($solusvm_vps)).'
			<table border="0" width="95%" align="center" class="table table-hover tablesorter">
			<tr>
				<th class="fhead" width="10%">'.__('ID').'</th>
				<th class="fhead">'.__('CTID').' </th>
				<th class="fhead">'.__('Hostname').' </th>
				<th class="fhead">'.__('Type').' </th>
				<th class="fhead">'.__('User').' </th>
				<th class="fhead">'.__('Virtualizor Equivalent').' </th>
				<th class="z-index-1 min_width fhead">
					'.get_checkbox('select_all', '', 'select_all', array('chk_it' => 0), '', 'select_all').'
				</th>
			</tr>';
			
			foreach($solusvm_vps as $k => $v){
				
				$vpsid = empty($v_vps_matches[$v['ctid']]) ? 0 : $v_vps_matches[$v['ctid']];
				
				echo '<tr '.(empty($vpsid) ? 'class="import-tr-success"' : '').'>
					<td>'.$v['vserverid'].'</td>
					<td>'.$v['ctid'].'</td>
					<td>'.$v['hostname'].'</td>
					<td>'.ucfirst($v['type']).'</td>
					<td>'.$solusvm_users[$v['clientid']]['emailaddress'].'</td>
					<td>'.(empty($vpsid) ? '--' : $v_vps[$v_vps_matches[$v['ctid']]]['vps_name'].' (ID : '.$v_vps_matches[$v['ctid']].')').'</td>
					<td width="20" valign="top" align="center">
						'.get_checkbox('vps_list[]', '', '', array('chk_it' => 0), $k).'
					</td>
				</tr>';
				
			}

			echo '
			</table>
			</div>
			<br /><br />
			<center><input type="submit" name="solusvm_vps" value="'.__('Import').'" class="btn"></center>
			</form>
			<br /><br />
			<center><a href="'.$globals['index'].'act=import&sa=solusvm" class="link_btn">'.__('Back to Wizard').'</a></center>
			<br /><br />
			<center><span class="import-tr-success p-2">'.__('The Green Background means that Virtualizor will import these VPS. Those not marked in green are already there in Virtualizor.').'</span></center>
			<br /><br />
			<div class="notice">'.__('Choose the active server in the Top Bar to import VMs of that server').'</div>';
	
		// There are no users
		}else{
			show_alert(__('No VPS were found in this node of SolusVM'));
			echo '<div class="notice"><b>NOTE : </b>&nbsp; '.__('No VPS were found in this node of SolusVM').'</div>';
		}

	}
	echo '<br /></div>';
	softfooter();


}

// The default theme to show the options
// The default theme to show the options
function proxmox_import_theme(){

	global $theme, $globals, $user, $l, $error, $done;
	
	softheader($l['<title>']);

	echo page_header(__('Proxmox Import Wizard'), 'fas fa-upload');

	$breadcrumbs = ['dashboard', 'lm_pdns', 'lms_proxmox'];

	echo get_breadcrumb($breadcrumbs);
	echo 
	'<div class="card p-2 mx-3">';
	error_handle($error);
	echo '
		<div class=" row w-100 mx-auto">
			<div class="col-sm-4"></div>
			<div class="col-sm-4 my-1"><a href="'.$globals['ind'].'act=import&sa=proxmox&ta=nodes" class="solus_opt"><i class="fas fa-server"></i> &nbsp;'.__('View Nodes').'</a></div>
			<div class="col-sm-4"></div>
			<div class="col-sm-4"></div>
			<div class="col-sm-4 my-1"><a href="'.$globals['ind'].'act=import&sa=proxmox&ta=users" class="solus_opt"><i class="fas fa-clipboard"></i> &nbsp;'.__('Import Users').'</a></div>
			<div class="col-sm-4"></div>
			<div class="col-sm-4"></div>
			<div class="col-sm-4 my-1"><a href="'.$globals['ind'].'act=import&sa=proxmox&ta=storages" class="solus_opt"><i class="fas fa-users"></i> &nbsp;'.__('Import Storages').'</a></div>
			<div class="col-sm-4"></div>
			<div class="col-sm-4"></div>
			<div class="col-sm-4 my-1"><a href="'.$globals['ind'].'act=import&sa=proxmox&ta=vps" class="solus_opt"><i class="fas fa-upload"></i> &nbsp;'.__('Import Virtual Server').'</a></div>
			<div class="col-sm-4"></div>
		</div>
		<div class="notice">'.__('Please go through the <a href="https://www.virtualizor.com/docs/admin/Proxmox_Import_Guide" target="_blank">Proxmox Import Guide</a> before starting to import data').'</div>
	</div>';
	softfooter();
}

// Import Feathur Nodes
function proxmox_nodes_import_theme(){

	global $theme, $globals, $kernel, $user, $l, $error, $servers, $oslist, $done, $vpsid, $orphan, $users, $proxmox_nodes, $virt_proxmox_servers;

	softheader($l['<title>']);

	echo page_header(__('Proxmox and Virtualizor Nodes'), 'fas fa-upload');
	echo '<div class="card p-2 mx-3">';
	error_handle($error);
	
	if(!empty($done)){
		show_alert(__('Nodes Successfully Imported into Virtualizor'));
	}else{
			
		echo '<div class="w-100 mx-auto sticky">
		'.get_num_records(count($proxmox_nodes[0])).'
		<table border="0" width="95%" align="center" class="table table-hover tablesorter">
		<tr>
			<th class="fhead">'.__('Node ID').'</th>
			<th class="fhead">'.__('Node Name').' </th>
			<th class="fhead">'.__('Virtualizor Equivalent').'</th>
		</tr>';	
						
		foreach($proxmox_nodes[0] as $k => $v){
			echo '<tr '.(isset($virt_proxmox_servers[$k]) ? 'class="import-tr-success"' : '').'>
			<td>'.$v['id'].'</td>
			<td>'.$v['node'].'</td>
			<td>'.(!isset($virt_proxmox_servers[$k]) ? '--' : $servers[$virt_proxmox_servers[$k]]['server_name'].' (ID : '.$virt_proxmox_servers[$k].')').'</td>
			</tr>';
		}
		
		echo '</table>
			</div>
		<br /><br />
		<center><a href="'.$globals['index'].'act=import&sa=proxmox" class="link_btn">'.__('Back to Wizard').'</a></center>
		<br /><br />
		<center><span class="import-tr-success p-2">'.__('Green rows indicate matching nodes i.e. Virtualizor has been installed on top of Proxmox on those nodes.').'</span></center>';

	}
	echo '<br /></div>';
	softfooter();

}

// Import proxmox users
function proxmox_users_import_theme(){

	global $theme, $globals, $kernel, $user, $l, $error, $oslist, $done, $vpsid, $orphan, $users, $proxmox_users, $u_sol_users, $v_users, $inserted, $info, $no_users;
	
	softheader($l['<title>']);

	echo page_header(__('Import Users'), 'fas fa-upload');
	echo '<div class="card p-2 mx-3">';
	error_handle($error);
	
	if(!empty($done)){
		show_alert(__('The users were imported successfully. <a href="index.php?act=import&sa=proxmox">Click here to go back to the wizard.</a>'));
	}else{
		
		// Show the list to be imported
		if(!empty($proxmox_users)){
			
			echo '<form accept-charset="'.$globals['charset'].'" name="importvps" method="post" action="" class="form-horizontal">
			<div class="w-100 mx-auto sticky">
			'.get_num_records(count($proxmox_users)).'
			<table border="0" width="95%" align="center" class="table table-hover tablesorter">
			<tr>
				<th class="fhead">'.__('Users').'</th>
				<th class="fhead">'.__('Email').' </th>
				<th class="fhead">'.__('Type of User').' </th>
				<th class="fhead">'. __('To be Imported ?') .'</th>
			</tr>';
			
			foreach($proxmox_users as $k => $v){
				
				echo '<tr>
					<td width="40%">'.$v['userid'].'</td>
					<td>'.(empty($v['email']) ? '---' : $v['email']).' </td>
					<td>'.(!empty($v['resellerid']) ? ($v['resellerid'] == $v['clientid'] ? __('Reseller') : __('Sub User')) : __('User')).' </td>
					<td>'. (empty($v['email']) ? '<font color="red">'.__('No').'</font>'. '<br />' .__('Reason') .': ' .__('No Email') : (in_array($v['email'], $v_users) ? '<font color="red">'.__('No') .'</font>'.'<br />' .__('Reason') . ': ' .__('User exists in Virtualizor DB')  : $e = '<font color="green">'.__('Yes') .'</font>' )) . '
					
					</td>
				</tr>';
				
			}
			
			/*if(isset($e)){
	
				echo '<tr>
						<td>
							'.__('Send Email to all the users to be imported ?').'
						</td>
						<td>
							<input type="checkbox" name="send_email">
						</td>
					</tr>';
			}*/

			echo '
			</table>
			</div>
			<br /><br />
			<center><input type="submit" name="proxmox_users" value="'.__('Import').'" class="btn" '.(!isset($e) ? ' disabled="1"' : '' ). '></center>
			</form>
			<br /><br />
			<center><a href="'.$globals['index'].'act=import&sa=proxmox" class="link_btn">'.__('Back to Wizard').'</a></center>
			<br /><br />
			<center>'.__('Choose the active server in the Top Bar to import Users of that server').'</center>';
	
		// There are no users
		}else{
			show_alert(__('No users to import') ,"2");
			echo '<div class="notice"><b>NOTE : </b>&nbsp; '.__('No users to import').'</div>';
		}

	}
	echo '<br /></div>';
	softfooter();

}


// Import proxmox Storages
function proxmox_storages_import_theme(){

	global $theme, $globals, $kernel, $user, $l, $error, $oslist, $done, $vpsid, $orphan, $storages, $proxmox_storages, $u_sol_users, $v_storages, $inserted, $info, $no_users;
	
	softheader($l['<title>']);

	echo page_header(__('Import Storages'), 'fas fa-upload');
	echo '<div class="card p-2 mx-3">';
	error_handle($error);
	
	if(!empty($done)){
		echo '<div class="notice"><b>NOTE : </b>&nbsp; '.__('The storages were imported successfully. <a href="index.php?act=import&sa=proxmox">Click here to go back to the wizard.</a>').'</div>';
	}else{
		
		// Show the list to be imported
		if(!empty($proxmox_storages)){
			
			echo '<form accept-charset="'.$globals['charset'].'" name="importvps" method="post" action="" class="form-horizontal">
			<div class="w-100 mx-auto sticky">
			'.get_num_records(count($proxmox_storages)).'
			<table border="0" width="95%" align="center" class="table table-hover tablesorter">
			<tr>
				<th class="fhead">'.__('Name').'</th>
				<th class="fhead">'.__('Type').' </th>
				<th class="fhead">'.__('To be Imported ?').' </th>
			</tr>';
			
			foreach($proxmox_storages as $k => $v){
				
				echo '<tr>
					<td>'.(empty($v['storage']) ? '---' : $v['storage']).' </td>
					<td>'.(empty($v['type']) ? '---' : $v['type']).' </td>
					<td>'. (empty($v['storage']) ? '<font color="red">'.__('No').'</font>'. '<br />' .__('Reason') .': ' .__('No Email') : (in_array($v['storage'], $v_storages) ? '<font color="red">'.__('No') .'</font>'.'<br />' .__('Reason') . ': ' .__('Storage exists in Virtualizor DB')  : $e = '<font color="green">'.__('Yes') .'</font>' )) . '
					</td>
				</tr>';	
			}
			
			echo '
			</table>
			</div>
			<br /><br />
			<center><input type="submit" name="proxmox_storages" value="'.__('Import').'" class="btn" '.(!isset($e) ? ' disabled="1"' : '' ). '></center>
			</form>
			<br /><br />
			<center><a href="'.$globals['index'].'act=import&sa=proxmox" class="link_btn">'.__('Back to Wizard').'</a></center>
			<br /><br />
			<center>'.__('Choose the active server in the Top Bar to import Storages of that server').'</center>';
	
		// There are no storages
		}else{
			show_alert(__('No storages to import') ,"2");
			echo '<div class="notice"><b>NOTE : </b>&nbsp; '.__('No storages to import').'</div>';
		}

	}
	echo '<br /></div>';
	softfooter();

}


// Import Proxmox VPS
function proxmox_vps_import_theme(){

	global $theme, $globals, $kernel, $user, $l, $error, $servers, $done, $v_vps, $v_vps_matches, $proxmox_vps, $proxmox_users, $users, $importVm;
	
	softheader($l['<title>']);

	echo page_header(__('Proxmox VPS Importer'), 'fas fa-upload');
	echo '<div class="card p-2 mx-3">';
	error_handle($error);
	
	if(!empty($done)){
		show_alert(__('The VPS(s) were imported successfully. <a href="index.php?act=import&sa=proxmox">Click here to go back to the wizard.</a>'));
	}else{
		// Show the list to be imported
		if(!empty($importVm)){
			
			echo '<form accept-charset="'.$globals['charset'].'" name="importos" method="post" action="" class="form-horizontal">
			<div class="w-100 mx-auto sticky">
			'.get_num_records(count($importVm)).'
			<table border="0" width="95%" align="center" class="table table-hover tablesorter">
			<tr>
				<th class="fhead">'.__('CTID').' </th>
				<th class="fhead">'.__('Hostname').' </th>
				<th class="fhead">'.__('Type').' </th>
				<th class="fhead">'.__('Users').' </th>
				<th class="z-index-1 min_width fhead">
					'.get_checkbox('select_all', '', 'select_all', array('chk_it' => 0), '', 'select_all').'
				</th>
			</tr>';
			
			foreach($importVm as $k => $v){
				
				echo '<tr>
					<td>'.$v['vmid'].'</td>
					<td>'.$v['name'].'</td>
					<td>'.ucfirst($v['type'] == 'proxk' ? 'qemu' : ($v['type'] == 'proxl' ? 'lxc' : $v['type'])).'</td>
					<td>
						<select name="vsuser_'.$k.'" class="virt-select">
						<option value="">'.__('None').'</option>';
					
						foreach($users as $uk => $uv){
							echo '<option value="'.$uk.'">'.$uv['email'].'</option>';
						}
					
				echo '</select>
					<td width="20" valign="top" align="center">
						'.get_checkbox('vps_list[]', '', '', array('chk_it' => 0), $k).'
					</td>
				</tr>';
				
			}

			echo '
			</table>
			</div>
			<br /><br />
			<center><input type="submit" name="proxmox_vps" value="'.__('Import').'" class="btn"></center>
			</form>
			<br /><br />
			<center><a href="'.$globals['index'].'act=import&sa=proxmox" class="link_btn">'.__('Back to Wizard').'</a></center>
			<br /><br />
			<div class="notice">'.__('Choose the active server in the Top Bar to import VMs of that server').'</div>';
	
		// There are no users
		}else{
			show_alert(__('No VPS were found in this node of Proxmox') ,"2");
			echo '<div class="notice"><b>NOTE : </b>&nbsp; '.__('No VPS were found in this node of Proxmox').'</div>';
		}

	}

	echo '<br /></div>';
	softfooter();


}

function show_vps_imp_succ($vps_list){
	global $l; 
	
	if(empty($vps_list)){
		return false;
	}
	
	if(!is_array($vps_list)){
		$vps_list = array($vps_list);
	}
	
	if($vps_list){
		$suc_imp_vps_ls = implode('</li><li>', $vps_list);
		echo '<div class="notice"><div class="row px-1">
					<div class="col-sm-12 text-left">
					<h4 class="border-bottom border-success">'.__('Imported following VPS successfully').'</h4>
					<div>
					<ol><li>'.$suc_imp_vps_ls.'</li></ol>
					</div>
				</div>
			</div></div>';
		unset($suc_imp_vps_ls);
	}
	
	return true;
}


?>
