<?php

//////////////////////////////////////////////////////////////
//===========================================================
// editbackupserver_theme.php
//===========================================================
// SOFTACULOUS VIRTUALIZOR
// Version : 1.0
// Inspired by the DESIRE to be the BEST OF ALL
// ----------------------------------------------------------
// Started by: Alons
// Date:       8th Mar 2010
// Time:       23:00 hrs
// Site:       https://www.virtualizor.com/ (SOFTACULOUS VIRTUALIZOR)
// ----------------------------------------------------------
// Please Read the Terms of use at https://www.virtualizor.com
// ----------------------------------------------------------
//===========================================================
// (c)Softaculous Ltd.
//===========================================================
//////////////////////////////////////////////////////////////

if(!defined('VIRTUALIZOR')){

	die('Hacking Attempt');

}

function editbackupserver_theme(){

global $theme, $globals, $kernel, $user, $l, $error, $done, $backup_server;

softheader($l['<title>']);
										
echo page_header(__('Edit Backup Server'), 'icon icon-ippool', '', 0, 0, '');

$breadcrumbs = array('dashboard', 'lm_backupservers', 'edit_backupserver');

echo get_breadcrumb($breadcrumbs);

error_handle($error);

if(!empty($done)){
	show_alert(__('The Backup Server has been saved. Return to <a href="index.php?act=backupservers">Backup Servers Overview</a>'));
}

$data = json_decode($backup_server['dir'], 1);

echo'<script>
let sshpub_key_val = "";
let sshpri_key_val = "";
$(document).ready(function(){

	sshpub_key_val = $("#sshpub_key").val();
	sshpri_key_val = $("#sshpri_key").val();

	toggle_keys_handle({chk_id : "ssh_key", pub_id : "ssh_pub_div", pri_id : "ssh_pri_div"});
	
	$("#ssh_key").click(function(){
		$("#ssh_pub_gen,#ssh_pri_gen").hide();
		$("#credentials").find("#password").val("");
		toggle_keys_handle({chk_id : "ssh_key", pub_id : "ssh_pub_div", pri_id : "ssh_pri_div"});
	});
	
	$("#type").on("change", function(){
		if($(this).val() == "FTP"){
			$("#credentials").show();
			$("#ftps_div").show();
			$("#ssh_key").prop("checked", false);
			$("#sshkeys, #ssh_pub_div, #ssh_pri_div").hide();
			$("#sshpub_key, #sshpri_key").val("");
		}
		if($(this).val() == "SSH"){
			$("#sshkeys").show();
			$("#ftps_div").hide();
		}
		
		if($(this).val() == "s3bucket"){
			$("#ftps_div").hide();
			$("#ssh_key").prop("checked", false);
			$("#sshkeys, #ssh_pub_div, #ssh_pri_div").hide();
			$("#sshpub_key, #sshpri_key").val("");
		}
		
	})
})

function toggle_keys_handle(params){
	if($("#"+params["chk_id"]).is(":checked")){
		$("#credentials").hide();
		$("#"+params["pub_id"]+",#"+params["pri_id"]).show();
		$("#sshpub_key").val(sshpub_key_val);
		$("#sshpri_key").val(sshpri_key_val);
	}else{
		$("#credentials").show();
		$("#"+params["pub_id"]+",#"+params["pri_id"]).hide();
		$("#sshpub_key").val("");
		$("#sshpri_key").val("");
	}
}

function checktype(type){
	
	var type = $("#type").val();
	$(".object_storage").hide();
	$(".servercred").hide();
	var storage_attr = $("#type option:selected").attr("storage_type");
	if(storage_attr == "object"){
		$("#"+type+"_authorize").show();
		$(".servercred").hide();
	}else{
		$(".servercred").show();
	}
}
	
function toggle_pass(toggle_button, pass_field) {
	if($("#"+pass_field).attr("type") == "text"){
		$("#"+pass_field).prop("type", "password");
		$("#"+toggle_button).text("'.__J('Show').'");
	}else{
		$("#"+pass_field).prop("type", "text");
		$("#"+toggle_button).text("'.__J('Hide').'");
	}
}

$(document).ready(function(){
	checktype("'.$backup_server['type'].'");
});
</script> 
<div id="form-container" class="card p-2 mx-3">


<form accept-charset="'.$globals['charset'].'" name="editbackupserver" method="post" action="" class="form-horizontal">

	<div class="row mx-auto w-100 my-3">
		<div class="col-sm-4">
		<label class="control-label">'.__('Name').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Unique name for the Backup Server').'"><i class="fas text-primary fa-info-circle"></i></a></label>
		</div>
		<div class="col-sm-4">
			<input type="text" class="form-control" name="name" id="name" size="30" value="'.POSTval('name', $backup_server['name']).'" />
		</div>
	</div>
	<div class="row mx-auto w-100 my-3">
		<div class="col-sm-4">
			<label class="control-label">'.__('Type').'</label> 
		</div>
		<div class="col-sm-4">
			<select class="custom-select" name="type" id="type" onchange="checktype(this.value)">
				<option value="FTP" '.ex_POSTselect('type', "FTP", $backup_server['type']).' storage_type="file">FTP</option>
				<option value="SSH" '.ex_POSTselect('type', "SSH", $backup_server['type']).' storage_type="file">SSH</option>
				<option value="s3bucket" ' . ex_POSTselect('type', "s3bucket", $backup_server['type']) . ' storage_type="object">S3 Bucket</option>'
				// <option value="gdrive" ' . ex_POSTselect('type', "gdrive", $backup_server['type']) . ' storage_type="object">GOOGLE DRIVE</option>
				// <option value="onedrive" ' . ex_POSTselect('type', "onedrive", $backup_server['type']) . ' storage_type="object">MICROSOFT ONEDRIVE</option>
				// <option value="dropbox" ' . ex_POSTselect('type', "dropbox", $backup_server['type']) . '>DROPBOX</option>';
			.'</select>
		</div>
	</div>
	<div class="row mx-auto w-100 my-3 servercred">
		<div class="col-sm-4">
			<label class="control-label">'.__('Hostname').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Valid TLD or IP Address of the server').'"><i class="fas text-primary fa-info-circle"></i></a></label>
		</div>
		<div class="col-sm-4">
			<input type="text" class="form-control" name="hostname" id="hostname" size="30" value="'.POSTval('hostname', $backup_server['hostname']).'" />
		</div>
	</div>
	<div class="row mx-auto w-100 my-3 servercred">
		<div class="col-sm-4">
			<label class="control-label">'.__('Internal Hostname/IP').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If set then first preference will be given to this Hostname/IP for uploading backups (Optional)').'"><i class="fas text-primary fa-info-circle"></i></a></label>
		</div>
		<div class="col-sm-4">
			<input type="text" class="form-control" name="internal_hostname" id="internal_hostname" size="30" value="'.POSTval('internal_hostname', $backup_server['internal_hostname']).'" />
		</div>
	</div>
	<div class="row mx-auto w-100 my-3" id="ftps_div" '.($backup_server['type'] == 'FTP' ? '' : 'style="display:none;"').'>
		<div class="col-sm-4">
			<label class="control-label">'.__('Use FTP(s)').'&nbsp;</label>
		</div>
		<div class="col-sm-4">
			'.get_checkbox('ftps', '', 'ftps', array('chk_it' => 1, 'val' => $backup_server['ftps']), 1).'
		</div>
		</div>
		<div class="row mx-auto w-100 my-3 servercred" id="sshkeys" '.($backup_server['type'] == 'SSH' ? '' : 'style="display:none"').'>
			<div class="col-sm-4">
			<label class="control-label">'.__('Use SSH key').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If enabled, SSH key will be used for backup server connection instead of password').'"><i class="fas text-primary fa-info-circle"></i></a></label>
		</div>
		<div class="col-sm-4">
			'.get_checkbox('ssh_key', '', 'ssh_key', array('chk_it' => 1, 'val' => $backup_server['ssh_key']), 1).'
		</div>
	</div>
	<div class="row mx-auto w-100 my-3 servercred">
		<div class="col-sm-4">
				<label class="control-label">'.__('Username').'</label>
		</div>
		<div class="col-sm-4">
			<input type="text" class="form-control" name="username" id="username" size="30" value="'.POSTval('username', $backup_server['username']).'" />
		</div>
	</div>
	<div id="credentials">
	<div class="row mx-auto w-100 my-3 servercred">
		<div class="col-sm-4">
			<label class="control-label">'.__('Password').'</label>
		</div>
		<div class="col-sm-4">
			<input type="password" class="form-control" name="password" id="password" size="30" value="'.POSTval('password').'" />
		</div>
	</div>
	</div>
	<div class="row mx-auto w-100 my-3" style="display: none;" name="ssh_pub_div" id="ssh_pub_div">
	<div class="col-sm-4">
	<label class="control-label">'.__('SSH Public Key').'</label>
	</div>
	<div class="col-sm-4">
		<span id="ssh_text" name="ssh_pub_text">
			<textarea  name="sshpub_key" rows="10" class="form-control font-monospace w-100" id="sshpub_key" value="'.POSTval('sshpub_key', $backup_server['sshpub_key']).'">'.base64_decode($backup_server['sshpub_key']).'</textarea>
		</span>
	</div>
	</div>
	<div class="row mx-auto w-100 my-3" style="display: none;" name="ssh_pri_div" id="ssh_pri_div">
	<div class="col-sm-4">
	<label class="control-label">'.__('SSH Private Key').'</label>
	</div>
	<div class="col-sm-4">
		<span id="ssh_text" name="ssh_pri_text">
			<textarea  name="sshpri_key" rows="10" class="form-control font-monospace w-100" id="sshpri_key" value="'.POSTval('sshpri_key', $backup_server['sshpri_key']).'">'.base64_decode($backup_server['sshpri_key']).'</textarea>
		</span>
	</div>
	</div>
	<div class="row mx-auto w-100 my-3 servercred">
		<div class="col-sm-4">
			<label class="control-label">'.__('Port').'</label>
		</div>
		<div class="col-sm-4">
			<input type="number" class="form-control" name="port" id="port" size="30" value="'.POSTval('port', $backup_server['port']).'" />
		</div>
	</div>'.

	//gdrive content
		'<div id="dropbox_authorize" class="object_storage">
			<div class="row mx-auto w-100 my-3">
				<div class="col-sm-8 alert alert-warning">
						<label>'.__('You will be prompted to provide access to your Dropbox on submitting the form').'</label>
				</div>
			</div>
		</div>'.

	//gdrive content
		'<div id="gdrive_authorize" class="object_storage">
			<div class="row mx-auto w-100 my-3">
				<div class="col-sm-8 alert alert-warning">
						<label>'.__('You will be prompted to provide access to your Google Drive on submitting the form').'</label>
				</div>
			</div>
		</div>'.

		//onedrive content
		'<div id="onedrive_authorize" class="object_storage">
			<div class="row mx-auto w-100 my-3">
				<div class="col-sm-8 alert alert-warning">
						<label>'.__('You will be prompted to provide access to your OneDrive on submitting the form').'</label>
				</div>
			</div>
		</div>'.
		
		//s3bucket content
		'<div id="s3bucket_authorize" class="object_storage">
			<div class="row mx-auto w-100 my-3">
				<div class="col-sm-4">
				 <label class="control-label">'.__('S3 Bucket Name').'&nbsp;
				 <br> <span class="text-muted">('.__('Enter the S3 bucket name where you wish to create backups. If the bucket is not present, it will be created automatically<br /> For Bucket Naming Rules <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/bucketnamingrules.html" target="_blank">Click here</a>').')</span></label>
				</div>
				<div class="col-sm-4">
					<input type="text" class="form-control post_data" name="aws_bucketname" id="aws_bucketname" size="30" value="'.POSTval('aws_bucketname', $data['bucketname']).'" />
				</div>
			</div>
			<div class="row mx-auto w-100 my-3">
				<div class="col-sm-4">
				 <label class="control-label">'.__('S3 Endpoint').'&nbsp;
				 <br> <span class="text-muted">('.__('Enter your S3 Endpoint e.g. "s3.amazonaws.com"<br /> For more Information <a href="https://docs.aws.amazon.com/general/latest/gr/s3.html" target="_blank">Click here</a>').')</span></label>
				</div>
				<div class="col-sm-4">
					<input type="text" class="form-control post_data" name="aws_endpoint" id="aws_endpoint" size="30" value="'.POSTval('aws_endpoint', $data['endpoint']).'" />
				</div>
			</div>
			<div class="row mx-auto w-100 my-3">
				<div class="col-sm-4">
				 <label class="control-label">'.__('S3 Region').'&nbsp;
				 <br> <span class="text-muted">('.__('Enter your S3 Region e.g. "us-east-1"<br />  For more Information <a href="https://docs.aws.amazon.com/general/latest/gr/s3.html" target="_blank">Click here</a>').')</span></label>
				</div>
				<div class="col-sm-4">
					<input type="text" class="form-control" name="aws_region" id="aws_region" size="30" value="'.POSTval('aws_region', $data['region']).'" />
				</div>
			</div>
			<div class="row mx-auto w-100 my-3">
				<div class="col-sm-4">
				 <label class="control-label">'.__('S3 Access Key').'&nbsp;
				</div>
				<div class="col-sm-4">
					<input type="text" class="form-control" name="aws_accessKey" id="aws_accessKey" size="30" value="'.POSTval('aws_accessKey', $data['access_token']).'" />
				</div>
			</div>
			<div class="row mx-auto w-100 my-3">
				<div class="col-sm-4">
				 <label class="control-label">'.__('S3 Secret Key').'&nbsp;
				</div>
				<div class="col-sm-4">
					<input type="password" class="form-control" name="aws_secretKey" id="aws_secretKey" size="30" value="'.POSTval('aws_secretKey', $data['secret_token']).'" autocomplete="off"/>
				</div>
				<div class="col-sm-1" style="margin-left:-20px;">
						<input id="aws_toggle_passwd" type="checkbox" style="display:none;" onclick="toggle_pass(\'aws_show_hide\', \'aws_secretKey\');" /><label for="aws_toggle_passwd" style="margin-top:6px;"><span id="aws_show_hide">'.__('Show').'</span></label>
				</div>
			</div>
		</div>
<br /><br />
<center><input type="submit" class="go_btn mt-5" name="editbackupserver" value="'.__('Submit').'"></center>

</form>

</div>';

softfooter();

}

?>
