<?php

//////////////////////////////////////////////////////////////
//===========================================================
// editbackup_plan_theme.php
//===========================================================
// SOFTACULOUS VIRTUALIZOR
// Version : 2.8.1
// Inspired by the DESIRE to be the BEST OF ALL
// ----------------------------------------------------------
// Started by: Husain
// Date:       16th Nov 2015
// Time:       15:20 hrs
// Site:       https://www.virtualizor.com/ (SOFTACULOUS VIRTUALIZOR)
// ----------------------------------------------------------
// Please Read the Terms of use at https://www.virtualizor.com
// ----------------------------------------------------------
//===========================================================
// (c)Softaculous Ltd.
//===========================================================
//////////////////////////////////////////////////////////////

if(!defined('VIRTUALIZOR')){

	die('Hacking Attempt');

}

function editbackup_plan_theme(){

global $theme, $globals, $kernel, $user, $l, $error, $backup_plan, $backupservers, $done, $servers, $vpses, $bpid, $servergroups;

softheader($l['<title>']);
					
echo page_header(__('Edit Backup Plan'), 'fas fa-clipboard', '', 1, 0, '');

$breadcrumbs = array( 'dashboard', 'backup_plans', 'lms_editbackup_plan');

echo get_breadcrumb($breadcrumbs);

echo '<div class="mx-3 mb-3 mt-0 notice"><b>'.__('Note').' </b> &nbsp; '.__('Incremental backups are supported on KVM, Virtuozzo machines only, For other kernels we will take full backups! It requires Backuply License on the respective nodes where the VPS exists.').'</div>
<div class="card p-2 mx-3">';

error_handle($error);

if(!empty($done)){
	if(isset($_POST['backup_now'])){
		animate_task(__('Backup now task started'));
	}
	show_alert($done);
}

$data_decode = json_decode($backup_plan['data'], 1);
echo '<script type="text/javascript" charset="utf8" src="'.$theme['url'].'/js/cronstrue.min.js"></script>
<script language="javascript" type="text/javascript">
	let selected_cron_type = new Object();
	$(document).ready(function(){';
		
		$cron_time = '';
		if(in_array($backup_plan['frequency'], array('daily', 'weekly', 'monthly', 'hourly'))){
			$cron_time = convert_to_cron($bpid);
		}

		if(!empty($cron_time)){
			echo '$("#backup_scheme").val("always_full"); $("#backup_scheme").trigger("change");';
		}

		if(!empty($data_decode["selected_cron_type"])){
			echo 'selected_cron_type = JSON.parse(\''.json_encode($data_decode["selected_cron_type"]).'\');';
		}

		if(!empty($_POST['selected_cron_type'])){
			echo 'selected_cron_type = JSON.parse(\''.htmlspecialchars_decode($_POST['selected_cron_type']).'\');';
		}
		$cron_post = array(
			'always_cronjob',
			'weekly_full_cronjob',
			'weekly_daily_inc_cronjob',
			'monthly_full_cronjob',
			'weekly_diff_cronjob',
			'weekly_diff_daily_inc_cronjob',
			'custom_full_cronjob',
			'custom_diff_cronjob',
			'custom_inc_cronjob',
		);
		foreach($cron_post as $post){
			if(!empty($_POST[$post])){
				echo '$(".'.$post.'").html(convert_to_msg("'.$_POST[$post].'"));';
			}
		}
		
		if(!empty($backup_plan['bid'])){
			echo '$("#tr_backup_servers").show();
				  $("#tr_local_dir").show();';
			if($backupservers[$backup_plan['bid']]['type'] == 'FTP'){
				echo '$("#type").val("FTP");';
			}else if($backupservers[$backup_plan['bid']]['type'] == 'SSH'){
				echo '$("#type").val("SSH");';
			}else if($backupservers[$backup_plan['bid']]['type'] == 'dropbox'){
				echo '$("#type").val("dropbox");';
			}else if($backupservers[$backup_plan['bid']]['type'] == 'gdrive'){
				echo '$("#type").val("gdrive");';
			}else if($backupservers[$backup_plan['bid']]['type'] == 'onedrive'){
				echo '$("#type").val("onedrive");';
			}else if($backupservers[$backup_plan['bid']]['type'] == 's3bucket'){
				echo '$("#type").val("s3bucket");';
			}
		}else{
			echo '$("#tr_backup_servers").hide();
				$("#tr_local_dir").show();
				$("#type").val("LOCAL");';
		}
		
		echo '
		handle_backup_scheme()
		handle_manual_option()
		handle_legacy_option()
		$("input:radio").change(function(event){
			$("#months, #dates, #days, #hrs, #mins").trigger("reset");
			$("#converted_cron").text("");
			$(".chosen, #months, #dates, #days").select2({
				"width" : "100%"
			});
			get_cron_msg();
			selected_cron_type[clicked_name] = event.target.value;
			if(!empty(selected_cron_type)){
				$("#selected_cron_type").val(JSON.stringify(selected_cron_type));
			}
			if(event.target.value == "weekly"){
				$("#backupday_tr").show();
				$("#backupdate_tr").hide();
				$("#tr_time").show();
				$("#backuphourly_tr").hide();
				$("#backupmonth_tr").hide();
			}else if(event.target.value == "monthly"){
				$("#backupdate_tr").show();
				$("#backupmonth_tr").show();
				$("#backupday_tr").hide();
				$("#tr_time").show();
				$("#backuphourly_tr").hide();
			}else if(event.target.value == "daily"){
				$("#backupdate_tr").hide();
				$("#backupday_tr").hide();
				$("#tr_time").show();
				$("#backuphourly_tr").hide();
				$("#backupmonth_tr").hide();
			}else if(event.target.value == "hourly"){
				$("#backupdate_tr").hide();
				$("#backupday_tr").hide();
				$("#tr_time").hide();
				$("#backuphourly_tr").show();
				$("#backupmonth_tr").hide();
			}else{
				$("#backupdate_tr").hide();
				$("#backupday_tr").hide();
				$("#tr_time").hide();
				$("#backuphourly_tr").hide();
				$("#backupmonth_tr").hide();
			}
		});

		$("#type").change(function(data){
			handle_type()
		});
		
		refresh_tasks();
		get_cron_msg();
		
		// Refresh tasks every 10 secs
		setInterval(refresh_tasks, 10000);
	});

	function toggle_advoptions(ele){
			
		var div_ele = $("#"+ele+"_advoptions");
		
		if (div_ele.is(":hidden")){
			$("#"+ele+"_advoptions_ind").text(" - ");
			div_ele.slideDown("slow");
		}
		else{
			$("#"+ele+"_advoptions_ind").text(" + ");
			div_ele.slideUp("slow");
		}
	}

	function handle_type(){
		$("#backup_scheme").val(0)
		$("#backup_scheme").trigger("change")
		if($("#type").val() == "LOCAL"){
			$("#tr_backup_servers").hide();
			$(".remote").hide();
			$(".local").show();
		}else{
			$("#bid").val(0);
			$("#tr_backup_servers").show();
			$(".local").hide();
			$(".remote").show();
		}
		handle_manual_option();
	}
	let expression = "";
	let clicked_name = "";
	let expression_description = "";
	function get_cron_msg(){

		if($("#freqm").prop("checked") == true){

			let months = new Array();
			let dates = new Array();

			if(!empty($("#months").val())){
				if(Object.values($("#months").val()).indexOf("1-12") > -1){
					$("#months").val("").val("1-12").select2({width : "100%"})
					months = "1-12";
				}else{
					months = Object.values($("#months").val()).join(",");
				}
			}

			if(!empty($("#dates").val())){
				if(Object.values($("#dates").val()).indexOf("1-31") > -1){
					$("#dates").val("").val("1-31").select2({width : "100%"})
					dates = "1-31";
				}else{
					dates = Object.values($("#dates").val()).join(",");
				}
			}

			if(empty(months)){
				months = "*";
			}

			if(empty(dates)){
				dates = "*";
			}

			let hrs = $("#hrs").val();
			let mins = $("#min").val();
			expression = mins+" "+hrs+" "+dates+" "+months+" *";

		}
		if($("#freqw").prop("checked") == true){

			let days = "";

			if($("#days").val() != null){
				if(Object.values($("#days").val()).indexOf("1-7") > -1){
					$("#days").val("").val("1-7").select2({width : "100%"})
					days = "1-7";
				}else{
					days = Object.values($("#days").val()).join(",");
				}
			}

			if(days == ""){
				days = "*";
			}

			let hrs = $("#hrs").val();
			let mins = $("#min").val();
			expression = mins+" "+hrs+" * * "+days;
		}
		if($("#freqd").prop("checked") == true){

			let hrs = $("#hrs").val();
			let mins = $("#min").val();
			expression = mins+" "+hrs+" * * *";

		}
		if($("#freqh").prop("checked") == true){
			let hourly_freq = $("#hourly_freq").val();
			expression = "00 */"+hourly_freq+" * * *";
		}

		expression_description = convert_to_msg(expression);
		$("#converted_cron").text(expression_description);

	}

	function convert_to_msg(exp){
		return cronstrue.toString(exp, { throwExceptionOnParseError: false });
	}

	function handle_backup_scheme(){

		if($("#freq").prop("checked")){
			$("#always_cron_div, #weekly_cron_div, #weekly_daily_inc_cron_div, #monthly_full_div, #weekly_diff_div, #weekly_diff_daily_inc_div, #custom_full_div, #custom_inc_div, #custom_diff_div").hide();
			return false;
		}
		
		if($("#backup_scheme").val() == "always_incremental" || $("#backup_scheme").val() == "always_full"){
			$("#always_cron_div").show();
		}else{
			$("#always_cron_div").hide();
		}

		if($("#backup_scheme").val() == "weekly_full_daily_incremental"){
			$("#weekly_cron_div, #weekly_daily_inc_cron_div").show();
		}else{
			$("#weekly_cron_div, #weekly_daily_inc_cron_div").hide();
		}

		if($("#backup_scheme").val() == "monthly_full_weekly_diff_daily_incremental"){
			$("#monthly_full_div, #weekly_diff_div, #weekly_diff_daily_inc_div").show();
		}else{
			$("#monthly_full_div, #weekly_diff_div, #weekly_diff_daily_inc_div").hide();
		}

		if($("#backup_scheme").val() == "custom"){
			$("#custom_full_div, #custom_inc_div, #custom_diff_div").show();
		}else{
			$("#custom_full_div, #custom_inc_div, #custom_diff_div").hide();
		}
			
	}

	function add_cron_job(ele){

		let _ele = ele;
		clicked_name = $(ele).attr("name");
		let cron_val = "";
		if(!empty($(ele).val())){
			cron_val = $(ele).val().split(" ")
		}
		
		$("#cron_job").trigger("reset");
		$("#converted_cron").text("");
		$(".chosen, #months, #dates, #days").select2({
			"width" : "100%"
		});
		$("#backupdate_tr").hide();
		$("#backupday_tr").hide();
		$("#tr_time").hide();
		$("#backuphourly_tr").hide();
		$("#backupmonth_tr").hide();

		$("#freqm_div, #freqw_div, #freqd_div, #freqh_div").show();
		if($(ele).attr("name") == "weekly_daily_inc_cronjob"){
			$("#freqm_div, #freqw_div, #freqh_div").hide();
			$("#freqd").trigger("click");
		}

		if($(ele).attr("name") == "weekly_full_cronjob"){
			$("#freqm_div, #freqd_div, #freqh_div").hide();
			$("#freqw").trigger("click");
		}

		if($(ele).attr("name") == "monthly_full_cronjob"){
			$("#freqw_div, #freqd_div, #freqh_div").hide();
			$("#freqm").trigger("click");
		}

		if($(ele).attr("name") == "weekly_diff_cronjob"){
			$("#freqm_div, #freqd_div, #freqh_div").hide();
			$("#freqw").trigger("click");
		}

		if($(ele).attr("name") == "weekly_diff_daily_inc_cronjob"){
			$("#freqw_div, #freqm_div, #freqh_div").hide();
			$("#freqd").trigger("click");
		}

		if(!empty(cron_val) && !empty(selected_cron_type[clicked_name])){
			if(selected_cron_type[clicked_name] == "monthly"){
				$("#freqm").trigger("click");
				$("#months").val(cron_val[3].split(",")).select2({"width" : "100%"});
				$("#dates").val(cron_val[2].split(",")).select2({"width" : "100%"});
				$("#hrs").val(cron_val[1]);
				$("#min").val(cron_val[0]);
			}else if(selected_cron_type[clicked_name] == "weekly"){
				$("#freqw").trigger("click");
				$("#days").val(cron_val[4].split(",")).select2({"width" : "100%"});
				$("#hrs").val(cron_val[1]);
				$("#min").val(cron_val[0]);
			}else if(selected_cron_type[clicked_name] == "daily"){
				$("#freqd").trigger("click");
				$("#hrs").val(cron_val[1]);
				$("#min").val(cron_val[0]);
			}else if(selected_cron_type[clicked_name] == "hourly"){
				$("#freqh").trigger("click");
				var tmp = cron_val[1].split("/");
				$("#hourly_freq").val(tmp[1]);
			}
			get_cron_msg();
		}

		$("#cronModal").modal();
		
		$("#create_cron").unbind().click(function(){
			_ele.val(expression);
			$("."+clicked_name).html(expression_description);
			$("#cronModal").modal("hide");
			handle_backup_scheme()
		});
		
	}

	function trigger_full(){
		$(".local").hide();
		$(".manual").show();
		$("#backup_scheme").val("always_full").trigger("change");
	}
	function handle_manual_option(){
		if($("#freq").prop("checked")){
			trigger_full()
		}else{
			if($("#enable_legacy_backup").prop("checked")){
				trigger_full()
			}else{
				$(".local").show();
				handle_backup_scheme()
			}
			
		}
	}

	function handle_legacy_option(){
		if($("#enable_legacy_backup").prop("checked")){
			trigger_full()
		}else{
			if($("#freq").prop("checked")){
				trigger_full()
			}else{
				$(".local").show();
			}
		}
	}

	function apply_roation_val(op){
		var val = parseInt($("#backup_rotation").val());

		if(op == 1){
			var new_val = val+1;
			if(new_val <= '.(empty($globals['backup_rotation_count']) ? 10 : (int) $globals['backup_rotation_count']).'){
				$("#backup_rotation").val(new_val);
			}
		}else{
			var new_val = val-1;
			if(new_val >= 0){
				$("#backup_rotation").val(new_val);
			}
		}
	}
	
	function refresh_tasks() {
		var cols = new Object();
		cols["actid"] = {"l" : "'.__J('Actid').'", "centered" : true};
		cols["vpsid"] = {"l" : "'.__J('VPS ID').'", "centered" : true};
		cols["user"] = {"l" : "'.__J('User').'", "centered" : true};
		cols["server"] = {"l" : "'.__J('Server').' '.'('.__J('ID').')", "centered" : true};
		cols["started"] = {"l" : "'.__J('Started').'", width: 100, "centered" : true};
		cols["updated"] = {"l" : "'.__J('Updated').'", width: 100, "centered" : true};
		cols["ended"] = {"l" : "'.__J('Ended').'", width: 100, "centered" : true};
		cols["action_txt"] = {"l" : "'.__J('Action').'", width: 100};
		cols["status_txt"] = {"l" : "'.__J('KYC Status').'", width: 200};
		cols["progress"] = {"l" : "'.__J('Progress').'"};
		cols["logs"] = {"l" : "'.__J('View Logs').'", "centered" : true};';
		
		$vpsids = array_keys($vpses);
		
		echo '$.ajax({
			type: "GET",
			url: "'.$globals['index'].'act=tasks&vpsid='.implode(',', $vpsids).'&action=vpsbackups_plan,restorevps_plan,backuply_vpsbackups_plan,backuply_restorevps_plan&api=json&page=0&reslen=50",
			dataType : "json",
			success: function(data){
				
				if(empty(data["tasks"])) {
					// Show no tasks note if table empty
					$("#table_tasks_container").html("<div class=\"notice\"><b>'.__J('Note').' : </b> &nbsp; '.__J('No Tasks Running').'</div>");
					return;
				}
				
				var rows = Array();
				
				$.each(data["tasks"], function(k, task) {
					
					rows[k] = new Object();
					rows[k]["actid"] = task["actid"];
					rows[k]["vpsid"] = task["vpsid"];
					rows[k]["user"] = empty(task["uid"]) ? "root" : task["email"];
					rows[k]["server"] = task["server_name"] + "(" + task["serid"] + ")";
					rows[k]["started"] = task["started"];
					rows[k]["updated"] = task["updated"];
					rows[k]["ended"] = task["ended"];
					rows[k]["action_txt"] = task["action_txt"];
					rows[k]["status_txt"] = task["status_txt"];
					rows[k]["progress"] = "<div class=\"progress-cont\" id=\"progress-cont"+task["actid"]+"\"><center><div class=\"text-center h6\" id=\"pbar"+task["actid"]+"\">"+task["progress"]+"%</center><div class=\"progress\"><div class=\"progress-bar bg-primary progress-bar-striped progress-bar-animated\" id=\"progressbar"+task["actid"]+"\"></div></div>";
					rows[k]["logs"] = "<button class=\"btn px-2 py-1\" onclick=\"loadlogs("+task["actid"]+");\">'.__J('Show').'</button>";
					
				});
				
				rows.sort(function(a, b){
					a = parseInt(a["actid"]);
					b = parseInt(b["actid"]);
					if(a < b) return 1;
					if(a > b) return -1;
					return 0;
				});
				
				table({"id" : "table_tasks_container", "tid" : "table_tasks", "width" : "100%"}, cols, rows);
				
				$.each(data["tasks"], function(index, task) {
					
					if(task["progress"] == 100){
						$("#status"+index).text("'.__J('COMPLETED').'");
						$("#pbar"+index).text("100% '.__J('COMPLETED').' !");
						$("#progressbar"+index).hide();
						$("#progressbar"+index).parent().css("border", "0px");
						$("#progressbar"+index).parent().removeClass("progress");
					}else if(task["status"] == -1){
						$("#status"+index).html(task["status_txt"]);
						$("#pbar"+index).text("'.__J('Task Not Completed').'");
						$("#progressbar"+index).hide();
						$("#progressbar"+index).parent().css("border", "0px");
						$("#progressbar"+index).parent().removeClass("progress");
					}else {
						
						if(isNaN(task["progress"])){
							$("#pbar"+index).text(task["progress"]);
							$("#progressbar"+index).hide();
						}else{
							make_progress(index, Number(task["progress"]));
							$("#progressbar"+index).show();
						}
					}
					
				});
				
			}
		});
	}

	function make_progress(index, progress){
		var steps = 20;
		var start = $("#pbar"+index).text();
		start = (start.slice(0, -1));
		if(isNaN(start)){
			start = 0;
		}
		var step = (progress - start)/steps;
		if(step < 0){ step = 0;}
		var increment = function(){
			var val = $("#pbar"+index).text();
			val = Number(val.slice(0, - 1));
			prog = parseInt(val + Math.round(step));
			//alert("progr"+prog);
			if(prog > progress){ prog = progress;}
			if(prog < parseInt("100")){
				$("#pbar"+index).text(prog + "%");
				$("#progressbar"+index).width(prog + "%");
			}else{
				$("#progressbar"+index).width(100 + "%");
			}
			if (prog < progress){setTimeout(increment, 500);}
		};
		increment();
	};
	
	function toggle_advoptions(ele){
		
		var div_ele = $("#"+ele+"_advoptions");

		if (div_ele.is(":hidden")){
			$("#"+ele+"_advoptions_ind").text(" - ");
			div_ele.slideDown("slow");
		}
		else{
			$("#"+ele+"_advoptions_ind").text(" + ");
			div_ele.slideUp("slow");
		}
	}

	function filter_bservers(val){
		$(".bservers").hide();
		$("."+val).show();
	};
	
</script>
<style>
.vps_table th{
width:auto !important; padding:5px 5px !important;
vertical-align:middle !important;
postion:sticky;
top:0px;
}
</style>
<style type="text/css">

.panel {
	min-height: 120px;
}
.panel-content {
	max-height: 400px;
	overflow: hidden;
}

.table-dash {
	margin-bottom: 4px;
}
.table-dash tbody tr td {
	vertical-align: middle;
}
.table-dash tr td:first-child, .table-dash tr th:first-child {
	padding-left: 16px;
}
.table-dash tr td:last-child, .table-dash tr th:last-child {
	padding-right: 16px;
}
.btn-logs {
	margin: 0;
	padding: 4px 8px;
	font-size: 12px;
}

</style>
	<!--Modal started -->
	<div class="modal fade" id="cronModal" tabindex="-1" aria-labelledby="cronjob" aria-hidden="true">
		<div class="modal-dialog modal-lg">
			<div class="modal-content">
				<div class="modal-header">
					<h5 class="modal-title" id="cronjob">'.__('Add Cron Job').'</h5>
					<button type="button" class="close text-always-white" data-dismiss="modal">×</button>
				</div>
				<div class="modal-body">
					<span class="h5 m-0 font-italic" id="converted_cron"></span>
					<form id="cron_job">
						<div class="my-3">
						<div class="form-group r-pill">
								<div class="r-pill__group mb-3">
										<span class="r-pill__item" id="freqm_div">
											<input type="radio" class="ssh_options" id="freqm" name="freq" value="monthly" '.POSTradio('freq', 'monthly').'>
											<label for="freq" class="m-0">'.__('Monthly').'</label>
										</span>
										<span class="r-pill__item">
											<input type="radio" class="custom-control-input" id="freqw" name="freq" value="weekly" '.POSTradio('freq', 'weekly').'>
											<label for="freq" class="m-0">'.__('Weekly').'</label>
										</span>
										<span class="r-pill__item">
											<input type="radio" class="custom-control-input" id="freqd" name="freq" value="daily" '.POSTradio('freq', 'daily').'>
											<label for="freq" class="m-0">'.__('Daily').'</label>
										</span>
										<span class="r-pill__item">
											<input type="radio" class="custom-control-input" id="freqh" name="freq" value="hourly" '.POSTradio('freq', 'hourly').'>
											<label for="freq" class="m-0">'.__('Hourly').'</label>
										</span>
								</div>
							</div>
						</div>
						<div class="row mx-auto w-100 my-3" id="backuphourly_tr" style="display:none">
							<div class="col-sm-6">
								<label class="control-label">'.__('Run the backup process every').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('The hourly backup frequency').'"><i class="fas text-primary fa-info-circle"></i></a></label>
							</div>
							<div class="col-sm-6">
								<select class="custom-select w-50" name="hourly_freq" id="hourly_freq" onchange="get_cron_msg()">';
									for($i=0;$i<24;$i++){
										echo '<option value="'.($i < 10 ? '0'.$i : $i).'" '.POSTselect('hourly_freq', $i).' >'.($i < 10 ? '0'.$i : $i).'</option>';
									}
							echo'</select><label class="p-2">'.__('Hours').'</label>
							</div>
						</div>		
						<div class="row mx-auto w-100 my-3" id="backupday_tr" style="display:none;">
							<div class="col-sm-6">
								<label class="control-label">'.__('Backup Day').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Designated day on which the backup will run').'"><i class="fas text-primary fa-info-circle"></i></a></label>
							</div>
							<div class="col-sm-6">
								<select class="custom-select" multiple="multiple" name="day" id="days" onchange="get_cron_msg()">
									<option value="0-6" >'.__('All Days').'</option>
									<option value="0" '.POSTselect('day', "0").' >'.__('Sunday').'</option>
									<option value="1" '.POSTselect('day', "1").' >'.__('Monday').'</option>
									<option value="2" '.POSTselect('day', "2").' >'.__('Tuesday').'</option>
									<option value="3" '.POSTselect('day', "3").' >'.__('Wednesday').'</option>
									<option value="4" '.POSTselect('day', "4").' >'.__('Thursday').'</option>
									<option value="5" '.POSTselect('day', "5").' >'.__('Friday').'</option>
									<option value="6" '.POSTselect('day', "6").' >'.__('Saturday').'</option>
								</select>
							</div>
						</div>
						<div class="row mx-auto w-100 my-3" id="backupmonth_tr" style="display:none;">
							<div class="col-sm-6">
								<label class="control-label">'.__('Backup Month').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Designated day of the month on which the backup will run').'"><i class="fas text-primary fa-info-circle"></i></a></label>
							</div>
							<div class="col-sm-6">
								<select name="months" multiple="multiple" class="custom-select" id="months" onchange="get_cron_msg()">';
								echo '<option value="1-12" >'.__('All Months').'</option>';
								for($i=1;$i<=12;$i++){
									echo '<option value="'.$i.'" '.POSTselect('months', $i).' >'.$i.'</option>';
								}
							echo '</select>
							</div>
						</div>
						<div class="row mx-auto w-100 my-3" id="backupdate_tr" style="display:none;">
							<div class="col-sm-6">
								<label class="control-label">'.__('Backup Date').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Designated day of the month on which the backup will run').'"><i class="fas text-primary fa-info-circle"></i></a></label>
							</div>
							<div class="col-sm-6">
								<select name="date" multiple="multiple" class="custom-select" id="dates" onchange="get_cron_msg()">';
								echo '<option value="1-31" >'.__('All Dates').'</option>';
								for($i=1;$i<32;$i++){
									echo '<option value="'.$i.'" '.POSTselect('date', $i).' >'.$i.'</option>';
								}
							echo '</select>
							</div>
						</div>
						<div class="row mx-auto w-100 my-3" id="tr_time" style="display:none;">
							<div class="col-sm-6">
								<label class="control-label">'.__('Time').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('The time at which the backup process will begin').'"><i class="fas text-primary fa-info-circle"></i></a></label>
							</div>
							<div class="col-sm-6">
								<select class="custom-select w-25 p-1 float-left" name="hrs" id="hrs" onchange="get_cron_msg()">';
								for($i=0;$i<24;$i++){
									echo '<option value="'.($i < 10 ? '0'.$i : $i).'" '.POSTselect('hrs', $i).' >'.($i < 10 ? '0'.$i : $i).'</option>';
								}
							echo '</select>
								<label class="side_lbl">'.__('Hours').'</label>
								<select class="custom-select w-25 p-1 float-left" name="min" id="min" onchange="get_cron_msg()">';
									for($i=0;$i<60;$i++){
										echo '<option value="'.($i < 10 ? '0'.$i : $i).'" '.POSTselect('min', $i).' >'.($i < 10 ? '0'.$i : $i).'</option>';
									}
							echo '</select><label class="side_lbl">'.__('Minutes').'</label>
							</div>
						</div>

						<input type="button" value="'.__('Add Cron Job').'" name="create_cron" class="go_btn" id="create_cron" />
					</form>
				</div>
			</div>
		</div>
	</div>
	<!--Modal end -->
	<form accept-charset="'.$globals['charset'].'" name="editbackup_plan" method="post" action="" class="form-horizontal">

		<div class="roundheader cursor-pointer" onclick="toggle_advoptions(\'general\');"><label id="general_advoptions_ind" class="min_width">-</label> &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;General Settings
		</div>
		<div id="general_advoptions" class="">
			<div class="row mx-auto w-100 my-1">
				<div class="col-sm-12 col-md-12 col-lg-6 border-right">
					<div class="row mx-auto w-100 my-3">
						<div class="col-sm-6">
							<label class="control-label">'.__('Disable').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Disable this backup plan').'"><i class="fas text-primary fa-info-circle"></i></a></label>
						</div>
						<div class="col-sm-6">
							'.get_checkbox('disabled', '', 'disabled', array('chk_it' => 1, 'val' => $backup_plan['disabled'])).'
						</div>
					</div>
					<div class="row mx-auto w-100 my-3">
						<div class="col-6">
							<label class="control-label">'.__('Disable Suspended VPS').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If checked, backup of suspended VPS will not be taken').'"><i class="fas text-primary fa-info-circle"></i></a></label>
						</div>
						<div class="col-6">
							'.get_checkbox('disable_suspended_vm', '', 'disable_suspended_vm', array('chk_it' => 1, 'val' => $data_decode['disable_suspended_vm'])).'
						</div>
					</div>
					<div class="row mx-auto w-100 my-3">
						<div class="col-sm-6">
							<label class="control-label">'.__('Plan Name').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('The name of this plan').'"><i class="fas text-primary fa-info-circle"></i></a></label>
						</div>
						<div class="col-sm-6">
							<input type="text" class="form-control" name="plan_name" id="plan_name" value="'.POSTval('plan_name', $backup_plan['plan_name']).'" />
						</div>
					</div>
					<div class="row mx-auto w-100 my-3">
						<div class="col-sm-6">
							<label class="control-label">'.__('Backup Type').'</label><br />
						</div>
						<div class="col-sm-6">
							<select id="type" class="custom-select" name="type" onchange="filter_bservers(this.value);">
								<option value="LOCAL" '.($backup_plan['bid'] == 0 ? 'selected=selected' : "").'>Local</option>
								<option value="FTP" '.($backup_plan['bid'] != 0 && $backupservers[$backup_plan['bid']]['type'] == 'FTP' ? 'selected=selected' : "").'>FTP</option>
								<option value="SSH" '.($backup_plan['bid'] != 0 && $backupservers[$backup_plan['bid']]['type'] == 'SSH' ? 'selected=selected' : "").'>SSH</option>
								<option value="s3bucket" '.($backup_plan['bid'] != 0 && $backupservers[$backup_plan['bid']]['type'] == 's3bucket' ? 'selected=selected' : "").'>S3</option>'
								// <option value="gdrive" '.($backup_plan['bid'] != 0 && $backupservers[$backup_plan['bid']]['type'] == 'gdrive' ? 'selected=selected' : "").'>Google Drive</option>
								// <option value="onedrive" '.($backup_plan['bid'] != 0 && $backupservers[$backup_plan['bid']]['type'] == 'onedrive' ? 'selected=selected' : "").'>One Drive</option>
								// <option value="dropbox" '.($backup_plan['bid'] != 0 && $backupservers[$backup_plan['bid']]['type'] == 'dropbox' ? 'selected=selected' : "").'>Dropbox</option>';		
							.'</select>
						</div>
					</div>
					<div class="row mx-auto w-100 my-3" id="tr_backup_servers" style="display:none">
						<div class="col-sm-6">
							<label class="control-label">'.__('Backup Server').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('The server on which backups will be saved').'"><i class="fas text-primary fa-info-circle"></i></a></label>
						</div>
						<div class="col-sm-6">
							<select class="custom-select" name="id" id="bid">
							<option value="0" '.(ex_POSTselect('id', 0, $backup_plan['bid'])).'>---</option>';
							foreach($backupservers as $k => $v){
								echo '<option class="bservers '.$v['type'].'" value="'.$v['bid'].'" '.ex_POSTselect('id', $v['bid'], $backup_plan['bid']).'>'.$v['name'].'</option>';
							}
						echo '</select>
						</div>
					</div>
					<div class="row mx-auto w-100 my-3">
						<div class="col-sm-6">
							<label class="control-label">'.__('Enable Manual Backup').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If enabled then backup will not start automatically, but it will follow the same pattern as backup scheme on manual backup').'"><i class="fas text-primary fa-info-circle"></i></a></label>
						</div>
						<div class="col-sm-6">';
						$arr['chk_it'] = 1;
						if($backup_plan['frequency'] == 'manual'){
							$arr['val'] = 'manual';
						}
						echo get_checkbox('freq', '', 'freq', $arr, 'manual', '', array('onclick="handle_manual_option()"')).'
						</div>
					</div>	
						<div class="row mx-auto w-100 my-3">
							<div class="col-sm-6">
								<label class="control-label">'.__('Enable Legacy Backup').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If enabled then always full backups will be taken using old method and not backuply method. <br> <b>Note: </b>This setting is applicable only for full backups.').'"><i class="fas text-primary fa-info-circle"></i></a></label>
							</div>
							<div class="col-sm-6">
								'.get_checkbox('enable_legacy_backup', '', 'enable_legacy_backup', array('chk_it' => 1, 'val' => $data_decode['enable_legacy_backup']), '1', '', array('onclick="handle_legacy_option()"')).'
							</div>
					</div>	
					<div class="row mx-auto w-100 my-3">
						<div class="col-sm-6">
							<label class="control-label">'.__('Backup Scheme').'</label>&nbsp;<a class="info" data-placement="right" tooltip="'.__('Choose backup scheme for VPS').'"><i class="fas text-primary fa-info-circle"></i></a>
						</div>
						<div class="col-sm-6">
							<select id="backup_scheme" class="custom-select" name="backup_scheme" onchange="handle_backup_scheme();">
								<option value="0" '.ex_POSTselect('backup_scheme', 0, $data_decode['backup_scheme']).'>---</option>
								<option class="local manual remote" value="always_full" '.ex_POSTselect('backup_scheme', 'always_full', $data_decode['backup_scheme']).'>'.__('Always Full').'</option>
									<option class="local" value="always_incremental" '.ex_POSTselect('backup_scheme', 'always_incremental', $data_decode['backup_scheme']).'>'.__('Always Incremental').'</option>
									<option class="local remote" value="weekly_full_daily_incremental" '.ex_POSTselect('backup_scheme', 'weekly_full_daily_incremental', $data_decode['backup_scheme']).'>'.__('Weekly Full, Daily Incremental').'</option>
									<option class="local remote" class="local remote" value="monthly_full_weekly_diff_daily_incremental" '.(ex_POSTselect('backup_scheme', 'monthly_full_weekly_diff_daily_incremental', $data_decode['backup_scheme'])).'>'.__('Monthly Full, Weekly Differential, Daily Incremental').'</option>
								<option class="local remote" value="custom" '.ex_POSTselect('backup_scheme', 'custom', $data_decode['backup_scheme']).'>'.__('Custom').'</option>
							</select>
						</div>
					</div>
					<div class="row mx-auto w-100 my-3" id="always_cron_div" style="display:none;">
						<div class="col-sm-6">
							<label class="control-label">'.__('Backup Frequency').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('How often to run the backup process').'"><i class="fas text-primary fa-info-circle"></i></a></label><br />
						</div>
						<div class="col-sm-6">';
						if(!empty($cron_time)){
							$val = $cron_time;
						}else{
							$val = $data_decode['always_cronjob'];
						}
						if(!empty($val)){
							echo '<script>
								$(document).ready(function(){
									$(".always_cronjob").html(convert_to_msg(\''.$val.'\'))
								})
								</script>';
						}
						echo'
							<span class="cursor-pointer always_cronjob" onclick="add_cron_job($(\'#always_cronjob\'))">'.__('Click to set cron').'</span>
							<input type="hidden" class="form-control" id="always_cronjob" value="'.POSTval('always_cronjob', $val).'" name="always_cronjob" autocomplete="off"/>
						</div>
					</div>
					<div class="row mx-auto w-100 my-3" id="weekly_cron_div" style="display:none;">
						<div class="col-sm-6">
							<label class="control-label">'.__('Weekly Full Backup Frequency').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('How often to run the backup process').'"><i class="fas text-primary fa-info-circle"></i></a></label><br />
						</div>
						<div class="col-sm-6">';
						if(!empty($data_decode['weekly_full_cronjob'])){
							$val = $data_decode['weekly_full_cronjob'];
						}else{
							$val = '00 00 * * 1';
						}
						if(!empty($val)){
							echo '<script>
								$(document).ready(function(){
									$(".weekly_full_cronjob").html(convert_to_msg(\''.$val.'\'))
								})
								</script>';
						}
						echo'
							<span class="cursor-pointer weekly_full_cronjob" onclick="add_cron_job($(\'#weekly_full_cronjob\'))">'.__('Click to set cron').'</span>
							<input type="hidden" class="form-control" id="weekly_full_cronjob" value="'.POSTval('weekly_full_cronjob', $val).'" name="weekly_full_cronjob" autocomplete="off"/>
						</div>
					</div>
					<div class="row mx-auto w-100 my-3" id="weekly_daily_inc_cron_div" style="display:none;">
						<div class="col-sm-6">
							<label class="control-label">'.__('Daily Incremental Backup Frequency').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('How often to run the backup process').'"><i class="fas text-primary fa-info-circle"></i></a></label><br />
						</div>';
						if(!empty($data_decode['weekly_daily_inc_cronjob'])){
							echo '<script>
								$(document).ready(function(){
									$(".weekly_daily_inc_cronjob").html(convert_to_msg(\''.$data_decode['weekly_daily_inc_cronjob'].'\'))
								})
								</script>';
						}
						echo'
						<div class="col-sm-6">
							<span class="cursor-pointer weekly_daily_inc_cronjob" onclick="add_cron_job($(\'#weekly_daily_inc_cronjob\'))">'.__('Click to set cron').'</span>
							<input type="hidden" class="form-control" id="weekly_daily_inc_cronjob" value="'.POSTval('weekly_daily_inc_cronjob', $data_decode['weekly_daily_inc_cronjob']).'" name="weekly_daily_inc_cronjob" autocomplete="off"/>
						</div>
					</div>

					<div class="row mx-auto w-100 my-3" id="monthly_full_div" style="display:none;">
						<div class="col-sm-6">
							<label class="control-label">'.__('Monthly Full Backup Frequency').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('How often to run the backup process').'"><i class="fas text-primary fa-info-circle"></i></a></label><br />
						</div>
						<div class="col-sm-6">';
						if(!empty($data_decode['monthly_full_cronjob'])){
							$val = $data_decode['monthly_full_cronjob'];
						}else{
							$val = '00 00 1 * *';
						}
						if(!empty($val)){
							echo '<script>
								$(document).ready(function(){
									$(".monthly_full_cronjob").html(convert_to_msg(\''.$val.'\'))
								})
								</script>';
						}
						echo'
							<span class="cursor-pointer monthly_full_cronjob" onclick="add_cron_job($(\'#monthly_full_cronjob\'))">'.__('Click to set cron').'</span>
							<input type="hidden" class="form-control" autocomplete="off" id="monthly_full_cronjob" value="'.POSTval('monthly_full_cronjob', $val).'" name="monthly_full_cronjob" autocomplete="off"/>
						</div>
					</div>
					<div class="row mx-auto w-100 my-3" id="weekly_diff_div" style="display:none;">
						<div class="col-sm-6">
							<label class="control-label">'.__('Weekly Differential Backup Frequency').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('How often to run the backup process').'"><i class="fas text-primary fa-info-circle"></i></a></label><br />
						</div>
						<div class="col-sm-6">
						';
						if(!empty($data_decode['weekly_diff_cronjob'])){
							$val = $data_decode['weekly_diff_cronjob'];
						}else{
							$val = '00 00 * * 1';
						}
						if(!empty($val)){
							echo '<script>
								$(document).ready(function(){
									$(".weekly_diff_cronjob").html(convert_to_msg(\''.$val.'\'))
								})
								</script>';
						}
						echo'
							<span class="cursor-pointer weekly_diff_cronjob" onclick="add_cron_job($(\'#weekly_diff_cronjob\'))">'.__('Click to set cron').'</span>
							<input type="hidden" class="form-control" autocomplete="off" id="weekly_diff_cronjob" value="'.POSTval('weekly_diff_cronjob', $val).'" autocomplete="off" name="weekly_diff_cronjob" />
						</div>
					</div>
					<div class="row mx-auto w-100 my-3" id="weekly_diff_daily_inc_div" style="display:none;">
						<div class="col-sm-6">
							<label class="control-label">'.__('Daily Incremental Backup Frequency').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('How often to run the backup process').'"><i class="fas text-primary fa-info-circle"></i></a></label><br />
						</div>';
						if(!empty($data_decode['weekly_diff_daily_inc_cronjob'])){
							echo '<script>
								$(document).ready(function(){
									$(".weekly_diff_daily_inc_cronjob").html(convert_to_msg(\''.$data_decode['weekly_diff_daily_inc_cronjob'].'\'))
								})
								</script>';
						}
						echo'
						<div class="col-sm-6">
							<span class="cursor-pointer weekly_diff_daily_inc_cronjob" onclick="add_cron_job($(\'#weekly_diff_daily_inc_cronjob\'))">'.__('Click to set cron').'</span>
							<input type="hidden" class="form-control" id="weekly_diff_daily_inc_cronjob" autocomplete="off" value="'.POSTval('weekly_diff_daily_inc_cronjob', $data_decode['weekly_diff_daily_inc_cronjob']).'" name="weekly_diff_daily_inc_cronjob"/>
						</div>
					</div>

					<div class="row mx-auto w-100 my-3" id="custom_full_div" style="display:none;">
						<div class="col-sm-6">
							<label class="control-label">'.__('Custom Full Backup Frequency').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('How often to run the backup process').'"><i class="fas text-primary fa-info-circle"></i></a></label><br />
						</div>';
						if(!empty($data_decode['custom_full_cronjob'])){
							echo '<script>
								$(document).ready(function(){
									$(".custom_full_cronjob").html(convert_to_msg(\''.$data_decode['custom_full_cronjob'].'\'))
								})
								</script>';
						}
						echo'
						<div class="col-sm-6">
							<span class="roundflare text-admin cursor-pointer custom_full_cronjob" onclick="add_cron_job($(\'#custom_full_cronjob\'))">'.__('Click to set cron').'</span>
							<input type="hidden" class="form-control" id="custom_full_cronjob" autocomplete="off" value="'.POSTval('custom_full_cronjob', $data_decode['custom_full_cronjob']).'" name="custom_full_cronjob"/>
						</div>
					</div>
					<div class="row mx-auto w-100 my-3" id="custom_diff_div" style="display:none;">
						<div class="col-sm-6">
							<label class="control-label">'.__('Custom Differential Backup Frequency').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('How often to run the backup process').'"><i class="fas text-primary fa-info-circle"></i></a></label><br />
						</div>';
						if(!empty($data_decode['custom_diff_cronjob'])){
							echo '<script>
								$(document).ready(function(){
									$(".custom_diff_cronjob").html(convert_to_msg(\''.$data_decode['custom_diff_cronjob'].'\'))
								})
								</script>';
						}
						echo'
						<div class="col-sm-6">
							<span class="roundflare text-admin cursor-pointer custom_diff_cronjob" onclick="add_cron_job($(\'#custom_diff_cronjob\'))">'.__('Click to set cron').'</span>
							<input type="hidden" class="form-control" id="custom_diff_cronjob" autocomplete="off" value="'.POSTval('custom_diff_cronjob', $data_decode['custom_diff_cronjob']).'" name="custom_diff_cronjob"/>
						</div>
					</div>
					<div class="row mx-auto w-100 my-3" id="custom_inc_div" style="display:none;">
						<div class="col-sm-6">
							<label class="control-label">'.__('Custom Incremental Backup Frequency').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('How often to run the backup process').'"><i class="fas text-primary fa-info-circle"></i></a></label><br />
						</div>';
						if(!empty($data_decode['custom_inc_cronjob'])){
							echo '<script>
								$(document).ready(function(){
									$(".custom_inc_cronjob").html(convert_to_msg(\''.$data_decode['custom_inc_cronjob'].'\'))
								})
								</script>';
						}
						echo'
						<div class="col-sm-6">
							<span class="roundflare text-admin cursor-pointer custom_inc_cronjob" onclick="add_cron_job($(\'#custom_inc_cronjob\'))">'.__('Click to set cron').'</span>
							<input type="hidden" class="form-control" id="custom_inc_cronjob" autocomplete="off" value="'.POSTval('custom_inc_cronjob', $data_decode['custom_inc_cronjob']).'" name="custom_inc_cronjob"/>
						</div>
					</div>
					<input type="hidden" name="selected_cron_type" id="selected_cron_type">			
					<div class="row mx-auto w-100 my-3" id="tr_dir">
						<div class="col-sm-6">
							<label class="control-label">'.__('Directory').'&nbsp;<a class="info" data-placement="right" tooltip="'.htmlizer(__('The path of the directory where backups will be stored. Incase of local backups, this path has to be <b>mounted</b> previously on the server. <b>For example</b>: "/Your-Dir"')).'"><i class="fas text-primary fa-info-circle"></i></a></label>
						</div>
						<div class="col-sm-6">
							<input type="text" class="form-control" name="dir" id="dir" value="'.(!empty($backup_plan['dir']) ? $backup_plan['dir'] : '/').'" size="40"/>
						</div>
					</div>
					<div class="row mx-auto w-100 my-3">
						<div class="col-sm-6">
							<label class="control-label">'.__('Backup Rotation').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('The number of backups allowed per VPS').'"><i class="fas text-primary fa-info-circle"></i></a></label>
						</div>
						<div class="col-sm-6">
							<div class="input-group input-group-sm">
								<div class="input-group-prepend">
									<button type="button" class="input-group-text blue_btn cursor-pointer" onclick="apply_roation_val(0)">-</button>
								</div>
								<input type="text" id="backup_rotation" value="'.POSTval('rotation', $backup_plan['rotation']).'" name="rotation" class="form-control" value="0">
								<div class="input-group-append">
									<button type="button" class="input-group-text blue_btn cursor-pointer" onclick="apply_roation_val(1)">+</button>
								</div>
							</div>
						</div>
					</div>
					<div class="row mx-auto w-100 my-3" id="tr_backup_limit">
						<div class="col-sm-6">
							<label class="control-label">'.__('Enduser Backups').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Max number of manual backup operations the VPS user can perform per month').'"><i class="fas text-primary fa-info-circle"></i></a></label>
						</div>
						<div class="col-sm-6">
							<select class="custom-select" name="backup_limit" id="backup_limit">';
							
							echo '<option value="0" '.ex_POSTselect('backup_limit', 0, $backup_plan['backup_limit']).' >'.__('Disabled').'</option>';
							
							for($i = 1; $i < 11; $i++){
								echo '<option value="'.$i.'" '.ex_POSTselect('backup_limit', $i, $backup_plan['backup_limit']).' >'.$i.'</option>';
							}
							
							echo '<option value="-1" '.ex_POSTselect('backup_limit', -1, $backup_plan['backup_limit']).' >'.__('Unlimited').'</option>';
							
						echo '</select>
						</div>
					</div>
				</div>
				<div class="col-sm-12 col-md-12 col-lg-6">
					<div class="row mx-auto w-100 my-3" id="tr_restore_limit">
						<div class="col-sm-6">
							<label class="control-label">'.__('Enduser Restore').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Max number of VPS restore operations the user can perform per month').'"><i class="fas text-primary fa-info-circle"></i></a></label>
						</div>
						<div class="col-sm-6">
							<select class="custom-select" name="restore_limit" id="restore_limit">';
							
							echo '<option value="0" '.ex_POSTselect('restore_limit', 0, $backup_plan['restore_limit']).' >'.__('Disabled').'</option>';
							
							for($i = 1; $i < 11; $i++){
								echo '<option value="'.$i.'" '.ex_POSTselect('restore_limit', $i, $backup_plan['restore_limit']).' >'.$i.'</option>';
							}
							
							echo '<option value="-1" '.ex_POSTselect('restore_limit', -1, $backup_plan['restore_limit']).' >'.__('Unlimited').'</option>';
							
						echo '</select>
						</div>
					</div>
					<!-- <div class="row mx-auto w-100 my-3">
						<div class="col-sm-6">
							<label class="control-label">'.__('Enable Enduser Backup Servers').'</label><br />
							<span class="help-block">'.__('Allow the VPS user to select his own backup server to store the backups.<br /><b>NOTE:</b> This setting will be ignored if overriden in master settings').'</span>
						</div>
						<div class="col-sm-6">
							'.get_checkbox('enable_enduser_backup_servers', '', 'enable_enduser_backup_servers', array('chk_it' => 1, 'val' => $backup_plan['enable_enduser_backup_servers'])).'
						</div>
					</div> -->
					<div class="row mx-auto w-100 my-3">
						<div class="col-sm-6">
							<label class="control-label">'.__('Process Priority').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('CPU time the backup process will get. 19 (least favourable) to -20 (most favourable)').'"><i class="fas text-primary fa-info-circle"></i></a></label>
						</div>
						<div class="col-sm-6">
							<select class="custom-select" name="nice" id="nice">';
							for($i=-20; $i<20; $i++){
								echo '<option value="'.$i.'" '.ex_POSTselect('nice', $i, $backup_plan['nice']).'>'.$i.'</option>';
							}
						echo '</select>
						</div>
					</div>
					<div class="row mx-auto w-100 my-3">
						<div class="col-sm-6">
							<label class="control-label">'.__('Process I/O Priority').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('IO priority for the backup process').'"><i class="fas text-primary fa-info-circle"></i></a></label>
						</div>
						<div class="col-sm-6">
							<select class="custom-select" name="ionice_prio" id="ionice_prio">';
							for($i=0; $i<8; $i++){
								echo '<option value="'.$i.'" '.ex_POSTselect('ionice_prio', $i, $backup_plan['ionice_prio']).'>'.$i.'</option>';
							}
					echo '</select>
						</div>
					</div>
					<div class="row mx-auto w-100 my-3">
						<div class="col-sm-6">
							<label class="control-label">'.__('Process I/O Class').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('IO class for the backup process').'"><i class="fas text-primary fa-info-circle"></i></a></label>
						</div>
						<div class="col-sm-6">
							<select class="custom-select" name="ionice_class" id="ionice_class">
								<option value="1" '.ex_POSTselect('ionice_class', 1, $backup_plan['ionice_class']).' >Real Time</option>
								<option value="2" '.ex_POSTselect('ionice_class', 2, $backup_plan['ionice_class']).'>Best Effort</option>
								<option value="3" '.ex_POSTselect('ionice_class', 3, $backup_plan['ionice_class']).'>Idle</option>
							</select>
						</div>
					</div>
					<div class="row mx-auto w-100 my-3">
						<div class="col-sm-6">
							<label class="control-label">'.__('Process I/O speed limit (in Mbps)').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('The I/O speed limit (in Mbps) for the backup process. Set 0 for unlimited. It will take effect while write IO operation only.').'"><i class="fas text-primary fa-info-circle"></i></a></label>
						</div>
						<div class="col-sm-6">
							<input type="number" class="form-control" name="io_limit" value="'.POSTval('io_limit', $backup_plan['io_limit']).'" />
						</div>
					</div>
					<div class="row mx-auto w-100 my-3">
						<div class="col-6">
							<label class="control-label">'.__('Disable Compression').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Disable compression for the backups. This will take effect only for KVM, Xen-HVM and OpenVZ.<br />
For KVM file based VPS this will take effect only for QCOW2 disks.').'"><i class="fas text-primary fa-info-circle"></i></a></label>
						</div>
						<div class="col-6">
							'.get_checkbox('compression', '', 'compression', array('chk_it' => 1, 'val' => $backup_plan['disable_compression'])).'
						</div>
					</div>
					<div class="row mx-auto w-100 my-3">
						<div class="col-6">
							<label class="control-label">'.__('Check Directory Permissions on Save.').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If checked, the local / backup server directory permissions will be checked on saving the backup plan to ensure the backups do not fail').'"><i class="fas text-primary fa-info-circle"></i></a></label>
						</div>
						<div class="col-6">
							'.get_checkbox('check_dir_permissions', '', 'check_dir_permissions', array('chk_it' => 1, 'val' => true)).'
						</div>
					</div>
					<div class="row mx-auto w-100 my-3">
							<div class="col-sm-6">
								<label class="control-label">'.__('Primary Backup').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If enabled, only primary disk backup will be taken').'"><i class="fas text-primary fa-info-circle"></i></a></label>
							</div>
							<div class="col-6">
							'.get_checkbox('backup_primary', '', 'backup_primary', array('chk_it' => 1, 'val' => $data_decode['backup_primary'])).'

							</div>
					</div>
				</div>
			</div>
		</div>

		<div class="row mx-auto w-100 my-3 row w-100">
			<div class="col-sm-12 col-md-12 col-lg-6 pl-0 border-right">
				<div class="roundheader hide_for_plan cursor-pointer" onclick="toggle_advoptions(\'adv\');"><label id="adv_advoptions_ind"  class="min_width">+</label> &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'.__('Advanced Options').'
				</div>
				<div id="adv_advoptions" style="display:none;" class="hide_for_plan w-100">
					<div class="col-sm-12">
						<div class="row mx-auto w-100 my-3">
							<div class="col-sm-12">
								<label class="control-label">'.__('Backup Server Per Server / Server Group').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Assign a different backup server for each Slave Server / Server Group. This setting will override the default backup server specified above.').'"><i class="fas text-primary fa-info-circle"></i></a></label>
							</div>
							<div class="col-sm-12">
								<div class="scrollbar-virt">
									<table class="table table-bordered">
										<tr class="active">
											<th>'.__('Server / Server Group').'</th>
											<th>'.__('Backup Server').'</th>
											<th>'.__('Directory').'</th>
										</tr>';
										
										foreach($servergroups as $sgid => $servergroup) {
											
											echo '<tr>
												<th>[Group] '.$servergroup['sg_name'].'</th>
												<th><select class="virt-select" name="bs_sg'.$sgid.'">
													<option value="0" '.ex_POSTselect('bs_sg'.$sgid, 0, $backup_plan['bs_servergroups']['bs_groups'][$sgid]).'>'.__('Default').'</option>
													<option value="-1" '.ex_POSTselect('bs_sg'.$sgid, -1, $backup_plan['bs_servergroups']['bs_groups'][$sgid]).'>LOCAL</option>
													<optgroup label="SSH">';
												
														foreach($backupservers as $bid => $bs) {
															if($bs['type'] == 'SSH') {
																echo '<option value="'.$bid.'" '.ex_POSTselect('bs_sg'.$sgid, $bid, $backup_plan['bs_servergroups']['bs_groups'][$sgid]).'>'.$bs['name'].'</option>';
															}
														}
													
													echo '</optgroup>
													<optgroup label="FTP">';
														
														foreach($backupservers as $bid => $bs) {
															if($bs['type'] == 'FTP') {
																echo '<option value="'.$bid.'" '.ex_POSTselect('bs_sg'.$sgid, $bid, $backup_plan['bs_servergroups']['bs_groups'][$sgid]).'>'.$bs['name'].'</option>';
															}
														}
														
											echo '</optgroup>';
											if(has_plugin_license('backuply')){
											echo'
											<optgroup label="dropbox">';
													foreach($backupservers as $bid => $bs) {
														if($bs['type'] == 'dropbox') {
															echo '<option value="'.$bid.'" '.ex_POSTselect('bs_sg'.$sgid, $bid, $backup_plan['bs_servergroups']['bs_groups'][$sgid]).'>'.$bs['name'].'</option>';
														}
													}
												echo '</optgroup>
												<optgroup label="gdrive">';
													foreach($backupservers as $bid => $bs) {
														if($bs['type'] == 'gdrive') {
															echo '<option value="'.$bid.'" '.ex_POSTselect('bs_sg'.$sgid, $bid, $backup_plan['bs_servergroups']['bs_groups'][$sgid]).'>'.$bs['name'].'</option>';
														}
													}
												echo '</optgroup>
												<optgroup label="onedrive">';
													foreach($backupservers as $bid => $bs) {
														if($bs['type'] == 'onedrive') {
															echo '<option value="'.$bid.'" '.ex_POSTselect('bs_sg'.$sgid, $bid, $backup_plan['bs_servergroups']['bs_groups'][$sgid]).'>'.$bs['name'].'</option>';
														}
													}
												echo '</optgroup>
												<optgroup label="s3bucket">';
													foreach($backupservers as $bid => $bs) {
														if($bs['type'] == 's3bucket') {
															echo '<option value="'.$bid.'" '.ex_POSTselect('bs_sg'.$sgid, $bid, $backup_plan['bs_servergroups']['bs_groups'][$sgid]).'>'.$bs['name'].'</option>';
														}
													}
												echo '</optgroup>';
											}
										echo '</select></th>
										<th><input type="text" class="form-control" name="dir_sg'.$sgid.'" value="'.POSTval('dir_sg'.$sgid, $backup_plan['bs_servergroups']['dir_groups'][$sgid]).'" placeholder="'.__('Default if empty').'" size="40"/></th>
											</tr>';
											
											foreach($servers as $serid => $server) {
												
												if($server['sgid'] != $sgid) {
													continue;
												}
												
												echo '<tr>
													<td> - '.$server['server_name'].' ('.$server['ip'].')</td>
													<th><select class="virt-select" name="bs_s'.$serid.'">
														<option value="0" '.ex_POSTselect('bs_s'.$serid, 0, $backup_plan['bs_servergroups']['bs_servers'][$serid]).'>'.__('Default').'</option>
														<option value="-1" '.ex_POSTselect('bs_s'.$serid, -1, $backup_plan['bs_servergroups']['bs_servers'][$serid]).'>LOCAL</option>
														<optgroup label="SSH">';
													
															foreach($backupservers as $bid => $bs) {
																if($bs['type'] == 'SSH') {
																	echo '<option value="'.$bid.'" '.ex_POSTselect('bs_s'.$serid, $bid, $backup_plan['bs_servergroups']['bs_servers'][$serid]).'>'.$bs['name'].'</option>';
																}
															}
														
														echo '</optgroup>
														<optgroup label="FTP">';
															
															foreach($backupservers as $bid => $bs) {
																if($bs['type'] == 'FTP') {
																	echo '<option value="'.$bid.'" '.ex_POSTselect('bs_s'.$serid, $bid, $backup_plan['bs_servergroups']['bs_servers'][$serid]).'>'.$bs['name'].'</option>';
																}
															}
															
												echo '</optgroup>';
												echo '<optgroup label="dropbox">';
													foreach($backupservers as $bid => $bs) {
														if($bs['type'] == 'dropbox') {
															echo '<option value="'.$bid.'" '.ex_POSTselect('bs_sg'.$serid, $bid, $backup_plan['bs_servergroups']['bs_servers'][$serid]).'>'.$bs['name'].'</option>';
														}
													}
												echo '</optgroup>
												<optgroup label="gdrive">';
													foreach($backupservers as $bid => $bs) {
														if($bs['type'] == 'gdrive') {
															echo '<option value="'.$bid.'" '.ex_POSTselect('bs_sg'.$serid, $bid, $backup_plan['bs_servergroups']['bs_servers'][$serid]).'>'.$bs['name'].'</option>';
														}
													}
												echo '</optgroup>
												<optgroup label="onedrive">';
													foreach($backupservers as $bid => $bs) {
														if($bs['type'] == 'onedrive') {
															echo '<option value="'.$bid.'" '.ex_POSTselect('bs_sg'.$serid, $bid, $backup_plan['bs_servergroups']['bs_servers'][$serid]).'>'.$bs['name'].'</option>';
														}
													}
												echo '</optgroup>
												<optgroup label="s3bucket">';
													foreach($backupservers as $bid => $bs) {
														if($bs['type'] == 's3bucket') {
															echo '<option value="'.$bid.'" '.ex_POSTselect('bs_sg'.$serid, $bid, $backup_plan['bs_servergroups']['bs_servers'][$serid]).'>'.$bs['name'].'</option>';
														}
													}
												echo '</optgroup>';
												echo '</select></th>
													<th><input type="text" class="form-control" name="dir_s'.$serid.'" value="'.POSTval('dir_s'.$serid, $backup_plan['bs_servergroups']['dir_servers'][$serid]).'"  placeholder="'.__('Default if empty').'" size="40"/></th>
												</tr>';
											}
										}
										echo '</table>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
			<div class="col-sm-12 col-md-12 col-lg-6 pr-0">
				<div class="roundheader cursor-pointer" onclick="toggle_advoptions(\'vs\');">
					<label id="vs_advoptions_ind" class="min_width">+</label> &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'.__('List of VPS in this Backup Plan').'
				</div>
				<div id="vs_advoptions" style="display:none;" class="">
					<div class="p-0 m-0 overflow-auto mh-25">
						<table class="table table-hover vps_table m-0">
							<tr>
								<th width="100">'.__('VPS ID').'</th>
								<th width="100">'.__('VPS').'</th>
								<th>'.__('Server').'</th>
								<th>'.__('Hostname').'</th>
								<th>'.__('Space').'</th>
							</tr>';
							
							if(empty($vpses)) {
								echo '<tr>
									<td colspan="5" align="center"><b>'.__('No VPS assigned to this Backup Plan').'</b></td>
								</tr>';
							}
							
							foreach($vpses as $vpsid => $vps) {
								
								echo '<tr>
										<td width="100">'.$vpsid.'</td>
										<td width="100">'.$vps['vps_name'].'</td>
										<td>'.$servers[$vps['serid']]['server_name'].'</td>
										<td>'.$vps['hostname'].'</td>
										<td align="center">'.$vps['space'].' GB</td>
									</tr>';
								
							}
							
						echo '</table>
					</div>
				</div>
			</div>
		</div>
		<br/>
		<center>
			<input type="submit" name="editbackup_plan"  id="editbackup_plan" value="'.__('Submit').'" class="go_btn" />
			<br /><br />';
			// Legacy backup
			if(!empty($data_decode['enable_legacy_backup'])){
				echo '<input type="submit" id="backup_now" class="go_btn" name="backup_now"  value="'.__('Backup Now (Legacy)').'"/>';

				// Backuply full & inc backup
			} else {
				echo '<input type="submit" id="take_full_backup" class="go_btn" name="take_full_backup"  value="'.__('Take Full Backup (Backuply)').'"/>';
				if(($backup_plan['frequency'] != 'manual') && ($data_decode['backup_scheme'] != 'always_full')){
					echo '<input type="submit" id="backup_now" class="go_btn ml-3" name="backup_now"  value="'.__('Take Incremental Backup (Backuply)').'"/>';
				}
			}
			echo '
		</center>
	</form>

	<div class="row mx-auto w-100 my-3">
		<div class="col-sm-12 p-0">
			<div id="panel-tasks" class="panel panel-blue-grey">
				<div class="panel-heading">
					<span>'.__('Last 50 Backup / Restore Tasks of this Plan').'</span>
					<i class="icon icon-tasks float-left mr-1 h6 m-0"></i>
				</div>
				<div class="panel-content scrollbar-virt">
					<div id="table_tasks_container"></div>
				</div>
			</div>
		</div>
	</div>
</div>';

softfooter();

}

?>