<?php

//////////////////////////////////////////////////////////////
//===========================================================
// config_theme.php
//===========================================================
// SOFTACULOUS VIRTUALIZOR
// Version : 1.0
// Inspired by the DESIRE to be the BEST OF ALL
// ----------------------------------------------------------
// Started by: Alons
// Date:       8th Mar 2010
// Time:       23:00 hrs
// Site:       https://www.virtualizor.com/ (SOFTACULOUS VIRTUALIZOR)
// ----------------------------------------------------------
// Please Read the Terms of use at https://www.virtualizor.com
// ----------------------------------------------------------
//===========================================================
// (c)Softaculous Ltd.
//===========================================================
//////////////////////////////////////////////////////////////

if(!defined('VIRTUALIZOR')){

	die('Hacking Attempt');

}

function config_theme(){

global $theme, $globals, $info, $kernel, $user, $l, $error, $langs, $skins, $done, $cluster, $virt, $centos5, $val, $master, $servers, $timezones, $valid_compression, $available_social_logins, $custom_cp;

softheader($l['<title>']);
					
echo '<script>
$(document).ready(function(){
  $("#myInput").on("keyup", function() {
		var value = $(this).val().toLowerCase();
		if(value==""){
			//alert(4)
			$(".divroundshad").show();
			$(".roundheader").show();
		}else{
			$(".roundheader").hide();
			$(".card").css("border", "0");
		}
		
		$(".divroundshad .row").filter(function() {
		  $(this).toggle($(this).first().text().toLowerCase().indexOf(value) > -1 || $(this).parent(".px-3").parent(".divroundshad").find(".roundheader").text().toLowerCase().indexOf(value) > -1);
		  if($(this).first().text().toLowerCase().indexOf(value) > -1 || $(this).parent(".px-3").parent(".divroundshad").find(".roundheader").text().toLowerCase().indexOf(value) > -1){
			$(this).parent(".px-3").parent(".divroundshad").find(".roundheader").show();
			$(this).parent(".divroundshad").show();   
		  }
		});
	});
});
</script>';

echo page_header((!empty($master) ? 'Master ' : 'Slave ').__('Configuration'), 'fas fa-cogs');

$breadcrumbs = array('dashboard', 'lm_config', 'lms_config_slave');

echo get_breadcrumb($breadcrumbs);

error_handle($error);
echo '<div class="card p-2 mx-3">';
if(!$master) {
	echo '<div class="notebox p-4 mx-4">'.__('<b>NOTE</b> : These settings are global settings, which will be synced across all the slave servers. You can also change settings on a per node basis from the <a href="index.php?act=config_slave">Slave Settings</a> wizard.').'</div>';
	echo '<br><div class="row mx-auto w-100">
			<div class="col-sm-6"><label class="control-label"><br></label><input id="myInput" class="form-control" type="text" placeholder="'.__('Type to search configuration..').'"></div><div class="col-sm-6 ">';
			server_select();
	echo '</div></div>';
}else{
	echo '<div class="notebox p-4 mx-4">'.__('<b>NOTE</b> : These settings are individual settings for the Active Node. These settings will override the Master Settings on the Active Slave Node.').'</div>';
	echo '<div class="row mx-auto w-100">
			<div class="col-sm-12 "><label class="control-label"><br></label><input id="myInput" class="form-control" type="text" placeholder="'.__('Type to search configuration..').'"></div></div>';
}

// Is it offline ?
$hypervisor_status = $cluster->statewise($globals['server']);
if($hypervisor_status == 0 || $hypervisor_status == 2){
	
	show_alert($globals['hypervisor_status'][$hypervisor_status],"1");
	echo '<div class="e_notice"><b>NOTE : </b>&nbsp; '.$globals['hypervisor_status'][$hypervisor_status].'</div>';
	
}else{

if(!empty($done)){
	show_alert(__('The settings have been saved'));
	//echo '<div class="notice"><b>NOTE : </b>&nbsp; '..'</div>';
}

echo '
<style>
.side_lbl{
	padding:10px;
}
</style>

<script language="javascript" type="text/javascript"><!-- // --><![CDATA[
	
	function reset_hash(){
		
		$("#resethash").attr("src", "'.$theme['images'].'admin/vpsloading.gif");
		
		$.ajax({
			type: "POST",
			url: "'.$globals['ind'].'act=config&reset_cb_hash=1&api=json",
			dataType : "json",
			success:function(response){
				if("new_hash" in response){
					$("#cb_hash").html(response["new_hash"]);
				}
				$("#resethash").attr("src", "'.$theme['images'].'refresh.png");
			},
			error:function(){
				$("#resethash").attr("src", "'.$theme['images'].'refresh.png");
			}
		});
		return;
	}
	
	$(document).ready(function(){
		
		$("#haproxy_src_ips").on("change", function(){
			showalert("'.__J('Modifying source IPs will also require to remap old source IPs with new under Admin Panel > Virtual Server > Domain Forwarding > Servers page to update existing VDF records with new source IPs').'","2");
		});

		$(".chosen").select2({width: "100%"});
		if($("#enable_backup_delete").prop("checked")){
			$("#enable_backup_delete_cron").slideDown();
		}
		$("#enable_backup_delete").click(function(){
			$("#enable_backup_delete_cron").slideToggle();
		});

		if ($(".disable_icons_cp_class").length == $(".disable_icons_cp_class:checked").length) {
			$("#select_all").prop("checked", true);
		} else {
			$("#select_all").prop("checked", false);
		}
		
		enduser_iso_settings();
		check_ldap();
	});

	function check_ldap(){
		if($("#enable_ldap_auth").prop("checked")){
			$("#ldap_div").show();
		} else {
			$("#ldap_div").hide();
		}
	}
	
	function enduser_iso_settings(){
		if($("#enable_eu_iso_boot").prop("checked")){
			$(".enduser_iso_settings").show();
		} else {
			$(".enduser_iso_settings").hide();
		}
	}

	function enduser_cp_settings(checker){
		if($("#select_all").prop("checked")){
			$(".disable_icons_cp_class").prop("checked", true);
		}else{
			$(".disable_icons_cp_class").prop("checked", false);
		}
	}

	function show_social_details(social_id){
		if($("#"+social_id).prop("checked") == true){
			$("#"+social_id+"_div").show();
		}else{
			$("#"+social_id+"_div").hide();
		}
	};
// ]]></script>

<form accept-charset="'.$globals['charset'].'" action="" method="post" name="config" class="form-horizontal">
<div class="row mx-auto w-100 my-3">
	<div class="col-sm-12 col-md-12 col-lg-6">
		<div  class="divroundshad card mb-3">
			<div class="roundheader">'.__('General Settings').'</div>
			<div class="px-3">
			';

			if($master){
				
			echo '<div class="row mx-auto w-100 my-3">
				<div class="col-sm-6 p-0">
					<label class="control-label">'.__('Site Name').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('The name of the server or company using Virtualizor. It will appear in many pages of the Virtualizor Panel').'"><i class="fas text-primary fa-info-circle"></i></a></label>
				</div>
				<div class="col-sm-6 p-0">
					<input type="text" class="form-control" name="sn" id="sitename" size="30" value="'.POSTval('sn', $info['sn']).'" />
				</div>
			</div>
			<div class="row mx-auto w-100 my-3">
				<div class="col-sm-6 p-0">
					<label class="control-label">'.__('Master Server Name').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If set, then Master server will be show as provided name instead of localhost').'"><i class="fas text-primary fa-info-circle"></i></a></label>
				</div>
				<div class="col-sm-6 p-0">
					<input type="text" class="form-control" name="master_name" id="master_name" size="30" value="'.POSTval('master_name', $info['master_name']).'" />
				</div>
			</div>
			<div class="row mx-auto w-100 my-3">
				<div class="col-sm-6 p-0">
					<label class="control-label">'.__('Site domain').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If empty server\'s IP will be used instead of the domain.').'"><i class="fas text-primary fa-info-circle"></i></a></label>
				</div>
				<div class="col-sm-6 p-0">
					<input type="text" class="form-control" name="site_domain" size="30" value="'.POSTval('site_domain', $info['site_domain']).'" />
				</div>
			</div>
			<div class="row mx-auto w-100 my-3">
				<div class="col-sm-6 p-0">
					<label class="control-label">'.__('Logo URL').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('The recommended size is 172 x 35 pixels. If empty the Virtualizor logo will be shown.').'"><i class="fas text-primary fa-info-circle"></i></a></label>
				</div>
				<div class="col-sm-6 p-0">
					<input type="text" class="form-control" name="logo_url" size="30" value="'.POSTval('logo_url', $info['logo_url']).'" />
				</div>
			</div>
			<div class="row mx-auto w-100 my-3">
				<div class="col-sm-6 p-0">
					<label class="control-label">'.__('Mobile Logo URL').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('The recommended size is 45 x 53 pixels. If empty the Virtualizor logo will be shown.').'"><i class="fas text-primary fa-info-circle"></i></a></label>
				</div>
				<div class="col-sm-6 p-0">
					<input type="text" class="form-control" name="admin_mob_logo_url" size="30" value="'.POSTval('admin_mob_logo_url', $info['admin_mob_logo_url']).'" />
				</div>
			</div>
			<div class="row mx-auto w-100 my-3">
				<div class="col-sm-6 p-0">
					<label class="control-label">'.__('Logo URL (Login Page)').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('The recommended size is 400 x 80 pixels. If empty the Virtualizor logo will be shown.').'"><i class="fas text-primary fa-info-circle"></i></a></label>
				</div>
				<div class="col-sm-6 p-0">
					<input type="text" class="form-control" name="logo_login_url" size="30" value="'.POSTval('logo_login_url', $info['logo_login_url']).'" />
				</div>
			</div>
			<div class="row mx-auto w-100 my-3">
				<div class="col-sm-6 p-0">
					<label class="control-label">'.__('Favicon URL').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If not set then Virtualizor favicon will be used').'"><i class="fas text-primary fa-info-circle"></i></a></label>
				</div>
				<div class="col-sm-6 p-0">
					<input type="text" class="form-control" name="favicon_url" size="30" value="'.POSTval('favicon_url', $info['favicon_url']).'" />
				</div>
			</div>
			<div class="row mx-auto w-100 my-3">
				<div class="col-sm-6 p-0">		
					<label class="control-label">'.__('Support URL').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Specify the support URL which will be displayed in the Enduser Panel.').'"><i class="fas text-primary fa-info-circle"></i></a></label>
				</div>
				<div class="col-sm-6 p-0">
					<input type="text" class="form-control" name="support" size="30" value="'.POSTval('support', $info['support']).'"/> 
				</div>
			</div>

			<div class="row mx-auto w-100 my-3">
				<div class="col-sm-6 p-0">
					<label class="control-label">'.__('Copyright').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('The Copyright that appears in the footer').'"><i class="fas text-primary fa-info-circle"></i></a></label>
				</div>
				<div class="col-sm-6 p-0">
					<input type="text" class="form-control" name="copyright" id="copyright" size="30" value="'.POSTval('copyright', @$info['copyright']).'" />
				</div>
			</div>

			<div class="row mx-auto w-100 my-3">
				<div class=" col-sm-6 p-0">
					<label class="control-label">'.__('Compress Output').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('This will compress output and it saves a lot of bandwidth.').'"><i class="fas text-primary fa-info-circle"></i></a></label>
				</div>
				<div class=" col-sm-6 p-0">
					'.get_checkbox('gzip', '', '', array('chk_it' => 1, 'val' => $info['gzip'])).'
				</div>
			</div>';
			}

			if(empty($master)){
			echo '<div class="row mx-auto w-100 my-3">
				<div class="col-sm-6 p-0">
					<label class="control-label">'.__('Cookie Name').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('The name of the cookie that will be stored on browsers.').'"><i class="fas text-primary fa-info-circle"></i></a></label>
				</div>
				<div class="col-sm-6 p-0">
					<input type="text" class="form-control" name="cookie_name" id="cookie_name" size="30" value="'.POSTval('cookie_name', $info['cookie_name']).'" />
				</div>
			</div>';
			}

			echo '<div class="row mx-auto w-100 my-3">
				<div class="col-sm-6 p-0">
				<label class="control-label">'.__('Email Address').'</label>
				</div>
				<div class="col-sm-6 p-0">
				<input type="text" class="form-control" name="soft_email" size="30" value="'.POSTval('soft_email', $info['soft_email']).'" />
				</div>
			</div>';

			if($master){
			echo '<div class="row mx-auto w-100 my-3">
				<div class="col-sm-6 p-0">
					<label class="control-label">'.__('From email Address').'</label>
				</div>
				<div class="col-sm-6 p-0">
					<input type="text" class="form-control" name="from_email" size="30" value="'.POSTval('from_email', $info['from_email']).'" />
				</div>
			</div>
			<div class="row mx-auto w-100 my-3">
				<div class="col-sm-6 p-0">
					<label class="control-label">'.__('Session Timeout').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Seconds before an unused session timeout').'"><i class="fas text-primary fa-info-circle"></i></a></label>
				</div>
				<div class="col-sm-6 p-0">
					<input type="text" class="form-control" name="sess_len" id="sess_len" size="30" value="'.POSTval('sess_len', $info['sess_len']).'" />
				</div>
			</div>
			<div class="row mx-auto w-100 my-3">
			<div class="col-sm-6 p-0">
				<label class="control-label">'.__('Choose Language').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Choose your preferred language').'"><i class="fas text-primary fa-info-circle"></i></a></label>
			</div>
			<div class="col-sm-6 p-0">
			<select class="custom-select" name="language">';
				
				foreach($langs as $k => $v){

					echo '<option value="'.$v.'" '.(empty($_POST['language']) && $info['language'] == $v ? 'selected="selected"' : (@trim($_POST['language']) == $v ? 'selected="selected"' : '') ).'>'._ucfirst($v).'</option>';
					
				}
				
				echo '</select>
			</div>
			</div>

			<div class="row mx-auto w-100 my-3">
			<div class="col-sm-6 p-0">
				<label class="control-label">'.__('Choose Theme').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('The selected theme will be the default theme throughout Virtualizor').'"><i class="fas text-primary fa-info-circle"></i></a></label>	
			</div>
			<div class="col-sm-6 p-0">
			<select class="custom-select" name="theme_folder">';
				
				foreach($skins as $k => $v){
					echo '<option value="'.$v.'" '.(empty($_POST['theme_folder']) && $info['theme_folder'] == $v ? 'selected="selected"' : (trim($_POST['theme_folder']) == $v ? 'selected="selected"' : '') ).'>'.($v == 2024 ? '2024 (Beta)' : _ucfirst($v)).'</option>';
				}
				
				echo '</select>
			</div>
			</div>';
			}

			echo '<div class="row mx-auto w-100 my-3">
				<div class="col-sm-6 p-0"><label class="control-label">'.__('Timezone').'</label></div>
				<div class="col-sm-6 p-0" valign="top">
					<select class="custom-select virt-select" name="timezone">';
				
						foreach ($timezones as $key => $value) {
							echo '<optgroup label="'.$key.'">';
							foreach ($value as $timezone_value => $timezone_name) {
								echo '<option value="'.$timezone_value.'" '. ($info['timezone'] == $timezone_value ? 'selected="selected"' : '') .'>'.$timezone_name.'</option>';
							}
							echo '</optgroup>';
						}

					echo '</select>
				</div>
			</div>';

			// CPU model edit option only available on kvm
			if($master || (empty($master) && server_virt($globals['server'], 'kvm') == 'kvm')){
				echo '<div class="row mx-auto w-100 my-3">
					<div class=" col-6 p-0">
						<label class="control-label">'.__('Show CPU Model name').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Show the CPU Model name in all VPS.').'"><i class="fas text-primary fa-info-circle"></i></a></label>
					</div>
					<div class=" col-6 p-0">
						'.get_checkbox('cpu_nm', '', '', array('chk_it' => 1, 'val' => $info['cpu_nm'])).'
					</div>
				</div>';
			}

			if(empty($master)){
			echo '<div class="row mx-auto w-100 my-3" id="overcommitrow">
				<div class="col-6 p-0">
					<label class="control-label">'.__('RAM Overcommit').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If specified the total allocated RAM for all VPS on the physical server cannot exceed this value.').'"><i class="fas text-primary fa-info-circle"></i></a></label>
				</div>
				<div class="col-6 p-0">
					<input type="number" class="form-control" name="overcommit" id="overcommit" size="20" value="'.POSTval('overcommit', $info['overcommit']).'" />
				</div>
			</div>';
			}

			if(empty($master) && !$cluster->virt(0)){
			echo '<div class="row mx-auto w-100 my-3">
				<div class="col-sm-6 p-0">
					<label class="control-label">'.__('Set VNC IP').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Use this option only when Virtualizor is installed on an Internal Network').'"><i class="fas text-primary fa-info-circle"></i></a></label>
				</div>
				<div class="col-sm-6 p-0">
					<input type="text" class="form-control" name="vnc_ip" id="vnc_ip" size="20" value="'.POSTval('vnc_ip', $info['vnc_ip']).'" />
				</div>
			</div>';
			}

			if($master){
			echo '
			<div class="row mx-auto w-100 my-3">
				<div class=" col-6 p-0">
					<label class="control-label">'.__('Enable RDNS').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If checked then the Reverse DNS will be ON for VPS. However you will need to setup the DNS servers.').'"><i class="fas text-primary fa-info-circle"></i></a></label>
				</div>
				<div class=" col-6 p-0">
					'.get_checkbox('enable_rdns', '', '', array('chk_it' => 1, 'val' => @$info['enable_rdns'])).'
				</div>
			</div>
			<div class="row mx-auto w-100 my-3">
				<div class=" col-6 p-0">
					<label class="control-label">'.__('Auto Add rDNS Zone').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If checked, rDNS zones will be auto created for records whose zones are not present').'"><i class="fas text-primary fa-info-circle"></i></a></label>
				</div>
				<div class=" col-6 p-0">
					'.get_checkbox('auto_add_zone', '', '', array('chk_it' => 1, 'val' => @$info['auto_add_zone'])).'
				</div>
			</div>
			<div class="row mx-auto w-100 my-3">
				<div class="col-sm-6 p-0">
					<label class="control-label">'.__('CURL Timeout').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If set than Virtualizor will use this value as CURL time out. Default is 3. Please set greater than 3 if you want to change the timeout.').'"><i class="fas text-primary fa-info-circle"></i></a></label>
				</div>
				<div class="col-sm-6 p-0">
					<input type="text" class="form-control" name="curl_timeout" value="'.POSTval('curl_timeout', $info['curl_timeout']).'" />
				</div>
			</div>
			<div class="row mx-auto w-100 my-3">
				<div class=" col-6 p-0">
					<label class="control-label">'.__('Delete User with no VPS').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If checked, then users with no VPS will be deleted on a daily basis.').'"><i class="fas text-primary fa-info-circle"></i></a></label>
				</div>
				<div class=" col-6 p-0">
					'.get_checkbox('del_novps_user', '', '', array('chk_it' => 1, 'val' => @$info['del_novps_user'])).'
				</div>
			</div>
			<div class="row mx-auto w-100 my-3">
				<div class="col-sm-6 p-0">
					<label class="control-label">'.__('Default Password Strength').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If set, users will be forced to set the password of specified strength').'"><i class="fas text-primary fa-info-circle"></i></a></label>
				</div>
				<div class="col-sm-6 p-0">
					<input type="text" class="form-control" name="pass_strength" value="'.POSTval('pass_strength', $info['pass_strength']).'" />
				</div>
			</div>';
			}

			if($master){
			echo '<div class="row mx-auto w-100 my-3">
				<div class=" col-6 p-0">
					<label class="control-label">'.__('Turn On Virt-df').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If checked, virt-df will be used to get the disk usage in hourly cron, and the disk usage will be detected on startup of individual VPS(s).').'"><i class="fas text-primary fa-info-circle"></i></a></label>
				</div>
				<div class=" col-6 p-0">
					'.get_checkbox('turnon_virtdf', '', '', array('chk_it' => 1, 'val' => $info['turnon_virtdf'])).'
				</div>
			</div>';
			}

			echo '<div class="row mx-auto w-100 my-3">
				<div class=" col-6 p-0">
					<label class="control-label">'.__('Delete OS Template on Slave Server').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If checked then OS template from all Slave servers will be deleted. This is useful to save space on the slaves. But it will require much more bandwidth as the template will be re-downloaded every time a VPS is created.').'"><i class="fas text-primary fa-info-circle"></i></a></label>
				</div>
				<div class=" col-6 p-0">
					'.get_checkbox('del_slave_ostemplate', '', '', array('chk_it' => 1, 'val' => $info['del_slave_ostemplate'])).'
				</div>
			</div>
			<div class="row mx-auto w-100 my-3">
				<div class=" col-6 p-0">
					<label class="control-label">'.__('Do not delete Orphan OS Template(s)').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If checked, then Orphan OS template which are not added to Virtualizor will not be deleted.').'"><i class="fas text-primary fa-info-circle"></i></a></label>
				</div>
				<div class=" col-6 p-0">
					'.get_checkbox('keep_orphan_template', '', '', array('chk_it' => 1, 'val' => $info['keep_orphan_template'])).'
				</div>
			</div>
			<div class="row mx-auto w-100 my-3">
				<div class=" col-6 p-0">
					<label class="control-label">'.__('Disable virt-top').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If checked, statistics about CPU and DISK I/O of VPS on supported hypervisors will not display the values.').'"><i class="fas text-primary fa-info-circle"></i></a></label>
				</div>
				<div class=" col-6 p-0">
					'.get_checkbox('disable_virttop', '', 'disable_virttop', array('chk_it' => 1, 'val' => $info['disable_virttop'])).'
				</div>
			</div>
			<div class="row mx-auto w-100 my-3">
				<div class="col-6 p-0">
					<label class="control-label">'.__('Disable virt-sparsify').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If checked, VPS will not be sparsed after every Start/PowerOff operation').'"><i class="fas text-primary fa-info-circle"></i></a></label>
				</div>
				<div class="col-6 p-0">
					'.get_checkbox('disable_virtsparsify', '', 'disable_virtsparsify', array('chk_it' => 1, 'val' => $info['disable_virtsparsify'])).'
				</div>
			</div>
			<div class="row mx-auto w-100 my-3">
				<div class=" col-6 p-0">	
					<label class="control-label">'.__('Display Search Box (By Default)').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If checked, Search Box will be displayed on pages where applicable in the admin panel.').'"><i class="fas text-primary fa-info-circle"></i></a></label>
				</div>
				<div class=" col-6 p-0">
					'.get_checkbox('showsearch', '', '', array('chk_it' => 1, 'val' => $info['showsearch'])).'
				</div>
			</div>';

			if($master){

			echo '
			<div class="row mx-auto w-100 my-3">
				<div class=" col-6 p-0">
					<label class="control-label">'.__('Sort VPS by ID in descending order').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If checked newly created VPS will be shown first').'"><i class="fas text-primary fa-info-circle"></i></a></label>
				</div>
				<div class=" col-6 p-0">
					'.get_checkbox('enable_idsort', '', '', array('chk_it' => 1, 'val' => $info['enable_idsort'])).'
				</div>
			</div>

			<div class="row mx-auto w-100 my-3">
				<div class=" col-sm-6 p-0">
					<label class="control-label">'.__('Set the default Server Group name').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If not set then Default will be shown on Server Group which is created by default by Virtualizor').'"><i class="fas text-primary fa-info-circle"></i></a></label>
				</div>
				<div class=" col-sm-6 p-0">
					<input type="text" class="form-control" name="default_sg_name" value="'.POSTval('default_sg_name', $info['default_sg_name']).'" />
				</div>
			</div>

			<div class="row mx-auto w-100 my-3">
				<div class=" col-sm-6 p-0">
					<label class="control-label">'.__('Set the default Reseller Region Name').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('(Optional) The name of the server group that will be shown to resellers. If not set Default will be set').'"><i class="fas text-primary fa-info-circle"></i></a></label>
				</div>
				<div class=" col-sm-6 p-0">
					<input type="text" class="form-control" name="default_sg_reseller_name" value="'.POSTval('default_sg_reseller_name', $info['default_sg_reseller_name']).'" />
				</div>
			</div>

			<div class="row mx-auto w-100 my-3">
				<div class=" col-sm-6 p-0">
					<label class="control-label">'.__('Set RAM threshold to lock server (%)').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If provided then server will be locked after exceeding threshold value of RAM').'"><i class="fas text-primary fa-info-circle"></i></a></label>
				</div>
				<div class=" col-sm-6 p-0">
					<input type="text" class="form-control" name="server_ram_threshold" value="'.POSTval('server_ram_threshold', $info['server_ram_threshold']).'" />
				</div>
			</div>
			<div class="row mx-auto w-100 my-3">
				<div class=" col-sm-6 p-0">
					<label class="control-label">'.__('Set Primary storage threshold to lock server (%)').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If provided then server will be locked after exceeding threshold value of primary storage').'"><i class="fas text-primary fa-info-circle"></i></a></label>
				</div>
				<div class=" col-sm-6 p-0">
					<input type="text" class="form-control" name="server_disk_threshold" value="'.POSTval('server_disk_threshold', $info['server_disk_threshold']).'" />
				</div>
			</div>
			<div class="row mx-auto w-100 my-3">
				<div class=" col-sm-6 p-0">
					<label class="control-label">'.__('Set the default Server Group Description').'</label>
				</div>
				<div class=" col-sm-6 p-0">
					<textarea class="form-control" name="default_sg_desc" >'.POSTval('default_sg_desc', $info['default_sg_desc']).'</textarea>
				</div>
			</div>
			';
			}
			if($master){
				echo'<div class="row mx-auto w-100 my-3">
						<div class="col-6 p-0">
							<label class="control-label">'.__('Delete Backup on VPS deletion').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If checked Backup will get deleted on VPS deletion.').'"><i class="fas text-primary fa-info-circle"></i></a></label>
						</div>
						<div class="col-6 p-0">
							'.get_checkbox('enable_backup_delete', '', 'enable_backup_delete', array('chk_it' => 1, 'val' => $info['enable_backup_delete'])).'
						</div>
					</div>
					<div class="row mx-auto w-100 my-3" id="enable_backup_delete_cron" style="display:none;">
						<div class="col-sm-6 p-0">
							<label class="control-label">'.__('Number of days').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If it is zero VPS Backup will get deleted immediately on VPS deletion.<br>Or it will get deleted after provided number of days.').'"><i class="fas text-primary fa-info-circle"></i></a></label>
						</div>
						<div class="col-sm-6 p-0">
							<input type="text" class="form-control" name="enable_backup_delete_cron" value="'.(empty(POSTval('enable_backup_delete_cron', $info['enable_backup_delete_cron'])) ? '0' : POSTval('enable_backup_delete_cron', $info['enable_backup_delete_cron'])).'" />
						</div>
					</div>
					<div class="row mx-auto w-100 my-3">
						<div class="col-6 p-0">
							<label class="control-label">'.__('Disable 2TB check for VPS').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If checked, VPS creation of size greater than 2TB will be allowed').'"><i class="fas text-primary fa-info-circle"></i></a></label>
						</div>
						<div class="col-6 p-0">
							'.get_checkbox('disable_2tb_check', '', 'disable_2tb_check', array('chk_it' => 1, 'val' => $info['disable_2tb_check'])).'
						</div>
					</div>
					<div class="row mx-auto w-100 my-3">
						<div class=" col-6 p-0">
							<label class="control-label">'.__('Use <b>vzctl suspend</b> for virtuozzo CT').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If enabled then virtuozzo container will be suspended using vzctl command').'"><i class="fas text-primary fa-info-circle"></i></a></label>
						</div>
						<div class=" col-6 p-0">
							'.get_checkbox('vz6_style_suspend', '', '', array('chk_it' => 1, 'val' => $info['vz6_style_suspend'])).'
						</div>
					</div>
					<div class="row mx-auto w-100 my-3">
						<div class="col-6 p-0"><label class="control-label">'.__('Compression algorithm').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Choose the compression algorithm, for proxmox (zstd, lzop is only supported) (on ubuntu zstd is experimental)').'"><i class="fas text-primary fa-info-circle"></i></a></label></div>
						<div class="col-6 p-0" valign="top">
							<select class="custom-select virt-select" name="compression_algo">';
							echo'<option value="0">'.__('None').'</option>';
								foreach ($valid_compression as $key => $value) {
									echo '<option value="'.$value.'" '. ($info['compression_algo'] == $value ? 'selected="selected"' : '') .'>'.$value.'</option>';
								}

						echo '</select>
						</div>
					</div>
					<div class="row mx-auto w-100 my-3">
						<div class=" col-6 p-0">
							<label class="control-label">'.__('Disable recipe execution on rebuild').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If enabled, then recipe set in VPS Plan will not get executed').'"><i class="fas text-primary fa-info-circle"></i></a></label>
						</div>
						<div class=" col-6 p-0">
							'.get_checkbox('disable_recipe_reinstall', '', '', array('chk_it' => 1, 'val' => $info['disable_recipe_reinstall'])).'
						</div>
					</div>';
			}
			
			echo'
				<div class="row mx-auto w-100 my-3">
					<div class=" col-sm-6 p-0">
						<label class="control-label">'.__('Set MTU value in VPS config file').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If enabled, then MTU value will be set in VPS config file for supported Virtualizations').'"><i class="fas text-primary fa-info-circle"></i></a></label>
					</div>
					<div class=" col-sm-6 p-0">
						'.get_checkbox('set_vps_config_mtu', '', '', array('chk_it' => 1, 'val' => $info['set_vps_config_mtu'])).'
					</div>
				</div>';
			if($master){
				echo'
				<div class="row mx-auto w-100 my-3">
					<div class=" col-6 p-0">
						<label class="control-label">'.__('Use Windows Configuration script').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If enabled Static ips, Location and other operations will be performed').'"><i class="fas text-primary fa-info-circle"></i></a></label>
					</div>
					<div class=" col-6 p-0">
						'.get_checkbox('use_win_script', '', '', array('chk_it' => 1, 'val' => $info['use_win_script'])).'
					</div>
				</div>
				<div class="row mx-auto w-100 my-3">
					<div class=" col-6 p-0">
						<label class="control-label">'.__('Disable Notifications').'</label>
					</div>
					<div class=" col-6 p-0">
						'.get_checkbox('disable_notifications', '', '', array('chk_it' => 1, 'val' => $info['disable_notifications'])).'
					</div>
				</div>
				<div class="row mx-auto w-100 my-3">
					<div class="col-6 p-0">
						<label class="control-label">'.__('Save Password of VPS').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If enabled, then VPS password will be stored and will be visible to Endusers only. Admin will not be able to see the password.').'"><i class="fas text-primary fa-info-circle"></i></a></label>
					</div>
					<div class="col-6 p-0">
						'.get_checkbox('save_vm_pass', '', '', array('chk_it' => 1, 'val' => $info['save_vm_pass'])).'
					</div>
				</div>
				<div class="row mx-auto w-100 my-3" id="dont_delete_bw_from_db">
					<div class="col-sm-6 p-0">
						<label class="control-label">'.__('Do not delete Bandwidth data').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If checked, then bandwidth data for each 5 minute will not be deleted').'"><i class="fas text-primary fa-info-circle"></i></a></label>
					</div>
					<div class="col-sm-6 p-0">
						'.get_checkbox('dont_delete_bw_from_db', '', '', array('chk_it' => 1, 'val' => $info['dont_delete_bw_from_db'])).'
					</div>
				</div>';
			}
				echo '
				<div class="row mx-auto w-100 my-3" id="memory_limit">
					<div class="col-sm-6 p-0">
						<label class="control-label">'.__('Memory Limit (in MBs)').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('You can increase memory limit if you are facing syncing issues, by default it will be 128M').'"><i class="fas text-primary fa-info-circle"></i></a></label>
					</div>
					<div class="col-sm-6 p-0">
						<input type="text" class="form-control" name="memory_limit" value="'.POSTval('memory_limit', (int) $info['memory_limit']).'" />
					</div>
				</div>
				<div class="row mx-auto w-100 my-3" id="temporary_st_directory">
					<div class="col-sm-6 p-0">
						<label class="control-label">'.__('Temporary Backup Directory').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('During Remote Backup Temporary data will be stored in this directory').'"><i class="fas text-primary fa-info-circle"></i></a></label>
					</div>
					<div class="col-sm-6 p-0">
						<input type="text" class="form-control" name="temporary_st_directory" value="'.POSTval('temporary_st_directory', $info['temporary_st_directory']).'" />
					</div>
				</div>
				<div class="row mx-auto w-100 my-3" id="disable_guest_agent">
					<div class="col-sm-6 p-0">
						<label class="control-label">'.__('Disable Guest Agent').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If enabled, then guest agent will not be installed/enabled for the VPS').'"><i class="fas text-primary fa-info-circle"></i></a></label>
					</div>
					<div class="col-sm-6 p-0">
						'.get_checkbox('disable_guest_agent', '', '', array('chk_it' => 1, 'val' => $info['disable_guest_agent']), 1).'
					</div>
				</div>
				<div class="row mx-auto w-100 my-3" id="enable_vm_setup_wizard">
					<div class="col-sm-6 p-0">
						<label class="control-label">'.__('Enable VPS Setup for enduser').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If enabled, VPS will not be created from admin panel. User will be able to choose OS and password').'"><i class="fas text-primary fa-info-circle"></i></a></label>
					</div>
					<div class="col-sm-6 p-0">
						'.get_checkbox('enable_vm_setup_wizard', '', '', array('chk_it' => 1, 'val' => $info['enable_vm_setup_wizard']), 1).'
					</div>
				</div>
			</div>
		</div>';
		if($master){
			echo'
			<div class="divroundshad card mb-3">
				<div class="roundheader">'.__('Vertical Scaling Settings').'</div>
				<div class="px-3">
					<div class="row mx-auto w-100">
						<div class="col-sm-12 notice">
							'.__('<ol class="pl-2 mb-1">
<li>Vertical scaling is supported on KVM based virtualization only.</li>
<li>QEMU version should be greater than or equal to 1.5, To check QEMU Version run "/usr/bin/virsh version"</li>
<li>Vertical scaling is currently not supported on Windows VPS</li>
</ol>').'
						</div>
					</div>
					<div class="row mx-auto w-100">
						<div class="col-6 p-0">
							<label class="control-label">'.__('Enable vertical scaling').'</label>
						</div>
						<div class="col-6 p-0">
							'.get_checkbox('enable_ver_scaling', '', 'enable_ver_scaling', array('chk_it' => 1, 'val' => $info['enable_ver_scaling'])).'
						</div>
					</div>
					<div class="row mx-auto w-100 my-3 ver_scale_settings" id="ver_max_ram_div">
						<div class="col-sm-6 p-0">
							<label class="control-label">'.__('Max RAM (in MB)').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Provide the maximum amount of RAM that will be allocated to VPS ').'"><i class="fas text-primary fa-info-circle"></i></a></label>
						</div>
						<div class="col-sm-6 p-0">
							<input type="text" class="form-control" name="ver_max_ram" value="'.POSTval('ver_max_ram', $info['ver_max_ram']).'" />
						</div>
					</div>
					<div class="row mx-auto w-100 my-3 ver_scale_settings" id="ver_ram_threshold_div">
						<div class="col-sm-6 p-0">
							<label class="control-label">'.__('RAM Threshold (in %)').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If the VPS RAM usage is greater/less than threshold provided scaling will be performed accordingly').'"><i class="fas text-primary fa-info-circle"></i></a></label>
						</div>
						<div class="col-sm-6 p-0">
							<input type="text" class="form-control" name="ver_ram_threshold" value="'.POSTval('ver_ram_threshold', $info['ver_ram_threshold']).'" />
						</div>
					</div>
					<div class="row mx-auto w-100 my-3 ver_scale_settings" id="ver_ram_inc_by_div">
						<div class="col-sm-6 p-0">
							<label class="control-label">'.__('Increase/Decrease RAM By (in GB)').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If the threshold exceeds/subceed, the provided RAM (in GB) will be increased or decreased accordingly').'"><i class="fas text-primary fa-info-circle"></i></a></label>
						</div>
						<div class="col-sm-6 p-0">
							<input type="text" class="form-control" name="ver_ram_inc_by" value="'.POSTval('ver_ram_inc_by', $info['ver_ram_inc_by']).'" />
						</div>
					</div>
					<div class="row mx-auto w-100 my-3 ver_scale_settings" id="ver_max_cpu_id_div">
						<div class="col-sm-6 p-0">
							<label class="control-label">'.__('Max CPU Cores').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Provide the maximum amount of cpu cores that will be allocated to VPS ').'"><i class="fas text-primary fa-info-circle"></i></a></label>
						</div>
						<div class="col-sm-6 p-0">
							<input type="text" class="form-control" name="ver_max_cpu" value="'.POSTval('ver_max_cpu', $info['ver_max_cpu']).'" />
						</div>
					</div>
					<div class="row mx-auto w-100 my-3 ver_scale_settings" id="ver_cpu_threshold_div">
						<div class="col-sm-6 p-0">
							<label class="control-label">'.__('CPU Threshold (in %)').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If the VPS cpu usage is greater/less than threshold provided scaling will be performed accordingly').'"><i class="fas text-primary fa-info-circle"></i></a></label>
						</div>
						<div class="col-sm-6 p-0">
							<input type="text" class="form-control" name="ver_cpu_threshold" value="'.POSTval('ver_cpu_threshold', $info['ver_cpu_threshold']).'" />
						</div>
					</div>
					<div class="row mx-auto w-100 my-3 ver_scale_settings" id="ver_cpu_inc_by_div">
						<div class="col-sm-6 p-0">
							<label class="control-label">'.__('Increase/Decrease CPU Cores By').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If the threshold exceeds/subceed, the provided cores will be increased or decreased accordingly').'"><i class="fas text-primary fa-info-circle"></i></a></label>
						</div>
						<div class="col-sm-6 p-0">
							<input type="text" class="form-control" name="ver_cpu_inc_by" value="'.POSTval('ver_cpu_inc_by', $info['ver_cpu_inc_by']).'" />
						</div>
					</div>
				</div>
			</div>
			';
		}
		if($master){
			echo '<div  class="divroundshad card mb-3">
				<div class="roundheader">'.__('Sever Group Preferences').'</div>
				<div class="px-3">
					<div class="row mx-auto w-100 my-3">
						<div class="col-6 p-0">
							<label class="control-label">'.__('Server Selection').'</label>
						</div>
						<div class="col-6 p-0">
							<div class="row w-100">
								<div class="col-12">
									<label class="custom-control custom-radio">
										<input type="radio" class="custom-control-input" id="resource_preference_none" name="resource_preference" value="0" '.POSTradio('resource_preference', '0', $info['resource_preference']).'>
										<span class="custom-control-label" for="resource_preference_none">'.__('None').'</span>
									</label>
								</div>
								<div class="col-12">
									<label class="custom-control custom-radio">
										<input type="radio" class="custom-control-input" id="resource_preference1" name="resource_preference" value="1" '.POSTradio('resource_preference', '1', $info['resource_preference']).'>
										<span class="custom-control-label" for="resource_preference1">'.__('Most Available Space').'</span>
									</label>
								</div>
								<div class="col-12">
									<label class="custom-control custom-radio">
										<input type="radio" class="custom-control-input" id="resource_preference2" name="resource_preference" value="2" '.POSTradio('resource_preference', '2', $info['resource_preference']).'>
										<span class="custom-control-label" for="resource_preference2">'.__('Most Available Ram').'</span>
									</label>
								</div>
								<div class="col-12">
									<label class="custom-control custom-radio">
										<input type="radio" class="custom-control-input" id="resource_preference3" name="resource_preference" value="3" '.POSTradio('resource_preference', '3', $info['resource_preference']).'>
										<span class="custom-control-label" for="resource_preference3">'.__('Most Available Cores').'</span>
									</label>
								</div>
								<div class="col-12">
									<label class="custom-control custom-radio">
										<input type="radio" class="custom-control-input" id="resource_preference4" name="resource_preference" value="4" '.POSTradio('resource_preference', '4', $info['resource_preference']).'>
										<span class="custom-control-label" for="resource_preference4">'.__('Most Available IPv4').'</span>
									</label>
								</div>
								<div class="col-12">
									<label class="custom-control custom-radio">
										<input type="radio" class="custom-control-input" id="resource_preference5" name="resource_preference" value="5" '.POSTradio('resource_preference', '5', $info['resource_preference']).'>
										<span class="custom-control-label" for="resource_preference5">'.__('Most Available IPv6').'</span>
									</label>
								</div>
								<div class="col-12">
									<label class="custom-control custom-radio">
										<input type="radio" class="custom-control-input" id="resource_preference6" name="resource_preference" value="6" '.POSTradio('resource_preference', '6', $info['resource_preference']).'>
										<span class="custom-control-label" for="resource_preference6">'.__('Most Available IPv6 Subnets').'</span>
									</label>
								</div>
								<div class="col-12">
									<label class="custom-control custom-radio">
										<input type="radio" class="custom-control-input" id="resource_preference7" name="resource_preference" value="7" '.POSTradio('resource_preference', '7', $info['resource_preference']).'>
										<span class="custom-control-label" for="resource_preference7">'.__('Least Number of VPS').'</span>
									</label>
								</div>
								<div class="col-12">
									<label class="custom-control custom-radio">
										<input type="radio" class="custom-control-input" id="resource_preference8" name="resource_preference" value="8" '.POSTradio('resource_preference', '8', $info['resource_preference']).'>
										<span class="custom-control-label" for="resource_preference8">'.__('Least System Load').'</span>
									</label>
								</div>
							</div>
						</div>
					</div>
				</div>
				<div class="row mx-auto w-100 my-3">
					<div class=" col-6">
						<label class="control-label">'.__('Show Server Selection logs').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Display server selection logs on task page inside create VPS task').'"><i class="fas text-primary fa-info-circle"></i></a></label>
					</div>
					<div class=" col-6 p-0">
						'.get_checkbox('show_server_selection_logs', '', '', array('chk_it' => 1, 'val' => $info['show_server_selection_logs'])).'
					</div>
				</div>
			</div>';
		}
		echo'
		<div  class="divroundshad card mb-3">
			<div class="roundheader">'.__('Database Settings').'</div>
			<div class="px-3">
				<div class="row mx-auto w-100 my-3">
					<div class=" col-6 p-0">
						<label class="control-label">'.__('Disable database backup on slave servers').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If checked slave servers will not take database backup').'"><i class="fas text-primary fa-info-circle"></i></a></label>
					</div>
					<div class=" col-6 p-0">
						'.get_checkbox('disable_slave_db_backup', '', '', array('chk_it' => 1, 'val' => $info['disable_slave_db_backup'])).'
					</div>
				</div>
			</div>
		</div>
		
		<div  class="divroundshad card mb-3">
			<div class="roundheader">'.__('Network Settings').'</div>
			<div class="px-3">
				<div class="row mx-auto w-100 my-3">
					<div class="col-sm-6 p-0">
						<label class="control-label">'.__('Network Interface').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('The public network interface of the server. If left empty, <strong>eth0</strong> will be assumed as the default interface.').'"><i class="fas text-primary fa-info-circle"></i></a></label>
					</div>
					<div class="col-sm-6 p-0">
						<input type="text" class="form-control" name="interface" id="interface" size="30" value="'.POSTval('interface', $info['interface']).'" />
					</div>
				</div>
				<div class="row mx-auto w-100 my-3">
					<div class="col-sm-6 p-0">
						<label class="control-label">'.__('Node Bandwidth').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('The total bandwidth of the Node in GB. If set to Zero, the bandwidth calculation will assume unlimited bandwidth').'"><i class="fas text-primary fa-info-circle"></i></a></label>
					</div>
					<div class="col-sm-6 p-0">
						<input type="number" class="form-control" name="node_bandwidth" id="node_bandwidth" size="20" value="'.POSTval('node_bandwidth', $info['node_bandwidth']).'" />
					</div>
				</div>
				<div class="row mx-auto w-100 my-3">
					<div class="col-sm-6 p-0">
						<label class="control-label">'.__('Set Ping IP').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('When the Virtualizor Bridge Network is started it will try to ping to this IP to check if the server has connectivity. If empty, then Virtualizor will ping 4.2.2.1').'"><i class="fas text-primary fa-info-circle"></i></a></label>
					</div>
					<div class="col-sm-6 p-0">
						<input type="text" class="form-control" name="ping_ip" id="ping_ip" size="20" value="'.POSTval('ping_ip', $info['ping_ip']).'" />
					</div>
				</div>';
				if($master){
					echo '
					<div class="row mx-auto w-100 my-3">
						<div class="col-sm-6 p-0">
							<label class="control-label">'.__('VPS Bandwidth Threshold').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If set to Zero bandwidth threshold email will be disabled. Value in %').'"><i class="fas text-primary fa-info-circle"></i></a></label>
						</div>
						<div class="col-sm-6 p-0">
							<input type="number" class="form-control" name="vps_bandwidth_threshold" id="vps_bandwidth_threshold" size="20" value="'.POSTval('vps_bandwidth_threshold', $info['vps_bandwidth_threshold']).'" />
						</div>
					</div>
					<div class="row mx-auto w-100 my-3">
						<div class=" col-6 p-0">
							<label class="control-label">'.__('Bandwidth suspend ').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If checked then all the cloud user\'s VPS(s) will be suspended if the specified bandwidth limit is exceeded').'"><i class="fas text-primary fa-info-circle"></i></a></label>
						</div>
						<div class=" col-6 p-0">
							'.get_checkbox('band_suspend', '', '', array('chk_it' => 1, 'val' => $info['band_suspend'])).'
						</div>
					</div>
					<div class="row mx-auto w-100 my-3">
						<div class=" col-6 p-0">
							<label class="control-label">'.__('Service period bandwidth calculation').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('This option will calculate the bandwidth as per the VPS service period. For example, if the VPS is created on 15th Jan, the bandwidth calculation will be from 15 Jan to 14th Feb.').'"><i class="fas text-primary fa-info-circle"></i></a></label>
						</div>
						<div class=" col-6 p-0">
							'.get_checkbox('band_calc_creation', '', '', array('chk_it' => 1, 'val' => $info['band_calc_creation'])).'
						</div>
					</div>
					<div class="row mx-auto w-100 my-3">
						<div class="col-6 p-0">
							<label class="control-label">'.__('Disable ebtables').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If checked, ebtables rules will not be created on all the servers for VPS(s). If you want to remove ebtables rules for existing VPS(s) then after enbaling this setting you will need to edit the VPS(s) or update network rules for the VPS(s).No need to stop or restart the VPS(s)').'"><i class="fas text-primary fa-info-circle"></i></a></label>
						</div>
						<div class="col-6 p-0">
							'.get_checkbox('disable_ebtables', '', '', array('chk_it' => 1, 'val' => $info['disable_ebtables'])).'
						</div>
					</div>
					<div class="row mx-auto w-100 my-3">
						<div class="col-6 p-0">
							<label class="control-label">'.__('Disable internal IP ebtables').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If checked, internal IP ebtables rules will not be created on all the servers for VPS(s). If you want to remove ebtables rules for existing VPS(s) then after enbaling this setting you will need to edit the VPS(s) or update network rules for the VPS(s).No need to stop or restart the VPS(s)').'"><i class="fas text-primary fa-info-circle"></i></a></label>
						</div>
						<div class="col-6 p-0">
							'.get_checkbox('disable_ebtables_internal', '', '', array('chk_it' => 1, 'val' => $info['disable_ebtables_internal'])).'
						</div>
					</div>';
				}
				if(empty($master)){
					echo '
						<div class="row mx-auto w-100 my-3">
						<div class=" col-6 p-0">
							<label class="control-label">'.__('Disable Network configuration').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If checked, Virtualizor will not configure/re-write network when a VPS is rebooted. However, during creation of the VPS, the network file will be written.').'"><i class="fas text-primary fa-info-circle"></i></a></label>
						</div>
						<div class=" col-6 p-0">
							'.get_checkbox('disable_nw_config', '', '', array('chk_it' => 1, 'val' => $info['disable_nw_config'])).'
						</div>
					</div>
					<div class="row mx-auto w-100 my-3">
						<div class=" col-6 p-0">
							<label class="control-label">'.__('Drop ARP Broadcast').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If checked, then ALL ARP broadcast will be DROPPED and ARP Broadcast will be allowed ONLY for the VPS which are created via our panel').'"><i class="fas text-primary fa-info-circle"></i></a></label>
						</div>
						<div class=" col-6 p-0">
							'.get_checkbox('drop_arp_broadcast', '', 'drop_arp_broadcast', array('chk_it' => 1, 'val' => $info['drop_arp_broadcast'])).'
						</div>
					</div>
					<div class="row mx-auto w-100 my-3">
						<div class="col-6 p-0">
						<label class="control-label">'.__('Bandwidth Calculation').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Bandwidth calculation based on upload/download').'"><i class="fas text-primary fa-info-circle"></i></a></label>
						</div>
						<div class="col-6 p-0">
							<label class="custom-control custom-radio">
								<input type="radio" class="custom-control-input" id="bw_cal_config1" name="bw_cal_config" value="0" '.(POSTval('bw_cal_config', $info['bw_cal_config']) == 0 ? 'checked="checked"' : '').'>
								<span class="custom-control-label" for="bw_cal_config1">'.__('Normal Bandwidth calculation. Total usage will be shown as sum of upload and download.').'</span>
							</label> 
							<label class="custom-control custom-radio">
								<input type="radio" class="custom-control-input" id="bw_cal_config2" name="bw_cal_config" value="1" '.(POSTval('bw_cal_config', $info['bw_cal_config']) == 1 ? 'checked="checked"' : '').'>
								<span class="custom-control-label" for="bw_cal_config2">'.__('Bandwidth calculation for download only. Total usage will be shown for download only.').'</span>
							</label> 
							<label class="custom-control custom-radio">
								<input type="radio" class="custom-control-input" id="bw_cal_config3" name="bw_cal_config" value="2" '.(POSTval('bw_cal_config', $info['bw_cal_config']) == 2 ? 'checked="checked"' : '').'>
								<span class="custom-control-label" for="bw_cal_config3">'.__('Bandwidth calculation for upload only. Total usage will be shown for upload only.').'</span>
							</label>
						</div>
					</div>
					';
				}
				echo '
				<div class="row mx-auto w-100 my-3">
					<div class=" col-6 p-0">
						<label class="control-label">'.__('Disable Speed Capping').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Global setting to disable VPS network speed capping').'"><i class="fas text-primary fa-info-circle"></i></a></label>
					</div>
					<div class=" col-6 p-0">
						'.get_checkbox('speed_cap_disable', '', 'speed_cap_disable', array('chk_it' => 1, 'val' => $info['speed_cap_disable'])).'
					</div>
				</div>';

		echo '
			</div>
		</div>'; // End of network setting DIV

		echo '
		<div  class="divroundshad card mb-3">
			<div class="roundheader">'.__('HAProxy Settings (VPS Domain Forwarding)').'</div>
			<div class="px-3">
				<div class="row mx-auto w-100 my-3">
					<div class=" col-6 p-0">
						<label class="control-label">'.__('Enable HAProxy').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('This allows VPS(s) to host services on private IPs that can be accessed through internet').'"><i class="fas text-primary fa-info-circle"></i></a></label>
					</div>
					<div class=" col-6 p-0">
						'.get_checkbox('haproxy_enable', '', 'haproxy_enable', array('chk_it' => 1, 'val' => $info['haproxy_enable'])).'
					</div>
				</div>';

				if(empty($master)){
					echo '

				<div class="row mx-auto w-100 my-3">
					<div class=" col-sm-6 p-0">
						<label class="control-label">'.__('HAProxy Source IPs').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Comma seperated list of IPs on which HAProxy is allowed to listen on this server. If blank, the slave servers primary IP will be used.<br/>Note: Modifying source IPs will also require to remap old source IPs with new under Admin Panel > Virtual Server > Domain Forwarding > Servers page to update existing VDF records with new source IPs').'"><i class="fas text-primary fa-info-circle"></i></a></label>
					</div>
					<div class=" col-sm-6 p-0">
						<input type="text" class="form-control haproxy" id="haproxy_src_ips" name="haproxy_src_ips" value="'.POSTval('haproxy_src_ips', (!empty($info['haproxy_src_ips']) ? $info['haproxy_src_ips'] : server_publicip($globals['serid']))).'" />
					</div>
				</div>';
				}

				echo '
				<div class="row mx-auto w-100 my-3">
					<div class=" col-sm-6 p-0">
						<label class="control-label">'.__('HAProxy Blocked Ports').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('List of source ports which will not be allowed for HAProxy. Multiple ports should be seprated by \',\' and port range must be specified with \'-\'. (eg: 26,99,1001-1005)').'"><i class="fas text-primary fa-info-circle"></i></a></label>
					</div>
					<div class=" col-sm-6 p-0">
						<input type="text" class="form-control haproxy" id="haproxy_reservedports" name="haproxy_reservedports" value="'.POSTval('haproxy_reservedports', $info['haproxy_reservedports']).'" />
					</div>
				</div>
				<div class="row mx-auto w-100 my-3">
					<div class=" col-sm-6 p-0">
						<label class="control-label">'.__('HAProxy Reserved ports for HTTP(S) only').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('List of source ports reserved for HAProxy to be used only for HTTP and HTTPS protocol i.e. these ports will not be allowed for any TCP ports in HAProxy. Multiple ports should be seprated by \',\' and port range must be specified with \'-\'. (eg: 26,99,1001-1005)').'"><i class="fas text-primary fa-info-circle"></i></a></label>
					</div>
					<div class=" col-sm-6 p-0">
						<input type="text" class="form-control haproxy" id="haproxy_reservedports_http" name="haproxy_reservedports_http" value="'.POSTval('haproxy_reservedports_http', (empty($info['haproxy_reservedports_http']) ? '80,443' : $info['haproxy_reservedports_http'])).'" />
					</div>
				</div>
				<div class="row mx-auto w-100 my-3">
					<div class=" col-sm-6 p-0">
						<label class="control-label">'.__('HAProxy Allowed Ports for HTTP(S) and TCP').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('List of source ports allowed to be used for any protocol for HAProxy. If left blank, any port available will be allowed to the user. <b>Note</b> : If specified, HTTP and TCP ports will be allowed only from these port(s). Multiple ports should be seprated by \',\' and port range must be specified with \'-\'. (eg: 26,99,1001-1005)').'"><i class="fas text-primary fa-info-circle"></i></a></label>
					</div>
					<div class=" col-sm-6 p-0">
						<input type="text" class="form-control haproxy" id="haproxy_allowedports" name="haproxy_allowedports" value="'.POSTval('haproxy_allowedports', $info['haproxy_allowedports']).'" />
					</div>
				</div>
			</div>
		</div>
		';
		if($master){
					echo '<div  class="divroundshad card mb-3">
						<div class="roundheader">'.__('Enduser Backup Settings').'</div>
						<div class="px-3">
							<div class="row mx-auto w-100 my-3">
								<div class="col-sm-6 p-0">
									<label class="control-label">'.__('Backup Queue').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Max number of simultaneous enduser backup operations allowed. Set -1 for unlimited.').'"><i class="fas text-primary fa-info-circle"></i></a></label>
								</div>
								<div class="col-sm-6 p-0">
									<input type="text" class="form-control" name="backup_queue" size="10" value="'.POSTval('backup_queue', @$info['backup_queue']).'" />
								</div>
							</div>
							<div class="row mx-auto w-100 my-3">
								<div class="col-sm-6 p-0">
									<label class="control-label">'.__('Restore Queue').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Max number of simultaneous enduser restore operations allowed. Set -1 for unlimited.').'"><i class="fas text-primary fa-info-circle"></i></a></label>
								</div>
								<div class="col-sm-6 p-0">
									<input type="text" class="form-control" name="restore_queue" size="10" value="'.POSTval('restore_queue', @$info['restore_queue']).'" />
								</div>
							</div>
							<div class="row mx-auto w-100 my-3">
								<div class=" col-6 p-0">
									<label class="control-label">'.__('Disable Backup in Client panel').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('By default Backup icon will be Displayed.').'"><i class="fas text-primary fa-info-circle"></i></a></label>
								</div>
								<div class=" col-6 p-0">
									'.get_checkbox('disable_backup_cp', '', '', array('chk_it' => 1, 'val' => $info['disable_backup_cp'])).'
								</div>
							</div>
							<div class="row mx-auto w-100 my-3">
								<div class=" col-sm-6 p-0">
									<label class="control-label">'.__('Backup / Restore Email').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('The email where backup / restore mails for success and error messages will be sent.<br /><b>Note:</b> If empty, the mails will be sent to the site admin email.').'"><i class="fas text-primary fa-info-circle"></i></a></label>
								</div>
								<div class=" col-sm-6 p-0">
									<input type="text" class="form-control" name="backup_email" size="10" value="'.POSTval('backup_email', $info['backup_email']).'" />
								</div>
							</div>
							<div class="row mx-auto w-100 my-3">
								<div class=" col-6 p-0">
									<label class="control-label">'.__('Disable Backup / Restore Success Mail').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If checked, the backup / restore success mails will not be sent to the admin.<br /><b>Note:</b> Error mails will always be sent regardless of this setting.').'"><i class="fas text-primary fa-info-circle"></i></a></label>
								</div>
								<div class=" col-6 p-0">
									'.get_checkbox('backup_disable_success_mail', '', '', array('chk_it' => 1, 'val' => $info['backup_disable_success_mail'])).'
								</div>
							</div>
						</div>
					</div>';
				}
		
			if($master){
					
				echo '
				<div  class="divroundshad card mb-3">
					<div class="roundheader">'.__('Logs Settings').'</div>
					<div class="px-3">
						<div class="row mx-auto w-100 my-3">
							<div class="col-sm-6 p-0">
								<label class="control-label">'.__('Admin Logs Retention').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Admin logs will be saved for the specified number of days. (0 for infinite retention)').'"><i class="fas text-primary fa-info-circle"></i></a></label>
							</div>
							<div class="col-sm-6 p-0">
								<input type="text" class="form-control" name="admin_logs" id="admin_logs" size="30" value="'.POSTval('admin_logs', $info['admin_logs']).'" />
							</div>
						</div>

						<div class="row mx-auto w-100 my-3">
							<div class="col-sm-6 p-0">
								<label class="control-label">'.__('VPS Logs Retention').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('VPS logs will be saved for the specified number of days. (0 for infinite retention)').'"><i class="fas text-primary fa-info-circle"></i></a></label>
							</div>
							<div class="col-sm-6 p-0">
								<input type="text" class="form-control" name="vps_logs" id="vps_logs" size="30" value="'.POSTval('vps_logs', $info['vps_logs']).'" />
							</div>
						</div>

						<div class="row mx-auto w-100 my-3">
							<div class="col-sm-6 p-0">
								<label class="control-label">'.__('Login Logs Retention').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Login logs will be saved for the specified number of days. (0 for infinite retention)').'"><i class="fas text-primary fa-info-circle"></i></a></label>
							</div>
							<div class="col-sm-6 p-0">
								<input type="text" class="form-control" name="login_logs" id="login_logs" size="30" value="'.POSTval('login_logs', $info['login_logs']).'" />
							</div>
						</div>

						<div class="row mx-auto w-100 my-3">
							<div class="col-sm-6 p-0">
								<label class="control-label">'.__('VPS System Logs Retention').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Logs will be saved for the specified number of days. (0 for infinite retention)').'"><i class="fas text-primary fa-info-circle"></i></a></label>
							</div>
							<div class="col-sm-6 p-0">
								<input type="text" class="form-control" name="system_logs" id="system_logs" size="30" value="'.POSTval('system_logs', $info['system_logs']).'" />
							</div>
						</div>

						<div class="row mx-auto w-100 my-3">
							<div class="col-sm-6 p-0">
								<label class="control-label">'.__('VPS Status Logs Retention').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Logs will be saved for the specified number of days. (0 for infinite retention)').'"><i class="fas text-primary fa-info-circle"></i></a></label>
								<label class="control-label"></label>
								<span class="help-block"></span>
							</div>
							<div class="col-sm-6 p-0">
								<input type="text" class="form-control" name="status_logs" id="status_logs" size="30" value="'.POSTval('status_logs', $info['status_logs']).'" />
							</div>
						</div>

						<div class="row mx-auto w-100 my-3">
							<div class="col-sm-6 p-0">
								<label class="control-label">'.__('Bandwidth Logs Retention').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Logs will be saved for the specified number of days. (0 for infinite retention)').'"><i class="fas text-primary fa-info-circle"></i></a></label>
							</div>
							<div class="col-sm-6 p-0">
								<input type="text" class="form-control" name="bandwidth_logs" id="bandwidth_logs" size="30" value="'.POSTval('bandwidth_logs', $info['bandwidth_logs']).'" />
							</div>
						</div>
						<div class="row mx-auto w-100 my-3">
							<div class="col-sm-6 p-0">
								<label class="control-label">'.__('HAProxy Cron Logs Retention').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Logs will be saved for the specified number of days. (0 for infinite retention)').'"><i class="fas text-primary fa-info-circle"></i></a></label>
							</div>
							<div class="col-sm-6 p-0">
								<input type="text" class="form-control" name="haproxy_cron_logs" id="haproxy_cron_logs" size="30" value="'.POSTval('haproxy_cron_logs', $info['haproxy_cron_logs']).'" />
							</div>
						</div>
						<div class="row mx-auto w-100 my-3">
							<div class="col-sm-6 p-0">
								<label class="control-label">'.__('Tasks Retention').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Tasks will be saved for the specified number of days. (0 for infinite retention)').'"><i class="fas text-primary fa-info-circle"></i></a></label>
							</div>
							<div class="col-sm-6 p-0">
								<input type="text" class="form-control" name="del_tasks" id="del_tasks" size="30" value="'.POSTval('del_tasks', $info['del_tasks']).'" />
							</div>
						</div>
						<div class="row mx-auto w-100 my-3">
							<div class="col-sm-6 p-0">
								<label class="control-label">'.__('Notifications Retention').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Notifications will be saved for the specified number of days. (0 for infinite retention)').'"><i class="fas text-primary fa-info-circle"></i></a></label>
							</div>
							<div class="col-sm-6 p-0">
								<input type="text" class="form-control" name="del_notifications" id="del_notifications" size="30" value="'.POSTval('del_notifications', $info['del_notifications']).'" />
							</div>
						</div>
						<div class="row mx-auto w-100 my-3">
							<div class="col-sm-6 p-0">
								<label class="control-label">'.__('API Logs Retention').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('API Logs will be saved for the specified number of days. (0 for infinite retention)').'"><i class="fas text-primary fa-info-circle"></i></a></label>
							</div>
							<div class="col-sm-6 p-0">
								<input type="text" class="form-control" name="del_api_logs" id="del_api_logs" size="30" value="'.POSTval('del_api_logs', $info['del_api_logs']).'" />
							</div>
						</div>
					</div>
				</div>
				<!-- <div  class="divroundshad card mb-3">
					<div class="roundheader">'.__('Social Login Setting for enduser panel').'</div>
					<div class="px-3 mb-3">';
						$social_login_lang['Google'] = 'Google Login';
						$social_login_lang['facebook'] = 'Facebook Login';
						$social_login_lang['github'] = 'Github Login';
						$social_login_lang['LinkedInOpenID'] = 'LinkedInOpenID Login';
						$social_login_lang['twitter'] = 'X (formerly Twitter) Login';
						// r_print($info['social_logins']);
						foreach($available_social_logins as $ak => $av){

							$tmp_social_login = $info['social_logins'][$ak];
							echo '
							<div class="row mx-auto w-100 mt-3">
								<div class="col-sm-6 p-0">
									<label class="control-label" for="'.$ak.'">'.$social_login_lang[$ak].'&nbsp;</label>
								</div>
								<div class="col-sm-6 p-0">
									'.get_checkbox($ak, '', $ak, array('chk_it' => 1, 'val' => $tmp_social_login['enabled']), 1, '', ['onchange="show_social_details(this.id);"']).'
								</div>
							</div>
							<div class="row mx-auto w-100 mb-3" id="'.$ak.'_div" style="display:'.(!empty($tmp_social_login['enabled']) ? 'block' : 'none').';">
								<div class="row mx-auto w-100 my-3 p-0">
									<div class="col-sm-6 p-0">
										<label class="control-label">'.__('Client ID').'&nbsp;</label>
									</div>
									<div class="col-sm-6 p-0">
										<input type="text" class="form-control" name="'.$ak.'_client_id" id="'.$ak.'_client_id" size="30" value="'.POSTval($ak.'_client_id', $tmp_social_login['keys'][$ak.'_client_id']).'" />
									</div>
								</div>
								<div class="row mx-auto w-100 p-0">
									<div class="col-sm-6 p-0">
										<label class="control-label">'.__('Client Secret').'&nbsp;</label>
									</div>
									<div class="col-sm-6 p-0">
										<input type="text" class="form-control" name="'.$ak.'_client_secret" id="'.$ak.'_client_secret" size="30" value="'.POSTval($ak.'_client_secret', $tmp_social_login['keys'][$ak.'_client_secret']).'" />
									</div>
								</div>
							</div>';
						}
					echo '
						<div class="row mx-auto w-100 mb-3" id="sociallogin_callback_div">
							<div class="row mx-auto w-100 my-3 p-0">
								<div class="col-sm-6 p-0">
									<label class="control-label">'.__('Callback URL for your Social APP').'&nbsp;</label>
								</div>
								<div class="col-sm-6 p-0">
									<input type="text" class="form-control" name="social_login_callback" id="social_login_callback" size="30" value="'.POSTval('social_login_callback', $info['social_logins']['social_login_callback']).'" />
								</div>
							</div>
						</div>
					</div>
				</div>-->
				';
				}echo'
		
	</div>
	<div class="col-sm-12 col-md-12 col-lg-6">';
	if($master || (empty($master) && $cluster->virt(0, 1, 1, 0, 1))){
			echo '
			<div  class="divroundshad card mb-3">
				<div class="roundheader">'.__('Xen Settings').'</div>
				<div class="px-3">
					<div class="row mx-auto w-100 my-3">
						<div class="col-sm-6 p-0">
							<label class="control-label">'.__('Domain-0 / Host Memory').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('In Xen, the Domain-0 is the physical node. This will set the memory available to the Domain-0. The remaining memory of the physical node will be available for the VPS.').'"><i class="fas text-primary fa-info-circle"></i></a></label>
						</div>
						<div class="col-sm-6 p-0">
						<div class="input-group ">	
							<input type="text" class="form-control w-50 rounded" name="xen_dom0mem" id="xen_dom0mem" size="30" value="'.POSTval('xen_dom0mem', $info['xen_dom0mem']).'"/>
							<div class="input-group-append">
								<span class="input-group-text">MB</span>
							</div>
						</div>
						</div>
					</div>
					<div class="row mx-auto w-100 my-3">
						<div class=" col-6 p-0">
							<label class="control-label">'.__('PV-on-HVM driver Support').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Global setting to enable PV-on-HVM for all the new VMs').'"><i class="fas text-primary fa-info-circle"></i></a></label>
						</div>
						<div class=" col-6 p-0">
							'.get_checkbox('pv_on_hvm', '', '', array('chk_it' => 1, 'val' => $info['pv_on_hvm'])).'
						</div>
					</div>';

					if(empty($master)){

					echo '<div class="row mx-auto w-100 my-3">
						<div class="col-sm-6 p-0">
							<label class="control-label">'.__('Paravirtualization Bridge').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('This setting allows you to define the default BRIDGE used by the Xen PV Virtual Server').'"><i class="fas text-primary fa-info-circle"></i></a></label>
						</div>
						<div class="col-sm-6 p-0">
							<input type="text" class="form-control" name="xen_pvbridge" id="xen_pvbridge" size="30" value="'.POSTval('xen_pvbridge', $info['xen_pvbridge']).'" />
						</div>
					</div>
					<div class="row mx-auto w-100 my-3">
						<div class="col-sm-6 p-0">
							<label class="control-label">'.__('HVM Bridge').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('This setting allows you to define the default BRIDGE used by the Xen HVM Virtual Server').'"><i class="fas text-primary fa-info-circle"></i></a></label>
						</div>
						<div class="col-sm-6 p-0">
							<input type="text" class="form-control" name="xen_hvmbridge" id="xen_hvmbridge" size="30" value="'.POSTval('xen_hvmbridge', $info['xen_hvmbridge']).'" />
						</div>
					</div>
					<div class="row mx-auto w-100 my-3">
						<div class=" col-6 p-0">
							<label class="control-label">'.__('Use XL').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Use the <b>xl</b> tool instead of the deprecated <b>xm</b> tool. NOTE : xend service must be shutdown and prevented to start').'"><i class="fas text-primary fa-info-circle"></i></a></label>
						</div>
						<div class=" col-6 p-0">
							'.get_checkbox('use_xl', '', '', array('chk_it' => 1, 'val' => $info['use_xl'])).'
						</div>
					</div>
					<div class="row mx-auto w-100 my-3">
						<div class=" col-6 p-0">
							<label class="control-label">'.__('Xen dm version').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Define which value to use for xen_dm_version config of VPS, qemu-xen-traditional OR qemu-xen. <br>qemu-xen is available after xen version 4.4+').'"><i class="fas text-primary fa-info-circle"></i></a></label>
						</div>
						<div class="col-6 p-0">
							<div class="row mx-auto w-100">
								<div class="col-12 p-0">
									<label class="custom-control custom-radio">
										<input type="radio" class="custom-control-input" id="xen_dm_version1" name="xen_dm_version" value="0" '.(POSTval('xen_dm_version', $info['xen_dm_version']) == '0' ? 'checked="checked"' : '').'>
										<span class="custom-control-label" for="xen_dm_version1">'.__('Use <b>qemu-xen-traditional</b>').'</span>
									</label>
								</div>
								<div class="col-12 p-0">
									<label class="custom-control custom-radio">
										<input type="radio" name="xen_dm_version" id="xen_dm_version2" value="1" '.(POSTval('xen_dm_version', $info['xen_dm_version']) == '1' ? 'checked="checked"' : '').' class="custom-control-input" >
										<span class="custom-control-label" for="xen_dm_version2">'.__('Use <b>qemu-xen</b>').'</span>
									</label>
								</div>
							</div>
						</div>
					</div>';
					}
			echo'
				</div>
			</div>';
		}// End of XEN
		
		if($master){
			echo '<div  class="divroundshad card mb-3">
			<div class="roundheader">'.__('Enduser Settings').'</div>
				<div class="px-3">
					<div class="row mx-auto w-100 my-3">
						<div class=" col-6 p-0">
							<label class="control-label">'.__('Disable Monitoring').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Disable the Monitor icon for the endusers').'"><i class="fas text-primary fa-info-circle"></i></a></label>
						</div>
						<div class=" col-6 p-0">
							'.get_checkbox('disable_icons_monitor', '', '', array('chk_it' => 1, 'val' => $info['disable_icons_monitor'])).'
						</div>
					</div>';

			$cp_list = array("webuzo" => "Webuzo", "plesk" => "Plesk", "cpanel" => "cPanel", "webmin" => "Webmin", "interworx" => "Interworx", "ispconfig" => "ISPConfig", "cwp" => "CentOS Web Panel", "vesta" => "VestaCP");		
			
			if(!empty($custom_cp)){
				foreach($custom_cp as $k => $v){
					$cp_list[$v] = $v;
				}
			}

			echo '<div class="row mx-auto w-100 my-3">
						<div class=" col-6 p-0">
							<label class="control-label">'.__('Disable Control Panel').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Disable the Control Panel installation icon for the endusers').'"><i class="fas text-primary fa-info-circle"></i></a></label>
						</div>
						<div class=" col-6 p-0">
							<div class="row w-100">
								<div class="col-12">
									'.get_checkbox('select_all', 'All', 'select_all', '', -1,'',array('onchange="enduser_cp_settings(this)"')).'
								</div>';

								$hidden_cp_list = json_decode($info['disable_icons_cp'], 1);

								foreach($cp_list as $k => $v){

									$val = is_array($hidden_cp_list) ? (in_array("disable_icons_cp_".$k, $hidden_cp_list) ? 1 : 0) : $info['disable_icons_cp'];

									echo '<div class="col-12">
										'.get_checkbox('disable_icons_cp_'.$k, $v, '', array('chk_it' => 1, 'val' => $val), 1, 'disable_icons_cp_class').'
									</div>';
								}
								
								echo '
							</div>
						</div>
					</div>

					<div class="row mx-auto w-100 my-3">
						<div class=" col-6 p-0">
							<label class="control-label">'.__('Allow VNC Management').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If enabled, the user can turn on/off the VNC of his VPS').'"><i class="fas text-primary fa-info-circle"></i></a></label>
						</div>
						<div class=" col-6 p-0">
							'.get_checkbox('enable_enduser_vnc', '', '', array('chk_it' => 1, 'val' => $info['enable_enduser_vnc'])).'
						</div>
					</div>
					<div class="row mx-auto w-100 my-3">
						<div class=" col-6 p-0">
							<label class="control-label">'.__('Hide VNC details').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If enabled, VNC details of the VPS will not be displayed to enduser').'"><i class="fas text-primary fa-info-circle"></i></a></label>
						</div>
						<div class=" col-6 p-0">
							'.get_checkbox('hide_enduser_vnc_info', '', '', array('chk_it' => 1, 'val' => $info['hide_enduser_vnc_info'])).'
						</div>
					</div>
					<div class="row mx-auto w-100 my-3">
						<div class=" col-6 p-0">
							<label class="control-label">'.__('Show Server Name/Location').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If enabled, Endusers can see the Server name or Location of the VPS').'"><i class="fas text-primary fa-info-circle"></i></a></label>
						</div>
						<div class=" col-6 p-0">
							'.get_checkbox('show_server', '', '', array('chk_it' => 1, 'val' => $info['show_server'])).'
						</div>
					</div>
					<div class="row mx-auto w-100 my-3">
						<div class=" col-6 p-0">
							<label class="control-label">'.__('Disable API Credential Access in Client panel').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If checked than users will not be able to generate API credentials.').'"><i class="fas text-primary fa-info-circle"></i></a></label>
						</div>
						<div class=" col-6 p-0">
							'.get_checkbox('disable_apicredential', '', 'disable_apicredential', array('chk_it' => 1, 'val' => @$info['disable_apicredential'])).'
						</div>	
					</div>

					<div class="row mx-auto w-100 my-3">
						<div class=" col-6 p-0">	
							<label class="control-label">'.__('Disable Recipes').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Disable Recipes for the endusers').'"><i class="fas text-primary fa-info-circle"></i></a></label>
						</div>
						<div class=" col-6 p-0">
							'.get_checkbox('disable_recipes', '', '', array('chk_it' => 1, 'val' => $info['disable_recipes'])).'
						</div>
					</div>

					<div class="row mx-auto w-100 my-3">
						<div class=" col-6 p-0">
							<label class="control-label">'.__('Allow virtio management').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If enabled, users can enable/disable virtio for their VPS(s)').'"><i class="fas text-primary fa-info-circle"></i></a></label>
						</div>
						<div class=" col-6 p-0">
							'.get_checkbox('eu_allow_virtio', '', '', array('chk_it' => 1, 'val' => $info['eu_allow_virtio'])).'
						</div>
					</div>

					<div class="row mx-auto w-100 my-3">
						<div class=" col-6 p-0">
							<label class="control-label">'.__('Disable Rescue mode').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Disable Rescue mode for the endusers').'"><i class="fas text-primary fa-info-circle"></i></a></label>
						</div>
						<div class=" col-6 p-0">
							'.get_checkbox('disable_rescue', '', '', array('chk_it' => 1, 'val' => $info['disable_rescue'])).'			
						</div>
					</div>

					<div class="row mx-auto w-100 my-3">
						<div class=" col-6 p-0">
							<label class="control-label">'.__('Disable change of Hostname').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Endusers will not be able to change the hostname').'"><i class="fas text-primary fa-info-circle"></i></a></label>
						</div>
						<div class=" col-6 p-0">
							'.get_checkbox('disable_change_hostname', '', '', array('chk_it' => 1, 'val' => $info['disable_change_hostname'])).'
						</div>
					</div>

					<div class="row mx-auto w-100 my-3">
						<div class=" col-6 p-0">
							<label class="control-label">'.__('Disable change of VPS Password').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Endusers will not be able to change the password of their VPS').'"><i class="fas text-primary fa-info-circle"></i></a></label>
						</div>
						<div class=" col-sm-6 p-0">
							'.get_checkbox('disable_change_password', '', '', array('chk_it' => 1, 'val' => $info['disable_change_password'])).'
						</div>
					</div>

					<div class="row mx-auto w-100 my-3">
						<div class=" col-6 p-0">
							<label class="control-label">'.__('Disable change of VPS VNC Password').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Endusers will not be able to change the password of their VPS\'s VNC').'"><i class="fas text-primary fa-info-circle"></i></a></label>
						</div>
						<div class=" col-sm-6 p-0">
							'.get_checkbox('disable_change_vnc_password', '', '', array('chk_it' => 1, 'val' => $info['disable_change_vnc_password'])).'
						</div>
					</div>

					<div class="row mx-auto w-100 my-3">
						<div class=" col-6 p-0">
							<label class="control-label">'.__('Disable VPS Configuration').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Endusers will not be able to change VPS configuration').'"><i class="fas text-primary fa-info-circle"></i></a></label>
						</div>
						<div class=" col-6 p-0">
							'.get_checkbox('disable_vps_config', '', '', array('chk_it' => 1, 'val' => $info['disable_vps_config'])).'
						</div>
					</div>

					<div class="row mx-auto w-100 my-3">
						<div class=" col-6 p-0">
							<label class="control-label">'.__('Disable OS reinstall').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Endusers will not be able to reinstall the OS').'"><i class="fas text-primary fa-info-circle"></i></a></label>
						</div>
						<div class=" col-6 p-0">
							'.get_checkbox('disable_os_reinstall', '', '', array('chk_it' => 1, 'val' => $info['disable_os_reinstall'])).'
						</div>
					</div>

					<div class="row mx-auto w-100 my-3">
						<div class=" col-6 p-0">
						<label class="control-label">'.__('Disable SSH').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Endusers will not be able to access SSH from panel').'"><i class="fas text-primary fa-info-circle"></i></a></label>
						</div>
						<div class=" col-6 p-0">
							'.get_checkbox('disable_ssh', '', '', array('chk_it' => 1, 'val' => $info['disable_ssh'])).'
						</div>
					</div>
					<div class="row mx-auto w-100 my-3">
						<div class=" col-6 p-0">
							<label class="control-label">'.__('Disable Email on VPS Suspension').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Enduser will not receive any email on VPS suspension').'"><i class="fas text-primary fa-info-circle"></i></a></label>
						</div>
						<div class=" col-6 p-0">
							'.get_checkbox('disable_suspend_email', '', '', array('chk_it' => 1, 'val' => $info['disable_suspend_email'])).'
						</div>
					</div>
					<div class="row mx-auto w-100 my-3">
						<div class=" col-6 p-0">
							<label class="control-label">'.__('Disable Self Shutdown').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Enduser will not be able to schedule power option(s) from enduser panel').'"><i class="fas text-primary fa-info-circle"></i></a></label>
						</div>
						<div class=" col-6 p-0">
							'.get_checkbox('disable_self_shutdown', '', '', array('chk_it' => 1, 'val' => $info['disable_self_shutdown'])).'
						</div>
					</div>
					<div class="row mx-auto w-100 my-3">
						<div class=" col-6 p-0">
							<label class="control-label">'.__('Disable Server Location').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If checked the server location on map in the enduser panel will not be displayed').'"><i class="fas text-primary fa-info-circle"></i></a></label>
						</div>
						<div class=" col-6 p-0">
							'.get_checkbox('disable_server_location', '', '', array('chk_it' => 1, 'val' => $info['disable_server_location'])).'
						</div>
					</div>
					<div class="row mx-auto w-100 my-3">
						<div class=" col-6 p-0">
							<label class="control-label">'.__('Disable SSH Keys').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Enduser will not be able to add SSH Keys to his VPS').'"><i class="fas text-primary fa-info-circle"></i></a></label>
						</div>
						<div class=" col-6 p-0">
							'.get_checkbox('disable_enduser_sshkeys', '', '', array('chk_it' => 1, 'val' => $info['disable_enduser_sshkeys'])).'
						</div>
					</div>
					<div class="row mx-auto w-100 my-3">
						<div class=" col-6 p-0">
							<label class="control-label">'.__('Disable VGA').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If checked, the Enable VGA option in VPS Configuration dialog in the enduser panel will not be displayed.').'"><i class="fas text-primary fa-info-circle"></i></a></label>
						</div>
						<div class=" col-sm-6 p-0">
							'.get_checkbox('disable_vga', '', '', array('chk_it' => 1, 'val' => $info['disable_vga'])).'
						</div>
					</div>
					<div class="row mx-auto w-100 my-3">
						<div class=" col-6 p-0">
							<label class="control-label">'.__('Enable NIC option').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If enabled, then user can manage NIC (Network Interface Card) of their VPS').'"><i class="fas text-primary fa-info-circle"></i></a></label>
						</div>
						<div class=" col-6 p-0">
							'.get_checkbox('enable_nic', '', '', array('chk_it' => 1, 'val' => $info['enable_nic'])).'
						</div>
					</div>
					<div class="row mx-auto w-100 my-3">
						<div class=" col-6 p-0">
							<label class="control-label">'.__('Enable Two Factor Authentication').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If checked, Two factor authentication will be enabled for endusers. But they will have to enable which method they want from enduser panel').'"><i class="fas text-primary fa-info-circle"></i></a></label>
						</div>
						<div class=" col-6 p-0">
							'.get_checkbox('enable_2fa', '', '', array('chk_it' => 1, 'val' => $info['enable_2fa'])).'
						</div>
					</div>
					<div class="row mx-auto w-100 my-3">
						<div class=" col-6 p-0">
							<label class="control-label">'.__('Email OTP').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If checked and if no method is set from enduser panel, Two factor authentication via Email will be enabled for endusers').'"><i class="fas text-primary fa-info-circle"></i></a></label>
						</div>
						<div class=" col-6 p-0">
							'.get_checkbox('2fa_email_otp', '', '', array('chk_it' => 1, 'val' => $info['2fa_email_otp'])).'
						</div>
					</div>
					<div class="row mx-auto w-100 my-3">
						<div class=" col-6 p-0">
							<label class="control-label">'.__('Disable domain forwarding for enduser').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If checked, Domain Forwarding feature will be disabled from enduser panel').'"><i class="fas text-primary fa-info-circle"></i></a></label>
						</div>
						<div class=" col-6 p-0">
							'.get_checkbox('disable_domain_forward', '', '', array('chk_it' => 1, 'val' => $info['disable_domain_forward'])).'
						</div>
					</div>
					<div class="row mx-auto w-100 my-3">
						<div class=" col-6 p-0">
							<label class="control-label">'.__('Disable Account information').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If checked, Account Information Panel will be disabled from enduser panel').'"><i class="fas text-primary fa-info-circle"></i></a></label>
						</div>
						<div class=" col-6 p-0">
							'.get_checkbox('disable_account_information', '', '', array('chk_it' => 1, 'val' => $info['disable_account_information'])).'
						</div>
					</div>
					<div class="row mx-auto w-100 my-3">
						<div class=" col-6 p-0">
							<label class="control-label">'.__('Show VPS active hours in enduser panel').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If checked, Enduser panel will show VPS Up time').'"><i class="fas text-primary fa-info-circle"></i></a></label>
						</div>
						<div class=" col-6 p-0">
							'.get_checkbox('show_vps_active_time', '', '', array('chk_it' => 1, 'val' => $info['show_vps_active_time'])).'
						</div>
					</div>
					<div class="row mx-auto w-100 my-3">
						<div class=" col-6 p-0">
							<label class="control-label">'.__('Show Power buttons only').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If enabled, then user will only get power option(s) while accessing enduser panel. All other options will be disabled. <b>NOTE:</b> This setting will be applied ONLY when <b>Managed By Admin</b> is enabled.').'"><i class="fas text-primary fa-info-circle"></i></a></label>
						</div>
						<div class=" col-6 p-0">
							'.get_checkbox('power_only_option', '', '', array('chk_it' => 1, 'val' => $info['power_only_option'])).'
						</div>
					</div>
					<div class="row mx-auto w-100 my-3">
						<div class=" col-6 p-0">
							<label class="control-label">'.__('Disable Logs').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If enabled then enduser will not be able to see Logs Tab').'"><i class="fas text-primary fa-info-circle"></i></a></label>
						</div>
						<div class=" col-6 p-0">
							'.get_checkbox('disable_logs', '', '', array('chk_it' => 1, 'val' => $info['disable_logs'])).'
						</div>
					</div>
					<div class="row mx-auto w-100 my-3">
						<div class=" col-6 p-0">
							<label class="control-label">'.__('Disable Change of Primary IP').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If enabled then enduser will not be able to change primary IP of VPS').'"><i class="fas text-primary fa-info-circle"></i></a></label>
						</div>
						<div class=" col-6 p-0">
							'.get_checkbox('disable_change_primary_ip', '', '', array('chk_it' => 1, 'val' => $info['disable_change_primary_ip'])).'
						</div>
					</div>
					<div class="row mx-auto w-100 my-3">
						<div class=" col-6 p-0">
							<label class="control-label">'.__('Disable Enduser Panel').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If enabled, Enduser panel access will be disabled').'"><i class="fas text-primary fa-info-circle"></i></a></label>
						</div>
						<div class=" col-6 p-0">
							'.get_checkbox('disable_enduser_panel', '', '', array('chk_it' => 1, 'val' => $info['disable_enduser_panel'])).'
						</div>
					</div>
					<div class="row mx-auto w-100 my-3">
						<div class=" col-6 p-0">
							<label class="control-label">'.__('Do not show Remote IP').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If enabled, Remote IP will not be shown to enduser wherever possible').'"><i class="fas text-primary fa-info-circle"></i></a></label>
						</div>
						<div class=" col-6 p-0">
							'.get_checkbox('eu_dont_show_remote_ip', '', '', array('chk_it' => 1, 'val' => $info['eu_dont_show_remote_ip'])).'
						</div>
					</div>
					<div class="row mx-auto w-100 my-3">
						<div class="col-6 p-0"><label class="control-label">'.__('Default Enduser timezone').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If set then VPS will get the default timezone as selected. Enduser can set different timezone as per their choice from enduser panel').'"><i class="fas text-primary fa-info-circle"></i></a></label></div>
						<div class="col-6 p-0" valign="top">
							<select class="custom-select virt-select" name="default_enduser_timezone">';
							echo'<option value="0">'.__('None').'</option>';
								foreach ($timezones as $key => $value) {
									echo '<optgroup label="'.$key.'">';
									foreach ($value as $timezone_value => $timezone_name) {
										echo '<option value="'.$timezone_value.'" '. ($info['default_enduser_timezone'] == $timezone_value ? 'selected="selected"' : '') .'>'.$timezone_name.'</option>';
									}
									echo '</optgroup>';
								}

							echo '</select>
						</div>
					</div>
					<div class="row mx-auto w-100 my-3">
						<div class=" col-6 p-0">
							<label class="control-label">'.__('Hide Account Password').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If enabled, then user will not be able to change the account password from the enduser panel').'"><i class="fas text-primary fa-info-circle"></i></a></label>
						</div>
						<div class=" col-6 p-0">
							'.get_checkbox('hide_acc_password', '', '', array('chk_it' => 1, 'val' => $info['hide_acc_password'])).'
						</div>
					</div>
					<div class="row mx-auto w-100 my-3">
						<div class=" col-6 p-0">
							<label class="control-label">'.__('Hide Forgot Password link').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If enabled, then user will not be able to reset the password on login page').'"><i class="fas text-primary fa-info-circle"></i></a></label>
						</div>
						<div class=" col-6 p-0">
							'.get_checkbox('hide_forgot_password', '', '', array('chk_it' => 1, 'val' => $info['hide_forgot_password'])).'
						</div>
					</div>
					<div class="row mx-auto w-100 my-3">
						<div class=" col-6 p-0">
							<label class="control-label">'.__('Disable Volume').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If enabled, volume management will be disabled from cloud panel').'"><i class="fas text-primary fa-info-circle"></i></a></label>
						</div>
						<div class=" col-6 p-0">
							'.get_checkbox('disable_volume_enduser', '', '', array('chk_it' => 1, 'val' => $info['disable_volume_enduser'])).'
						</div>
					</div>
					<div class="row mx-auto w-100 my-3">
						<div class=" col-6 p-0">
							<label class="control-label">'.__('Disable Load Balancer').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If enabled, load balancer management will be disabled from cloud panel').'"><i class="fas text-primary fa-info-circle"></i></a></label>
						</div>
						<div class=" col-6 p-0">
							'.get_checkbox('disable_lb_enduser', '', '', array('chk_it' => 1, 'val' => $info['disable_lb_enduser'])).'
						</div>
					</div>
					<div class="row mx-auto w-100 my-3">
						<div class=" col-6 p-0">
							<label class="control-label">'.__('Do not show virtualization type').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If enabled, virtualization type column will not be shown on listvs page in enduser panel').'"><i class="fas text-primary fa-info-circle"></i></a></label>
						</div>
						<div class=" col-6 p-0">
							'.get_checkbox('disable_virttype', '', '', array('chk_it' => 1, 'val' => $info['disable_virttype'])).'
						</div>
					</div>
					<div class="row mx-auto w-100 my-3">
						<div class=" col-6 p-0">
							<label class="control-label">'.__('Hide Tasks Log').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If enabled, then enduser will not be able to see task logs').'"><i class="fas text-primary fa-info-circle"></i></a></label>
						</div>
						<div class=" col-6 p-0">
							'.get_checkbox('hide_eu_tasks', '', '', array('chk_it' => 1, 'val' => $info['hide_eu_tasks'])).'
						</div>
					</div>
					<div class="row mx-auto w-100 my-3">
						<div class=" col-6 p-0">
							<label class="control-label">'.__('Add PTR records').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('PTR records for the VPS\'s will be added after VM creation, VM\'s hostname will be used for adding the records.').'"><i class="fas text-primary fa-info-circle"></i></a></label>
						</div>
						<div class=" col-6 p-0">
							'.get_checkbox('add_ptr_record', '', '', array('chk_it' => 1, 'val' => $info['add_ptr_record'])).'
						</div>
					</div>
					<div class="row mx-auto w-100 my-3">
						<div class=" col-6 p-0">
							<label class="control-label">'.__('Disable VPS Power Off').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If enabled, VPS Power Off will be disabled for the enduser.').'"><i class="fas text-primary fa-info-circle"></i></a></label>
						</div>
						<div class=" col-6 p-0">
							'.get_checkbox('disable_enduser_vps_poweroff', '', '', array('chk_it' => 1, 'val' => $info['disable_enduser_vps_poweroff'])).'
						</div>
					</div>
					<div class="row mx-auto w-100 my-3">
						<div class=" col-6 p-0">
							<label class="control-label">'.__('Disable Firewall').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If enabled, VPS Firewall will be disabled for the enduser.').'"><i class="fas text-primary fa-info-circle"></i></a></label>
						</div>
						<div class=" col-6 p-0">
							'.get_checkbox('disable_enduser_firewall', '', '', array('chk_it' => 1, 'val' => $info['disable_enduser_firewall'])).'
						</div>
					</div>
					<div class="row mx-auto w-100 my-3">
						<div class=" col-6 p-0">
							<label class="control-label">'.__('Hide Recipe Code').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If enabled, the recipe code will be hidden from endusers.').'"><i class="fas text-primary fa-info-circle"></i></a></label>
						</div>
						<div class=" col-6 p-0">
							'.get_checkbox('eu_hide_recipe_code', '', '', array('chk_it' => 1, 'val' => $info['eu_hide_recipe_code'])).'
						</div>
					</div>
				</div>
			</div>
			

			<div  class="divroundshad card mb-3">
				<div class="roundheader">'.__('Enduser ISO Settings').'</div>
				<div class="px-3">
					<div class="row mx-auto w-100 my-3">
						<div class=" col-6 p-0">
							<label class="control-label">'.__('Enable Enduser ISO Boot').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If checked, enduser(s) will be able to boot VPS from ISO').'"><i class="fas text-primary fa-info-circle"></i></a></label>
						</div>
						<div class=" col-6 p-0">
							'.get_checkbox('enable_eu_iso_boot', '', 'enable_eu_iso_boot', array('chk_it' => 1, 'val' => $info['enable_eu_iso_boot']),1,'',array('onchange="enduser_iso_settings()"')).'
						</div>
					</div>
					<div class="row mx-auto w-100 my-3 enduser_iso_settings">
						<div class=" col-6 p-0">
							<label class="control-label">'.__('Enable Add ISO Option For Enduser').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If checked, allows the enduser(s) to add their own custom ISOs from the Enduser Panel').'"><i class="fas text-primary fa-info-circle"></i></a></label>
						</div>
						<div class=" col-6 p-0">
							'.get_checkbox('enable_eu_iso', '', 'enable_eu_iso', array('chk_it' => 1, 'val' => $info['enable_eu_iso'])).'
						</div>
					</div>
					<div class="row mx-auto w-100 my-3 enduser_iso_settings">
						<div class=" col-6 p-0">
							<label class="control-label">'.__('Max ISO Size (MB)').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Specify the maximum size of an ISO that a enduser can download. If not specified, 5120 MB will be set as the default size.').'"><i class="fas text-primary fa-info-circle"></i></a></label>
						</div>
						<div class=" col-6 p-0">
							<div class="input-group ">
								<input type="number" class="form-control float-left" name="eu_iso_size" id="eu_iso_size" value="'.POSTval('eu_iso_size', (empty($info['eu_iso_size']) ? '5120' : $info['eu_iso_size'])).'"/>
								<div class="input-group-append">
									<span class="input-group-text">MB</span>
								</div>
							</div>
						</div>
					</div>
					<div class="row mx-auto w-100 my-3 enduser_iso_settings">
						<div class=" col-6 p-0">
							<label class="control-label">'.__('Number of ISOs Allowed').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Specify the number of ISOs an enduser can download. If not specified, 3 will be set as the default limit.').'"><i class="fas text-primary fa-info-circle"></i></a></label>
						</div>
						<div class=" col-6 p-0">
							<input type="number" class="form-control w-100" name="eu_iso_limit" id="eu_iso_limit" value="'.POSTval('eu_iso_limit', (empty($info['eu_iso_limit']) ? '3' : $info['eu_iso_limit'])).'"/>
						</div>
					</div>
					<div class="row mx-auto w-100 my-3 enduser_iso_settings">
						<div class=" col-6 p-0">
							<label class="control-label">'.__('Total ISO Space / Enduser (MB)').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('The total space for ISOs allowed per enduser. If not specified, 5120 MB will be set as the default space.').'"><i class="fas text-primary fa-info-circle"></i></a></label>
						</div>
						<div class=" col-6 p-0">
							<div class="input-group ">
								<input type="number" class="form-control rounded" name="eu_iso_space" id="eu_iso_space" value="'.POSTval('eu_iso_space', (empty($info['eu_iso_space']) ? '5120' : $info['eu_iso_space'])).'"/>
								<div class="input-group-append">
									<span class="input-group-text">MB</span>
								</div>
							</div>
						</div>
					</div>

					<div class="row mx-auto w-100 my-3 enduser_iso_settings">
						<div class=" col-6 p-0">
							<label class="control-label">'.__('Auto Delete Enduser ISO (Hours)').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If specified, Enduser ISO(s) will be deleted after specified hours').'"><i class="fas text-primary fa-info-circle"></i></a></label>
						</div>
						<div class=" col-6 p-0">
						<div class="input-group ">
								<input type="number" class="form-control rounded" name="eu_iso_del_hr" id="eu_iso_del_hr" value="'.POSTval('eu_iso_del_hr', (empty($info['eu_iso_del_hr']) ? 0 : $info['eu_iso_del_hr'])).'"/>
							<div class="input-group-append">
								<span class="input-group-text">Hr</span>
							</div>
						</div>
						</div>
					</div>
				</div>
			</div>
			

			<div  class="divroundshad card mb-3">
				<div class="roundheader">'.__('Cloud User Setting').'</div>
				<div class="px-3">
					<!-- <div class="row mx-auto w-100 my-3">
						<div class=" col-6 p-0">
							<label class="control-label">'.__('Disable Suspension options for Cloud User').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If checked, VPS Suspend/Unsuspend and Network Suspend/Unsuspend options will be disabled for Cloud User').'"><i class="fas text-primary fa-info-circle"></i></a></label>
						</div>
						<div class=" col-6 p-0">
							'.get_checkbox('disable_cloud_suspend_options', '', '', array('chk_it' => 1, 'val' => $info['disable_cloud_suspend_options'])).'
						</div>
					</div>-->
					<div class="row mx-auto w-100 my-3">
						<div class=" col-6 p-0">
							<label class="control-label">'.__('Allow virtio management').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If enabled, cloud users can enable/disable virtio for their VPS(s)').'"><i class="fas text-primary fa-info-circle"></i></a></label>
						</div>
						<div class=" col-6 p-0">
							'.get_checkbox('cloud_allow_virtio', '', '', array('chk_it' => 1, 'val' => @$info['cloud_allow_virtio'])).'
						</div>
					</div>
					<div class="row mx-auto w-100 my-3">
						<div class=" col-6 p-0">
							<label class="control-label">'.__('Disable Login Logo').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If checked the Logo will be hidden at Login for the endusers. This is useful for helping reseller or cloud users to rebrand their panels.').'"><i class="fas text-primary fa-info-circle"></i></a></label>
						</div>
						<div class=" col-6 p-0">
							'.get_checkbox('disable_login_logo', '', 'disable_login_logo', array('chk_it' => 1, 'val' => @$info['disable_login_logo'])).'		
						</div>	
					</div>
					<div class="row mx-auto w-100 my-3">
						<div class="col-6 p-0">
							<label class="control-label">'.__('Allow cloud user domain name').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Allow cloud user domain name for login').'"><i class="fas text-primary fa-info-circle"></i></a></label>
						</div>
						<div class="col-6 p-0">
							'.get_checkbox('allow_cloud_dom_name', '', 'allow_cloud_dom_name', array('chk_it' => 1, 'val' => @$info['allow_cloud_dom_name'])).'
						</div>	
					</div>
					<div class="row mx-auto w-100 my-3">
						<div class="col-6 p-0">
							<label class="control-label">'.__('Allow disable ebtables').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Allow cloud user to disable ebtables rules for their VPS. Ebtables rules prevent IP stealing (These rules prevent VPS from using IP not assigned to it)').'"><i class="fas text-primary fa-info-circle"></i></a></label>
						</div>
						<div class="col-6 p-0">
							'.get_checkbox('allow_cloud_ebt_disable', '', 'allow_cloud_ebt_disable', array('chk_it' => 1, 'val' => @$info['allow_cloud_ebt_disable'])).'
						</div>	
					</div>
					<!-- <div class="row mx-auto w-100 my-3">
						<div class="col-6 p-0">
							<label class="control-label">'.__('Allow Total I/O per sec').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If enabled then cloud user will be able to set I/O limit').'"><i class="fas text-primary fa-info-circle"></i></a></label>
						</div>
						<div class="col-6 p-0">
							'.get_checkbox('enable_iops_sec', '', 'enable_iops_sec', array('chk_it' => 1, 'val' => @$info['enable_iops_sec'])).'
						</div>	
					</div> -->
				</div>
			</div>
			<div  class="divroundshad card mb-3">
				<div class="roundheader">'.__('Callback Settings').'</div>
				<div class="px-3">	
					<div class="row mx-auto w-100 my-3">
						<div class=" col-6 p-0">
							<label class="control-label">'.__('Enable Callback').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If checked, changes in the Virtualizor panel will be reflected in the billing panel').'"><i class="fas text-primary fa-info-circle"></i></a></label>
						</div>
						<div class=" col-6 p-0">
							'.get_checkbox('enable_cb', '', '', array('chk_it' => 1, 'val' => @$info['enable_cb'])).'
						</div>
					</div>
					<div class="row mx-auto w-100 my-3">
						<div class="col-sm-6 p-0">
							<label class="control-label">'.__('Callback URL').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Full URL to the callback file. For e.g if you are using WHMCS the url will look like billing.xxxx.com/whmcs/modules/servers/virtualizor/callback.php').'"><i class="fas text-primary fa-info-circle"></i></a></label>
						</div>
						<div class="col-sm-6 p-0 form-gorup">
							<div class="input-group ">
								<select name="cb_use_https" id="cb_use_https" class="custom-select p-0 w-25">
									<option value="0" '.ex_POSTselect('cb_use_https', '0', $info['cb_use_https']).'>http://</option>
									<option value="1" '.ex_POSTselect('cb_use_https', '1', $info['cb_use_https']).'>https://</option>
								</select>
							<div class="input-group-append w-75"><input type="text" class="form-control w-100" name="cb_url" id="cb_url" value="'.POSTval('cb_url', $info['cb_url']).'" />
							</div>
							</div>
							
							
						</div>
					</div>
					<div class="row mx-auto w-100 my-3">
						<div class=" col-6 p-0">
							<label class="control-label">'.__('Callback Hash').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Callback Hash used for authentication purpose').'"><i class="fas text-primary fa-info-circle"></i></a></label>
						</div>
						<div class="col-xs-6 col-6 p-0">
							<span id="cb_hash">'.$info['cb_hash'].'</span><a onclick="return reset_hash();" class="cursor-pointer mt-2 ml-2"><i class="fas fa-sync" id="resethash"></i></a>
						</div>
					</div>
					<div class="row mx-auto w-100 my-3">
						<div class=" col-6 p-0">
							<label class="control-label">'.__('VPS suspension').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If checked then Callback will be enabled for VPS suspension').'"><i class="fas text-primary fa-info-circle"></i></a></label>
						</div>
						<div class=" col-6 p-0">
							'.get_checkbox('cb_suspend', '', '', array('chk_it' => 1, 'val' => @$info['cb_suspend'])).'
						</div>
					</div>
					<div class="row mx-auto w-100 my-3">
						<div class=" col-6 p-0">
							<label class="control-label">'.__('VPS unsuspension').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If checked then Callback will be enabled for VPS unsuspension').'"><i class="fas text-primary fa-info-circle"></i></a></label>
						</div>
						<div class=" col-6 p-0">
							'.get_checkbox('cb_unsuspend', '', '', array('chk_it' => 1, 'val' => @$info['cb_unsuspend'])).'
						</div>
					</div>
					<div class="row mx-auto w-100 my-3">
						<div class=" col-6 p-0">
							<label class="control-label">'.__('Enable for Change VPS Hostname').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If checked then Callback will be enabled when the VPS Hostname is changed').'"><i class="fas text-primary fa-info-circle"></i></a></label>
						</div>
						<div class=" col-6 p-0">
							'.get_checkbox('cb_hostname', '', '', array('chk_it' => 1, 'val' => @$info['cb_hostname'])).'
						</div>
					</div>
					<div class="row mx-auto w-100 my-3">
						<div class=" col-6 p-0">
							<label class="control-label">'.__('Enable for VPS termination').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If checked then Callback will be enabled for VPS termination').'"><i class="fas text-primary fa-info-circle"></i></a></label>
						</div>
						<div class=" col-6 p-0">
							'.get_checkbox('cb_terminate', '', '', array('chk_it' => 1, 'val' => @$info['cb_terminate'])).'
						</div>
					</div>
					<div class="row mx-auto w-100 my-3">
						<div class=" col-6 p-0">
							<label class="control-label">'.__('Enable for Change VPS IP(s)').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If checked then Callback will be enabled when the VPS IP(s) are updated').'"><i class="fas text-primary fa-info-circle"></i></a></label>
						</div>
						<div class=" col-6 p-0">
							'.get_checkbox('cb_changeips', '', '', array('chk_it' => 1, 'val' => @$info['cb_changeips'])).'
						</div>
					</div>
					<div class="row mx-auto w-100 my-3">
						<div class=" col-6 p-0">
							<label class="control-label">'.__('Enable login for WHMCS User').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If checked then WHMCS User will be able to login as Cloud User without Registration').'"><i class="fas text-primary fa-info-circle"></i></a></label>
						</div>
						<div class=" col-6 p-0">	
							'.get_checkbox('cb_login_whmcs_user', '', '', array('chk_it' => 1, 'val' => @$info['cb_login_whmcs_user'])).'
						</div>
					</div>
					<div class="row mx-auto w-100 my-3">
						<div class=" col-6 p-0">
							<label class="control-label">'.__('Enable WHMCS Invoicing').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If checked, the Balance in Cloud Billing panel will be fetched from WHMCS and the invoices will also be generated in WHMCS').'"><i class="fas text-primary fa-info-circle"></i></a></label>
						</div>
						<div class=" col-6 p-0">
							'.get_checkbox('cb_invoice_whmcs_user', '', '', array('chk_it' => 1, 'val' => @$info['cb_invoice_whmcs_user'])).'
						</div>
					</div>
				</div>
			</div>';
		}
	
		if($master){
			echo '<div  class="divroundshad card mb-3">
				<div class="roundheader">'.__('IP settings').'</div>
				<div class="px-3">
					<div class="row mx-auto w-100 my-3">
						<div class="col-xs-10 col-sm-6 p-0">
							<label class="control-label">'.__('Max IPv4 per VPS').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Max number of IPv4 addresses allowed per VPS').'"><i class="fas text-primary fa-info-circle"></i></a></label>
						</div>
						<div class="col-xs-2 col-sm-6 p-0">
							<input type="number" class="form-control" name="max_ipv4s" id="max_ipv4s" size="30" value="'.POSTval('max_ipv4s', $info['max_ipv4s']).'" />
						</div>
					</div>
					<div class="row mx-auto w-100 my-3">
						<div class="col-xs-10 col-sm-6 p-0">
							<label class="control-label">'.__('Max IPv6 per VPS').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Max number of IPv6 addresses allowed per VPS').'"><i class="fas text-primary fa-info-circle"></i></a></label>
						</div>
						<div class="col-xs-2 col-sm-6 p-0">
							<input type="number" class="form-control" name="max_ipv6s" id="max_ipv6s" size="30" value="'.POSTval('max_ipv6s', $info['max_ipv6s']).'" />
						</div>
					</div>
					<div class="row mx-auto w-100 my-3">
						<div class="col-xs-10 col-sm-6 p-0">
							<label class="control-label">'.__('Max IPv6 Subnet per VPS').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Max number of IPv6 subnet allowed per VPS').'"><i class="fas text-primary fa-info-circle"></i></a></label>
						</div>
						<div class="col-xs-2 col-sm-6 p-0">
							<input type="number" class="form-control" name="max_ipv6_subnets" id="max_ipv6_subnets" size="30" value="'.POSTval('max_ipv6_subnets', $info['max_ipv6_subnets']).'" />
						</div>
					</div>
					<div class="row mx-auto w-100 my-3">
						<div class="col-xs-10 col-sm-6 p-0">
							<label class="control-label">'.__('Max Internal IPs per VPS').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Max number of Internal IP addresses allowed per VPS').'"><i class="fas text-primary fa-info-circle"></i></a></label>
						</div>
						<div class="col-xs-2 col-sm-6 p-0">
							<input type="number" class="form-control" name="max_internal_ips" id="max_internal_ips" size="30" value="'.POSTval('max_internal_ips', $info['max_internal_ips']).'" />
						</div>
					</div>
				</div>
			</div>';
		}
		
		
		if(empty($master) && $cluster->virt(0, 0, 0, 0, 0, 0, 0, 1)){
				echo '
			<div  class="divroundshad card mb-3">
				<div class="roundheader">'.__('Proxmox Settings').'</div>
				<div class="px-3">
					<div class="row mx-auto w-100 my-3">
						<div class="col-sm-6 p-0">
							<label class="control-label">'.__('Proxmox Server Name').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Proxmox Server Name can be found at /etc/hostname file').'"><i class="fas text-primary fa-info-circle"></i></a></label>
						</div>
						<div class="col-sm-6 p-0">
							<input type="text" class="form-control" name="proxmox_server_name" id="proxmox_server_name" size="30" value="'.POSTval('proxmox_server_name', $info['proxmox_server_name']).'" />
						</div>
					</div>
					<div class="row mx-auto w-100 my-3">
						<div class="col-sm-6 p-0">
							<label class="control-label">'.__('Proxmox root password').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Proxmox root password used for Proxmox panel login').'"><i class="fas text-primary fa-info-circle"></i></a></label>
						</div>
						<div class="col-sm-6 p-0">
							<input type="text" class="form-control" name="proxmox_server_pass" id="proxmox_server_pass" size="30" autocomplete="off" value="'.POSTval('proxmox_server_pass', '').'" />
						</div>
					</div>
					<div class="row mx-auto w-100 my-3">
						<div class="col-sm-6 p-0">
							<label class="control-label">'.__('Proxmox 2FA secret').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Enter the secret obtained from Proxmox 2FA').'"><i class="fas text-primary fa-info-circle"></i></a></label>
						</div>
						<div class="col-sm-6 p-0">
							<input type="text" class="form-control" name="proxmox_tfa_secret" id="proxmox_tfa_secret" size="30" autocomplete="off" value="'.POSTval('proxmox_tfa_secret', '').'" />
						</div>
					</div>
					<div class="row mx-auto w-100 my-3">
						<div class="col-sm-6 p-0">
							<label class="control-label">'.__('Proxmox API token name').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('API token name for root@pam user generated on Proxmox panel from Datacenter > Permission > API tokens').'"><i class="fas text-primary fa-info-circle"></i></a></label>
						</div>
						<div class="col-sm-6 p-0">
							<input type="text" class="form-control" name="proxmox_root_token_name" id="proxmox_root_token_name" size="30" autocomplete="off" value="'.POSTval('proxmox_root_token_name', $info['proxmox_root_token_name']).'" />
						</div>
					</div>
					<div class="row mx-auto w-100 my-3">
						<div class="col-sm-6 p-0">
							<label class="control-label">'.__('Proxmox API token secret value').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Secret value generated for the above root user API token').'"><i class="fas text-primary fa-info-circle"></i></a></label>
						</div>
						<div class="col-sm-6 p-0">
							<input type="text" class="form-control" name="proxmox_root_token_secret" id="proxmox_root_token_secret" size="30" autocomplete="off" value="'.POSTval('proxmox_root_token_secret', '').'" />
						</div>
					</div>
				</div>
			</div>
			';

			}echo'
			
			<div  class="divroundshad card mb-3">
				<div class="roundheader">'.__('noVNC Settings').'</div>
				<div class="px-3">';

					if($master){
					echo '
					<div class="row mx-auto w-100 my-3">
						<div class=" col-6 p-0">
							<label class="control-label">'.__('Enable noVNC').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('This option will enable the HTML5 VNC viewer along with the JAVA VNC Viewer').'"><i class="fas text-primary fa-info-circle"></i></a></label>
						</div>
						<div class=" col-6 p-0">
							'.get_checkbox('novnc', '', '', array('chk_it' => 1, 'val' => @$info['novnc'])).'
						</div>
					</div>
					<div class="row mx-auto w-100 my-3">
						<div class=" col-6 p-0">
							<label class="control-label">'.__('Master Proxy Only').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If enabled, only the Master will have the noVNC Websocket service').'"><i class="fas text-primary fa-info-circle"></i></a></label>
						</div>
						<div class=" col-6 p-0">
							'.get_checkbox('novnc_master_only', '', '', array('chk_it' => 1, 'val' => @$info['novnc_master_only'])).'
						</div>
					</div>';
					}

					echo '
					<div class="row mx-auto w-100 my-3">
						<div class=" col-6 p-0">	
							<label class="control-label">'.__('Use Server Hostname').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If enabled, then the server name (instead of its IP) will be used as the host to access the noVNC service. Please ensure the name of the server in the master is correct.').'"><i class="fas text-primary fa-info-circle"></i></a></label>
						</div>
						<div class=" col-6 p-0">
							'.get_checkbox('novnc_server_name', '', '', array('chk_it' => 1, 'val' => @$info['novnc_server_name'])).'
						</div>
					</div>
				</div>
			</div>
			';
			
		if($master || (empty($master) && $cluster->virt(1))){
			echo'<div  class="divroundshad card mb-3">
			<div class="roundheader">'.__('OpenVZ Settings').'</div>
			<div class="px-0">
				<div class="row mx-auto w-100 my-3">
					<div class=" col-8">
						<label class="control-label">'.__('Enable VSwap').'&nbsp;<a class="info" data-placement="right" tooltip="'.htmlizer(__('Enable VSwap for this server. This will be effective only if RHEL/SL/CentOS 6 is the Operating System of the NODE.<br />Please refer to <a href="https://www.virtualizor.com/docs/admin/VSwap_Openvz" target="_blank">this</a> article for further information.')).'"><i class="fas text-primary fa-info-circle"></i></a></label>
					</div>
					<div class=" col-4">
						'.get_checkbox('vswap', '', '', array('chk_it' => 1, 'val' => $info['vswap'])).'
					</div>
				</div>
				<div class="row mx-auto w-100 my-3">
					<div class=" col-8">
						<label class="control-label">'.__('Ploop').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If enabled, VPS will be created with the Ploop format').'"><i class="fas text-primary fa-info-circle"></i></a></label>
					</div>
					<div class=" col-4">
						'.get_checkbox('ploop', '', '', array('chk_it' => 1, 'val' => $info['ploop'])).'
					</div>
				</div>
				<div class="row mx-auto w-100 my-3">
					<div class=" col-8">
						<label class="control-label">'.__('Enable PPP settings in Client panel').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('By default PPP icon will be disabled.').'"><i class="fas text-primary fa-info-circle"></i></a></label>
					</div>
					<div class=" col-4">
						'.get_checkbox('enable_ppp_cp', '', '', array('chk_it' => 1, 'val' => $info['enable_ppp_cp'])).'
					</div>
				</div>
				<div class="row mx-auto w-100 my-3">
					<div class=" col-8">
						<label class="control-label">'.__('Enable Tun/Tap settings in Client panel').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('By default Tun/Tap icon will be disabled.').'"><i class="fas text-primary fa-info-circle"></i></a></label>
					</div>
					<div class=" col-4">
						'.get_checkbox('enable_tuntap_cp', '', '', array('chk_it' => 1, 'val' => $info['enable_tuntap_cp'])).'
					</div>
				</div>
				<div class="row mx-auto w-100 my-3">
					<div class=" col-8">
						<label class="control-label">'.__('Enable FUSE settings in Client panel').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('By default FUSE icon will be disabled.').'"><i class="fas text-primary fa-info-circle"></i></a></label>
					</div>
					<div class=" col-4">
						'.get_checkbox('enable_fuse_cp', '', '', array('chk_it' => 1, 'val' => $info['enable_fuse_cp'])).'
					</div>
				</div>
				<div class="row mx-auto w-100 my-3">
					<div class=" col-8">
						<label class="control-label">'.__('Enable IPIP settings in Client panel').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('By default IPIP icon will be disabled.').'"><i class="fas text-primary fa-info-circle"></i></a></label>
					</div>
					<div class=" col-4">
						'.get_checkbox('enable_ipip_cp', '', '', array('chk_it' => 1, 'val' => $info['enable_ipip_cp'])).'
					</div>
				</div>
				<div class="row mx-auto w-100 my-3">
					<div class=" col-8">
						<label class="control-label">'.__('Enable IPGRE settings in Client panel').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('By default IPGRE icon will be disabled.').'"><i class="fas text-primary fa-info-circle"></i></a></label>
					</div>
					<div class=" col-4">
						'.get_checkbox('enable_ipgre_cp', '', '', array('chk_it' => 1, 'val' => $info['enable_ipgre_cp'])).'
					</div>
				</div>
				<div class="row mx-auto w-100 my-3">
					<div class=" col-8">
						<label class="control-label">'.__('Enable NFS settings in Client panel').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('By default NFS icon will be disabled.').'"><i class="fas text-primary fa-info-circle"></i></a></label>
					</div>
					<div class=" col-4">
						'.get_checkbox('enable_nfs_cp', '', '', array('chk_it' => 1, 'val' => $info['enable_nfs_cp'])).'
					</div>
				</div>
				<div class="row mx-auto w-100 my-3">
					<div class=" col-8">
						<label class="control-label">'.__('Enable QUOTAUGIDLIMIT settings in Client panel').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('By default QUOTAUGIDLIMIT icon will be disabled.').'"><i class="fas text-primary fa-info-circle"></i></a></label>
					</div>
					<div class=" col-4">
						'.get_checkbox('enable_quotaugidlimit_cp', '', '', array('chk_it' => 1, 'val' => $info['enable_quotaugidlimit_cp'])).'
					</div>
				</div>
				<div class="row mx-auto w-100 my-3">
					<div class=" col-8">
						<label class="control-label">'.__('Enable IO Bandwidth Limit settings in Client panel').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('By default IO Bandwidth Limit icon will be disabled.').'"><i class="fas text-primary fa-info-circle"></i></a></label>
					</div>
					<div class=" col-4">
						'.get_checkbox('enable_iolimit_cp', '', '', array('chk_it' => 1, 'val' => $info['enable_iolimit_cp'])).'
					</div>
				</div>
				<div class="row mx-auto w-100 my-3">
					<div class=" col-8">
						<label class="control-label">'.__('Enable IOPS Limit settings in Client panel').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('By default IOPS Limit icon will be disabled.').'"><i class="fas text-primary fa-info-circle"></i></a></label>
					</div>
					<div class=" col-4">
						'.get_checkbox('enable_iopslimit_cp', '', '', array('chk_it' => 1, 'val' => $info['enable_iopslimit_cp'])).'
					</div>
				</div>';

				if($master){
				echo '<div class="row mx-auto w-100 my-3">
					<div class=" col-8">
						<label class="control-label">'.__('Enable Serial Console').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Enable Serial console for OpenVZ containers. Warning, SSH users will be created on the OpenVZ Nodes for users to use this feature.').'"><i class="fas text-primary fa-info-circle"></i></a></label>
					</div>
					<div class=" col-4">
						'.get_checkbox('enable_console', '', '', array('chk_it' => 1, 'val' => $info['enable_console'])).'
					</div>
				</div>';
				}

				echo '<div class="row mx-auto w-100 my-3">
					<div class="col-sm-8">
						<label class="control-label">'.__('Suspend VPS on High Load').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If set, load (uptime) of each VPS for the past 5 minute will be checked and if it is higher than the set value, VMs will be suspended').'"><i class="fas text-primary fa-info-circle"></i></a></label>
					</div>
					<div class="col-sm-4">
						<input type="text" class="form-control" name="openvz_suspend_load" id="openvz_suspend_load" size="30" value="'.POSTval('openvz_suspend_load', $info['openvz_suspend_load']).'" />
					</div>
				</div>
			</div>
		</div>';
		}


		echo '
		<div  class="divroundshad card mb-3">
		<div class="roundheader">'.__('Security Settings').'</div>
			<div class="px-3">';
			if($master){
				
				echo '<div class="row mx-auto w-100 my-3">
					<div class="col-sm-6 p-0">
						<label class="control-label">'.__('Max Login Attempts').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('The number of attempts allowed before banning the IP for a period of time specified in the <b>Failed Login Ban Time</b>').'"><i class="fas text-primary fa-info-circle"></i></a></label>
					</div>
					<div class="col-sm-6 p-0">
						<input type="number" min="0" class="form-control" name="login_attempts" id="login_attempts" size="30" value="'.POSTval('login_attempts', $info['login_attempts']).'" />
					</div>
				</div>

				<div class="row mx-auto w-100 my-3">
					<div class="col-sm-6 p-0">
						<label class="control-label">'.__('Failed Login Ban Time').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('The time in minutes to ban the IP of the user who has crossed the <b>Max Login Attempts</b>').'"><i class="fas text-primary fa-info-circle"></i></a></label>
					</div>
					<div class="col-sm-6 p-0">
						<input type="number" min="0" class="form-control" name="login_ban_time" id="login_ban_time" size="30" value="'.POSTval('login_ban_time', $info['login_ban_time']).'" />
					</div>
				</div>

				<div class="row mx-auto w-100 my-3">
					<div class="col-sm-6 p-0">
						<label class="control-label">'.__('Allowed IP list to Access Panel').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('List of IPs which are allowed to access Virtualizor Admin panel. If set, only these IPs will be allowed to access Admin panel. If more than one IP, IPs must be seperated by \',\'. If left empty, no restrictions will be imposed on IPs allowed. Currently supporting only IPv4 IP').'"><i class="fas text-primary fa-info-circle"></i></a></label>
					</div>
					<div class="col-sm-6 p-0">
						<input type="text" class="form-control" name="secure_allowed_ips" id="secure_allowed_ips" size="30" value="'.POSTval('secure_allowed_ips', $info['secure_allowed_ips']).'" />
					</div>
				</div>

				<div class="row mx-auto w-100 my-3">
					<div class="col-sm-6 p-0">
						<label class="control-label">'.__('Allowed IP list to restrict API operations').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('List of IPs which are allowed to perform API operations. If more than one IP, IPs must be seperated by \',\'. If left empty, no restrictions will be imposed. Currently supporting only IPv4 IP').'"><i class="fas text-primary fa-info-circle"></i></a></label>
					</div>
					<div class="col-sm-6 p-0">
						<input type="text" class="form-control" name="secure_allowed_api_ips" id="secure_allowed_api_ips" size="30" value="'.POSTval('secure_allowed_api_ips', $info['secure_allowed_api_ips']).'" />
					</div>
				</div>

				<div class="row mx-auto w-100 my-3">
					<div class=" col-6 p-0">
						<label class="control-label">'.__('Disable Server Web Terminal').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If enabled, server web terminal access will be disabled from the Admin panel').'"><i class="fas text-primary fa-info-circle"></i></a></label>
					</div>
					<div class=" col-6 p-0">
						'.get_checkbox('disable_terminal_access', '', 'disable_terminal_access', array('chk_it' => 1, 'val' => $info['disable_terminal_access'])).'
					</div>
				</div>

				<div class="row mx-auto w-100 my-3">
					<div class=" col-6 p-0">
						<label class="control-label">'.__('Enable LDAP Authentication').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Admin login Authentication will be done with LDAP server ').'"><i class="fas text-primary fa-info-circle"></i></a></label>
					</div>
					<div class=" col-6 p-0">
						'.get_checkbox('enable_ldap_auth', '', 'enable_ldap_auth', array('chk_it' => 1, 'val' => $info['enable_ldap_auth']),1,'',array('onchange="check_ldap();"')).'
					</div>
				</div>


				<div id="ldap_div" style="display: none;">

					<div class="row mx-auto w-100 my-3">
						<div class="col-sm-6 p-0">
							<label class="control-label">'.__('LDAP Server').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Enter the LDAP server Hostname or IP address').'"><i class="fas text-primary fa-info-circle"></i></a></label>
						</div>
						<div class="col-sm-6 p-0">
							<input type="text" class="form-control" name="ldap_server" id="ldap_server" size="30" value="'.POSTval('ldap_server', $info['ldap_server']).'" />
						</div>
					</div>

					<div class="row mx-auto w-100 my-3">
						<div class="col-sm-6 p-0">
							<label class="control-label">'.__('LDAP Port').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Enter the LDAP server Port ( Default is 389 )').'"><i class="fas text-primary fa-info-circle"></i></a></label>
						</div>
						<div class="col-sm-6 p-0">
							<input type="number" class="form-control" name="ldap_port" id="ldap_port" size="30" value="'.POSTval('ldap_port', $info['ldap_port']).'" />
						</div>
					</div>

					<div class="row mx-auto w-100 my-3">
						<div class="col-sm-6 p-0">
							<label class="control-label">'.__('LDAP Admin').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Enter the dn (distinguished name) of LDAP admin user <br /> eg :- cn=admin,dc=ldapserver,dc=local').'"><i class="fas text-primary fa-info-circle"></i></a></label>
						</div>
						<div class="col-sm-6 p-0">
							<input type="text" class="form-control" name="ldap_admin_username" id="ldap_admin_username" size="30" value="'.POSTval('ldap_admin_username', $info['ldap_admin_username']).'" />
						</div>
					</div>

					<div class="row mx-auto w-100 my-3">
						<div class="col-sm-6 p-0">
							<label class="control-label">'.__('LDAP Password').'&nbsp;</label>
						</div>
						<div class="col-sm-6 p-0">
							<input type="text" class="form-control" name="ldap_admin_password" id="ldap_admin_password" size="30" value="'.POSTval('ldap_admin_password').'" />
						</div>
					</div>

					<div class="row mx-auto w-100 my-3">
						<div class="col-sm-6 p-0">
							<label class="control-label">'.__('LDAP user\'s dn (distinguished name)').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Enter the search base from which users will be authenticated. <br /> eg :- ou=users,dc=ldapserver,dc=local <br />Please Note:<br /><ul><li>Entry of the user must be present on LDAP Server, and Mail attribute of the user must be set, or else users will not be able to login</li></ul>').'"><i class="fas text-primary fa-info-circle"></i></a></label>
						</div>
						<div class="col-sm-6 p-0">
							<input type="text" class="form-control" name="ldap_search_base" id="ldap_search_base" size="30" value="'.POSTval('ldap_search_base', $info['ldap_search_base']).'" />
						</div>
					</div>
				</div>';

			}

			if(empty($master)){
				echo '<div class="row mx-auto w-100 my-3">
					<div class="col-sm-6 p-0">
						<label class="control-label">'.__('Change SSH port').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Set the SSH port for your Server. Its recommeded to change this for better security.').'"><i class="fas text-primary fa-info-circle"></i></a></label>
					</div>
					<div class="col-sm-6 p-0">
						<input type="number" min="0" class="form-control" name="change_ssh_port" id="change_ssh_port" size="30" value="'.POSTval('change_ssh_port', $info['change_ssh_port']).'" />
					</div>
				</div>

				<div class="row mx-auto w-100 my-3">
					<div class="col-sm-6 p-0">
						<label class="control-label">'.__('Maximum SSH Login').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Set the maximum SSH login attempts').'"><i class="fas text-primary fa-info-circle"></i></a></label>
					</div>
					<div class="col-sm-6 p-0">
						<input type="number" min="0" class="form-control" name="max_ssh_login" id="max_ssh_login" size="30" value="'.POSTval('max_ssh_login', $info['max_ssh_login']).'" />
					</div>
				</div>';
				}

				echo '
			</div>
		</div>';

		if(empty($master)){
			
			$countries = array('AD', 'AE', 'AF', 'AG', 'AI', 'AL', 'AM', 'AN', 'AO', 'AQ', 'AR', 'AS', 'AT', 'AU', 'AW', 'AX', 'AZ', 'BA', 'BB', 'BD', 'BE', 'BF', 'BG', 'BH', 'BI', 'BJ', 'BL', 'BM', 'BN', 'BO', 'BQ', 'BR', 'BS', 'BT', 'BV', 'BW', 'BY', 'BZ', 'CA', 'CC', 'CD', 'CF', 'CG', 'CH', 'CI', 'CK', 'CL', 'CM', 'CN', 'CO', 'CR', 'CU', 'CV', 'CW', 'CX', 'CY', 'CZ', 'DE', 'DJ', 'DK', 'DM', 'DO', 'DZ', 'EC', 'EE', 'EG', 'EH', 'ER', 'ES', 'ET', 'EU', 'FI', 'FJ', 'FK', 'FM', 'FO', 'FR', 'GA', 'GB-ENG', 'GB-NIR', 'GB-SCT', 'GB-WLS', 'GB', 'GD', 'GE', 'GF', 'GG', 'GH', 'GI', 'GL', 'GM', 'GN', 'GP', 'GQ', 'GR', 'GS', 'GT', 'GU', 'GW', 'GY', 'HK', 'HM', 'HN', 'HR', 'HT', 'HU', 'ID', 'IE', 'IL', 'IM', 'IN', 'IO', 'IQ', 'IR', 'IS', 'IT', 'JE', 'JM', 'JO', 'JP', 'KE', 'KG', 'KH', 'KI', 'KM', 'KN', 'KP', 'KR', 'KW', 'KY', 'KZ', 'LA', 'LB', 'LC', 'LI', 'LK', 'LR', 'LS', 'LT', 'LU', 'LV', 'LY', 'MA', 'MC', 'MD', 'ME', 'MF', 'MG', 'MH', 'MK', 'ML', 'MM', 'MN', 'MO', 'MP', 'MQ', 'MR', 'MS', 'MT', 'MU', 'MV', 'MW', 'MX', 'MY', 'MZ', 'NA', 'NC', 'NE', 'NF', 'NG', 'NI', 'NL', 'NO', 'NP', 'NR', 'NU', 'NZ', 'OM', 'PA', 'PE', 'PF', 'PG', 'PH', 'PK', 'PL', 'PM', 'PN', 'PR', 'PS', 'PT', 'PW', 'PY', 'QA', 'RE', 'RO', 'RS', 'RU', 'RW', 'SA', 'SB', 'SC', 'SD', 'SE', 'SG', 'SH', 'SI', 'SJ', 'SK', 'SL', 'SM', 'SN', 'SO', 'SR', 'SS', 'ST', 'SV', 'SX', 'SY', 'SZ', 'TC', 'TD', 'TF', 'TG', 'TH', 'TJ', 'TK', 'TL', 'TM', 'TN', 'TO', 'TR', 'TT', 'TV', 'TW', 'TZ', 'UA', 'UG', 'UM', 'US', 'UY', 'UZ', 'VA', 'VC', 'VE', 'VG', 'VI', 'VN', 'VU', 'WF', 'WS', 'XK', 'YE', 'YT', 'ZA', 'ZM', 'ZW');

			echo '
			<div class="divroundshad card mb-3">
				<div class="roundheader">'.__('Server Location Settings').'</div>
				<div class="px-3">
					<div class="row mx-auto w-100 my-3">
						<div class="col-sm-6 p-0">
							<label class="control-label">'.__('Country Code').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Set the country code where your server is located').'"><i class="fas text-primary fa-info-circle"></i></a></label>
						</div>
						<div class="col-sm-6 p-0"> 
							<select name="server_country_code" class="form-control chosen">
								<option value="">'.__('Select your country code').'</option>';
								foreach($countries as $country){
									echo '<option value="'.$country.'" '.ex_POSTselect('server_country_code', $country, $info['server_country_code']).'>'.$country.'</option>';
								}						
							echo '</select>
						</div>
					</div>
					<div class="row mx-auto w-100 my-3">
						<div class="col-sm-6 p-0">
							<label class="control-label">'.__('State').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Set the state where your server is located').'"><i class="fas text-primary fa-info-circle"></i></a></label>
						</div>
						<div class="col-sm-6 p-0">
							<input type="text" name="server_state" class="form-control" value="'.POSTval('server_state', $info['server_state']).'">
						</div>
					</div>
					<div class="row mx-auto w-100 my-3">
						<div class="col-sm-6 p-0">
							<label class="control-label">'.__('City').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Set the city where your server is located').'"><i class="fas text-primary fa-info-circle"></i></a></label>
						</div>
						<div class="col-sm-6 p-0">
							<input type="text" name="server_city" class="form-control" value="'.POSTval('server_city', $info['server_city']).'">
						</div>
					</div>
				</div>
			</div>';
		}

		echo '<div  class="divroundshad card mb-3">
			<div class="roundheader">'.__('Create VPS IO/CPU priority').'</div>
				<div class="px-3">
			';
			
			if($master){
				echo '<div class="row mx-auto w-100 my-3">
					<div class="col-sm-6 p-0">
						<label class="control-label">'.__('Enable Queue Creation').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('e.g. If you set the value to 2, only 2 VPS will be created at a time. Other creation processes will be queued').'"><i class="fas text-primary fa-info-circle"></i></a></label>
					</div>
					<div class="col-sm-6 p-0">
						<input type="text" class="form-control" name="queue_creation" size="10" value="'.POSTval('queue_creation', @$info['queue_creation']).'" />
					</div>
				</div>
				<div class="row mx-auto w-100 my-3">
					<div class=" col-6 p-0">
						<label class="control-label">'.__('Disable Master VPS Name').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('By default the Master decides the VPS name and uses the highest VPS name available in the Cluster. If this is checked, the VPS name will be decided by each individual slave server.').'"><i class="fas text-primary fa-info-circle"></i></a></label>
					</div>
					<div class=" col-6 p-0">
						'.get_checkbox('disable_master_vpsname', '', '', array('chk_it' => 1, 'val' => @$info['disable_master_vpsname'])).'
					</div>
				</div>
				<div class="row mx-auto w-100 my-3">
					<div class="col-sm-6 p-0">
						<label class="control-label">'.__('Custom MAC Prefix').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Initial 3 Octet for auto generated MAC addresses of VMs. If not set then default value 00:16:3e will be used').'"><i class="fas text-primary fa-info-circle"></i></a></label>
					</div>
					<div class="col-sm-6 p-0">
						<input type="text" class="form-control" id="custom_mac" name="custom_mac" placeholder="eg. 9a:f8:15" value="'.POSTval('custom_mac', $info['custom_mac']).'" />			
							
					</div>
				</div>
				<div class="row mx-auto w-100 my-3">
					<div class="col-sm-6 p-0">
						<label class="control-label">'.__('Use HVM by default').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Select this option to set HVM as default for VPS creation on supported hypervisors').'"><i class="fas text-primary fa-info-circle"></i></a></label>
					</div>
					<div class=" col-sm-6 p-0">
						'.get_checkbox('set_def_hvm', '', '', array('chk_it' => 1, 'val' => @$info['set_def_hvm'])).'
					</div>
				</div>';
			}
			
			if(empty($master)){
				echo '<div class="row mx-auto w-100 my-3">
					<div class="col-sm-6 p-0">
						<label class="control-label">'.__('VPS Creation Limit').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('This config is to restrict the number of VPS that will be created on this server. Set 0 for no restriction.').'"><i class="fas text-primary fa-info-circle"></i></a></label>
					</div>
					<div class="col-sm-6 p-0">
						<input type="text" class="form-control" name="vpslimit" id="vpslimit" size="30" value="'.POSTval('vpslimit', $info['vpslimit']).'" />
					</div>
				</div>
				<div class="row mx-auto w-100 my-3">
					<div class="col-sm-6 p-0">
						<label class="control-label">'.__('Virtual Cores').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Number of virtual cores available for VPS creation. Once the limit is reached <br /> -  VPS(s) can not be created on this node. <br /> - Additional cores can not be assigned to existing VPS').'"><i class="fas text-primary fa-info-circle"></i></a></label>
					</div>
					<div class="col-sm-6 p-0">
						<input type="text" class="form-control" name="vcores" id="vcores" size="30" value="'.POSTval('vcores', $info['vcores']).'" />
					</div>
				</div>';
			}
				
			echo '<div class="row mx-auto w-100 my-3">
					<div class="col-sm-6 p-0">
						<label class="control-label">'.__('Process Priority').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('CPU time the backup process will get. 19 (least favourable) to -20 (most favourable)').'"><i class="fas text-primary fa-info-circle"></i></a></label>
					</div>
					<div class="col-sm-6 p-0">
						<select class="custom-select" name="addvs_cpu_prio" id="addvs_cpu_prio">';
							echo '<option value="" '.($info['addvs_cpu_prio'] == '' ? 'selected="selected"' : '').'>None</option>';
							if($info['addvs_cpu_prio'] == ''){
								$info['addvs_cpu_prio'] = 'none';
							}
							for($i=-20; $i<20; $i++){
								echo '<option value="'.$i.'" '.ex_POSTselect('addvs_cpu_prio', "$i", $info['addvs_cpu_prio']).'>'.$i.'</option>';
							}
							
						echo '</select>
					</div>
				</div>
				<div class="row mx-auto w-100 my-3">
					<div class="col-sm-6 p-0">
						<label class="control-label">'.__('Process I/O Priority').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('IO priority for the backup process').'"><i class="fas text-primary fa-info-circle"></i></a></label>
					</div>
					<div class="col-sm-6 p-0">
						<select class="custom-select" name="addvs_io_prio" id="addvs_io_prio">';
							echo '<option value="" '.($info['addvs_io_prio'] == '' ? 'selected="selected"' : '').'>None</option>';
							if($info['addvs_io_prio'] == ''){
								$info['addvs_io_prio'] = 'none';
							}
							for($i=0; $i<8; $i++){
								echo '<option value="'.$i.'" '.ex_POSTselect('addvs_io_prio', "$i", $info['addvs_io_prio']).' >'.$i.'</option>';
							}
							
						echo '</select>
					</div>
				</div>
				<div class="row mx-auto w-100 my-3">
					<div class="col-sm-6 p-0">
						<label class="control-label">'.__('Process I/O Class').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('IO class for the backup process').'"><i class="fas text-primary fa-info-circle"></i></a></label>
					</div>
					<div class="col-sm-6 p-0">
						<select class="custom-select" name="addvs_io_class" id="addvs_io_class">';
								echo '<option value="" '.(POSTval('addvs_io_class') == '' ? 'selected="selected"' : ($info['addvs_io_class'] == '' ? 'selected="selected"' : '')).'>None</option>';
								echo'<option value="1" '.(POSTval('addvs_io_class') == 1 ? 'selected="selected"' : ($info['addvs_io_class'] == 1 ? 'selected="selected"' : '')).'>Real Time</option>
								<option value="2"  '.(POSTval('addvs_io_class') == 2 ? 'selected="selected"' : ($info['addvs_io_class'] == 2 ? 'selected="selected"' : '')).'>Best Effort</option>
								<option value="3"  '.(POSTval('addvs_io_class') == 3 ? 'selected="selected"' : ($info['addvs_io_class'] == 3 ? 'selected="selected"' : '')).'>Idle</option>
						</select>
					</div>
				</div>
				<div class="row mx-auto w-100 my-3">
					<div class="col-sm-12 notice mb-0">
						'.__('You need to set all the three values for this to come into effect during VPS creation').'
					</div>
				</div>
			</div>
		</div>';

		echo '<div  class="divroundshad card mb-3">
		<div class="roundheader">'.__('Update Settings').'</div>
		<div class="px-3">';

			if($master){

				echo '<div class="row mx-auto w-100 my-3">
					<div class="col-sm-6 p-0">
						<label class="control-label">'.__('Auto Update Virtualizor').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If enabled Virtualizor will automatically update itself to the latest version.<br />The <b>Stable</b> branch is launched after the Release Candidate has been thorughly tested. <br />The <b>Release Candidate</b> branch contains the latest version and features.').'"><i class="fas text-primary fa-info-circle"></i></a></label>
					</div>
					<div class="col-sm-6 p-0">
							
						<label class="custom-control custom-radio">
							<input type="radio" id="update1" name="update" value="0" '.(POSTval('update', $info['update']) == '0' ? 'checked="checked"' : '').' class="custom-control-input" >
							<span class="custom-control-label" for="update1">'.__('Never Update').'</span>
						</label>	
						
						<label class="custom-control custom-radio">
							<input type="radio" id="update2" name="update" value="1" '.(POSTval('update', $info['update']) == '1' ? 'checked="checked"' : '').' class="custom-control-input" >
							<span class="custom-control-label" for="update2">'.__('Stable (Recommended)').'</span>
						</label>
						
						<label class="custom-control custom-radio">
							<input type="radio" id="update3" name="update" value="2" '.(POSTval('update', $info['update']) == '2' ? 'checked="checked"' : '').' class="custom-control-input" >
							<span class="custom-control-label" for="update3">'.__('Release Candidate (Experimental!)').'</span>
						</label>
								
					</div>
				</div>
				<div class="row mx-auto w-100 my-3">
					<div class=" col-6 p-0">
						<label class="control-label">'.__('Notify Updates').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Will send emails when Virtualizor upgrades are available or Auto Upgrade is performed').'"><i class="fas text-primary fa-info-circle"></i></a></label>
					</div>
					<div class=" col-6 p-0">
						'.get_checkbox('email_update', '', '', array('chk_it' => 1, 'val' => @$info['email_update'])).'
					</div>
				</div>
				<div class="row mx-auto w-100 my-3">
					<div class=" col-6 p-0">
						<label class="control-label">'.__('Disable Client Emails').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('When a new VPS is created, no email will be sent to the client').'"><i class="fas text-primary fa-info-circle"></i></a></label>
					</div>
					<div class=" col-6 p-0">
						'.get_checkbox('email_update_client', '', '', array('chk_it' => 1, 'val' => @$info['email_update_client'])).'
					</div>
				</div>';
			}

			if(empty($master)){
				echo '<div class="row mx-auto w-100 my-3">
					<div class="col-sm-6 p-0">
						<label class="control-label">'.__('Cron Job Frequency').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('The cron job that will collect all information of VPS(s) and also check for updates.').'"><i class="fas text-primary fa-info-circle"></i></a></label>
					</div>
					<div class="col-sm-6 p-0">
						<input type="text" name="cron_time" class="form-control" id="cron_time" size="30" value="'.POSTval('cron_time', $info['cron_time']).'" />
					</div>
				</div>
				<div class="row mx-auto w-100 my-3">
					<div class="col-sm-6 p-0">
						<label class="control-label">'.__('EMPS Cron Job Frequency').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('The EMPS cron job that will update the EMPS stack of PHP, NGinx and MySQL. We recommend to have this set for twice a month').'"><i class="fas text-primary fa-info-circle"></i></a></label>
					</div>
					<div class="col-sm-6 p-0">
						<input type="text" name="emps_cron_time" class="form-control" id="emps_cron_time" size="30" value="'.POSTval('emps_cron_time', $info['emps_cron_time']).'" />
					</div>
				</div>';
			}

		echo '
			</div>
		</div>
		<div  class="divroundshad card mb-3">
			<div class="roundheader">'.__('Notify Settings').'</div>
			<div class="px-3">
				<div class="row mx-auto w-100 my-3">
					<div class="col-sm-6 p-0">
						<label class="control-label">'.__('Alert on High Load').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If the <b>15 minute</b> load of the hardware node exceeds the limit set here, an email will be sent to the Administrator.').'"><i class="fas text-primary fa-info-circle"></i></a></label>
					</div>
					<div class="col-sm-6 p-0">
						<input type="text" class="form-control" name="alert_load_limit" id="alert_load_limit" size="30" value="'.POSTval('alert_load_limit', $info['alert_load_limit']).'" />
					</div>
				</div>
				<div class="row mx-auto w-100 my-3">
					<div class="col-sm-6 p-0">
						<label class="control-label">'.__('Disk Alert Limit').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If the Disk Usage of the Node exceeds the set limit (in %), an email will be sent to the Administrator.').'"><i class="fas text-primary fa-info-circle"></i></a></label>
					</div>
					<div class="col-sm-6 p-0">
						<input type="text" class="form-control" name="alert_disk_limit" id="alert_disk_limit" size="30" value="'.POSTval('alert_disk_limit', $info['alert_disk_limit']).'" />
					</div>
				</div>
			</div>
		</div>
	</div>
</div>
';
echo '<br><br><center>
<input type="submit" name="editsettings" value="'.__('Save Settings').'" class="go_btn"/>
</center><br><br>

</form>
';
}
echo'
</div>';
echo '</div>';
softfooter();


}

?>