<?php

//////////////////////////////////////////////////////////////
//===========================================================
// backup_plans_theme.php
//===========================================================
// SOFTACULOUS VIRTUALIZOR
// Version : 2.8.1
// Inspired by the DESIRE to be the BEST OF ALL
// ----------------------------------------------------------
// Started by: Husain	
// Date:       10th Nov 2015
// Time:       23:00 hrs
// Site:       https://www.virtualizor.com/ (SOFTACULOUS VIRTUALIZOR)
// ----------------------------------------------------------
// Please Read the Terms of use at https://www.virtualizor.com
// ----------------------------------------------------------
//===========================================================
// (c)Softaculous Ltd.
//===========================================================
//////////////////////////////////////////////////////////////

if(!defined('VIRTUALIZOR')){

	die('Hacking Attempt');

}

function backup_plans_theme(){

global $theme, $globals, $kernel, $user, $l, $backup_plans, $error, $done;

softheader($l['<title>']);
					
$buttons = array(
				0 => array(
					'name' => __('Add Backup Plan'),
					'act'  => 'addbackup_plan'
				)
			);

echo page_header(__('Backup Plans'), 'fas fa-clipboard', '', 1, 0, $buttons);

$breadcrumbs = array( 'dashboard', 'lms_backup_plans');

echo get_breadcrumb($breadcrumbs);

error_handle($error);

echo '<script language="javascript" type="text/javascript"><!-- // --><![CDATA[

function go_click(ele) {
	
	var backup_list = new Array();
	
	$(".ios:checked").each(function() {
		backup_list.push($(this).val());
	});
	
	if(backup_list.length < 1){
		showalert("'.__J('Nothing selected !').'","1");
		return false;
	}
	
	var action = $(ele).parent().prev().find("select").val();
	
	if(action == 1) {
		change_backup_plan(backup_list, "enable");
	} else if(action == 2) {
		change_backup_plan(backup_list, "disable");
	} else if(action == 3) {
		Delbackup_plans(backup_list);
	} else {
		showalert("'.__J('No Action Selected !').'","1");
		return false;
	}
	
}

function change_backup_plan(backup_list, action) {
	
	var finalData = new Object();
	
	finalData["bpids"] = backup_list.join(",");
	finalData["action"] = action;
	
	$("#progress_bar").show();
	
	$.ajax({
		type: "POST",
		url: "'.$globals['index'].'act=backup_plans&api=json",
		data : finalData,
		dataType : "json",
		success: function(data){
			$("#progress_bar").hide();
			if("done" in data){
				showalert("'.__J('The action was completed successfully. Reloading the Page !').'");
				$("#alert-modal").on("hidden.bs.modal", function (e) {
				location.reload(true);
				});
			}
		},
		error: function(data) {
			$("#progress_bar").hide();
			return false;
		}
	});
	
}

function Delbackup_plans(backup_list){
	showalert("'.__J('Are you sure, you want to Delete the Plan ?').'" ,"3" ,function(confirm){
		if(confirm == false){
			return false;
		}else{
			var finalData = new Object();
			finalData["delete"] = backup_list.join(",");

			//alert(finalData);
			//return false;
			
			$("#progress_bar").show();
			
			$.ajax({
				type: "POST",
				url: "'.$globals['index'].'act=backup_plans&api=json",
				data : finalData,
				dataType : "json",
				success: function(data){
					$("#progress_bar").hide();
					if("done" in data){
						setTimeout(function(){showalert("'.__J('The action was completed successfully. Reloading the Page !').'");
						$("#alert-modal").on("hidden.bs.modal", function (e) {
						location.reload(true);
						});} ,200);
					}
				},
				error: function(data) {
					$("#progress_bar").hide();
					//alert(data.description);
					return false;
				}
			});
		}
	});
	
	
	
	
	return false;
};

// ]]></script>
<div class="card p-2 mx-3">
	<div id="showsearch" class="my-1" style="display:'.(optREQ('search') || (!empty($backup_plans) && !empty($globals['showsearch'])) ? "" : "none").';">
	<form accept-charset="'.$globals['charset'].'" name="backup_plans" method="GET" action="" class="form-horizontal">
		<input type="hidden" name="act" value="backup_plans">
		<div class="form-group_head">
			<div class="row mx-auto w-100">
				<div class="col-sm-4"></div>
				<div class="col-sm-4"><label>'.__('Plan Name').'</label><input type="text" class="form-control" name="planname" id="planname" size="30" value="'.REQval('planname','').'"/>
				</div>
			</div>
			<div class="row mx-auto w-100 my-2">
				<div class="col-sm-12 text-center mb-3"><button type="submit" name="search" class="go_btn mt-2" value="Search"/>'.__('Submit').'</button>
				</div>
			</div>
		</div>
	</form>
</div>';

if($done){
	show_alert(__('The Backup Plan was deleted successfully'));
	//echo '<div class="notice"><b>NOTE : </b> '..'</div><br />';
}
if(empty($backup_plans)){
	optREQ('search') ? show_alert(__('No VPS Backup Tasks Found'), "2") : show_alert(__('There are no Backup Plans. <a href="index.php?act=addbackup_plan">Add a Backup Plan now</a>'), "2");
	echo '<div class="notice"><b>NOTE : </b> '.(optREQ('search') ? __('No VPS Backup Tasks Found') : __('There are no Backup Plans. <a href="index.php?act=addbackup_plan">Add a Backup Plan now</a>')).'</div>';
}else{

echo'<div class="row mx-auto w-100">
		<div class="col-sm-8 col-lg-8 col-md-6 d-flex align-items-center p-0">';
			page_links($globals['num_res'], $globals['cur_page'], $globals['reslen']);
		echo''.get_num_records($globals['num_res']).'
		</div>
		<div class="col-sm-4 col-lg-4 col-md-6 text-right d-flex align-items-center">
			<div class="bottom-menu float-right w-100">
				<div class="row my-auto">
					<div class="p-0">
						<label>'.__('With Selected').'</label>
					</div>
					<div class="col p-0">
						<select class="custom-select" name="backup_task_select" id="backup_task_select">
							<option value="0">---</option>
							<option value="1">'.__('Enable').'</option>
							<option value="2">'.__('Disable').'</option>
							<option value="3">'.__('Delete').'</option>
						</select>
					</div>
					<div class="pl-2">
						<input type="submit" id ="backup_submit" class="go_btn" name="backup_submit" value="'.__('GO').'" onclick="go_click(this); return false;">
					</div>
				</div>
			</div>
		</div>
	</div>
 	<div class="notice" align="left"><span><b> '.__('Note').' : </b> &nbsp; '.__('If Backuply license is not present on the node it will take a full backup for backuply plan as well').'</span></div>
	<form accept-charset="'.$globals['charset'].'" name="multi_dns" id="multi_dns" method="post" action="" class="form-horizontal">
		<div class="w-100 mx-auto sticky">
			<table class="table table-hover tablesorter common-table">
			<tr class="table_heading">
				<th class="min_width z-index-1" align="center">
					'.get_checkbox('select_all', __('Check all'), 'select_all', array('chk_it' => 0), '', 'select_all').'
				</th>
				<th class="min_width" align="center">'.__('ID').'</th>
				<th align="center">'.__('Plan Name').'</th>
				<th align="center">'.__('Plan Type').'</th>
				<th align="center">'.__('Backup Server').'</th>
				<th align="center">'.__('Frequency').'</th>
				<th align="center">'.__('Directory').'</th>
				<th align="center" class="min_width">'.__('Primary Backup').'</th>
				<th align="center" class="min_width">'.__('Disabled').'</th>
				<th colspan="2" width="10" class="min_width text-right">'.__('Manage').'</th>
			</tr>';
			$i = 0;
			foreach($backup_plans as $k => $v){
				
				$data = json_decode($v['data'], true);

				$backup_tag = !empty($data['enable_legacy_backup']) ? 'Legacy' : '<a class="badge badge-settings">Backuply</a>'; 
				
				echo '<tr>
					<td width="20" valign="middle" align="center">
						'.get_checkbox('backup_list[]', '', '', array('chk_it' => 0), $k).'
					</td>
					<td>'.$v['bpid'].'</td>
					<td>'.$v['plan_name'].'</td>
					<td>'.$backup_tag.'</td>
					<td>'.$v['backup_server'].'</td>
					<td>'.$v['frequency'].'</td>
					<td>'.$v['dir'].'</td>
					<td align="center">
						<h5 class="p-0 m-0"><a class="badge '.(empty($data['backup_primary']) ? 'badge-danger' : 'badge-success').'" title="'.(empty($data['backup_primary']) ? __('Primary Disk Backup is disabled') : __('Primary Disk Backup is enabled')).'">'.(empty($data['backup_primary']) ? __('Disabled') : __('Enabled')).'</a></h5>
					</td>
					<td align="center">'.(empty($v['disabled']) ? __('No') : __('Yes')).'</td>
					<td align="center" width="10">
						<div class="badge_container">
							<a class="badge badge-manage" href="?act=editbackup_plan&bpid='.$v['bpid'].'" title="Edit"><i class="fas fa-pencil-alt"></i></a>	
							<a class="badge badge-trash" href="javascript:void(0);" onclick="return Delbackup_plans(['.$k.']);" title="Delete"><i class="fas fa-trash"></i></a>
						</div>
					</td>
				</tr>';
			$i++;	
			}
		echo'</table>
		</div>';
	echo'<div class="row mx-auto w-100 mt-5">
		<div class="col-sm-8 col-lg-8 col-md-6 mb-3 p-0">';
			page_links($globals['num_res'], $globals['cur_page'], $globals['reslen']);
		echo'
		</div>
		<div class="col-sm-4 col-lg-4 col-md-6 text-right mb-3">
			<div class="bottom-menu float-right w-100">
				<div class="row my-auto">
					<div class="p-0">
						<label>'.__('With Selected').'</label>
					</div>
					<div class="col p-0">
						<select class="custom-select" name="backup_task_select" id="backup_task_select">
							<option value="0">---</option>
							<option value="1">'.__('Enable').'</option>
							<option value="2">'.__('Disable').'</option>
							<option value="3">'.__('Delete').'</option>
						</select>
					</div>
					<div class="pl-2">
						<input type="submit" id ="backup_submit" class="go_btn" name="backup_submit" value="'.__('GO').'" onclick="go_click(this); return false;">
					</div>
				</div>
			</div>
		</div>
		</div>

		<div id="progress_bar" style="display:none;">
			<br />
			<center>
				<font id="progress_txt" size="4">'.__('Please wait, Action in Progress.').'</font>
			</center>
			<div class="my-2" align="center">
				<div class="progress w-50">
					<div class="progress-bar bg-primary progress-bar-striped progress-bar-animated w-100">
					</div>
				</div>
			</div>
			<center>
				'.__('You will be notified once the Action is Completed.').'
			</center>
		</div>
	</form>';
}

echo '<div class="text-center my-4">
		<a href="'.$globals['ind'].'act=addbackup_plan" class="go_btn">'.__('Add Backup Plan').'</a>
	</div>
</div><br>


';
softfooter();

}
?>