<?php

//////////////////////////////////////////////////////////////
//===========================================================
// addvs_theme.php
//===========================================================
// SOFTACULOUS VIRTUALIZOR
// Version : 1.0
// Inspired by the DESIRE to be the BEST OF ALL
// ----------------------------------------------------------
// Started by: Alons
// Date:       8th Mar 2010
// Time:       23:00 hrs
// Site:       https://www.virtualizor.com/ (SOFTACULOUS VIRTUALIZOR)
// ----------------------------------------------------------
// Please Read the Terms of use at https://www.virtualizor.com
// ----------------------------------------------------------
//===========================================================
// (c)Softaculous Ltd.
//===========================================================
//////////////////////////////////////////////////////////////

if(!defined('VIRTUALIZOR')){

	die('Hacking Attempt');

}

function addvs_theme(){

global $theme, $globals, $kernel, $user, $l, $error, $cluster, $servers, $oslist, $done, $loop_device, $ostemplates, $usbs, $pcis, $machine_type, $custom_cp, $vga;
global $plans, $ips, $ips6, $ips6_subnet, $ips_int, $ipools, $servers, $users, $isos, $_virt, $virt, $hvm, $newvs, $resources, $cpu_info;
global $actid, $flag_createvps, $flag_ubcsettings, $done_data, $mgs, $servergroups, $scripts, $iscripts, $storages, $stid, $disk_space, $os_check, $disks, $dnsplans, $recipes, $supported_nics, $cpu_modes, $backup_plans;
global $iscripts_allowed, $webuzo_apps, $isfree, $webuzo_templates, $allowed_scripts, $webuzo_done, $bus_driver, $ha_enabled, $ajax_user, $load_balancer, $gpu_roms, $firewall_plans, $firewall_users, $pro_lic;


if($flag_createvps){
	
	echo 'actid='.$actid.';
	ubc_redirect='.$flag_ubcsettings.';';
	$flag_createvps = 0;
	return;
}

//Is Ajax Mode on?
if(optGET('ajax')){

	$planid = optGET('plan');
	$uid  = (int) optGET('uid');
	if(!empty($uid)){
		// Make the ISOs list as per user
		useriso($uid);
		$options_eu_iso = $options_iso = $options = '';
		$options = '<option value="0">'.__('None').'</option>';
		foreach($isos as $k => $v){
			if(!empty($v['isuseriso'])){
				$options_eu_iso .= '<option value="'.$k.'">'.$v['name'].'</option>';
			}else{
				$options_iso .= '<option value="'.$k.'">'.$v['name'].'</option>';
			}
		}

		if(!empty($options_iso)){
			$options .= '<optgroup label="'.__('Admin ISOs').'">'.$options_iso.'</optgroup>';
		}
		
		if(!empty($options_eu_iso)){
			$options .= '<optgroup label="'.__('Enduser ISOs').'">'.$options_eu_iso.'</optgroup>';
		}
		echo $options;
		return;
	}

	$get_demo_time = optREQ('get_demo_time');
	if(!empty($get_demo_time)){
		echo datify(time(), 1, 1, $get_demo_time);
		return;
	}
	
	echo 'var $plan = new Object();';
	
	foreach($plans[$planid] as $k => $v){
		
		if($k == 'dns_nameserver'){
			$tmp_dns = unserialize($v);
			echo '$plan["dns_nameserver"] = '.json_encode($tmp_dns).';';
			continue;
		}
		
		if($k == 'mgs'){
			$tmp_mgs = cexplode(',', $v);
			echo '$plan["mgs"] = '.json_encode($tmp_mgs).';';
			continue;
		}
		
		if($k == 'speed_cap' && !empty($v)){
			$v = _unserialize($v);
			echo '$plan["speed_cap_down"] = '.$v['down'].';
				$plan["speed_cap_up"] = '.$v['up'].';
			';
			continue;
		}		
	
		if($k == 'ippoolid'){
			echo '$plan["plan_ips"] = '.json_encode($ips).';';
			echo '$plan["internal_ips"] = '.json_encode($ips_int).';';
			continue;
		}
		
		if($k == 'recipe'){
			$v = (is_numeric($v) ? array($v) : _unserialize($v)); 
			echo '$plan["recipe"] = '.json_encode($v).';';
			continue;
		}

		if($k == 'data' && !empty($v)){
			$tmp_data = json_decode($v,1);
			//Is there a demo
			//print_r($tmp_data);
			if(!empty($tmp_data['demo'])){
				$tmp_expiry_demo = strtotime('+'.$tmp_data['demo']['duration_days'].' days');
				echo '
				$plan["dtime1"] = \''.datify($tmp_expiry_demo, 1, 1, 'H:i:s').'\';
				$plan["date1"] = \''.datify($tmp_expiry_demo, 1, 1, 'd/m/Y').'\';';
			}

			echo '$plan["data"] = '.json_encode(json_decode($v,1)).';';
			continue;
		}

		if($k == 'webuzo_data'){
			$v = _unserialize($v);
			echo '$plan["script"] = "'.$v['script'].'";
				$plan["mysql"] = "'.$v['mysql'].'";
				$plan["webuzo_stack"] = "'.$v['webuzo_stack'].'";
				$plan["webserver"] = "'.$v['webserver'].'";
				$plan["php"] = "'.$v['php'].'";
				$plan["webuzo_os"] = "'.$v['webuzo_os'].'";
			';
			continue;
		}
		
		echo '$plan["'.$k.'"] = "'.str_replace('"', '\"', $v).'";';
	}
	
	return true;
}

if(optGET('done')){

	if(!empty($done_data['newvs'])){
		$vps_data = $done_data['newvs'];
	}

	if(!empty($done_data['data']['newvs'])){
		$vps_data = $done_data['data']['newvs'];
	}

	$done = $vps_data['vpsid'];
	$vps_name = $vps_data['vps_name'];
	$root_pass = $vps_data['pass'];
	$vnc = $vps_data['vnc_details'];
	$vnc_pass = $vps_data['vncpass'];
	$ips = $vps_data['ips'];
	$ipsv6 = $vps_data['ipv6'];
	$ipsv6_subnet = $vps_data['ipv6_subnet_w_prefix'];
	$ips_int = $vps_data['ips_int'];
	
	show_alert(__('The Virtual Server has been created. Return to <a href="index.php?act=vs">Virtual Server Overview</a>'));
	echo '<div class="notice my-0 mx-3"><b>'.__('Note').' : </b> &nbsp; '.__('The Virtual Server has been created. Return to <a href="index.php?act=vs">Virtual Server Overview</a>').'</div>';
	echo '<div class="card mt-3 mx-3">
	<div class="row mx-auto w-100 my-3">
			<div class="row mx-auto w-100">
			<div class="col-sm-4">
				<span class="fhead text-secondary">'.__('VPS ID').'</span>
			</div>
			<div class="col-sm-8">'.$done.'</div>
			</div>
	</div>
	<div class="row mx-auto w-100 my-3">
			<div class="row mx-auto w-100">
			<div class="col-sm-4">
				<span class="fhead text-secondary">'.__('VPS Name').'</span>
			</div>
			<div class="col-sm-8">'.$vps_name.'</div>
			</div>
	</div>
	<div class="row mx-auto w-100 my-3">
			<div class="row mx-auto w-100">
			<div class="col-sm-4">
				<span class="fhead text-secondary">'.__('Root Password').'</span>
			</div>
			<div class="col-sm-8" id="newvs_rootpass">'.htmlentities($root_pass).'</div>
			</div>
	</div>';

	if($vnc){

		echo '<div class="row mx-auto w-100 my-3">
				<div class="row mx-auto w-100">
				<div class="col-sm-4">
					<span class="fhead text-secondary">'.__('VNC Details').'</span>
				</div>
				<div class="col-sm-8">'.$vnc.'</div>
				</div>
		</div>';
	
		if(!empty($vnc_pass)){
			echo '
			<div class="row mx-auto w-100 my-3">
					<div class="row mx-auto w-100">
					<div class="col-sm-4">
						<span class="fhead text-secondary">'.__('VNC Password').'</span>
					</div>
					<div class="col-sm-8" id="newvs_vncpass">'.$vnc_pass.'</div>
					</div>
			</div>';
		}
	}
	if(!empty($ips)){

		echo '
		<div class="row mx-auto w-100 my-3">
				<div class="row mx-auto w-100">
				<div class="col-sm-4">
					<span class="fhead text-secondary">'.__('IPs').'</span>
				</div>
				<div class="col-sm-8">'.implode(', ', $ips).'</div>
				</div>
		</div>';
		
	}

	if(!empty($ipsv6)){

		echo '<div class="row mx-auto w-100 my-3">
				<div class="row mx-auto w-100">
				<div class="col-sm-4">
					<span class="fhead text-secondary">'.__('IPv6').'</span>
				</div>
				<div class="col-sm-8">'.implode(', ', $ipsv6).'</div>
				</div>
		</div>';
	}

	if(!empty($ipsv6_subnet)){
		echo '
		<div class="row mx-auto w-100 my-3">
				<div class="row mx-auto w-100">
				<div class="col-sm-4">
					<span class="fhead text-secondary">'.__('IPv6 Subnet').'</span>
				</div>
				<div class="col-sm-8">'.implode(', ', $ipsv6_subnet).'</div>
				</div>
		</div>';
	}

	if(!empty($ips_int)){
		echo '
		<div class="row mx-auto w-100 my-3">
				<div class="row mx-auto w-100">
				<div class="col-sm-4">
					<span class="fhead text-secondary">'.__('Internal IP Addresses').'</span>
				</div>
				<div class="col-sm-8">'.implode(', ', $ips_int).'</div>
				</div>
		</div>';
	}

	echo '</div>';
	return true;
}

softheader($l['<title>']);
						
// Is it offline ?
$hypervisor_status = $cluster->statewise($globals['server']);
if($hypervisor_status == 0 || $hypervisor_status == 2){
	echo page_header(__('Add Virtual Server'), 'fas fa-server', $globals['docs'].'creating-a-vps', 0, 0, '');

	$breadcrumbs = array('dashboard', 'lm_vs', 'lms_addvs');

	echo get_breadcrumb($breadcrumbs);

	server_select();
	echo '<div class="e_notice mx-3 mb-3"><b>NOTE : </b>'.$globals['hypervisor_status'][$hypervisor_status].'</div>';
	echo '</div>';
}else{

if(!empty($done)){
	
	show_alert(__('The Virtual Server has been created. Return to <a href="index.php?act=vs">Virtual Server Overview</a>'));
	//echo '<div class="bg"><div class="notice"><b>NOTE : </b>'..'</div>';
	
	echo '<script>gettaskscount();</script><div>
	<div class="row mx-auto w-100 my-3">
		
			
			<div class="col-sm-4">
				<span class="fhead text-secondary">'.__('VPS ID').'</span>
			</div>
			<div class="col-sm-4">'.$done.'</div>
			
		
	</div>
	<div class="row mx-auto w-100 my-3">
		
			
			<div class="col-sm-4">
				<span class="fhead text-secondary">'.__('VPS Name').'</span>
			</div>
			<div class="col-sm-4">'.$newvs['vps_name'].'</div>
			
		
	</div>
	<div class="row mx-auto w-100 my-3">
		
			
			<div class="col-sm-4">
				<span class="fhead text-secondary">'.__('Root Password').'</span>
			</div>
			<div class="col-sm-4" id="newvs_rootpass">'.$newvs['pass'].'</div>
			
		
	</div>';

	if($newvs['vnc']){

		echo '<div class="row mx-auto w-100 my-3">
			
				
				<div class="col-sm-4">
					<span class="fhead text-secondary">'.__('VNC Details').'</span>
				</div>
				<div class="col-sm-4">'.$servers[$globals['server']]['ip'].':'.vncPort($newvs).'</div>
				
			
		</div>';
	
		if(!empty($vnc_pass)){
			echo '
			<div class="row mx-auto w-100 my-3">
				
					
					<div class="col-sm-4">
						<span class="fhead text-secondary">'.__('VNC Password').'</span>
					</div>
					<div class="col-sm-4">'.$newvs['vncpass'].'</div>
					
				
			</div>';
		}
	}

	echo '
	<div class="row mx-auto w-100 my-3">
		
			
			<div class="col-sm-4">
				<span class="fhead text-secondary">'.__('IPs').'</span>
			</div>
			<div class="col-sm-4">'.implode(', ', $newvs['ips']).'</div>
			
		
	</div>';

	if(!empty($newvs['ipv6'])){

		echo '<div class="row mx-auto w-100 my-3">
			
				
				<div class="col-sm-4">
					<span class="fhead text-secondary">'.__('IPv6').'</span>
				</div>
				<div class="col-sm-4">'.implode(', ', $newvs['ipv6']).'</div>
				
			
		</div>';

	}

	echo '</div></div>';	

}else{

	echo page_header(__('Add Virtual Server'), 'fas fa-server', $globals['docs'].'creating-a-vps', 0, 0, '');

	$breadcrumbs = array('dashboard', 'lm_vs', 'lms_addvs');

	echo get_breadcrumb($breadcrumbs);

	error_handle($error);
echo '<script language="javascript" type="text/javascript"><!-- // --><![CDATA[
	var regexp = /^actid/;
	var actid = null;
	var progress = 0;
	var progress_update = "";
	var timer = null;
	var newvs_rootpass = "";
	var newvs_vncpass = "";
	//var ubc_redirect = 0;

function check(){
	var cp = $("#control_panel").val();
	show_webuzo(cp);
};

function get_demo_time(el, date_format){
	$.ajax({
		type: "POST",
		url: "'.$globals['index'].'jsnohf=1&act=addvs&ajax=1&get_demo_time="+date_format,
		success:function(response){
			$("#"+el).val(response);
		}
	});
}

function prox_cpu_flags(){
	let cpu = $("#cpu_mode").val();
	$(".hide_all_cpu_flags").hide();
	$("."+cpu).show();
}
	function change_checkbox(id){	
		if(is_checked(id)){
			$("#hidden_"+id).val(1);
		}else{
			$("#hidden_"+id).val(0);
		}
	}

	let toggle_bios = () => {
	
		let ele = $("#bios").val();
	
		if(ele === "uefi"){
			$("#tpm_row").show();
			showalert("'.__J('To create VPS using UEFI bios, please use ISO as our default template won’t work with UEFI bios option. After creating VPS from ISO, resize will not be possible. Template creation will not work for VPS with UEFI bios.').'","2");
		}else{
			$("#tpm_row").hide();
		}		
		
	}
	
	function show_webuzo(cp){
		if(cp != "webuzo"){
			$("#webuzo_app_checkbox").hide();
			$("#show_webuzo_tr input[name=webuzo_os]").prop("disabled", true);
			return false;
		}
		
		$("#webuzo_app_checkbox").show();
		$("#show_webuzo_tr input[name=webuzo_os]").prop("disabled", false);
		ishvm();
	}

	function webuzo_app_install(){
		if($("#webuzo_install_app").prop("checked")){
			$("#show_webuzo_tr").css("display", "");
		}else{
			$("#show_webuzo_tr").css("display", "none");
		}
	};
	

	function webuzo_apps(stack){
		stack = stack || 0;
		
		if($("#stack1").data("demo") === "1"){
			$("#webuzo_stack_tr").hide();
			return;
		}
		$("#webuzo_stack_tr").slideDown("slow");	
		if(stack == \'lamp\'){
			$("#webuzo_webserver_tr").show();
		}else{
			$("#webuzo_webserver_tr").hide();
		}
	}
	
	function script_req(sid){
	
		if(sid == 0 || $("#script_isfree").val() > 0){
			return;
		}
		$("#stack1, #stack2, #stack3").prop("checked", false);
		
		processing_symb(1);
		
		if(AJAX("'.$globals['index'].'act=addvs&api=json&scriptreqid="+sid, "scriptdetails(re, true)")){
			return false;
		}else{
			return true;
		}
	};

	function scriptdetails(re, scriptreq){
		
		processing_symb();
		var re = $.parseJSON(re);
		scriptreq = scriptreq || false;
		
		if("error" in re){
			showalert(re["error"],"1");
			$("#webuzo_operation").hide();
			$("#webuzo_unsupport").show().text(re["error"]);
		}else{
			$("#webuzo_operation").show();
			$("#webuzo_unsupport").hide().text("");
		}
			
		if("webuzo_apps" in re["webuzo_done"]){
			for(x in re["webuzo_done"]["webuzo_apps"]){
				var id = "webuzo_"+x;
				var str = "";
				var val = re["webuzo_done"]["webuzo_apps"][x];
				str += \'<div class="row mx-auto w-100 my-2 my-0">\';
				for(k in val){
					str += \'<div class="col-4 p-0">\
					<label class="custom-control custom-radio">\
						<input type="radio" class="form-check-input" name="\'+x+\'" id="serverver_\'+k+\'" value="\'+val[k][\'softname\']+\'">\
						<span class="custom-form-label" for="serverver_\'+k+\'">\'+val[k][\'fullname\']+\'</span>\
					</label></div>\';
				}
				str += \'</div>\';
				
				$("#"+id).html(str);
			}
		}
		
		if("isfree" in re["webuzo_done"]){
			$("#stack2_tr, #stack3_tr").hide();
			$("#stack1").prop("checked", true).data("demo", "1");
			$("#script_isfree").val(1);
		}else{
			$("#stack2_tr, #stack3_tr").show();
			$("#stack1").data("demo", "0");
		}
		
		if(scriptreq == true){
			return;
		}
		
		var options = \'<option value="0">'.__J('None').'</option>\';
		if("allowed_scripts" in re["webuzo_done"]){	
			for(x in re["webuzo_done"][\'allowed_scripts\']){
				options += \'<optgroup label="\'+x+\'">\';
				var val = re["webuzo_done"][\'allowed_scripts\'][x];
				for(k in val){
					options += \'<option value="\'+k+\'">\'+val[k][\'name\']+\'</option>\';
				}
				options += \'</optgroup>\';
			}
		}
	}
	
	$(document).ready(function(){
		
		$("#gram").on("keyup change", function(e) {
			var gram = $("#gram").val();
			$("#min_ram").val(gram);
		});
		
		$(window).keyup(function (e) {
			var code = (e.keyCode ? e.keyCode : e.which);
			if (code == 9 && $("#gram:focus").length && window.innerWidth > 500) {
				$("body,html").animate({scrollTop: 0}, 100);
			}
		});

		$("#addvsform .chosen").select2({width: "100%"});
		$("#hvm").change(function(data){
			if(data.target.checked){
				$("#tr_viftype").show();
			}
			else if(!data.target.checked){
				$("#tr_viftype").hide();
			}
			
		});
		
		$("#hvm").change(function(data){
			if(data.target.checked){
				$("#tr_pvonhvm").show();
			}
			else if(!data.target.checked){
				$("#tr_pvonhvm").hide();
			}
			
		});';
		
		if($virt != 'xenhvm'){
			echo '$("#tr_viftype").hide();';
			echo '$("#tr_pvonhvm").hide();';
		}
		
	
		echo '$("#addvsform").submit(function(){
			
			var space = new Array();
			var size = new Array();
			var storage = new Array();
			var tmp_space = new Object();
			var bootord = new Array();
			let set_bootord = 0;
			let select = document.getElementById("bootorder"); 
			if(select){
				for (var option of select.options){
					bootord.push(option.value);
				}
			}
			

			size = $(".size").map(function(){
				return this.value;
			}).get();
			
			storage = $(".storages").map(function(){
				return this.value;
			}).get();
			
			if($(".bus_driver")){
				bus_driver = $(".bus_driver").map(function(){
					return this.value;
				}).get();
			
				bus_driver_num = $(".bus_driver_num").map(function(){
					return this.value;
				}).get();
			}		
			
			 for(i = 0; i < $(".size").length; i++){
				 
		 
				if($(".bus_driver")){
					tmp_space[i] = {size: size[i], st_uuid: storage[i], bus_driver: bus_driver[i], bus_driver_num: bus_driver_num[i]};
				}else{
					tmp_space[i] = {size: size[i], st_uuid: storage[i]};
				}
				
				space.push(tmp_space[i]);
			}
			
			var json_data = JSON.stringify(space);
			
			//Reset this to zero on every new submit
			progress = 0;
			var params = $("#addvsform").serialize();
			newvs_vncpass = $("#vncpass").val();
			newvs_rootpass = $("#rootpass").val();
			$.ajax({type: "POST",
				url: "'.$globals['index'].'jsnohf=1&act=addvs'.(!empty($_REQUEST['stid']) ? '&stid='.optREQ('stid') : '').''.(!empty($_REQUEST['virt']) ? '&virt='.optREQ('virt') : '').''.(!empty($_REQUEST['debug']) ? '&debug='.optREQ('debug') : '').'",
				data:params+"&addvps=1&space="+json_data+"&bootord="+bootord,
				success:function(response){
						if(regexp.exec(trim(response)) != null){
							gettaskscount();
							animate_task("'.__J('Create VPS task started').'");
							eval(response);
							setTimeout("get_progress(\'addvs\')", 2000);
						}else{
							gettaskscount();
							var parsed_HTML = $(response);
							var error_box = parsed_HTML.filter("#error_box").add(parsed_HTML.find("#error_box"));
							//$("#form-container").prepend(error_box);
							showalert(error_box.html(),"1");
							$("#form-container").show();
							$("#progress-cont").hide();
							error_box.html("");
						}
				}
			});
			
			$("#error_box").remove();
			$("#form-container").hide();
			$("#progress-cont").show();
			$("#pbar").html("'.__J('Checking submitted data...').'" + " ( 0% ) ");
			window.scrollTo(0, 0);
			$("#progressbar").progressbar({value: 0});
			
			return false;
		});
		';
		if(!empty($globals['set_def_hvm']) && !isset($_POST['hvm'])){
			echo '
				$("#hvm").prop("checked", true);
				$("#hvm").trigger("change");
			';
		}
		
		echo '
		handle_ssh_settings();
	});
	
// ]]></script>';

echo '<script language="javascript" type="text/javascript">

var ips = new Object();
var virt = "'.$virt.'";';

foreach($ips as $k => $v){
	echo 'ips['.$k.'] = "'.$v['ip'].'";';
}

echo 'function addrow(id, val){
	var t = $_(id);
	var lastRow = (t.rows.length);
	var x= t.insertRow(lastRow);
	var y = x.insertCell(0);
	y.innerHTML = \'<input type="text" class="form-control float-left w-90" name="ips[]" value="\'+(val || "")+\'" onblur="checkippool()" size="20" /></td><td><a class="delip" title="'.__J('Remove this IP').'"><i class="fas fa-times text-danger cursor-pointer py-2"></i></a>\';
	
	ipdel();	
};

function changevif(){
	var name = $("#osid option:selected").html();
	if (name.match(/windows/i)) {
		$("input[name=vif_type][value=\'ioemu\']").prop("checked", true);
	}
};

function add_storage_list(id, val){
	
	var y = id.insertCell(1);
	var z = id.insertCell(2);

	var str = \'<select class="custom-select storages" name="storages[]">\';';
	
	foreach($storages as $sk => $sv){
		echo 'str += \'<option value="'.$sv['st_uuid'].'" '.($sv['st_uuid'] == $storages[$stid]['st_uuid'] ? 'selected="selected"' : '').'>'.$sv['name'].'&nbsp;('.$sv['disk_space'].' GB '.(empty($sv['oversell']) ? __J('Free') : __J('Overcommitted Free Space')).')</option>\';';
	}
	
	echo 'str += \'</select>\';
	y.innerHTML = str;
	y.style.paddingTop = "10px";
	z.style.paddingTop = "10px";
	z.innerHTML = \'<a class="delstorage" title="'.__J('Delete this storage').'"><i class="fas fa-times cursor-pointer py-2 text-danger"></i></a>\';
	storagedel();
};

change_bootorder = (ele) => {
	
	const select = document.getElementById("bootorder"); 

	if(select){
		if(select.options.length > 1){

			var selected = {};
			let prev = "";
			let pos = 0;
			let current = "";
			for (var option of select.options){
				if(option.selected) {
					prev = pos;
				}
				selected[pos] = option.value;
				pos+=1
			}
			
			if(prev !== ""){
				current = selected[prev];  
				let v1 = "";
				if(ele.id == "up"){
					v1 = selected[prev - 1];  
					if(v1 != undefined){
						selected[prev-1] = current;
					}
				}else if(ele.id == "down"){
					v1 = selected[prev + 1];  
					if(v1 != undefined){
						selected[prev+1] = current;
					}
				}   
				if(v1 != undefined){
					selected[prev] = v1;
				}
			}
			
			select.innerHTML = "";
			
			for (var key in selected) {
				
				let newOption = new Option(selected[key].toUpperCase(), selected[key], false, false);
				
				if(current === selected[key]){
					newOption = new Option(selected[key].toUpperCase(), selected[key], true, true);
				}
				select.add(newOption);
			}
		}
	}
}


add_bootorder = (iscdrom = 0) => {
	
	const select = document.getElementById("bootorder"); 

	if(select){
		let newOption = "";
		let val = "";
		if(select.options.length > 1){
			let disk = cd = 1;
			for (var option of select.options){
				if(option.value.match(/cdrom/gi)){
					cd += 1;	
				}else if(option.value.match(/disk/gi)){
					disk += 1;
				}
			}
			
			if(iscdrom){
				for(i= 1; i < cd; i++){
					val = "cdrom"+i.toString();
					newOption += "<option value=\""+val+"\">"+val.toUpperCase()+"</option>";
				}
			}
			
			if(disk > 2){
				for(i = 1; (i < disk-1); i++){
					val = "disk"+i.toString();
					newOption += "<option value=\""+val+"\">"+val.toUpperCase()+"</option>";
				}
			}else{
				val = "disk1";
				newOption += "<option value=\""+val+"\">"+val.toUpperCase()+"</option>";
			}

			if(!iscdrom){
				for(i= 1; i < cd; i++){
					val = "cdrom"+i.toString();
					newOption += "<option value=\""+val+"\">"+val.toUpperCase()+"</option>";
				}
			}

			select.innerHTML = "";
			select.innerHTML = newOption;
		}
	}
}

function add_storage(id, val){
	var t = $_(id);
	var lastRow = (t.rows.length);
	var x = t.insertRow(lastRow);
	var y = x.insertCell(0);
	var z = x.insertCell(1);

	y.innerHTML = \'<input name="size" class="form-control size" type="text" size="30" value="" />\';
	z.innerHTML = \'<div class="square">&nbsp;&nbsp;'.__J('GB').'&nbsp;&nbsp;&nbsp;</div>\';

	y.style.paddingTop = "10px";
	z.style.paddingTop = "10px";
	add_storage_list(x);

	const select = document.getElementById("bootorder"); 
	let count = (parseInt(lastRow) + 1).toString();
	let newOption = new Option("DISK"+count, "disk"+count, false, false);
	select.add(newOption);
	
};

function add_storage_bus(id, val){
	var t = $_(id);
	var lastRow = (t.rows.length);
	var x = t.insertRow(lastRow);
	var y = x.insertCell(0);
	var z = x.insertCell(1);
	var p = x.insertCell(2);
	var q = x.insertCell(3);
	var r = x.insertCell(4);
	var s = x.insertCell(5);
	var j = x.insertCell(6);
	var k = x.insertCell(7);
	
	var str1 = \'<select class="custom-select bus_driver" name="bus_driver[]" onchange="toggle_driver_num(this.value, this)" >\';';
						
	foreach($bus_driver as $bdk => $bdv){
		echo 'str1 += \'<option value="'.$bdk.'">'.$bdv.'</option>\';';
	}
							
	echo 'str1 += \'</select>\';
	

	z.innerHTML = \'&nbsp;&nbsp;&nbsp;&nbsp;&nbsp\';
	z.style.paddingTop = "10px";
	var str2 = \'<select class="custom-select bus_driver_num" name="bus_driver_num[]">\';';
	
	
	echo 'str2 += \'<option class="sata virtio scsi" value="0" >0</option>\';';
	echo 'str2 += \'<option class="sata virtio scsi" value="1" >1</option>\';';
	echo 'str2 += \'<option class="ide sata virtio scsi" value="2" >2</option>\';';
	echo 'str2 += \'<option class="ide sata virtio scsi" value="3" >3</option>\';';
	echo 'str2 += \'<option class="virtio scsi" value="4" >4</option>\';';
	echo 'str2 += \'<option class="sata virtio scsi" value="5" >5</option>\';';
	echo 'str2 += \'<option class="virtio scsi" value="6" >6</option>\';';
	echo 'str2 += \'<option class="virtio scsi" value="7" >7</option>\';';
	echo 'str2 += \'<option class="virtio scsi" value="8" >8</option>\';';
	echo 'str2 += \'<option class="virtio scsi" value="9" >9</option>\';';
	echo 'str2 += \'<option class="virtio scsi" value="10" >10</option>\';';
	echo 'str2 += \'<option class="virtio scsi" value="11" >11</option>\';';
	echo 'str2 += \'<option class="virtio scsi" value="12" >12</option>\';';
	echo 'str2 += \'<option class="virtio scsi" value="13" >13</option>\';';
	echo 'str2 += \'<option class="virtio" value="14" >14</option>\';';
	echo 'str2 += \'<option class="virtio" value="15" >15</option>\';';

	echo 'str2 += \'</select>\';
	
	var str3 = \'<span class="help-block">&nbsp;</span>\';
	
	r.innerHTML = \'<input name="size" class="form-control size" type="text" size="30" value="" />\';
	s.innerHTML = \'<span class="square">'.__J('GB').'</span>\';
	
	r.style.paddingTop = "10px";
	s.style.paddingTop = "10px";
					
	var str4 = \'<select class="custom-select storages" name="storages[]">\';';
	
	foreach($storages as $sk => $sv){
		echo 'str4 += \'<option value="'.$sv['st_uuid'].'" '.($sv['st_uuid'] == $storages[$stid]['st_uuid'] ? 'selected="selected"' : '').'>'.$sv['name'].'&nbsp;('.$sv['disk_space'].' GB '.(empty($sv['oversell']) ? __J('Free') : __J('Overcommitted Free Space')).')</option>\';';
	}
	
	echo 'str4 += \'</select>\';
	
	y.innerHTML = str1;
	y.style.paddingTop = "10px";
	p.innerHTML = str2;
	p.style.paddingTop = "10px";
	q.innerHTML = str3;
	q.style.paddingTop = "10px";
	j.innerHTML = str4;
	j.style.paddingTop = "10px";
	k.style.paddingTop = "10px";
	k.innerHTML = \'<a class="delstorage" title="'.__J('Delete this storage').'"><i class="fas fa-times text-danger cursor-pointer py-2"></i></a>\';
	toggle_driver_num($("#bus_driver option:first").val(),  $("#bus_driver"));
	storagedel();
	
};

function toggle_driver_num(driver_type, ele){
	var parent = $(ele).parent().next().next();
	parent.find(".ide, .sata, .virtio, .scsi").hide();
	parent.find("." + driver_type).show();
	parent.find("select").val(0);
	if($(ele).val() == "ide"){
		parent.find("select").val(2);
	}
	
	if(driver_type == "virtio"){
		$("#ssd_emulation").prop("checked", false);
		$(".ssd_emulation").hide();
	}else{
		$(".ssd_emulation").show();
	}

	scsi_controller();

};
//ticket controller hide/show for scsi controller also in kvm
function scsi_controller(){
	var bus_driver = new Array(); 
	bus_driver = $(".bus_driver").map(function(){
		return this.value;
	}).get();
	if(bus_driver.includes("scsi")){
		$(".scsi_controller").show();
		
	}else{
		$(".scsi_controller").hide();
		$("#scsi_controller").val("");
	}
}

function storagedel(){
	$(".delstorage").each(function(){
		$(this).unbind("click");
		$(this).click(function(){
			var parent = $(this).parent();
			var granparent = parent.parent();
			parent.remove();
			granparent.remove();
			add_bootorder();
		});
	});	
	scsi_controller();
};

function ipdel(){
	$(".delip").each(function(){
		$(this).unbind("click");
		$(this).click(function(){
			var parent = $(this).parent();
			parent.remove();
			checkippool();
		});
	});
}

$(document).ready(function(){
	progress_onload();
	ipdel();
	storagedel();
	toggle_driver_num($("#bus_driver option:first").val(), $("#bus_driver"));
	enable_vertical_scaling('.$globals['enable_ver_scaling'].');
});

cdrom_bootorder = () =>{

	const select = document.getElementById("bootorder"); 
	if(document.getElementById("iso") && !empty(select)){
		document.getElementById("iso").onchange = function() {  
			
			if(!empty(this.value) && empty(select.querySelector("option[value=\"cdrom1\"]"))){
				let newOption = new Option("CDROM"+"1", "cdrom"+"1", false, false);
				select.add(newOption);
			}
			if(empty(this.value) && !empty(select.querySelector("option[value=\"cdrom1\"]"))){
				select.removeChild(select.querySelector("option[value=\"cdrom1\"]"));
			}
		}; 
	}
	if(document.getElementById("sec_iso") && !empty(select)){
		document.getElementById("sec_iso").onchange = function() {  
			
			if(!empty(this.value) && empty(select.querySelector("option[value=\"cdrom2\"]"))){
				let newOption = new Option("CDROM"+"2", "cdrom"+"2", false, false);
				select.add(newOption);
			}
			if(empty(this.value) && !empty(select.querySelector("option[value=\"cdrom2\"]"))){
				select.removeChild(select.querySelector("option[value=\"cdrom2\"]"));
			}
		};  
	}

}

function adddnsrow(id, val){

	var t = $_(id);
	var ele = document.createElement("div");
	ele.setAttribute("class","row my-2 mx-auto w-100");
	ele.innerHTML=\'<div class="col-sm-12 p-0 d-inline-flex"><input type="text" class="form-control" name="dns[]"  value="\'+(val || "")+\'"  size="20" />&nbsp;&nbsp;<a class="deldns" ><i class="fas fa-times text-danger cursor-pointer py-2"></i></a></div>\';
	t.appendChild(ele);

	var sp = document.createElement("span");
	sp.setAttribute("class","help-block");
	t.appendChild(sp);
	del_dns_div("deldns");
};

function checkippool(){
	try{
	// Clear the Select
	while($_("iplist").options.length != 0){
		$_("iplist").remove(0);
	}
	
	vpsips = curips();
	
	for(x in ips){
		is_cur = 0;	
		for(xx in vpsips){
			if(vpsips[xx] == ips[x]){
				is_cur = 1;
			}
		}
		if(is_cur == 0){
			createOption(x, ips[x]);
		}
	}
	}catch(e){	}
};

function addtoips(){
	try{
	$("#num_ips").val("");

	for(i=0; i < $_("iplist").options.length; i++) {
		if ($_("iplist").options[i].selected) {
			addrow("iptable", ips[$_("iplist").options[i].value]);
		}
	}
	
	checkippool();
	
	// Make the Table again
	while($_("iptable").rows.length != 0){
		$_("iptable").deleteRow(0);
	}
	
	for(x in vpsips){
		addrow("iptable", vpsips[x]);
	}
	}catch(e){	}
};

function createOption(val, txt){
	var opt = document.createElement("option");
	opt.text = txt;
	opt.value = val;
	
	if(document.all && !window.opera){
		$_("iplist").add(opt);
	}else{
		$_("iplist").add(opt, null);
	}
};

function curips(){
	var vpsips = new Object();
	var cur_ips = document.getElementsByName("ips[]");
	for(i=0; i < cur_ips.length; i++){
		if(cur_ips.item(i).value != ""){
			vpsips[i] = cur_ips.item(i).value;
		}
	}
	return vpsips;
};

function planips(num){
	if(num > 0){
		try{
			for(i=0; i < num; i++) {
				$_("iplist").options[i].selected = true;
			}
		}catch(e){	}
		addtoips();
	}
};

function loadplan(planid){
	if(planid == 0){
		var uid = parseInt($_("uid").value);
		get_user_ips(uid);
		return false;
	}
	
	$("#plan_loader").show();
	var uid = $("#uid").val();
	if(AJAX("'.$globals['index'].'act=addvs&pool_uid="+uid+"&ajax=true'.(!empty($_REQUEST['virt']) ? '&virt='.optREQ('virt') : '').'&plan="+planid+"&plid="+planid, "plandetails(re)")){
		return false;
	}else{
		$("#plan_loader").hide();
		return true;	
	}
};

function plandetails(re){
	eval(re);
	var topology_enabled = cdrom_for_boot = 0;
	$("#ipv6_div").hide();
	$("#ipv6_subnet_div").hide();
	$.each($plan, function( index, value ){
		//alert(index  + " -- "+ value)
		if(index == "io") index = "priority";
		if(index == "swap") index = "swapram";
		if(index == "data"){

			if(!empty($plan["data"])){

				$.each($plan["data"], function(d_k, d_v){
					$("#addvsform").field(d_k, d_v);
					if($("#"+d_k).prop("type") == "checkbox" || $("#"+d_k).prop("type") == "radio"){
						$("#"+d_k).prop("checked", (!empty(d_v) ? 1 : 0));
					}
				});

				if(empty($plan["data"]["dont_add_ptr"])){
					$("#dont_add_ptr").prop("checked", false);
					$("#dont_add_ptr").val(0);
				}

				if(empty($plan["data"]["enable_cpu_threshold"])){
					$("#enable_cpu_threshold").prop("checked", false);
					$("#enable_cpu_threshold").val(0);
				}
				
				if(!empty($plan["dtime1"])){
					$("#dtime1").val($plan["dtime1"]);
					$("#date1").val($plan["date1"]);
					$("#demo").prop("checked", 1);
					if(!empty($plan["data"]["demo"]["action"])){
						$("#demo_suspend_action").prop("checked", true);
					}else{
						$("#demo_delete_action").prop("checked", true);
					}
				}else{
					$("#demo").prop("checked", 0);
					$("#dtime1").val("");
					$("#date1").val("");
				}

				$("#vga").val(!empty($plan["data"]["vga"]) ? $plan["data"]["vga"] : "");
				$("#vga_memory").val(!empty($plan["data"]["vga_memory"]) ? $plan["data"]["vga_memory"] : "");

				enable_vertical_scaling('.$globals['enable_ver_scaling'].');
				
				if(!empty($plan["data"]["vga_vram"])){
					enable_accel();
				}
				$("#iothread").prop("checked", !empty($plan["data"]["iothread"]) ? true : false);	
				$("#nesting").prop("checked", !empty($plan["data"]["nesting"]) ? true : false);	
				change_checkbox("ha");

				if(!empty($plan["data"]["cpu_flags"])){
				
					var cpu = $("#cpu_mode").val();
					prox_cpu_flags();
					var cpu_flag =  $plan["data"]["cpu_flags"];
					var cpu_info = '.json_encode($cpu_info).';
					var cpu_keys = '.json_encode(array_keys($cpu_info)).';
					$.each(cpu_keys, function(k, v){
						if(cpu_info[v]["cpu_mode"].includes(cpu)){
						
							var mapper = [];
							mapper[0] = "default";
							mapper[1] = "on";
							mapper[2] = "off";
							let execptions = [];
							if(!empty(cpu_info[v]["exception"])){
								$.each(cpu_info[v]["exception"], function(k,v){
									if(v in cpu_flag){
										execptions.push(v);
										$("#"+v+"-"+mapper[cpu_flag[v]]).prop(\'checked\', true);
									}
								})
							}
	
							$.each(cpu_info[v]["cpu_flags"], function(k,v){
								if(!(v in execptions)){
									$("#"+v+"-"+mapper[cpu_flag[v]]).prop(\'checked\', true);
								}
							})
					
						}
					})
				}

			}

		}
		if(index == "mgs"){
			
			var i = 0;
			var size = value.length;
			$options = $("#mg option");
			$("#mg option:selected").removeAttr("selected");
			for(i; i < size; i++){
				// filter the options with the specific value and select them
				if(value[i] != ""){
					$options.filter("[value="+value[i]+"]").prop("selected", true);
				}
			}
			
		}else if(index == "dns_nameserver" && (typeof value == "object")){
			$("#dnstable").html("");
			$.each(value, function( ind, val ){
				adddnsrow(\'dnstable\', val);
			});			
		}else if(index == "plan_ips" && (typeof value == "object")){
			$("#iplist").html("");
			ips = [];
			$.each(value, function( ind, val ){
				let row = "<option value="+ind+">"+val.ip+"</option>";
				$("#iplist").append(row);
				ips[ind] = val.ip;
			});			
		}else if(index == "internal_ips" && (typeof value == "object")){
			$("#ips_int").html("");
			ips_int = [];
			$.each(value, function( ind, val ){
				let row = "<option value="+val.ip+">"+val.ip+"</option>";
				$("#ips_int").append(row);
				ips_int[ind] = val.ip;
			});			
		}else if(index == "script"){
			check();
			if(!empty($plan["script"])){
				$("#webuzo_scriptlist").val($plan["script"]);
				webuzo_apps($plan["webuzo_stack"]);
				$("input[name=\'mysql\'][value="+$plan["mysql"]+"]").prop("checked", true);
				$("input[name=\'webuzo_os\'][value="+$plan["webuzo_os"]+"]").prop("checked", true);
				$("input[name=\'webuzo_stack\'][value="+$plan["webuzo_stack"]+"]").prop("checked", true);
				$("input[name=\'webserver\'][value="+$plan["webserver"]+"]").prop("checked", true);
				$("input[name=\'php\'][value="+$plan["php"]+"]").prop("checked", true);
			}			
		}else if(index == "bpid"){
			// Do nothing since bpid should remain as -1
		}else if(index == "fwid"){
			// From plan ONLY Admin plans can be selected for firewall
			if(!empty(value)){
				$("#admin_fwid").val(value);
				$("#admin_fwid").select2({width:"100%"});
			}
			
		}else if(index == "virtio"){
			if(value == 0){
				$("#disk_driver_none").prop(\'checked\', true);
			}else if(value == 1){
				$("#virtio").prop(\'checked\', true);
			}else if(value == 2){
				$("#scsi").prop(\'checked\', true);
			}
		}else if(index == "load_balancer" && value == 1){
			$("#load_balancer").val(-1);
		}else if(index == "control_panel"){
			$("#control_panel").val(value);
			show_webuzo(value);
		}else if(index == "recipe"){
			
			$("#recipe").val(null).trigger("change");

			// If value is not an array then convert it to array
			if(value.length == undefined){
				value = (value != 0 ? [ value ] : []);
			}
			
			value.forEach(item => { // iterate through array of items that need to be pre-selected
				let value = $("#recipe option[value="+item+"]").text(); // get items inner text
				
				// Skip recipe that is not available
				if(value == ""){					
					return;
				}
				
				$("#recipe option[value="+item+"]").remove(); // remove current item from DOM
				$("#recipe").append(new Option(value, item, true, true)); // append it, making it selected by default
			 });
			
		}else{
			var ischeckbox = 0;
			if($("#addvsform").find("[name=show_"+ index +"]").prop("type") == "checkbox"){
				ischeckbox = index;
				index = "show_"+index;
			}
			$("#addvsform").field( index, value);
			if(!empty(ischeckbox)){
				change_checkbox(ischeckbox);
			}

			if(!empty($plan["data"]["custom_cpu_model"])){
				$("#cpu_mode").val($plan["data"]["custom_cpu_model"]);
			}

			if(!empty($plan["data"]["unprivileged"])){
				$("#unprivileged").val($plan["data"]["unprivileged"]);
			}
			
			if(!empty($plan["data"]["scsi_controller"] && $plan["data"]["scsi_controller"] == "virtio-scsi-pci" )){
				$(".scsi_controller").show();
				$("#scsi_controller").val($plan["data"]["scsi_controller"]);
			}
			
			if((index == "topology_sockets" || index == "topology_cores" || index == "cpu_threads") && (!empty(value)) && (empty(topology_enabled))){
				$("#enable_cpu_topology").prop("checked", true);
				topology_enabled = 1;
			}
		}

		if(index == "iso"){
			$("#iso").trigger("change"); // trigger onchange so that we can add bootorder
			cdrom_for_boot = 1;
		}
		
		if(index == "sec_iso"){
			$("#sec_iso").trigger("change");
			cdrom_for_boot = 1;
		}		
	});
	
	if(cdrom_for_boot){
		add_bootorder(1);
	}

	$_("hdd_0").value = $plan["space"];';
	
	if(!empty($bus_driver)){
		echo '
		$_("bus_driver").value = $plan["bus_driver"];
		$_("bus_driver_num").value = $plan["bus_driver_num"];';
	}
	
	echo 'ipchoose("ips_int", $plan["ips_int"]);
	
	try{
		var currentIPs = curips();		
		var i;
		var num_ips = 0;
		for (i in currentIPs) {
			if (currentIPs.hasOwnProperty(i)) {
				num_ips++;
			}
		}
	
		if(num_ips < $plan["ips"]){		
			var diff = $plan["ips"] - num_ips;
			planips(diff);
		}

		if($("#ipv6count").length > 0){
			$("#ipv6_div").show();
			$_("ipv6count").value = $plan["ips6"];
		}

		if($("#ipv6subnetcount").length > 0){
			$("#ipv6_subnet_div").show();
			$_("ipv6subnetcount").value = $plan["ips6_subnet"];
		}

		if(document.getElementsByName("ips_int[]").length < $plan["ips_int"]){
			multiselect("ips_int[]", $plan["ips_int"]);
		}
		
	}catch(e){
		// Nothing to do here
	}
	
	$(".virt-select, .chosen").select2({width:"100%"});
	ishvm();
	checkvnc();
	checkdemo();
	change_cpu_topology();
	handle_capping();
	$("#plan_loader").hide();
	if(!empty($plan["bus_driver"])){
		toggle_driver_num($plan["bus_driver"], $("#bus_driver"))
	}
	checkcputhreshold();
	handle_ssh_settings();
	toggle_bios();
};

function loadiso(uid){
	
	if(uid == 0){
		return false;
	}
	
	if(AJAX("'.$globals['index'].'act=addvs&ajax=true&uid="+uid, "isodetails(re)")){
		return false;
	}else{
		return true;
	}	
};

// Fill iso where it is needed
function isodetails(re){
	$("#iso,#sec_iso").empty().html(re);
};

function changepriority(priority){
	
	if(!$("#prior")){
		return false;
	}
	
	if (priority != ""){
		$("#prior").val(priority);
	}
};

function adduser(){
	var uid = parseInt($_("uid").value);
	
	if(uid < 1){
		$("#user_details_f").show();
		$(".user_details").show();
	}else{
		$(".user_details").hide();
		$("#user_details_f").hide();
	}

	get_user_ips(uid);
	loadiso(uid);
	get_ssh_keys(uid);
	check_user_billing(uid);
}

function get_user_lb(){
	var uid = parseInt($_("uid").value);
	$("#load_balancer_card").show();
	$("#ajax_user_loader").show()
	$.ajax({
		url: "'.$globals['index'].'&act=load_balancer&search=1&uid="+uid+"&sgid='.$servers[$globals['server']]['sgid'].'&check_user_billing=1&api=json",
		dataType : "json",
		method : "post",
		success:function(data){
			$("#ajax_user_loader").hide();
			if("load_balancer" in data){
				var options = `<option value="0">'.__J('None').'</option>
				<option value="-1">'.__J('Create as Load Balancer').'</option>`;
				if(!empty(data["load_balancer"])){
					$.each(data["load_balancer"], function(k, v){
						options += "<option value=\'"+k+"\'>"+v["vpsid"]+" - "+v["hostname"]+"</option>";
					});
				}
				$("#load_balancer").html(options);
			}
			if("no_billing_user" in data){
				$("#load_balancer_card").hide();
			}
		}
	});
}

function check_user_billing(uid){
	$("#ajax_user_loader").show()
	$.ajax({
		url: "'.$globals['index'].'&act=users&check_user_billing="+uid+"&api=json",
		dataType : "json",
		method : "post",
		success:function(data){
			$("#ajax_user_loader").hide()
			if(!empty(data["has_billing_enabled"])){
				$("#vertical_scaling_settings").css("display", "flex");
			}else{
				$("#vertical_scaling_settings").css("display", "none");
			}
		}
	});
}

function get_user_ips(uid){
	var plid = $("#plid").val();
	if(plid > 0){
		loadplan(plid)
	}else{
		$("#ajax_user_loader").show();
		$.ajax({
			type: "POST",
			url: "'.$globals['index'].'act=addvs&get_user_ips=1&api=json&uid="+uid+"'.(!empty((int) optREQ('ippoolid')) ? '&ippoolid='.(int) optREQ('ippoolid') : '').'",
			dataType : "json",
			success:function(data){
				$("#ajax_user_loader").hide();
				remove_all_ips()
				$("#iplist").html("");
				$("#ips_int").html("");
				$("#ipv6_div").hide();
				$("#ipv6_subnet_div").hide();
				if(!empty(data["ips"])){
					ips = [];
					$.each(data["ips"], function( ind, val ){
						let row = "<option value="+ind+">"+val.ip+"</option>";
						$("#iplist").append(row);
						ips[ind] = val.ip;
					});	
				}
				
				if(!empty(data["ips_int"])){
					ips_int = [];
					$.each(data["ips_int"], function( ind, val ){
						let row = "<option value="+val.ip+">"+val.ip+"</option>";
						$("#ips_int").append(row);
						ips_int[ind] = val.ip;
					});
				}
				
				if(!empty(data["ips6"])){
					$("#ipv6_div").show();
				}
				if(!empty(data["ips6_subnet"])){
					$("#ipv6_subnet_div").show();
				}
			}
		});
	}
}

function get_ssh_keys(uid){
	$("#ajax_user_loader").show()
	$.ajax({
		type: "POST",
		url: "'.$globals['index'].'act=users&list_ssh_keys=1&api=json&uid="+uid,
		dataType : "json",
		success:function(data){
			$("#ajax_user_loader").hide()
			if(!empty(data["ssh_keys"])){
				let html = `<select name="existing_key[]" class="custom-select virt-select" data-placeholder="'.__J('Select SSH keys').'" multiple>`;
				$.each(data["ssh_keys"], function(k, v){
					html += `<option value="`+v["value"]+`">`+v["name"]+`</option>`;
				})
				html += `</select>`
				$("#existing_keys_div").html(html);
				$(".virt-select").select2({width:"100%"});
			}else{
				$("#existing_keys_div").html(`<div class="col-sm-12 p-0">'.__J('No SSH keys found!').'</div>`);
			}
		}
	});
}

function checkvnc(){
	if(!$("#vnc")){
		return false;
	}
	if(is_checked("vnc")){
		$("#vncpassrow").show();
	}else{
		$("#vncpassrow").hide();
	}
	change_checkbox("vnc");	
};

function checkdemo(){
	if(!$("#demo")){
		return false;
	}
	if(is_checked("demo")){
		$("#demotime").show();
		$("#demodate").show();
		$("#demo_action_options").show();
	}else{
		$("#demotime").hide();
		$("#demodate").hide();
		$("#demo_action_options").hide();
	}
	change_checkbox("demo");	
};

function pincheck(){
	if(!$("#allcores")){
		return false;
	}
	
	if(is_checked("allcores")){';
		for($i=0; $i < $resources['cpucores']; $i++){
			echo '$_("pin'.$i.'").checked = 0;';
		}
		echo '$("#pincores").hide();
	}else{
		$("#pincores").show();
	}
};

function addvbutton(){
	
	if($_("macaddress").style.display == "none"){
		$_("macaddress").style.display = ""; 
		$_("addv_opt_label").innerHTML = "'.__J('Hide Advance option').'";
		$_("addv_opt_button").value = "'.__J('Hide Advance option').'";     
	} else {
		$_("macaddress").style.display = "none";
		$_("addv_opt_label").innerHTML = "'.__J('Advanced Options').'";  
		$_("addv_opt_button").value = "'.__J('Advanced Options').'";  	    
	}
}

function toggle_advoptions(ele){
	
	var div_ele = $("#"+ele+"_advoptions");

	if (div_ele.is(":hidden")){
		$("#"+ele+"_advoptions_ind").text(" - ");
		div_ele.slideDown("slow");
	}
	else{
		$("#"+ele+"_advoptions_ind").text(" + ");
		div_ele.slideUp("slow");
	}
}

function plus_onmouseover(){
	$("#plus").attr("src", "'.$theme['images'].'admin/plus_hover.gif");
}

function plus_onmouseout(){
	$("#plus").attr("src", "'.$theme['images'].'admin/plus.gif");
}

function remove_all_ips(){
	$(".delip").each(function(){
		var parent = $(this).parent().parent();
		parent.remove();
		checkippool();
	});
}

function enable_accel(){
	
	if($_("kvm_vga").checked == true){
		$_("set_vga_vram").style.display = "";
		$_("enable_acceleration").style.display = "";	
	}else{
		$_("set_vga_vram").style.display = "none";
		$_("enable_acceleration").style.display = "none";
	}
	
	change_checkbox("kvm_vga");
}


function ishvm(){
	
	var hvm = false;
	if(!$_("hvm")){
		hvm = false;
	}else{
		hvm = $_("hvm").checked;
	}
	
	if($_("isorow")){
		if(hvm == true || virt == "kvm" || virt == "vzk" || virt == "proxk"){
			$_("isorow").style.display = "";
		}else{
			$_("isorow").style.display = "none";
		}
	}
	
	if($_("enable_rdp")){
		if(hvm == true || virt == "kvm" || virt == "vzk" || virt == "proxk"){
			$_("enable_rdp").style.display = "";
		}else{
			$_("enable_rdp").style.display = "none";
		}		
	}
	
	if($("#add_storage_btn")){
		if(hvm == true || virt == "kvm" || virt == "proxk" || virt == "vzk"){
			$("#add_storage_btn").show();
		}else{
			$("#add_storage_btn").hide();
		}
	}
	
	if($_("shadowrow")){
		if(hvm == true){
			$_("shadowrow").style.display = "";
		}else{
			$_("shadowrow").style.display = "none";
		}
	}
		
	if($_("osid")){
		
		var sid = $("#sid").val() || 0;
		
		for(var i=0; i<$_("osid").options.length; i++){

			if(getAttributeByName($_("osid").options[i], "hvm") == 1 && hvm == true){
				if(sid > 0 && getAttributeByName($_("osid").options[i], "distro") != "webuzo"){
					$_("osid").options[i].disabled = true;
				}else{
					$_("osid").options[i].disabled = false;	
				}
			}else if(getAttributeByName($_("osid").options[i], "hvm") != 1 && hvm == false){
				if(sid > 0 && getAttributeByName($_("osid").options[i], "distro") != "webuzo"){
					$_("osid").options[i].disabled = true;
				}else{
					$_("osid").options[i].disabled = false;	
				}
			}else{
				$_("osid").options[i].disabled = true;
			}
		}
	}
	
	// if there is webuzo templates available in advance section
	if($(\'input[name="webuzo_os"]\')){
		
		$(\'input[name="webuzo_os"]\').each(function(){
			if(hvm == true && $(this).attr("hvm") == 1){
				$(this).removeAttr("disabled");
			}else if(hvm == false && $(this).attr("hvm") != 1){
				$(this).removeAttr("disabled");
			}else{
				$(this).attr("disabled", "true")
			}
		})
	}
	
	if($_("mg")){
		
		$("#mg option").each(function() {
			if(hvm){
				if($(this).attr("type").indexOf("hvm") > 0){
					$(this).css("display", "");
				}else{
					$(this).css("display", "none");
				}
			}else{
				if($(this).attr("type").indexOf("hvm") == -1){
					$(this).css("display", "");
				}else{
					$(this).css("display", "none");
				}
			}
		});
	}
	
	change_checkbox("hvm");
	
	$(".virt-select").select2({width:"100%"});
	$("#recipe").select2({
		placeholder : "",
		allowClear: true
	});
	$("#recipe").on("select2:select", function(e){
		var id = e.params.data.id;
		var option = $(e.target).children("[value="+id+"]");
		option.detach();
		$(e.target).append(option).change();
	});
	
	if($("#pci").length){
		$("#pci").select2({
			placeholder : "",
			allowClear: true
		});
	
		$("#pci").on("select2:select", function(e){
			var id = e.params.data.id;
			var option = $(e.target).children("[value="+id+"]");
			option.detach();
			$(e.target).append(option).change();
		});
	}
	
	if($("#usb").length){
		$("#usb").select2({
			placeholder : "",
			allowClear: true
		});
	
		$("#usb").on("select2:select", function(e){
			var id = e.params.data.id;
			var option = $(e.target).children("[value="+id+"]");
			option.detach();
			$(e.target).append(option).change();
		});
	}
	
	return true;
};

function ispvonhvm(){
	
	var pv_on_hvm = false;
	if(!$_("pv_on_hvm")){
		pv_on_hvm = false;
	}else{
		pv_on_hvm = $_("pv_on_hvm").checked;
	}
	
	if($_("tr_viftype")){
		if(pv_on_hvm == true){
			$_("tr_viftype").style.display = "none";
		}else{
			$_("tr_viftype").style.display = "";
		}
	}
	change_checkbox("pv_on_hvm");
	return true;
};


function loadvirt(virt){

	window.location = "'.$globals['index'].'act=addvs&virt="+virt;
	
}

function adv_ip_toggle(ele){

	$(ele).prev("span").html(function(e, old_text){
		if($(this).find("i").hasClass("fa-plus")){
			$(this).html("<i class=\"fas fa-minus text-dark\"></i>");
		}else{
			$(this).html("<i class=\"fas fa-plus text-dark\"></i>");
		}
	});
	$("#adv_ip").slideToggle(function(k,v){
		if($(this).css("display") == "none"){
			if(!empty($("#num_ips").val())){
				$(".delip").each(function(){
					//var parent = $(this).parent();
					var prev_ele = $(this).prev();
					prev_ele.val("");
					checkippool();
				});
			}
		}
	});
};

$(document).ready(function(){
	$("#num_ips").keyup(function(){
		if(!empty($("#num_ips").val())){
			$(".delip").each(function(){
				//var parent = $(this).parent();
				var prev_ele = $(this).prev();
				prev_ele.val("");
				checkippool();
			});
		}
	});
	
	load_ajax_user("uid", "'.$globals['index'].'act=addvs&api=json&load_ajax_user=1'.(!empty($_REQUEST['load_balancer']) ? "&load_balancer=1":"").'");
});

var lang = Array();
lang["bad"] = "'.__J('Bad').'";
lang["good"] = "'.__J('Good').'";
lang["strong"] = "'.__J('Strong').'";
lang["short"] = "'.__J('Short').'";
lang["strength_indicator"] = "'.__J('Strength Indicator').'";

function change_cpu_topology(){
	
	if($("#enable_cpu_topology").prop("checked")){
		$("#cpu_topology").css("display", "");
	}else{
		$("#cpu_topology").css("display", "none");
		$("#topology_sockets").val(0);
		$("#topology_cores").val(0);
		$("#topology_threads").val(0);
	}
}

let add_ssh_event = 0;
function handle_ssh_settings(){
	$(".ssh_options").prop("checked", false);
	$("#add_ssh_keys_div").hide();
	$("#use_ssh_keys_div").hide();

	$(".ssh_options").unbind().on("change", function(){
		$("#add_ssh_keys_div").hide();
		$("#use_ssh_keys_div").hide();
		$("#download_private").hide();
		$("#new_key_loader").hide();
		$("#sshkey, #private_key").val("");
		$("#sshkey").removeAttr("readonly");
		$("#private_key_link").attr("href", "");

		$("#"+$(this).attr("value")+"_div").show();

		if($(this).attr("value") == "add_ssh_keys"){
			add_ssh_event = 1;
		}

		if($(this).attr("value") == "generate_keys"){
			$("#new_key_loader").show();
			$("#add_ssh_keys_div").show();
			add_ssh_event = 0
			$.ajax({
				type: "POST",
				url: "'.$globals['index'].'act=addvs&generate_keys=1&api=json",
				dataType : "json",
				success:function(data){
					if(!empty(data["new_keys"]) && empty(add_ssh_event)){
						$("#new_key_loader").hide();
						$("#download_private").show();
						$("#private_key_link").attr("href", "data:attachment/text," + encodeURI(data["new_keys"]["private_key"]))
						$("#private_key_link").attr("download", "private_key")
						$("#private_key_link")[0].click()
						$("#sshkey").val(data["new_keys"]["public_key"])
						$("#private_key").val(data["new_keys"]["private_key"])
						$("#sshkey").attr("readonly", "readonly")
					}
				}
			});
		}
	})
}

var lang_no_limit = "'.__J('No Restriction').'";

function checkcputhreshold(){

	if($("#enable_cpu_threshold").prop("checked")){
		$("#cputhresholdpercentage").css("display", "");
		$("#enable_cpu_threshold").val(1);
	}else{
		$("#cputhresholdpercentage").css("display", "none");
		$("#cpu_threshold").val(0);
		$("#cpu_threshold_time").val(0);
	}
	change_checkbox("enable_cpu_threshold");
};

addonload("handle_capping(); fillspeedkBps(); planips(0); checkippool(); adduser(); changepriority(\''.POSTval('priority', 3).'\'); checkvnc(); ishvm(); pincheck(); check_pass_strength(\'rootpass\');change_cpu_topology();toggle_bios();prox_cpu_flags();cdrom_bootorder();checkdemo();checkcputhreshold();");



</script>';

// Is it loaded into the correct kernel
if(strlen($resources['check_kernel']) > 1){
	//show_alert($resources['check_kernel'],"1");
	echo'<div class="e_notice mx-3 mb-3">'.$resources['check_kernel'].'</div>';
}

if(empty($loop_device)){
	echo '<div class="e_notice mx-3 mb-3">'.__('There is no free loop device available on the server. Hence VPS creation on file based storage may fail. Please free up some loop device to create VPS.').'</div>';
}

echo '
<div id="form-container" class="container-fluid p-0">
<form id="addvsform"  accept-charset="'.$globals['charset'].'" action="" method="post" name="addvs" class="form-horizontal">
<div class="roundheader cursor-pointer mx-3 px-4" onclick="toggle_advoptions(\'general\')"><label id="general_advoptions_ind" class="min_width">-</label> '.__('Basic Settings').'
	</div>
<div id="general_advoptions" >
<div class="row mx-auto w-100 my-2">
	<div class="col-sm-12 col-md-6 col-lg-6 mt-n2 ">
		<div class="divroundshad" >
			<div class="card p-3 my-3">
				<div class="row mx-auto w-100 mb-3 mt-2">
					<div class="col-sm-12 p-0">
					<label class="form-label">'.__('Server').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Select the server on which you want to create the VPS').'"><i class="fas text-primary fa-info-circle"></i></a></label><br><select id="server-select" class="server-select form-select">';
						
					foreach($servers as $k => $v) {
						if(($v['serid'] == 0) && !empty($globals['is_master_only'])){
							$v['virt'] = 'msonly';
						}
						echo '<option value="'.$k.'" '.($k == $globals['server'] ? 'selected' : '').' data-icon-ram="fa-memory" data-ram-text="'.(empty($v['overcommit']) ? $v['ram'] : ($v['overcommit'] - $v['alloc_ram'])).'" data-icon-disk="fa-hdd" data-disk-text="'.$v['space'].'" data-virt="'.$v['virt'].'">'.$v['server_name'].' ('.$v['ip'].')'.($v['locked'] == 0 ? '' : ' (Locked)').'</option>';
					}
					echo '</select>
					</div>
					';
					if(count($servers[$globals['server']]['virts']) > 1){
						echo '<div class="col-sm-12 p-0 mt-3">
						<label class="form-label">'.__('Select Virtualization').'<a class="info" data-placement="right" tooltip="'.__('The Virtualizationn technology of the VPS to be created.').'"><i class="fas text-primary fa-info-circle"></i></a></label><select class="custom-select" name="virt" onchange="loadvirt(this.value)">';
							foreach($servers[$globals['server']]['virts'] as $k => $v){		 
								echo '<option value="'.$v.'" '.(REQval('virt') == $v ? 'selected="selected"' : '').'>'.$globals['virt_names'][$v].'</option>';
							}
							
							echo '</select>
							</div>';	
							}
						echo'
				</div>
			</div>
			<div class="card p-3 my-3">
				<div class="row mx-auto w-100 my-3 ">
					<div class="col-sm-12 p-0 server-select-lg">
						<div class="d-flex align-items-center">
							<label class="form-label">'.__('User').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Select an existing user OR add a user').'"><i class="fas text-primary fa-info-circle"></i></a></label>
							<div class="loader ml-2" style="display:none;" id="ajax_user_loader"></div>
						</div>
						<select class="custom-select virt-select" name="uid" id="uid" onchange="adduser();get_user_lb();">
							<option value="0" '.(POSTval('uid') == 0 ? 'selected="selected"' : '').'>'.__('Add User').'</option>';	
							foreach($users as $k => $v){	
								$parent = !empty($users[$v['pid']]['email']) ? "(".$users[$v['pid']]['email'].")" : "";	 
								echo '<option value="'.$k.'" '.(POSTval('uid') == $k ? 'selected="selected"' : '').'>'.$v['uid'].' - '.$v['email'].' '.$parent.'</option>';
							}
					
						echo'</select>
					</div>
				</div>
				<div class="row mx-auto w-100 my-3" id="user_details_f">
					<div class="col-sm-12 p-0">
						<fieldset class="user_details_f">
							<legend class="user_details_f mb-0">'.__('User details').'</legend>
							<div class="row mx-auto w-100 my-2 user_details" style="display:none">
								<div class="col-sm-12 p-0">
									<label class="form-label">'.__('User Email').'</label><br>
									<input type="text" class="form-control" name="user_email" size="30" value="'.POSTval('user_email', '').'" />
								</div>
							</div>
							<div class="row mx-auto w-100 my-3 user_details" style="display:none">
								<div class="col-sm-12 p-0">
									<label class="form-label">'.__('Password').'</label><br>
									<div class="input-group ">
									<input type="text" class="form-control" name="user_pass" size="30" value="'.POSTval('user_pass', '').'" id="rand_user_pass" autocomplete="off"/>
									<div class="input-group-append">
										<a href="javascript: void(0);" class="btn-primary rounded-right" onclick="$_(\'rand_user_pass\').value=rand_pass(12);check_pass_strength(\'rand_user_pass\');return false;" title="'.__('Make another Random Password').'"><i class="fas fa-key p-2"></i></a>
									</div>
									</div>
								</div>
							</div>
							
							<div class="row mx-auto w-100 my-3 user_details" style="display:none">
								<div class="col-sm-12 p-0">
									<label class="form-label">'.__('First Name').'</label><br><input type="text" class="form-control" name="fname" size="30" value="'.POSTval('fname', '').'" />
								</div>
							</div>
							<div class="row mx-auto w-100 my-3 user_details" style="display:none">
								<div class="col-sm-12 p-0">
									<label class="form-label">'.__('Last Name').'</label><br>
									<input type="text" class="form-control" name="lname" size="30" value="'.POSTval('lname', '').'" />
								</div>
								<div class="col-sm-1"></div>
							</div>
						</fieldset>
					</div>
				</div>
			</div>
			
			<div class="card my-3 p-3">
				<fieldset class="user_details_f">
					<legend class="user_details_f mb-0">'.__('General Settings').'</legend>
					<div class="row mx-auto w-100 my-3 ">
						<div class="col-sm-12 p-0">
						<div class="d-flex align-items-center">
							<label class="form-label">'.__('Select Plan').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Select a pre-defined plan').'"><i class="fas text-primary fa-info-circle"></i></a></label>
							<div class="loader ml-2" style="display:none;" id="plan_loader"></div>
						</div>
						<select class="custom-select virt-select" name="plid" onchange="loadplan(this.value)" id="plid">';
						foreach($plans as $k => $v){
							
							if(str_replace('hvm', '', $v['virt']) != $virt && !empty($k)) continue;
							
							echo '<option value="'.$k.'" '.(POSTval('plid') == $k ? 'selected="selected"' : '').'>'.$v['plan_name'].'</option>';
						}
						echo'</select>
						</div>
					</div>';
					if(($virt == 'xen' || $virt == 'xcp') && !empty($hvm)){
						echo '
						<div class="row mx-auto w-100 my-3 ">
							<div class="col-sm-12 p-0">
								<div class="row w-100">
									<div class="col-3">
										<label class="form-label" >'.__('Xen HVM').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Do you want to enable full virtualization for this VPS ?').'"><i class="fas text-primary fa-info-circle"></i></a></label>
									</div>
									<div class="col-2">
										'.get_checkbox('show_hvm', '', 'hvm', array('chk_it' => 1, 'name' => 'hvm'), 1, '', array('onchange="ishvm()"')).'
										<input type="hidden" name="hvm" id="hidden_hvm">
									</div>
								</div>
							</div>
						</div>';
					}
					echo'
					<div class="row mx-auto w-100 my-3 ">
						<div class="col-sm-12 p-0">
						<label class="form-label">'.__('Operating System').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Select the Operating System for the VPS').'"><i class="fas text-primary fa-info-circle"></i></a></label><br>
						<select class="custom-select virt-select" name="osid" id="osid" onchange="changevif();">
						'.'<option value="0" '.(POSTval('osid') == 0 ? 'selected="selected"' : '').'>'.__('None').'</option>';
						
						if(!empty($ostemplates)){
							foreach($ostemplates as $k => $v){
								if($v['type'] == $virt){
									echo '<option value="'.$k.'" '.(POSTval('osid') == $k ? 'selected="selected"' : '').' '.(!empty($v['hvm']) ? 'hvm="1"' : '').' distro="'.$v['distro'].'">'.(!empty($v['hvm']) ? 'HVM - ' : '').''.$v['name'].is_custom_os($k).'</option>';
								}
							}
						}
				
						echo'</select>
						</div>
					</div>
					';
					if(!empty($isos)){
							echo '
					<div class="row mx-auto w-100 my-3 " id="isorow">
						<div class="col-sm-12 p-0" >
							<label class="form-label">'.__('ISO').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If an ISO is selected the machine will be booted from that ISO').'"><i class="fas text-primary fa-info-circle"></i></a></label><br>
							<select class="form-select chosen" name="iso" id="iso">
							<option value="0" '.(POSTval('iso') == 0 ? 'selected="selected"' : '').'>'.__('None').'</option>
							<optgroup label="'.__('Admin ISOs').'">';
							foreach($isos as $k => $v){
								echo '<option value="'.$k.'" '.(POSTval('iso') == $k ? 'selected="selected"' : '').'>'.$v['name'].'</option>';
							}
								
							echo'</optgroup></select>
						</div>
					</div>';
							}
							echo'
						
					<div class="row mx-auto w-100 my-3 ">
						<div class="col-sm-12 p-0">
							<label class="form-label">'.__('Hostname').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Enter the hostname for the VPS. e.g. www.domain.com').'"><i class="fas text-primary fa-info-circle"></i></a></label><br>
							<input type="text" class="form-control" name="hostname" id="hostname" size="30" value="'.POSTval('hostname', '').'" />
						</div>
					</div>	
					<div class="row mx-auto w-100 my-3 ">
						<div class="col-sm-12 p-0">
							<label class="form-label">'.__('VPS Root Password').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('The Password of the Root User / Administrator of the VPS').'"><i class="fas text-primary fa-info-circle"></i></a></label>
							<div class="input-group ">
								<input type="text" class="form-control" name="rootpass" id="rootpass" size="30" onkeyup="check_pass_strength(\'rootpass\');" value="'.POSTval('rootpass', generateRandPwd(12)).'" autocomplete="off" />
							<div class="input-group-append">
								<div id="rootpass_pass-strength-result" class="w-auto strong d-flex align-items-center">'.__('Strength Indicator').'</div>
									<a href="javascript: void(0);" class="btn blue_btn py-0 px-1 rounded-right"  onclick="$_(\'rootpass\').value=randstr(12, 1, '.(!empty($globals['pass_strength']) ? $globals['pass_strength'] : 0).');check_pass_strength(\'rootpass\');return false;" title="'.__('Make another Random Password').'"><i class="fas fa-key p-2"></i></a>
								</div>
							</div>	
						</div>
					</div>	';	
					if($kernel->features('vnc_support', $virt)){

						$vncpasslen = $kernel->features('vncpasslen', $virt);

						echo '
						<div class="row mx-auto w-100 my-3 ">
							<div class="col-sm-3 p-0">
								<div class="row mx-auto w-100">
									<div class="col-4 p-0 hide_for_plan d-flex align-items-center">
									<label class="form-label">VNC</label>
									</div>
									<div class="col-1 p-0">
										'.get_checkbox('show_vnc', '', 'vnc', array('chk_it' => 1, 'name' => 'vnc'), 1, '', array('onchange="checkvnc();"')).'
									<input type="hidden" name="vnc" id="hidden_vnc">
									</div>	
								</div>
							</div>
							<div class="col-sm-9 p-0">
								<div id="vncpassrow" class="hide_for_plan">
								<label class="form-label">'.__('VNC Password').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('The VNC Password for the VPS. Click on the icon to generate a new random password').'"><i class="fas text-primary fa-info-circle"></i></a></label><br>
								<div class="input-group ">
								<input type="text" class="form-control" name="vncpass" id="vncpass" size="30" value="'.POSTval('vncpass', generateRandStr($vncpasslen)).'" autocomplete="off"/>
								<div class="input-group-append">
									<span class="pl-1"><a href="javascript: void(0);" onclick="$_(\'vncpass\').value=randstr('.$vncpasslen.');return false;" title="'.__('VNC Password').'"><i class="fas pt-2 fa-key"></i></a></span>
								</div>
								</div>
							</div>
						</div>
						
						</div>';

						}
							
						echo '
						<div class="row mx-auto w-100 my-3 ">
							<div class="col-sm-4 p-0 pt-1 pr-2 pl-0 ">
								<div class="row mx-auto w-100">
									<div class="col-8 p-0 hide_for_plan d-flex align-items-center">
										<label class="form-label">'.__('Enable Demo').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Enter date and time for demo').'"><i class="fas text-primary fa-info-circle"></i></a></label>
									</div>	
									<div class="col-4 p-0">
										'.get_checkbox('show_demo', '', 'demo', array('chk_it' => 1, 'name' => 'demo'), 1, '', array('onchange="checkdemo();"')).'
										<input type="hidden" name="demo" id="hidden_demo">
									</div>
								</div>
							</div>
							<div id="demotime" class="col-sm-4 p-1">
								<label class="form-label">'.__('Demo expiry time').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Add time for demo expiry').'"><i class="fas text-primary fa-info-circle"></i></a></label><br>
								<div class="input-group">
									<input type="text" class="form-control" placeholder="HH:MM:SS" name="demo_time" id="dtime1" size="30" value="'.POSTval('demo_time', '').'"  />
										<span class="input-group-text"><a class="text-white" onclick="get_demo_time(\'dtime1\', \'H:i:s\');" value="'.__('Now').'"/><i class="fas fa-clock"></i></a></span>
								</div>	
							</div>
							<div id="demodate" class="col-sm-4 p-1">
								<label class="form-label">'.__('Demo expiry date').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Add date for demo expiry').'"><i class="fas text-primary fa-info-circle"></i></a></label><br>
								 <div class="input-group ">
									<input type="text" class="form-control" placeholder="DD/MM/YYYY" name="demo_date" id="date1" size="30" value="'.POSTval('demo_date', '').'"  /> 
										<span class="input-group-text"><a class="text-white" onclick="get_demo_time(\'date1\', \'d/m/Y\');" /><i class="fas fa-calendar-week"></i></a></span>
								</div>	
							</div>
						</div>
						<div class="row mx-auto w-100 my-3" id="demo_action_options">
							<div class="col-sm-3 p-1">
								<label class="form-label">'.__('Demo Action').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Action to be taken once the Demo period is expired').'"><i class="fas text-primary fa-info-circle"></i></a></label>
							</div>
							<div class="col-sm-4 p-1">
								<label class="custom-control custom-radio">
									<input type="radio" class="form-check-input" name="demo_action" value="0" id="demo_delete_action" '.POSTradio('demo_action', "0").'>
									<span class="custom-form-label" for="demo_delete_action">'.__('VPS will be deleted').'</span>
								</label>
							</div>
							<div class="col-sm-5 p-1">
								<label class="custom-control custom-radio ">
									<input type="radio" class="form-check-input" name="demo_action" value="1" id="demo_suspend_action" '.POSTradio('demo_action', "1").'>
									<span class="custom-form-label" for="demo_suspend_action">'.__('VPS will be suspended').'</span>
								</label>
							</div>
						</div>';

						if(!empty($globals['add_ptr_record'])){

							echo '<div class="row mx-auto w-100 my-3 ">
									<div class="col-sm-5 p-0">
										<div class="row mx-auto w-100">
											<div class="col-11 p-0 d-flex align-items-center">
											<label class="form-label">'.__('Do not Add PTR Record').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If Auto Add PTR record setting is enabled in Master settings, PTR record for the VPS will not be added').'"><i class="fas text-primary fa-info-circle"></i></a></label><br />
											</div>
											<div class="col-1 p-0">
												'.get_checkbox('show_dont_add_ptr', '', 'dont_add_ptr', array('chk_it' => 1, 'name' => 'dont_add_ptr'), 1, '', array('onchange="change_checkbox(\'dont_add_ptr\');"')).'
												<input type="hidden" name="dont_add_ptr" id="hidden_dont_add_ptr">
											</div>	
										</div>
									</div>
								</div>';
						}

						// If enduser provisioning is enabled then we will need to show a setting so that Admin can overrdide this setting and create VM as old fashion
						if(!empty($globals['enable_vm_setup_wizard'])){

							echo '<div class="row mx-auto w-100 my-3 ">
									<div class="col-sm-5 p-0">
										<div class="row mx-auto w-100">
											<div class="col-11 p-0 d-flex align-items-center">
											<label class="control-label">'.__('Setup VPS from admin panel').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If enabled, then VPS will be created from admin panel and user will not be able to setup from enduser').'"><i class="fas text-primary fa-info-circle"></i></a></label><br />
											</div>
											<div class="col-1 p-0">
												'.get_checkbox('show_disable_setup_wizard', '', 'disable_setup_wizard', array('chk_it' => 1, 'name' => 'disable_setup_wizard'), 1, '', array('onchange="change_checkbox(\'disable_setup_wizard\');"')).'
												<input type="hidden" name="disable_setup_wizard" id="hidden_disable_setup_wizard">
											</div>	
										</div>
									</div>
								</div>';
						}

						if($kernel->features('ha', $virt) && array_key_exists($globals['server'], $ha_enabled)){
							echo '<div class="row mx-auto w-100 my-3">
									<div class="col-4 p-0">
										<label class="form-label">'.__('High Availability').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Turn on high availability for the VPS as configured in the server group').'"><i class="fas text-primary fa-info-circle"></i></a></label>
									</div>
									<div class="col-4 p-0">
										'.get_checkbox('show_ha', '', 'ha', array('chk_it' => 1, 'val' => 1, 'name' => 'ha'), 1, '', array('onchange="change_checkbox(\'ha\');"')).'
										<input type="hidden" name="ha" id="hidden_ha" value="1">
									</div>
							</div>';
						}echo '
					
				</div>
			</fieldset>
		</div>

		<div class="card p-3 my-3">
			<div class="divroundshad">
				<fieldset class="user_details_f">
					<legend class="user_details_f mb-0">'.__('Network').'</legend>
					<div class="row mx-auto w-100 mb-0 mt-1">
						<div class="col-sm-12 p-0">
							<label class="form-label">'.__('IP Address').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('You can specify number of IPs to assign').'"><i class="fas text-primary fa-info-circle"></i></a></label><br>
							<input type="number" class="form-control" name="num_ips" size="30" value="'.POSTval('num_ips', '').'" id="num_ips"/>
							<div class=" w-100 mt-3 py-1 px-0"><span class="min_width pr-1"><i class="fas fa-minus text-dark"></i></span><label class="cursor-pointer" onclick="adv_ip_toggle(this)">'.__('Advanced Options').'</label>
								<div class="row w-100 my-3 mx-auto" id="adv_ip">
									<div class="col-sm-6 p-0">
										<label class="form-label mb-2">'.__('IP Address').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('You can choose from the IP Pool or specify other IPs').'"><i class="fas text-primary fa-info-circle"></i></a></label>
										<table border="0" cellpadding="0" cellspacing="0" class="shadow-none" width="100%">
										<tr>
											<td valign="top">
												<div class="ips_scroll mr-2">
												<table cellpadding="3" class="w-100 shadow-none" cellspacing="0" id="iptable">';
										
												$_ips = @$_POST['ips'];
												
												if(is_array($_ips) && !empty($_ips)){
													foreach($_ips as $k => $ip){
														if(empty($ip)){
															unset($_ips[$k]);
														}
													}
												}
												
												if(empty($_ips)){
													$_ips = array(NULL);
												}
											
												foreach($_ips as $ip){
													echo '<tr>
														<td>
															<input type="text" class="form-control float-left w-90" name="ips[]" value="'.$ip.'" onblur="checkippool();" size="20" />
															<a class="delip" title="'.__('Remove this IP').'"><i class="fas fa-times text-danger cursor-pointer py-2"></i></a>
															
														</td>
													</tr>';
												}
												
											echo '</table>
												</div>
												<a class="btn blue_btn py-1 px-2 mt-2"onclick="javascript:addrow(\'iptable\');">'.__('Add IP').'</a>
											</td>
										</tr>
										</table>
									</div>
									<div class="col-sm-6 p-0">
									<br><select class="form-control" id="iplist" size="4" multiple="multiple">';
										if(!empty($ips)){
											foreach($ips as $k => $v){	 
												echo '<option value="'.$k.'">'.$v['ip'].'</option>';
											}
												
										}
										echo '</select>
										<div class="d-flex mt-1 align-items-center">
											<a class="btn blue_btn py-1 px-2"onclick="javascript:addtoips(\'iptable\');">'.__('<<').'</a>
											&nbsp;&nbsp;
											<a class="btn blue_btn py-1 px-2" onclick="javascript:remove_all_ips();">'.__('Remove all IPs').'</a>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
					<div class="row mx-auto w-100 my-3 " id="ipv6_subnet_div" style="'.(empty($ips6_subnet) ? 'display: flex;' : '').'">
						<div class="col-sm-12 p-0">
							<label class="form-label">'.__('IPv6 Subnet').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('You can specify the number of IPv6 Subnet to assign').'"><i class="fas text-primary fa-info-circle"></i></a></label><br>
							<div class="input-group ">
								<input type="text" class="form-control" name="num_ips6_subnet" id="ipv6subnetcount" size="10"/>
								<div class="input-group-append">
									<span class="input-group-text">'.' (<span class="fhead text-secondary">'.($resources['ipv6_subnet']) .' Free</span>'.')<span>
								</div>
							</div>
						</div>
					</div>
					<div class="row mx-auto w-100 my-3 " id="ipv6_div" style="'.(empty($ips6) ? 'display:none;' : '').'">
						<div class="col-sm-12 p-0">
							<div class="row mx-auto w-100 mt-1 mb-0">
								<label class="form-label">'.__('IPv6 Addresses').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('You can specify the number of IPv6 to assign').'"><i class="fas text-primary fa-info-circle"></i></a></label><br>
								<div class="input-group ">
									<input type="text" class="form-control" name="num_ips6" id="ipv6count" size="10" />
									<div class="input-group-append">
										<span class="input-group-text">'.' (<span class="fhead text-secondary">'.($resources['ipv6']).' Free</span>'.')<span>
									</div>
								</div>
							</div>
						</div>
					</div>
					<div class="row mx-auto w-100 my-3 ">
						<div class="col-sm-12 p-0">
							<label class="form-label">'.__('Bandwidth').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Monthly Bandwidth limit of the VPS. 0 (Zero) for unlimited').'"><i class="fas text-primary fa-info-circle"></i></a></label><br>
							<div class="input-group">
								<input type="number" class="form-control" name="bandwidth" id="band" size="30" value="'.POSTval('bandwidth', '').'" onchange="handle_capping();" />
								<div class="input-group-append">
									<span class="input-group-text">'.__('GB').'<span>
								</div>
							</div>
						</div>
					</div>
					<div class="row mx-auto w-100 my-3 ">
						<div class="col-sm-12 p-0">
							<label class="form-label">'.__('Network Speed').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Enter 0 or leave empty for no restriction. <br />Use the select box for easy options').'"><i class="fas text-primary fa-info-circle"></i></a></label><br>
							<div class="d-flex align-items-center justify-content-center">
								<div class="input-group w-50">
									<input type="number" min="0" class="form-control " name="network_speed" id="network_speed" size="8" value="'.POSTval('network_speed', '').'" />
									<div class="input-group-append">
										<span class="input-group-text me-2">'.__('KB/s').'</span>
									</div>
								</div>
								<div class="ml-2 w-50">
									<select class="ml-3 custom-select speedkBps virt-select" name="network_speed2" id="network_speed2" onchange="netspeed(this.value)"></select>
								</div>
							</div>
						</div>
					</div>
					<div class="row mx-auto w-100 my-3 hide_for_plan" id="macaddress"  style="display:none">
						<div class="col-sm-12"><div>
					</div>
					</div>
				</div>
				</fieldset>	
				<br>
			</div>	
		</div>
	</div>

	<div class="col-sm-12 col-md-6 col-lg-6 mt-n2">
		<div class="card p-3 my-3">
			<div class="divroundshad">
				<fieldset class="user_details_f">
				<legend class="user_details_f mb-0">'.__('Memory').'</legend>
				<div class="row mx-auto w-100 my-0">
					<div class="col-sm-12 p-0">
						<div class="row mx-auto w-100 mt-1 mb-0">
							<div class="col-sm-12 p-0">
								<label class="control-label">'.__('Guaranteed RAM').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('The amount of RAM which the VPS will always have').'"><i class="fas text-primary fa-info-circle"></i></a></label><br>
								<div class="input-group ">
									<input type="number" min="0" class="form-control rounded" name="ram" id="gram" size="30" value="'.POSTval('ram', '').'" />
									<div class="input-group-append"><span class="input-group-text">'.__('MB').'</div>
								</div>
								<span style="font-size:12px" class="text-secondary">
									'.__('Actual Free').': '.$resources['ram'].' '.__('MB').'
									'.(empty($servers[$globals['server']]['alloc_ram']) ? '' : ' | '.__('Allocated').': '.$servers[$globals['server']]['alloc_ram'].' '.__('MB')).'
									'.(empty($resources['overcommit']) ? '' : ' | '.__('Overcommitted Free RAM').': '.($resources['overcommit'] - $servers[$globals['server']]['alloc_ram']).' '.__('MB')).'
								</span>
							</div>
						</div>';

					if($kernel->features('balloon', $_virt) && $cluster->check_feature($globals['server'], $_virt, 'min_ram')){
						echo '<div class="row mx-auto w-100 my-3">
								<div id="minram" class="col-sm-12 p-0 hide_for_plan">
								<label class="form-label">'.__('Minimum RAM').'</label><br>
									<div class="input-group">
										<input type="number" min="0" class="form-control" name="min_ram" id="min_ram" size="30" value="'.POSTval('min_ram', '').'" />
										<div class="input-group-append">
											<span class="input-group-text">'.__('MB').'</span>
										</div>
									</div>
								</div>
							</div>';										
					}

					if($virt == 'openvz' || $virt == 'proxo'){

					echo '
						<div class="row mx-auto w-100 my-3 ">
							<div id="burst" class="col-sm-12 p-0 hide_for_plan">
								<label class="form-label">'.__('Burstable RAM').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('The maximum amount of RAM which the VPS can use').'"><i class="fas text-primary fa-info-circle"></i></a></label><br>
								<div class="input-group">
									<input type="number" min="0" class="form-control" name="burst" id="bram" size="30" value="'.POSTval('burst', '').'" />
									<div class="input-group-append">
										<span class="input-group-text p-1 pt-2">'.__('MB').'</span>
									</div>
								</div>
							</div>
						</div>';

					}

					if($virt != 'openvz' && $virt != 'proxo'){

					echo '
						<div class="row mx-auto w-100 my-3 ">
							<div id="swappedram" class="col-sm-12 p-0 hide_for_plan">
								<label class="form-label">'.__('Swap RAM').'</label>
								<div class="input-group">
									<input type="number" min="0" class="form-control" name="swapram" id="swap" size="30" value="'.POSTval('swapram', '').'" />
									<div class="input-group-append">
										<span class="input-group-text">'.__('MB').'</span>
									</div>
								</div>
							</div>
						</div>';

					}
					if($virt == 'xen' && !empty($hvm)){
						echo '
						<div class="row mx-auto w-100 my-3 ">
							<div id="shadowrow" class="col-sm-12 p-0 hide_for_plan">
								<label class="form-label">'.__('Shadow Memory').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Recommended value : 8 MB').'"><i class="fas text-primary fa-info-circle"></i></a></label><br>
								<div class="input-group ">
									<input type="number" class="form-control rounded" name="shadow" id="shadow" size="30" value="'.POSTval('shadow', 8).'" />
								<div class="input-group-append">
									<span class="input-group-text">MB</span>
								</div>
								</div>
							</div>
						</div>';
						}echo'
					</div>
				</div>
				</fieldset>
			</div>
		</div>


		<div class="card p-3 my-3">
			<div class="divroundshad">
				<fieldset class="user_details_f">
				<legend class="user_details_f mb-0">'.__('CPU').'</legend>
				<div class="row mx-auto w-100 mb-0 mt-1">
					<div class="col-sm-12 p-0">';
						echo '<div class="row mx-auto w-100 mb-3 mt-0 hide_for_plan">';
						if($virt != 'virtualbox'){
						echo '
							<div class="col-sm-6 p-0">
								<label class="form-label">'.__('CPU Units').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('CPU units to be allocated').'"><i class="fas text-primary fa-info-circle"></i></a></label>
								<a href="'.$globals['docs'].'creating-a-vps/#cpu-parameters" target="_blank" tooltip="'.__('Open the guide').'"><i class="fas fa-external-link-alt info"></i></a><br>
								<div class="input-group">
									<input type="number" min="0" class="form-control" name="cpu" id="cpunit" size="30" value="'.POSTval('cpu', '').'" />
									<div class="input-group-append">
										<span class="input-group-text">'.__('units').'</span>
									</div>
								</div>
							</div>';
						}

						echo '
							<div class="col-sm-6 ps-2">
								<label class="form-label">'.__('CPU Cores').'&nbsp;</label>
								<a href="'.$globals['docs'].'creating-a-vps/#cpu-parameters" target="_blank" tooltip="'.__('Open the guide').'"><i class="fas fa-external-link-alt info"></i></a>
								<input type="number" min="0" class="form-control" name="cores" id="cores" size="30" value="'.POSTval('cores', '').'" />
							</div>';
						echo '</div>';
						if($virt != 'lxc'){
							// CPU Percent HTML Output
							echo '
							<div class="row mx-auto w-100 my-3 hide_for_plan">
								<div id="cpupercent" class="col-sm-12 p-0 hide_for_plan">
									<label class="form-label">'.__('CPU %').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('The CPU time in percent the corresponding VPS is not allowed to exceed. <br />Set <b>0</b> for no restriction.').'"><i class="fas text-primary fa-info-circle"></i></a></label>
									<a href="'.$globals['docs'].'creating-a-vps/#cpu-parameters" target="_blank" tooltip="'.__('Open the guide').'"><i class="fas fa-external-link-alt info"></i></a>
									<div class="input-group ">
										<input type="number" min="0" class="form-control" name="cpu_percent" id="percent" size="30" value="'.POSTval('cpu_percent', '').'" />
										<div class="input-group-append">
											<span class="input-group-text">%</span>
										</div>
									</div>
								</div>
							</div>';
						}

						// IO Priority
						if($kernel->features('io_priority', $virt)){
							echo '
							<div class="row mx-auto w-100 my-3 hide_for_plan">
								<div class="col-sm-12 p-0" >
									<label class="form-label">'.__('I/O Priority').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Choose priority from 0-7').'"><i class="fas text-primary fa-info-circle"></i></a></label>
									<select id="prior" name="priority" class="custom-select">
										<option value="0">0</option>
										<option value="1">1</option>
										<option value="2">2</option>
										<option value="3">3</option>
										<option value="4">4</option>
										<option value="5">5</option>
										<option value="6">6</option>
										<option value="7">7</option>
									</select>
								</div>
							</div>';
						}
						echo '
					</div>
				</div>
				</fieldset>
			</div>
		</div>
		
		<div class="card p-3 my-3">
			<div class="divroundshad">
				<fieldset class="user_details_f">
				<legend class="user_details_f mb-0">'.__('DISK').'</legend>
					<div class="row mx-auto w-100 mb-0 mt-1">
						<div class="col-sm-12 p-0">';
						if($bus_driver){
							echo '<div class="row mx-auto w-100 hide_for_plan">
								<div class="col-sm-12 p-0">
									<label class="form-label">'.__('Disk Space').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('The allowed disk space for the VPS').'"><i class="fas text-primary fa-info-circle"></i></a></label>
									<table name="storages_table" id="storages_table" class="w-100 shadow-none" cellpadding="2" cellspacing="0" border="0">
									<tr>
											<td width="100">
												<select class="custom-select bus_driver" id = "bus_driver" name="bus_driver[]" onchange="toggle_driver_num(this.value, this)">';
												
													foreach($bus_driver as $bdk => $bdv){
														echo '<option value="'.$bdk.'" '.POSTselect('bus_driver', $bdv).'>'.$bdv.'</option>';
													}
													
										echo   '</select>
											</td>
											<td>
											</td>
											<td width="70">
												<select class="custom-select bus_driver_num" name="bus_driver_num[]" id="bus_driver_num">';
													echo '<option class="sata virtio scsi" value="0" '.POSTselect('bus_driver_num', 0).'>0</option>';
													echo '<option class="sata virtio scsi" value="1" '.POSTselect('bus_driver_num', 1).'>1</option>';
													echo '<option class="ide sata virtio scsi" value="2" '.POSTselect('bus_driver_num', 2).'>2</option>';
													echo '<option class="ide sata virtio scsi" value="3" '.POSTselect('bus_driver_num', 3).'>3</option>';
													echo '<option class="virtio scsi" value="4" '.POSTselect('bus_driver_num', 4).'>4</option>';
													echo '<option class="sata virtio scsi" value="5" '.POSTselect('bus_driver_num', 5).'>5</option>';
													echo '<option class="virtio scsi" value="6" '.POSTselect('bus_driver_num', 6).'>6</option>';
													echo '<option class="virtio scsi" value="7" '.POSTselect('bus_driver_num', 7).'>7</option>';
													echo '<option class="virtio scsi" value="8" '.POSTselect('bus_driver_num', 8).'>8</option>';
													echo '<option class="virtio scsi" value="9" '.POSTselect('bus_driver_num', 9).'>9</option>';
													echo '<option class="virtio scsi" value="10" '.POSTselect('bus_driver_num', 10).'>10</option>';
													echo '<option class="virtio scsi" value="11" '.POSTselect('bus_driver_num', 11).'>11</option>';
													echo '<option class="virtio scsi" value="12" '.POSTselect('bus_driver_num', 12).'>12</option>';
													echo '<option class="virtio scsi" value="13" '.POSTselect('bus_driver_num', 13).'>13</option>';
													echo '<option class="virtio" value="14" '.POSTselect('bus_driver_num', 14).'>14</option>';
													echo '<option class="virtio" value="15" '.POSTselect('bus_driver_num', 15).'>15</option>';
										echo	'
												</select>
											</td>
											<td>
												
											</td>';
												
											if(empty($disks)){
												$disks[0]['st_uuid'] = $storages[$stid]['st_uuid'];
											}
											
											foreach($disks as $k => $v){

												echo '
													<td width="15%">
														<input name="size[]" class="form-control size" type="number" id="hdd_'.$k.'" step="0.001" size="30" value="'.@$v['size'].'" />
													</td>
													<td width="10">
														<span class="square">&nbsp;&nbsp;'.__('GB').'&nbsp;&nbsp;&nbsp;</span>
													</td>
													<td width="200">
														<select class="custom-select storages" name="storages[]">';
															foreach($storages as $sk => $sv){
																echo '<option value="'.$sv['st_uuid'].'" '.(isset($_POST['storages']) ? ($sv['st_uuid'] == $v['st_uuid'] ? 'selected="selected"' : '') : ($sv['st_uuid'] == $storages[$stid]['st_uuid'] ? 'selected="selected"' : '')).'>'.$sv['name'].'&nbsp;('.$sv['disk_space'].' GB '.(empty($sv['oversell']) ? __('Free') : __('Overcommitted Free Space')).')</option>';
															}
														echo '</select>
													</td>
													<td>
													</td>
												';
											}	
										echo '</tr>
											</table>
										<a id="add_storage_btn" class="mt-1 btn blue_btn py-1 px-2"onclick="add_storage_bus(\'storages_table\');">'.__('Add Storage').'</a>
							</div>';
							//scsi controller option from proxmox panel	
							echo '<div class="col-sm-12 p-0 scsi_controller">
								<label class="form-label">'.__('SCSI Controller').'</label>
								<select id="scsi_controller" name="scsi_controller" class="custom-select">
									<option value="">'.__('None').'</option>
									<option value="virtio-scsi-pci">VirtIO SCSI</option>
									<option value="lsi">LSI 53C895A</option>
									<option value="lsi53c810">LSI 53C810</option>
									<option value="megasas">MegaRAID SAS 8708EM2</option>
									<option value="virtio-scsi-single">VirtIO SCSI single</option>
									<option value="pvscsi">VMware PVSCSI</option>
								</select>
								</div>
							</div>';
							
						}else{
							echo '<div class="row mx-auto w-100 hide_for_plan">
								<div class="col-sm-12 p-0">
									<label class="form-label">'.__('Disk Space').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('The allowed disk space for the VPS').'"><i class="fas text-primary fa-info-circle"></i></a></label><br>
									<table name="storages_table" id="storages_table" class="shadow-none w-100" cellpadding="2" cellspacing="0" border="0" >';
										
									if(empty($disks)){
										$disks[0]['st_uuid'] = $storages[$stid]['st_uuid'];
									}
									
									foreach($disks as $k => $v){

										echo '<tr>
											<td width="35%">
											<div class="input-group">
												<input name="size[]" step="0.001" class="form-control size" type="number" id="hdd_'.$k.'" size="30" value="'.@$v['size'].'" />
												<div class="input-group-append">
													<span class="input-group-text">'.__('GB').'</span>
												</div>
											</div>
											</td>
											<td width="65%">
												<select class="custom-select storages ml-2" name="storages[]">';
													foreach($storages as $sk => $sv){
														echo '<option value="'.$sv['st_uuid'].'" '.(isset($_POST['storages']) ? ($sv['st_uuid'] == $v['st_uuid'] ? 'selected="selected"' : '') : ($sv['st_uuid'] == $storages[$stid]['st_uuid'] ? 'selected="selected"' : '')).'>'.$sv['name'].'&nbsp;('.$sv['disk_space'].' GB '.(empty($sv['oversell']) ? __('Free') : __('Overcommitted Free Space')).')</option>';
													}
												echo '</select>
											</td>
										</tr>';
									}
									
								echo '</table>
								<a id="add_storage_btn" class="btn mt-1 py-1 px-2" onclick="add_storage(\'storages_table\');">'.__('Add Storage').'</a>
								</div>
							</div>';	
						}
						if($virt == 'openvz'){
							if(!distro_check(1)){
								$ploop_flag = ($globals['ploop'] ? 'checked="checked" disabled="disabled"' : '');
								echo '<div class="row mx-auto w-100 my-3 hide_for_plan">
										<div class="col-3 p-0">
											<label class="form-label">'.__('Ploop').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If enabled, VPS will be created with the Ploop format').'"><i class="fas text-primary fa-info-circle"></i></a></label>
										</div>
										<div class="col-1 p-0">
											'.get_checkbox('show_ploop', '', 'ploop', array('chk_it' => 1, 'name' => 'ploop'), 1, '', array('onchange="change_checkbox(\'ploop\');"', $ploop_flag)).'
											<input type="hidden" name="ploop" id="hidden_ploop">
										</div>
									</div>';
							}
						}
					echo'</div>
					</div>
				</fieldset>
			</div>
		</div>
		<div class="card p-3 my-3">
			<fieldset class="user_details_f">
				<legend class="user_details_f mb-0">'.__('SSH Key Settings').'</legend>
				<div class="row mx-auto w-100 my-3">
					<div class="col-6 p-0">
						<label class="form-label">'.__('Disable password authentication').'&nbsp;<a class="info" data-bs-toggle="tooltip" data-bs-placement="top" data-bs-title="'.__('If enabled then password authentication will be restricted for SSH.').'"><i class="fas text-primary fa-info-circle"></i></a></label>
					</div>
					<div class="col-6 p-0">
						'.get_checkbox('disable_password', '', 'disable_password').'
					</div>
				</div>
				<div class="row mx-auto w-100 my-3" id="ssh_options_div">
					<div class="col-sm-4 p-0">
						<label class="custom-control custom-radio form-check">
							<input for="input radio" type="radio" class="ssh_options form-check-input" name="ssh_options" id="generate_keys" value="generate_keys">
							<span class="custom-form-label" for="generate_keys">'.__('Generate SSH Keys').'</span>
						</label> 
					</div>
					<div class="col-sm-4 p-0">
						<label class="custom-control custom-radio form-check">
							<input for="input radio" type="radio" class="ssh_options form-check-input" name="ssh_options" id="add_ssh_keys" value="add_ssh_keys">
							<span class="custom-form-label" for="add_ssh_keys">'.__('Add SSH Keys').'</span>
						</label>
					</div>
					<div class="col-sm-4 p-0">
						<label class="custom-control custom-radio form-check">
							<input for="input radio" type="radio" class="ssh_options form-check-input" name="ssh_options" id="use_ssh_keys" value="use_ssh_keys">
							<span class="custom-form-label" for="use_ssh_keys">'.__('Use Existing Keys').'</span>
						</label> 
					</div>
				</div>
				<div class="row mx-auto w-100 my-3" id="add_ssh_keys_div" style="display:none;">
					<div class="col-sm-12 p-0">
						<input type="hidden" name="private_key" id="private_key">
						<div class="loader" id="new_key_loader" stlye="display:none;"></div>
						<div id="download_private" class="mb-3" style="display:none"><a href="" id="private_key_link">'.__('Download private key').'</a>&nbsp;<a class="info" data-placement="right" tooltip="'.__('Note: We do not save private key, so please download it').'"><i class="fas text-primary fa-info-circle"></i></a></div>
						<label class="form-label">'.__('Add SSH key').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Add public key in VPS.<br>NOTE : This key will not be saved.').'"><i class="fas text-primary fa-info-circle"></i></a></label>
						<textarea class="form-control font-monospace w-100" id="sshkey" name="sshkey" rows="8">'.POSTval('sshkey', '').'</textarea>
					</div>
				</div>
				<div class="row mx-auto w-100 my-3" id="use_ssh_keys_div" style="display:none;">
					<div class="col-sm-12 p-0">
						<div class="row mx-auto w-100 p-0" id="existing_keys_div">
							<div class="col-sm-12">
								'.__('No SSH keys found!').'
							</div>
						</div>
					</div>
				</div>
			</fieldset>
		</div>
		';
		if($kernel->features('load_balancer', $_virt) && $pro_lic){
			$select_load_balancer = (int) optGET('load_balancer');
			echo '
			<div class="card p-3 my-3" id="load_balancer_card">
				<fieldset class="user_details_f">
					<legend class="user_details_f mb-0">'.__('Load Balancer Settings').'</legend>
					<div class="row mx-auto w-100 my-3">
						<div class="col-12 p-0">
							<label class="form-label">'.__('Select Load Balancer').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Select Load Balancer to use this VPS behind Load Balancer').'"><i class="fas text-primary fa-info-circle"></i></a></label><br>
							<select name="load_balancer" class="virt-select" id="load_balancer">
								<option value="0">'.__('None').'</option>
								<option value="-1" '.(!empty($select_load_balancer) ? 'selected="selected"' : "").'>'.__('Create as Load Balancer').'</option>
							</select>
						</div>
					</div>
				</fieldset>
			</div>';
		}	
		echo'

		<!------------------------------------------------ -->
		
	</div>	
</div>		
</div>


<!-- advance settings start -->
<div class="row mx-auto w-100 my-3 ">
	<div class="col-sm-12 p-0">
		<div class="roundheader mx-3 px-4 hide_for_plan cursor-pointer" onclick="toggle_advoptions(\'adv\');" ><label id="adv_advoptions_ind"  class="min_width">+</label> '.__('Advanced Options').'</div>
		<div id="adv_advoptions" class="hide_for_plan w-100" style="display:none">
		<div class="row mx-auto w-100 py-3">
			<!-- Network Settings options -->
			<div class="col-sm-12 col-md-6 col-lg-6 ">
				<div class="card p-3 mb-3">
					<div class="divroundshad">
						<fieldset class="user_details_f">
						<legend class="user_details_f mb-0 mt-n1">'.__('Network Settings').'</legend>';
						echo '
							<div class="row mx-auto w-100 my-3 w-100">
								<div class="col-6 p-0">
									<label class="form-label">'.__('Bandwidth suspend ').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Suspend the VPS if it is uses more than specified bandwidth').'"><i class="fas text-primary fa-info-circle"></i></a></label>
								</div>
								<div class="col-2 p-0">
									'.get_checkbox('show_band_suspend', '', 'band_suspend', array('chk_it' => 1, 'name' => 'band_suspend'), 1, '', array('onchange="change_checkbox(\'band_suspend\'); handle_capping();"')).'
									<input type="hidden" name="band_suspend" id="hidden_band_suspend">
								</div>
							</div>
						';
							if($kernel->features('ebtables_support', $_virt)){
												
						echo '
								<div class="row mx-auto w-100 my-3">
									<div class="col-6 p-0">
										<label class="form-label">'.__('Disable ebtables').'</label>
									</div>
									<div class="col-6 p-0">
										'.get_checkbox('show_disable_ebtables', '', 'disable_ebtables', array('chk_it' => 1, 'name' => 'disable_ebtables'), 1, '', array('onchange="change_checkbox(\'disable_ebtables\');"')).'
										<input type="hidden" name="disable_ebtables" id="hidden_disable_ebtables">
									</div>
								</div>';
							}
							if($kernel->features('nw_config', $_virt)){
										
						echo '
								<div class="row mx-auto w-100 my-3">
									<div class="col-6 p-0">
										<label class="form-label">'.__('Disable Network configuration').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If checked, Virtualizor will not configure/re-write network when a VPS is rebooted. However, during creation of the VPS, the network file will be written.').'"><i class="fas text-primary fa-info-circle"></i></a></label>
									</div>
									<div class="col-6 p-0">
										'.get_checkbox('show_disable_nw_config', '', 'disable_nw_config', array('chk_it' => 1, 'name' => 'disable_nw_config'), 1, '', array('onchange="change_checkbox(\'disable_nw_config\');"')).'
										<input type="hidden" name="disable_nw_config" id="hidden_disable_nw_config">
									</div>
								</div>';
							}
							// Internal IP
							if(!empty($ips_int)){
							
						echo '
							<div class="row mx-auto w-100 my-3 w-100">
								<div class="col-sm-12 p-0">
								<label class="form-label">'.__('Internal IP Addresses').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('You can choose from the Internal IP Addresses List').'"><i class="fas text-primary fa-info-circle"></i></a></label><br>';
									
									$_ips_int = @$_POST['ips_int'];
									
									if(is_array($_ips_int) && !empty($_ips_int)){
										foreach($_ips_int as $k => $ip){
											if(empty($ip)){
												unset($_ips_int[$k]);
											}
										}
									}
									
									if(empty($_ips_int)){
										$_ips_int = array(NULL);
									}
									
									if(!empty($ips_int)){
									
										echo '<select id="ips_int" class="form-control" name="ips_int[]" size="5" multiple="multiple">';
										foreach($ips_int as $k => $v){	 
											echo '<option value="'.$v['ip'].'" '.(@in_array($v['ip'], $_POST['ips_int']) ? 'selected="selected"' : '').'>'.$v['ip'].'</option>';
										}		
										echo'</select>';
										
									}else{
										'&nbsp;';
									}		
										
							echo '</div>
							</div>';
							}
							
						echo '
							<div class="row mx-auto w-100 my-3 w-100">
								<div class="col-sm-12 p-0">
									<label class="form-label">'.__('Upload Speed').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Enter 0 or leave empty for no restriction. <br /> Enter -1 for upload speed to be same as <b>Network Speed.</b> <br />Use the select box for easy options').'"><i class="fas text-primary fa-info-circle"></i></a></label><br>
									<div class="input-group">
										<input type="number" class="form-control" name="upload_speed" id="upload_speed" size="8" value="'.POSTval('upload_speed', '-1').'" onchange="handle_capping();" />
										<div class="input-group-append">
											<span class="input-group-text me-2">'.__('KB/s').'</span>
										</div>
									<div class="ml-2 w-50">
										<select class="virt-select speedkBps" name="upload_speed2" id="upload_speed2" onchange="upspeed(this.value)"></select>
									</div>
									</div>
								</div>
							</div>
							<div id="speed_cap_limit">
								<div class="row mx-auto w-100 my-3 w-100">
									<div class=" col-sm-12 p-0">
										<label class="form-label" for="speed_cap_down">'.__('Capped Download Speed ').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Download speed after the bandwidth is overused for a VPS, 0 or emtpy value indicates no capping').'"><i class="fas text-primary fa-info-circle"></i></a></label>
										<br>
										<div class="input-group ">
										<input type="number" class="form-control rounded" name="speed_cap_down" id="speed_cap_down" onmouseout="blur();" />			
										<div class="input-group-append w-50">
											<span class="square mr-1">'.__('KB/s').'</span>
											<select class="virt-select speedkBps" name="speed_cap_down2" id="speed_cap_down2" onchange="$(\'#speed_cap_down\').val(this.value)"></select>
										</div>
										</div>
									</div>
								</div>
								<div class="row mx-auto w-100 my-3">
									<div class="col-sm-12 p-0">
										<label class="form-label" for="speed_cap_up">'.__('Capped Upload Speed ').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Upload speed after the bandwidth is overused for a VPS.<br /> If VPS upload speed -1 then  Capped upload speed will be same as <b>Capped Download Speed</b><br />0 or emtpy value indicates no capping').'"><i class="fas text-primary fa-info-circle"></i></a></label><br>
										<div class="input-group ">
										<input type="number" class="form-control" name="speed_cap_up" id="speed_cap_up" onmouseout="blur();" />
										<div class="input-group-append w-50">
											<span class="square mr-1">'.__('KB/s').'</span>
											<select class="virt-select speedkBps" name="speed_cap_up2" id="speed_cap_up2" onchange="$(\'#speed_cap_up\').val(this.value)"></select>
										</div>
										</div>
									</div>
								</div>
							</div>';

							$nic_lang['nic_default'] = 'Realtek 8139(default)';
							$nic_lang['nic_e1000'] = 'Intel E1000';
							$nic_lang['nic_novell'] = 'Novell NE2000';
							$nic_lang['nic_i82559er'] = 'Intel i82559er';
							$nic_lang['nic_pcnet'] = 'AMD PCNET';
							$nic_lang['nic_ne2k_isa'] = 'Novell E2000 ISA';
							
							if(!empty($supported_nics)){
								
								echo '<div class="row mx-auto w-100 my-3 w-100">
									<div class="col-sm-12 p-0">
										<label class="form-label">'.__('Virtual Network Interface Type').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If you want to change the network interface type. Options are default or E1000. <b>virtio</b> will be used as the virtual nic type if <b>virtio</b> is enabled').'"><i class="fas text-primary fa-info-circle"></i></a></label><br>
										<select class="custom-select" name="nic_type" id="nic_type" >';
										
											foreach($supported_nics as $k => $v){
												
												echo '<option value="'.$v.'" '.POSTselect('nic_type', $v).'>'.(!empty($nic_lang['nic_'.$v]) ? $nic_lang['nic_'.$v] : $v).'</option>';
											}
										echo '</select>
									</div>
								</div>';
							}
							
							/*
							if($kernel->features('vlan_tag', $virt)){

								echo'<div class="row mx-auto w-100 my-3">
									<div class="col-sm-12 p-0">
										<label class="form-label">'.__('VLAN Tag').'</label><br>
										<input type="number" max="4094" class="form-control" name="vlan_tag" id="vlan_tag"  value="'.POSTval('vlan_tag').'"/>
									</div>
								</div>';

							}
							*/
							
							
							// All kernel. DNS Nameserver 
							echo '<div class="row mx-auto w-100 my-3">
									<div class="col-sm-12 p-0">
										<label class="form-label">'.__('DNS Nameservers').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If not aware then use 4.2.2.1 and 4.2.2.2').'"><i class="fas text-primary fa-info-circle"></i></a></label><br>
										<div class="row mx-auto w-100 my-1">
											<div class="col-sm-12 p-0" id="dnstable">';
										
												$_dns = @$_POST['dns'];
												
												if(is_array($_dns) && !empty($_dns)){
													foreach($_dns as $d => $ds){
														if(empty($ds)){
															unset($_dns[$d]);
														}
													}
												}
												
												if(empty($_dns)){
													$_dns = array(NULL);
												}
											
												foreach($_dns as $dn){
													echo '<div class="row mx-auto w-100 my-1">
														<div class="col-sm-12 p-0 d-inline-flex">
															<input type="text" class="form-control" name="dns[]" value="'.$dn.'"/>
														</div>
													</div>';
												}
												
											echo '
											</div>
										</div>
										<a onclick="adddnsrow(\'dnstable\')" class="btn mt-1 blue_btn py-1 px-2">'.__('+').'</a>
										<span class="help-block"></span>
									</div>
							</div>
							<div class="row mx-auto w-100 user_details" style="display:none">
								<div class="col-sm-12 p-0">
									<label class="form-label">'.__('DNS Plan').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Choose a DNS Plan for the User.').'"><i class="fas text-primary fa-info-circle"></i></a></label><br>
									<select class="custom-select virt-select" name="dnsplid">';
										foreach($dnsplans as $dk => $dv){		 
											echo '<option value="'.$dk.'" '.(POSTval('dnsplid') == $dk ? 'selected="selected"' : '').'>'.$dv['plan_name'].'</option>';
										}
								
									echo '</select>
								</div>
							</div>';

					echo'		
						</fieldset>
					</div>
				</div>';

				//Disk advance option
				echo '
				<div class="card p-3 mb-3">
					<div class="divroundshad">
						<fieldset class="user_details_f">
							<legend class="user_details_f mb-0">'.__('DISK').'</legend>';
							if($kernel->features('virtio', $virt) && $virt != 'proxk'){
								echo '<div class="row mx-auto w-100 my-3">
										<div class="col-sm-4 p-0">
											<label class="form-label">'.__('Select Disk driver').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Use <b>virtio</b> for virtio drivers<br>Use <b>scsi</b> for disk drivers. Fstrim will work <b>ONLY</b> if scsi is selected and storage is thin.<br>If None is checked IDE will be selected').'"><i class="fas text-primary fa-info-circle"></i></a></label>
										</div>
										
										<div class="col-sm-3 form-check">
											<input type="radio" class="form-check-input" id="disk_driver_none" name="virtio" value="0"   '.POSTradio('virtio', 0).'>
											<label class="form-check-label">
												'.__('None').'
											</label>
										</div>
										<div class="col-sm-3 p-0 form-check">
											<input type="radio" class="form-check-input" id="virtio" name="virtio" value="1"   '.POSTradio('virtio', 1).' checked="checked">
											<label class="form-check-label">
												'.__('virtio').'
											</label>
										</div>
										<div class="col-sm-2 form-check">
											<input type="radio" class="form-check-input" id="scsi" name="virtio" value="2"   '.POSTradio('virtio', 2).'>
											<label class="form-check-label">
												'.__('scsi').'
											</label>
										</div>
									</div>';
							}

							if($kernel->features('ssd_emulation', $_virt)){
								echo'
									<div class="row mx-auto w-100 my-3">
										<div class="col-6 p-0 ssd_emulation">
											<label class="form-label">'.__('SSD Emulation').'</label>
										</div>
										<div class="col-6 p-0 ssd_emulation">
											'.get_checkbox('ssd_emulation', '', 'ssd_emulation').'
										</div>
									</div>';
							}

							if($kernel->features('discard', $_virt)){

								echo'<div class="row mx-auto w-100 my-3">
									<div class="col-6 p-0">
										<label class="form-label">'.__('Enable Discard').'</label><br>
									</div>
									<div class="col-6 p-0">
										'.get_checkbox('discard', '', 'discard', array('chk_it' => 1), 1).'
									</div>
								</div>';

							}

							if($kernel->features('iothread', $virt)){

								echo'<div class="row mx-auto w-100 my-3">
									<div class="col-6 p-0">
										<label class="control-label">'.__('IO Thread').'</label><br>
									</div>
									<div class="col-6 p-0">
										'.get_checkbox('iothread', '', 'iothread', array('chk_it' => 1), 1).'
									</div>
								</div>';

							}
							if($kernel->features('kvm_cache', $virt)){
								echo '
								<div class="row mx-auto w-100 my-3">
									<div class="col-sm-12 p-0">
										<label class="form-label">'.__('Disk Caching').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Controls the cache mechanism').'"><i class="fas text-primary fa-info-circle"></i></a></label><br>
										<select class="custom-select" name="kvm_cache" id="kvm_cache" >
											<option value="0" '.POSTselect('kvm_cache', 'none').'>None</option>
											<option value="writeback" '.POSTselect('kvm_cache', 'writeback').'>Writeback</option>
											<option value="writethrough" '.POSTselect('kvm_cache', 'writethrough').'>Writethrough</option>
											<option value="directsync" '.POSTselect('kvm_cache', 'directsync').'>Direct Sync</option>
											<option value="default" '.POSTselect('kvm_cache', 'default').'>Default</option>
										</select>
									</div>
								</div>';
							}

							if($kernel->features('io_mode', $virt)){
								echo'
								<div class="row mx-auto w-100 my-3">
									<div class="col-sm-12 p-0">
										<label class="form-label">'.__('I/O Policy').'</label><br>
										<select class="custom-select" name="io_mode" id="io_mode" >
											<option value="0" '.POSTselect('io_mode', 'default').'>Default</option>
											<option value="native" '.POSTselect('io_mode', 'native').'>Native</option>
											<option value="threads" '.POSTselect('io_mode', 'threads').'>Threads</option>
										</select>
									</div>
								</div>';
							}

							if($kernel->features('iops_sec', $virt)){
								echo '
								<div class="row mx-auto w-100 my-3">
									<div class="col-sm-12 p-0">
										<label class="form-label">'.__('Total I/O\'s per sec').'</label><br>
										<input type="number" class="form-control" name="total_iops_sec" value="'.POSTval('total_iops_sec', '').'" />
									</div>
								</div>
								<div class="row mx-auto w-100 my-3">
									<div class="col-sm-12 p-0">
										<label class="form-label">'.__('Read Mega Byte\'s/s').'</label><br>
										<div class="input-group ">
											<input type="number" class="form-control" name="read_bytes_sec" value="'.POSTval('read_bytes_sec', '').'" />
											<div class="input-group-append">												
												<span class="input-group-text p-1">MB/s</span>
											</div>
										</div>
									</div>
								</div>
								<div class="row mx-auto w-100 my-3">
									<div class="col-sm-12 p-0">
										<label class="form-label">'.__('Write Mega Byte\'s/s').'</label><br>
										<div class="input-group ">
											<input type="number" class="form-control" name="write_bytes_sec" value="'.POSTval('write_bytes_sec', '').'" />
											<div class="input-group-append">
												<span class="p-1 input-group-text">MB/s</span>
											</div>
										</div>
									</div>
								</div>';
							}

					echo'
						</fieldset>
					</div>
				</div>';

				// Advance Container options
				if($kernel->features('tun_tap', $virt)){ 
					echo '
				<div class="card p-3 my-3">
					<div class="divroundshad">
						<fieldset class="user_details_f">
							<legend class="user_details_f mb-0">'.__('Container Settings').'</legend>';
					echo '	
							<div class="row mx-auto w-100 my-3">
								<div class="col-6 p-0">
									<label class="form-label">'.__('Tun/Tap').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Enable Tun/Tap for a VPS').'"><i class="fas text-primary fa-info-circle"></i></a></label>
								</div>
								<div class="col-6 p-0">
									'.get_checkbox('show_tuntap', '', 'tuntap', array('chk_it' => 1, 'name' => 'tuntap'), 1, '', array('onchange="change_checkbox(\'tuntap\');"')).'
									<input type="hidden" name="tuntap" id="hidden_tuntap">
								</div>
							</div>';
				
					// TUN/TAP$virt == 'openvz' || $virt == 'vzo' || $virt == 'proxo'
					if($kernel->features('openvz_features', $virt)){
					echo'
						<div class="row mx-auto w-100 my-3">
							<div class="col-6 p-0">
								<label class="form-label">'.__('PPP').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Enable PPP (Point to Point Protocol) for a VPS').'"><i class="fas text-primary fa-info-circle"></i></a></label>
							</div>
							<div class="col-6 p-0">
								'.get_checkbox('show_ppp', '', 'ppp', array('chk_it' => 1, 'name' => 'ppp'), 1, '', array('onchange="change_checkbox(\'ppp\');"')).'
								<input type="hidden" name="ppp" id="hidden_ppp">
							</div>
						</div>
						<div class="row mx-auto w-100 my-3">
							<div class="col-6 p-0">
								<label class="form-label">'.__('Enable Fuse in Container(s)').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If checked, Fuse will be enabled while making the new container(s).').'"><i class="fas text-primary fa-info-circle"></i></a></label><br />
							</div>
							<div class="col-6 p-0">
								'.get_checkbox('show_fuse', '', 'fuse', array('chk_it' => 1, 'name' => 'fuse'), 1, '', array('onchange="change_checkbox(\'fuse\');"')).'
								<input type="hidden" name="fuse" id="hidden_fuse">
							</div>
						</div>
						<div class="row mx-auto w-100 my-3">
							<div class="col-6 p-0">
								<label class="form-label">'.__('Enable IPIP in Container(s)').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If checked, IPIP will be enabled while making the new container(s).').'"><i class="fas text-primary fa-info-circle"></i></a></label><br />
							</div>
							<div class="col-6 p-0">
								'.get_checkbox('show_ipip', '', 'ipip', array('chk_it' => 1, 'name' => 'ipip'), 1, '', array('onchange="change_checkbox(\'ipip\');"')).'
								<input type="hidden" name="ipip" id="hidden_ipip">
							</div>
						</div>
						<div class="row mx-auto w-100 my-3">
							<div class="col-6 p-0">
								<label class="form-label">'.__('Enable IPGRE in Container(s)').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If checked, IPGRE will be enabled while making the new container(s).').'"><i class="fas text-primary fa-info-circle"></i></a></label><br />
							</div>
							<div class="col-6 p-0">
								'.get_checkbox('show_ipgre', '', 'ipgre', array('chk_it' => 1, 'name' => 'ipgre'), 1, '', array('onchange="change_checkbox(\'ipgre\');"')).'
								<input type="hidden" name="ipgre" id="hidden_ipgre">
							</div>
						</div>
						<div class="row mx-auto w-100 my-3">
							<div class="col-6 p-0">
								<label class="form-label">'.__('Enable NFS in Container(s)').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If checked, NFS will be enabled while making the new container(s).').'"><i class="fas text-primary fa-info-circle"></i></a></label><br />
							</div>
							<div class="col-6 p-0">
								'.get_checkbox('show_nfs', '', 'nfs', array('chk_it' => 1, 'name' => 'nfs'), 1, '', array('onchange="change_checkbox(\'nfs\');"')).'
								<input type="hidden" name="nfs" id="hidden_nfs">
							</div>
						</div>
						<div class="row mx-auto w-100 my-3">
							<div class="col-sm-12 p-0">
								<label class="form-label">'.__('Enable QUOTAUGIDLIMIT in Container(s)').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Enables or disables in-container per-user and per-group disk quotas. If the value is set to 0 or not set, disk quotas inside the container is disabled and not accounted. <br><b>NOTE:</b> This will restart the container.').'"><i class="fas text-primary fa-info-circle"></i></a></label><br />
								<input type="text" class="form-control" name="quotaugidlimit" id="quotaugidlimit" size="30" value="'.POSTval('quotaugidlimit').'" />
							</div>
						</div>
						<div class="row mx-auto w-100 my-3">
							<div class="col-sm-12 p-0">
								<label class="form-label">'.__('Set IO Bandwidth Limit for Container(s)').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If set, IO operation will not exceed the specified limit while performing IO operations.').'"><i class="fas text-primary fa-info-circle"></i></a></label><br />
								<input type="number" class="form-control" name="iolimit" id="iolimit" size="30" value="'.POSTval('iolimit').'" />
							</div>
						</div>
						<div class="row mx-auto w-100 my-3">
							<div class="col-sm-12 p-0">
								<label class="form-label">'.__('Set IOPS Limit for Container(s)').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If set, IO operations per second will not exceed the specified limit.').'"><i class="fas text-primary fa-info-circle"></i></a></label><br />
								<input type="number" class="form-control" name="iopslimit" id="iopslimit" size="30" value="'.POSTval('iopslimit').'" />
							</div>
						</div>
						<div class="row mx-auto w-100 my-3">
							<div class="col-sm-12 p-0">
								<label class="form-label">'.__('Set the netfilter module').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('This option is used to to set the state of iptables module').'"><i class="fas text-primary fa-info-circle"></i></a></label><br />
								';
								$netfilter = array('full' => "Full",
										 'stateful' => "Stateful"
										  );
								echo '
								<select class="custom-select virt-select" name="netfilter" id="netfilter">';
								foreach($netfilter as $netfilter_key => $netfilter_value){
									echo '<option value="'.$netfilter_key.'" '.POSTselect('netfilter', $netfilter_key).'>'.$netfilter_value.'</option>';
								}
								echo'	</select>
							</div>
						</div>';
					}
					echo '</fieldset>
					</div>
				</div>';
				}
			echo '
			</div>';
			//Control Panel
			echo '
			<div class="col-sm-12 col-md-6 col-lg-6">';
				if($pro_lic && $kernel->features('vertical_scaling', $virt)){
					echo '
					<div class="card p-3 my-3 row mx-auto w-100" id="vertical_scaling_settings" style="display:none;">
						<div class="col-sm-12 p-2">
							<fieldset class="user_details_f">
								<legend class="user_details_f mb-0">'.__('Vertical Scaling Settings').'</legend>
								<div class="row mx-auto w-100">
									<div class="col-sm-12 notice">
										'.__('<ol class="pl-2 mb-1">
<li>Vertical scaling is supported on KVM based virtualization only.</li>
<li>QEMU version should be greater than or equal to 1.5, To check QEMU Version run "/usr/bin/virsh version"</li>
<li>Vertical scaling is currently not supported on Windows VPS</li>
</ol>').'
									</div>
								</div>';
								if(empty($globals['enable_ver_scaling'])){
									echo'
									<div class="row mx-auto w-100 my-3">
										<div class="col-6 p-0">
											<label class="form-label">'.__('Enable vertical scaling').'</label>
										</div>
										<div class="col-6 p-0">
											'.get_checkbox('enable_ver_scaling', '', 'enable_ver_scaling').'
										</div>
									</div>';
								}
								echo '
								<div class="ver_scale_settings">
									<h5>'.__('RAM Settings').'</h5>
									<div class="row mx-auto w-100 my-3">
										<div class="col-sm-12 p-0">
											<label class="form-label">'.__('Max RAM (in MB)').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Provide the maximum amount of RAM that will be allocated to VPS ').'"><i class="fas text-primary fa-info-circle"></i></a></label>
											<input type="text" class="form-control" placeholder="'.(!empty($globals['ver_max_ram']) ? __('Default').' '.$globals['ver_max_ram'] : '').'" name="ver_max_ram" value="'.POSTval('ver_max_ram').'" />
										</div>
									</div>
									<div class="row mx-auto w-100 my-3">
										<div class="col-sm-12 p-0">
											<label class="form-label">'.__('RAM Threshold (in %)').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If the VPS RAM usage is greater/less than threshold provided scaling will be performed accordingly').'"><i class="fas text-primary fa-info-circle"></i></a></label>
											<input type="text" class="form-control" name="ver_ram_threshold" value="'.POSTval('ver_ram_threshold').'" placeholder="'.(!empty($globals['ver_ram_threshold']) ? __('Default').' '.$globals['ver_ram_threshold'] : '').'" />
										</div>
									</div>
									<div class="row mx-auto w-100 my-3">
										<div class="col-sm-12 p-0">
											<label class="form-label">'.__('Increase/Decrease RAM By (in GB)').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If the threshold exceeds/subceeds, the provided RAM (in GB) will be increased or decreased accordingly').'"><i class="fas text-primary fa-info-circle"></i></a></label>
											<input type="text" class="form-control" name="ver_ram_inc_by" value="'.POSTval('ver_ram_inc_by').'" placeholder="'.(!empty($globals['ver_ram_inc_by']) ? __('Default').' '.$globals['ver_ram_inc_by'] : '').'" />
										</div>
									</div>
									<hr>
									<h5>'.__('CPU Settings').'</h5>
									<div class="row mx-auto w-100 my-3">
										<div class="col-sm-12 p-0">
											<label class="form-label">'.__('Max CPU Cores').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Provide the maximum amount of cpu cores that will be allocated to VPS ').'"><i class="fas text-primary fa-info-circle"></i></a></label>
											<input type="text" class="form-control" name="ver_max_cpu" value="'.POSTval('ver_max_cpu').'" placeholder="'.(!empty($globals['ver_max_cpu']) ? __('Default').' '.$globals['ver_max_cpu'] : '').'" />
										</div>
									</div>
									<div class="row mx-auto w-100 my-3">
										<div class="col-sm-12 p-0">
											<label class="form-label">'.__('CPU Threshold (in %)').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If the VPS cpu usage is greater/less than threshold provided scaling will be performed accordingly').'"><i class="fas text-primary fa-info-circle"></i></a></label>
											<input type="text" class="form-control" name="ver_cpu_threshold" value="'.POSTval('ver_cpu_threshold').'" placeholder="'.(!empty($globals['ver_cpu_threshold']) ? __('Default').' '.$globals['ver_cpu_threshold'] : '').'" />
										</div>
									</div>
									<div class="row mx-auto w-100 my-3">
										<div class="col-sm-12 p-0">
											<label class="form-label">'.__('Increase/Decrease CPU Cores By').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If the threshold exceeds/subceeds, the provided cores will be increased or decreased accordingly').'"><i class="fas text-primary fa-info-circle"></i></a></label>
											<input type="text" class="form-control" name="ver_cpu_inc_by" value="'.POSTval('ver_cpu_inc_by').'" placeholder="'.(!empty($globals['ver_cpu_inc_by']) ? __('Default').' '.$globals['ver_cpu_inc_by'] : '').'" />
										</div>
									</div>
								</div>	
							</fieldset>
						</div>
					</div>';	
				}

				echo '
				<div class="row mx-auto w-100">
					<div class="col-sm-12 p-1">
						<div class="card p-3 mb-3">
							<div class="divroundshad">
								<fieldset class="user_details_f">
									<legend class="user_details_f mb-0">'.__('Control Panel').'</legend>
										<div class="row mx-auto w-100 my-3">
											<div class="col-sm-12 p-0">
												<label class="form-label">'.__('Web Control Panel').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('This option will install selected web control panel in the VPS').'"><i class="fas text-primary fa-info-circle"></i></a></label><br>
												<select class="custom-select" name="control_panel" id="control_panel" onchange="show_webuzo(this.value); check();">
													<option value="0" '.POSTselect('control_panel', 'none').'>None</option>
													<option value="webuzo" '.POSTselect('control_panel', 'webuzo').'>Webuzo</option>
													<option value="plesk" '.POSTselect('control_panel', 'plesk').'>Plesk</option>
													<option value="cpanel" '.POSTselect('control_panel', 'cpanel').'>cPanel</option>
													<option value="webmin" '.POSTselect('control_panel', 'webmin').'>Webmin</option>
													<option value="interworx" '.POSTselect('control_panel', 'interworx').'>Interworx</option>
													<option value="ispconfig" '.POSTselect('control_panel', 'ispconfig').'>ISPConfig</option>
													<option value="cwp" '.POSTselect('control_panel', 'cwp').'>CentOS Web Panel</option>
													<option value="vesta" '.POSTselect('control_panel', 'vesta').'>VestaCP</option>'; 
													if(!empty($custom_cp)){
														foreach($custom_cp as $k => $v){
															echo '<option value="virt_'.$v.'" '.POSTselect('control_panel', 'virt_'.$v).'>'.$v.'</option>';
														}
													}
													echo ';
												</select>
											</div>
										</div>
										<div class="row mx-auto w-100 my-2" id="webuzo_app_checkbox" style="display:none;">
											<div class="col-sm-6">
												'.__('Install Application').'
											</div>
											<div class="col-sm-6">
												'.get_checkbox('webuzo_install_app', '', 'webuzo_install_app', array('chk_it' => 1), 1, '', array('onchange="webuzo_app_install();"')).'
											</div>
										</div>
										<div id="show_webuzo_tr" class="col-sm-12 p-2 border rounded" style="display:none;">
											<div id="webuzo_content" class="py-2 px-0">
												<span class="help-block m-2">'.__('Create VPS with Applications').'</span><br />
												<div class="row mx-auto w-100 my-3">
													<div class="col-sm-6 px-2">
														<label class="form-label">'.__('Root Password').'</label><br />
														<div class="input-group ">
															<input class="form-control" type="text" name="webuzo_spasswd" id="webuzo_spasswd" onkeyup="check_pass_strength(\'webuzo_spasswd\');"  placeholder="'.__('Enter Root Password').'" 
															value="'.POSTval('webuzo_spasswd', '').'" autocomplete="off">
															<div class="input-group-append">
																<a href="javascript: void(0);" onclick="$_(\'webuzo_spasswd\').value=randstr(12, 1, '.(!empty($globals['pass_strength']) ? $globals['pass_strength'] : 0).');check_pass_strength(\'webuzo_spasswd\');return false;" class="btn-primary rounded-right" title="'.__('Make another Random Password').'"><i class="fas fa-key p-2"></i></a>
															</div>
														</div>
														<div id="webuzo_spasswd_pass-strength-result" class="w-100">
															'.__('Strength Indicator').'
														</div>
													</div>
													<div class="col-sm-6 px-2">
														<label class="form-label">'.__('Primary Domain').'</label><br />
														<input class="form-control" type="textbox" name="webuzo_pd" id="webuzo_pd" placeholder="'.__('example.com').'" 
														value="'.POSTval('webuzo_pd', '').'">	
													</div>
												</div>
												<div class="row mx-auto w-100 my-3">
													<div class="col-sm-12 px-2">
														<label class="form-label">'.__('Select a script').'</label><br />';
														echo'
														<select id="webuzo_scriptlist" class="custom-select virt-select" onchange="script_req(this.value);" name="webuzo_script">
														<option value="0">'.__('None').'</option>';
														foreach($allowed_scripts as $k => $v){
															echo '<optgroup label="'.$k.'">';
															$val = $v;
															foreach($val as $vk => $vv){
																echo '<option value="'.$vk.'">'.$vv['name'].'</option>';
															}
															echo '</optgroup>';
														}
														echo ';
														</select>
													</div>
												</div>
												<div class="row mx-auto w-100 my-3">
													<div class="col-sm-12 px-2">
														<label class="form-label">'.__('Select OS').'</label><br />
														<div class="row mx-auto w-100 form-group r-pill r-pill-bg">
															';foreach($webuzo_templates as $k => $v){
																echo '
																<div class="col-lg-6 col-md-4 col-12 px-2 my-1">
																	<span class="r-pill__item">
																		<input for="input radio" type="radio" class="form-check-input" name="webuzo_os" id="webuzoos_'.$k.'" value="'.$k.'" '.(!empty($v['hvm']) ? 'hvm="1"' : '').' distro="'.$v['distro'].'">
																		<label for="freq" class="m-0" for="webuzoos_'.$k.'">'.$v['name'].'</label>
																	</span>
																</div>
																';
															}echo '
														</div>
													</div>
												</div>
												<div class="row mx-auto w-100 my-3">
													<div class="col-sm-12 px-2">
														<label class="control-label">'.__('Choose Stack').'</label><br />
														<div class="row mx-auto w-100 form-group r-pill r-pill-bg">
															<div class="col-3 px-2 my-1" id="stack1_tr">
																<span class="r-pill__item">
																	<input type="radio" class="form-check-input" name="webuzo_stack" id="stack1" value="lamp" onclick="webuzo_apps(this.value);" checked="checked">
																	<label for="freq" class="m-0" for="stack1">LAMP</label>
																</span>
															</div>
															<div class="col-3 px-2 my-1" id="stack2_tr" style="display:'.(!empty($webuzo_done['isfree']) ? 'none' : '').';"> 
																<span class="r-pill__item">
																	<input type="radio" class="form-check-input" name="webuzo_stack" id="stack2" value="lemp" onclick="webuzo_apps(this.value);">
																	<label for="freq" class="m-0" for="stack2">LEMP</label>
																</span>
															</div>
															<div class="col-3 px-2 my-1" id="stack3_tr" style="display:'.(!empty($webuzo_done['isfree']) ? 'none' : '').';">
																<span class="r-pill__item">
																	<input type="radio" class="form-check-input" name="webuzo_stack" id="stack3" value="llmp" onclick="webuzo_apps(this.value);">
																	<label for="freq" class="m-0" for="stack3">LLMP</label>
																</span>
															</div>
														</div>
													</div>
												</div>
												<div id="webuzo_stack_tr" style="display:'.(!empty($webuzo_done['isfree']) ? 'none' : '').';">
													<input type="hidden" id="script_isfree" value="0" />
													<div class="row mx-auto w-100 my-3" id="webuzo_webserver_tr">
														<div class="col-sm-12 px-2">
															<label class="form-label">'.__('Select Apache Verison').'</label><br />
															<div id="webuzo_webserver">
																<div class="row mx-auto w-100 form-group r-pill r-pill-bg">';
																foreach($webuzo_apps['webserver'] as $wk => $wv){
																echo '
																	<div class="col-lg-3 col-md-3 col-6 px-2 my-1">	
																		<span class="r-pill__item">
																			<input type="radio" class="form-check-input" name="webserver" id="serverver_'.$wk.'" value="'.$wv['softname'].'">
																			<label for="freq" class="m-0" for="serverver_'.$wk.'">'.$wv['fullname'].'</label>
																		</span>				
																	</div>';
																}
															echo '</div>
															</div>
														</div>
														
													</div>
													<div class="row mx-auto w-100 my-3">
														<div class="col-sm-12 px-2">
															<label class="form-label">'.__('Select MYSQL Version').'</label>
															<div id="webuzo_mysql">
																<div class="row mx-auto w-100 form-group r-pill r-pill-bg">';
																foreach($webuzo_apps['mysql'] as $wk => $wv){
																	echo '
																<div class="col-lg-3 col-md-3 col-6 px-2 my-1">	
																	<span class="r-pill__item">
																		<input type="radio" class="form-check-input" name="mysql" id="serverver_'.$wk.'" value="'.$wv['softname'].'">
																		<label for="freq" class="m-0" for="serverver_'.$wk.'">'.$wv['fullname'].'</label>
																	</span>			
																</div>';
																}
															echo '</div>
															</div>	
														</div>	
													</div>
													<div class="row mx-auto w-100 my-3">
														<div class="col-sm-12 px-2">
															<label class="form-label">'.__('Select PHP Version').'</label>
															<div id="webuzo_php">
																<div class="row mx-auto w-100 form-group r-pill r-pill-bg">';
																foreach($webuzo_apps['php'] as $wk => $wv){
																	echo '
																	<div class="col-lg-3 col-md-3 col-6 px-2 my-1">
																		<span class="r-pill__item">
																			<input type="radio" class="form-check-input" name="php" id="serverver_'.$wk.'" value="'.$wv['softname'].'">
																			<label for="freq" class="m-0" for="serverver_'.$wk.'">'.$wv['fullname'].'</label>
																		</span>			
																	</div>';
																}
															echo '</div>
															</div>
														</div>	
													</div>
												</div>
											</div>
										</div>
									</fieldset>
								</div>
							</div>';

						// CPU Advance option
						echo '
						<div class="card p-3 my-3">
							<div class="divroundshad">
								<fieldset class="user_details_f">
									<legend class="user_details_f mb-0">'.__('CPU').'</legend>
								';
									
									if($kernel->features('cpu_pinning', $virt)){
																			
										$cpu_pin_flag = (!empty($_POST['cpupin']) ? (is_array($_POST['cpupin']) ? '' : 'checked="checked"') : 'checked="checked"');

								echo '
									<div class="row mx-auto w-100 my-3">
										<div class="col-6 p-0">
											<label class="form-label">'.__('CPU Affinity').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Pin the particular CPU Cores to this VPS. You can choose multiple CPU Cores.').'"><i class="fas text-primary fa-info-circle"></i></a></label>
										</div>
										<div class="col-6 p-0">
											'.get_checkbox('allcores', 'Default', 'allcores', array('chk_it' => 1), -1, '', array('onchange="pincheck();"', $cpu_pin_flag));
								echo '
										</div>
									</div>
									<div id="pincores" class="row mx-auto w-100 my-3">
										<div class="col-sm-6 p-0">
											<label class="form-label">'.__('Select the vCPU').'</label>
										</div>	
										<div class="col-sm-6 p-0">';
											for($i=0; $i < $resources['cpucores']; $i++){
												$cpu_core_flag = (is_array($_POST['cpupin']) && (in_array($i, @$_POST['cpupin']) || in_array((string)$i, @$_POST['cpupin'])) ? 'checked="checked"' : '');
												echo '
												'.get_checkbox('cpupin['.$i.']', '&nbsp;vCPU '.($i+1).'&nbsp;', 'pin'.$i.'', array('chk_it' => 0), $i, '', array($cpu_core_flag));
											}
										echo '</div>
										</div>';
									}
									
									// CPU Affinity. (CPU PIN)
									if($kernel->features('numa', $virt)){
								echo '
									<div class="row mx-auto w-100 my-3">
										<div class="col-6 p-0">
											<label class="form-label">'.__('Enable NUMA').'</label>
										</div>
										<div class="col-6 p-0">
											'.get_checkbox('numa', '', 'numa').'
										</div>
									</div>';
								}
							
							if($kernel->features('cpu_mode', $_virt)){
								
								echo '
								<div class="row mx-auto w-100 my-3">
									<div class="col-sm-12 p-0">
										<label class="form-check-label">'.__('CPU Mode').'</label><br>
										<select class="custom-select" name="cpu_mode" id="cpu_mode" '.($kernel->features('cpu_flags', $_virt) ? 'onchange="prox_cpu_flags()"' : "").'>';
									
										foreach($cpu_modes as $ck => $cv){
											echo '<option value="'.$ck.'" '.POSTselect('cpu_mode', $ck).'>'.$cv.'</option>';
										}
										
									echo '
										</select>
									</div>
								</div>
								
								';
							}
							if($kernel->features('cpu_flags', $_virt) && $cluster->check_feature($globals['server'], $_virt, 'cpu_flags')){
								$cpu_flags = array(
									'md-clear',
									'pcid',
									'spec-ctrl',
									'ssbd',
									'ibpb',
									'virt-ssbd',
									'amd-ssbd', 
									'amd-no-ssb',
									'pdpe1gb',
									'hv-tlbflush',
									'hv-evmcs',
									'aes' 
								);
								echo '
								<div class="mx-3">
									<div class="row mx-auto w-100 my-3 extra_cpu_flags" style="display:none;">
										<div class="col-12 p-0">
											<label class="form-label"><small>'.__('Extra Cpu Flags').'</small></label>
										</div>
									</div>
								';
									$cpu_info_lang['md-clear-info'] = 'Required to let the guest OS know if MDS is mitigated correctly.';
									$cpu_info_lang['pcid-info'] = 'Meltdown fix cost reduction on Westmere, Sandy-, and IvyBride Intel CPUs.';
									$cpu_info_lang['spec-ctrl-info'] = 'Allowed improved Spectre mitigation with Intel CPUs.';
									$cpu_info_lang['ssbd-info'] = 'Protection for Speculative Store Bypass for Intel models.';
									$cpu_info_lang['ibpb-info'] = 'Allows improved Spectre mitigation with AMD CPUs.';
									$cpu_info_lang['virt-ssbd-info'] = 'Basis for Speculative Store Bypass protection for AMD models.';
									$cpu_info_lang['amd-ssbd-info'] = 'Improved Spectre mitigation performance with AMD CPUs, best used with virt-ssbd.';
									$cpu_info_lang['amd-no-ssb-info'] = 'Notifies guest OS that host is not vulnerable for Spectre on AMD CPUs.';
									$cpu_info_lang['pdpe1gb-info'] = 'Allow guest OS to use 1GB size pages, if host HW supports it.';
									$cpu_info_lang['hv-tlbflush-info'] = 'Improved performance in overcomitted Windows guests. May lead to guest bluescreens on old CPUs.';
									$cpu_info_lang['hv-evmcs-info'] = 'Improve performance for nested virtualization. Only supported in Intel CPUs.';
									$cpu_info_lang['aes-info'] = 'Activated AES instruction set for HW accelaration.';

									foreach($cpu_flags as $flag){
										$class = '';
										if( !empty($cpu_info['amd_cpu']['exception'][$flag])){
											$class .= ' '.implode(' ', $cpu_info['amd_cpu']['exception'][$flag]);
										}elseif(in_array($flag, $cpu_info['amd_cpu']['cpu_flags'])){
											$class .= ' '.implode(' ', $cpu_info['amd_cpu']['cpu_mode']);
										}

										if( !empty($cpu_info['intel_cpu']['exception'][$flag])){
											$class .= ' '.implode(' ', $cpu_info['intel_cpu']['exception'][$flag]);
										}elseif(in_array($flag, $cpu_info['intel_cpu']['cpu_flags'])){
											$class .= ' '.implode(' ', $cpu_info['intel_cpu']['cpu_mode']);
										}

										if( !empty($cpu_info['other_cpu']['exception'][$flag])){
											$class .= ' '.implode(' ', $cpu_info['other_cpu']['exception'][$flag]);
										}elseif(in_array($flag, $cpu_info['other_cpu']['cpu_flags'])){
											$class .= ' '.implode(' ', $cpu_info['other_cpu']['cpu_mode']);
										}
										echo '
										<div class="row mx-auto w-100 my-3 '.$flag.' '.$class.' hide_all_cpu_flags" style="display:none">
											<div class="col-5 p-0">
												<label class="form-label">'.$flag.'&nbsp;<a class="info" data-placement="right" tooltip="'.$cpu_info_lang[$flag.'-info'].'"><i class="fas text-primary fa-info-circle"></i></a></label>
											</div>
											<div class="col-2 p-0">
												<label class="custom-control custom-radio">
													<input type="radio" class="form-check-input" id="'.$flag.'-on" name="'.$flag.'" value="1"   '.POSTradio($flag, 1).'>
													<span class="custom-form-label" for="'.$flag.'">'.__('On').'</span>
												</label>
											</div>
											<div class="col-3 p-0">
												<label class="custom-control custom-radio">
													<input type="radio" class="form-check-input" id="'.$flag.'-default" name="'.$flag.'" value="0"   '.POSTradio($flag, 0).' checked="checked">
													<span class="custom-form-label" for="'.$flag.'-clear">'.__('Default').'</span>
												</label>
											</div>
											<div class="col-2 p-0">
												<label class="custom-control custom-radio">
													<input type="radio" class="form-check-input" id="'.$flag.'-off" name="'.$flag.'" value="2"   '.POSTradio($flag, 2).' >
													<span class="custom-form-label" for="'.$flag.'">'.__('Off').'</span>
												</label>
											</div>
										</div>
										';
									}
								echo '
								</div>';
								
							}
								if($kernel->features('cpu_topology', $virt)){
								echo '
									<div class="row mx-auto w-100 my-3" id="enable_cpu_topology_row">
										<div class="col-6 p-0">
											<label class="form-label">'.__('CPU Topology').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Specify the number of CPU cores, Threads and Sockets to be assigned to the VPS').'"><i class="fas text-primary fa-info-circle"></i></a></label>
										</div>
										<div class="col-6 p-0">
											'.get_checkbox('enable_cpu_topology', '', 'enable_cpu_topology', array('chk_it' => 1), 1, '', array('onchange="change_cpu_topology();"')).'
										</div>
									</div>
									<div id="cpu_topology" style="display:none;">
										<div class="row mx-auto w-100 my-3">
											<div class="col-sm-5 p-0 pr-2">
												<label class="form-label">Sockets</label><br>
												<input type="text" name="topology_sockets" id="topology_sockets" class="form-control numbersonly" value="'.POSTval('topology_sockets').'" />
											</div>
											<div class="col-sm-1 p-0">
											</div>
											<div class="col-sm-5 p-0">
												<label class="form-label">Cores</label><br>
												<input type="number" class="form-control numbersonly" name="topology_cores" id="topology_cores" value="'.POSTval('topology_cores').'" />
											</div>	
										</div>';	
										
										if($kernel->features('cpu_threads', $virt)){
									echo '	<div class="row mx-auto w-100 my-3">
												<div class="col-sm-5 p-0">
													<label class="form-label">Threads</label><br>
													<input type="number" class="form-control numbersonly" name="topology_threads" id="topology_threads" value="'.POSTval('topology_threads').'" />
												</div>
											</div>';
										}
								echo '
										
									</div>';
									}
								echo'
									<div class="row mx-auto w-100 my-3">
										<div class="col-6 p-0">
											<label class="form-label">'.__('CPU Threshold ').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('The CPU Threshold Notifies admin when a predefined threshold of CPU usage is crossed ').'"><i class="fas text-primary fa-info-circle"></i></a></label>
										</div>
										<div class="col-6 p-0">
											'.get_checkbox('show_enable_cpu_threshold', '', 'enable_cpu_threshold', array('chk_it' => 1, 'name' => 'enable_cpu_threshold'), 1, '', array('onchange="checkcputhreshold();"')).'
											<input type="hidden" name="enable_cpu_threshold" id="hidden_enable_cpu_threshold">
										</div>
									</div>
									<div id="cputhresholdpercentage" class="input-group" style="display:none;">
										<div class="row mx-auto w-100 my-3">
											<div class="col-sm-6 p-0">
												<label class="form-label">'.__('CPU Threshold Percentage').'</label>
											</div>
											<div class="col-sm-6 p-0 input-group">
												<input type="number" min="0" max="100" class="form-control" name="cpu_threshold" id="cpu_threshold" size="6" value="'.POSTval('cpu_threshold', intval($newvs['data']['cpu_threshold'])).'"/> 
												<div class="input-group-append">
													<span class="input-group-text">%</span>
												</div>
											</div>
										</div>
										<div class="row mx-auto w-100">
											<div class="col-sm-6 p-0">
												<label class="form-label">'.__('CPU Threshold Time').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('The threshold time is divided by 5, and we will check the CPU usage on each interval. If CPU usage is above the threshold value for each interval then at the last interval we will suspend the VPS').'"><i class="fas text-primary fa-info-circle"></i></a></label>
											</div>
											<div class="col-sm-6 p-0 input-group">
												<input type="number" min="0" class="form-control" name="cpu_threshold_time" id="cpu_threshold_time" size="30" value="'.POSTval('cpu_threshold_time', intval($newvs['data']['cpu_threshold_time'])).'"/> 
												<div class="input-group-append">
													<span class="input-group-text">
													<i class="fas fa-stopwatch" style="color: #000000;"></i>
													</span>
												</div>
											</div>
										</div>
									</div>';
							echo '
								</fieldset>
							</div>
						</div>';

							//Misicellaneous options start
							echo '
						<div class="card p-3 my-3">
							<div class="divroundshad">
								<fieldset class="user_details_f">
									<legend class="user_details_f mb-0">'.__('Miscellaneous settings').'</legend>';
								// 		if($kernel->features('enable_guest_agent', $_virt)){
												
								// echo '
								// 		<div class="row mx-auto w-100 my-3">
								// 			<div class="col-6 p-0">
								// 				<label class="control-label">'.__('Disable Guest Agent').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If enabled, then few operations like password change, fetch ram and disk actual usage will not be possible on live machine').'"><i class="fas text-primary fa-info-circle"></i></a></label>
								// 			</div>
								// 			<div class="col-6 p-0">
								// 				'.get_checkbox('disable_guest_agent', '', 'disable_guest_agent', array('chk_it' => 1, 'name' => 'disable_guest_agent')).'
								// 			</div>
								// 		</div>';

								// 	}

									if($kernel->features('bios', $_virt)){
										
										echo '
										<div class="row mx-auto w-100 my-3">
											<div class="col-sm-12 p-0">
												<label class="form-label">'.__('Bios').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Choose bios to boot from. Default will be seabios').'"><i class="fas text-primary fa-info-circle"></i></a></label><br>
												<select class="custom-select" onchange="toggle_bios();"  name="bios" id="bios" >
													<option value="seabios" '.POSTselect('bios', 'seabios').' selected="selected">SeaBios (Default)</option>
													<option value="uefi" '.POSTselect('bios', 'uefi').'>UEFI (OVMF)</option>
												</select>
											</div>
										</div>
										<div class="row mx-auto w-100 my-3" id="tpm_row" style="display:none">
											<div class="col-6 p-0">
												<label class="form-label">'.__('Enable TPM').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If checked TPM will be enabled').'"><i class="fas text-primary fa-info-circle"></i></a></label>
											</div>
											<div class="col-6 p-0">
												'.get_checkbox('enable_tpm', '', 'enable_tpm', array('chk_it' => 1, 'name' => 'enable_tpm')).'
											</div>
										</div>';
									}

									if($kernel->features('xenserver_tools', $_virt)){
								
								echo '
									<div class="row mx-auto w-100 my-3">
										<div class="col-6 p-0">
											<label class="form-label">'.__('Install Xentools').'</label>
										</div>
										<div class="col-6 p-0">
											'.get_checkbox('install_xentools', '', 'install_xentools').'	
										</div>
									</div>';
									}

									if($kernel->features('win_support', $_virt)){						
								echo '
									<div id="enable_rdp" class="row mx-auto w-100 my-3">
										<div class="col-6 p-0">
											<label class="form-label">'.__('Enable RDP').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Enable Remote Desktop Connection (For Windows VPS)').'"><i class="fas text-primary fa-info-circle"></i></a></label>
										</div>
										<div class="col-6 p-0">
											'.get_checkbox('show_rdp', '', 'rdp', array('chk_it' => 1, 'name' => 'rdp'), 1, '', array('onchange="change_checkbox(\'rdp\');"')).'
											<input type="hidden" name="rdp" id="hidden_rdp">
										</div>
									</div>';
									}
									if($kernel->features('nested_virt', $virt)){
								echo '
									<div class="row mx-auto w-100 my-3 hide_for_plan">
										<div class="col-6 p-0">
											<label class="form-label">'.__('Enable Nested Virtualization').' :&nbsp;<a class="info" data-placement="right" tooltip="'.__('This feature is experimental and tested only on Linux guests. Operation of nested virtual machines may be unstable.').'"><i class="fas text-primary fa-info-circle"></i></a></label><br />
										</div>
										<div class="col-6 p-0">
											'.get_checkbox('show_nested_virt', '', 'nested_virt', array('chk_it' => 1, 'name' => 'nested_virt'), 1, '', array('onchange="change_checkbox(\'nested_virt\');"')).'
											<input type="hidden" name="nested_virt" id="hidden_nested_virt">
										</div>
									</div>';
									}
								if($kernel->features('pci_passthrough', $virt)){
									echo 
									'<div class="row mx-auto w-100 my-3">
										<label class="form-label">'.__('PCI passthrough').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('This allows a VPS to have exclusive access to the PCI device').'"><i class="fas text-primary fa-info-circle"></i></a></label><br />
										<div class="col-12 p-0 server-select-lg">
											<select class="form-control choosen" name="pcis[]" id="pci" multiple="multiple" style="width:100%">';
												foreach($pcis as $iommu_grp_num => $v){
													echo '<optgroup label="IOMMU Grp'.$iommu_grp_num.'">';
														foreach($v as $sk => $sv){
															echo'<option value="'.$sk.'" >'.substr(trim($sv), 0, -1).'</option>';
														}
													echo'</optgroup>';
												}
											echo '</select>
										</div>
									</div>';
								}
								
								// <!-- Multi USB devices -->
								if($kernel->features('usb_passthrough', $virt)){
									echo 
									'<div class="row mx-auto w-100 my-3">
										<label class="form-label">'.__('USB Passthrough').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('This allows a VPS to have exclusive access to the USB device').'"><i class="fas text-primary fa-info-circle"></i></a></label><br />
										<div class="col-12 p-0 server-select-lg">
											<select class="form-control choosen" name="usbs[]" id="usb" multiple="multiple" style="width:100%">';
											
												foreach($usbs as $k => $v){
													echo '<option value="'.$k.'" >['.$v['pid'].'] '.$v['name'].'</option>';
												}
								 
											echo '</select>
										</div>
									</div>';
								}
									// Only available for XEN-HVM
									if(($virt == 'xen' && !empty($hvm)) && distro_check(0, 1, 1, 0, 1)){
										// PV-on-HVM drivers
								echo '
									<div id="tr_pvonhvm" class="row mx-auto w-100 my-3">
										<div class="col-6 p-0">
											<label class="form-label">'.__('PV-on-HVM driver Support').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('The primary goal of PV on HVM is to boost performance of fully virtualized HVM guests through use of specially optimized paravirtual device drivers').'"><i class="fas text-primary fa-info-circle"></i></a></label>
										</div>
										<div class="col-6 p-0">
											'.get_checkbox('show_pv_on_hvm', '', 'pv_on_hvm', array('chk_it' => 1, 'name' => 'pv_on_hvm'), 1, '', array('onchange="ispvonhvm();"')).'
											<input type="hidden" name="pv_on_hvm" id="hidden_pv_on_hvm">
										</div>
									</div>';
									}
								echo '
									<div class="row mx-auto w-100 my-3 hide_for_plan">
										<div class="col-6 p-0">
											<label class="form-label">'.__('Managed by Admin').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If checked, VPS can not be managed from Enduser Panel.').'"><i class="fas text-primary fa-info-circle"></i></a></label><br />
										</div>
										<div class="col-6 p-0">
											'.get_checkbox('show_admin_managed', '', 'admin_managed', array('chk_it' => 1, 'name' => 'admin_managed'), 1, '', array('onchange="change_checkbox(\'admin_managed\');"')).'
											<input type="hidden" name="admin_managed" id="hidden_admin_managed">
										</div>
									</div>
								';
								if($kernel->features('nesting', $virt)){

									echo'<div class="row mx-auto w-100 my-3">
										<div class="col-6 p-0">
											<label class="control-label">'.__('Nesting').'</label><br>
										</div>
										<div class="col-6 p-0">
											'.get_checkbox('nesting', '', 'nesting', array('chk_it' => 1), 1).'
										</div>
									</div>';
									
								}

								if($kernel->features('vps_autostart', $virt)){
									echo '
									<div class="row mx-auto w-100 my-3 w-100">
											<div class="col-6 p-0">
												<label class="control-label">'.__('Disable Autostart').' &nbsp;<a class="info" data-placement="right" tooltip="'.__('If enabled then VPS will not autostart in case of node reboot').'"><i class="fas text-primary fa-info-circle"></i></a></label>
											</div>
											<div class="col-2 p-0">
												'.get_checkbox('show_disable_autostart', '', 'disable_autostart', array('chk_it' => 0, 'name' => 'disable_autostart', 'val' => 0), 1, '', array('onchange="change_checkbox(\'disable_autostart\');"')).'
												<input type="hidden" name="disable_autostart" id="hidden_disable_autostart">
											</div>
									</div>';
								}

									if(($kernel->features('vga_vram', $virt)) && !distro_check(0, 0, 0, 0, 1)){
						
								echo'		
									<div class="row mx-auto w-100 my-3">
										<div class="col-6 p-0">
											<label class="form-check-label">'.__('Enable VGA').'</label>
										</div>
										<div class="col-6 p-0">
											'.get_checkbox('show_kvm_vga', '', 'kvm_vga', array('chk_it' => 1, 'name' => 'kvm_vga'), 1, '', array('onchange="enable_accel();"')).'
											<input type="hidden" name="kvm_vga" id="hidden_kvm_vga">
										</div>
									</div>';
		
								echo '
									<div class="row mx-auto w-100 my-3" id="set_vga_vram" style="display:none;">
										<div class="col-sm-12 p-0">
											<label class="form-label">'.__('Set vram').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Set vram for VGA in MB. If not defined or set as 0, vram value will be set as 8MB').'"><i class="fas text-primary fa-info-circle"></i></a></label><br>
											<div class="input-group">
												<input type="number" min="0" class="form-control" name="vga_vram" id="vga_vram" size="30" value="'.POSTval('vga_vram', '').'" />
												<div class="input-group-append">
													<span class="p-1 pt-0 input-group-text">  '.__('MB').'</span>
												</div>
											</div>
										</div>
									</div>';
			
								echo '
									<div class="row mx-auto w-100 my-3" id="enable_acceleration" style="display:none;">
										<div class="col-6 p-0">
											<label class="form-label">'.__('Enable Acceleration').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If checked then 2D and 3D acceleration will be enabled for the VPS').'"><i class="fas text-primary fa-info-circle"></i></a></label>
										</div>
										<div class="col-6 p-0">
											'.get_checkbox('show_acceleration', '', 'acceleration', array('chk_it' => 1, 'name' => 'acceleration'), 1, '', array('onchange="change_checkbox(\'acceleration\');"')).'
											<input type="hidden" name="acceleration" id="hidden_acceleration">
										</div>
									</div>';
									
									}

									if($kernel->features('vnc_key_map', $_virt)){
								echo '
									<div class="row mx-auto w-100 my-3">
										<div class="col-sm-12 p-0">
											<label class="form-label">'.__('VNC Console Keymap').'</label><br>
											<select class="custom-select virt-select" name="vnc_keymap" id="vnc_keymap">
												<option value="en-us" '.POSTselect('vnc_keymap', 'en-us').'>en-us</option>
												<option value="de-ch" '.POSTselect('vnc_keymap', 'de-ch').'>de-ch</option>
												<option value="ar" '.POSTselect('vnc_keymap', 'ar').'>ar</option>
												<option value="da" '.POSTselect('vnc_keymap', 'da').'>da</option>
												<option value="et" '.POSTselect('vnc_keymap', 'et').'>et</option>
												<option value="fo" '.POSTselect('vnc_keymap', 'fo').'>fo</option>
												<option value="fr-be" '.POSTselect('vnc_keymap', 'fr-be').'>fr-be</option>
												<option value="fr-ch" '.POSTselect('vnc_keymap', 'fr-ch').'>fr-ch</option>
												<option value="hu" '.POSTselect('vnc_keymap', 'hu').'>hu</option>
												<option value="it" '.POSTselect('vnc_keymap', 'it').'>it</option>
												<option value="lt" '.POSTselect('vnc_keymap', 'lt').'>lt</option>
												<option value="mk" '.POSTselect('vnc_keymap', 'mk').'>mk</option>
												<option value="nl" '.POSTselect('vnc_keymap', 'nl').'>nl</option>
												<option value="no" '.POSTselect('vnc_keymap', 'no').'>no</option>
												<option value="pt" '.POSTselect('vnc_keymap', 'pt').'>pt</option>
												<option value="ru" '.POSTselect('vnc_keymap', 'ru').'>ru</option>
												<option value="sv" '.POSTselect('vnc_keymap', 'sv').'>sv</option>
												<option value="tr" '.POSTselect('vnc_keymap', 'tr').'>tr</option>
												<option value="de" '.POSTselect('vnc_keymap', 'de').'>de</option>
												<option value="en-gb" '.POSTselect('vnc_keymap', 'en-gb').'>en-gb</option>
												<option value="es" '.POSTselect('vnc_keymap', 'es').'>es</option>
												<option value="fi" '.POSTselect('vnc_keymap', 'fi').'>fi</option>
												<option value="fr" '.POSTselect('vnc_keymap', 'fr').'>fr</option>
												<option value="fr-ca" '.POSTselect('vnc_keymap', 'fr-ca').'>fr-ca</option>
												<option value="hr" '.POSTselect('vnc_keymap', 'hr').'>hr</option>
												<option value="is" '.POSTselect('vnc_keymap', 'is').'>is</option>
												<option value="ja" '.POSTselect('vnc_keymap', 'ja').'>ja</option>
												<option value="lv" '.POSTselect('vnc_keymap', 'lv').'>lv</option>
												<option value="nl-be" '.POSTselect('vnc_keymap', 'nl-be').'>nl-be</option>
												<option value="pl" '.POSTselect('vnc_keymap', 'pl').'>pl</option>
												<option value="pt-br" '.POSTselect('vnc_keymap', 'pt-br').'>pt-br</option>
												<option value="sl" '.POSTselect('vnc_keymap', 'sl').'>sl</option>
												<option value="th" '.POSTselect('vnc_keymap', 'th').'>th</option>
											</select>
										</div>
									</div>';
									}
								echo '<!-- Multi Recipe -->
									<div class="row mx-auto w-100 my-3">
											<div class="col-sm-12 p-0">
												<label class="form-label">'.__('Recipe').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Select the recipe to be executed inside the VPS after creation').'"><i class="fas text-primary fa-info-circle"></i></a></label><br />
												<select class="form-control" name="recipe[]" id="recipe" multiple="multiple" style="width:100%">';
									
													foreach($recipes as $k => $v){
														echo '<option value="'.$k.'" >'.$v['name'].'</option>';
													}
									
												echo '</select>
											</div>
									</div>';
								// OS Reinstall
								echo '
									<div class="row mx-auto w-100 my-3">
										<div class="col-sm-12 p-0">
											<label class="form-label">'.__('OS Reinstall Limit').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If you want to limit the number of OS re-installs per month. <br />Eg. 0 - is unlimited').'"><i class="fas text-primary fa-info-circle"></i></a></label><br>
											<input type="text" class="form-control" name="osreinstall_limit" id="osreinstall_limit"  value="'.POSTval('osreinstall_limit', '').'"/>
										</div>
									</div>';

									$os_type = $kernel->features('os_type', $virt);
									if(!empty($os_type)){
									
								echo '
										<div class="row mx-auto w-100 my-3 ">
											<div class="col-sm-12 p-0">
												<label class="form-label">'.__('Select OS Type').' &nbsp;<a class="info" data-placement="right" tooltip="'.__('Setting the proper Operating System(OS) allows Proxmox VE to optimize some low level parameters').'"><i class="fas text-primary fa-info-circle"></i></a></label><br>
												<select class="custom-select virt-select" name="os_type" id="os_type">';
													foreach($os_type as $os_value => $os_full_form){
														echo '<option value="'.$os_value.'" '.POSTselect('os_type', $os_value).'>'.$os_full_form.'</option>';
													}
											echo'	</select>
											</div>
										</div>';
									}
																
									if($kernel->features('machine_type', $virt)){
								echo '
										<div class="row mx-auto w-100 my-3">
											<div class="col-sm-12 p-0">
												<label class="form-label">'.__('Machine Type').'</label><br>
												<select class="custom-select virt-select" name="machine_type" id="machine_type">';
												echo '<option value="" '.(POSTval('machine_type') == '' ? 'selected="selected"' : '').'>'.__('None').'</option>';
												foreach($machine_type as $k => $v){
													echo '<option value="'.$v.'" '.POSTselect('machine_type', $v).'>'.$v.'</option>';
												}
												echo '
												</select>
											</div>
										</div>';
									}
									if($kernel->features('vga', $virt)){

								echo '
										<div class="row mx-auto w-100 my-3">
											<div class="col-sm-12 p-0">
												<label class="form-label">'.__('Graphic Card').'</label><br>
												<select class="custom-select virt-select" name="vga" id="vga">';
													foreach($vga as $vk => $vv){
														echo '<option value="'.$vk.'" '.POSTselect('vga', $vk).'>'.$vv.'</option>';
													}
												echo '</select>
											</div>
										</div>
										<div class="row mx-auto w-100 my-3">
											<div class="col-sm-12 p-0">
												<label class="form-label">'.__('Graphic Card Memory (MB)').'<a class="info" data-placement="right" tooltip="'.__('Graphir Card Memory should be less then or equal to 512').'"><i class="fas text-primary fa-info-circle"></i></a></label><br>
												<input type="number" min="0" max="512" class="form-control" name="vga_memory" id="vga_memory" value="'.POSTval('vga_memory', '').'" />
											</div>
										</div>';
									}
								
									if(!empty($isos) && $kernel->features('sec_iso_support', $virt)){
									
								echo '
									<div class="row mx-auto w-100 my-3">
										<div class="col-sm-12 p-0">
											<label class="form-label">'.__('ISO for secondary CDROM ').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Select an ISO for secondary CDROM').'"><i class="fas text-primary fa-info-circle"></i></a></label><br>
											<select class="custom-select virt-select w-100" name="sec_iso" id="sec_iso">
												<option value="0" '.(POSTval('sec_iso') == 0 ? 'selected="selected"' : '').'>'.__('None').'</option><optgroup label="'.__('Admin ISOs').'">';							
													foreach($isos as $k => $v){
														echo '<option value="'.$k.'" '.(POSTval('sec_iso') == $k ? 'selected="selected"' : '').'>'.$v['name'].'</option>';
													}
									
												echo'</optgroup></select>
										</div>
									</div>';
									}
									
									if($virt == 'xen'){
								echo '
									<div id="tr_viftype" class="row mx-auto w-100 my-3">
										<div class="col-sm-12 p-0">
										<label class="form-label">'.__('Virtual Network Interface Emulation type').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If you want to change the network interface emulation type. Options are <b>netfront</b> or <b>ioemu</b>.').'"><i class="fas text-primary fa-info-circle"></i></a></label><br>
											<div class="row mx-auto w-100 w-100 my-0">
												<div class="col-sm-6 p-0">
													<label class="custom-control custom-radio">
													<input type="radio" class="form-check-input" name="vif_type" id="netfront"  value="netfront" '.POSTradio('vif_type', 'netfront', 'netfront').'>
													<span class="custom-form-label" for="netfront">'.__('netfront (default)').'</span>
													</label>
												</div>
												<div class="col-sm-6 p-0">
													<label class="custom-control custom-radio">
													<input type="radio" class="form-check-input" name="vif_type" id="ioemu"  value="ioemu" '.POSTradio('vif_type', 'ioemu').'>
													<span class="custom-form-label" for="ioemu">'.__('ioemu').'</span>
													</label>
												</div>
											</div>
										</div>
									</div>';
									}
								
									if($kernel->features('rtc', $virt)){
										$rtc = array('0' => __('Disable'),
												'1' => __('Enable')
												);
									echo '
										<div class="row mx-auto w-100 my-3 ">
											<div class="col-sm-12 p-0">
												<label class="form-label">'.__('RTC').' &nbsp;<a class="info" data-placement="right" tooltip="'.__('Set RTC local time. By default for Windows it is enabled').'"><i class="fas text-primary fa-info-circle"></i></a></label><br>
												<select class="custom-select virt-select" name="rtc" id="rtc">';
													foreach($rtc as $bol => $options){
														echo '<option value="'.$bol.'" '.POSTselect('rtc', $bol).'>'.$options.'</option>';
													}
									echo'	</select>
											</div>
										</div>';
									}

									if($kernel->features('unprivileged', $virt)){
										$unprivileged = array('0' => __('Disable'),
												'1' => __('Enable')
												);
										echo '
										<div class="row mx-auto w-100 my-3 ">
											<div class="col-sm-12 p-0">
												<label class="form-label">'.__('Unprivileged').' &nbsp;<a class="info" data-placement="right" tooltip="'.__('Create unprivileged Container. NOTE: You cannot change the unprivileged state once VPS is created').'"><i class="fas text-primary fa-info-circle"></i></a></label><br>
												<select class="custom-select virt-select" name="unprivileged" id="unprivileged">';
													foreach($unprivileged as $bol => $options){
														echo '<option value="'.$bol.'" '.POSTselect('unprivileged', $bol).'>'.$options.'</option>';
													}
											echo'	</select>
											</div>
										</div>';
									}
									
									if(!empty($backup_plans)){		
								echo '
									<div class="row mx-auto w-100 my-3">
										<div class="col-sm-12 p-0">
											<label class="control-label">'.__('Backup Plan').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Select pre-defined Backup Plan').'"><i class="fas text-primary fa-info-circle"></i></a></label><br>
											<select class="custom-select virt-select" name="bpid">
													<option value="0" '.POSTselect('bpid', 0).'>'.__('None').'</option>
													<option value="-1" '.POSTselect('bpid', -1, true).'>'.__('Same as VPS Plan').'</option>';
											foreach($backup_plans as $bk => $bv){		 
													echo '
													<option value="'.$bk.'" '.POSTselect('bpid', $bk).'>'.$bv['plan_name'].'</option>';
												}
											echo '
											</select>
										</div>
									</div>';
									}

								if(!empty($firewall_plans)){
									echo '<div class="row mx-auto w-100 my-3"> 
									<div class="col-sm-12 p-0">
										<label class="form-label">'.__('Firewall Plan').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Select Firewall Plan for VPS').'"><i class="fas text-primary fa-info-circle"></i></a></label>
										<br /><select class="custom-select chosen" id="admin_fwid" name="admin_fwid">
										<option value="0" '.(empty($fwpid) ? 'selected="selected"' : '').'>'.__('None').'</option>';
										$current_user = -1;
										foreach($firewall_plans as $k => $v){
											$firewall_plan_creator = empty($v["uid"]) ? "root" : $firewall_users[(int)$v["uid"]];
											if($current_user != $v['uid']){
												if($current_user != -1){
													echo '</optgroup>';
												}	
												echo '<optgroup label="'.$firewall_plan_creator.'">';
												$current_user = $v['uid'];
											}
											echo '<option value="'.$k.'" '.POSTselect('fwid', $k).'>'.$v['fw_plan_name'].'</option>';
										}
										echo '</optgroup>';
									echo '</select>
									</div>
								</div>';
								}
								echo '
									<div class="row mx-auto w-100 my-3 hide_for_plan">
										<div class="col-sm-12 p-0">
											<label class="form-label">'.__('Media Groups').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If no Media Group is assigned then all Media will be available to this VPS.').'"><i class="fas text-primary fa-info-circle"></i></a></label><br><select class="virt-select" name="mgs[]" id="mg" multiple="multiple">';
												
												foreach($mgs as $mk => $mv){
													if(strpos($_virt, $mv['mg_type']) === false) continue;
													echo '<option value="'.$mk.'" type="'.$mv['mg_type'].'" '.(in_array($mk, @$_POST['mgs']) ? 'selected="selected"' : '').'>'.$mv['mg_name'].'</option>';
												}
												
											echo '</select>
										</div>
									</div>';
								if($kernel->features('boot_order', $virt)){
									echo'
										<div class="row mx-auto w-100 my-3 ">
											<div class="col-sm-12 p-0">
												<label class="form-label">'.__('Boot order').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Choose the order from which disk the VPS will boot (Note: This is only for Boot order changes. Disks will be considered as they were while VPS  creation)').'"><i class="fas text-primary fa-info-circle"></i></a></label><br>
													<div class="input-group w-100">
														<select class="form-control" name="bootorder" id="bootorder" size="4">
															<option value="disk1" id="disk1" >DISK1</option>
														</select>
														<div class="input-group-append w-50">
															<div class="d-flex flex-column mb-3">
																<div class="p-2">
																	<button type="button" id="up" onclick="change_bootorder(this)" class="btn"><i class="fas fa-arrow-up"></i></button>
																</div>
																<div class="p-2">
																	<button type="button" id="down" onclick="change_bootorder(this)" class="btn"><i class="fas fa-arrow-down"></i></button>
																</div>
															</div>
														</div>
													</div>
											</div>
										</div>';
								}
									echo '</fieldset>
								</div>
							</div>
						</div>
					</div>
				</div>	
			</div>
		</div>
	</div>
</div>	
<!-- advance settings close -->
';
// Do we have multiple virt




echo '

<script type="text/javascript">
$("fieldset.user_details_f").each(function(i, obj) {
	if($(this).children("div").length <= 0){
		$(this).hide();
		$(this).parent().parent().hide();
	}
});



function netspeed(r){
	$_("network_speed").value = (r);
	handle_capping();
}
function upspeed(r){
	$_("upload_speed").value = (r);
	handle_capping();
}
</script><br>
<center><input type="submit" class="go_btn" name="addvps" value="'.__('Add Virtual Server').'"/></center>
</div>';

// CPU Units HTML Output
//-------------------------------------------------------------------------------------------------------------------------------
echo'
<br /><br />
</form>
<div id="progress_onload"></div>
';

}

}// End of Server Offline if

echo '</div>';
softfooter();
echo '
<div id="processing_symb"><div class="loader-lg"></div></div>
';

}

?>
