<?php

//////////////////////////////////////////////////////////////
//===========================================================
// addplan_theme.php
//===========================================================
// SOFTACULOUS VIRTUALIZOR
// Version : 1.0
// Inspired by the DESIRE to be the BEST OF ALL
// ----------------------------------------------------------
// Started by: Alons
// Date:       8th Mar 2010
// Time:       23:00 hrs
// Site:       https://www.virtualizor.com/ (SOFTACULOUS VIRTUALIZOR)
// ----------------------------------------------------------
// Please Read the Terms of use at https://www.virtualizor.com
// ----------------------------------------------------------
//===========================================================
// (c)Softaculous Ltd.
//===========================================================
//////////////////////////////////////////////////////////////

if(!defined('VIRTUALIZOR')){

	die('Hacking Attempt');

}

function addplan_theme(){

global $theme, $globals, $kernel, $user, $l, $error, $done, $_ubc, $mgs, $isos, $oslist, $vnc_keymap_array, $plans, $recipes, $backup_plans, $supported_nics, $servergroups, $ippools, $bus_driver_list, $ostemplates, $bios, $cpu_modes, $cpu_info, $firewall_plans, $firewall_users, $custom_cp;

$nics_lang = [
	'default' => __('Realtek 8139(default)'),
	'e1000' => __('Intel E1000'),
	'ne2k_pci' => __('Novell NE2000'),
	'virtio' => __('Virtio'),
	'i82559er' => __('Intel i82559er'),
	'pcnet' => __('AMD PCNET'),
	'ne2k_isa' => __('Novell E2000 ISA'),
	'vmxnet3' => __('VMware vmxnet3')
];

//Is Ajax Mode on?
if(optGET('ajax')){

	$planid = optGET('plan_template');
	
	// Creating the DB Column name => html field name array
	echo 'var odd_plans = {"virt" : "cplan", "space" : "disk_space", "ram" : "guaranteed_ram", "burst" : "burst_ram", "swap" : "swapram", "cpu" : "cpu_units", "cores" : "cpu_cores", "cpu_percent" : "percent_cpu", "io" : "priority" };';
	echo 'var $plan = new Object();';
	foreach($plans[$planid] as $k => $v){
		
		if($k == 'dns_nameserver'){
			echo '$plan["dns_nameserver"] = '.json_encode(unserialize($v)).';';
			continue;
		}
		if($k == 'mgs'){
			$tmp_mgs = cexplode(',', $v);
			echo '$plan["mgs"] = '.json_encode($tmp_mgs).';';
			continue;
		}
		
		if($k == 'ubc'){
			echo '$plan["ubc"] = '.json_encode(unserialize($v)).';';
			continue;
		}

		if($k == 'ippoolid'){
			echo '$plan["ippoolid"] = '.json_encode(unserialize($v)).';';
			continue;
		}
		
		if($k == 'recipe'){
			
			$v = (is_numeric($v) ? array($v) : $v);
			echo '$plan["recipe"] = '.json_encode(unserialize($v)).';';
			continue;
			
		}

		if($k == 'data' && !empty($v)){
			echo '$plan["data"] = '.json_encode(json_decode($v, 1)).';';
			continue;
		}

		if($k == 'speed_cap' && !empty($v)){
			$v = _unserialize($v);
			echo '$plan["speed_cap_down"] = '.$v['down'].';
				$plan["speed_cap_up"] = '.$v['up'].';
			';
			continue;
		}
		
		echo '$plan["'.$k.'"] = "'.str_replace('"', '\"', $v).'";';
	}

	echo '$plan["support_nic"] = new Object();';
	foreach($supported_nics as $k => $v){
		echo '$plan["support_nic"]["'.$v.'"] = "'.(!empty($nics_lang[$v]) ? $nics_lang[$v] : $v).'";';
	}
	echo '$plan["bus_driver_list"] = new Object();';
	foreach($bus_driver_list as $k => $v){
		echo '$plan["bus_driver_list"]["'.$k.'"] = "'.$v.'";';
	}
	return true;
}

if(optGET('getparams')){
	
	echo 'var $supported_nics = new Object();';
	foreach($supported_nics as $k => $v){
		echo '$supported_nics["'.$v.'"] = "'.(!empty($nics_lang[$v]) ? $nics_lang[$v] : $v).'";';
	}
	echo 'var $bus_driver_list = new Object();';
	foreach($bus_driver_list as $k => $v){
		echo '$bus_driver_list["'.$k.'"] = "'.$v.'";';
	}

	echo 'var $bios = new Object();';
	foreach($bios as $k => $v){
		echo '$bios["'.$k.'"] = "'.$v.'";';
	}
	return true;
}

softheader($l['<title>']);
					
echo page_header(__('Add Plan'), 'fas fa-clipboard',$globals['docs'].'adding-a-plan/', 0, 0, '');

$breadcrumbs = array('dashboard', 'lm_plans', 'lms_addplan');

echo get_breadcrumb($breadcrumbs);

error_handle($error);
if(!empty($done)){
	show_alert(__('The Plan has been saved. Return to <a href="index.php?act=plans">Plans Overview</a>'), "0", "plans");
	//echo '<div class="notice"><b>'.__('Note').' : </b> &nbsp; '..'</div>';
}

echo '<script language="javascript" type="text/javascript">

var servergroups = '.json_encode($servergroups).';

function prox_cpu_flags(){

	let virt = $("#virt_select").val();
	if(virt != "proxk"){
		return false;
	}
	let cpu = $("#cpu_mode").val();
	$(".hide_all_cpu_flags").hide();
	$("."+cpu).show();
	
}

function toggle_advoptions(ele){
	
	var div_ele = $("#"+ele+"_advoptions");

	if (div_ele.is(":hidden")){
		$("#"+ele+"_advoptions_ind").text(" - ");
		div_ele.slideDown("slow");
	}
	else{
		$("#"+ele+"_advoptions_ind").text(" + ");
		div_ele.slideUp("slow");
	}
}
function adddnsrow(id, val){

	var t = $_(id);
	var ele = document.createElement("div");
    ele.setAttribute("class","row mx-auto w-100 my-1");
    ele.innerHTML=\'<div class="col-sm-11 p-0"><input type="text" class="form-control w-100" name="dns[]"  value="\'+(val || "")+\'"  size="20" /></div><div class="col-sm-1 p-0">&nbsp;&nbsp;<a class="deldns" ><i class="fas fa-times text-danger cursor-pointer py-2"></i></a></div>\';
    t.appendChild(ele);

    var sp = document.createElement("span");
    sp.setAttribute("class","help-block");
	t.appendChild(sp);		
	del_dns_div("deldns");
};

function changeplan(plan, is_from_plan = 0){
	$(".ver_scale_settings").hide();
	$("#enable_ver_scaling").prop("checked", false);
	$(".openvz, .kvm, .xen, .xenhvm, .xcp, .xcphvm, .lxc, .vzk, .vzo, .proxo, .proxl, .proxk").hide();
	$("." + plan).show();
	
	$("#disk_space_col").attr("class", "");
	if(plan == "proxk"){
		$("#disk_space_col").attr("class", "col-sm-3 pr-0");
		$("#disk_space").css("width", "50%");
	}else{
		$("#disk_space_col").attr("class", "col-sm-6 p-0");
		$("#disk_space").css("width", "");
	}
	
	$("#mgs option").each(function(){
		if($(this).attr("type") != plan){
			$(this).attr("disabled","disabled");
			$(this).css("display","none");
		}else{
			$(this).attr("disabled", false);
			$(this).css("display","block");
		}
	});
	
	// if call is from plan than do not call ajax
	if(is_from_plan){
		return;
	}

	ispvonhvm();
	ishvm();
	prox_cpu_flags();
	if(AJAX("'.$globals['index'].'act=addplan&getparams=true&virt="+plan, "handleparams(re)")){
		return false;
	}else{
		return true;	
	}
};

function handleparams(re){
	eval(re);
	
	var sel_opts = "";
	
	$.each($supported_nics, function(index, value){
		sel_opts += "<option value=\""+index+"\">"+value+"</option>";
	});
	
	$(".nic_type").html(sel_opts);	

	var bus_driver_opts = "";
	
	$.each($bus_driver_list, function(index, value){
		bus_driver_opts += "<option value=\""+index+"\">"+value+"</option>";
	});
	
	$("#bus_driver").html(bus_driver_opts);

	toggle_driver_num($("#bus_driver").val());

	var bios_opts = "";
	
	$.each($bios, function(index, value){
		bios_opts += "<option value=\""+index+"\" >"+value+"</option>";
	});
	
	$("#bios").html(bios_opts);
};

function changepriority(priority){
	if(!$("#prior")){
		return;
	}
	if (priority != ""){
		$_("prior").value = priority;
	}
};

function ishvm(){
	var hvm = false;
	var tmp_hvm = $("#virt_select").val();
	var n = tmp_hvm.search(/hvm/i); 
	if(n > 0){
		hvm = true;
	}
	
	if($_("isorow")){
		$_("sec_iso_div").style.display = "none";
		if(hvm == true || tmp_hvm == "kvm" || tmp_hvm == "vzk" || tmp_hvm == "proxk"){
			$_("isorow").style.display = "";
		}else{
			$_("isorow").style.display = "none";
		}
	}

	// Secondary ISO support is not for all virts
	if(tmp_hvm == "kvm" || tmp_hvm == "vzk" || tmp_hvm == "proxk"){
		if($("#sec_iso_div").length > 0){
			$_("sec_iso_div").style.display = "";
		}
	}
	
	$("#osid").select2("destroy");
	$("#osid").select2({
		width:"100%",
		templateResult: function(option) {
			var myOption = $("#osid").find("option[value=\"" + option.id + "\"]");
			
			if ((myOption.attr("virt") != "undefined") && (hvm == true || hvm == false) && (myOption.attr("virt") == tmp_hvm)) {
				return option.text;
			}else if ((myOption.attr("value") == 0)) {
				return option.text;
			}
		}
	});

	//alert(vpsid + " -- " + hvm)
	
	return false;
};

function loadplan(plan_template_id){
	
	if(plan_template_id == 0){
	
		$_("addplan").reset();
		changeplan($("#virt_select option:first").val());
		$(addplan).find(":checkbox").prop("checked", false);
		$(addplan).find(":input text").prop(false);
		return false;
	}
	
	if(AJAX("'.$globals['index'].'act=addplan&ajax=1'.(!empty($_REQUEST['virt']) ? '&virt='.optREQ('virt') : '').'&plan_template="+plan_template_id, "plandetails(re)")){
		return false;
	}else{
		return true;	
	}
};

function plandetails(re){
	eval(re);
	var topology_enabled = 0;
	var threshold_enabled = 0;
	$.each($plan, function(index, value){
		
		if(index == "plan_name"){
			return;
		}
		
		if(index in odd_plans){
			index = odd_plans[index];
		}
		
		if(index == "mgs"){
			
			$("#mgs option:selected").removeAttr("selected");
			for(var i=0; i < value.length; i++){
				// filter the options with the specific value and select them
				if(value[i] != ""){
					$("#mgs option").filter("[value="+value[i]+"]").prop("selected", true);
				}
			}	
		}else if(index == "ippoolid"){
			
			$("#ippoolid option:selected").removeAttr("selected");
			for(var i=0; i < value.length; i++){
				// filter the options with the specific value and select them
				if(value[i] != ""){
					$("#ippoolid option").filter("[value="+value[i]+"]").prop("selected", true);
				}
			}	
		}else if(index == "dns_nameserver" && (typeof value == "object")){
			$("#dnstable").html("");
			$.each(value, function( ind, val ){
				adddnsrow(\'dnstable\', val);
			});
			
		}else if(index == "ubc"){
			if(!$.isEmptyObject(value)){
				$("#ubcsettings").prop("checked", true);
				$.each(value, function(ind, val){
					$("#addplan").field("b" + ind, val[0]);
					$("#addplan").field("l" + ind, val[1]);
				});
			}else{
				$("#ubcsettings").prop("checked", false);
				$("#ubc_advoptions input:text").val("");
			}
			$("#ubcsettings").change();
			
		}else if(index == "data"){
			
			if(!empty($plan["data"])){
				$.each($plan["data"], function(d_k, d_v){
					$("#addplan").field(d_k, d_v);
					if($("#"+d_k).prop("type") == "checkbox" || $("#"+d_k).prop("type") == "radio"){
						$("#"+d_k).prop("checked", (!empty(d_v) ? 1 : 0));
					}
				});
				enable_vertical_scaling();
				
				if(!empty($plan["data"]["vga_vram"])){
					enable_accel();
				}
				
				if(!empty($plan["data"]["cpu_flags"])){
				
					var cpu = $("#cpu_mode").val();
					prox_cpu_flags();
					var cpu_flag =  $plan["data"]["cpu_flags"];
					var cpu_info = '.json_encode($cpu_info).';
					var cpu_keys = '.json_encode(array_keys($cpu_info)).';
					$.each(cpu_keys, function(k, v){
						if(cpu_info[v]["cpu_mode"].includes(cpu)){
						
							var mapper = [];
							mapper[0] = "default";
							mapper[1] = "on";
							mapper[2] = "off";
							let execptions = [];
							if(!empty(cpu_info[v]["exception"])){
								$.each(cpu_info[v]["exception"], function(k,v){
									if(v in cpu_flag){
										execptions.push(v);
										$("#"+v+"-"+mapper[cpu_flag[v]]).prop(\'checked\', true);
									}
								});
							}
	
							$.each(cpu_info[v]["cpu_flags"], function(k,v){
								if(!(v in execptions)){
									$("#"+v+"-"+mapper[cpu_flag[v]]).prop(\'checked\', true);
								}
							});
					
						}
					});
				}
				
				if(!empty($plan["data"]["demo"])){

					let demo_data = $plan["data"]["demo"];
					$("#demo_duration").val(demo_data["duration_days"]);
					$("#demo").prop("checked", true);
					$("#enable_demo").val(1);
					
					if(!empty(demo_data["action"])){
						$("#demo_suspend_action").prop("checked", true);
					}else{
						$("#demo_delete_action").prop("checked", true);
					}

					$("#demo").show();
					
				}else{
					
					$("#enable_demo").val(0);
					$("#demo").prop("checked", false);
					$("#demo_duration").val("");
					$("#demo").hide();
				}
			}
				
			
		}else if(index == "virtio"){
			if(value == 0){
				$("#disk_driver_none").prop(\'checked\', true);
			}else if(value == 1){
				$("#virtio").prop(\'checked\', true);
			}else if(value == 2){
				$("#scsi").prop(\'checked\', true);
			}
		}else if(index == "recipe"){
			
			// If value is not an array then convert it to array
			if(value.length == undefined){
				value = (value != 0 ? [ value ] : []);
			}
			
			value.forEach(item => { // iterate through array of items that need to be pre-selected
				let value = $("#recipe option[value="+item+"]").text(); // get items inner text
				$("#recipe option[value="+item+"]").remove(); // remove current item from DOM
				$("#recipe").append(new Option(value, item, true, true)); // append it, making it selected by default
			 });
			 
		}else if(index == "nic_type"){

			if(!empty($plan["support_nic"])){
				
				var sel_opts = "";

				$.each($plan["support_nic"], function(n_k, n_v){
					selected = ""

					if(n_k == value){
						selected = "selected";
					}
					sel_opts += "<option value=\""+n_k+"\" "+selected+">"+n_v+"</option>";
				});
				$(".nic_type").html(sel_opts);	
				$("#addplan").field(index, value);

			}

		}else if(index == "bus_driver"){
		
			if(!empty($plan["bus_driver_list"])){

				var bus_driver_opts = "";
		
				$.each($plan["bus_driver_list"], function(b_k, b_v){
					selected = ""

					if(b_k == value){
						selected = "selected";
					}
					bus_driver_opts += "<option value=\""+b_k+"\" "+selected+">"+b_v+"</option>";
				});
		
				$("#bus_driver").html(bus_driver_opts);

			}
			toggle_driver_num($("#bus_driver").val());
			

		}else{
			$("#addplan").field(index, value);
			if($("#"+index).prop("type") == "checkbox"){
				$("#"+index).prop("checked", (!empty(value) ? 1 : 0));
			}
			if(index == "cplan"){
				changeplan($plan["virt"], 1);
			}
			
			if((index == "topology_sockets" || index == "topology_cores" || index == "cpu_threads") && (!empty(value)) && (empty(topology_enabled))){
				$("#enable_cpu_topology").prop("checked", true);
				topology_enabled = 1;
			}

			if((index == "cpu_threshold" || index == "cpu_threshold_time") && !empty(value) && empty(threshold_enabled)){
				$("#enable_cpu_threshold").prop("checked", true);
				threshold_enabled = 1;
			}
		}
	});
	$(".virt-select").select2({width:"100%"});
	ishvm();
	ispvonhvm();
	change_cpu_topology();
	handle_capping();
	enable_accel();
	checkcputhreshold();
	checkdemo();
};

let toggle_bios = () => {
	
	let ele = $("#bios").val();

	if(ele === "uefi"){
		$("#tpm_row").show();
		showalert("'.__J('To create VPS using UEFI bios, please use ISO as our default template won’t work with UEFI bios option. After creating VPS from ISO, resize will not be possible. Template creation will not work for VPS with UEFI bios.').'","2");
	}else{
		$("#tpm_row").hide();
	}		
	
}

function ispvonhvm(){
	
	if($("#tr_pvonhvm").css("display") == "none"){
		return true;
	}
	
	var pv_on_hvm = false;
	if(!$("#pv_on_hvm")){
		pv_on_hvm = false;
	}else{
		if(is_checked("pv_on_hvm")){
			pv_on_hvm =  true;
		}
	}
	
	if($("#tr_viftype")){
		if(pv_on_hvm){
			$("#tr_viftype").hide();
		}else{
			$("#tr_viftype").show();
		}
	}
	
	return true;
};

function ubcEdit(){
	if($("#ubcsettings").prop("checked")){
		$("#ubc_advoptions input:text").prop("disabled", false);
	}else{
		$("#ubc_advoptions input:text").prop("disabled", true);
	}
}

function change_cpu_topology(){
	
	if($("#enable_cpu_topology").prop("checked")){
		$(".cpu_topology").css("display", "");
	}else{
		$(".cpu_topology").css("display", "none");
		$("#topology_sockets").val(0);
		$("#topology_cores").val(0);
		$("#topology_threads").val(0);
	}
};

function toggle_driver_num(driver_type){
	$(".ide, .sata, .virtio, .scsi").hide();
	$("." + driver_type).show();
	$("#bus_driver_num").val(0);
	if(driver_type == "ide"){
		$("#bus_driver_num").val(2);
	}

	if(driver_type == "virtio"){
		$("#ssd_emulation").prop("checked", false);
		$(".ssd_emulation").hide();
	}else{
		$(".ssd_emulation").show();
	}

	if(driver_type == "scsi"){
		$(".scsi_controller").show();
	}else{
		$(".scsi_controller").hide();
		$("#scsi_controller").val("");
	}
};

$(document).ready(function(){
	enable_vertical_scaling();
});

function checkcputhreshold(){

	if($("#enable_cpu_threshold").prop("checked")){
		$("#cputhresholdpercentage").css("display", "");
		$("#enable_cpu_threshold").val(1);
	}else{
		$("#cputhresholdpercentage").css("display", "none");
		$("#cpu_threshold").val(0);
		$("#cpu_threshold_time").val(0);
	}

};

function checkdemo(){
	if(!$("#demo")){
		return false;
	}
	if(is_checked("demo")){
		$("#demo_duration").show();
		$("#demo_days").show();
		$("#demo_action_options").show();
	}else{
		$("#demo_duration").hide();
		$("#demo_days").hide();
		$("#demo_action_options").hide();
	}	
};

function change_checkbox(id){
	if(is_checked(id)){
		$("#hidden_"+id).val(1);
	}else{
		$("#hidden_"+id).val(0);
	}
};

var lang_no_limit = "'.__J('No Restriction').'";

addonload("changepriority(\''.POSTval('priority', 3).'\');change_cpu_topology();checkcputhreshold();");
addonload("handle_capping(); fillspeedkBps(); changeplan(\''.POSTval('cplan', !empty($_POST['cplan']) ? $_POST['cplan'] : "openvz").'\');ishvm();ispvonhvm();ubcEdit();prox_cpu_flags()");
</script>

<div id="form-container">
<form accept-charset="'.$globals['charset'].'" id="addplan" name="addplan" method="post" action="" class="form-horizontal">
<div class="row mx-auto w-100 mb-3">
	<div class="col-sm-12 col-md-12 col-lg-6 border-right">
		<div class="roundheader cursor-pointer" onclick="toggle_advoptions(\'general\');"><label id="general_advoptions_ind" class="min_width">-</label> &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'.__('General Settings').'</div>
		<div id="general_advoptions" class="bgaddv w-100">
				<div class="row mx-auto w-100 my-3">
					<div class="col-sm-6 p-0">
						<label class="control-label">'.__('Plan Name').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('The name of this plan').'"><i class="fas text-primary fa-info-circle"></i></a></label>
					</div>
					<div class="col-sm-6 p-0">
						<input type="text" class="form-control w-100 side_text" name="plan_name" id="plan_name" size="30" value="'.POSTval('plan_name', '').'" />
					</div>
				</div>
				<div class="row mx-auto w-100 my-3">
					<div class="col-sm-6 p-0">
						<label class="control-label">'.__('Plan Template').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Select existing plan as a template').'"><i class="fas text-primary fa-info-circle"></i></a></label>
					</div>
					<div class="col-sm-6 p-0 server-select-lg">
						<select id="plan_template" name="plan_template" class="custom-select w-100 side_text virt-select" onchange="loadplan(this.value);">
							<option value="0" '.(POSTval('plan_template') == 0 ?  'selected="selected"' : '').'>'.__('Select Plan Template').'</option>';
						foreach($plans as $k => $v){
							echo '<option value='.$k.' '.(POSTval('plan_template') == $k ? 'selected="selected"' : '').'>'.$v['plan_name'].'</option>';
						}
					echo '</select>
					</div>
				</div>
				<div class="row mx-auto w-100 my-3">
					<div class="col-sm-6 p-0">
						<label class="control-label">'.__('Plan Type').'</label>
					</div>
					<div class="col-sm-6 p-0">
						<select id="virt_select" name="cplan" onchange="changeplan(this.value);" class="custom-select w-100 side_text">
							<option value="openvz" '.POSTselect('cplan', 'openvz').'>OpenVZ</option>
							<option value="kvm" '.POSTselect('cplan', 'kvm').'>KVM</option>
							<option value="xcp" '.POSTselect('cplan', 'xcp').'>XenServer</option>
							<option value="xcphvm" '.POSTselect('cplan', 'xcphvm').'>XenServer HVM</option>
							<option value="xen" '.POSTselect('cplan', 'xen').'>Xen</option>
							<option value="xenhvm" '.POSTselect('cplan', 'xenhvm').'>Xen HVM</option>
							<option value="lxc" '.POSTselect('cplan', 'lxc').'>LXC</option>
							<option value="vzo" '.POSTselect('cplan', 'vzo').'>Virtuozzo OpenVZ</option>
							<option value="vzk" '.POSTselect('cplan', 'vzk').'>Virtuozzo KVM</option>
							<option value="proxo" '.POSTselect('cplan', 'proxo').'>Proxmox OpenVZ</option>
							<option value="proxk" '.POSTselect('cplan', 'proxk').'>Proxmox KVM / QEMU</option>
							<option value="proxl" '.POSTselect('cplan', 'proxl').'>Proxmox LXC</option>
						</select>
					</div>
				</div>';

				if(!empty($backup_plans)){

					echo '
				<div class="row mx-auto w-100 my-3">
					<div class="col-sm-6 p-0">
						<label class="control-label">'.__('Backup Plan').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Select Backup Plan for the VPS').'"><i class="fas text-primary fa-info-circle"></i></a></label>
					</div>
					<div class="col-sm-6 p-0 server-select-lg">
						<select class="custom-select w-100 side_text virt-select" name="bpid" id="bpid">
						<option value=0 '.(POSTval('bpid') == 0 ? 'selected="selected"' : '').'>'.__('Select Backup Plan').'</option>';
							foreach($backup_plans as $k => $v){
								echo '<option value="'.$k.'" '.(POSTval('bpid') == $k ? 'selected="selected"' : '').'>'.$v['plan_name'].'</option>';
							}
						echo '</select>
					</div>
				</div>';

				}

				if(!empty($firewall_plans)){
								
					echo '
					<div class="row mx-auto w-100 my-3"> 
						<div class="col-sm-6 p-0">
							<label class="control-label">'.__('Firewall Plan').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Select Firewall Plan for the VPS').'"><i class="fas text-primary fa-info-circle"></i></a></label>
						</div>
						<div class="col-sm-6 p-0 server-select-lg">
							<select class="custom-select w-100 side_text virt-select" id="fwid" name="fwid">
							<option value="0" '.(POSTval('fwid') == 0 ? 'selected="selected"' : '').'>'.__('None').'</option>';
							$current_user = -1;
		
							foreach($firewall_plans as $k => $v){
		
								$firewall_plan_creator = empty($v["uid"]) ? "root" : $firewall_users[$v["uid"]];
		
								if($current_user != $v['uid']){
		
									if($current_user != -1){
										echo '</optgroup>';
									}	
									
									echo '<optgroup label="'.$firewall_plan_creator.'">';
		
									$current_user = $v['uid'];
									
								}
		
								echo '<option value="'.$k.'" '.(POSTval('fwid') == $k ? 'selected="selected"' : '').'>'.$v['fw_plan_name'].'</option>';
							}
		
							echo '</optgroup>';
						
						echo '</select>
						</div>
					</div>';
				
				}

				echo '<div class="row mx-auto w-100 my-3">
					<div class="col-sm-6 p-0">
						<label class="control-label">'.__('Operating System').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Select the Operating System for the VPS').'"><i class="fas text-primary fa-info-circle"></i></a></label>
					</div>
					<div class="col-sm-6 p-0 server-select-lg">
						<select class="custom-select w-100 side_text virt-select" id="osid" name="osid">
							<option value="0" '.(POSTval('osid') == 0 ? 'selected="selected"' : '').'>'.__('None').'</option>';
							if(!empty($ostemplates)){
								foreach($ostemplates as $k => $v){
									echo '<option value="'.$k.'" '.(POSTval('osid') == $k ? 'selected="selected"' : '').' '.(!empty($v['hvm']) ? 'hvm="1"' : '').' virt="'.$v['type'].(!empty($v['hvm']) ? 'hvm' : '').'">'.(!empty($v['hvm']) ? 'HVM - ' : '').''.$v['name'].is_custom_os($k).'</option>';
								}
							}
					echo'</select>
					</div>
				</div>';

				if(!empty($isos)){
					echo '<div class="row mx-auto w-100 my-3 kvm xenhvm xcphvm vzk proxk" id="isorow">
					<div class="col-sm-6 p-0">
						<label class="control-label">'.__('ISO').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If an ISO is selected the machine will be booted from that ISO').'"><i class="fas text-primary fa-info-circle"></i></a></label>
					</div>
					<div class="col-sm-6 p-0">
						<select class="custom-select virt-select w-100 side_text" name="iso">
						<option value="0" '.(POSTval('iso') == 0 ? 'selected="selected"' : '').'>'.__('None').'</option>';
						
						foreach($isos as $k => $v){	
							echo '<option value="'.$k.'" '.(POSTval('iso') == $k ? 'selected="selected"' : '').'>'.$v['name'].'</option>';
						}
						
					 echo'</select>
					</div>
				</div>';

				}
				
				echo '
				<div class="row mx-auto w-100 my-3">
					<div class="col-sm-6 p-0">
						<label class="control-label">'.__('Disk Space').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('The allowed disk space for the VPS').'"><i class="fas text-primary fa-info-circle"></i></a></label>
					</div>
					<div class="proxk row col-sm-3 p-0 mx-auto w-100">
						<div class="col-sm-6 pl-0 pr-1">
							<select class="custom-select bus_driver" id = "bus_driver" name="bus_driver" onchange="toggle_driver_num(this.value)" >';
							
								foreach($bus_driver_list as $bdk => $bdv){
									echo '<option value="'.$bdk.'" '.POSTselect('bus_driver', $bdv).'>'.$bdv.'</option>';
								}
					echo   '
							</select>
						</div>	
						<div class="col-sm-6 pr-0 pl-1">	
							<select class="custom-select bus_driver_num" id="bus_driver_num" name="bus_driver_num" >';
							echo '<option class="sata virtio scsi" value="0" '.POSTselect('bus_driver_num', 0).'>0</option>';
							echo '<option class="sata virtio scsi" value="1" '.POSTselect('bus_driver_num', 1).'>1</option>';
							echo '<option class="ide sata virtio scsi" value="2" '.POSTselect('bus_driver_num', 2).'>2</option>';
							echo '<option class="ide sata virtio scsi" value="3" '.POSTselect('bus_driver_num', 3).'>3</option>';
							echo '<option class="virtio scsi" value="4" '.POSTselect('bus_driver_num', 4).'>4</option>';
							echo '<option class="sata virtio scsi" value="5" '.POSTselect('bus_driver_num', 5).'>5</option>';
							echo '<option class="virtio scsi" value="6" '.POSTselect('bus_driver_num', 6).'>6</option>';
							echo '<option class="virtio scsi" value="7" '.POSTselect('bus_driver_num', 7).'>7</option>';
							echo '<option class="virtio scsi" value="8" '.POSTselect('bus_driver_num', 8).'>8</option>';
							echo '<option class="virtio scsi" value="9" '.POSTselect('bus_driver_num', 9).'>9</option>';
							echo '<option class="virtio scsi" value="10" '.POSTselect('bus_driver_num', 10).'>10</option>';
							echo '<option class="virtio scsi" value="11" '.POSTselect('bus_driver_num', 11).'>11</option>';
							echo '<option class="virtio scsi" value="12" '.POSTselect('bus_driver_num', 12).'>12</option>';
							echo '<option class="virtio scsi" value="13" '.POSTselect('bus_driver_num', 13).'>13</option>';
							echo '<option class="virtio" value="14" '.POSTselect('bus_driver_num', 14).'>14</option>';
							echo '<option class="virtio" value="15" '.POSTselect('bus_driver_num', 15).'>15</option>';
					echo	'
							</select>
						</div>
					</div>
					<div id="disk_space_col" class="">
						<div class="input-group ">
							<input type="number" step="0.001" class="form-control rounded" name="disk_space" id="disk_space" size="10" value="'.POSTval('disk_space', '').'" />
							<div class="input-group-append">
									<span class="input-group-text">GB</span>
							</div>
						</div>
					</div>
				</div>
				<div class="row mx-auto w-100 my-3 proxk scsi_controller">
					<div class="col-sm-6 p-0">
						<label class="control-label">'.__('SCSI Controller').'</label>
					</div>
					<div class="col-sm-6 p-0">
						<select id="scsi_controller" name="scsi_controller" class="custom-select">
							<option value="">'.__('None').'</option>
							<option value="virtio-scsi-pci" '.POSTselect('scsi_controller', 'virtio-scsi-pci').'>VirtIO SCSI</option>
							<option value="lsi" '.POSTselect('scsi_controller', 'lsi').'>LSI 53C895A</option>
							<option value="lsi53c810" '.POSTselect('scsi_controller', 'lsi53c810').'>LSI 53C810</option>
							<option value="megasas" '.POSTselect('scsi_controller', 'megasas').'>MegaRAID SAS 8708EM2</option>
							<option value="virtio-scsi-single" '.POSTselect('scsi_controller', 'virtio-scsi-single').'>VirtIO SCSI single</option>
							<option value="pvscsi" '.POSTselect('scsi_controller', 'pvscsi').'>VMware PVSCSI</option>
						</select>								
					</div>
				</div>

				<div class="row mx-auto w-100 my-3">
					<div class="col-sm-6 p-0">
						<label class="control-label">'.__('Guaranteed RAM').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('The amount of RAM which the VPS will always have').'"><i class="fas text-primary fa-info-circle"></i></a></label>
					</div>
					<div class="col-sm-6 p-0">
						<div class="input-group">
							<input type="number" class="form-control rounded" name="guaranteed_ram" id="guaranteed_ram" size="10" value="'.POSTval('guaranteed_ram', '').'" />
							<div class="input-group-append">
									<span class="input-group-text">MB</span>
							</div>
						</div>
					</div>	
				</div>

				<div class="row mx-auto w-100 my-3 proxk" id="minram">
					<div class="col-sm-6 p-0">
						<label class="control-label">'.__('Minimum RAM').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Supported only on Proxmox 7 and above').'"><i class="fas text-primary fa-info-circle"></i></a></label>
					</div>
					<div class="col-sm-6 p-0">
						<div class="input-group ">
							<input type="number" class="form-control rounded" name="min_ram" id="min_ram" size="10" value="'.POSTval('min_ram', '').'" />
							<div class="input-group-append">
								<span class="input-group-text">MB</span>
							</div>
						</div>
					</div>
				</div>

				<div class="row mx-auto w-100 my-3 kvm xen xenhvm xcp xcphvm lxc vzk vzo proxk proxo proxl" id="swap">
					<div class="col-sm-6 p-0">
						<label class="control-label">'.__('SWAP Ram').'</label>
					</div>
					<div class="col-sm-6 p-0">
						<div class="input-group ">
							<input type="number" class="form-control rounded" name="swapram" id="swapram" size="10" value="'.POSTval('swapram', '').'" />
							<div class="input-group-append">
									<span class="input-group-text">MB</span>
							</div>
						</div>
					</div>	
				</div>

				<div class="row mx-auto w-100 my-3 openvz" id="burst">
					<div class="col-sm-6 p-0">
						<label class="control-label">'.__('Burstable RAM').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('The maximum amount of RAM which the VPS can use').'"><i class="fas text-primary fa-info-circle"></i></a></label>
					</div>
					<div class="col-sm-6 p-0">
						<div class="input-group ">
							<input type="number" class="form-control rounded" name="burst_ram" id="burst_ram" size="10" value="'.POSTval('burst_ram', '').'" />
							<div class="input-group-append">
									<span class="input-group-text">MB</span>
							</div>
						</div>
					</div>
				</div>

				<div class="row mx-auto w-100 my-3">
					<div class="col-sm-6 p-0">
						<label class="control-label">'.__('Bandwidth').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Monthly Bandwidth limit of the VPS').'"><i class="fas text-primary fa-info-circle"></i></a></label>
					</div>
					<div class="col-sm-6 p-0">
						<div class="input-group ">
							<input type="number" class="form-control rounded" name="bandwidth" id="bandwidth" size="10" value="'.POSTval('bandwidth', '').'" onchange="handle_capping();" />
							<div class="input-group-append">
									<span class="input-group-text">GB</span>
							</div>
						</div>
					</div>	
				</div>

				<script type="text/javascript">
				function netspeed(r){
					$_("network_speed").value = r;
					handle_capping();
				}
				function upspeed(r){
					$_("upload_speed").value = (r);
					handle_capping();
				}

				function enable_accel(){
					
					if($_("kvm_vga").checked == true){
						$_("enable_acceleration").style.display = "";
						$_("set_vga_vram").style.display = "";
					}else{
						$_("enable_acceleration").style.display = "none";
						$_("set_vga_vram").style.display = "none";
					}

				}

				</script>

				<div class="row mx-auto w-100 my-3">
					<div class="col-sm-6 p-0">
						<label class="control-label">'.__('Network Speed').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Enter 0 or leave empty for no restriction. <br />Use the select box for easy options').'"><i class="fas text-primary fa-info-circle"></i></a></label>
					</div>
					<div class="col-sm-6 p-0">
						<div class="input-group w-100">
							<input type="number" class="form-control rounded" name="network_speed" id="network_speed" size="8" value="'.POSTval('network_speed', '').'" onchange="handle_capping();" />
							<div class="input-group-append w-50">
								<span class="input-group-text mb-1 mr-1">'.__('KB/s').'</span>
								<select class="custom-select w-75 speedkBps" name="network_speed2" id="network_speed2" onchange="netspeed(this.value)"></select>
							</div>
						</div>
					 </div>
				</div>

				<div class="row mx-auto w-100 my-3" id="cpunits">
					<div class="col-sm-6 p-0">
						<label class="control-label">'.__('CPU Units').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('CPU units to be allocated').'"><i class="fas text-primary fa-info-circle"></i></a></label><br>
						<span class="help-block">
						<a href="'.$globals['docs'].'creating-a-vps#cpu-parameters" target="_blank">'.__('Need more info ?').'</a>
						</span>
					</div>
					<div class="col-sm-6 p-0">
						<div class="input-group ">
							<input type="number" class="form-control rounded" name="cpu_units" id="cpu_units" size="10" value="'.POSTval('cpu_units', '').'" />
						  <div class="input-group-append">
							<span class="input-group-text">Units</span>
						  </div>
						</div>
					</div>	
				</div>

				<div class="row mx-auto w-100 my-3">
					<div class="col-sm-6 p-0">
						<label class="control-label">'.__('CPU Cores').'</label><br>
						<span class="help-block"><a href="'.$globals['docs'].'creating-a-vps#cpu-parameters" target="_blank">'.__('Need more info ?').'</a></span>
					</div>
					<div class="col-sm-6 p-0">
						<input type="number" class="form-control w-100 side_text" name="cpu_cores" id="cores" size="10" value="'.POSTval('cpu_cores', '').'" />
					</div>	
				</div>

				<div class="row mx-auto w-100 my-3 kvm openvz proxk proxl vzk vzo xcp xen" id="cpupercent">
					<div class="col-sm-6 p-0">
						<label class="control-label">'.__('CPU %').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('The CPU time in percent the corresponding VPS is not allowed to exceed. <br />Set <b>0</b> for no restriction.').'"><i class="fas text-primary fa-info-circle"></i></a></label><br>
						<span class="help-block">
						<a href="'.$globals['docs'].'creating-a-vps#cpu-parameters" target="_blank">'.__('Need more info ?').'</a>
						</span>
					</div>
					<div class="col-sm-6 p-0">
						<div class="input-group ">
							<input type="number" class="form-control rounded" name="percent_cpu" id="percent_cpu" size="10" value="'.POSTval('percent_cpu', '').'" />
							<div class="input-group-append">
								<span class="input-group-text">%</span>
							</div>
						</div>
					</div>
				</div>

				<div class="row mx-auto w-100 my-3 openvz vzo vzk proxo" id="priority">
					<div class="col-sm-6 p-0">
						<label class="control-label">'.__('I/O priority').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Choose priority from 0-7').'"><i class="fas text-primary fa-info-circle"></i></a></label>
					</div>
					<div class="col-sm-6 p-0">
						<select id="prior" name="priority" class="custom-select w-100 side_text">
							<option value="0">0</option>
							<option value="1">1</option>
							<option value="2">2</option>
							<option value="3">3</option>
							<option value="4">4</option>
							<option value="5">5</option>
							<option value="6">6</option>
							<option value="7">7</option>
						</select>
					</div>
				</div>

				<div class="row mx-auto w-100 my-3">
					<div class="col-sm-6 p-0">
						<label class="control-label">'.__('Number of IPs').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Specify any positive integer. If nothing is specified (or 0), you will have to select the IPs when creating a VPS.').'"><i class="fas text-primary fa-info-circle"></i></a></label>
					</div>
					<div class="col-sm-6 p-0">
						<input type="number" class="form-control w-100 side_text" name="ips" size="10" value="'.POSTval('ips', '').'" />
					</div>
				</div>

				<div class="row mx-auto w-100 my-3">
					<div class="col-sm-6 p-0">
						<label class="control-label">'.__('Number of IPv6 Subnets').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Specify any positive integer. If nothing is specified (or 0), you will have to select the IPs when creating a VPS.').'"><i class="fas text-primary fa-info-circle"></i></a></label>
					</div>
					<div class="col-sm-6 p-0">
						<input type="number" class="form-control w-100 side_text" name="ips6_subnet" size="10" value="'.POSTval('ips6_subnet', '').'" />
					</div>
				</div>

				<div class="row mx-auto w-100 my-3">
					<div class="col-sm-6 p-0">
						<label class="control-label">'.__('Number of IPv6 Addresses').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Specify any positive integer. If nothing is specified (or 0), you will have to select the IPs when creating a VPS.').'"><i class="fas text-primary fa-info-circle"></i></a></label>
					</div>
					<div class="col-sm-6 p-0">
						<input type="number" class="form-control w-100 side_text" name="ips6" size="10" value="'.POSTval('ips6', '').'" />
					</div>
				</div>
				<div class="row mx-auto w-100 my-3">
					<div class="col-sm-6 p-0">
						<label class="control-label">'.__('Number of Internal IPs').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Specify any positive integer. If nothing is specified (or 0), you will have to select the Internal IPs when creating a VPS.').'"><i class="fas text-primary fa-info-circle"></i></a></label>
					</div>
					<div class="col-sm-6 p-0">
						<input type="number" class="form-control w-100 side_text" name="ips_int" size="10" value="'.POSTval('ips_int', '').'" />
					</div>
				</div>
				<div class="row mx-auto w-100 my-3 kvm vzk" id="virtio_settings">
					<div class="col-6 p-0">
						<label class="control-label">'.__('Select Disk driver').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Use <b>virtio</b> for virtio drivers<br>Use <b>scsi</b> for disk drivers. Fstrim will work <b>ONLY</b> if scsi is selected and storage is thin.<br>If None is checked IDE will be selected').'"><i class="fas text-primary fa-info-circle"></i></a></label>
					</div>
					<div class="col-2 p-0">
						<label class="custom-control custom-radio">
							<input type="radio" class="custom-control-input" name="virtio" value="0" id="disk_driver_none" '.POSTradio('virtio', 0).'>
							<span class="custom-control-label" for="disk_driver_none">'.__('None').'</span>
						</label>
					</div>
					<div class="col-2 p-0">
						<label class="custom-control custom-radio">
							<input type="radio" class="custom-control-input" name="virtio" value="1" id="virtio" '.POSTradio('virtio', 1).' checked="checked">
							<span class="custom-control-label" for="virtio">'.__('virtio').'</span>
						</label>
					</div>
					<div class="col-2 p-0">
						<label class="custom-control custom-radio">
							<input type="radio" class="custom-control-input" name="virtio" value="2" id="scsi" '.POSTradio('virtio', 2).'>
							<span class="custom-control-label" for="scsi">'.__('scsi').'</span>
						</label>
					</div>
				</div>
				<div class="row mx-auto w-100 my-3 vnc_div kvm xen xenhvm xcp xcphvm proxk vzk vzo">
					<div class="col-6 p-0">
						<label class="control-label">VNC</label>
						<span class="help-block">&nbsp;</span>
					</div>
					<div class="col-6 p-0">
						'.get_checkbox('vnc', '', 'vnc').'
					</div>
				</div>
				<div class="row mx-auto w-100 my-3 xenhvm" id="shadow_div">
					<div class="col-sm-6 p-0">
						<label class="control-label">'.__('Shadow Memory').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Recommended value : 8 MB').'"><i class="fas text-primary fa-info-circle"></i></a></label>
					</div>
					<div class="col-sm-6 p-0">
						<input type="number" class="form-control side_text" name="shadow" size="10" value="'.POSTval('shadow', 8).'" /><label class="side_lbl">MB</label>
					</div>
				</div>
				';
				$ploop_flag = ($globals['ploop'] ? 'checked="checked" disabled="disabled"' : '');
				echo'
				<div class="row mx-auto w-100 my-3 openvz">
					<div class="col-6 p-0">
						<label class="control-label">'.__('Ploop').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If enabled, VPS will be created with the Ploop format').'"><i class="fas text-primary fa-info-circle"></i></a></label>
					</div>
					<div class="col-6 p-0">
						'.get_checkbox('ploop', '', '', array('chk_it' => 1), 1, '', array($ploop_flag)).'
					</div>
				</div>';
				if(($globals['is_master_only'] == 1) || check_licensepro()){
					echo '
					<div class="row mx-auto w-100 my-3 kvm proxk vzk">
						<div class="col-6 p-0">
							<label class="control-label">'.__('Create as load balancer').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If checked then VPS will be created with load balancer service enabled').'"><i class="fas text-primary fa-info-circle"></i></a></label>
						</div>
						<div class="col-6 p-0">
							'.get_checkbox('load_balancer', '', 'load_balancer', array('chk_it' => 1)).'
						</div>
					</div>';
				}	
				echo'
				<div class="row mx-auto w-100 my-3 kvm_hvm_div kvm xenhvm xcphvm">
					<div class="col-6 p-0">
						<label class="control-label">'.__('ACPI').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('ACPI is used to send shutdown signal to the Virtual Machines. ACPI is required for Virtual Machines so that they can react to such signals').'"><i class="fas text-primary fa-info-circle"></i></a></label>
					</div>
					<div class="col-6 p-0">
						'.get_checkbox('acpi', '', 'acpi', array('chk_it' => 1), 1, '', array('checked = "checked"')).'
					</div>
				</div>
				<div class="row mx-auto w-100 my-3 kvm_hvm_div kvm xenhvm xcphvm">
					<div class="col-6 p-0">
						<label class="control-label">'.__('APIC').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Advanced Programmable Interrupt Controller improves virtualized AMD64 and Intel 64 guest performance by allowing the guest to directly access the APIC, dramatically cutting down interrupt latencies and the number of virtual machine exits caused by the APIC').'"><i class="fas text-primary fa-info-circle"></i></a></label>
					</div>
					<div class="col-6 p-0">
						'.get_checkbox('apic', '', 'apic', array('chk_it' => 1), 1, '', array('checked = "checked"')).'
					</div>
				</div>
				<div class="row mx-auto w-100 my-3 kvm_hvm_div kvm xenhvm xcphvm">
					<div class="col-6 p-0">
						<label class="control-label">'.__('PAE').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Physical address extension mode allows 32-bit guest virtual machines to address more than 4 GB of memory').'"><i class="fas text-primary fa-info-circle"></i></a></label>
					</div>
					<div class="col-6 p-0">
						'.get_checkbox('pae', '', 'pae', array('chk_it' => 1), 1, '', array('checked = "checked"')).'
					</div>
				</div>
				<div class="row mx-auto w-100 my-3">
					<div class="col-sm-6 p-0">
						<label class="control-label">'.__('Media Groups').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If no Media Group is assigned then all Media will be available to this VPS.').'"><i class="fas text-primary fa-info-circle"></i></a></label>
					</div>
					<div class="col-sm-6 p-0">
						<select class="virt-select w-100" name="mgs[]" id="mgs" multiple="multiple">';
							
							foreach($mgs as $mk => $mv){
								echo '<option value="'.$mk.'" type="'.$mv['mg_type'].'" '.(in_array($mk, @$_POST['mgs']) ? 'selected="selected"' : '').'>'.$mv['mg_name'].'</option>';
							}
							
						echo '</select>
					</div>
				</div>
		</div><br>
		<div class="openvz_ubc openvz" style="display:none;" id="ubc">
			<div class="roundheader cursor-pointer" onclick="toggle_advoptions(\'ubc\');"><label id="ubc_advoptions_ind" class="min_width">-</label> &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'.__('UBC Settings').'</div>
			<div id="ubc_advoptions" class="w-100 bgaddv">
				<div class="row mx-auto w-100 my-3" id="ubc">
					<div class="col-6 p-0">
						<label class="control-label">'.__('UBC Settings').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Check this if you want to save the UBC Settings').'"><i class="fas text-primary fa-info-circle"></i></a></label>
					</div>
					<div class="col-6 p-0">
						'.get_checkbox('ubcsettings', '', 'ubcsettings', array('chk_it' => 1), 1, '', array('onchange="ubcEdit();"')).'
					</div>
				</div>
				<div class="row mx-auto w-100 my-3">
					<div class="col-4 p-0"></div>
					<div class="col-4">
						<label class="control-label">'.__('Barrier').'</label>
					</div>
					<div class="col-4">
						<label class="control-label">'.__('Limit').'</label>
					</div>
				</div>';
			
				foreach($_ubc as $k){
					
					echo '<div class="row mx-auto w-100 my-3">
						<div class="col-4 p-0">
							<label class="control-label">'.$k.'</label></div>
						<div class="col-4 pl-0">
							<input type="text" class="form-control" name="b'.$k.'" id="b'.$k.'" size="30" value="'.POSTval('b'.$k).'" />
							<span class="help-block"></span>
						</div>
						<div class="col-4 pr-0">
							<input type="text" class="form-control" name="l'.$k.'" id="l'.$k.'" size="30" value="'.POSTval('l'.$k).'" />
						</div>
					</div>';	
				}
		echo '</div>
		</div><br>
		

	</div>
	<div class="col-sm-12 col-md-12 col-lg-6">
		<div class="roundheader cursor-pointer" onclick="toggle_advoptions(\'adv\');"><label id="adv_advoptions_ind" class="min_width">-</label> &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'.__('Advanced Options').'</div>
		<div id="adv_advoptions" class="w-100 bgaddv">
			<div class="row mx-auto w-100 my-3">
				<div class="col-sm-6 p-0">
					<label class="control-label">'.__('IP Pool').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Select Multiple IP Pools you want to assign to this plan. (Optional)').'"><i class="fas text-primary fa-info-circle"></i></a></label>
				</div>
				<div class="col-sm-6 p-0">
					<select multiple="multiple" class="form-control virt-select" name="ippoolid[]" id="ippoolid">';
						$posted_ippool = (!empty($_REQUEST['ippoolid']) ? $_REQUEST['ippoolid'] : []);
						foreach($ippools as $k => $v){
							echo '<option value="'.$k.'" '.(in_array($k, $posted_ippool) ? 'selected="selected"' : '').'">'.$v['ippool_name'].(!empty($v['ipv6']) ? " (IPv6)" : (!empty($v['internal']) ? " (".__('Internal').")" : " (IPv4)")).'</option>';
						}
					echo '</select>
				</div>
			</div>
			<div class="row mx-auto w-100 my-3 openvz vzo lxc">
				<div class=" col-6 p-0">
					<label class="control-label">'.__('Tun/Tap').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Enable Tun/Tap for a VPS').'"><i class="fas text-primary fa-info-circle"></i></a></label>
				</div>
				<div class=" col-6 p-0">
					'.get_checkbox('tuntap', '', 'tuntap').'
				</div>
			</div>
			<div class="row mx-auto w-100 my-3 openvz vzo">
				<div class=" col-6 p-0">
					<label class="control-label">'.__('PPP').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Enable PPP (Point to Point Protocol) for a VPS').'"><i class="fas text-primary fa-info-circle"></i></a></label>
				</div>
				<div class=" col-6 p-0">
					'.get_checkbox('ppp', '', 'ppp').'
				</div>
			</div>
			<div class="row mx-auto w-100 my-3 openvz vzo">
				<div class=" col-6 p-0">
					<label class="control-label">'.__('Enable Fuse in Container(s)').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If checked, Fuse will be enabled while making the new container(s).').'"><i class="fas text-primary fa-info-circle"></i></a></label>
				</div>
				<div class=" col-6 p-0">
					'.get_checkbox('fuse').'
				</div>
			</div>
			<div class="row mx-auto w-100 my-3 kvm">
				<div class=" col-6 p-0">
					<label class="control-label">'.__('Disable Autostart').' &nbsp;<a class="info" data-placement="right" tooltip="'.__('If enabled then VPS will not autostart in case of node reboot').'"><i class="fas text-primary fa-info-circle"></i></a></label>
				</div>
				<div class=" col-6 p-0">
					'.get_checkbox('disable_autostart', '', 'disable_autostart').'
				</div>
			</div>
			<div class="row mx-auto w-100 my-3 openvz vzo">
				<div class=" col-6 p-0">
					<label class="control-label">'.__('Enable IPIP in Container(s)').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If checked, IPIP will be enabled while making the new container(s).').'"><i class="fas text-primary fa-info-circle"></i></a></label>
				</div>
				<div class=" col-6 p-0">
					'.get_checkbox('ipip').'
				</div>
			</div>
			<div class="row mx-auto w-100 my-3 openvz vzo">
				<div class=" col-6 p-0">
					<label class="control-label">'.__('Enable IPGRE in Container(s)').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If checked, IPGRE will be enabled while making the new container(s).').'"><i class="fas text-primary fa-info-circle"></i></a></label>
				</div>
				<div class=" col-6 p-0">
					'.get_checkbox('ipgre').'
				</div>
			</div>
			<div class="row mx-auto w-100 my-3 openvz vzo">
				<div class=" col-6 p-0">
					<label class="control-label">'.__('Enable NFS in Container(s)').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If checked, NFS will be enabled while making the new container(s).').'"><i class="fas text-primary fa-info-circle"></i></a></label>
				</div>
				<div class=" col-6 p-0">
					'.get_checkbox('nfs').'
				</div>
			</div>
			<div class="row mx-auto w-100 my-3 openvz vzo">
				<div class="col-sm-6 p-0">
					<label class="control-label">'.__('Enable QUOTAUGIDLIMIT in Container(s)').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Enables or disables in-container per-user and per-group disk quotas. If the value is set to 0 or not set, disk quotas inside the container is disabled and not accounted. <br><b>NOTE:</b> This will restart the container.').'"><i class="fas text-primary fa-info-circle"></i></a></label>
				</div>
				<div class="col-sm-6 p-0">
					<input type="number" class="form-control" name="quotaugidlimit" id="quotaugidlimit" size="30" value="'.POSTval('quotaugidlimit').'" />
				</div>
			</div>
			<div class="row mx-auto w-100 my-3 openvz vzo">
				<div class="col-sm-6 p-0">
					<label class="control-label">'.__('Set IO Bandwidth Limit for Container(s)').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If set, IO operation will not exceed the specified limit while performing IO operations.').'"><i class="fas text-primary fa-info-circle"></i></a></label>
				</div>
				<div class="col-sm-6 p-0">
					<input type="number" class="form-control" name="iolimit" id="iolimit" size="30" value="'.POSTval('iolimit').'" />
				</div>
			</div>
			<div class="row mx-auto w-100 my-3 openvz vzo">
				<div class="col-sm-6 p-0">
					<label class="control-label">'.__('Set IOPS Limit for Container(s)').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If set, IO operations per second will not exceed the specified limit.').'"><i class="fas text-primary fa-info-circle"></i></a></label>
				</div>
				<div class="col-sm-6 p-0">
					<input type="number" class="form-control" name="iopslimit" id="iopslimit" size="30" value="'.POSTval('iopslimit').'" />
				</div>
			</div>
			<div class="row mx-auto w-100 my-3">
				<div class="col-sm-6 p-0">
					<label class="control-label">'.__('Web Control Panel').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('This option will install selected web control panel in the VPS').'"><i class="fas text-primary fa-info-circle"></i></a></label>
				</div>
				<div class="col-sm-6 p-0">
					<select class="custom-select" name="control_panel" id="control_panel" >
						<option value="0" '.POSTselect('control_panel', 'none').'>None</option>
						<option value="cpanel" '.POSTselect('control_panel', 'cpanel').'>cPanel</option>
						<option value="webuzo" '.POSTselect('control_panel', 'webuzo').'>Webuzo</option>
						<option value="plesk" '.POSTselect('control_panel', 'plesk').'>Plesk</option>
						<option value="webmin" '.POSTselect('control_panel', 'webmin').'>Webmin</option>
						<option value="interworx" '.POSTselect('control_panel', 'interworx').'>Interworx</option>
						<option value="ispconfig" '.POSTselect('control_panel', 'ispconfig').'>ISPConfig</option>
						<option value="cwp" '.POSTselect('control_panel', 'cwp').'>CentOS Web Panel</option>
						<option value="vesta" '.POSTselect('control_panel', 'vesta').'>VestaCP</option>';
						if(!empty($custom_cp)){
							foreach($custom_cp as $k => $v){
								echo '<option value="virt_'.$v.'" '.POSTselect('control_panel', 'virt_'.$v).'>'.$v.'</option>';
							}
						}
						echo ';
					</select>
				</div>
			</div>
			<div class="row mx-auto w-100 my-3 proxl">
				<div class="col-sm-6 p-0">
					<label class="control-label">'.__('Unprivileged').' &nbsp;<a class="info" data-placement="right" tooltip="'.__('Create unprivileged Container. NOTE: You cannot change the unprivileged state once VPS is created').'"><i class="fas text-primary fa-info-circle"></i></a></label>
				</div>
				<div class="col-sm-6 p-0">
					<select class="custom-select" name="unprivileged" id="unprivileged" >
							<option value="0" '.POSTselect('unprivileged', '0').'>Disable</option>
							<option value="1" '.POSTselect('unprivileged', '1').'>Enable</option>
					</select>
				</div>
			</div>';
			if(!empty($globals['premium_apps'])){
				echo '
					<div id="premium_apps_cb" class="row mx-auto w-100 my-3">
						<div class="col-6 p-0">
							<label class="control-label">'.__('Enable Premium Applications').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If checked then premium application will be enabled for the VPS(s) under this plan').'"><i class="fas text-primary fa-info-circle"></i></a></label>
						</div>
						<div class="col-6 p-0 ">
							'.get_checkbox('premium_apps_plan', '', 'webuzo_data').'
						</div>
					</div>';
			}
			echo '
			<div class="row mx-auto w-100 my-3">
				<div class="col-6 p-0">
					<label class="control-label">'.__('Recipe').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Select the recipe to be executed inside the VPS after creation').'"><i class="fas text-primary fa-info-circle"></i></a></label>
					
				</div>
				<div class="col-6 p-0 server-select-lg">
					<select class="form-control virt-select" name="recipe[]" id="recipe" multiple="multiple" style="width:100%">';
					$tmp_rids = (isset($_POST['recipe']) ? $_POST['recipe'] : []);
					foreach($recipes as $k => $v){
						echo '<option value="'.$k.'" >'.$v['name'].'</option>';
					}
						
					echo '</select>
				</div>
				<script type = "text/javascript">var recSeq = '.json_encode(@$tmp_rids).';
					if(recSeq){
						recSeq.forEach(item => { // iterate through array of items that need to be pre-selected
							let value = $("#recipe option[value="+item+"]").text(); // get items inner text
							$("#recipe option[value="+item+"]").remove(); // remove current item from DOM
							$("#recipe").append(new Option(value, item, true, true)).trigger("change"); // append it, making it selected by default
						});
					}
				</script>
			</div>
			
			<div class="kvm proxk xcp xcphvm vzk">
				<div class="row mx-auto w-100 my-3 xcp xcphvm">
					<div class="col-6 p-0">
						<label class="control-label">'.__('Install Xentools').'</label>
					</div>
					<div class="col-6 p-0">
						'.get_checkbox('install_xentools', '', 'install_xentools').'
					</div>
				</div>
				<div class="row mx-auto w-100 my-3 kvm proxk" id="kvm_cpu_mode">
					<div class="col-sm-6 p-0">
						<label class="control-label">'.__('CPU Mode').'</label>
					</div>
					<div class="col-sm-6 p-0">
						<select class="custom-select" name="cpu_mode" id="cpu_mode" onchange="prox_cpu_flags()">
							<option value="default" '.POSTselect('cpu_mode', 'default').'>Default</option>
							<option class="kvm"   value="host-model"  '.POSTselect('cpu_mode', 'host-model').'>Host Model</option>
							<option class="kvm"   value="host-passthrough" '.POSTselect('cpu_mode', 'host-passthrough').'>Host Passthrough</option>
							<option class="proxk" value="athlon" '.POSTselect('cpu_mode', 'athlon').'>athlon</option>
							<option class="proxk" value="EPYC" '.POSTselect('cpu_mode', 'EPYC').'>EPYC</option>
							<option class="proxk" value="EPYC-IBPB" '.POSTselect('cpu_mode', 'EPYC-IBPB').'>EPYC-IBPB</option>
							<option class="proxk" value="EPYC-Rome" '.POSTselect('cpu_mode', 'EPYC-Rome').'>EPYC-Rome</option>
							<option class="proxk" value="Opteron_G1" '.POSTselect('cpu_mode', 'Opteron_G1').'>Opteron_G1</option>
							<option class="proxk" value="Opteron_G2" '.POSTselect('cpu_mode', 'Opteron_G2').'>Opteron_G2</option>
							<option class="proxk" value="Opteron_G3" '.POSTselect('cpu_mode', 'Opteron_G3').'>Opteron_G3</option>
							<option class="proxk" value="Opteron_G4" '.POSTselect('cpu_mode', 'Opteron_G4').'>Opteron_G4</option>
							<option class="proxk" value="Opteron_G5" '.POSTselect('cpu_mode', 'Opteron_G5').'>Opteron_G5</option>
							<option class="proxk" value="phenom" '.POSTselect('cpu_mode', 'phenom').'>phenom</option>
							<option class="proxk" value="486" '.POSTselect('cpu_mode', '486').'>486</option>
							<option class="proxk" value="Broadwell" '.POSTselect('cpu_mode', 'Broadwell').'>Broadwell</option>
							<option class="proxk" value="Broadwell-IBRS" '.POSTselect('cpu_mode', 'Broadwell-IBRS').'>Broadwell-IBRS</option>
							<option class="proxk" value="Broadwell-noTSX" '.POSTselect('cpu_mode', 'Broadwell-noTSX').'>Broadwell-noTSX</option>
							<option class="proxk" value="Broadwell-noTSX-IBRS" '.POSTselect('cpu_mode', 'Broadwell-noTSX-IBRS').'>Broadwell-noTSX-IBRS</option>
							<option class="proxk" value="Cascadelake-Server" '.POSTselect('cpu_mode', 'Cascadelake-Server').'>Cascadelake-Server</option>
							<option class="proxk" value="Cascadelake-Server-noTSX" '.POSTselect('cpu_mode', 'Cascadelake-Server-noTSX').'>Cascadelake-Server-noTSX</option>
							<option class="proxk" value="Conroe" '.POSTselect('cpu_mode', 'Conroe').'>Conroe</option>
							<option class="proxk" value="core2duo" '.POSTselect('cpu_mode', 'core2duo').'>core2duo</option>
							<option class="proxk" value="coreduo" '.POSTselect('cpu_mode', 'coreduo').'>coreduo</option>
							<option class="proxk" value="Haswell" '.POSTselect('cpu_mode', 'Haswell').'>Haswell</option>
							<option class="proxk" value="Haswell-IBRS" '.POSTselect('cpu_mode', 'Haswell-IBRS').'>Haswell-IBRS</option>
							<option class="proxk" value="Haswell-noTSX" '.POSTselect('cpu_mode', 'Haswell-noTSX').'>Haswell-noTSX</option>
							<option class="proxk" value="Haswell-noTSX-IBRS" '.POSTselect('cpu_mode', 'Haswell-noTSX-IBRS').'>Haswell-noTSX-IBRS</option>
							<option class="proxk" value="Icelake-Client" '.POSTselect('cpu_mode', 'Icelake-Client').'>Icelake-Client</option>
							<option class="proxk" value="Icelake-Client-noTSX" '.POSTselect('cpu_mode', 'Icelake-Client-noTSX').'>Icelake-Client-noTSX</option>
							<option class="proxk" value="Icelake-Server" '.POSTselect('cpu_mode', 'Icelake-Server').'>Icelake-Server</option>
							<option class="proxk" value="Icelake-Server-noTSX" '.POSTselect('cpu_mode', 'Icelake-Server-noTSX').'>Icelake-Server-noTSX</option>
							<option class="proxk" value="IvyBridge" '.POSTselect('cpu_mode', 'IvyBridge').'>IvyBridge</option>
							<option class="proxk" value="IvyBridge-IBRS" '.POSTselect('cpu_mode', 'IvyBridge-IBRS').'>IvyBridge-IBRS</option>
							<option class="proxk" value="KnightsMill" '.POSTselect('cpu_mode', 'KnightsMill').'>KnightsMill</option>
							<option class="proxk" value="Nehalem" '.POSTselect('cpu_mode', 'Nehalem').'>Nehalem</option>
							<option class="proxk" value="Nehalem-IBRS" '.POSTselect('cpu_mode', 'Nehalem-IBRS').'>Nehalem-IBRS</option>
							<option class="proxk" value="Penryn" '.POSTselect('cpu_mode', 'Penryn').'>Penryn</option>
							<option class="proxk" value="pentium" '.POSTselect('cpu_mode', 'pentium').'>pentium</option>
							<option class="proxk" value="pentium2" '.POSTselect('cpu_mode', 'pentium2').'>pentium2</option>
							<option class="proxk" value="pentium3" '.POSTselect('cpu_mode', 'pentium3').'>pentium3</option>
							<option class="proxk" value="SandyBridge" '.POSTselect('cpu_mode', 'SandyBridge').'>SandyBridge</option>
							<option class="proxk" value="SandyBridge-IBRS" '.POSTselect('cpu_mode', 'SandyBridge-IBRS').'>SandyBridge-IBRS</option>
							<option class="proxk" value="Skylake-Client" '.POSTselect('cpu_mode', 'Skylake-Client').'>Skylake-Client</option>
							<option class="proxk" value="Skylake-Client-IBRS" '.POSTselect('cpu_mode', 'Skylake-Client-IBRS').'>Skylake-Client-IBRS</option>
							<option class="proxk" value="Skylake-Client-noTSX-IBRS" '.POSTselect('cpu_mode', 'Skylake-Client-noTSX-IBRS').'>Skylake-Client-noTSX-IBRS</option>
							<option class="proxk" value="Westmere" '.POSTselect('cpu_mode', 'Westmere').'>Westmere</option>
							<option class="proxk" value="Westmere-IBRS" '.POSTselect('cpu_mode', 'Westmere-IBRS').'>Westmere-IBRS</option>
							<option class="proxk" value="kvm32" '.POSTselect('cpu_mode', 'kvm32').'>kvm32</option>
							<option class="proxk" value="kvm64" '.POSTselect('cpu_mode', 'kvm64').'>kvm64</option>
							<option class="proxk" value="max" '.POSTselect('cpu_mode', 'max').'>max</option>
							<option class="proxk" value="qemu32" '.POSTselect('cpu_mode', 'qemu32').'>qemu32</option>
							<option class="proxk" value="qemu64" '.POSTselect('cpu_mode', 'qemu64').'>qemu64</option>
							<option class="proxk" value="host" '.POSTselect('cpu_mode', 'host').'>host</option>
							
						</select>
					</div>
				</div>';

				$cpu_flags = [
					'md-clear' => __('Required to let the guest OS know if MDS is mitigated correctly.'),
					'pcid' => __('Meltdown fix cost reduction on Westmere, Sandy-, and IvyBride Intel CPUs.'),
					'spec-ctrl' => __('Allowed improved Spectre mitigation with Intel CPUs.'),
					'ssbd' => __('Protection for Speculative Store Bypass for Intel models.'),
					'ibpb' => __('Allows improved Spectre mitigation with AMD CPUs.'),
					'virt-ssbd' => __('Basis for Speculative Store Bypass protection for AMD models.'),
					'amd-ssbd' => __('Improved Spectre mitigation performance with AMD CPUs, best used with virt-ssbd.'), 
					'amd-no-ssb' => __('Notifies guest OS that host is not vulnerable for Spectre on AMD CPUs.'),
					'pdpe1gb' => __('Allow guest OS to use 1GB size pages, if host HW supports it.'),
					'hv-tlbflush' => __('Improved performance in overcomitted Windows guests. May lead to guest bluescreens on old CPUs.'),
					'hv-evmcs' => __('Improve performance for nested virtualization. Only supported in Intel CPUs.'),
					'aes' => __('Activated AES instruction set for HW accelaration.')
				];

		 					 echo '
								<div class="extra_cpu_flags mx-3 proxk" style="display:none;">
    								<div class="row mx-auto w-100 my-3 extra_cpu_flags proxk" style="display:none;">
										<div class="col-12 p-0">
            								<label class="control-label"><small>'.__('Extra Cpu Flags').'</small>&nbsp;<a class="info" data-placement="right" tooltip="'.__('Supported only on Proxmox 7 and above').'"><i class="fas text-primary fa-info-circle"></i></a></label>
        								</div>
    								</div>';

										foreach($cpu_flags as $flag => $flag_info){
											$class = '';
											if( !empty($cpu_info['amd_cpu']['exception'][$flag])){
												$class .= ' '.implode(' ', $cpu_info['amd_cpu']['exception'][$flag]);
											}elseif(in_array($flag, $cpu_info['amd_cpu']['cpu_flags'])){
												$class .= ' '.implode(' ', $cpu_info['amd_cpu']['cpu_mode']);
											}

											if( !empty($cpu_info['intel_cpu']['exception'][$flag])){
												$class .= ' '.implode(' ', $cpu_info['intel_cpu']['exception'][$flag]);
											}elseif(in_array($flag, $cpu_info['intel_cpu']['cpu_flags'])){
												$class .= ' '.implode(' ', $cpu_info['intel_cpu']['cpu_mode']);
											}

											if( !empty($cpu_info['other_cpu']['exception'][$flag])){
												$class .= ' '.implode(' ', $cpu_info['other_cpu']['exception'][$flag]);
											}elseif(in_array($flag, $cpu_info['other_cpu']['cpu_flags'])){
												$class .= ' '.implode(' ', $cpu_info['other_cpu']['cpu_mode']);
											}
											echo '
											<div class="row mx-auto w-100 my-3 proxk '.$flag.' '.$class.' hide_all_cpu_flags" style="display:none">
												<div class="col-5 p-0">
													<label class="control-label">'.$flag.'&nbsp;<a class="info" data-placement="right" tooltip="'.$flag_info.'"><i class="fas text-primary fa-info-circle"></i></a></label>
												</div>
												<div class="col-2 p-0">
													<label class="custom-control custom-radio">
														<input type="radio" class="custom-control-input" id="'.$flag.'-on" name="'.$flag.'" value="1"   '.POSTradio($flag, 1).'>
														<span class="custom-control-label" for="'.$flag.'">'.__('On').'</span>
													</label>
												</div>
												<div class="col-3 p-0">
													<label class="custom-control custom-radio">
														<input type="radio" class="custom-control-input" id="'.$flag.'-default" name="'.$flag.'" value="0"   '.POSTradio($flag, 0).'>
														<span class="custom-control-label" for="'.$flag.'-clear">'.__('Default').'</span>
													</label>
												</div>
												<div class="col-2 p-0">
													<label class="custom-control custom-radio">
														<input type="radio" class="custom-control-input" id="'.$flag.'-off" name="'.$flag.'" value="2"   '.POSTradio($flag, 2).' >
														<span class="custom-control-label" for="'.$flag.'">'.__('Off').'</span>
													</label>
												</div>
											</div>
											';
										}
						   	echo'</div>
				<div class="row mx-auto w-100 my-3 kvm proxk">
					<div class="col-sm-6 p-0">
						<label class="control-label">'.__('Custom CPU Mode').'</label>&nbsp;<a class="info" data-placement="right" tooltip="'.__('Custom Model should be the exact name which is available in the cpu mode dropdown list on addvs wizard. If not matched then it will not set the custom model.').'"><i class="fas text-primary fa-info-circle"></i></a>
					</div>
					<div class="col-sm-6 p-0">
						<input type="text" class="form-control" name="custom_cpu_model" id="custom_cpu_model" size="6" value="'.POSTval('custom_cpu_model').'" />
					</div>
				</div>
				<div class="row mx-auto w-100 my-3 proxk">
					<div class="col-sm-6 p-0">
						<label class="control-label">'.__('Machine Type').'</label>&nbsp;<a class="info" data-placement="right" tooltip="'.__('Enter the machine type(E.g : pc-i440fx-5.1 or pc-q35-5.1). If not entered properly, default machine type will be selected').'"><i class="fas text-primary fa-info-circle"></i></a>
					</div>
					<div class="col-sm-6 p-0">
						<input type="text" class="form-control" name="machine_type" id="machine_type" value="'.POSTval('machine_type').'" />
					</div>
				</div>
				<div class="row mx-auto w-100 my-3 kvm proxk xcp" id="enable_cpu_topology_row">
					<div class="col-6 p-0">
						<label class="control-label">'.__('CPU Topology').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Specify the number of CPU cores, Threads and Sockets to be assigned to the VPS').'"><i class="fas text-primary fa-info-circle"></i></a></label>
					</div>
					<div class="col-6 p-0">
						'.get_checkbox('enable_cpu_topology', '', 'enable_cpu_topology', array('chk_it' => 1), 1, '', array('onchange="change_cpu_topology();"')).'
					</div>
				</div>
				<div class="row mx-auto w-100 my-3 cpu_topology">
					<div class="col-sm-6 p-0">
						<label class="control-label">Sockets</label>
					</div>
					<div class="col-sm-6 p-0">
						<input type="number" class="form-control numbersonly" name="topology_sockets" id="topology_sockets" size="6" value="'.POSTval('topology_sockets').'" />
					</div>
				</div>
				<div class="row mx-auto w-100 my-3 cpu_topology">
					<div class="col-sm-6 p-0">
						<label class="control-label">Cores</label>
					</div>
					<div class="col-sm-6 p-0">
						<input type="number" class="form-control numbersonly" name="topology_cores" id="topology_cores" size="6" value="'.POSTval('topology_cores').'" />
					</div>
				</div>
				<div class="kvm" id="thread">
					<div class="row mx-auto w-100 my-3 cpu_topology">
						<div class="col-sm-6 p-0">
							<label class="control-label">Threads</label>
						</div>
						<div class="col-sm-6 p-0">
							<input type="number" class="form-control numbersonly" name="topology_threads" id="topology_threads" size="6" value="'.POSTval('topology_threads').'" />
						</div>
					</div>
				</div>';
			
				if(!empty($isos)){
					echo '<div class="row mx-auto w-100 my-3 kvm vzk proxk" id="sec_iso_div">
						<div class="col-sm-6 p-0">
							<label class="control-label">'.__('ISO for secondary CDROM ').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Select an ISO for secondary CDROM').'"><i class="fas text-primary fa-info-circle"></i></a></label>
						</div>
						<div class="col-sm-6 p-0">
					
						<select class="custom-select virt-select" name="sec_iso">
						<option value="0" '.(POSTval('sec_iso') == 0 ? 'selected="selected"' : '').'>'.__('None').'</option>';
					
						foreach($isos as $k => $v){	
							echo '<option value="'.$k.'" '.(POSTval('sec_iso') == $k ? 'selected="selected"' : '').'>'.$v['name'].'</option>';
						}
						
						 echo'</select>
						</div>
					</div>';
				}
			echo '</div>
			<div class="row mx-auto w-100 my-3 kvm xen xenhvm xcp xcphvm" id="vnc_keymap_div">
				<div class="col-sm-6 p-0">
					<label class="control-label">'.__('VNC Console Keymap').'</label>
				</div>
				<div class="col-sm-6 p-0">
					<select class="virt-select" name="vnc_keymap" id="vnc_keymap" >
						<option value="en-us" '.POSTselect('vnc_keymap', 'en-us').'>en-us</option>
						<option value="de-ch" '.POSTselect('vnc_keymap', 'de-ch').'>de-ch</option>
						<option value="ar" '.POSTselect('vnc_keymap', 'ar').'>ar</option>
						<option value="da" '.POSTselect('vnc_keymap', 'da').'>da</option>
						<option value="et" '.POSTselect('vnc_keymap', 'et').'>et</option>
						<option value="fo" '.POSTselect('vnc_keymap', 'fo').'>fo</option>
						<option value="fr-be" '.POSTselect('vnc_keymap', 'fr-be').'>fr-be</option>
						<option value="fr-ch" '.POSTselect('vnc_keymap', 'fr-ch').'>fr-ch</option>
						<option value="hu" '.POSTselect('vnc_keymap', 'hu').'>hu</option>
						<option value="it" '.POSTselect('vnc_keymap', 'it').'>it</option>
						<option value="lt" '.POSTselect('vnc_keymap', 'lt').'>lt</option>
						<option value="mk" '.POSTselect('vnc_keymap', 'mk').'>mk</option>
						<option value="nl" '.POSTselect('vnc_keymap', 'nl').'>nl</option>
						<option value="no" '.POSTselect('vnc_keymap', 'no').'>no</option>
						<option value="pt" '.POSTselect('vnc_keymap', 'pt').'>pt</option>
						<option value="ru" '.POSTselect('vnc_keymap', 'ru').'>ru</option>
						<option value="sv" '.POSTselect('vnc_keymap', 'sv').'>sv</option>
						<option value="tr" '.POSTselect('vnc_keymap', 'tr').'>tr</option>
						<option value="de" '.POSTselect('vnc_keymap', 'de').'>de</option>
						<option value="en-gb" '.POSTselect('vnc_keymap', 'en-gb').'>en-gb</option>
						<option value="es" '.POSTselect('vnc_keymap', 'es').'>es</option>
						<option value="fi" '.POSTselect('vnc_keymap', 'fi').'>fi</option>
						<option value="fr" '.POSTselect('vnc_keymap', 'fr').'>fr</option>
						<option value="fr-ca" '.POSTselect('vnc_keymap', 'fr-ca').'>fr-ca</option>
						<option value="hr" '.POSTselect('vnc_keymap', 'hr').'>hr</option>
						<option value="is" '.POSTselect('vnc_keymap', 'is').'>is</option>
						<option value="ja" '.POSTselect('vnc_keymap', 'ja').'>ja</option>
						<option value="lv" '.POSTselect('vnc_keymap', 'lv').'>lv</option>
						<option value="nl-be" '.POSTselect('vnc_keymap', 'nl-be').'>nl-be</option>
						<option value="pl" '.POSTselect('vnc_keymap', 'pl').'>pl</option>
						<option value="pt-br" '.POSTselect('vnc_keymap', 'pt-br').'>pt-br</option>
						<option value="sl" '.POSTselect('vnc_keymap', 'sl').'>sl</option>
						<option value="th" '.POSTselect('vnc_keymap', 'th').'>th</option>
					</select>
				</div>
			</div>
			<div class="kvm proxk">
				<div class="row mx-auto w-100 my-3" id="kvm_cache_div">
					<div class="col-sm-6 p-0">
						<label class="control-label">'.__('Disk Caching').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Controls the cache mechanism').'"><i class="fas text-primary fa-info-circle"></i></a></label>
					</div>
					<div class="col-sm-6 p-0">
						<select class="custom-select" name="kvm_cache" id="kvm_cache" >
							<option value="0" '.POSTselect('kvm_cache', 'none').'>None</option>
							<option value="writeback" '.POSTselect('kvm_cache', 'writeback').'>Writeback</option>
							<option value="writethrough" '.POSTselect('kvm_cache', 'writethrough').'>Writethrough</option>
							<option value="default" '.POSTselect('kvm_cache', 'default').'>Default</option>
							<option value="directsync" '.POSTselect('kvm_cache', 'directsync').'>Direct Sync</option>
						</select>
					</div>
				</div>

			
				<div class="row mx-auto w-100 my-3 kvm" id="io_mode_div">
					<div class="col-sm-6 p-0">
						<label class="control-label">'.__('I/O Policy').'</label>
					</div>
					<div class="col-sm-6 p-0">
						<select class="custom-select" name="io_mode" id="io_mode" >
							<option value="0" '.POSTselect('io_mode', 'default').'>Default</option>
							<option value="native" '.POSTselect('io_mode', 'native').'>Native</option>
							<option value="threads" '.POSTselect('io_mode', 'threads').'>Threads</option>
							<option value="io_uring" '.POSTselect('io_mode', 'io_uring').'>Io_Uring</option>
						</select>
					</div>
				</div>
				<div class="row mx-auto w-100 my-3 kvm" id="kvm_vga_div">
					<div class=" col-6 p-0">
						<label class="control-label">'.__('Enable VGA').'</label>
					</div>
					<div class=" col-6 p-0">
						'.get_checkbox('kvm_vga', '', 'kvm_vga', array('chk_it' => 1), 1, '', array('onchange="enable_accel();"')).'
					</div>
				</div>
			
				<div class="row mx-auto w-100 my-3 proxk">
					<div class="col-6 p-0">
						<label class="control-label">'.__('Enable NUMA').'</label>
					</div>
					<div class="col-6 p-0">
						'.get_checkbox('numa', '', 'numa').'
					</div>
				</div>
				
				<div class="row mx-auto w-100 my-3" id="set_vga_vram" style="display:none;">
					<div class=" col-6 p-0">
						<label class="control-label">'.__('Set vram').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Set vram for VGA in MB. If not defined or set as 0, vram value will be set as 8MB').'"><i class="fas text-primary fa-info-circle"></i></a></label>
					</div>
					<div class=" col-6 p-0">
						<div class="input-group">
							<input type="number" class="form-control rounded" name="vga_vram" id="vga_vram" size="10" value="'.POSTval('vga_vram', '').'" />
							<div class="input-group-append">
								<span class="input-group-text">MB</span>
							</div>
						</div>
					</div>
				</div>

				<div class="row mx-auto w-100 my-3" id="enable_acceleration" style="display:none;">
					<div class=" col-6 p-0">
						<label class="control-label">'.__('Enable Acceleration').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If checked then 2D and 3D acceleration will be enabled for the VPS').'"><i class="fas text-primary fa-info-circle"></i></a></label>
					</div>
					<div class=" col-6 p-0">
						'.get_checkbox('acceleration', '', 'acceleration').'
					</div>
				</div>
				<div class="row mx-auto w-100 my-3 kvm proxk" id="total_iops_sec_div">
					<div class="col-sm-6 p-0">
						<label class="control-label">'.__('Total I/O\'s per sec').'</label>
					</div>
					<div class="col-sm-6 p-0">
						<input type="number" class="form-control" name="total_iops_sec" value="'.POSTval('total_iops_sec', '').'" />
					</div>
				</div>
				<div class="row mx-auto w-100 my-3 kvm proxk" id="read_bytes_sec_div">
					<div class="col-sm-6 p-0">
						<label class="control-label">'.__('Read Mega Byte\'s/s').'</label>
					</div>
					<div class="col-sm-6 p-0">
						<div class="input-group ">
							<input type="number" class="form-control rounded" name="read_bytes_sec" value="'.POSTval('read_bytes_sec', '').'" />
						  <div class="input-group-append">
							<span class="input-group-text">MB/s</span>
						  </div>
						</div>
					</div>
				</div>
				<div class="row mx-auto w-100 my-3 kvm proxk" id="write_bytes_sec_div">
					<div class="col-sm-6 p-0">
						<label class="control-label">'.__('Write Mega Byte\'s/s').'</label>
					</div>
					<div class="col-sm-6 p-0">
						<div class="input-group ">
							<input type="number" class="form-control rounded" name="write_bytes_sec" value="'.POSTval('write_bytes_sec', '').'" />
						  <div class="input-group-append">
							<span class="input-group-text">MB/s</span>
						  </div>
						</div>
					</div>
				</div>
			</div>';
			
			$os_type = array('other' => 'unspecified OS / Default',
									'wxp' => 'Microsoft Windows XP',
									'w2k' => 'Microsoft Windows 2000',
									'w2k3' => 'Microsoft Windows 2003',
									'w2k8' => 'Microsoft Windows 2008',
									'wvista' => 'Microsoft Windows Vista',
									'win7' => 'Microsoft Windows 7',
									'win8' => 'Microsoft Windows 8/2012/2012r2',
									'win10' => 'Microsoft Windows 10/2016',
									'l24' => 'Linux 2.4 Kernel',
									'l26' => 'Linux 2.6 - 5.X Kernel',
									'solaris' => 'Solaris/OpenSolaris/OpenIndiania kernel'
								);	
			echo '
			<div class="row mx-auto w-100 my-3 proxk">
				<div class="col-sm-6 p-0">
					<label class="control-label">'.__('Select OS Type').' &nbsp;<a class="info" data-placement="right" tooltip="'.__('Setting the proper Operating System(OS) allows Proxmox VE to optimize some low level parameters').'"><i class="fas text-primary fa-info-circle"></i></a></label><br>
				</div>
				<div class="col-sm-6 p-0">
					<select class="custom-select virt-select" name="os_type" id="os_type">';
						foreach($os_type as $os_value => $os_full_form){
							echo '<option value="'.$os_value.'" '.POSTselect('os_type', $os_value).'>'.$os_full_form.'</option>';
						}
				echo'	</select>
				</div>
			</div>';
			
			$rtc = array('0' => __('Disable'),
					 '1' => __('Enable')
					);
			echo '
			<div class="row mx-auto w-100 my-3 proxk">
				<div class="col-sm-6 p-0">
					<label class="control-label">'.__('RTC').' &nbsp;<a class="info" data-placement="right" tooltip="'.__('Set RTC local time. By default for Windows it is enabled').'"><i class="fas text-primary fa-info-circle"></i></a></label><br>
				</div>
				<div class="col-sm-6 p-0">
					<select class="custom-select virt-select" name="rtc" id="rtc">';
						foreach($rtc as $bol => $options){
							echo '<option value="'.$bol.'" '.POSTselect('rtc', $bol).'>'.$options.'</option>';
						}
				echo'	</select>
				</div>
			</div>
			<div class="row mx-auto w-100 my-3 kvm_hvm_div kvm xenhvm xcphvm vzk proxk">
				<div class=" col-6 p-0">
					<label class="control-label">'.__('Enable RDP').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Enable Remote Desktop Connection (For Windows VPS)').'"><i class="fas text-primary fa-info-circle"></i></a></label>
				</div>
				<div class=" col-6 p-0">
					'.get_checkbox('rdp', '', 'rdp').'
				</div>
			</div>	
			<div id="tr_pvonhvm" class="row mx-auto w-100 my-3 pv_on_hvm_div xenhvm">
				<div class=" col-6 p-0">
					<label class="control-label">'.__('PV-on-HVM driver Support').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('The primary goal of PV on HVM is to boost performance of fully virtualized HVM guests through use of specially optimized paravirtual device drivers').'"><i class="fas text-primary fa-info-circle"></i></a></label>
				</div>
				<div class=" col-6 p-0">
					'.get_checkbox('pv_on_hvm', '', 'pv_on_hvm', array('chk_it' => 1, 'val' => @$globals['pv_on_hvm']), 1, '', array('onchange="ispvonhvm();"')).'
				</div>
			</div>
			<div id="tr_viftype" class="row mx-auto w-100 my-3 xenhvm">
				<div class="col-6 p-0">
					<label class="control-label">'.__('Virtual Network Interface Emulation type').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If you want to change the network interface emulation type. Options are <b>netfront</b> or <b>ioemu</b>.').'"><i class="fas text-primary fa-info-circle"></i></a></label>
				</div>
				<div class="col-6 p-0">
					<label class="custom-control custom-radio">
						<input type="radio" name="vif_type" value="netfront" id="netfront" '.POSTradio('vif_type', 'netfront', 'netfront').' class="custom-control-input">
						<span class="custom-control-label" for="netfront">'.__('netfront (default)').'</span>
					</label>
					<label class="custom-control custom-radio">
						<input type="radio" name="vif_type" value="ioemu" id="ioemu" '.POSTradio('vif_type', 'ioemu').' class="custom-control-input">
						<span class="custom-control-label" for="ioemu">'.__('ioemu').'</span>
					</label>
				</div>
			</div>
			<div class="row mx-auto w-100 my-3">
				<div class="col-sm-6 p-0">
					<label class="control-label">'.__('OS Reinstall Limit').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If you want to limit the number of OS re-installs per month. <br />Eg. 0 - is unlimited').'"><i class="fas text-primary fa-info-circle"></i></a></label>
				</div>
				<div class="col-sm-6 p-0">
					<input type="number" class="form-control" name="osreinstall_limit" id="osreinstall_limit"  value="'.POSTval('osreinstall_limit', '').'"/>
				</div>
			</div>
			<div class="row mx-auto w-100 my-3">
				<div class="col-6 p-0">
					<label class="control-label">'.__('Managed by Admin').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If checked, VPS can not be managed from Enduser Panel.').'"><i class="fas text-primary fa-info-circle"></i></a></label>
				</div>
				<div class="col-6 p-0">
					'.get_checkbox('admin_managed', '', 'admin_managed').'
				</div>
			</div>';

			if(!empty($globals['add_ptr_record'])){
				echo '<div class="row mx-auto w-100 my-3">
						<div class="col-6 p-0">
							<label class="control-label">'.__('Do not Add PTR Record').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If Auto Add PTR record setting is enabled in Master settings, PTR record for the VPS will not be added').'"><i class="fas text-primary fa-info-circle"></i></a></label>
						</div>
						<div class="col-6 p-0">
							'.get_checkbox('dont_add_ptr', '', 'dont_add_ptr').'
						</div>
				</div>';
			}

			echo '<div class="row mx-auto w-100 my-3">
				<div class="col-6 p-0">
					<label class="control-label">'.__('Disable password authentication').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If enabled then password authentication will be restricted for SSH.').'"><i class="fas text-primary fa-info-circle"></i></a></label>
				</div>
				<div class="col-6 p-0">
					'.get_checkbox('disable_password', '', 'disable_password').'
				</div>
			</div>
			<div class="row mx-auto w-100 my-3 kvm">
				<div class="col-6 p-0">
					<label class="control-label">'.__('Enable HA').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('HA will be enabled for VPS only if the VPS is created in HA enabled server group').'"><i class="fas text-primary fa-info-circle"></i></a></label>
				</div>
				<div class="col-6 p-0">
					'.get_checkbox('ha', '', 'ha').'
				</div>
			</div>
			
			<div class="row mx-auto w-100 my-3 kvm vzk proxk">
				<div class="col-6 p-0">
					<label class="control-label">'.__('Bios').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Choose bios to boot VPS from. Note: It will work if the VPS is booted from ISO.').'"><i class="fas text-primary fa-info-circle"></i></a></label>
				</div>
				<div class="col-6 p-0">
					<select class="custom-select virt-select" name="bios" id="bios" onchange="toggle_bios();">';
						foreach($bios as $boi => $options){
						echo '<option value="'.$boi.'" '.POSTselect('bios', $boi).'>'.$options.'</option>';
					}
			echo'	</select>
				</div>
			</div>
			<div class="row mx-auto w-100 my-3" id="tpm_row" style="display:none">
				<div class="col-6 p-0">
					<label class="control-label">'.__('Enable TPM').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If checked TPM will be enabled').'"><i class="fas text-primary fa-info-circle"></i></a></label>
				</div>
				<div class="col-6 p-0">
					'.get_checkbox('enable_tpm', '', 'enable_tpm', array('chk_it' => 1, 'name' => 'enable_tpm')).'
				</div>
			</div>
			<div class="row mx-auto w-100 my-3 kvm xen xenhvm xcp xcphvm lxc vzk proxk proxl" id="disable_nw_config_row">
				<div class="col-6 p-0">
					<label class="control-label">'.__('Disable Network configuration').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If checked, Virtualizor will not configure/re-write network when a VPS is rebooted. However, during creation of the VPS, the network file will be written.').'"><i class="fas text-primary fa-info-circle"></i></a></label>
				</div>
				<div class="col-6 p-0">
					'.get_checkbox('disable_nw_config', '', 'disable_nw_config').'
				</div>
			</div>
			<div class="row mx-auto w-100 my-3 proxk">
				<div class="col-6 p-0">
					<label class="control-label">'.__('Enable Discard').'</label>
				</div>
				<div class="col-6 p-0">
					'.get_checkbox('discard', '', 'discard', array('chk_it' => 1), 1).'
				</div>
			</div>
			<!--<div class="row mx-auto w-100 my-3 proxk proxl">
				<div class="col-6 p-0">
					<label class="control-label">'.__('VLAN Tag').'</label>
				</div>
				<div class="col-6 p-0">
					<input type="number" max="4094" class="form-control" name="vlan_tag" id="vlan_tag"  value="'.POSTval('vlan_tag').'"/>
				</div>
			</div>-->
			<div class="row mx-auto w-100 my-3 proxk">
				<div class="col-6 p-0 iothread">
					<label class="control-label">'.__('IO Thread').'</label>
				</div>
				<div class="col-6 p-0 iothread">
					'.get_checkbox('iothread', '', 'iothread').'
				</div>	
			</div>
			<div class="row mx-auto w-100 my-3 proxl">
				<div class="col-6 p-0 nesting">
					<label class="control-label">'.__('Nesting').'</label>
				</div>
				<div class="col-6 p-0 nesting">
					'.get_checkbox('nesting', '', 'nesting').'
				</div>	
			</div>
			<div class="row mx-auto w-100 my-3 proxk kvm">
				<div class="col-6 p-0 ssd_emulation">
					<label class="control-label">'.__('SSD Emulation').'</label>
				</div>
				<div class="col-6 p-0 ssd_emulation">
					'.get_checkbox('ssd_emulation', '', 'ssd_emulation').'
				</div>	
			</div>';
			echo
				'<div class="row mx-auto w-100 my-3">
					<div class=" col-6 p-0">
						<label class="control-label">'.__('CPU Threshold ').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('The CPU Threshold notifies admin when a predefined threshold of CPU usage is exceeded ').'"><i class="fas text-primary fa-info-circle"></i></a></label>
					</div>
					<div class="col-6 p-0">
						'.get_checkbox('enable_cpu_threshold', '', 'enable_cpu_threshold', array('chk_it' => 1), 1, '', array('onchange="checkcputhreshold();"')).'
					</div>
				</div>
				<div id="cputhresholdpercentage" class="input-group">
					<div class="row mx-auto w-100 my-3">
						<div class="col-sm-6 p-0">
							<label class="control-label">'.__('CPU Threshold Percentage').'</label>
						</div>
						<div class="col-sm-6 p-0 input-group">
							<input type="number" min="0" max="100" class="form-control" name="cpu_threshold" id="cpu_threshold" size="6" value="'.POSTval('cpu_threshold', '').'"/> 
							<span class="input-group-text">%</span>
						</div>
					</div>
					<div class="row mx-auto w-100">
						<div class="col-sm-6 p-0">
							<label class="control-label">'.__('CPU Threshold Time').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('The threshold time is divided by 5, and we will check the CPU usage on each interval. If CPU usage is above the threshold value for each interval then at the last interval we will suspend the VPS').'"><i class="fas text-primary fa-info-circle"></i></a></label>
						</div>
						<div class="col-sm-6 p-0 input-group">
							<input type="number" min="0" class="form-control" name="cpu_threshold_time" id="cpu_threshold_time" size="30" value="'.POSTval('cpu_threshold_time', '').'"/> 
							<span class="input-group-text">
								<i class="fas fa-stopwatch" style="color: #000000;"></i>
							</span>
						</div>
					</div>
				</div>
				<div class="row mx-auto w-100 my-3">
					<div class="col-6 p-0 hide_for_plan d-flex align-items-center">
						<label class="control-label">'.__('Enable Demo').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('When enabled VPS will Suspended/Deleted once demo period is expired').'"><i class="fas text-primary fa-info-circle"></i></a></label>
					</div>	
					<div class="col-4 p-0">
						'.get_checkbox('show_demo', '', 'demo', array('chk_it' => 1, 'name' => 'demo'), 1, '', array('onchange="checkdemo();change_checkbox(\'demo\');"')).'
						<input type="hidden" name="enable_demo" id="hidden_demo">
					</div>
				</div>
				<div class="row mx-auto w-100">
					<div class="col-6 p-0"></div>
					<div id="demo_days" class="col-sm-6 p-0" style="display:none;">
						<div class="input-group ">
							<input type="number" class="form-control rounded" name="demo_duration" id="demo_duration" size="10" value="'.POSTval('demo_duration', '').'" placeholder="'.__('Demo duration in Day(s)').'"/>
							<div class="input-group-append">
								<span class="input-group-text">'.__('Day(s)').'</span>
							</div>
						</div>
					</div>
				</div>
				<div class="row mx-auto w-100 my-3" id="demo_action_options" style="display:none;">
					<div class="col-sm-6 p-0">
						<label class="control-label">'.__('Demo Action').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Action to be taken once the Demo period is expired').'"><i class="fas text-primary fa-info-circle"></i></a></label>
					</div>
					<div class="col-sm-6 p-0">
						<label class="custom-control custom-radio">
							<input type="radio" class="custom-control-input" name="demo_action" value="0" id="demo_delete_action" '.POSTradio('demo_action', "0").'>
							<span class="custom-control-label" for="demo_delete_action">'.__('VPS will be deleted').'</span>
						</label>
						<label class="custom-control custom-radio">
							<input type="radio" class="custom-control-input" name="demo_action" value="1" id="demo_suspend_action" '.POSTradio('demo_action', "1").'>
							<span class="custom-control-label" for="demo_suspend_action">'.__('VPS will be suspended').'</span>
						</label>
					</div>
				</div>
				<div class="row mx-auto w-100 my-3 proxk">
					<div class="col-sm-6 p-0">
						<label class="control-label">'.__('Graphic Card').'</label>
					</div>
					<div class="col-sm-6 p-0">
						<select class="custom-select" name="vga" id="vga">
							<option value="" '.POSTselect('vga', '').'>Default</option>
							<option value="std"  '.POSTselect('vga', 'std').'>Standard VGA</option>
							<option value="vmware"  '.POSTselect('vga', 'vmware').'>VMware Compatible</option>
							<option value="qxl"  '.POSTselect('vga', 'qxl').'>SPICE</option>
							<option value="qxl2"  '.POSTselect('vga', 'qxl2').'>SPICE dual monitor</option>
							<option value="qxl3"  '.POSTselect('vga', 'qxl3').'>SPICE three monitor</option>
							<option value="qxl4"  '.POSTselect('vga', 'qxl4').'>SPICE four monitor</option>
							<option value="serial0"  '.POSTselect('vga', 'serial0').'>Serial Terminal 0</option>
							<option value="serial1"  '.POSTselect('vga', 'serial1').'>Serial Terminal 1</option>
							<option value="serial2"  '.POSTselect('vga', 'serial2').'>Serial Terminal 2</option>
							<option value="virtio"  '.POSTselect('vga', 'virtio').'>VirtIO-GPU</option>
							<option value="virtio-gl"  '.POSTselect('vga', 'virtio-gl').'>VirtGL GPU</option>
							<option value="none"  '.POSTselect('vga', 'none').'>None</option>
						</select>
					</div>
				</div>
				<div class="row mx-auto w-100 my-3 proxk">
					<div class="col-sm-6 p-0">
						<label class="control-label">'.__('Graphic Card Memory (MB)').'<a class="info" data-placement="right" tooltip="'.__('Graphir Card Memory should be less then or equal to 512').'"><i class="fas text-primary fa-info-circle"></i></a></label>
					</div>
					<div class="col-sm-6 p-0">
						<input type="number" min="0" max="512" class="form-control"  name="vga_memory" id="vga_memory" value="'.POSTval('vga_memory', '').'"/>
					</div>
				</div>';
			if(check_licensepro()){
				echo'
				<div class="row mx-auto w-100 kvm">
					<div class="col-6 p-0">
						<label class="control-label">'.__('Enable vertical scaling').'</label>
					</div>
					<div class="col-6 p-0">
						'.get_checkbox('enable_ver_scaling', '', 'enable_ver_scaling').'
					</div>
				</div>
				<div class="row mx-auto w-100 ver_scale_settings">
					<div class="col-sm-12 p-2">
						<fieldset class="user_details_f" >
							<legend class="user_details_f mb-0">'.__('Vertical Scaling Settings').'</legend>
							<div class="row mx-auto w-100">
								<div class="col-sm-12 notice">
									'.__('<ol class="pl-2 mb-1">
<li>Vertical scaling is supported on KVM based virtualization only.</li>
<li>QEMU version should be greater than or equal to 1.5, To check QEMU Version run "/usr/bin/virsh version"</li>
<li>Vertical scaling is currently not supported on Windows VPS</li>
</ol>').'
								</div>
							</div>
							<h5>'.__('RAM Settings').'</h5>
							<div class="row mx-auto w-100 my-3">
								<div class="col-sm-6 p-0">
									<label class="control-label">'.__('Max RAM (in MB)').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Provide the maximum amount of RAM that will be allocated to VPS ').'"><i class="fas text-primary fa-info-circle"></i></a></label>
								</div>
								<div class="col-sm-6 p-0">
									<input type="text" class="form-control" name="ver_max_ram" value="'.POSTval('ver_max_ram').'" />
								</div>
							</div>
							<div class="row mx-auto w-100 my-3">
								<div class="col-sm-6 p-0">
									<label class="control-label">'.__('RAM Threshold (in %)').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If the VPS RAM usage is greater/less than threshold provided scaling will be performed accordingly').'"><i class="fas text-primary fa-info-circle"></i></a></label>
								</div>
								<div class="col-sm-6 p-0">
									<input type="text" class="form-control" name="ver_ram_threshold" value="'.POSTval('ver_ram_threshold').'" />
								</div>
							</div>
							<div class="row mx-auto w-100 my-3">
								<div class="col-sm-6 p-0">
									<label class="control-label">'.__('Increase/Decrease RAM By (in GB)').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If the threshold exceeds/subceeds, the provided RAM (in GB) will be increased or decreased accordingly').'"><i class="fas text-primary fa-info-circle"></i></a></label>
								</div>
								<div class="col-sm-6 p-0">
									<input type="text" class="form-control" name="ver_ram_inc_by" value="'.POSTval('ver_ram_inc_by').'" />
								</div>
							</div>
							<hr>
							<h5>'.__('CPU Settings').'</h5>
							<div class="row mx-auto w-100 my-3">
								<div class="col-sm-6 p-0">
									<label class="control-label">'.__('Max CPU Cores').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Provide the maximum amount of cpu cores that will be allocated to VPS ').'"><i class="fas text-primary fa-info-circle"></i></a></label>
								</div>
								<div class="col-sm-6 p-0">
									<input type="text" class="form-control" name="ver_max_cpu" value="'.POSTval('ver_max_cpu').'" />
								</div>
							</div>
							<div class="row mx-auto w-100 my-3">
								<div class="col-sm-6 p-0">
									<label class="control-label">'.__('CPU Threshold (in %)').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If the VPS cpu usage is greater/less than threshold provided scaling will be performed accordingly').'"><i class="fas text-primary fa-info-circle"></i></a></label>
								</div>
								<div class="col-sm-6 p-0">
									<input type="text" class="form-control" name="ver_cpu_threshold" value="'.POSTval('ver_cpu_threshold').'" />
								</div>
							</div>
							<div class="row mx-auto w-100 my-3">
								<div class="col-sm-6 p-0">
									<label class="control-label">'.__('Increase/Decrease CPU Cores By').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If the threshold exceeds/subceeds, the provided cores will be increased or decreased accordingly').'"><i class="fas text-primary fa-info-circle"></i></a></label>
								</div>
								<div class="col-sm-6 p-0">
									<input type="text" class="form-control" name="ver_cpu_inc_by" value="'.POSTval('ver_cpu_inc_by').'" />
								</div>
							</div>
						</fieldset>
					</div>
				</div>';
			}
			echo'
		</div><br>
	
		
		<div class="roundheader cursor-pointer" onclick="toggle_advoptions(\'network\');"><label id="network_advoptions_ind" class="min_width">-</label> &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'.__('Network Settings').'</div>
		<div id="network_advoptions" class="bgaddv w-100">
			<div class="row mx-auto w-100 my-3">
				<div class="col-sm-6 p-0">
					<label class="control-label">'.__('Upload Speed').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Enter 0 or leave empty for no restriction. <br /> Enter -1 for upload speed to be same as <b>Network Speed.</b> <br />Use the select box for easy options').'"><i class="fas text-primary fa-info-circle"></i></a></label>
				</div>
				<div class="col-sm-6 p-0">
					<div class="row mx-auto w-100">
						<div class="col-4 p-0"><input type="number" class="form-control" name="upload_speed" id="upload_speed" size="8" value="'.POSTval('upload_speed', '-1').'" onchange="handle_capping();" />
						</div>
						<div class="col-2 p-0 p-1 pt-2 square mr-1">'.__('KB/s').'
						</div>
						<div class="col-6 p-0"><select class="custom-select speedkBps" name="upload_speed2" id="upload_speed2" onchange="upspeed(this.value)"></select>
						</div>
					</div>
				</div>
			</div>';
			echo '<div class="row mx-auto w-100 my-3 kvm xen xenhvm vzk xcp xcphvm proxk">
				<div class="col-sm-6 p-0">
					<label class="control-label">'.__('Virtual Network Interface Type').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Virtual Network Interface Type').'"><i class="fas text-primary fa-info-circle"></i></a></label>
				</div>
				<div class="col-sm-6 p-0">
					<select class="nic_type custom-select w-100 side_text" name="nic_type" id="nic_type" >';
						foreach($supported_nics as $k => $v){
							echo '<option value="'.$v.'" '.POSTselect('nic_type', $v).'>'.(!empty($nics_lang[$v]) ? $nics_lang[$v] : $v).'</option>';
						}
					echo '</select>
				</div>
			</div>';
			echo '
			<div class="row mx-auto w-100 my-3">
				<div class=" col-6 p-0">
					<label class="control-label">'.__('Bandwidth suspend ').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Suspend the VPS if it is uses more than specified bandwidth').'"><i class="fas text-primary fa-info-circle"></i></a></label>
				</div>
				<div class=" col-6 p-0">
					'.get_checkbox('band_suspend', '', 'band_suspend', array('chk_it' => 1), 1, '', array('onchange="handle_capping();"')).'
				</div>
			</div>
			<div id="speed_cap_limit">
				<div class="row mx-auto w-100 my-3">
					<div class=" col-sm-6 p-0">
						<label class="control-label">'.__('Capped Download Speed ').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Download speed after the bandwidth is overused for a VPS, 0 or emtpy value indicates no capping').'"><i class="fas text-primary fa-info-circle"></i></a></label>
					</div>
					<div class=" col-sm-6 p-0">
						<div class="row mx-auto w-100">
							<div class="col-4 p-0">
								<input type="number" class="form-control rounded" name="speed_cap_down" id="speed_cap_down" value="'.POSTval('speed_cap_down').'" onmouseout="blur();"/>
							</div>
							<div class="col-2 p-0 p-1 pt-2">
								'.__('KB/s').'
							</div>
							<div class="col-6 p-0">
								<select class="custom-select speedkBps" name="speed_cap_down2" id="speed_cap_down2" onchange="$(\'#speed_cap_down\').val(this.value)"></select></select>
							</div>
						</div>
					</div>		
				</div>
				<div class="row mx-auto w-100 my-3">
					<div class=" col-sm-6 p-0">
						<label class="control-label">'.__('Capped Upload Speed ').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Upload speed after the bandwidth is overused for a VPS.<br /> If VPS upload speed -1 then  Capped upload speed will be same as <b>Capped Download Speed</b><br />0 or emtpy value indicates no capping').'"><i class="fas text-primary fa-info-circle"></i></a></label>
					</div>
					<div class=" col-sm-6 p-0">
						<div class="row mx-auto w-100">
							<div class="col-4 p-0">
								<input type="number" class="form-control rounded" name="speed_cap_up" id="speed_cap_up" value="'.POSTval('speed_cap_up').'" onmouseout="blur();" />
							</div>
							<div class="col-2 p-0 p-1 pt-2">
								'.__('KB/s').'
							</div>
							<div class="col-6 p-0">
								<select class="custom-select speedkBps" name="speed_cap_up2" id="speed_cap_up2" onchange="$(\'#speed_cap_up\').val(this.value)"></select>
							</div>
						</div>
					</div>
				</div>
			</div>
			<div class="row mx-auto w-100 my-3">
				<div class="col-sm-6 p-0">
					<label class="control-label">'.__('DNS Nameservers').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If not aware then use 4.2.2.1 and 4.2.2.2').'"><i class="fas text-primary fa-info-circle"></i></a></label>
				</div>
				<div class="col-sm-6 p-0">
					<div class="row mx-auto w-100 my-1">
							<div class="col-sm-12 p-0" id="dnstable">';
						 
								$_dns = (isset($_POST['dns']) ? $_POST['dns'] : []);
								
								if(is_array($_dns) && !empty($_dns)){
									foreach($_dns as $d => $ds){
										if(empty($ds)){
											unset($_dns[$d]);
										}
									}
								}
								
								if(empty($_dns)){
									$_dns = array(NULL);
								}
							 
								foreach($_dns as $dn){
									echo '<div class="row mx-auto w-100 my-1">
										<div class="col-sm-11 p-0">
											<input type="text" class="form-control w-100" name="dns[]" value="'.$dn.'"/>
										</div>
									</div>';
								}
								
							echo '
								
							</div>
						</div>
					<input type="button" class="btn blue_btn py-1 px-2" onclick="adddnsrow(\'dnstable\')" value="'.__('+').'"/>
					<span class="help-block"></span>
				</div>
			</div>
		</div><br>';
		
		if(!empty($globals['inhouse_billing'])){
	
		echo '
		<div class="roundheader cursor-pointer" onclick="toggle_advoptions(\'pricing\');"><label id="pricing_advoptions_ind" class="min_width" >-</label> &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'.__('Pricing').'</div>
		<div id="pricing_advoptions" class="bgaddv w-100" >
			<div class="row mx-auto w-100 my-3 ">
				<div class="col-2 p-0"><label>'.__('Regions').'</label></div>

					<div class="col-3">
						<label>'.__('Hourly Rate').'</label>
					</div>
					<div class="col-3 text-center">
						<label>'.__('Monthly Rate').'</label>
					</div>
					<div class="col-3 text-center">
						<label>'.__('Yearly Rate').'</label>
					</div>
			</div><hr />
			<div class="row mx-auto w-100 my-3" id="pricerowscontainer" >
			</div>
			<div class="row mx-auto w-100 my-3">
				<div class="col-sm-12 text-right p-0">
					<button type="button" class="btn blue_btn py-2 px-2" data-toggle1="modal" data-target1="#selectregionforpricing" onclick="selectregmod();" ><i class="fas fa-plus"></i></button>
				</div>
			</div>
			<div class="modal fade" id="selectregionforpricing" role="dialog">
				<div class="modal-dialog">
					<div class="modal-content">
						<div class="modal-header">
							<div class="modal-title float-left"><b>'.__('Select Region').'</b></div>
							<div class="close" data-dismiss="modal">X</div>
						</div>
						<div class="modal-body"></div>
					</div>
				</div>
			</div>
		</div>
		<script>
			var ratetypes = ["h_rate", "m_rate", "y_rate"];
			
			// tmpsgs will act as a bucket, and store servergroups currently for which pricing is not added.
			var tmpsgs = JSON.parse(JSON.stringify(servergroups));
			
			// Fill and display modal with available servergroups
			function selectregmod(){
				if(JSON.stringify(tmpsgs) == "{}"){
					showalert("'.__J('No more regions left to add').'" ,"1");
					return;
				}
				
				var dv = "";
				dv += "<div class=\"row mh-25 p-1 overflow-auto\" id=\"sglist\">";
				for(var x in tmpsgs){
					if(tmpsgs.hasOwnProperty(x) && tmpsgs[x] != null){
						dv += "<div class=\"col-sm-6 p-0 selregrowclass\">";
							dv += "<div class=\"row\" id=\""+tmpsgs[x].sgid+"\" onclick=\"moreregionpricing(this); $(this).removeAttr(\'onclick\'); $(this).css(\'background-color\', \'var(--primary_color)\'); $(this).css(\'color\', \'var(--always_white)\');\">";
								dv += "<div class=\"col-sm-1\">"+(tmpsgs[x].sgid == -1 ? "*" : tmpsgs[x].sgid)+"</div>";
								dv += "<div class=\"col-sm-10\">"+tmpsgs[x].sg_name+"</div>";
							dv += "</div>";
						dv += "</div>";
					}
				}
				dv += "</div>";
				$("#selectregionforpricing .modal-body").html(dv);
				$("#selectregionforpricing").modal({keyboard: true});
				$("#selectregionforpricing").modal({show:true});
			}
			
			// Add selected region (servergroup) pricing row
			function moreregionpricing(selreg, reload){
				// Return back if we do not have a valid servergroup to add or if we are not reloading old values back.
				if(reload != 1 && (selreg == "" || $(selreg).attr("id") == null)){
					return false;
				}
		
				// Extract sgid
				var rsgid = (reload == 1 ? selreg : $(selreg).attr("id"));
		
				// Construct div for this sgid:
				var prow = "";
				prow += "<div class=\"row mx-auto w-100 my-1\" id=\"pricerow"+rsgid+"\">";
				prow += "<div class=\"col-2 p-0 text-break\">";
				prow += "<label>"+servergroups[rsgid].sg_name+"</label>";
				prow += "</div>";
				for(var i in ratetypes){
					prow += "<div class=\"col-3\">";
					prow += "<input type=\"number\" step=\"0.001\" class=\"form-control\" name=\""+ratetypes[i]+"["+rsgid+"]\" id=\""+ratetypes[i]+"["+rsgid+"]\" value=\"\" />";
					prow += "</div>";
				}
					
				prow += "<div class=\"col-1 my-2 text-right\">";
				prow += "<button type=\"button\" class=\"btn red_btn py-2 px-2\" onclick=\"removepricing(this)\"><i class=\"fas fa-minus\"></i></button>";
				prow += "</div>";
				prow += "</div>";
				
				
				// Append this new div to pricerowcontainer div
				$("#pricerowscontainer").append(prow);
				
				// Remove this servergroup from the tmpsgs bucket
				delete tmpsgs[rsgid];
			}
			
			// Remove selected region pricing row
			function removepricing(id){
				// Remove selected pricing region
				$("#"+$(id).parents().eq(1).attr("id")).remove();
				
				// Get Pricing Region ID (ie id of servergroup in servergroups)
				var tmpsgid = parseInt(/\-?\d+/.exec($(id).parents().eq(1).attr("id")));
		
				// If we did not got expected ID
				if(isNaN(tmpsgid)){
					showalert("'.__J('Delete ID not found').'" ,"1");
					return false;
				}
				// Add removed servergroup back to tmpsgs bucket
				tmpsgs[tmpsgid] = servergroups[tmpsgid];
			}
		';
			
			// Are the rates posted ? Then we must add them
			if(!empty($_POST['h_rate'])){
				
				echo '
					$("#pricing_advoptions_ind").text(" - ");
					$("#pricing_advoptions").slideDown("slow");
				';
				
				foreach($_POST['h_rate'] as $kk => $vv){
					echo '
					moreregionpricing('.$kk.', 1);
					$("#h_rate\\\["+'.$kk.'+"\\\]").val("'.$_POST['h_rate'][$kk].'");
					$("#m_rate\\\["+'.$kk.'+"\\\]").val("'.$_POST['m_rate'][$kk].'");
					$("#y_rate\\\["+'.$kk.'+"\\\]").val("'.$_POST['y_rate'][$kk].'");
					';
					
				}
				
			}
			
		echo '</script>';

		}echo'
	</div>
</div>
';

echo '</div><br>
<center><input type="submit" name="addplan" value="'.__('Save Plan').'" class="go_btn"></center><br><br><br>
</form>
</div>';

softfooter();

}

