<?php

//////////////////////////////////////////////////////////////
//===========================================================
// addippool_theme.php
//===========================================================
// SOFTACULOUS VIRTUALIZOR
// Version : 1.0
// Inspired by the DESIRE to be the BEST OF ALL
// ----------------------------------------------------------
// Started by: Alons
// Date:       8th Mar 2010
// Time:       23:00 hrs
// Site:       https://www.virtualizor.com/ (SOFTACULOUS VIRTUALIZOR)
// ----------------------------------------------------------
// Please Read the Terms of use at https://www.virtualizor.com
// ----------------------------------------------------------
//===========================================================
// (c)Softaculous Ltd.
//===========================================================
//////////////////////////////////////////////////////////////

if(!defined('VIRTUALIZOR')){

	die('Hacking Attempt');

}

function addippool_theme(){

global $theme, $globals, $kernel, $user, $l, $cluster, $error, $servers, $done, $ips, $virt, $servergroups, $users, $pdns_servers;

softheader($l['<title>']);
					
echo page_header(__('Add IP Pool'), 'icon icon-ippool',$globals['docs'].'add-ip-pool/', 0, 0);

$breadcrumbs = array('dashboard', 'lm_ippool', 'lms_addippool');

echo get_breadcrumb($breadcrumbs);

error_handle($error);

if(!empty($done)){
	show_alert(__('The IP Pool has been saved. Return to <a href="index.php?act=ippool">IP Pool Overview</a>'),"0","ippool");

	if(!empty($done['ipv6_subnet'])){
		show_alert(__('To generate IPv6 Subnets click <a href="index.php?act=addiprange&ippid=$0">here</a>', array($done['ipv6_subnet'])),"0","ippool");
	}
	
}else{

	echo '<script language="javascript" type="text/javascript">

	$(document).ready(function(){
		$("#uid").on("change", function(){		
			var temp = new Array("routing", "internal", "nat", "vlan");
			$("#internal").prop("disabled", false);
			$.each(temp, function(k , v){
				if($("#"+v).prop("checked") == true){
					changeipsettings(v);
				}
			})
			handle_user()
		});
	})

	function handle_user(){
		if($("#uid").val() > 0){
			if($("#internal").prop("checked") == true){
				$("#internal").trigger("click");
			}else{
				$("#internal").prop("checked", false);
			}
			$("#internal").prop("disabled", true);
			$("#internal_bridge_tr").hide();
		}
	}

	function addrow(id){
		var t = $_(id);

		var row = document.createElement("div");
		row.className = "row mx-auto w-100 my-3";
		var col1 = document.createElement("div");
		col1.className = "col-5 ip-mac p-0 d-flex align-items-center";
		var col2 = document.createElement("div");
		col2.className = "col-6 ip-mac p-0 d-flex align-items-center";

		col1.innerHTML = \'<label class="p-0">'.__J('IP').' :&nbsp;&nbsp;</label><input type="text" class="form-control w-75 m-0" name="ips[]"/>\';
		col2.innerHTML = \'<label class="p-0">'.__J('MAC').' :&nbsp;&nbsp;</label><input type="text" class="form-control w-75 m-0" name="macs[]"/><a class="delip pl-1" ><i class="fas fa-times text-danger cursor-pointer py-2"></i></a>\';
		
		row.appendChild(col1);
		row.appendChild(col2);
		t.appendChild(row);
		$(".delip").each(function(){
			$(this).unbind("click");
			$(this).click(function(){
				var parent = $(this).parent();
				var parent2 = $(this).parent().parent();
				parent.remove();
				parent2.remove();
			});
		});
	};

	function ipv6_subnet_gen(){
		if(is_checked("ipv6_subnet")){
			$("#ipv6_range").hide();
			$("#ipv6_num").hide();
		}else{
			$("#ipv6_range").show();
			$("#ipv6_num").show();
		}
	}
		
	function changetype(iptype){
		$_("ipv4").className = "nav-link";
		$_("ipv6").className = "nav-link";
		var namesever = "";
		if (iptype == 4){
			$(".ipv4").show();
			$(".ipv6").hide();
			$("#ns1").attr("tooltip", "'.__J('If not aware then use 4.2.2.1').'");
			$("#ns2").attr("tooltip", "'.__J('If not aware then use 4.2.2.2').'");
			$_("ns_1").value="";
			$_("ns_2").value="";
			$_("gateway").value="";
			if($("#internal").attr("checked")){
				$_("internal_bridge_tr").style.display="";
			}
			if($("#vlan").attr("checked")){
				$_("vlan_bridge_tr").style.display="";
			}
			$_("netmask").style.width="100%";
			$("#4_space").addClass("help-block");
			handle_user()
		}else{

			$(".ipv4").hide();
			$(".ipv6").show();
			$("#ns1").attr("tooltip", "'.__J('If not aware then use 2001:4860:4860::8888').'");
			$("#ns2").attr("tooltip", "'.__J('If not aware then use 2001:4860:4860::8844').'");
			$_("ns_1").value="";
			$_("ns_2").value="";
			$_("gateway").value="";
			if($("#vlan").attr("checked")){
				$_("vlan_bridge_tr").style.display="";
			}
			ipv6_subnet_gen();
			$("#4_space").removeClass("help-block");
		}	
		
		$_("ipv"+iptype).className = "active nav-link";
		$_("iptype").value = iptype;
		show_tooltip();
		
	};

	function changeDNS(ips){
		ip = ips.split(\',\');
		$("input[type=text][name=ns1]").val(ip[0]);
		$("input[type=text][name=ns2]").val(ip[1]);
	}

	function handletr(){
		
		var serid = $("#serid").val();
		if(serid == "-1"){
			$("#nat_tr").hide();
			$("#routing_tr").hide();
		}else{
			if($_("iptype").value == 4){
				$("#nat_tr").show();
			}
			$("#routing_tr").show();
		}
	};

	function changeipsettings(id){
		
		var temp = new Array("routing", "internal", "nat", "vlan");
					
		if(is_checked(id)){
			$("#"+id).removeAttr("disabled");
			
			if(id == "internal"){
				$("#internal_bridge_tr").show();
			}
			
			if(id == "vlan"){
				$("#vlan_bridge_tr").show();
			}
			
			for(x in temp){
				if(temp[x] != id){
					$("#"+temp[x]).attr("disabled", "disabled");
					if(temp[x] == "internal"){
						$("#internal_bridge_tr").hide();
					}
					if(temp[x] == "vlan"){
						$("#vlan_bridge_tr").hide();
					}
				}
			}
			
		}else{
			
			for(x in temp){
				$("#"+temp[x]).removeAttr("disabled");
				if(temp[x] == "internal"){
					$("#internal_bridge_tr").hide();
				}
				if(temp[x] == "vlan"){
					$("#vlan_bridge_tr").hide();
				}
			}
			
		}
		handle_user()
			
	};

	addonload("changetype('.POSTval('iptype', 4).');handletr();");
	</script>
	<div id="form-container" class="card p-2 mx-3">
		<form accept-charset="'.$globals['charset'].'" name="addippool" method="post" action="" class="form-horizontal">

			<input type="hidden" id="iptype" name="iptype" value="'.POSTval('iptype', 4).'">

			<ul class="nav nav-tabs">
				<li class="col-4"><label class="control-label mx-auto my-3">'.__('Type').'</label></li>
				<li class="col-4 nav-item text-center"><a href="javascript:changetype(4);" class="nav-link active" id="ipv4"><h4>IPv4</h4></a></li>
				<li class="col-4 nav-item text-center"><a href="javascript:changetype(6);" class="nav-link" id="ipv6"><h4>IPv6</h4></a></li>
			</ul>
			<div class="row mx-auto w-100 my-3">
				<div class="col-sm-4">
					<label class="control-label">'.__('Server').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('NOTE : NAT and Routing is allowed for only one server').'"><i class="fas text-primary fa-info-circle"></i></a></label>
				</div>
				<div class="col-sm-4">';
				
					$POSTserid = @$_POST['serid'];
					$POSTserid = empty($POSTserid) ? array() : $POSTserid;
					
					echo '<select class="form-control" name="serid[]" id="serid" size="8" onchange="handletr();" multiple="multiple">
						<option value="-1" '.(in_array(-1, $POSTserid) ? 'selected="selected"' : '').'>'.__('All Servers').'</option>';
						
						foreach ($servergroups as $k => $v){
							echo '<option class="fhead" value="'.$k.'_group" '.(in_array($k.'_group', $POSTserid) ? 'selected="selected"' : '').'>[Group]&nbsp;'.$v['sg_name'].'</option>';
							
							foreach ($servers as $m => $n){
								if($n['sgid'] == $k){
									echo '<option value="'.$n['serid'].'" '.(in_array((string)$n['serid'], $POSTserid) ? 'selected="selected"' : '').'>&nbsp;&nbsp;&nbsp;&nbsp;-&nbsp;'.$n['server_name'].'</option>';
								}
							}
						}
				echo '</select>
					</div>
			</div>
			<span class="help-block"></span>
			<div class="row mx-auto w-100 my-3">
				<div class="col-sm-4">
					<label class="control-label">'.__('Name').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('The name of this IP Pool').'"><i class="fas text-primary fa-info-circle"></i></a></label>
				</div>
				<div class="col-sm-4"><input type="text" class="form-control" name="ippool_name" id="ippool_name" size="30" value="'.POSTval('ippool_name', '').'" /></div>
				<div class="col-sm-4"></div>
			</div>

			<div class="row mx-auto w-100 my-3">
				<div class="col-sm-4"><label class="control-label">'.__('Gateway').'</label></div>
				<div class="col-sm-4"><input type="text" class="form-control" id="gateway" name="gateway" value="'.POSTval('gateway', '').'" size="30"></div>
				<div class="col-sm-4"></div>
			</div>
			<span class="help-block"></span>
			<div class="row mx-auto w-100 my-3">
				<div class="col-sm-4">
					<label class="control-label">'.__('Netmask').'</label>
					<span class="ipv6" id="netmask_6">
						<label class="control-label">'.__('(Routing Prefix)').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Integer between 1-128').'"><i class="fas text-primary fa-info-circle"></i></a></label>
					</span>
				</div>
				<div class="col-sm-4 d-flex align-items-center">
					<label id="6_slash" class="float-left pr-3 pt-1 ipv6" style="width: 0%;">/</label>
					<input id="netmask" type="text" class="form-control" name="netmask" value="'.POSTval('netmask', '').'" size="30" >
				</div>
			</div>
			<span id="4_space"></span>
			<div class="row mx-auto w-100 my-3">
				<div class="col-sm-4">
					<label class="control-label">'.__('Nameserver').' 1&nbsp;<a class="info" data-placement="right"   id="ns1"><i class="fas text-primary fa-info-circle"></i></a></label>
				</div>
				<div class="col-sm-4">
					<input type="text" class="form-control" id = "ns_1" name="ns1" value="'.POSTval('ns1', '').'" size="30">
				</div>
				<div class="col-sm-4">
					<span class="ipv4" id="ipv4_ns"><a href="javascript:changeDNS(\'8.8.8.8,8.8.4.4\');">[Google]</a>&nbsp;<a href="javascript:changeDNS(\'208.67.222.222,208.67.220.220\');">[Open DNS]</a>&nbsp;<a href="javascript:changeDNS(\'8.26.56.26,8.20.247.20\');">[Comodo]</a>&nbsp;<a href="javascript:changeDNS(\'208.76.50.50,208.76.51.51\');">[Smart Viper]</a></span>
					<span class="ipv6" id="ipv6_ns"><a href="javascript:changeDNS(\'2001:4860:4860::8888,2001:4860:4860::8844\');">[Google]</a></span>
				</div>
			</div>

			<div class="row mx-auto w-100 my-3">
				<div class="col-sm-4">
					<label class="control-label">'.__('Nameserver').' 2&nbsp;<a class="info" data-placement="right" id="ns2"><i class="fas text-primary fa-info-circle"></i></a></label>
				</div>
				<div class="col-sm-4">
					<input type="text" class="form-control" id = "ns_2" name="ns2" value="'.POSTval('ns2', '').'" size="30">
				</div>
			</div>

			<div class="row mx-auto w-100 my-3 ipv4" id="firstip">
				<div class="col-sm-4">
					<label class="control-label">'.__('First IP').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Please specify the First IP <b>if</b> you want to add a range to the IP Pool.').'"><i class="fas text-primary fa-info-circle"></i></a></label> 
				</div>
				<div class="col-sm-4"><input type="text" class="form-control" name="firstip" value="'.POSTval('firstip', '').'" size="30"></div>
			</div>

			<div class="row mx-auto w-100 my-3 ipv4" id="lastip">
				<div class="col-sm-4">
					<label class="control-label">'.__('Last IP').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Please specify the Last IP <b>if</b> you want to add a range to the IP Pool.').'"><i class="fas text-primary fa-info-circle"></i></a></label>
				</div>
				<div class="col-sm-4"><input type="text" class="form-control" name="lastip" value="'.POSTval('lastip', '').'" size="30"></div>
			</div>';
			if(!empty($users)){
			echo'
			<div class="row mx-auto w-100 my-3">
				<div class="col-sm-4">
					<label class="control-label">'.__('Select User').' &nbsp;<a class="info" data-placement="right" tooltip="'.__('Select user for which you want to assign this IP pool').'"><i class="fas text-primary fa-info-circle"></i></a></label>
				</div>
				<div class="col-sm-4">
					<select name="uid" class="virt-select" id="uid">
					<option value="0">--</option>';
					foreach($users as $uk => $uv){
						echo '<option value="'.$uk.'" '.POSTselect('uid', $uk).'>'.$uv['email'].'</option>';
					}
					echo'
					</select>
				</div>
			</div>';
			}
			if(!empty($pdns_servers)){
			echo'
			<div class="row mx-auto w-100 my-3">
				<div class="col-sm-4">
					<label class="control-label">'.__('Select PDNS Server').' &nbsp;<a class="info" data-placement="right" tooltip="'.__('Select pdns server which you want to assign this IP pool, entries of RDNS Records of this IP pool IP(s) will be stored in the selected PDNS Server').'"><i class="fas text-primary fa-info-circle"></i></a></label>
				</div>
				<div class="col-sm-4">
					<select name="pdns_id" class="virt-select" id="pdns_id">
					<option value="0">--</option>';
					foreach($pdns_servers as $pk => $pv){
						echo '<option value="'.$pk.'" '.POSTselect('pdns_id', $pk).'>'.$pv['name'].'</option>';
					}
					echo'
					</select>
				</div>
			</div>';
			}
			echo'
			<div class="row mx-auto w-100 my-3 ipv4" id="internal_tr">
				<div class="col-4">
					<label class="control-label">'.__('Is Internal IP Range ?').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('You can assign Internal IPs to VMs for communication within them. Do not check this, if this IP Pool is for Public IPs').'"><i class="fas text-primary fa-info-circle"></i></a></label>
				</div>
				<div class="col-4">
					'.get_checkbox('internal', '', 'internal', array('chk_it' => 1), 1, '', array('onchange="changeipsettings(this.id);"')).'
				</div>
			</div>

			<div class="row mx-auto w-100 my-3" id="internal_bridge_tr" style="display:none;">
				<div class="col-sm-4">
					<label class="control-label">'.__('Internal IP Bridge').'&nbsp;<a class="info" data-placement="right" tooltip="'.htmlizer(__('The bridge that will be used for the internal IP range on the nodes. Please refer to our guide to create a <a target="_blank" href="https://www.virtualizor.com/docs/admin/Internal_Network">Internal Bridge</a>')).'"><i class="fas text-primary fa-info-circle"></i></a></label><br>
					<a target="_blank" href="'.$globals['docs'].'Internal_Network">'.__('Refer This').'</a>
				</div>
				<div class="col-sm-4">
					<input type="text" class="form-control" name="internal_bridge" value="'.POSTval('internal_bridge', '').'" size="30">
				</div>
			</div>

			<div class="row mx-auto w-100 my-3" id="vlan_tr">
				<div class="col-4">
					<label class="control-label">'.__('Enable VLAN').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If checked, vlan networking will be used').'"><i class="fas text-primary fa-info-circle"></i></a></label><br>
					<a href="'.$globals['docs'].'VLAN" target="_blank">'.__('Refer This').'</a>
				</div>
				<div class="col-4">
					'.get_checkbox('vlan', '', 'vlan', array('chk_it' => 1), 1, '', array('onchange="changeipsettings(this.id);"')).'
				</div>
			</div>

			<div class="row mx-auto w-100 my-3" id="vlan_bridge_tr" style="display:none;">
				<div class="col-sm-4">
					<label class="control-label">'.__('VLAN Bridge').'&nbsp;<a class="info" data-placement="right" tooltip="'.htmlizer(__('VLAN bridge has to be configured by the Admin. Please refer to <a href="https://www.virtualizor.com/docs/admin/VLAN" target="_blank">this</a> guide for more information.')).'"><i class="fas text-primary fa-info-circle"></i></a></label>
				</div>
				<div class="col-sm-4">
					<input type="text" class="form-control" name="vlan_bridge" value="'.POSTval('vlan_bridge', '').'" size="30">
				</div>
			</div>

			<div class="row mx-auto w-100 my-3 ipv4">
				<div class="col-sm-4">
					<label class="control-label">'.__('VLAN Tag').'&nbsp;<a class="info" data-placement="right" tooltip="'.htmlizer(__('Specify the vlan tag number (0-4094). <br><b>Only for Proxmox</b>.')).'"><i class="fas text-primary fa-info-circle"></i></a></label>
				</div>
				<div class="col-sm-4">
					<input type="text" class="form-control" name="vlan_tag" value="'.POSTval('vlan_tag', '').'" size="30">
				</div>
			</div>

			<div class="row mx-auto w-100 my-3 ipv4" id="nat_tr" style="display:none;">
				<div class="col-4">
					<label class="control-label">'.__('Enable NAT').'&nbsp;<a class="info" data-placement="right" tooltip="'.htmlizer(__('Enable this only if your data center does not allow bridged networking and you are adding subnet IPs. <br />Please refer to <a target="_blank" href="https://www.virtualizor.com/docs/admin/NAT">this</a> for more info.<br />
<b>Only add the first and last usable IPs above. <br />If enabled no more IPs can be added to this pool.</b>')).'"><i class="fas text-primary fa-info-circle"></i></a></label><br><a target="_blank" href="'.$globals['docs'].'nat/">'.__('Refer This').'</a>
				</div>
				<div class="col-4">
					'.get_checkbox('nat', '', 'nat', array('chk_it' => 1), 1, '', array('onchange="changeipsettings(this.id);"')).'
				</div>
			</div>

			<div class="row mx-auto w-100 mt-3" id="routing_tr" style="display:none;">
				<div class="col-4">
					<label class="control-label">'.__('Use Routed network').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If checked, routed networking will be used').'"><i class="fas text-primary fa-info-circle"></i></a></label>
				</div>
				<div class="col-4">
					'.get_checkbox('routing', '', 'routing', array('chk_it' => 1), 1, '', array('onchange="changeipsettings(this.id);"')).'
				</div>
			</div>

			<div class="row mx-auto w-100 my-1 ipv4" id="or">
				<div class="col-sm-12 h3 m-0" align="center">'.__('OR').'</div>
			</div>

			<div class="row mx-auto w-100 mb-3 ipv4" id="ips">
				<div class="col-sm-4">
					<label class="control-label">Enter IP&nbsp;<a class="info" data-placement="right" tooltip="Enter IP and its associated MAC address<br>'.__('Leave the MAC field blank to auto-generate the MAC.').'"><i class="fas text-primary fa-info-circle"></i></a></label>
				</div>
				<div class="col-sm-8">
					<div id="iptable">';
						
						if(is_array($ips) && !empty($ips)){
							foreach($ips as $k => $ip){
								if(empty($ip['ip'])){
									unset($ip['ip']);
								}
								if(empty($ip['mac_addr'])){
									unset($ip['mac_addr']);
								}
							}
						}
						
						if(empty($ips)){
							$ips = array(NULL);
						}
					
						foreach($ips as $ip){
							echo '
							<div class="row mx-auto w-100 my-3">
								<div class="col-5 ip-mac p-0 ip-mac d-flex align-items-center">
									<label class="p-0">'.__('IP').' :&nbsp;&nbsp;</label><input type="text" class="form-control w-75 m-0" name="ips[]" value="'.$ip['ip'].'"/>
								</div>
								<div class="col-6 ip-mac p-0 ip-mac d-flex align-items-center">
									<label class="p-0">'.__('MAC').' :&nbsp;&nbsp;</label><input type="text" class="form-control w-75 m-0" name="macs[]" value="'.$ip['mac_addr'].'"/>
								</div>
							</div>';
						}
					echo 
					'</div>
					<a onclick="addrow(\'iptable\');" class="go_btn blue_btn px-2 py-1">'.__('+').'</a>
				</div>
			</div>

			<div class="row mx-auto w-100 my-3 ipv6" id="ipv6_subnet_row">
				<div class="col-4">
					<label class="control-label">'.__('Generate Subnets').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If you want to make subnets, you will be redirected after creating the IP Pool').'"><i class="fas text-primary fa-info-circle"></i></a></label>
				</div>
				<div class="col-4">
					'.get_checkbox('ipv6_subnet', '', 'ipv6_subnet', array('chk_it' => 1), 1, 'select_all', array('onchange="ipv6_subnet_gen();"')).'
				</div>	
			</div>

			<div class="row mx-auto w-100 my-3 ipv6" id="ipv6_range">
				<div class="col-sm-4">
					<label class="control-label">'.__('Generate IPv6').'</label>
				</div>
				<div class="col-sm-8">
					<div class="ipv6-range">
						<div> <input type="text" class="form-control" name="ipv6_1" value="'.POSTval('ipv6_1', '').'" size="4" maxlength="4"><label> : </label></div>
						<div> <input type="text" class="form-control" name="ipv6_2" value="'.POSTval('ipv6_2', '').'" size="4" maxlength="4"><label> : </label></div>
			<div> <input type="text" class="form-control" name="ipv6_3" value="'.POSTval('ipv6_3', '').'" size="4" maxlength="4"><label> : </label></div>
			<div> <input type="text" class="form-control" name="ipv6_4" value="'.POSTval('ipv6_4', '').'" size="4" maxlength="4"><label> : </label></div>
			<div> <input type="text" class="form-control" name="ipv6_5" value="'.POSTval('ipv6_5', '').'" size="4" maxlength="4"><label> : </label></div>
			<div> <input type="text" class="form-control" name="ipv6_6" value="'.POSTval('ipv6_6', '').'" size="4" maxlength="4"><label> : </label></div>
			<div> <input type="text" class="form-control" name="ipv6_7" value="'.POSTval('ipv6_7', '').'" size="4" maxlength="4" placeholder="auto"></div>
			<div><label> : auto </label></div>
		</div>
	</div>
	
			</div>
			<span class="help-block"></span>
			<div class="row mx-auto w-100 my-3 ipv6" id="ipv6_num">
				<div class="col-sm-4">
					<label class="control-label">'.__('Number of IPv6').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('The Number of IPv6 addresses to generate.').'"><i class="fas text-primary fa-info-circle"></i></a></label>
				</div>
				<div class="col-sm-4">
					<input type="text" class="form-control" name="ipv6_num" value="'.POSTval('ipv6_num', 50).'" size="10">
				</div>	
			</div>
			<div class="row mx-auto w-100 my-3" id="mtu">
				<div class="col-sm-4">
					<label class="control-label">'.__('MTU').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Specify the Maximum Transmission Unit in bytes').'"><i class="fas text-primary fa-info-circle"></i></a></label>
				</div>
				<div class="col-sm-4">
					<input type="number" class="form-control" name="mtu" value="'.POSTval('mtu').'" size="10">
				</div>	
				<div class="col-sm-4 col-sm-4 d-flex align-items-center">Bytes</div>
			</div>
			<br>
			<center><input type="submit" value="'.__('Add IP Pool').'" class="go_btn" name="addippool"></center>
			<br><br>
		</form>';
}

echo'</div>';
softfooter();

}

?>