<?php

//////////////////////////////////////////////////////////////
//===========================================================
// addinvoice_theme.php
//===========================================================
// SOFTACULOUS VIRTUALIZOR
// Version : 1.0
// Inspired by the DESIRE to be the BEST OF ALL
// ----------------------------------------------------------
// Started by: Alons
// Date:       8th Mar 2010
// Time:       23:00 hrs
// Site:       https://www.virtualizor.com/ (SOFTACULOUS VIRTUALIZOR)
// ----------------------------------------------------------
// Please Read the Terms of use at https://www.virtualizor.com
// ----------------------------------------------------------
//===========================================================
// (c)Softaculous Ltd.
//===========================================================
//////////////////////////////////////////////////////////////

if(!defined('VIRTUALIZOR')){

	die('Hacking Attempt');

}

function addinvoice_theme(){

global $theme, $globals, $kernel, $user, $l, $error, $done, $users, $tax;


if(optREQ('get_tax')){
	
	//show_alert(__('The Invoice has been created. Return to <a href="index.php?act=invoices">Invoices Overview</a>'));
	if(!empty($done)){
		echo json_encode(array('done' => $done));
		return true;
	}
	
	if(!empty($error)){
		echo json_encode(array('error' => $error));
		return true;
	}
	
	if(!empty($tax)){
		echo json_encode(array('tax' => $tax));
		return true;
	}
	
}
softheader($l['<title>']);
					
echo page_header(__('Create Invoice'), 'fas fa-file-invoice', '', 0, 0, '');

$breadcrumbs = ['dashboard', 'lm_invoices', 'lms_addinvoice'];

echo get_breadcrumb($breadcrumbs);

error_handle($error);

if(!empty($done)){
	show_alert(__('The Invoice has been created. Return to <a href="index.php?act=invoices">Invoices Overview</a>'));
}

echo '
<div class="card p-2 mx-3">
<div id="form-container">
<form accept-charset="'.$globals['charset'].'" name="addinvoice" id="addinvoice" method="post" action="" class="form-horizontal">
	<div class="row mx-auto w-100 my-3">
		<div class="col-sm-12 col-md-6 col-lg-6">
			<label class="control-label">'.__('Select User').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Select the user the invoice belongs to').'"><i class="fas text-primary fa-info-circle"></i></a></label><br>
			<select class="custom-select virt-select" name="uid" id="uid" >
			<option value="" '.(POSTval('uid') == "" ? 'selected="selected"' : '').'>'.__('Select User').'</option>';	
			foreach($users as $k => $v){		 
				$parent = !empty($users[$v['pid']]['email']) ? "(".$users[$v['pid']]['email'].")" : "";
				echo '<option value="'.$k.'" '.(POSTval('uid') == $k ? 'selected="selected"' : '').'>'.$v['email'].' '.$parent.'</option>';
			}
	
		echo '</select>
		</div>
		<div class="col-sm-12 col-md-6 col-lg-6">
			<label class="control-label">'.__('Invoice Date').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Effective Invoice Date').'"><i class="fas text-primary fa-info-circle"></i></a></label><br>
			
			<div class="input-group ">
			  <input type="text" class="form-control" placeholder="DD/MM/YYYY" name="invodate" id="invodate" size="30" value="'.POSTval('invodate', '').'"  />
			  <div class="input-group-append">
			  <span class="input-group-text"><a class="text-white" onclick="$_(\'invodate\').value=\''.datify(time(), 0, 1, 'd/m/Y').'\'" tooltip="'.__('Today').'" /><i class="fas fa-calendar-week"></i></a></span>
				
			  </div>
			</div>	
			
			
		</div>
	</div>
	<div class="row mx-auto w-100 my-3">
		<div class="col-sm-12 col-md-6 col-lg-6">
			<label class="control-label">'.__('Due Date').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('The Date on which the invoice becomes due').'"><i class="fas text-primary fa-info-circle"></i></a></label><br><input type="text" class="form-control" placeholder="DD/MM/YYYY" name="duedate" id="duedate" size="30" value="'.POSTval('duedate', '').'"  />
		</div>
		<div class="col-sm-12 col-md-6 col-lg-6">
			<label class="control-label">'.__('Pay Date').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('The date on which the invoice was paid').'"><i class="fas text-primary fa-info-circle"></i></a></label><br><input type="text" class="form-control" placeholder="DD/MM/YYYY" name="paydate" id="paydate" size="30" value="'.POSTval('paydate', '').'"  />
		</div>
	</div>
	<div class="row mx-auto w-100 my-3">
		<div class="col-sm-12 col-md-6 col-lg-6">
			<label class="control-label">'.__('Item').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('The item being invoiced').'"><i class="fas text-primary fa-info-circle"></i></a></label><br><input type="text" class="form-control" name="item" id="item" value="'.POSTval('item', '').'"  />
		</div>
		<div class="col-sm-12 col-md-6 col-lg-6">
			<label class="control-label">'.__('Item Description').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('(Optional) Detailed Description of the item').'"><i class="fas text-primary fa-info-circle"></i></a></label><br><input type="text" class="form-control" name="item_desc" id="item_desc" value="'.POSTval('item_desc', '').'"  />
		</div>
	</div>
	<div class="row mx-auto w-100 my-3">
		<div class="col-sm-12 col-md-6 col-lg-6">
			<label class="control-label">'.__('Amount').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('The Invoice Amount').'"><i class="fas text-primary fa-info-circle"></i></a></label><br><input type="number" class="form-control" name="amt" id="amt" value="'.POSTval('amt', '').'" onchange="calc_net(); apply_tax_func();" />
		</div>
		<div class="col-sm-12 col-md-6 col-lg-6">
			<label class="control-label">'.__('Discount').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('(Optional) This will be deducted from the amount').'"><i class="fas text-primary fa-info-circle"></i></a></label><br><input type="text" class="form-control" name="disc" id="disc" value="'.POSTval('disc', '').'" onchange="calc_net(); apply_tax_func();"  />
		</div>
	</div>	
	<div class="row mx-auto w-100 my-3">
		<div class="col-sm-12 col-md-6 col-lg-6 d-flex gap-2 align-items-center">
			<label class="control-label">'.__('Apply Tax').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('(Optional) If checked, Tax will be applied to an invoice').'"><i class="fas text-primary fa-info-circle"></i></a></label>
			'.get_checkbox('apply_tax', '', 'apply_tax', array('chk_it' => 1), 1, '', array('onchange="apply_tax_func();"')).'
		</div>
		<div class="col-sm-12 col-md-6 col-lg-6">
		</div>
	</div>	
	<div class="row mx-auto w-100 my-3">
		<div class="col-sm-12 col-md-6 col-lg-6">
			<label class="control-label">'.__('Net Amount').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('The total payable amount').'"><i class="fas text-primary fa-info-circle"></i></a></label><br><input type="text" disabled="disabled" class="form-control" name="net" id="net" value="" />
		</div>
		<div class="col-sm-12 col-md-6 col-lg-6">
			<label class="control-label">'.__('Payment Token').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('(Optional) A reference to the payment transaction').'"><i class="fas text-primary fa-info-circle"></i></a></label><br><input type="text" class="form-control" name="token" id="token" value="'.POSTval('token', '').'"  />
		</div>
	</div>
</div>

<div id="tax_info" class="mx-auto" style="display:none;">
	<br><br>
	<h6>'.__('Tax information').'</h6>
	<div class="tax_cal  w-100 my-3"></div>
</div>

<br /><br />
<div class="text-center my-4"><input type="submit" class="go_btn" name="addinvoice" value="'.__('Submit').'"></div>

</form>

<script language="javascript" type="text/javascript">
function calc_net(){
	var amt = parseFloat($_("amt").value);
	var disc = parseFloat($_("disc").value);
	if(amt > 0){
		$_("net").value = amt - (disc > 0 ? disc : 0);
	}
};

calc_net();
function apply_tax_func(){
	calc_net();
	if($("#apply_tax").prop("checked") == false){
		$("#tax_info").hide();
		return;
	}
	
	var uid = $("#uid").val();
	var net = parseFloat($("#net").val());
	var amt = parseFloat($("#amt").val());
	
	if(empty(uid)){
		showalert("'.__J('Please select user to apply tax').'", 1);
		return false;
	}
	if(empty(amt)){
		showalert("'.__J('Please enter amount to calculate tax').'", 1);
		return false;
	}
	
	url = "'.$globals['index'].'act=addinvoice&api=json&ajax=1&apply_tax=1&random="+Math.random();
	var postval = new Object();
	postval["uid"] = uid;
	postval["amt"] = net;
	
	$.ajax({
		type: "POST",
		url: url,
		data: postval,
		complete:function(response){
			//alert(response.responseText)
			response = jQuery.parseJSON(response.responseText);
			if(!empty(response.error)){
				showalert(response.error, 1);
				return false;
			}
			var tax_table = "<table class=\"table table-hover tablesorter \">\
			<th>'.__J('Tax Number').'</th>\
			<th>'.__J('Tax Name').'</th>\
			<th>'.__J('Tax Percentage (value in %)').'</th>\
			<th>'.__J('Tax value').'</th>";
			var i = 1;
			$.each(response.tax.tax, function( index, value ) {
				if(value.name != undefined){
					tax_table += "<tr><td>"+i+"</td><td>"+value.name+"</td><td>"+value.taxrate+"</td><td>"+value.taxamount+"</td></tr>";
					i++;
				}
			});
			tax_table += "<tr><td></td><td></td><td><b>'.__J('Total Net Payable amount').'</b></td><td>"+response.tax.total_payable_amt+"</td></tr>";
			
			$("#tax_info").show();
			$(".tax_cal").html(tax_table);
			$("#net").val(response.tax.total_payable_amt);
			
		}
	});
};
</script>

</div>
</div>
';


softfooter();

}
