<?php

//////////////////////////////////////////////////////////////
//===========================================================
// addbackup_plan_theme.php
//===========================================================
// SOFTACULOUS VIRTUALIZOR
// Version : 2.8.1
// Inspired by the DESIRE to be the BEST OF ALL
// ----------------------------------------------------------
// Started by: Husain
// Date:       11th November 2015
// Time:       16:15 hrs
// Site:       https://www.virtualizor.com/ (SOFTACULOUS VIRTUALIZOR)
// ----------------------------------------------------------
// Please Read the Terms of use at https://www.virtualizor.com
// ----------------------------------------------------------
//===========================================================
// (c)Softaculous Ltd.
//===========================================================
//////////////////////////////////////////////////////////////

if(!defined('VIRTUALIZOR')){

	die('Hacking Attempt');

}

function addbackup_plan_theme(){

global $theme, $globals, $kernel, $user, $l, $error, $cluster, $done, $backupservers, $servers, $servergroups;
	
softheader($l['<title>']);
					
echo page_header(__('Add Backup Plan'), 'fas fa-clipboard', $globals['docs'].'backup-plans/', 0, 0, '');

$breadcrumbs = array( 'dashboard', 'lms_backup_plans', 'lms_addbackup_plan');

echo get_breadcrumb($breadcrumbs);

echo '<div class="notice mx-3 mt-0"><b>'.__('Note').' </b> &nbsp; '.__('Incremental backups are supported on KVM, Virtuozzo machines only, For other kernels we will take full backups! It requires Backuply License on the respective nodes where the VPS exists.').'</div>';

error_handle($error);
if(!empty($done)){
	show_alert(__('The backup plan has been sucessfully saved') ,"0" ,"backup_plans");
	//echo '<div class="notice"><b>'.__('Note').' : </b> &nbsp; '..'</div>';
}

	echo '<script type="text/javascript" charset="utf8" src="'.$theme['url'].'/js/cronstrue.min.js"></script>
	<script language="javascript" type="text/javascript">
	let selected_cron_type = new Object();
	$(document).ready(function(){
		';
		if(!empty($_POST['selected_cron_type'])){
			echo 'selected_cron_type = JSON.parse(\''.htmlspecialchars_decode($_POST['selected_cron_type']).'\');';
		}
		$cron_post = array(
			'always_cronjob',
			'weekly_full_cronjob',
			'weekly_daily_inc_cronjob',
			'monthly_full_cronjob',
			'weekly_diff_cronjob',
			'weekly_diff_daily_inc_cronjob',
			'custom_full_cronjob',
			'custom_diff_cronjob',
			'custom_inc_cronjob',
		);
		foreach($cron_post as $post){
			if(!empty($_POST[$post])){
				echo '$(".'.$post.'").html(convert_to_msg("'.$_POST[$post].'"));';
			}
		}
		echo'
		handle_manual_option();
		handle_backup_scheme();
		$("input:radio").change(function(event){
			$("#months, #dates, #days, #hrs, #mins").trigger("reset");
			$("#converted_cron").text("");
			$(".chosen, #months, #dates, #days").select2({
				"width" : "100%"
			});
			get_cron_msg();
			selected_cron_type[clicked_name] = event.target.value;
			if(!empty(selected_cron_type)){
				$("#selected_cron_type").val(JSON.stringify(selected_cron_type));
			}
			
			if(event.target.value == "weekly"){
				$("#backupday_tr").show();
				$("#backupdate_tr").hide();
				$("#tr_time").show();
				$("#backuphourly_tr").hide();
				$("#backupmonth_tr").hide();
			}else if(event.target.value == "monthly"){
				$("#backupdate_tr").show();
				$("#backupmonth_tr").show();
				$("#backupday_tr").hide();
				$("#tr_time").show();
				$("#backuphourly_tr").hide();
			}else if(event.target.value == "daily"){
				$("#backupdate_tr").hide();
				$("#backupday_tr").hide();
				$("#tr_time").show();
				$("#backuphourly_tr").hide();
				$("#backupmonth_tr").hide();
			}else if(event.target.value == "hourly"){
				$("#backupdate_tr").hide();
				$("#backupday_tr").hide();
				$("#tr_time").hide();
				$("#backuphourly_tr").show();
				$("#backupmonth_tr").hide();
			}else{
				$("#backupdate_tr").hide();
				$("#backupday_tr").hide();
				$("#tr_time").hide();
				$("#backuphourly_tr").hide();
				$("#backupmonth_tr").hide();
			}
		});

		$("#type").change(function(data){
			handle_type()
		});
	});

	function toggle_advoptions(ele){
			
		var div_ele = $("#"+ele+"_advoptions");
		
		if (div_ele.is(":hidden")){
			$("#"+ele+"_advoptions_ind").text(" - ");
			div_ele.slideDown("slow");
		}
		else{
			$("#"+ele+"_advoptions_ind").text(" + ");
			div_ele.slideUp("slow");
		}
	}

	function handle_type(){
		$("#backup_scheme").val(0)
		$("#backup_scheme").trigger("change")
		if($("#type").val() == "LOCAL"){
			$("#tr_backup_servers").hide();
			$(".remote").hide();
			$(".local").show();
		}else{
			$("#bid").val(0);
			$("#tr_backup_servers").show();
			$(".local").hide();
			$(".remote").show();
		}
		handle_manual_option()
	}
	let expression = "";
	selected_cron_type["weekly_full_cronjob"] = "weekly";
	selected_cron_type["monthly_full_cronjob"] = "monthly";
	selected_cron_type["weekly_diff_cronjob"] = "weekly";
	let clicked_name = "";
	let expression_description = "";
	function get_cron_msg(){

		if($("#freqm").prop("checked") == true){

			let months = new Array();
			let dates = new Array();

			if(!empty($("#months").val())){
				if(Object.values($("#months").val()).indexOf("1-12") > -1){
					$("#months").val("").val("1-12").select2({width : "100%"})
					months = "1-12";
				}else{
					months = Object.values($("#months").val()).join(",");
				}
			}

			if(!empty($("#dates").val())){
				if(Object.values($("#dates").val()).indexOf("1-31") > -1){
					$("#dates").val("").val("1-31").select2({width : "100%"})
					dates = "1-31";
				}else{
					dates = Object.values($("#dates").val()).join(",");
				}
			}

			if(empty(months)){
				months = "*";
			}

			if(empty(dates)){
				dates = "*";
			}

			let hrs = $("#hrs").val();
			let mins = $("#min").val();
			expression = mins+" "+hrs+" "+dates+" "+months+" *";

		}
		if($("#freqw").prop("checked") == true){

			let days = "";

			if($("#days").val() != null){
				if(Object.values($("#days").val()).indexOf("1-7") > -1){
					$("#days").val("").val("1-7").select2({width : "100%"})
					days = "1-7";
				}else{
					days = Object.values($("#days").val()).join(",");
				}
			}

			if(days == ""){
				days = "*";
			}

			let hrs = $("#hrs").val();
			let mins = $("#min").val();
			expression = mins+" "+hrs+" * * "+days;
		}
		if($("#freqd").prop("checked") == true){

			let hrs = $("#hrs").val();
			let mins = $("#min").val();
			expression = mins+" "+hrs+" * * *";

		}
		if($("#freqh").prop("checked") == true){
			let hourly_freq = $("#hourly_freq").val();
			expression = "00 */"+hourly_freq+" * * *";
		}

		expression_description = convert_to_msg(expression);
		$("#converted_cron").text(expression_description);

	}

	function convert_to_msg(exp){
		return cronstrue.toString(exp, { throwExceptionOnParseError: false });
	}

	function handle_backup_scheme(){

		if($("#freq").prop("checked")){
			$("#always_cron_div").hide();
			$("#weekly_cron_div").hide();
			$("#weekly_daily_inc_cron_div").hide();
			$("#monthly_full_div").hide();
			$("#weekly_diff_div").hide();
			$("#weekly_diff_daily_inc_div").hide();
			$("#custom_full_div").hide();
			$("#custom_inc_div").hide();
			$("#custom_diff_div").hide();
			return false;
		}

		if($("#backup_scheme").val() == "always_incremental" || $("#backup_scheme").val() == "always_full"){
			$("#always_cron_div").show();
		}else{
			$("#always_cron_div").hide();
		}

		if($("#backup_scheme").val() == "weekly_full_daily_incremental"){
			$("#weekly_cron_div").show();
			$("#weekly_daily_inc_cron_div").show();
		}else{
			$("#weekly_cron_div").hide();
			$("#weekly_daily_inc_cron_div").hide();
		}

		if($("#backup_scheme").val() == "monthly_full_weekly_diff_daily_incremental"){
			$("#monthly_full_div").show();
			$("#weekly_diff_div").show();
			$("#weekly_diff_daily_inc_div").show();
		}else{
			$("#monthly_full_div").hide();
			$("#weekly_diff_div").hide();
			$("#weekly_diff_daily_inc_div").hide();
		}

		if($("#backup_scheme").val() == "custom"){
			$("#custom_full_div").show();
			$("#custom_inc_div").show();
			$("#custom_diff_div").show();
		}else{
			$("#custom_full_div").hide();
			$("#custom_inc_div").hide();
			$("#custom_diff_div").hide();
		}

	}

	function add_cron_job(ele){

		let _ele = ele;
		clicked_name = ele.attr("name");
		let cron_val = "";
		if(!empty(ele.val())){
			cron_val = ele.val().split(" ")
		}
		
		$("#cron_job").trigger("reset");
		$("#converted_cron").text("");
		$(".chosen, #months, #dates, #days").select2({
			"width" : "100%"
		});
		$("#backupdate_tr").hide();
		$("#backupday_tr").hide();
		$("#tr_time").hide();
		$("#backuphourly_tr").hide();
		$("#backupmonth_tr").hide();

		$("#freqm_div, #freqw_div, #freqd_div, #freqh_div").show();
		if(ele.attr("name") == "weekly_daily_inc_cronjob"){
			$("#freqm_div, #freqw_div, #freqh_div").hide();
			$("#freqd").trigger("click");
		}

		if(ele.attr("name") == "weekly_full_cronjob"){
			$("#freqm_div, #freqd_div, #freqh_div").hide();
			$("#freqw").trigger("click");
		}

		if(ele.attr("name") == "monthly_full_cronjob"){
			$("#freqw_div, #freqd_div, #freqh_div").hide();
			$("#freqm").trigger("click");
		}

		if(ele.attr("name") == "weekly_diff_cronjob"){
			$("#freqm_div, #freqd_div, #freqh_div").hide();
			$("#freqw").trigger("click");
		}

		if(ele.attr("name") == "weekly_diff_daily_inc_cronjob"){
			$("#freqw_div, #freqm_div, #freqh_div").hide();
			$("#freqd").trigger("click");
		}

		if(!empty(cron_val) && !empty(selected_cron_type[clicked_name])){

			if(selected_cron_type[clicked_name] == "monthly"){
				$("#freqm").trigger("click");
				$("#months").val(cron_val[3].split(",")).select2({"width" : "100%"});
				$("#dates").val(cron_val[2].split(",")).select2({"width" : "100%"});
				$("#hrs").val(String(cron_val[1]));
				$("#min").val(String(cron_val[0]));
			}else if(selected_cron_type[clicked_name] == "weekly"){
				$("#freqw").trigger("click");
				$("#days").val(cron_val[4].split(",")).select2({"width" : "100%"});
				$("#hrs").val(String(cron_val[1]));
				$("#min").val(String(cron_val[0]));
			}else if(selected_cron_type[clicked_name] == "daily"){
				$("#freqd").trigger("click");
				$("#hrs").val(String(cron_val[1]));
				$("#min").val(String(cron_val[0]));
			}else if(selected_cron_type[clicked_name] == "hourly"){
				$("#freqh").trigger("click");
				var tmp = cron_val[1].split("/");
				$("#hourly_freq").val(tmp[1]);
			}
			get_cron_msg();

		}

		$("#cronModal").modal();
		
		$("#create_cron").unbind().click(function(){
			_ele.val(expression);
			$("."+clicked_name).html(expression_description);
			$("#cronModal").modal("hide");
			handle_backup_scheme()
		});
		
	}
	function trigger_full(){
		$(".local").hide();
		$(".manual").show();
		$("#backup_scheme").val("always_full").trigger("change");
	}
	function handle_manual_option(){
		if($("#freq").prop("checked")){
			trigger_full()
		}else{
			if($("#enable_legacy_backup").prop("checked")){
				trigger_full()
			}else{
				$(".local").show();
				handle_backup_scheme()
			}
			
		}
	}

	function handle_legacy_option(){
		if($("#enable_legacy_backup").prop("checked")){
			trigger_full()
		}else{
			if($("#freq").prop("checked")){
				trigger_full()
			}else{
				$(".local").show();
			}
		}
	}

	function apply_roation_val(op){
		var val = parseInt($("#backup_rotation").val());

		if(op == 1){
			var new_val = val+1;
			if(new_val <= '.(empty($globals['backup_rotation_count']) ? 10 : (int) $globals['backup_rotation_count']).'){
				$("#backup_rotation").val(new_val);
			}
		}else{
			var new_val = val-1;
			if(new_val >= 0){
				$("#backup_rotation").val(new_val);
			}
		}
	}

	function filter_bservers(val){
		$(".bservers").hide();
		$("."+val).show();
	};
	
	</script>

	<!--Modal started -->
	<div class="modal fade" id="cronModal" tabindex="-1" aria-labelledby="cronjob" aria-hidden="true">
		<div class="modal-dialog modal-lg">
			<div class="modal-content">
				<div class="modal-header">
					<h5 class="modal-title" id="cronjob">'.__('Add Cron Job').'</h5>
					<button type="button" class="close text-always-white" data-dismiss="modal">×</button>
				</div>
				<div class="modal-body">
					<span class="h5 m-0 font-italic" id="converted_cron"></span>
					<form id="cron_job">
						<div class="my-3">
							<div class="form-group r-pill">
								<div class="r-pill__group mb-3">
										<span class="r-pill__item" id="freqm_div">
											<input type="radio" class="ssh_options" id="freqm" name="freq" value="monthly" '.POSTradio('freq', 'monthly').'>
											<label for="freq" class="m-0">'.__('Monthly').'</label>
										</span>
										<span class="r-pill__item">
											<input type="radio" class="custom-control-input" id="freqw" name="freq" value="weekly" '.POSTradio('freq', 'weekly').'>
											<label for="freq" class="m-0">'.__('Weekly').'</label>
										</span>
										<span class="r-pill__item">
											<input type="radio" class="custom-control-input" id="freqd" name="freq" value="daily" '.POSTradio('freq', 'daily').'>
											<label for="freq" class="m-0">'.__('Daily').'</label>
										</span>
										<span class="r-pill__item">
											<input type="radio" class="custom-control-input" id="freqh" name="freq" value="hourly" '.POSTradio('freq', 'hourly').'>
											<label for="freq" class="m-0">'.__('Hourly').'</label>
										</span>
								</div>
							</div>
						</div>
						<div class="row mx-auto w-100 my-3" id="backuphourly_tr" style="display:none">
							<div class="col-sm-6">
								<label class="control-label">'.__('Run the backup process every').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('The hourly backup frequency').'"><i class="fas text-primary fa-info-circle"></i></a></label>
							</div>
							<div class="col-sm-6">
								<select class="custom-select w-50" name="hourly_freq" id="hourly_freq" onchange="get_cron_msg()">';
									for($i=0;$i<24;$i++){
										echo '<option value="'.($i < 10 ? '0'.$i : $i).'" '.POSTselect('hourly_freq', $i).' >'.($i < 10 ? '0'.$i : $i).'</option>';
									}
							echo'</select><label class="p-2">'.__('Hours').'</label>
							</div>
						</div>		
						<div class="row mx-auto w-100 my-3" id="backupday_tr" style="display:none;">
							<div class="col-sm-6">
								<label class="control-label">'.__('Backup Day').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Designated day on which the backup will run').'"><i class="fas text-primary fa-info-circle"></i></a></label>
							</div>
							<div class="col-sm-6">
								<select class="custom-select" multiple="multiple" name="day" id="days" onchange="get_cron_msg()">
									<option value="0-6" >'.__('All Days').'</option>
									<option value="0" '.POSTselect('day', "0").' >'.__('Sunday').'</option>
									<option value="1" '.POSTselect('day', "1").' >'.__('Monday').'</option>
									<option value="2" '.POSTselect('day', "2").' >'.__('Tuesday').'</option>
									<option value="3" '.POSTselect('day', "3").' >'.__('Wednesday').'</option>
									<option value="4" '.POSTselect('day', "4").' >'.__('Thursday').'</option>
									<option value="5" '.POSTselect('day', "5").' >'.__('Friday').'</option>
									<option value="6" '.POSTselect('day', "6").' >'.__('Saturday').'</option>
								</select>
							</div>
						</div>
						<div class="row mx-auto w-100 my-3" id="backupmonth_tr" style="display:none;">
							<div class="col-sm-6">
								<label class="control-label">'.__('Backup Month').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Designated day of the month on which the backup will run').'"><i class="fas text-primary fa-info-circle"></i></a></label>
							</div>
							<div class="col-sm-6">
								<select name="months" multiple="multiple" class="custom-select" id="months" onchange="get_cron_msg()">';
								echo '<option value="1-12" >'.__('All Months').'</option>';
								for($i=1;$i<=12;$i++){
									echo '<option value="'.$i.'" '.POSTselect('months', $i).' >'.$i.'</option>';
								}
								
							echo '</select>
							</div>
						</div>
						<div class="row mx-auto w-100 my-3" id="backupdate_tr" style="display:none;">
							<div class="col-sm-6">
								<label class="control-label">'.__('Backup Date').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Designated day of the month on which the backup will run').'"><i class="fas text-primary fa-info-circle"></i></a></label>
							</div>
							<div class="col-sm-6">
								<select name="date" multiple="multiple" class="custom-select" id="dates" onchange="get_cron_msg()">';
								echo '<option value="1-31" >'.__('All Dates').'</option>';
								for($i=1;$i<32;$i++){
									echo '<option value="'.$i.'" '.POSTselect('date', $i).' >'.$i.'</option>';
								}
							echo '</select>
							</div>
						</div>
						<div class="row mx-auto w-100 my-3" id="tr_time" style="display:none;">
							<div class="col-sm-6">
								<label class="control-label">'.__('Time').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('The time at which the backup process will begin').'"><i class="fas text-primary fa-info-circle"></i></a></label>
							</div>
							<div class="col-sm-6">
								<select class="custom-select w-25 p-1 float-left" name="hrs" id="hrs" onchange="get_cron_msg()">';
								for($i=0;$i<24;$i++){
									echo '<option value="'.($i < 10 ? '0'.$i : $i).'" '.POSTselect('hrs', $i).' >'.($i < 10 ? '0'.$i : $i).'</option>';
								}
							echo '</select>
								<label class="side_lbl">'.__('Hours').'</label>
								<select class="custom-select w-25 p-1 float-left" name="min" id="min" onchange="get_cron_msg()">';
									for($i=0;$i<60;$i++){
										echo '<option value="'.($i < 10 ? '0'.$i : $i).'" '.POSTselect('min', $i).' >'.($i < 10 ? '0'.$i : $i).'</option>';
									}
							echo '</select><label class="side_lbl">'.__('Minutes').'</label>
							</div>
						</div>

						<input type="button" value="'.__('Add Cron Job').'" name="create_cron" class="go_btn" id="create_cron" />
					</form>
				</div>
			</div>
		</div>
	</div>
	<!--Modal end -->	

	<div id="form-container" class="m-3">
		<form accept-charset="'.$globals['charset'].'" action="" method="post" name="vpsbackups" class="form-horizontal">
			<div class="roundheader cursor-pointer" onclick="toggle_advoptions(\'general\');"><label id="general_advoptions_ind" class="min_width">-</label> &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;General Settings</div>
				<div id="general_advoptions" class="bgaddv w-100">
					<div class="row mx-auto w-100 my-1">
						<div class="col-sm-12 col-md-12 col-lg-6 border-right">
							<div class="row mx-auto w-100 my-3">
								<div class="col-6">
									<label class="control-label">'.__('Disable').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Disable this backup plan').'"><i class="fas text-primary fa-info-circle"></i></a></label>
								</div>
								<div class="col-6">
									'.get_checkbox('disabled', '', 'disabled').'
								</div>
							</div>
							<div class="row mx-auto w-100 my-3">
								<div class="col-6">
									<label class="control-label">'.__('Disable Suspended VPS').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If checked, backup of suspended VPS will not be taken').'"><i class="fas text-primary fa-info-circle"></i></a></label>
								</div>
								<div class="col-6">
									'.get_checkbox('disable_suspended_vm', '', 'disable_suspended_vm').'
								</div>
							</div>
							<div class="row mx-auto w-100 my-3">
								<div class="col-sm-6">
									<label class="control-label">'.__('Plan Name').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('The name of this plan').'"><i class="fas text-primary fa-info-circle"></i></a></label>
								</div>
								<div class="col-sm-6">
									<input type="text" class="form-control" name="plan_name" id="plan_name" value="'.POSTval('plan_name', '').'" />
								</div>
							</div>
							<div class="row mx-auto w-100 my-3">
								<div class="col-sm-6">
									<label class="control-label">'.__('Backup Type').'</label><br />
								</div>
								<div class="col-sm-6">
									<select id="type" class="custom-select" name="type" id="type" onchange="filter_bservers(this.value);">
										<option value="LOCAL" '.(POSTselect('type', 'LOCAL')).'>Local</option>
										<option value="FTP" '.(POSTselect('type', 'FTP')).'>FTP</option>
										<option value="SSH" '.(POSTselect('type', 'SSH')).'>SSH</option>
										<option value="s3bucket" ' . (POSTselect('type', 's3bucket')) .'>S3</option>'
										// <option value="gdrive" ' . (POSTselect('type', 'gdrive')) . '>GOOGLE DRIVE</option>
										// <option value="onedrive" ' . (POSTselect('type', 'onedrive')) . '>MICROSOFT ONEDRIVE</option>
										// <option value="dropbox" ' . (POSTselect('type', 'dropbox')) . '>DROPBOX</option>';	
									.'</select>
								</div>
							</div>
							<div class="row mx-auto w-100 my-3" id="tr_backup_servers" style="display:none">
								<div class="col-sm-6">
									<label class="control-label">'.__('Backup Server').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('The server on which backups will be saved').'"><i class="fas text-primary fa-info-circle"></i></a></label>
								</div>
							<div class="col-sm-6">
								<select class="custom-select" name="id" id="bid">
								<option value="0" '.(POSTselect('id', '0')).'>---</option>';
								foreach($backupservers as $k => $v){
									echo '<option class="bservers '.$v['type'].'" value="'.$v['bid'].'" '.POSTselect('id', $v['bid']).'>'.$v['name'].'</option>';
								}
							echo '</select>
							</div>
						</div>	
						<div class="row mx-auto w-100 my-3">
							<div class="col-sm-6">
								<label class="control-label">'.__('Enable Manual Backup').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If enabled then backup will not start automatically, but it will follow the same pattern as backup scheme on manual backup').'"><i class="fas text-primary fa-info-circle"></i></a></label>
							</div>
							<div class="col-sm-6">
								'.get_checkbox('freq', '', 'freq', array('chk_it' => 1), 'manual', '', array('onclick="handle_manual_option()"')).'
							</div>
						</div>';
							echo'	
						<div class="row mx-auto w-100 my-3">
							<div class="col-sm-6">
								<label class="control-label">'.__('Enable Legacy Backup').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If enabled then always full backups will be taken using old method and not backuply method. <br> <b>Note: </b>This setting is applicable only for full backups.').'"><i class="fas text-primary fa-info-circle"></i></a></label>
							</div>
							<div class="col-sm-6">
								'.get_checkbox('enable_legacy_backup', '', 'enable_legacy_backup', array('chk_it' => 1), '1', '', array('onclick="handle_legacy_option()"')).'
							</div>
						</div>
						<div class="row mx-auto w-100 my-3">
							<div class="col-sm-6">
								<label class="control-label">'.__('Backup Scheme').'</label>&nbsp;<a class="info" data-placement="right" tooltip="'.__('Choose backup scheme for VPS').'"><i class="fas text-primary fa-info-circle"></i></a>
							</div>
							<div class="col-sm-6">
								<select id="backup_scheme" class="custom-select" name="backup_scheme" onchange="handle_backup_scheme();">
									<option value="0" '.(POSTselect('backup_scheme', '0')).'>---</option>
									<option class="local manual remote" value="always_full" '.(POSTselect('backup_scheme', 'always_full')).'>'.__('Always Full').'</option>	
									<option class="local" value="always_incremental" '.(POSTselect('backup_scheme', 'always_incremental')).'>'.__('Always Incremental').'</option>
									<option class="local remote" value="weekly_full_daily_incremental" '.(POSTselect('backup_scheme', 'weekly_full_daily_incremental')).'>'.__('Weekly Full, Daily Incremental').'</option>
									<option class="local remote" value="monthly_full_weekly_diff_daily_incremental" '.(POSTselect('backup_scheme', 'monthly_full_weekly_diff_daily_incremental')).'>'.__('Monthly Full, Weekly Differential, Daily Incremental').'</option>
									<option class="local remote" value="custom" '.(POSTselect('backup_scheme', 'custom')).'>'.__('Custom').'</option>
								</select>
							</div>
						</div>
						<div class="row mx-auto w-100 my-3" id="always_cron_div" style="display:none;">
							<div class="col-sm-6">
								<label class="control-label">'.__('Backup Frequency').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('How often to run the backup process').'"><i class="fas text-primary fa-info-circle"></i></a></label><br />
							</div>
							<div class="col-sm-6">
								<span class="cursor-pointer always_cronjob" onclick="add_cron_job($(\'#always_cronjob\'))">'.__('Click to set cron').'</span>
								<input type="hidden" class="form-control" id="always_cronjob" value="'.POSTval('always_cronjob', '').'" name="always_cronjob" autocomplete="off"/>
							</div>
						</div>
						<div class="row mx-auto w-100 my-3" id="weekly_cron_div" style="display:none;">
							<div class="col-sm-6">
								<label class="control-label">'.__('Weekly Full Backup Frequency').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('How often to run the backup process').'"><i class="fas text-primary fa-info-circle"></i></a></label><br />
							</div>
							<script>
								$(document).ready(function(){
									$(".weekly_full_cronjob").html(convert_to_msg(\'00 00 * * 1\'))
								})
							</script>
							<div class="col-sm-6">
								<span class="cursor-pointer weekly_full_cronjob" onclick="add_cron_job($(\'#weekly_full_cronjob\'))">'.__('Click to set cron').'</span>
								<input type="hidden" class="form-control" autocomplete="off" id="weekly_full_cronjob" value="'.POSTval('weekly_full_cronjob', '00 00 * * 1').'" name="weekly_full_cronjob" />
							</div>
						</div>
						<div class="row mx-auto w-100 my-3" id="weekly_daily_inc_cron_div" style="display:none;">
							<div class="col-sm-6">
								<label class="control-label">'.__('Daily Incremental Backup Frequency').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('How often to run the backup process').'"><i class="fas text-primary fa-info-circle"></i></a></label><br />
							</div>
							<div class="col-sm-6">
								<span class="cursor-pointer weekly_daily_inc_cronjob" onclick="add_cron_job($(\'#weekly_daily_inc_cronjob\'))">'.__('Click to set cron').'</span>
								<input type="hidden" class="form-control" id="weekly_daily_inc_cronjob" autocomplete="off" value="'.POSTval('weekly_daily_inc_cronjob', '').'" name="weekly_daily_inc_cronjob"/>
							</div>
						</div>

						<div class="row mx-auto w-100 my-3" id="monthly_full_div" style="display:none;">
							<div class="col-sm-6">
								<label class="control-label">'.__('Monthly Full Backup Frequency').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('How often to run the backup process').'"><i class="fas text-primary fa-info-circle"></i></a></label><br />
							</div>
							<script>
								$(document).ready(function(){
									$(".monthly_full_cronjob").html(convert_to_msg(\'00 00 1 * *\'))
								})
							</script>
							<div class="col-sm-6">
								<span class="roundflare text-admin cursor-pointer monthly_full_cronjob" onclick="add_cron_job($(\'#monthly_full_cronjob\'))">'.__('Click to set cron').'</span>
								<input type="hidden" class="form-control" autocomplete="off" id="monthly_full_cronjob" value="'.POSTval('monthly_full_cronjob', '00 00 1 * *').'" name="monthly_full_cronjob" />
							</div>
						</div>
						<div class="row mx-auto w-100 my-3" id="weekly_diff_div" style="display:none;">
							<div class="col-sm-6">
								<label class="control-label">'.__('Weekly Differential Backup Frequency').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('How often to run the backup process').'"><i class="fas text-primary fa-info-circle"></i></a></label><br />
							</div>
							<script>
								$(document).ready(function(){
									$(".weekly_diff_cronjob").html(convert_to_msg(\'00 00 * * 1\'));
								})
							</script>
							<div class="col-sm-6">
								<span class="text-admin roundflare cursor-pointer weekly_diff_cronjob" onclick="add_cron_job($(\'#weekly_diff_cronjob\'))">'.__('Click to set cron').'</span>
								<input type="hidden" class="form-control" autocomplete="off" id="weekly_diff_cronjob" value="'.POSTval('weekly_diff_cronjob', '00 00 * * 1').'" name="weekly_diff_cronjob" />
							</div>
						</div>
						<div class="row mx-auto w-100 my-3" id="weekly_diff_daily_inc_div" style="display:none;">
							<div class="col-sm-6">
								<label class="control-label">'.__('Daily Incremental Backup Frequency').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('How often to run the backup process').'"><i class="fas text-primary fa-info-circle"></i></a></label><br />
							</div>
							<div class="col-sm-6">
								<span class="cursor-pointer weekly_diff_daily_inc_cronjob" onclick="add_cron_job($(\'#weekly_diff_daily_inc_cronjob\'))">'.__('Click to set cron').'</span>
								<input type="hidden" class="form-control" id="weekly_diff_daily_inc_cronjob" autocomplete="off" value="'.POSTval('weekly_diff_daily_inc_cronjob', '').'" name="weekly_diff_daily_inc_cronjob"/>
							</div>
						</div>
						<div class="row mx-auto w-100 my-3" id="custom_full_div" style="display:none;">
							<div class="col-sm-6">
								<label class="control-label">'.__('Custom Full Backup Frequency').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('How often to run the backup process').'"><i class="fas text-primary fa-info-circle"></i></a></label><br />
							</div>
							<div class="col-sm-6">
								<span class="roundflare text-admin cursor-pointer custom_full_cronjob" onclick="add_cron_job($(\'#custom_full_cronjob\'))">'.__('Click to set cron').'</span>
								<input type="hidden" class="form-control" id="custom_full_cronjob" autocomplete="off" value="'.POSTval('custom_full_cronjob', '').'" name="custom_full_cronjob"/>
							</div>
						</div>
						<div class="row mx-auto w-100 my-3" id="custom_diff_div" style="display:none;">
							<div class="col-sm-6">
								<label class="control-label">'.__('Custom Differential Backup Frequency').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('How often to run the backup process').'"><i class="fas text-primary fa-info-circle"></i></a></label><br />
							</div>
							<div class="col-sm-6">
								<span class="roundflare text-admin cursor-pointer custom_diff_cronjob" onclick="add_cron_job($(\'#custom_diff_cronjob\'))">'.__('Click to set cron').'</span>
								<input type="hidden" class="form-control" id="custom_diff_cronjob" autocomplete="off" value="'.POSTval('custom_diff_cronjob', '').'" name="custom_diff_cronjob"/>
							</div>
						</div>
						<div class="row mx-auto w-100 my-3" id="custom_inc_div" style="display:none;">
							<div class="col-sm-6">
								<label class="control-label">'.__('Custom Incremental Backup Frequency').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('How often to run the backup process').'"><i class="fas text-primary fa-info-circle"></i></a></label><br />
							</div>
							<div class="col-sm-6">
								<span class="roundflare text-admin cursor-pointer custom_inc_cronjob" onclick="add_cron_job($(\'#custom_inc_cronjob\'))">'.__('Click to set cron').'</span>
								<input type="hidden" class="form-control" id="custom_inc_cronjob" autocomplete="off" value="'.POSTval('custom_inc_cronjob', '').'" name="custom_inc_cronjob"/>
							</div>
						</div>
						<input type="hidden" name="selected_cron_type" id="selected_cron_type">				
						<div class="row mx-auto w-100 my-3" id="tr_dir">
							<div class="col-sm-6">
								<label class="control-label">'.__('Directory').'&nbsp;<a class="info" data-placement="right" tooltip="'.htmlizer(__('The path of the directory where backups will be stored. Incase of local backups, this path has to be <b>mounted</b> previously on the server. <b>For example</b>: "/Your-Dir"')).'"><i class="fas text-primary fa-info-circle"></i></a></label>
							</div>
							<div class="col-sm-6">
								<input type="text" class="form-control" name="dir" id="dir" value="'.POSTval('dir', '').'" size="40"/>
							</div>
						</div>
						<div class="row mx-auto w-100 my-3">
							<div class="col-sm-6">
								<label class="control-label">'.__('Backup Rotation').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('The number of backups of per VPS allowed').'"><i class="fas text-primary fa-info-circle"></i></a></label>
							</div>
							<div class="col-sm-6">
								<div class="input-group input-group-sm">
									<div class="input-group-prepend">
										<button type="button" class="input-group-text blue_btn cursor-pointer" onclick="apply_roation_val(0)">-</button>
									</div>
									<input type="text" id="backup_rotation" value="'.POSTval('rotation', '0').'" name="rotation" class="form-control" value="0">
									<div class="input-group-append">
										<button type="button" class="input-group-text blue_btn cursor-pointer" onclick="apply_roation_val(1)">+</button>
									</div>
								</div>
							</div>
						</div>
						<div class="row mx-auto w-100 my-3" id="tr_backup_limit">
							<div class="col-sm-6">
								<label class="control-label">'.__('Enduser Backups').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Max number of manual backup operations the VPS user can perform per month').'"><i class="fas text-primary fa-info-circle"></i></a></label>
							</div>
							<div class="col-sm-6">
								<select class="custom-select" name="backup_limit" id="backup_limit">';
								
								echo '<option value="0" '.POSTselect('backup_limit', 0).' >'.__('Disabled').'</option>';
								
								for($i = 1; $i < 11; $i++){
									echo '<option value="'.$i.'" '.POSTselect('backup_limit', $i).' >'.$i.'</option>';
								}
								
								echo '<option value="-1" '.POSTselect('backup_limit', -1).' >'.__('Unlimited').'</option>';
								
							echo '</select>
							</div>
						</div>
					</div>
					<div class="col-sm-12 col-md-12 col-lg-6">
						<!-- <div class="row mx-auto w-100 my-3">
							<div class="col-6">
								<label class="control-label">'.__('Enable Enduser Backup Servers').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Allow the VPS user to select his own backup server to store the backups.<br /><b>NOTE:</b> This setting will be ignored if overriden in master settings').'"><i class="fas text-primary fa-info-circle"></i></a></label>
							</div>
							<div class="col-6">
								'.get_checkbox('enable_enduser_backup_servers', '', 'enable_enduser_backup_servers').'
							</div>
						</div> -->
						<div class="row mx-auto w-100 my-3" id="tr_restore_limit">
							<div class="col-sm-6">
								<label class="control-label">'.__('Enduser Restore').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Max number of restore operations the VPS user can perform per month').'"><i class="fas text-primary fa-info-circle"></i></a></label>
							</div>
							<div class="col-sm-6">
								<select class="custom-select" name="restore_limit" id="restore_limit">';
								
								echo '<option value="0" '.POSTselect('restore_limit', 0).' >'.__('Disabled').'</option>';
								
								for($i = 1; $i < 11; $i++){
									echo '<option value="'.$i.'" '.POSTselect('restore_limit', $i).' >'.$i.'</option>';
								}
								
								echo '<option value="-1" '.POSTselect('restore_limit', -1).' >'.__('Unlimited').'</option>';
								
							echo '</select>
							</div>
						</div>
						<div class="row mx-auto w-100 my-3">
							<div class="col-sm-6">
								<label class="control-label">'.__('Process Priority').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('CPU time the backup process will get. 19 (least favourable) to -20 (most favourable)').'"><i class="fas text-primary fa-info-circle"></i></a></label>
							</div>
							<div class="col-sm-6">
								<select class="custom-select" name="nice" id="nice">';
								for($i=-20; $i<20; $i++){
									echo '<option value="'.$i.'" '.POSTselect('nice', $i).'>'.$i.'</option>';
								}
							echo '</select>
							</div>
						</div>
						<div class="row mx-auto w-100 my-3">
							<div class="col-sm-6">
								<label class="control-label">'.__('Process I/O Priority').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('IO priority for the backup process').'"><i class="fas text-primary fa-info-circle"></i></a></label>
							</div>
							<div class="col-sm-6">
								<select class="custom-select" name="ionice_prio" id="ionice_prio">';
								for($i=0; $i<8; $i++){
									echo '<option value="'.$i.'" '.POSTselect('ionice_prio', $i).'>'.$i.'</option>';
								}
						echo '</select>
							</div>
						</div>
						<div class="row mx-auto w-100 my-3">
							<div class="col-sm-6">
								<label class="control-label">'.__('Process I/O Class').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('IO class for the backup process').'"><i class="fas text-primary fa-info-circle"></i></a></label>
							</div>
							<div class="col-sm-6">
								<select class="custom-select" name="ionice_class" id="ionice_class">
									<option value="1" '.POSTselect('ionice_class', 1).' >Real Time</option>
									<option value="2" '.POSTselect('ionice_class', 2).'>Best Effort</option>
									<option value="3" '.POSTselect('ionice_class', 3).'>Idle</option>
								</select>
							</div>
						</div>
						<div class="row mx-auto w-100 my-3">
							<div class="col-sm-6">
								<label class="control-label">'.__('Process I/O speed limit (in Mbps)').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('The I/O speed limit (in Mbps) for the backup process. Set 0 for unlimited. It will take effect while write IO operation only.').'"><i class="fas text-primary fa-info-circle"></i></a></label>
							</div>
							<div class="col-sm-6">
								<input type="number" class="form-control" name="io_limit" value="'.POSTval('io_limit', '0').'" />
							</div>
						</div>
						<div class="row mx-auto w-100 my-3">
							<div class="col-6">
								<label class="control-label">'.__('Disable Compression').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Disable compression for the backups. This will take effect only for KVM, Xen-HVM and OpenVZ.<br />
For KVM file based VPS this will take effect only for QCOW2 disks.').'"><i class="fas text-primary fa-info-circle"></i></a></label>
							</div>
							<div class="col-6">
								'.get_checkbox('compression', '', 'compression').'
							</div>
						</div>
						<div class="row mx-auto w-100 my-3">
							<div class="col-6">
								<label class="control-label">'.__('Check Directory Permissions on Save').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If checked, the local / remote backup server directory permissions will be checked on saving the backup plan to ensure the backups do not fail').'"><i class="fas text-primary fa-info-circle"></i></a></label>
							</div>
							<div class="col-6">
								'.get_checkbox('check_dir_permissions', '', 'check_dir_permissions', array('chk_it' => 1, 'val' => true)).'
							</div>
						</div>
						<div class="row mx-auto w-100 my-3">
							<div class="col-sm-6">
								<label class="control-label">'.__('Primary Backup').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('If enabled, only primary disk backup will be taken').'"><i class="fas text-primary fa-info-circle"></i></a></label>
							</div>
							<div class="col-6">
								'.get_checkbox('backup_primary', '', 'backup_primary', array('chk_it' => 1)).'
							</div>
						</div>
					</div>
				</div>
			</div>
			<br>
			<div class="roundheader hide_for_plan cursor-pointer" onclick="toggle_advoptions(\'adv\');"><label id="adv_advoptions_ind"  class="min_width">+</label> &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'.__('Advanced Options').'</div>
			<div id="adv_advoptions" class="hide_for_plan bgaddv w-100" style="display:none;">
				<div class="col-sm-12 bgaddv">
					<div class="row mx-auto w-100 my-3">
						<div class="col-sm-12">
							<label class="control-label">'.__('Backup Server per Server / Server Group').'&nbsp;<a class="info" data-placement="right" tooltip="'.__('Assign a different backup server for each Slave Server / Server Group. This setting will override the default backup server specified above.').'"><i class="fas text-primary fa-info-circle"></i></a></label>
						</div>
						<div class="col-sm-12">
							<div class="scrollbar-virt">
								<table class="table table-bordered">
									<tr class="active">
										<th>'.__('Server / Server Group').'</th>
										<th>'.__('Backup Server').'</th>
										<th>'.__('Directory').'</th>
									</tr>';
									
									foreach($servergroups as $sgid => $servergroup) {
										
										echo '<tr>
											<th>[Group] '.$servergroup['sg_name'].'</th>
											<th>
												<select class="virt-select" name="bs_sg'.$sgid.'">
													<option value="0" '.(POSTselect('bs_sg'.$sgid, 0)).'>'.__('Default').'</option>
													<option value="-1" '.(POSTselect('bs_sg'.$sgid, -1)).'>LOCAL</option>
													<optgroup label="SSH">';
												
														foreach($backupservers as $bid => $bs) {
															if($bs['type'] == 'SSH') {
																echo '<option value="'.$bid.'" '.(POSTselect('bs_sg'.$sgid, $bid)).'>'.$bs['name'].'</option>';
															}
														}
											
													echo '
													</optgroup>
													<optgroup label="FTP">';
														foreach($backupservers as $bid => $bs) {
															if($bs['type'] == 'FTP') {
																echo '<option value="'.$bid.'" '.(POSTselect('bs_sg'.$sgid, $bid)).'>'.$bs['name'].'</option>';
															}
														}
													echo '
													</optgroup>';
												// echo '<optgroup label="dropbox">';
												// 	foreach($backupservers as $bid => $bs) {
												// 		if($bs['type'] == 'dropbox') {
												// 			echo '<option value="'.$bid.'" '.(POSTselect('bs_sg'.$sgid, $bid)).'>'.$bs['name'].'</option>';
												// 		}
												// 	}
												// echo '</optgroup>
												// <optgroup label="gdrive">';
												// 	foreach($backupservers as $bid => $bs) {
												// 		if($bs['type'] == 'gdrive') {
												// 			echo '<option value="'.$bid.'" '.(POSTselect('bs_sg'.$sgid, $bid)).'>'.$bs['name'].'</option>';
												// 		}
												// 	}
												// echo '</optgroup>
												// <optgroup label="onedrive">';
												// 	foreach($backupservers as $bid => $bs) {
												// 		if($bs['type'] == 'onedrive') {
												// 			echo '<option value="'.$bid.'" '.(POSTselect('bs_sg'.$sgid, $bid)).'>'.$bs['name'].'</option>';
												// 		}
												// 	}
												// echo '</optgroup>';
												echo '
													<optgroup label="S3">';
														foreach($backupservers as $bid => $bs) {
															if($bs['type'] == 's3bucket') {
																echo '<option value="'.$bid.'" '.(POSTselect('bs_sg'.$sgid, $bid)).'>'.$bs['name'].'</option>';
															}
														}
												echo '
													</optgroup>
												</select>
											</th>
											<th><input type="text" class="form-control" name="dir_sg'.$sgid.'" value="'.POSTval('dir_sg'.$sgid, '').'" placeholder="'.__('Default if empty').'" size="40"/></th>
										</tr>';
										
										foreach($servers as $serid => $server) {
											
											if($server['sgid'] != $sgid) {
												continue;
											}
											
											echo '<tr>
												<td> - '.$server['server_name'].' ('.$server['ip'].')</td>
												<th><select class="virt-select" name="bs_s'.$serid.'">
													<option value="0" '.(POSTselect('bs_s'.$serid, 0)).'>'.__('Default').'</option>
													<option value="-1" '.(POSTselect('bs_s'.$serid, -1)).'>LOCAL</option>
													<optgroup label="SSH">';
													
														foreach($backupservers as $bid => $bs) {
															if($bs['type'] == 'SSH') {
																echo '<option value="'.$bid.'" '.(POSTselect('bs_s'.$serid, $bid)).'>'.$bs['name'].'</option>';
															}
														}
												
													echo '</optgroup>
													<optgroup label="FTP">';
													
														foreach($backupservers as $bid => $bs) {
															if($bs['type'] == 'FTP') {
																echo '<option value="'.$bid.'" '.(POSTselect('bs_s'.$serid, $bid)).'>'.$bs['name'].'</option>';
															}
														}
												
													echo '</optgroup>';

													// 	echo'<optgroup label="dropbox">';
													// 	foreach($backupservers as $bid => $bs) {
													// 		if($bs['type'] == 'dropbox') {
													// 			echo '<option value="'.$bid.'" '.(POSTselect('bs_sg'.$sgid, $bid)).'>'.$bs['name'].'</option>';
													// 		}
													// 	}
													// echo '</optgroup>
													// <optgroup label="gdrive">';
													// 	foreach($backupservers as $bid => $bs) {
													// 		if($bs['type'] == 'gdrive') {
													// 			echo '<option value="'.$bid.'" '.(POSTselect('bs_sg'.$sgid, $bid)).'>'.$bs['name'].'</option>';
													// 		}
													// 	}
													// echo '</optgroup>
													// <optgroup label="onedrive">';
													// 	foreach($backupservers as $bid => $bs) {
													// 		if($bs['type'] == 'onedrive') {
													// 			echo '<option value="'.$bid.'" '.(POSTselect('bs_sg'.$sgid, $bid)).'>'.$bs['name'].'</option>';
													// 		}
													// 	}
													// echo '</optgroup>';
													echo'
													<optgroup label="s3bucket">';
														foreach($backupservers as $bid => $bs) {
															if($bs['type'] == 's3bucket') {
																echo '<option value="'.$bid.'" '.(POSTselect('bs_sg'.$sgid, $bid)).'>'.$bs['name'].'</option>';
															}
														}
													echo '</optgroup>
												</select></th>
												<th><input type="text" class="form-control" name="dir_s'.$serid.'" value="'.POSTval('dir_s'.$serid, '').'"  placeholder="'.__('Default if empty').'" size="40"/></th>
											</tr>';
										}
										
									}
									echo '</table>
							</div>
						</div>
					</div>
				</div>
			</div>
			<br/><br/>
			<center>
				<input type="submit" name="addbackup_plan"  id="addbackup_plan" value="'.__('Submit').'" class="go_btn"/>
			</center>
			<br/><br/>
		</form>
	</div>';

softfooter();

}

?>